package com.example.java;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;

import com.ucalc.lib.uCalc;
import android.widget.*;
import android.graphics.*;
import android.graphics.drawable.*;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        final uCalc uc = new uCalc();

        // uCalc Eval()
        Button btnEval = (Button) findViewById(R.id.btnEval);
        btnEval.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                EditText txtExpression = (EditText) findViewById(R.id.txtExpression);
                TextView tvResult = (TextView) findViewById(R.id.tvResult);
                tvResult.setText(uc.EvalStr(String.valueOf(txtExpression.getText())));
            }
        });

        // uCalc Define()
        Button btnDefine = (Button) findViewById(R.id.btnDefine);
        btnDefine.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                EditText txtDefine = (EditText) findViewById(R.id.txtDefine);
                uc.Define(String.valueOf(txtDefine.getText()));
            }
        });

        // uCalc - Summation - Parse(), Evaluate(), SetVariableValue(), Release()
        Button btnSum = (Button) findViewById(R.id.btnSum);
        btnSum.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                EditText txtSumEq = (EditText) findViewById(R.id.txtSumEq);
                EditText txtSumMax = (EditText) findViewById(R.id.txtSumMax);
                double SumTotal = 0, SumMax = Double.parseDouble(String.valueOf(txtSumMax.getText()));

                uCalc.Item VariableX = uc.DefineVariable("x");
                uCalc.ParsedExpr Expression = uc.Parse(String.valueOf(txtSumEq.getText()));

                for (double x = 1; x <= SumMax; x++) {
                    VariableX.SetVariableValue(x);
                    SumTotal = SumTotal + Expression.Evaluate();
                }

                TextView tvSumResult = (TextView) findViewById(R.id.tvSumResult);
                tvSumResult.setText(String.valueOf(SumTotal));

                Expression.Release();
                VariableX.Release();
            }
        });

        // uCalc - Plotting an equation - Parse(), Evaluate(), SetVariableValue(), Release()
        Button btnPlot = (Button) findViewById(R.id.btnPlot);
        btnPlot.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                EditText txtPlot = (EditText) findViewById(R.id.txtPlot);
                uCalc.Item VariableX = uc.DefineVariable("x");
                uCalc.ParsedExpr Expression = uc.Parse(String.valueOf(txtPlot.getText()));

                Paint paint = new Paint();
                paint.setColor(Color.RED);
                paint.setStrokeWidth(5);
                ImageView imageView = (ImageView) findViewById(R.id.imageView);
                Bitmap bitmap = Bitmap.createBitmap(imageView.getWidth(), imageView.getHeight(), Bitmap.Config.RGB_565);
                imageView.setImageDrawable(new BitmapDrawable(getResources(), bitmap));
                Canvas canvas = new Canvas(bitmap);

                for (double x = -10; x <= 10; x = x + 0.02) {
                    VariableX.SetVariableValue(x);
                    canvas.drawPoint((float) (imageView.getWidth() * (x + 10) / 20), (float) (imageView.getHeight() * (2 - Expression.Evaluate()) / 4), paint);
                }

                Expression.Release();
                VariableX.Release();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
