﻿using System;
using Android.App;
using Android.Widget;
using Android.OS;
using Android.Graphics;
using Android.Graphics.Drawables;

namespace Xamarin
{
    [Activity(Label = "uCalc Xamarin (Visual Studio) Demo", MainLauncher = true, Icon = "@drawable/icon")]
    public class MainActivity : Activity
    {        

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            uCalc uc = new uCalc();

            // uCalc Eval()
            Button btnEval = FindViewById<Button>(Resource.Id.btnEval);
            btnEval.Click += delegate {
                EditText txtExpression = FindViewById<EditText>(Resource.Id.txtExpression);
                TextView tvResult = FindViewById<TextView>(Resource.Id.tvResult);
                tvResult.Text = uc.EvalStr(txtExpression.Text);
            };

            // uCalc Define()
            Button btnDefine = FindViewById<Button>(Resource.Id.btnDefine);
            btnDefine.Click += delegate {
                EditText txtDefine = FindViewById<EditText>(Resource.Id.txtDefine);
                uc.Define(txtDefine.Text);
            };

            // uCalc - Summation - Parse(), Evaluate(), SetVariableValue(), Release()
            Button btnSum = FindViewById<Button>(Resource.Id.btnSum);
            btnSum.Click += delegate {
                EditText txtSumEq = FindViewById<EditText>(Resource.Id.txtSumEq);
                EditText txtSumMax = FindViewById<EditText>(Resource.Id.txtSumMax);
                double SumTotal = 0, SumMax = Convert.ToDouble(txtSumMax.Text);

                var VariableX = uc.DefineVariable("x");
                var Expression = uc.Parse(txtSumEq.Text);

                for (double x = 1; x <= SumMax; x++) {
                    VariableX.SetVariableValue(x);
                    SumTotal = SumTotal + Expression.Evaluate();
                }

                TextView tvSumResult = FindViewById<TextView>(Resource.Id.tvSumResult);
                tvSumResult.Text = SumTotal.ToString();               

                Expression.Release();
                VariableX.Release();
            };

            // uCalc - Plotting an equation - Parse(), Evaluate(), SetVariableValue(), Release()
            Button btnPlot = FindViewById<Button>(Resource.Id.btnPlot);
            btnPlot.Click += delegate
            {
                EditText txtPlot = FindViewById<EditText>(Resource.Id.txtPlot);

                var VariableX = uc.DefineVariable("x");
                var Expression = uc.Parse(txtPlot.Text);

                Paint paint = new Paint();
                paint.Color = Android.Graphics.Color.Red;
                paint.StrokeWidth = 5;
                ImageView imageView = FindViewById<ImageView>(Resource.Id.imageView);
                Bitmap bitmap = Bitmap.CreateBitmap(imageView.Width, imageView.Height, Bitmap.Config.Rgb565);
                imageView.SetImageDrawable(new BitmapDrawable(bitmap));
                Canvas canvas = new Canvas(bitmap);

                for (double x = -10; x <= 10; x = x + 0.02)
                {
                    VariableX.SetVariableValue(x);
                    canvas.DrawPoint((float)(imageView.Width * (x + 10) / 20), (float)(imageView.Height * (2 - Expression.Evaluate()) / 4), paint);
                }

                Expression.Release();
                VariableX.Release();
            };
        }       
    }
}

