
// This file was auto-generated with uCalc Transform 3.0 using uCalcCS.uc on 12/31/18 at 20:42 PM 

using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace uCalcSoftware {
   
   /// <summary> Data types that come with uCalc</summary>
   ///  <remarks>
   /// <para>These are built-in data types that come with uCalc +++ Use scoped public enum w/ class; or insert public enum in class for uCalc::member access</para>
   /// </remarks>
   public enum BuiltInTypesEnum : Int32 {
      Type_Unspecified,
      Type_Auto,
      /// <summary> Boolean</summary>
      Type_Boolean,
      /// <summary> Int8 +++ Rename these to things like Type_Int8</summary>
      Type_Integer_8,
      /// <summary> Byte</summary>
      Type_Integer_8u,
      /// <summary> Int16</summary>
      Type_Integer_16,
      /// <summary> Int16u</summary>
      Type_Integer_16u,
      /// <summary> Int32</summary>
      Type_Integer_32,
      /// <summary> Int32u</summary>
      Type_Integer_32u,
      /// <summary> Int64</summary>
      Type_Integer_64,
      /// <summary> Int64u</summary>
      Type_Integer_64u,
      /// <summary> Int128</summary>
      Type_Integer_128,
      /// <summary> Int128u</summary>
      Type_Integer_128u,
      /// <summary> Single</summary>
      Type_Float_Single,
      /// <summary> Double</summary>
      Type_Float_Double,
      /// <summary> Extended</summary>
      Type_Float_Extended,
      Type_Size_t,
      Type_Complex,
      Type_Decimal,
      Type_BigNum,
      Type_Date,
      Type_String,
      Type_StringView,
      /// <summary> LPCSTR</summary>
      Type_String_LPCSTR,
      /// <summary> FixedStr</summary>
      Type_String_Fixed,
      /// <summary> WideStr</summary>
      Type_String_Wide,
      /// <summary> StackList</summary>
      Type_List_Stack,
      /// <summary> TableList</summary>
      Type_List_Table,
      /// <summary> SortedList</summary>
      Type_List_Sorted,
      Type_Null,
      Type_Void,
      Type_Any,
      Type_Pointer,
      Type_Omni,
      Type_UserDefined,
      Type_DataType,
      Type_Namespace,
      Type_IntPtr,
      Type_ADDR,
      Type_uCalcPtr,
      Type_Item,
      Type_ParsedExpr,
      Type_uCalcCallback,
      Type_Object,
      Type_Intrinsic
   };
   
   /// <summary> Data type constructors</summary>
   public enum DataTypeConstruction : Int32 {
      TypeConstr_ByteSize,
      TypeConstr_AllocArray,
      TypeConstr_AllocScalar,
      TypeConstr_AllocByPtr,
      TypeConstr_ReleaseArray,
      TypeConstr_ReleaseScalar,
      TypeConstr_ResetScalar,
      TypeConstr_ResetArray,
      TypeConstr_SetArrayValue,
      TypeConstr_SetScalarValue,
      TypeConstr_SwapScalarValues
   };
   
   /// <summary> Error hander responses</summary>
   public enum ErrorHandlerResponseEnum : Int32 {
      /// <summary> Immediately stops parsing</summary>
      ErrorAbort,
      /// <summary> Continues parsing (after the error is resolved)</summary>
      ErrorResume,
      /// <summary> Raises the same error again for the next error handler to take care of</summary>
      ErrorReRaise
   };
   
   /// <summary> Error numbers that uCalc may return</summary>
   public enum ErrorNumberEnum : Int32 {
      /// <summary> No error</summary>
      Err_None,
      /// <summary> Inexact result</summary>
      Err_FloatInexact = 1,
      /// <summary> Floating point underflow</summary>
      Err_FloatUnderflow = 2,
      /// <summary> Floating point overflow</summary>
      Err_FloatOverflow = 4,
      /// <summary> Division by 0</summary>
      Err_FloatDivisionByZero = 8,
      /// <summary> Invalid floating point value</summary>
      Err_FloatInvalid = 16,
      /// <summary> Dynamically defined user error</summary>
      Err_Dynamically_Defined,
      /// <summary> Syntax error</summary>
      Err_Syntax_Error,
      /// <summary> Undefined identifier</summary>
      Err_Undefined_Identifier,
      /// <summary> File not found</summary>
      Err_FileNotFound,
      /// <summary> Unrecognized token</summary>
      Err_Unrecognized_Token,
      /// <summary> Unrecognized command</summary>
      Err_Unrecognized_Command,
      /// <summary> Data type mismatch</summary>
      Err_Datatype_Mismatch,
      /// <summary> Invalid number of arguments</summary>
      Err_Invalid_Argument_Count,
      /// <summary> Invalid definition</summary>
      Err_Invalid_Definition,
      /// <summary> Bracket delimiter error</summary>
      Err_Bracket_Error,
      /// <summary> Undefined callback</summary>
      Err_Undefined_Callback,
      /// <summary> Error message already defined</summary>
      Err_ErrorMessageAlreadyDefined,
      /// <summary> This item cannot be modified</summary>
      Err_ItemCannotBeModified,
      /// <summary> Unrecognized class member</summary>
      Err_Unrecognized_Class_Member,
      /// <summary> Unrecognized namespace member</summary>
      Err_Unrecognized_Namespace_Member,
      /// <summary> Unbalanced quote</summary>
      Err_Unbalanced_Quote,
      /// <summary> Value cannot be assigned here</summary>
      Err_ValueCannotBeAssigned,
      /// <summary> Reparsing has passed the specified limit</summary>
      Err_ReParseOverflow,
      /// <summary> Array or list bound exceeded</summary>
      Err_Array_Bounds_Exceeded,
      Err_Customized1 = 100,
      Err_Customized2,
      Err_Customized3,
      Err_Customized4,
      Err_Customized5,
      Err_Customized6,
      Err_Customized7,
      Err_Customized8,
      Err_Customized9,
      Err_Customized10,
      Err_Customized11,
      Err_Customized12,
      Err_Customized13,
      Err_Customized14,
      Err_Customized15,
      Err_Customized16,
      Err_Customized17,
      Err_Customized18,
      Err_Customized19,
      Err_Customized20
   };
   
   /// <summary> Operator grouping associativity</summary>
   public enum GroupingEnum : Int32 {
      GroupLeftToRight,
      GroupRightToLeft
   };
   
   /// <summary> Properties that a uCalc item may have</summary>
   ///  <remarks>
   /// <para>
   /// Items defined with uCalc typically have a combination of properties.  A variable defined
   /// with DefineVariable for instance will have the ItemIsEnum.Variable property set.  An operator
   /// will have the ItemIsEnum.Operator property set.  If it's an infix operator, in addition to
   /// having the ItemIsEnum.Operator property set, ItemIsEnum.Infix will also be set.
   /// property will also be set.</para>
   /// <para>The IsProperty function can determine if a given uCalc.Item has a certain property.</para>
   /// <para>You can use the GetItemOfProperty function to cycle through the list of all items that share
   /// certain properties, or to disambiguate between items that share the same name but have
   /// different roperties (for instance the + operator with the Prefix property vs another one
   /// with the Infix property).</para>
   /// <para>Some members are keywords in VB.NET.  To avoid naming conflict, the following members have been
   /// renamed in the VB.NET header: Function_, Operator_, Optional_, ByVal_, ByRef_, Class_, and NameSpace_.
   /// </para>
   /// </remarks>
   public enum ItemIsEnum : Int32 {
      SelectAny,
      SelectAll,
      RightToLeft_,
      DataType__,
      Array,
      Class,
      Namespace,
      Variable,
      Function,
      Operator,
      FunctionOrOperator,
      Prefix,
      Infix,
      Postfix,
      /// <summary> +++ Use MemoryIndex instead</summary>
      AddressOwner,
      ByVal,
      ByRef,
      ByCopy,
      ByExpr,
      ByHandle,
      IntPtr,
      Optional,
      VariableNumberOfArgs,
      Alias_,
      LiteralItem,
      Locked,
      /// <summary> +++ May need to rename; Purpose of Exclude: cause match to fail if this search item is found</summary>
      Exclude,
      /// <summary> +++ Remove underscore after reorganization</summary>
      Transform_,
      Search,
      /// <summary> +++ Remove this; not used (for now)</summary>
      SubSearch,
      FinishedSearch,
      ReturnSelf,
      ErrorHandler,
      ApiCall,
      CaseSensitive_,
      QuotedText,
      /// <summary> +++ RewindOnModify, RewindOnUpdate, RewindOnAlter, RewindOnRevise, RewindOnRevision, RewindOnRewriteRewindOnEdit, other?</summary>
      RewindOnChange_,
      TransformArg,
      /// <summary> +++ Alternative name: Enabled</summary>
      Active_,
      /// <summary> +++ Maybe rename WhiteSpaceSensitive</summary>
      WhiteSpaceCounts,
      IgnoreQuote,
      IgnoreStatementSep,
      IgnoreBracket,
      SkipEvalTransform,
      ExprUnit,
      EagerArg,
      SkipPatternMatching,
      SkipOver_,
      Modified,
      UpdatePending,
      ParentUpdatePending,
      UpToEndOrSeparator,
      UpToCompleted,
      SkipReduce,
      PatternCheck,
      EvalStrOutput,
      SkipOutput,
      NotFound,
      ListReturned,
      /// <summary> +++ Temp solution</summary>
      DisconnectedParent,
      MiscItem
   };
   
   /// <summary> Licensing options for uCalc products</summary>
   public enum LicenseTypeEnum : Int32 {
      License_Demo,
      License_FMP_Free,
      License_FMP_Standard_32,
      License_FMP_Standard_64,
      License_FMP_32_and_64,
      License_LanguageBuilder,
      License_GeneralParser,
      License_Interpreter,
      License_ConsoleCalc,
      License_WindowsCalc,
      License_StringLib,
      License_Transform,
      License_TransformLib,
      License_Search,
      License_SearchLib,
      License_Library1,
      License_Library2,
      License_Beta,
      License_Debugger,
      License_uCalc_All,
      License_Developer,
      License_EndUser
   };
   
   /// <summary> Types of tokens</summary>
   public enum TokenEnum : Int32 {
      None,
      /// <summary> A token defined without any specified property is generic (default)</summary>
      Generic,
      /// <summary> Represents the absence of any character (token not found)</summary>
      Empty,
      /// <summary> A token that behaves as alphanuric (works with word boundaries)</summary>
      AlphaNumeric,
      /// <summary> A token that serves as argument separator (typically a comma)</summary>
      ArgSeparator,
      /// <summary> A token that starts a bracketed group; typically strings like {, [, or (</summary>
      Bracket,
      /// <summary> The closing token that matches a Bracket token. Ex: }, ], or )</summary>
      BracketMatch_,
      /// <summary> A token that separates an object from its member, typically a . (a dot)</summary>
      MemberAccess,
      /// <summary> A token that represents a literal value, typically a quoted string or number</summary>
      Literal,
      /// <summary> A token that represents a statement separator, typically a ; (semicolon)</summary>
      StatementSep,
      /// <summary> A token that represents whitespace, typically tab or space characters</summary>
      WhiteSpace,
      /// <summary> A token that is not delimited by word boundaries (+, -, *, etc), consecutive characters are reduced until they match a value that exists in the symbol table or until 1 character</summary>
      Reducible,
      /// <summary> Non-character that represents the end of a stream of text</summary>
      Eof,
      CurrentThread,
      LocalVar,
      StaticVar,
      /// <summary> Item in parenthesis (or quotes) following this token will be defined while the expression is parsed</summary>
      DefineNow = StaticVar,
      TempDef,
      /// <summary> The expression in parathesis (or quotes) following the token is evaluated and inserted in place of the token in the string</summary>
      EvalInsert,
      EvalDuringParse,
      /// <summary> Works like EvalInsert, except the expression is transformed instead of evaluated  +++ Is it used?</summary>
      TransformInsert,
      /// <summary> The contents of the quoted file name following this token is inserted into the string</summary>
      FileInclude,
      CurrentSpace,
      DefSpace,
      EvalSpace,
      TokenTransform
   };
   
   /// <summary> RegEx grammar option for defining tokens; based on C++ regex flags</summary>
   public enum RegExGrammarEnum : Int32 {
      /// <summary> Default grammar; ECMAScript is default unless reconfigured with +++</summary>
      RegEx_Default,
      /// <summary> JavaScript-like regex grammar</summary>
      RegEx_ECMAScript,
      /// <summary> Basic POSIX grammar (BRE)</summary>
      RegEx_basic,
      /// <summary> Extended POSIX grammar (ERE)</summary>
      RegEx_extended,
      /// <summary> awk POSIX grammar</summary>
      RegEx_awk,
      /// <summary> grep POSIX grammar</summary>
      RegEx_grep,
      /// <summary> egrep POXIX grammar</summary>
      RegEx_egrep
   };
   
   /// <summary> Transform reset options</summary>
   ///  <remarks>
   /// <para>Use these options with Transform Reset.  The Default is Reset_All</para>
   /// </remarks>
   public enum TransformResetEnum : Int32 {
      /// <summary> Resets all (Input, Tokens, Rules)</summary>
      Reset_All,
      /// <summary> Resets the input to an empty string</summary>
      Reset_Input,
      /// <summary> Resets token definitions</summary>
      Reset_Tokens,
      /// <summary> Resets the FromTo rules</summary>
      Reset_Rules,
      /// <summary> Resets transform results</summary>
      Reset_Results,
      /// <summary> Removes passes</summary>
      Reset_Passes
   };
   
   /// <summary> Options for Transform Pass</summary>
   public enum PassEnum : Int32 {
      /// <summary> Creates a pass with new token definitions that are separate from those of the parent +++ and separate one for transforms</summary>
      Pass_Independent,
      /// <summary> Creates a pass that inherits a separate copy of the token list from the parent</summary>
      Pass_InheritCopy,
      /// <summary> Creates a pass with that shares the same tokens as the parent</summary>
      Pass_InheritShare
   };
   
   /// <summary> Options for transform steps</summary>
   public enum StepsEnum : Int32 {
      Steps_None,
      Steps_All,
      Steps_Passes
   };
   
   /// <summary> Transform Properties</summary>
   public enum TransformPropertiesEnum : Int32 {
      NoTransformProperties,
      /// <summary> Save snapshots of entire text for each change</summary>
      Snapshot_EachChange = 1,
      /// <summary> Save snapshots of entire text for each pass</summary>
      Snapshot_EachPass = 2,
      /// <summary> Save snapshots of each local change</summary>
      Snapshot_LocalChange = 4,
      /// <summary> Save snapshots of local text before each change</summary>
      Archive_LocalOriginals = 5,
      /// <summary> Count number of modifications made by each rule</summary>
      CountChanges = 8
   };
   
   public enum uCalcCompareEnum : Int32 {
      uc_LessThan = -1,
      uc_Equal = 0,
      uc_Greater = 1
   };
   
   public enum ChildStringOptionEnum : Int32 {
      ClearAllOnNewObj,
      ClearOverlapOnRead,
      ClearOverlapOnWrite,
      /// <summary> +++ Split Detach in 2; add to string IntPtr vs add to ucalc IntPtr(/summary) 
      DetachAllOnNewObj,
      DetachOverlapOnRead,
      DetachOverlapOnWrite
   };
   
   public enum uCalcList : Int32 {
      /// <summary> +++ Rethink uCalcList</summary>
      List_None,
      Chars,
      Tokens_,
      Elments,
      Statements,
      Lines,
      Matches
   };
   
   /// <summary> uCalc main class</summary> 
   public class uCalc {
      
#if WIN64
      public const string uCalcDLL = "uCalc64.dll";
#else
      public const string uCalcDLL = "uCalc32.dll";
#endif
      public delegate void uCalcDelegate(IntPtr Expr);
      
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Name_1")]
      protected static extern IntPtr Name_1(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Text_2")]
      protected static extern IntPtr Text_2(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IsProperty_3")]
      protected static extern Int32 IsProperty_3(IntPtr Handle, ItemIsEnum ItemProperty);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IsProperty_4")]
      protected static extern void IsProperty_4(IntPtr Handle, ItemIsEnum ItemProperty , Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NextOverload_5")]
      protected static extern IntPtr NextOverload_5(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Comment_6")]
      protected static extern IntPtr Comment_6(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Comment_7")]
      protected static extern IntPtr Comment_7(IntPtr Handle, string CommentStr, IntPtr CommentStr_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DataType_8")]
      protected static extern IntPtr DataType_8(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DataType_9")]
      protected static extern void DataType_9(IntPtr Handle, IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="uCalc_10")]
      protected static extern IntPtr uCalc_10(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Count_11")]
      protected static extern IntPtr Count_11(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FunctionAddress_12")]
      protected static extern IntPtr FunctionAddress_12(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Precedence_13")]
      protected static extern IntPtr Precedence_13(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Precedence_14")]
      protected static extern void Precedence_14(IntPtr Handle, IntPtr Level);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Rename_15")]
      protected static extern IntPtr Rename_15(IntPtr Handle, string NewName, IntPtr NewName_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Value_16")]
      protected static extern double Value_16(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Value_17")]
      protected static extern void Value_17(IntPtr Handle, double Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Value_18")]
      protected static extern void Value_18(IntPtr Handle, string Value, IntPtr Value_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueBool_19")]
      protected static extern Int32 ValueBool_19(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueBool_20")]
      protected static extern void ValueBool_20(IntPtr Handle, Int32 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueByte_21")]
      protected static extern Byte ValueByte_21(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueByte_22")]
      protected static extern void ValueByte_22(IntPtr Handle, Byte Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt16_23")]
      protected static extern Int16 ValueInt16_23(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt16_24")]
      protected static extern void ValueInt16_24(IntPtr Handle, Int16 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt32_25")]
      protected static extern Int32 ValueInt32_25(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt32_26")]
      protected static extern void ValueInt32_26(IntPtr Handle, Int32 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt64_27")]
      protected static extern Int64 ValueInt64_27(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueInt64_28")]
      protected static extern void ValueInt64_28(IntPtr Handle, Int64 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueSng_29")]
      protected static extern float ValueSng_29(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueSng_30")]
      protected static extern void ValueSng_30(IntPtr Handle, float Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueDbl_31")]
      protected static extern double ValueDbl_31(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueDbl_32")]
      protected static extern void ValueDbl_32(IntPtr Handle, double Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueStr_33")]
      protected static extern IntPtr ValueStr_33(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueStr_34")]
      protected static extern void ValueStr_34(IntPtr Handle, string Value, IntPtr Value_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValuePtr_35")]
      protected static extern IntPtr ValuePtr_35(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValuePtr_36")]
      protected static extern void ValuePtr_36(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueByPtr_37")]
      protected static extern void ValueByPtr_37(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueAddr_38")]
      protected static extern IntPtr ValueAddr_38(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_39")]
      protected static extern IntPtr Handle_39(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_40")]
      protected static extern void Release_40(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Evaluate_41")]
      protected static extern double Evaluate_41(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvaluateDbl_42")]
      protected static extern double EvaluateDbl_42(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvaluateInt32_43")]
      protected static extern Int32 EvaluateInt32_43(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvaluateBool_44")]
      protected static extern Int32 EvaluateBool_44(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvaluateStr_45")]
      protected static extern IntPtr EvaluateStr_45(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvaluateVoid_46")]
      protected static extern IntPtr EvaluateVoid_46(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Execute_47")]
      protected static extern void Execute_47(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DataType_48")]
      protected static extern IntPtr DataType_48(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_49")]
      protected static extern IntPtr Handle_49(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_50")]
      protected static extern void Release_50(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Arg_51")]
      protected static extern double Arg_51(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgDbl_52")]
      protected static extern double ArgDbl_52(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Arg1_53")]
      protected static extern double Arg1_53(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Arg2_54")]
      protected static extern double Arg2_54(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgBool_55")]
      protected static extern Int32 ArgBool_55(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgCount_56")]
      protected static extern IntPtr ArgCount_56(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgObj_57")]
      protected static extern IntPtr ArgObj_57(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgAddr_58")]
      protected static extern IntPtr ArgAddr_58(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgExpr_59")]
      protected static extern IntPtr ArgExpr_59(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgInt32_60")]
      protected static extern Int32 ArgInt32_60(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgInt64_61")]
      protected static extern Int64 ArgInt64_61(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgPtr_62")]
      protected static extern IntPtr ArgPtr_62(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ArgStr_63")]
      protected static extern IntPtr ArgStr_63(IntPtr Handle, out IntPtr ReturnSize, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Return_64")]
      protected static extern void Return_64(IntPtr Handle, double Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnDbl_65")]
      protected static extern void ReturnDbl_65(IntPtr Handle, double Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnBool_66")]
      protected static extern void ReturnBool_66(IntPtr Handle, Int32 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnInt32_67")]
      protected static extern void ReturnInt32_67(IntPtr Handle, Int32 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnInt64_68")]
      protected static extern void ReturnInt64_68(IntPtr Handle, Int64 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnPtr_69")]
      protected static extern void ReturnPtr_69(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReturnStr_70")]
      protected static extern void ReturnStr_70(IntPtr Handle, string Value, IntPtr Value_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorSet_71")]
      protected static extern void ErrorSet_71(IntPtr Handle, ErrorNumberEnum ErrNumber);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorRaise_72")]
      protected static extern ErrorHandlerResponseEnum ErrorRaise_72(IntPtr Handle, ErrorNumberEnum ErrNumber);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorRaiseMessage_73")]
      protected static extern ErrorHandlerResponseEnum ErrorRaiseMessage_73(IntPtr Handle, string ErrMessage, IntPtr ErrMessage_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="uCalc_74")]
      protected static extern IntPtr uCalc_74(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Item_75")]
      protected static extern IntPtr Item_75(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_76")]
      protected static extern IntPtr Handle_76(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_77")]
      protected static extern void Release_77(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ByteSize_78")]
      protected static extern IntPtr ByteSize_78(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Index_79")]
      protected static extern BuiltInTypesEnum Index_79(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Item_80")]
      protected static extern IntPtr Item_80(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Name_81")]
      protected static extern IntPtr Name_81(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Reset_82")]
      protected static extern void Reset_82(IntPtr Handle, IntPtr ValuePtr , IntPtr Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Reset_83")]
      protected static extern void Reset_83(IntPtr Handle, IntPtr ValuePtr);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SetArray_84")]
      protected static extern void SetArray_84(IntPtr Handle, IntPtr Destination , IntPtr Source , IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SetScalar_85")]
      protected static extern void SetScalar_85(IntPtr Handle, IntPtr Destination , IntPtr Source);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SwapScalarValues_86")]
      protected static extern void SwapScalarValues_86(IntPtr Handle, IntPtr ValuePtrA , IntPtr ValuePtrB);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToString_87")]
      protected static extern IntPtr ToString_87(IntPtr Handle, out IntPtr ReturnSize, IntPtr ValuePtr);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToString_88")]
      protected static extern IntPtr ToString_88(IntPtr Handle, out IntPtr ReturnSize, string Value, IntPtr Value_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_89")]
      protected static extern IntPtr Handle_89(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_90")]
      protected static extern void Release_90(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineRule_91")]
      protected static extern IntPtr DefineRule_91(IntPtr Handle, string Comment, IntPtr Comment_Size , string FindStr, IntPtr FindStr_Size , string ToStr, IntPtr ToStr_Size , IntPtr Min , IntPtr Max , IntPtr MinHard , IntPtr MaxHard , IntPtr Precedence , IntPtr StartAfter , IntPtr StopAfter , Int32 SkipOver , Int32 RewindOnChange , Int32 CaseSensitive , Int32 BracketSensitive , Int32 QuoteSensitive , Int32 RightToLeft);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineToken_92")]
      protected static extern IntPtr DefineToken_92(IntPtr Handle, string TokenDef, IntPtr TokenDef_Size , TokenEnum TokenType, string CloseBracket, IntPtr CloseBracket_Size, IntPtr SubMatch, RegExGrammarEnum RegExGrammar);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RemoveToken_93")]
      protected static extern void RemoveToken_93(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Tokens_94")]
      protected static extern IntPtr Tokens_94(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FromTo_95")]
      protected static extern IntPtr FromTo_95(IntPtr Handle, string FromStr, IntPtr FromStr_Size , string ToStr, IntPtr ToStr_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="uCalc_96")]
      protected static extern IntPtr uCalc_96(IntPtr Handle, IntPtr uCalcHandle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NewPass_97")]
      protected static extern IntPtr NewPass_97(IntPtr Handle, Int32 Share);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Pass_98")]
      protected static extern IntPtr Pass_98(IntPtr Handle, IntPtr Index , Int32 Share);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Reset_99")]
      protected static extern IntPtr Reset_99(IntPtr Handle, TransformResetEnum ResetOption);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Transform_100")]
      protected static extern IntPtr Transform_100(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Transform_101")]
      protected static extern IntPtr Transform_101(IntPtr Handle, out IntPtr ReturnSize, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TransformWithSteps_102")]
      protected static extern IntPtr TransformWithSteps_102(IntPtr Handle, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Str_103")]
      protected static extern IntPtr Str_103(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Str_104")]
      protected static extern IntPtr Str_104(IntPtr Handle, string InputStr, IntPtr InputStr_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StrData_105")]
      protected static extern string StrData_105(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StrLength_106")]
      protected static extern IntPtr StrLength_106(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IndexBase_107")]
      protected static extern IntPtr IndexBase_107(IntPtr Handle, IntPtr BaseValue);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IndexBase_108")]
      protected static extern IntPtr IndexBase_108(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="WasModified_109")]
      protected static extern Int32 WasModified_109(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RulesDefault_110")]
      protected static extern IntPtr RulesDefault_110(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RulesOverall_111")]
      protected static extern IntPtr RulesOverall_111(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Rule_112")]
      protected static extern IntPtr Rule_112(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_113")]
      protected static extern IntPtr Handle_113(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_114")]
      protected static extern void Release_114(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Active_115")]
      protected static extern IntPtr Active_115(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FindPart_116")]
      protected static extern IntPtr FindPart_116(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FindPart_117")]
      protected static extern IntPtr FindPart_117(IntPtr Handle, string Pattern, IntPtr Pattern_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FromPart_118")]
      protected static extern IntPtr FromPart_118(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FromPart_119")]
      protected static extern IntPtr FromPart_119(IntPtr Handle, string Pattern, IntPtr Pattern_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToPart_120")]
      protected static extern IntPtr ToPart_120(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToPart_121")]
      protected static extern IntPtr ToPart_121(IntPtr Handle, string Pattern, IntPtr Pattern_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="CaseSensitive_122")]
      protected static extern IntPtr CaseSensitive_122(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IgnoreInnerPatterns_123")]
      protected static extern IntPtr IgnoreInnerPatterns_123(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="WhitespaceSensitive_124")]
      protected static extern IntPtr WhitespaceSensitive_124(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="BracketSensitive_125")]
      protected static extern IntPtr BracketSensitive_125(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="LocalTransform_126")]
      protected static extern IntPtr LocalTransform_126(IntPtr Handle, IntPtr t);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Maximum_127")]
      protected static extern IntPtr Maximum_127(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Maximum_128")]
      protected static extern IntPtr Maximum_128(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MaximumHard_129")]
      protected static extern IntPtr MaximumHard_129(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MaximumHard_130")]
      protected static extern IntPtr MaximumHard_130(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Minimum_131")]
      protected static extern IntPtr Minimum_131(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Minimum_132")]
      protected static extern IntPtr Minimum_132(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MinimumHard_133")]
      protected static extern IntPtr MinimumHard_133(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MinimumHard_134")]
      protected static extern IntPtr MinimumHard_134(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Precedence_135")]
      protected static extern IntPtr Precedence_135(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Precedence_136")]
      protected static extern IntPtr Precedence_136(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Property_137")]
      protected static extern IntPtr Property_137(IntPtr Handle, ItemIsEnum SelectedProperty , Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="QuoteSensitive_138")]
      protected static extern IntPtr QuoteSensitive_138(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReplacementText_139")]
      protected static extern IntPtr ReplacementText_139(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StartAfter_140")]
      protected static extern IntPtr StartAfter_140(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StartAfter_141")]
      protected static extern IntPtr StartAfter_141(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StopAfter_142")]
      protected static extern IntPtr StopAfter_142(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StopAfter_143")]
      protected static extern IntPtr StopAfter_143(IntPtr Handle, IntPtr Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SkipOver_144")]
      protected static extern IntPtr SkipOver_144(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RewindOnChange_145")]
      protected static extern IntPtr RewindOnChange_145(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RightToLeft_146")]
      protected static extern IntPtr RightToLeft_146(IntPtr Handle, Int32 TrueFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_147")]
      protected static extern IntPtr Handle_147(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_148")]
      protected static extern void Release_148(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Import_149")]
      protected static extern IntPtr Import_149(IntPtr Handle, IntPtr FromTokenList);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Define_150")]
      protected static extern IntPtr Define_150(IntPtr Handle, string TokenDef, IntPtr TokenDef_Size , TokenEnum TokenType, string CloseBracket, IntPtr CloseBracket_Size, IntPtr SubMatch, RegExGrammarEnum RegExGrammar);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_151")]
      protected static extern IntPtr Handle_151(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_152")]
      protected static extern void Release_152(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenCharLen_153")]
      protected static extern IntPtr TokenCharLen_153(IntPtr Handle, IntPtr StartIndex , IntPtr Count);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenCount_154")]
      protected static extern IntPtr TokenCount_154(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenType_155")]
      protected static extern TokenEnum TokenType_155(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Compare_156")]
      protected static extern uCalcCompareEnum Compare_156(IntPtr Handle, string OtherString, IntPtr OtherString_Size , IntPtr IndexA, IntPtr IndexB, IntPtr Length);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenIndexAtChar_157")]
      protected static extern IntPtr TokenIndexAtChar_157(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Apply_158")]
      protected static extern IntPtr Apply_158(IntPtr Handle, string expression, IntPtr expression_Size , string Variable, IntPtr Variable_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="At_159")]
      protected static extern IntPtr At_159(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="AtChar_160")]
      protected static extern IntPtr AtChar_160(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="AtToken_161")]
      protected static extern IntPtr AtToken_161(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="BracketMatch_162")]
      protected static extern IntPtr BracketMatch_162(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="BracketedText_163")]
      protected static extern IntPtr BracketedText_163(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="BracketedTextInside_164")]
      protected static extern IntPtr BracketedTextInside_164(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="BracketMatchTokenIndex_165")]
      protected static extern IntPtr BracketMatchTokenIndex_165(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="CharPos_166")]
      protected static extern IntPtr CharPos_166(IntPtr Handle, IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="CharCount_167")]
      protected static extern IntPtr CharCount_167(IntPtr Handle, IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenPos_168")]
      protected static extern IntPtr TokenPos_168(IntPtr Handle, IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="TokenCharPos_169")]
      protected static extern IntPtr TokenCharPos_169(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Str_170")]
      protected static extern IntPtr Str_170(IntPtr Handle, out IntPtr ReturnSize, IntPtr Nth, IntPtr TokenCount);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Str_171")]
      protected static extern IntPtr Str_171(IntPtr Handle, string StringValue, IntPtr StringValue_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Find_172")]
      protected static extern IntPtr Find_172(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FindOtherThan_173")]
      protected static extern IntPtr FindOtherThan_173(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Parent_174")]
      protected static extern IntPtr Parent_174(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Root_175")]
      protected static extern IntPtr Root_175(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IndexBase_176")]
      protected static extern IntPtr IndexBase_176(IntPtr Handle, IntPtr BaseValue);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IndexBase_177")]
      protected static extern IntPtr IndexBase_177(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="UpTo_178")]
      protected static extern IntPtr UpTo_178(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StartingFrom_179")]
      protected static extern IntPtr StartingFrom_179(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="StartingFromEndingWith_180")]
      protected static extern IntPtr StartingFromEndingWith_180(IntPtr Handle, string StartPattern, IntPtr StartPattern_Size , string EndPattern, IntPtr EndPattern_Size , IntPtr StartNth, IntPtr EndNth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Before_181")]
      protected static extern IntPtr Before_181(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="After_182")]
      protected static extern IntPtr After_182(IntPtr Handle, string Pattern, IntPtr Pattern_Size , IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Between_183")]
      protected static extern IntPtr Between_183(IntPtr Handle, string StartPattern, IntPtr StartPattern_Size , string StopPattern, IntPtr StopPattern_Size , IntPtr StartNth, IntPtr StopNth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListOfTokens_184")]
      protected static extern IntPtr ListOfTokens_184(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListOfChars_185")]
      protected static extern IntPtr ListOfChars_185(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SubString_186")]
      protected static extern IntPtr SubString_186(IntPtr Handle, IntPtr StartPos , IntPtr Length);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ChildStringOption_187")]
      protected static extern IntPtr ChildStringOption_187(IntPtr Handle, ChildStringOptionEnum Option);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ChildStringOption_188")]
      protected static extern ChildStringOptionEnum ChildStringOption_188(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ClearDerivedStrings_189")]
      protected static extern IntPtr ClearDerivedStrings_189(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Remove_190")]
      protected static extern IntPtr Remove_190(IntPtr Handle, string From_, IntPtr From__Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Replace_191")]
      protected static extern IntPtr Replace_191(IntPtr Handle, string From_, IntPtr From__Size , string To_, IntPtr To__Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Skip_192")]
      protected static extern IntPtr Skip_192(IntPtr Handle, string Pattern, IntPtr Pattern_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToUpper_193")]
      protected static extern IntPtr ToUpper_193(IntPtr Handle, string Pattern, IntPtr Pattern_Size, IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ToLower_194")]
      protected static extern IntPtr ToLower_194(IntPtr Handle, string Pattern, IntPtr Pattern_Size, IntPtr Nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="List_195")]
      protected static extern IntPtr List_195(IntPtr Handle, uCalcList ListType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListFormat_196")]
      protected static extern IntPtr ListFormat_196(IntPtr Handle, string Separator, IntPtr Separator_Size , string Prefix, IntPtr Prefix_Size, string Postfix, IntPtr Postfix_Size, string UserFunc, IntPtr UserFunc_Size, string Element, IntPtr Element_Size, string Index, IntPtr Index_Size, string Count, IntPtr Count_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListSeparator_197")]
      protected static extern IntPtr ListSeparator_197(IntPtr Handle, string Separator, IntPtr Separator_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListPrefix_198")]
      protected static extern IntPtr ListPrefix_198(IntPtr Handle, string Prefix, IntPtr Prefix_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListPostfix_199")]
      protected static extern IntPtr ListPostfix_199(IntPtr Handle, string Postfix, IntPtr Postfix_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ListFunction_200")]
      protected static extern IntPtr ListFunction_200(IntPtr Handle, string UserFunc, IntPtr UserFunc_Size , string Element, IntPtr Element_Size, string Index, IntPtr Index_Size, string MatchCount, IntPtr MatchCount_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Populate_201")]
      protected static extern IntPtr Populate_201(IntPtr Handle, double first , double last , string expression, IntPtr expression_Size , double Step, string Condition, IntPtr Condition_Size, string VarIndex, IntPtr VarIndex_Size, string VarFirst, IntPtr VarFirst_Size, string VarLast, IntPtr VarLast_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Match_202")]
      protected static extern IntPtr Match_202(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MatchIndexAtChar_203")]
      protected static extern IntPtr MatchIndexAtChar_203(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MatchIndexAtToken_204")]
      protected static extern IntPtr MatchIndexAtToken_204(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NonMatches_205")]
      protected static extern IntPtr NonMatches_205(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="SubMatch_206")]
      protected static extern IntPtr SubMatch_206(IntPtr Handle, IntPtr Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="MatchCount_207")]
      protected static extern IntPtr MatchCount_207(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Transform_208")]
      protected static extern IntPtr Transform_208(IntPtr Handle, IntPtr tt);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_209")]
      protected static extern IntPtr Handle_209(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_210")]
      protected static extern void Release_210(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="AddErrorHandler_211")]
      protected static extern IntPtr AddErrorHandler_211(IntPtr Handle, uCalcDelegate ErrorHandlerAddress , IntPtr Position);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Create_212")]
      protected static extern IntPtr Create_212(IntPtr Handle, IntPtr BasedOn);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="CreateTempDefault_213")]
      protected static extern IntPtr CreateTempDefault_213(IntPtr Handle, IntPtr BasedOn);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ReleaseTempDefault_214")]
      protected static extern IntPtr ReleaseTempDefault_214(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Alias_215")]
      protected static extern IntPtr Alias_215(IntPtr Handle, string NewSymbol, IntPtr NewSymbol_Size , string ExistingSymbol, IntPtr ExistingSymbol_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Alias_216")]
      protected static extern IntPtr Alias_216(IntPtr Handle, string NewSymbol, IntPtr NewSymbol_Size , IntPtr ExistingItem);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="AliasForDefine_217")]
      protected static extern void AliasForDefine_217(IntPtr Handle, string NewCommandName, IntPtr NewCommandName_Size , string ExistingCommandName, IntPtr ExistingCommandName_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DataTypeOf_218")]
      protected static extern IntPtr DataTypeOf_218(IntPtr Handle, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DataTypeOf_219")]
      protected static extern IntPtr DataTypeOf_219(IntPtr Handle, BuiltInTypesEnum Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Define_220")]
      protected static extern IntPtr Define_220(IntPtr Handle, string expression, IntPtr expression_Size , IntPtr Address, IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineConstant_221")]
      protected static extern IntPtr DefineConstant_221(IntPtr Handle, string Definition, IntPtr Definition_Size , IntPtr VariableAddress);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineFunction_222")]
      protected static extern IntPtr DefineFunction_222(IntPtr Handle, string Definition, IntPtr Definition_Size , uCalcDelegate FunctionAddr);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineOperator_223")]
      protected static extern IntPtr DefineOperator_223(IntPtr Handle, string Definition, IntPtr Definition_Size , IntPtr iPrecedence , GroupingEnum Grouping, uCalcDelegate FunctionAddr);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefineVariable_224")]
      protected static extern IntPtr DefineVariable_224(IntPtr Handle, string Definition, IntPtr Definition_Size , IntPtr VariableAddress);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorExpression_225")]
      protected static extern IntPtr ErrorExpression_225(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorExpression_226")]
      protected static extern void ErrorExpression_226(IntPtr Handle, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorLocation_227")]
      protected static extern IntPtr ErrorLocation_227(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorMessage_228")]
      protected static extern IntPtr ErrorMessage_228(IntPtr Handle, out IntPtr ReturnSize, ErrorNumberEnum Index);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorNumber_229")]
      protected static extern ErrorNumberEnum ErrorNumber_229(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorResponse_230")]
      protected static extern void ErrorResponse_230(IntPtr Handle, ErrorHandlerResponseEnum Response);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ErrorSymbol_231")]
      protected static extern IntPtr ErrorSymbol_231(IntPtr Handle, out IntPtr ReturnSize);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Eval_232")]
      protected static extern double Eval_232(IntPtr Handle, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="EvalStr_233")]
      protected static extern IntPtr EvalStr_233(IntPtr Handle, out IntPtr ReturnSize, string expression, IntPtr expression_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RaiseErrorOnDivideByZero_234")]
      protected static extern void RaiseErrorOnDivideByZero_234(IntPtr Handle, Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RaiseErrorOnInexact_235")]
      protected static extern void RaiseErrorOnInexact_235(IntPtr Handle, Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RaiseErrorOnUnderflow_236")]
      protected static extern void RaiseErrorOnUnderflow_236(IntPtr Handle, Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RaiseErrorOnOverflow_237")]
      protected static extern void RaiseErrorOnOverflow_237(IntPtr Handle, Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="RaiseErrorOnInvalid_238")]
      protected static extern void RaiseErrorOnInvalid_238(IntPtr Handle, Int32 TrueOrFalse);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FloatingPointErrorsToCatch_239")]
      protected static extern Int32 FloatingPointErrorsToCatch_239(IntPtr Handle, Int32 Value);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ItemOf_240")]
      protected static extern IntPtr ItemOf_240(IntPtr Handle, string ItemName, IntPtr ItemName_Size , Int64 Properties);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ItemOf_241")]
      protected static extern IntPtr ItemOf_241(IntPtr Handle, ItemIsEnum Property_ , IntPtr nth , string DataTypeName, IntPtr DataTypeName_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NamespaceChild_242")]
      protected static extern IntPtr NamespaceChild_242(IntPtr Handle, IntPtr nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NamespaceChildCount_243")]
      protected static extern IntPtr NamespaceChildCount_243(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NamespaceParent_244")]
      protected static extern IntPtr NamespaceParent_244(IntPtr Handle, IntPtr Level);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NamespaceSymbol_245")]
      protected static extern IntPtr NamespaceSymbol_245(IntPtr Handle, IntPtr nth);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NamespaceSymbolCount_246")]
      protected static extern IntPtr NamespaceSymbolCount_246(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NewString_247")]
      protected static extern IntPtr NewString_247(IntPtr Handle, string InitialString, IntPtr InitialString_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="NewTransform_248")]
      protected static extern IntPtr NewTransform_248(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ExpressionTransforms_249")]
      protected static extern IntPtr ExpressionTransforms_249(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Parse_250")]
      protected static extern IntPtr Parse_250(IntPtr Handle, string expression, IntPtr expression_Size , IntPtr DataType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Parse_251")]
      protected static extern IntPtr Parse_251(IntPtr Handle, string expression, IntPtr expression_Size , string DataType, IntPtr DataType_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Parse_252")]
      protected static extern IntPtr Parse_252(IntPtr Handle, string expression, IntPtr expression_Size , BuiltInTypesEnum DataTypeIndex);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Precedence_253")]
      protected static extern IntPtr Precedence_253(IntPtr Handle, string Operator1, IntPtr Operator1_Size , string Operator2, IntPtr Operator2_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Properties_254")]
      protected static extern Int64 Properties_254(IntPtr Handle, ItemIsEnum p1 , ItemIsEnum p2, ItemIsEnum p3, ItemIsEnum p4);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefaultItem_255")]
      protected static extern IntPtr DefaultItem_255(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefaultDataType_256")]
      protected static extern IntPtr DefaultDataType_256(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefaultDataType_257")]
      protected static extern void DefaultDataType_257(IntPtr Handle, IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefaultDataType_258")]
      protected static extern void DefaultDataType_258(IntPtr Handle, BuiltInTypesEnum DataTypeIndex);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="DefaultDataType_259")]
      protected static extern void DefaultDataType_259(IntPtr Handle, string dTypeStr, IntPtr dTypeStr_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IsDefault_260")]
      protected static extern Int32 IsDefault_260(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="IsDefault_261")]
      protected static extern void IsDefault_261(IntPtr Handle, Int32 Condition);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Default_262")]
      protected static extern IntPtr Default_262(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Default_263")]
      protected static extern void Default_263(IntPtr Handle, IntPtr uCalcObj);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Format_264")]
      protected static extern IntPtr Format_264(IntPtr Handle, uCalcDelegate FunctionAddr , string Properties, IntPtr Properties_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Format_265")]
      protected static extern IntPtr Format_265(IntPtr Handle, uCalcDelegate FunctionAddr , IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Format_266")]
      protected static extern IntPtr Format_266(IntPtr Handle, string Definition, IntPtr Definition_Size , IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="FormatRemove_267")]
      protected static extern void FormatRemove_267(IntPtr Handle, IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueAt_268")]
      protected static extern IntPtr ValueAt_268(IntPtr Handle, out IntPtr ReturnSize, IntPtr ValuePtr , IntPtr dType);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="ValueAt_269")]
      protected static extern IntPtr ValueAt_269(IntPtr Handle, out IntPtr ReturnSize, IntPtr ValuePtr , string ValueDataType, IntPtr ValueDataType_Size);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="License_270")]
      protected static extern void License_270(IntPtr Handle, LicenseTypeEnum LicenseType , IntPtr L1, IntPtr L2, IntPtr L3, IntPtr L4, IntPtr L5);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Handle_271")]
      protected static extern IntPtr Handle_271(IntPtr Handle);
      [DllImport(uCalcDLL, CharSet=CharSet.Ansi, CallingConvention=CallingConvention.StdCall, EntryPoint="Release_272")]
      protected static extern void Release_272(IntPtr Handle);
      
      public class Base {
         /// <summary> Handle for Base Class</summary> 
         public IntPtr hb;
         
         /// <summary> Returns the name of the uCalc Item</summary> 
         /// <remarks>
         /// <para>Items such as functions, operators, variables, etc generally are given a name when they are defined.
         ///          That name can be retried with this function.</para>
         /// </remarks> 
         public string Name() {
            IntPtr ReturnStrSize;
            var ReturnStr = Name_1(hb, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Returns the text data associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Certain items may have a text property that can be retrieved with a call to this function.  The literal text
         ///          used to define an item is usually stored here.
         /// </para>
         /// </remarks> 
         public string Text() {
            IntPtr ReturnStrSize;
            var ReturnStr = Text_2(hb, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Determines if a uCalc Item has the given properties</summary> 
         /// <param name="ItemProperty"> The property you want to check for</param>
         /// <returns> Returns True if the uCalc Item matches the given property, or False otherwise.</returns>
         /// <remarks>
         /// <para>This helps you determine whether the uCalc Item is a function, operator, variable, data type,
         ///            literal value, etc, or has certain other special properties.  Note: Some items may have multiple
         ///            properties.  For instance the Function property may be set to true for arrays.
         ///            +++ Maybe (or maybe not; Transform class has them) have complete set of Is functions.  For instance IsCaseSensitive(), IsFunction(), IsVariable(), etc...
         ///            and for some you can change the value like IsCaseSensitive(true) sets the property to true.
         /// </para>
         /// </remarks> 
         public bool IsProperty(ItemIsEnum ItemProperty) { return Convert.ToBoolean(IsProperty_3(hb, ItemProperty));          }
         
         /// <summary> Sets a given property</summary> 
         /// <param name="ItemProperty"> The property you want to check for</param>
         /// <param name="TrueOrFalse"> Value to set the property to</param>
         /// <returns> Returns True if the uCalc Item matches the given property, or False otherwise.</returns>
         /// <remarks>
         /// <para>This helps you determine whether the uCalc Item is a function, operator, variable, data type,
         ///          literal value, etc, or has certain other special properties.  Note: Some items may have multiple
         ///          properties.  For instance the Function property may be set to true for arrays.
         ///          +++ Maybe (or maybe not; Transform class has them) have complete set of Is functions.  For instance IsCaseSensitive(), IsFunction(), IsVariable(), etc...
         ///          and for some you can change the value like IsCaseSensitive(true) sets the property to true.
         /// </para>
         /// </remarks> 
         public void IsProperty(ItemIsEnum ItemProperty ,bool TrueOrFalse) { IsProperty_4(hb, ItemProperty , Convert.ToInt32(TrueOrFalse));          }
         
         /// <summary> Returns next uCalc Item object that shares the same name</summary> 
         /// <returns> Returns next uCalc Item object that shares the same name, or a NULL (or 0) if there is none</returns>
         /// <remarks>
         /// <para>If several functions, operators, parameters, etc are overloaded -- that is they are defined with different
         ///          parameters but share the same name --, or if they (or variables) overshadow each other, this function returns
         ///          the next uCalc.Item object that shares the same name.
         /// </para>
         /// </remarks> 
         public Item NextOverload() { return NextOverload_5(hb);          }
         
         /// <summary> Associates a comment with a rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///          Each rule can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system, or as a tool tip.
         /// </para>
         /// </remarks> 
         public string Comment() {
            IntPtr ReturnStrSize;
            var ReturnStr = Comment_6(hb, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Associates a comment with a rule</summary> 
         /// <param name="CommentStr"> Text of the comment</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///          Each rule can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system, or as a tool tip.
         /// </para>
         /// </remarks> 
         public Rule Comment(string CommentStr) { return Comment_7(hb, CommentStr, (IntPtr)CommentStr.Length);          }
         
         /// <summary> Returns the data type of a uCalc Item</summary> 
         /// <remarks>
         /// <para>The returned data type object can be used to determine the type name, size, etc.</para>
         /// </remarks> 
         public DataType DataType() { return DataType_8(hb);          }
         
         /// <summary> Sets the data type of a uCalc Item +++ Might no longer be needed</summary> 
         /// <param name="dType"> ...</param>
         /// <remarks>
         /// <para>Intended mainly for use with DefaultItem()</para>
         /// </remarks> 
         public void DataType(uCalc.DataType dType) { DataType_9(hb, dType != null ? dType.h : (IntPtr)0);          }
         
         /// <summary> Returns the uCalc object that performs calculations related to the transform</summary> 
         /// <returns> uCalc object associated with current transform</returns>
         /// <remarks>
         /// <para>If your transform inovlves calcuations, then they will be performed using the
         ///          uCalc object returned by this function.  Each uCalc object can have its own sets of
         ///          variables, functions, and other definitions.</para>
         /// <para>         A uCalc.Item is defined in the context of a uCalc object.  You can later use this function to determine
         ///          the uCalc object the defined item belongs to.
         /// </para>
         /// </remarks> 
         public uCalc uCalc() { return uCalc_10(hb);          }
      }
      
      /// <summary> Class for handling uCalc items</summary> 
      public class Item: Base {
         
         /// <summary> Handle for a uCalc Item</summary> 
         public IntPtr h;
         
         /// <summary> Returns the number of elements in a uCalc Item</summary> 
         /// <remarks>
         /// <para>Depending on the kind of object, this may represent the number of elements in an array, the number of parameters in a function,
         ///          the number of operands in an operator, the number of parameters in a syntax construct, the number of parts in a transform,
         ///          the number of parts in a compound token, or the value explicitlely set in the Count property when calling Define.</para>
         /// <para>         When determining the number of elements, optional parameters in a function count as an element.  If the function
         ///          has a variable number of arguments, then count is -1.</para>
         /// <para>         The value returned for a syntax construct may not seem obvious, especially if it has optional and/or alternative
         ///          parts or some other complexity.</para>
         /// <para>         +++ the number of symbols in a uCalc
         ///          instance,</para>
         /// </remarks> 
         public Int64 Count() { return (Int64)Count_11(h);          }
         
         /// <summary> Returns the callback address of a defined function (or operator)</summary> 
         /// <remarks>
         /// <para>The returned value is the actual IntPtr address of the function as used by uCalc internally, and not
         ///          a delegate, even in .NET.  As such, in .NET this value can be used in the more general Define function but
         ///          not functions like DefineFunction or DefineneOperator.</para>
         /// </remarks> 
         public IntPtr FunctionAddress() { return FunctionAddress_12(h);          }
         
         /// <summary> Returns the precedence level of the uCalc.Item</summary> 
         /// <remarks>
         /// <para>Operators, and some syntax constructs are defined with a precedence level.  When defining a new operator you
         ///          may sometimes want to give it the same level as a pre-existing operator.</para>
         /// </remarks> 
         public Int64 Precedence() { return (Int64)Precedence_13(h);          }
         
         /// <summary> Sets the precedence level of the uCalc Item</summary> 
         /// <param name="Level"> ...</param>
         /// <remarks>
         /// <para>Operators, and some syntax constructs are defined with a precedence level.  When defining a new operator you
         ///          may sometimes want to give it the same level as a pre-existing operator.
         ///          For use mainly with DefaultItem.
         /// </para>
         /// </remarks> 
         public void Precedence(Int64 Level) { Precedence_14(h, (IntPtr)Level);          }
         
         /// <summary> Renames an item</summary> 
         /// <param name="NewName"> The new name of the item</param>
         /// <remarks>
         /// <para>
         /// Any defined item that has a name (such as a variable, constant, function, operator, etc) can be renamed with this function.
         /// </para>
         /// </remarks> 
         public Item Rename(string NewName) { return Rename_15(h, NewName, (IntPtr)NewName.Length);          }
         
         /// <summary> Returns the value (default double precision) associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Double precision value associated with a variable.</para>
         /// </remarks> 
         public double Value() { return Value_16(h);          }
         
         /// <summary> Sets the value of a floating point variable</summary> 
         /// <param name="Value"> Double precision floating point value that the variable will be set to</param>
         /// <remarks>
         /// <para>When a floating point variable is defined with DefineVariable, you can later set a value for this variable by passing an
         ///            argument to Value.  Note: If your compiler supports pointers, you can define a uCalc variable that is directly attached
         ///            to the address of a variable in your source code, and not have to use Value.
         /// </para>
         /// </remarks> 
         public void Value(double Value) { Value_17(h, Value);          }
         
         /// <summary> Sets the value of a variable of any data type by passing a string</summary> 
         /// <param name="Value"> String containing the value that will be converted and stored in the variable</param>
         /// <remarks>
         /// <para>This lets you set the value of a variable defined with DefineVariable (or Define) regardless of the variable's data type.
         ///          The value is passed as a string, and internally converted to the appropriate data type.  Note: Because a conversion takes
         ///          place with ValueAny, it is typically slower than calling Value for floating point, or one of the
         ///          other versions of Value specific to a data type.</para>
         /// </remarks> 
         public void Value(string Value) { Value_18(h, Value, (IntPtr)Value.Length);          }
         
         /// <summary> Returns the Boolean value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Boolean value associated with a variable.</para>
         /// </remarks> 
         public bool ValueBool() { return Convert.ToBoolean(ValueBool_19(h));          }
         
         /// <summary> Sets the value of a Boolean variable</summary> 
         /// <param name="Value"> Boolean value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a Boolean variable defined with DefineVariable (or Define)</para>
         /// </remarks> 
         public void ValueBool(bool Value) { ValueBool_20(h, Convert.ToInt32(Value));          }
         
         /// <summary> Returns the byte value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Byte value associated with a variable.</para>
         /// </remarks> 
         public Byte ValueByte() { return ValueByte_21(h);          }
         
         /// <summary> Sets the value of a Byte variable</summary> 
         /// <param name="Value"> Byte value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a Byte variable defined with DefineVariable (or Define)</para>
         /// </remarks> 
         public void ValueByte(Byte Value) { ValueByte_22(h, Value);          }
         
         /// <summary> Returns the 16-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int16 value associated with a variable.</para>
         /// </remarks> 
         public Int16 ValueInt16() { return ValueInt16_23(h);          }
         
         /// <summary> Sets the value of a 16-bit integer variable</summary> 
         /// <param name="Value"> 16-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 16-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 16-bit integers.</para>
         /// </remarks> 
         public void ValueInt16(Int16 Value) { ValueInt16_24(h, Value);          }
         
         /// <summary> Returns the 32-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int32 value associated with a variable.</para>
         /// </remarks> 
         public Int32 ValueInt32() { return ValueInt32_25(h);          }
         
         /// <summary> Sets the value of a 32-bit integer variable</summary> 
         /// <param name="Value"> 32-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 32-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 32-bit integers.</para>
         /// </remarks> 
         public void ValueInt32(Int32 Value) { ValueInt32_26(h, Value);          }
         
         /// <summary> Returns the 64-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int64 value associated with a variable.</para>
         /// </remarks> 
         public Int64 ValueInt64() { return ValueInt64_27(h);          }
         
         /// <summary> Sets the value of a 64-bit integer variable</summary> 
         /// <param name="Value"> 64-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 64-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 64-bit integers.</para>
         /// </remarks> 
         public void ValueInt64(Int64 Value) { ValueInt64_28(h, Value);          }
         
         /// <summary> Returns the Double precision value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Single precision value associated with a variable.</para>
         /// </remarks> 
         public float ValueSng() { return ValueSng_29(h);          }
         
         /// <summary> Sets the value of a single precision floating point variable</summary> 
         /// <param name="Value"> Single precision value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a single precision variable defined with DefineVariable (or Define).</para>
         /// </remarks> 
         public void ValueSng(float Value) { ValueSng_30(h, Value);          }
         
         /// <summary> Returns the Double precision value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Synonymous with Value</para>
         /// </remarks> 
         public double ValueDbl() { return ValueDbl_31(h);          }
         
         /// <summary> Sets the value of a double precision floating point variable</summary> 
         /// <param name="Value"> Double precision floating point value that the variable will be set to</param>
         /// <remarks>
         /// <para>ValueDbl is synonymous with Value</para>
         /// </remarks> 
         public void ValueDbl(double Value) { ValueDbl_32(h, Value);          }
         
         /// <summary> Returns the String value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the String value associated with a variable.</para>
         /// <para>         ValueStr has a special property beyond the Value function for other data types in that it can return the value
         ///          of an item regardless of what data type it has.  The value is returned as a string.
         /// </para>
         /// </remarks> 
         public string ValueStr() {
            IntPtr ReturnStrSize;
            var ReturnStr = ValueStr_33(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets the value of a string variable</summary> 
         /// <param name="Value"> String value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a string variable defined with DefineVariable (or Define).</para>
         /// </remarks> 
         public void ValueStr(string Value) { ValueStr_34(h, Value, (IntPtr)Value.Length);          }
         
         /// <summary> Returns the IntPtr value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the IntPtr value associated with a variable.
         ///          Note: If the uCalc.Item is a Variable of type IntPtr, then ValuePtr returns a IntPtr value
         ///          that is stored in that variable, whereas ValueAddr returns the IntPtr of the variable itself.  In other words
         ///          ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any value you may
         ///          have set as the address the variable points to.</para>
         /// </remarks> 
         public IntPtr ValuePtr() { return ValuePtr_35(h);          }
         
         /// <summary> Sets the value of a IntPtr variable</summary> 
         /// <param name="Value"> IntPtr that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a IntPtr variable defined with DefineVariable (or Define).  Note: This does not
         ///          change the IntPtr of the variable.  It simply stores a IntPtr value in the variable.</para>
         /// </remarks> 
         public void ValuePtr(IntPtr Value) { ValuePtr_36(h, Value);          }
         
         /// <summary> Sets the value of a variable to a value who's IntPtr is passed</summary> 
         /// <param name="Value"> IntPtr to the value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a variable by passing the IntPtr to the value you want to set the variable to.</para>
         /// </remarks> 
         public void ValueByPtr(IntPtr Value) { ValueByPtr_37(h, Value);          }
         
         /// <summary> Returns the IntPtr address of the value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the IntPtr address of the value associated with a variable (instead of
         ///          the value itself).  Note: If the uCalc.Item is a Variable of type IntPtr, then ValuePtr returns a IntPtr value
         ///          that is stored in that variable, whereas ValueAddr returns the IntPtr of the variable itself.  In other words
         ///          ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any given address
         ///          you may have stored as the value of the variable.</para>
         /// </remarks> 
         public IntPtr ValueAddr() { return ValueAddr_38(h);          }
         
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          +++ check optimization
         ///          ... +++ Do this for other structs too
         /// </para>
         /// </remarks>
         
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         
         public Item() { h = default(IntPtr);          }
         public Item( string Definition ) { h = Default().Define(Definition).h;          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_39(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_40(h); h = (IntPtr)0;          }
         
         public static implicit operator Item(IntPtr o) { return new Item(o);          }
         public Item(IntPtr PassedHandle) { h = PassedHandle; hb = h;          }
         
      }
      
      /// <summary> Class for evaluating an already parsed expression or executing parsed code</summary> 
      public class Expression {
         
         /// <summary> Handle for a uCalc expression</summary> 
         public IntPtr h;
         
         /// <summary> Rapidly evaluates a floating point expression that was parsed with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated expression returned as a floating point number</returns>
         /// <remarks>
         /// <para>Evaluate can be used instead of Eval for faster results in time-critical loops where the same expression
         ///          is repeatedly re-evaluated, with the only change in each iteration typically being the value(s) of one or
         ///          more variables.  Evaluate works in pair with Parse, the relatively slower part, which is called first before
         ///          going into the time-critical loop.  The Expression object returned by Parse is what calls the Evaluate function.</para>
         /// <para>         
         ///          
         ///          
         ///          
         ///          
         ///          
         ///          
         ///          
         /// <para>         Evaluate can also be called by a Expression object that was passed to a callback By Expression.</para>
         /// <para>         If the expression evaluates to something other than Double precision floating point (such as various integers, complex,
         ///          single precision, etc), the value is converted before being returned.  In some cases (such as string, complex, etc), the
         ///          return result may or may not have a meaningful value.  However, an error is not raised.
         /// </para>
         /// </remarks> 
         public double Evaluate() { return Evaluate_41(h);          }
         
         /// <summary> Rapidly evaluates a floating point expression that was parsed with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated floating point expression</returns>
         /// <remarks>
         /// <para>EvaluateDbl is similar to Evaluate, but is intended strictly for expressions that return a Double
         ///          precision value (determined by the operators used in the expression).  It will not work with Integers
         ///          or Single precision expressions for instance.</para>
         /// <para>         If the expression evaluates
         ///          to a non-numeric value (such as a string) or non-scalar numeric value (such as a complex number), or if a numeric
         ///          type other than the default was explicitely specified with Parse, the value returned will be invalid.  However,
         ///          an error will not be raised.
         /// </para>
         /// </remarks> 
         public double EvaluateDbl() { return EvaluateDbl_42(h);          }
         
         /// <summary> Rapidly evaluates expression that was parsed as integer with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated integer expression</returns>
         /// <remarks>
         /// <para>
         ///          This is similar to Evaluate, but applies only to expressions that return a 32-bit integer.
         /// </para>
         /// </remarks> 
         public Int32 EvaluateInt32() { return EvaluateInt32_43(h);          }
         
         /// <summary> Rapidly evaluates expression that was parsed as Boolean with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated Boolean expression</returns>
         /// <remarks>
         /// <para>
         ///          This is similar to Evaluate, but applies only to expressions that return a Boolean.
         ///          Certain operators, such as comparison operators like <, >, ==, etc. return a Boolean.  If the final operation of an
         ///          expression is Boolean, for instance in Parse("x + 1 > 3"), then you can use EvaluateBool.  In earlier versions
         ///          Evaluate could not be used for types other than floating point, unless Double was specified in Parse so that a
         ///          conversion can take place (from Bool in this case) to Double before being returned.  Now you can either use
         ///          EvaluateBool (slightly more efficient) or else Evaluate as a catch all for any type including Boolean.
         /// </para>
         /// </remarks> 
         public bool EvaluateBool() { return Convert.ToBoolean(EvaluateBool_44(h));          }
         
         /// <summary> Rapidly evaluates an expression of any data type that was parsed with Parse or passed By Expression returning a string</summary> 
         /// <returns> The result of an evaluated expression of any data type, returned as a string</returns>
         /// <remarks>
         /// <para>EvaluateStr is similar to Evaluate.  However, EvaluateStr returns a value as a string.  Unlike Evaluate, which can only
         ///          return a floating point value, EvaluateStr can return a value of any data type.  Non-string values are converted to a string
         ///          before being returned.
         /// </para>
         /// </remarks> 
         public string EvaluateStr() {
            IntPtr ReturnStrSize;
            var ReturnStr = EvaluateStr_45(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Rapidly evaluates an expression that was parsed with Parse or passed By Expression and returns a IntPtr to the result</summary> 
         /// <returns> Returns a IntPtr to the result instead of the result itself</returns>
         /// <remarks>
         /// <para>Use this when you are interested in a IntPtr to the result instead of the result itself.  For instance, given an integer
         ///          result, you might use a IntPtr in order to retrieve the hi byte and lo byte values.
         /// </para>
         /// </remarks> 
         public IntPtr EvaluateVoid() { return EvaluateVoid_46(h);          }
         
         /// <summary> Rapidly executes code that was parsed with Parse or passed By Expression for which a result is not required</summary> 
         /// <remarks>
         /// <para>This can be used in cases where the reutrn value is not needed, such as statements that represent code to be executed
         ///          rather than a math expression.
         /// </para>
         /// </remarks> 
         public void Execute() { Execute_47(h);          }
         
         /// <summary> Returns the data type of a parsed expression</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         public DataType DataType() { return DataType_48(h);          }
         
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          +++ check optimization
         ///          ...
         /// </para>
         /// </remarks>
         
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_49(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_50(h); h = (IntPtr)0;          }
         
         public static implicit operator Expression(IntPtr o) { return new Expression(o);          }
         public Expression(IntPtr PassedHandle) { h = PassedHandle;          }
      }
      
      /// <summary> Class for retrieving arguments passed to a callback, returning a value, and more</summary> 
      public class Callback {
         
         /// <summary> Handle of the expression part the current callback instance is refering to</summary> 
         public IntPtr h;
         
         /// <summary> Returns the value of an argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>When the name of a callback function is specified in DefineFunction or DefineOperator, that
         ///          callback function will receive arguments uCalc passes to it through the Arg.  Arg handles values
         ///          of the default Double floating point data type.  For other data types, ArgInt32, ArgStr, etc instead.</para>
         /// <para>         Note that Index is 1-based.  So if there are 3 arguments, the Index of the first will be
         ///          1 (not 0), and the second and third will be 2 and 3 respectively.</para>
         /// <para>         If you are defining a binary operator, 1 is the index for the left operand, and 2 for the right operand.
         ///          For a unary operator, the index is 1.
         /// </para>
         /// </remarks> 
         public double Arg(Int64 Index) { return Arg_51(h, (IntPtr)Index);          }
         
         /// <summary> Returns the value of an argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>When the name of a callback function is specified in DefineFunction or DefineOperator, that
         ///          callback function will receive arguments uCalc passes to it through the Arg.  Arg handles values
         ///          of the default Double floating point data type.  For other data types, ArgInt32, ArgStr, etc instead.</para>
         /// <para>         Note that Index is 1-based.  So if there are 3 arguments, the Index of the first will be
         ///          1 (not 0), and the second and third will be 2 and 3 respectively.</para>
         /// <para>         If you are defining a binary operator, 1 is the index for the left operand, and 2 for the right operand.
         ///          For a unary operator, the index is 1.
         /// </para>
         /// </remarks> 
         public double ArgDbl(Int64 Index) { return ArgDbl_52(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         public double Arg1() { return Arg1_53(h);          }
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         public double Arg2() { return Arg2_54(h);          }
         
         /// <summary> Returns the Boolean integer argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int32, then the callback function can
         ///          recieve it through ArgBool.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         public bool ArgBool(Int64 Index) { return Convert.ToBoolean(ArgBool_55(h, (IntPtr)Index));          }
         
         /// <summary> Returns the number of arguments being passed to a uCalc.Callback function</summary> 
         /// <returns> 0 if no arg is passed; or a positive integer representing the number of args being passed.</returns>
         /// <remarks>
         /// <para>This is useful for functions that have a variable number of arguments</para>
         /// </remarks> 
         public Int64 ArgCount() { return (Int64)ArgCount_56(h);          }
         
         /// <summary> Returns an object instance of the argument being passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <returns> The returned object can be used (where relevent) just like any other uCalc.Item</returns>
         /// <remarks>
         /// <para>Each argument is a uCalc.Item, just like anything else defined with Define.  With this object,
         ///          you can do such things as determine the argument's data type, determine which instance of uCalc
         ///          it belongs to, retrieve the IntPtr of the value of the argument, etc.</para>
         /// </remarks> 
         public Item ArgObj(Int64 Index) { return ArgObj_57(h, (IntPtr)Index);          }
         
         /// <summary> Returns the address of the argument value that is being passed</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>In addition to Arg which returns arguments that are of the default Double floating point numeric type, there
         ///          are specialized functions for other datatypes such as ArgInt32, ArgInt64, etc.  However, if the argument is of
         ///          a data type that does not have a specialized function, you can retrieve the address of the argument value as
         ///          a IntPtr, and use that to retrieve the value.</para>
         /// </remarks> 
         public IntPtr ArgAddr(Int64 Index) { return ArgAddr_58(h, (IntPtr)Index);          }
         
         /// <summary> Returns the object instance of the expression that's passed as an argument to a uCalc.Callback function+++Example</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <returns> Returns parsed expression object with which you can call functions like Evaluate or Execute</returns>
         /// <remarks>
         /// <para>uCalc allows you to not only pass arguments by value or by reference.  But it also lets you pass an argument
         ///          by expression.  When an expression is passed By Expression, the expresison is not evaluated before being passed.
         ///          Instead a handle to the parsed expression is passed, allowing the callback to perform the evaluation.</para>
         /// </remarks> 
         public Expression ArgExpr(Int64 Index) { return ArgExpr_59(h, (IntPtr)Index);          }
         
         /// <summary> Returns the Int32 integer argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int32, then the callback function can
         ///          recieve it through ArgInt32.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         public Int32 ArgInt32(Int64 Index) { return ArgInt32_60(h, (IntPtr)Index);          }
         
         /// <summary> Returns the Int64 integer argument being passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int64, then the callback function can
         ///          recieve it through ArgInt64.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         public Int64 ArgInt64(Int64 Index) { return ArgInt64_61(h, (IntPtr)Index);          }
         
         /// <summary> Returns a IntPtr value being passed as an argument to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as a IntPtr, then the callback function can
         ///          recieve it through ArgPtr.  Note that ArgPtr returns any address value that is being sent, whereas ArgAddr returns the
         ///          address of the value being passed.</para>
         /// </remarks> 
         public IntPtr ArgPtr(Int64 Index) { return ArgPtr_62(h, (IntPtr)Index);          }
         
         /// <summary> Returns the value being passed as argument in to a uCalc.Callback function in form of a string</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>Returns data of any type to a string.
         ///          In addition to returning an argument that was passed as a string, ArgStr has the special property of returning an argument that
         ///          was passed as any data type.  If the argument was not a string, ArgStr converts it to a string before returning its value.</para>
         /// </remarks> 
         public string ArgStr(Int64 Index) {
            IntPtr ReturnStrSize;
            var ReturnStr = ArgStr_63(h, out ReturnStrSize , (IntPtr)Index);
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets the return value (default floating point) of a uCalc.Callback function</summary> 
         /// <param name="Value"> Floating point value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a floating point number,
         ///          do it with Return.</para>
         /// <para>         Note: For compilers in which Return is a reserved keyword, use ReturnDbl instead.
         /// </para>
         /// </remarks> 
         public void Return(double Value) { Return_64(h, Value);          }
         
         /// <summary> Sets the return value (default floating point) of a uCalc.Callback function</summary> 
         /// <param name="Value"> Floating point value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a floating point number,
         ///          do it with Return.</para>
         /// <para>         Note: For compilers in which Return is a reserved keyword, use ReturnDbl instead.
         /// </para>
         /// </remarks> 
         public void ReturnDbl(double Value) { ReturnDbl_65(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Boolean integer</summary> 
         /// <param name="Value"> Boolean that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Boolean,
         ///          do it with ReturnBool.</para>
         /// </remarks> 
         public void ReturnBool(bool Value) { ReturnBool_66(h, Convert.ToInt32(Value));          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Int32 integer</summary> 
         /// <param name="Value"> Integer (32-bit) that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Int32,
         ///          do it with ReturnInt32.</para>
         /// </remarks> 
         public void ReturnInt32(Int32 Value) { ReturnInt32_67(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Int64 integer</summary> 
         /// <param name="Value"> Integer (64-bit) that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Int64,
         ///          do it with ReturnInt64.</para>
         /// </remarks> 
         public void ReturnInt64(Int64 Value) { ReturnInt64_68(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as a IntPtr</summary> 
         /// <param name="Value"> IntPtr value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction that returns a IntPtr value,
         ///          do it with ReturnPtr.</para>
         /// </remarks> 
         public void ReturnPtr(IntPtr Value) { ReturnPtr_69(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as a String</summary> 
         /// <param name="Value"> String value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction that returns a string,
         ///          do it with ReturnStr.</para>
         /// </remarks> 
         public void ReturnStr(string Value) { ReturnStr_70(h, Value, (IntPtr)Value.Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="ErrNumber"> Index number of error to raise</param>
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         public void ErrorSet(ErrorNumberEnum ErrNumber) { ErrorSet_71(h, ErrNumber);          }
         
         /// <summary> Raises an error in a uCalc.Callback function</summary> 
         /// <param name="ErrNumber"> Index number of error to raise</param>
         /// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
         /// <remarks>
         /// <para>Your callback can raise an error by calling this funciton with one of the values of the
         ///          ErrorNumberEnum enumerator.  End-user function definitions can also raise an error by calling Error().
         ///          The return value is determined by error handlers that you may have added.  ErrorAbort (value of 0)
         ///          is returned by default if there are no error handlers.</para>
         /// </remarks> 
         public ErrorHandlerResponseEnum ErrorRaise(ErrorNumberEnum ErrNumber) { return ErrorRaise_72(h, ErrNumber);          }
         
         /// <summary> Raises an error with a user-defined message in a uCalc.Callback function</summary> 
         /// <param name="ErrMessage"> Text of custom error message to return</param>
         /// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
         /// <remarks>
         /// <para>Your callback can raise a custom error message (one not listed as a ErrorNumberEnum enumerator)
         ///          by simply passing the text of the message to this function.</para>
         /// </remarks> 
         public ErrorHandlerResponseEnum ErrorRaiseMessage(string ErrMessage) { return ErrorRaiseMessage_73(h, ErrMessage, (IntPtr)ErrMessage.Length);          }
         
         /// <summary> Returns the uCalc instance the current expression part belongs to</summary> 
         /// <remarks>
         /// <para>A callback is designed to work with all instances of uCalc.  However, at times you may need to know
         ///          which particular instance of uCalc the expression part being passed belongs to.</para>
         /// </remarks> 
         public uCalc uCalc() { return uCalc_74(h);          }
         
         /// <summary> Returns the function or operator Item of the current expression part</summary> 
         /// <remarks>
         /// <para>If several functions and/or operators are mapped to the same callback function, you can use this to
         ///          let you determine which one is currently being called, based on properties you can check.</para>
         /// </remarks> 
         public Item Item() { return Item_75(h);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_76(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_77(h); h = (IntPtr)0;          }
         
         public static implicit operator Callback(IntPtr o) { return new Callback(o);          }
         public Callback(IntPtr PassedHandle) { h = PassedHandle;          }
      } 
      
      /// <summary> Class for working with uCalc data types</summary> 
      public class DataType {
         
         /// <summary> Handle for uCalc Data Type</summary> 
         public IntPtr h;
         
         /// <summary> Returns the size (in bytes) of one unit of data for this data type</summary> 
         public Int64 ByteSize() { return (Int64)ByteSize_78(h);          }
         
         /// <summary> Returns the index of the data type</summary> 
         /// <remarks>
         /// <para>The return value is a BuiltInTypesEnum enumerator value that represents the data type of the
         ///          current object.  For instance, if the data type is a string, the return value would be Type_String.
         /// </para>
         /// </remarks> 
         public BuiltInTypesEnum Index() { return Index_79(h);          }
         
         /// <summary> Returns the uCalc.Item handle of the data type</summary> 
         /// <remarks>
         /// <para>Each data type object can also be represented as a uCalc object by using this return value.</para>
         /// </remarks> 
         public Item Item() { return Item_80(h);          }
         
         /// <summary> Returns the name of the data type</summary> 
         public string Name() {
            IntPtr ReturnStrSize;
            var ReturnStr = Name_81(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary> 
         /// <param name="ValuePtr"> IntPtr of the uCalc array to be reset</param>
         /// <param name="Size"> Number of elements to reset</param>
         /// <remarks>
         /// <para>Resets all the elements of the array to the default value for the given data type.  This should only
         ///          be used for arrays that were explicitly allocated with uCalc's AllocArray.
         ///          +++ Test this
         /// </para>
         /// </remarks> 
         public void Reset(IntPtr ValuePtr ,Int64 Size) { Reset_82(h, ValuePtr , (IntPtr)Size);          }
         
         /// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary> 
         /// <param name="ValuePtr"> IntPtr of the uCalc scalar to be reset</param>
         /// <remarks>
         /// <para>
         ///           +++ Test this
         /// </para>
         /// </remarks> 
         public void Reset(IntPtr ValuePtr) { Reset_83(h, ValuePtr);          }
         
         /// <summary> Sets the value of an array at a given memory location that was allocated by AllocArray</summary> 
         /// <param name="Destination"> IntPtr of array (base address) of which the element value is to be set</param>
         /// <param name="Source"> IntPtr to a value of the same data type that will be copied to the element</param>
         /// <param name="Index"> Index of the array element who's value needs to be set</param>
         /// <remarks>
         /// <para>
         ///          +++ Test this or remove
         /// </para>
         /// </remarks> 
         public void SetArray(IntPtr Destination ,IntPtr Source ,Int64 Index) { SetArray_84(h, Destination , Source , (IntPtr)Index);          }
         
         /// <summary> Sets the value of a scalar at a given memory location that was allocated by AllocScalar</summary> 
         /// <param name="Destination"> IntPtr of scalar who's value is to be set</param>
         /// <param name="Source"> IntPtr to a value of the same data type that will be copied to the element</param>
         /// <remarks>
         /// <para>
         ///          +++ Test this or remove
         /// </para>
         /// </remarks> 
         public void SetScalar(IntPtr Destination ,IntPtr Source) { SetScalar_85(h, Destination , Source);          }
         
         /// <summary> swaps the pointers of two variables that were allocated with AllocScalar or AllocArray</summary> 
         /// <param name="ValuePtrA"> IntPtr of variable 1</param>
         /// <param name="ValuePtrB"> IntPtr of variable 2</param>
         public void SwapScalarValues(IntPtr ValuePtrA ,IntPtr ValuePtrB) { SwapScalarValues_86(h, ValuePtrA , ValuePtrB);          }
         
         /// <summary> Retuns a string representing the value at the given address formatted for the given data type</summary> 
         /// <param name="ValuePtr"> IntPtr of the data containing the value you want to display</param>
         /// <remarks>
         /// <para>If you have a IntPtr to data of the given type, you can display this data as a string with this function.  Special formatting
         ///          associated with a data type is used, if such formatting was defined.  For instance, if you're dealing with a Boolean, then
         ///          you might get: True, Yes, On, etc, depending on how the formatting was configured with Format.</para>
         /// </remarks> 
         public string ToString(IntPtr ValuePtr) {
            IntPtr ReturnStrSize;
            var ReturnStr = ToString_87(h, out ReturnStrSize , ValuePtr);
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Retuns a formatted string of the given data type representing the value that was passed as text</summary> 
         /// <param name="Value"> String representing data of any type that is to be represented as data of the given type</param>
         /// <remarks>
         /// <para>If you pass a string, it will be converted to the given data type, and return using the formatting
         ///          for that data type.</para>
         /// </remarks> 
         public string ToString(string Value) {
            IntPtr ReturnStrSize;
            var ReturnStr = ToString_88(h, out ReturnStrSize , Value, (IntPtr)Value.Length);
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> ... +++ check optimization</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_89(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_90(h); h = (IntPtr)0;          }
         
         public static implicit operator DataType(IntPtr o) { return new DataType(o);          }
         public DataType(IntPtr PassedHandle) { h = PassedHandle;          }
      } 
      
      /// <summary> uCalc transform class</summary> 
      public class Transforms: Base {
         
         /// <summary> Handle for uCalc Transform instance</summary> 
         public IntPtr h;
         
         /// <summary> Defines a rule (for search, transform, or filter)</summary> 
         /// <param name="Comment"> Documentation/help/comment/tooltip type info associated with the rule. See Comment.</param>
         /// <param name="FindStr"> Pattern of text you want to match (The Find pattern in a search, or the From part in FromTo).</param>
         /// <param name="ToStr"> Replacement string (text that the From part should be changed to)</param>
         /// <param name="Min"> Soft minimum number of matches required.  See Min.</param>
         /// <param name="Max"> Soft maximum number of matches allowed.  See Max.</param>
         /// <param name="MinHard"> Hard minimum number of matches required. See MinHard</param>
         /// <param name="MaxHard"> Hard maximum number of matches allowed.  See MaxHard</param>
         /// <param name="Precedence"> Precedence level.  See Precedence.</param>
         /// <param name="StartAfter"> Number of matches to skip before matches start counting. See StartAfter.</param>
         /// <param name="StopAfter"> Number of matches to stop counting after.  See StopAfter.</param>
         /// <param name="SkipOver"> Makes it skip over text that is a match.  See SkipOver.</param>
         /// <param name="RewindOnChange"> Determines whether to rewind to the beginning of modified text and parse again</param>
         /// <param name="CaseSensitive"> Case sensitivity.  See CaseSensitive.</param>
         /// <param name="BracketSensitive"> Sets bracket sensitivity.  See BracketSensitive.</param>
         /// <param name="QuoteSensitive"> Sets quote sensitivity.  See QuoteSensitive.</param>
         /// <param name="RightToLeft"> Right to left</param>
         /// <returns> Rule object that has just been defined</returns>
         /// <remarks>
         /// <para>
         ///    Defines a rule that contains a pattern used for finding text, along with a replacement string, and all the other properties.
         ///    This function represents an alternative way of defining a rule, by supplying all the properties in this one function call.  These
         ///    same properties can be called individually with separate functions.  Additional details for each property can be found in separate
         ///    topics for function calls related to each property.</para>
         /// <para></para>
         /// </remarks> 
         public Rule DefineRule(string Comment ,string FindStr ,string ToStr ,Int64 Min ,Int64 Max ,Int64 MinHard ,Int64 MaxHard ,Int64 Precedence ,Int64 StartAfter ,Int64 StopAfter ,bool SkipOver ,bool RewindOnChange ,bool CaseSensitive ,bool BracketSensitive ,bool QuoteSensitive ,bool RightToLeft) { return DefineRule_91(h, Comment, (IntPtr)Comment.Length , FindStr, (IntPtr)FindStr.Length , ToStr, (IntPtr)ToStr.Length , (IntPtr)Min , (IntPtr)Max , (IntPtr)MinHard , (IntPtr)MaxHard , (IntPtr)Precedence , (IntPtr)StartAfter , (IntPtr)StopAfter , Convert.ToInt32(SkipOver) , Convert.ToInt32(RewindOnChange) , Convert.ToInt32(CaseSensitive) , Convert.ToInt32(BracketSensitive) , Convert.ToInt32(QuoteSensitive) , Convert.ToInt32(RightToLeft));          }
         
         /// <summary> Defines a new token</summary> 
         /// <param name="TokenDef"> Token definition</param>
         /// <param name="TokenType"> The type of token</param>
         /// <param name="CloseBracket"> String representing closing bracket, such as "}", ")", "]", etc.</param>
         /// <param name="SubMatch"> Submatch</param>
         /// <param name="RegExGrammar"> Type of RegEx grammar</param>
         /// <returns> Token item</returns>
         /// <remarks>
         /// <para>
         ///    For details see Define (Transforms)
         /// </para>
         /// </remarks> 
         public Item DefineToken(string TokenDef ,TokenEnum TokenType = TokenEnum.Generic,string CloseBracket  = "",Int64 SubMatch  = 0,RegExGrammarEnum RegExGrammar = RegExGrammarEnum.RegEx_Default) { return DefineToken_92(h, TokenDef, (IntPtr)TokenDef.Length , TokenType, CloseBracket, (IntPtr)CloseBracket.Length, (IntPtr)SubMatch, RegExGrammar);          }
         
         /// <summary> +++ Remove this</summary> 
         public void RemoveToken() { RemoveToken_93(h);          }
         
         /// <summary> Returns the Tokens object for the current transform</summary> 
         /// <returns> Token list object</returns>
         /// <remarks>
         /// <para>
         ///    Returns the Tokens object, which consists of a list of tokens for the current transform.
         ///    You can use this to add, modify, delete, or reset the tokens.
         /// </para>
         /// </remarks> 
         public Tokens Tokens() { return Tokens_94(h);          }
         
         /// <summary> Defines a transform rule</summary> 
         /// <param name="FromStr"> Pattern that describes the text to match</param>
         /// <param name="ToStr"> New text that the match should be changed to</param>
         /// <returns> Object for rule being defined</returns>
         /// <remarks>
         /// <para>Whenever a piece of text matches the pattern described in FromStr, it is replaced with the text
         ///    found in ToStr.
         /// </para>
         /// </remarks> 
         public Rule FromTo(string FromStr ,string ToStr  = "") { return FromTo_95(h, FromStr, (IntPtr)FromStr.Length , ToStr, (IntPtr)ToStr.Length);          }
         
         /// <summary> Sets the uCalc object that performs calculations related to the transform</summary> 
         /// <param name="uCalcHandle"> Handle of a uCalc object 
         /// <returns> uCalc object associated with current transform</returns>
         /// <remarks>
         /// <para>If your transform inovlves calcuations, then they will be performed using the
         ///    uCalc object the transform was defined in.  However, yoiu can change the uCalc object with this function.
         ///    Each uCalc object can have its own sets of variables, functions, and other definitions.
         ///    For instance when {@Eval: ...} is used in the pattern or ~Eval() in the text.
         /// </para>
         /// </remarks> 
         public Transforms uCalc(IntPtr uCalcHandle) { return uCalc_96(h, uCalcHandle);          }
         
         /// <summary> Returns a new Pass object</summary> 
         /// <param name="Share"> Share</param>
         /// <returns> Transform object</returns>
         /// <remarks>
         /// <para>
         ///    It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  The transform
         ///    of each pass is executed in sequential order.  Passes can later be referenced later by index.  Calling NewPass the first
         ///    time returns the same as Pass(0), the next call to NewPass refers to Pass(1), etc.
         /// </para>
         /// </remarks> 
         public Transforms NewPass(bool Share  = false) { return NewPass_97(h, Convert.ToInt32(Share));          }
         
         /// <summary> Returns a new Pass object</summary> 
         /// <param name="Index"> Index of pass to select</param>
         /// <param name="Share"> Share</param>
         /// <returns> Transform object</returns>
         /// <remarks>
         /// <para>
         ///    It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  Each pass
         ///    is transformed in sequential order, starting with Pass(0).  A pass consists of a transform.
         /// </para>
         /// </remarks> 
         public Transforms Pass(Int64 Index ,bool Share  = false) { return Pass_98(h, (IntPtr)Index , Convert.ToInt32(Share));          }
         
         /// <summary> Resets the transform object</summary> 
         /// <param name="ResetOption"> Reset option</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>This clears the input string, transform rules, token definitions, Results.  It also resets properties to default settings
         /// </para>
         /// </remarks> 
         public Transforms Reset(TransformResetEnum ResetOption = TransformResetEnum.Reset_All) { return Reset_99(h, ResetOption);          }
         
         /// <summary> Performs the transformation of text</summary> 
         /// <returns> The current transform object</returns>
         /// <remarks>
         /// <para>Once all the rules and parameters are set, you can call this function in order to
         ///    perform the text transformation.</para>
         /// <para>   Prior to calling Transform, you must set the text to be transformed, with Str
         /// </para>
         /// </remarks> 
         public Transforms Transform() { return Transform_100(h);          }
         
         /// <summary> Transforms an expression in one quick step</summary> 
         /// <param name="expression"> Expression to be transformed</param>
         /// <returns> String result of transform</returns>
         /// <remarks>
         /// <para>
         ///    When you would like to set text to be transformed, and transform the text, and return a result, all in one step,
         ///    you can use this function, instead of calling Str, then Transform, then Str.
         /// </para>
         /// </remarks> 
         public string Transform(string expression) {
            IntPtr ReturnStrSize;
            var ReturnStr = Transform_101(h, out ReturnStrSize , expression, (IntPtr)expression.Length);
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Returns each step leading to an expression expansion</summary> 
         /// <param name="expression"> Expression to be transformed +++ See Transform_</param>
         /// <returns> String list containg steps leading up to transform result</returns>
         /// <remarks>
         /// <para>
         ///    Transforms an expression and returns intermediate steps
         /// </para>
         /// </remarks> 
         public String TransformWithSteps(string expression) { return TransformWithSteps_102(h, expression, (IntPtr)expression.Length);          }
         
         /// <summary> Returns string result of transformed text</summary> 
         /// <returns> String result of transformed text</returns>
         /// <remarks>
         /// <para>After performing a text transformation, you may obtain the transformed result with this
         ///    function
         /// </para>
         /// </remarks> 
         public string Str() {
            IntPtr ReturnStrSize;
            var ReturnStr = Str_103(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets the text input that is to be transformed</summary> 
         /// <param name="InputStr"> Text that mast be parsed and modified</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>The text that you want to transform should be passed to this function.
         /// </para>
         /// </remarks> 
         public Transforms Str(string InputStr) { return Str_104(h, InputStr, (IntPtr)InputStr.Length);          }
         
         /// <summary> Returns actual char porsing of data</summary> 
         /// <returns> ... +++ test this; maybe with null-imbedded string</returns>
         /// <remarks>
         /// <para>
         ///    ... 
         /// </para>
         /// </remarks> 
         public string StrData() { return StrData_105(h);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 StrLength() { return (Int64)StrLength_106(h);          }
         
         /// <summary> Sets the index base used in various functions+++</summary> 
         /// <param name="BaseValue"> value representing index of 1st element</param>
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this if you prefer to start by 1 or another non-zero value.  This value is passed on to string objects derived from a parent string.
         ///    Each string may have a different index base.
         /// </para>
         /// </remarks> 
         public Transforms IndexBase(Int64 BaseValue) { return IndexBase_107(h, (IntPtr)BaseValue);          }
         
         /// <summary> Gets the index base used in various functions+++</summary> 
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this to check to see which base is being used.
         /// </para>
         /// </remarks> 
         public Int64 IndexBase() { return (Int64)IndexBase_108(h);          }
         
         /// <summary> Indicates whether text was modified in the most recent Transform operation</summary> 
         /// <returns> True if text was modified in the most recent transformation operation or false otherwise</returns>
         /// <remarks>
         /// <para>
         ///    +++ Maybe rename IsModified; and have one that Sets the value; or maybe IsProperty for this & others.
         ///    If text was modified after a call to Transform, then this function returns True.  When transforming large amounts of text,
         ///    transferring strings back and forth with ReturnStr() can be expensive.  Checking this property allows you to skip unnecessary
         ///    steps when text has not been modified.
         /// </para>
         /// </remarks> 
         public bool WasModified() { return Convert.ToBoolean(WasModified_109(h));          }
         
         /// <summary> Returns the defaults settings for rules</summary> 
         /// <returns> Default rule object</returns>
         /// <remarks>
         /// <para>
         ///    Each FromTo or Find rule has many configurable properties that can be set.  Instead of excplicitely setting all of these many properties
         ///    with each rule definition, you may define default settings that will automatically be assigned to new rules.  Any of these default settings
         ///    can be overridden by explicitely setting the desired property for a given rule.
         /// </para>
         /// </remarks> 
         public Rule RulesDefault() { return RulesDefault_110(h);          }
         
         /// <summary> Returns the overall settings for a transform</summary> 
         /// <returns> Overall rule object</returns>
         /// <remarks>
         /// <para>
         ///    This returns an object containing the properties for a transform or search object.  This object is a Rules object, and conatains the
         ///    same properties listed for individual rules, but works in a slightly different context.  For instance, if you set the StopAfter property
         ///    of FromTo("a", "b") to 5, then it will only change the first five occurences of "a" to "b", whereas if you set the RulesOverall StopAfter
         ///    property to 5, and you have rules FromTo("a", "b") and FromTo("x", "y") then it will stop changing any occurence of either rule, after the
         ///    combined total of changes reaches 5; "a" might change to "b" 2 times and "x" to "y" 3 times, or whichever combination does not total more
         ///    than 5.  You might set QuoteSensitive to "true" overall, while you may set it to false within a given rule.  In certain combinations,
         ///    overall rules may clash with individual rules.  Although all combinations are allowed, not all combinations make sense.  When setting
         ///    the case sensitivity property of individual rules differently from the overall property, keep in mind that if the overall case sensitivity
         ///    is false, then all symbols are stored in the symbol table in all upper case.
         /// </para>
         /// </remarks> 
         public Rule RulesOverall() { return RulesOverall_111(h);          }
         
         /// <summary> Returns a rule object from a transform</summary> 
         /// <param name="Index"> Index of rule</param>
         /// <returns> Rule object</returns>
         /// <remarks>
         /// <para>
         ///    The default rule is located at index -1.  All subsequent rules inherent properties from the default rule.</para>
         /// <para>   If no argument is passed, then Rule returns the next empty new rule in the list.
         /// </para>
         /// </remarks> 
         public Rule Rule(Int64 Index  = 0) { return Rule_112(h, (IntPtr)Index);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_113(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_114(h); h = (IntPtr)0;          }
         
         public static implicit operator Transforms(IntPtr o) { return new Transforms(o);          }
         public Transforms(IntPtr PassedHandle) { h = PassedHandle; hb = h;          }
      } 
      
      /// <summary> Class for rules</summary> 
      public class Rule: Base {
         
         /// <summary> Handle for Rule</summary> 
         public IntPtr h;
         
         /// <summary> Sets whether a rule is active</summary> 
         /// <param name="TrueFalse"> Value that determines case is active</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets whether a rule is active or not.
         ///    When you no longer need a rule, you can release it entirely from memory with Release().  However, at times you may
         ///    want to only temporarily deactivate a transform, and then later reactivate it for further use.  That is when you use
         ///    this function.
         /// </para>
         /// </remarks> 
         public Rule Active(bool TrueFalse) { return Active_115(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         public string FindPart() {
            IntPtr ReturnStrSize;
            var ReturnStr = FindPart_116(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <param name="Pattern"> Pattern for the Find part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         public Rule FindPart(string Pattern) { return FindPart_117(h, Pattern, (IntPtr)Pattern.Length);          }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         public string FromPart() {
            IntPtr ReturnStrSize;
            var ReturnStr = FromPart_118(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets From part of a rule</summary> 
         /// <param name="Pattern"> Pattern for the From part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the From part of a rule.
         /// </para>
         /// </remarks> 
         public Rule FromPart(string Pattern) { return FromPart_119(h, Pattern, (IntPtr)Pattern.Length);          }
         
         /// <summary> Sets To part of a rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the To part of a rule.
         /// </para>
         /// </remarks> 
         public string ToPart() {
            IntPtr ReturnStrSize;
            var ReturnStr = ToPart_120(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets To part of a rule</summary> 
         /// <param name="Pattern"> Pattern for the From part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the To part of a rule.
         /// </para>
         /// </remarks> 
         public Rule ToPart(string Pattern) { return ToPart_121(h, Pattern, (IntPtr)Pattern.Length);          }
         
         /// <summary> Sets whether a rule is case-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines case sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is case-sensitive or not.
         ///    +++ Maybe IsProperty() for this and others
         /// </para>
         /// </remarks> 
         public Rule CaseSensitive(bool TrueFalse) { return CaseSensitive_122(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> ...</summary> 
         /// <param name="TrueFalse"> ...</param>
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>...
         /// </para>
         /// </remarks> 
         public Rule IgnoreInnerPatterns(bool TrueFalse) { return IgnoreInnerPatterns_123(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Sets whether a rule is whitespace-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines whitespace sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is whitespace-sensitive or not.
         /// </para>
         /// </remarks> 
         public Rule WhitespaceSensitive(bool TrueFalse) { return WhitespaceSensitive_124(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Sets bracket sensitivity</summary> 
         /// <param name="TrueFalse"> Value that determines bracket sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is bracket sensitive or not.  When set to True, a pattern will not match if it crosses the boundaries of
         ///    a bracket grouping.</para>
         /// <para>   If set to False, then clode block delimiters are treated as ordinary generic tokens, with no special property as delimiters.</para>
         /// <para>   A bracketed group is a pattern enclosed between tokens defined as a bracket pair.  By default square brackets, [],
         ///    parenthesis, (), and curly braces, {}, are defined as bracket pairs.  However, any string pairs can be defined as
         ///    bracket tokens.</para>
         /// <para>   So, if you define a pattern "a {etc} b", it will match "a x y z b c", "a (x y z) b c", "a (x) (y z) b c", but not "a x y z (b c)",
         ///    because the bracket grouping (b c) crosses the boundary of the "a {etc} b" pattern; the opening parenthesis is found in the would-be match,
         ///    but the closing parenthesis is beyond it, whereas in the other examples, the both opening and closing parenthesis (when present) are
         ///    fully within "a {etc} b".</para>
         /// <para>   Note: Brackets used in pattern definitions take precedence over bracket token pairs.  Therefore you may define a pattern that gives
         ///    brackets a different behavior than the default.
         /// </para>
         /// </remarks> 
         public Rule BracketSensitive(bool TrueFalse) { return BracketSensitive_125(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Returns a local transform object</summary> 
         /// <param name="t"> ...</param>
         /// <returns> Local transform object</returns>
         /// <remarks>
         /// <para>
         ///    When a pattern is matched, you can zoom into the text and perform a local search just within the matched text, independantly
         ///    from the rest of the text outside of the match.  Among various possible uses, it's ideal for parsing escape characters within quotes.
         ///    Such characters are treated differently within the quote than outside the quote.
         /// </para>
         /// </remarks> 
         public Transforms LocalTransform(Transforms t  = null) { return LocalTransform_126(h, t != null ? t.h : (IntPtr)0);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 Maximum() { return (Int64)Maximum_127(h);          }
         
         /// <summary> Sets the soft maximum number of matches of this rule allowed</summary> 
         /// <param name="Value"> Maximum number of matches of this rule allowed</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft maximum number of individual matches that this rule should find in order for any matches
         ///    of this rule to count.  If more than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the maximum is set to 2, then no matches of "a" will be counted at all, because there are more than
         ///    2 occurences of "a" in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
         ///    all the matches would count.</para>
         /// <para>   The default Maximum value is -1, which is the equivalent of no maximum limit.</para>
         /// <para>   If you want to stop counting after a given number of matches of a rule, without invalidating the matches
         ///    that were already found, use StopAfter instead.
         /// </para>
         /// </remarks> 
         public Rule Maximum(Int64 Value) { return Maximum_128(h, (IntPtr)Value);          }
         
         /// <summary> Sets the hard maximum number of matches of this rule allowed</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 MaximumHard() { return (Int64)MaximumHard_129(h);          }
         /// <summary> Sets the hard maximum number of matches of this rule allowed</summary> 
         /// <param name="Value"> Maximum number of matches of this rule allowed</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the maximum number of individual matches that this rule should find in order for any matches
         ///    of this rule to count.  If more than this number of matches are found in the text, then no matches from
         ///    any rule will count (whereas in a soft maximum, only matches from the current rule will be cancelled).
         ///    For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the maximum is set to 2, then no matches of "a" will be counted at all, because there are more than
         ///    2 occurences of "a" in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
         ///    all the matches would count.</para>
         /// <para>   The default Maximum value is -1, which is the equivalent of no maximum limit.</para>
         /// <para>   If you want to stop counting after a given number of matches of a rule, without invalidating the matches
         ///    that were already found, use StopAfter instead.
         /// </para>
         /// </remarks> 
         public Rule MaximumHard(Int64 Value) { return MaximumHard_130(h, (IntPtr)Value);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 Minimum() { return (Int64)Minimum_131(h);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <param name="Value"> Minimum number of matches required of this rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft minimum number of individual matches that this rule should find.</para>
         /// <para>   A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
         ///    reached, then it is considered that there are no matches for this particular rule.  Other rules
         ///    are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
         ///    then the entire search or transform is invalidated, and it's considered that no match of any
         ///    kind is found.</para>
         /// <para>   If less than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the minimum is set to 5, then no matches of "a" will be counted at all, because there are not at least
         ///    5 occurences of "a" in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.</para>
         /// <para>   Default: 0.
         /// </para>
         /// </remarks> 
         public Rule Minimum(Int64 Value) { return Minimum_132(h, (IntPtr)Value);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 MinimumHard() { return (Int64)MinimumHard_133(h);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <param name="Value"> Minimum number of matches required of this rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft minimum number of individual matches that this rule should find.</para>
         /// <para>   A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
         ///    reached, then it is considered that there are no matches for this particular rule.  Other rules
         ///    are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
         ///    then the entire search or transform is invalidated, and it's considered that no match of any
         ///    kind is found.</para>
         /// <para>   If less than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the minimum is set to 5, then no matches of "a" will be counted at all, because there are not at least
         ///    5 occurences of "a" in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.</para>
         /// <para>   Default: 0.
         /// </para>
         /// </remarks> 
         public Rule MinimumHard(Int64 Value) { return MinimumHard_134(h, (IntPtr)Value);          }
         
         /// <summary> Sets the precedence level for a pattern</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 Precedence() { return (Int64)Precedence_135(h);          }
         /// <summary> Sets the precedence level for a pattern</summary> 
         /// <param name="Value"> Precedence level</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    Patterns that start (and/or end) with a pattern variable instead of a token or identifier can
         ///    (and probably should) be assigned a precedence level.  You can choose any arbitrary numerical
         ///    value.  The meaning of the precedence level depends on whether the value is greater, equal, or
         ///    less than adjacent patterns with a precedence level.  It works similarly to precedence levels for
         ///    operators.  For instance, if you define:</para>
         /// <para>   FromTo("{a} + {b}", "({a} + {b})").Precedence(10);
         ///    FromTo("{a} * {b}", "({a} * {b})").Precedence(20);</para>
         /// <para>   Then</para>
         /// <para>   "1 + 2 * 3 + 4" transforms into "(1 + (2 * 3) + 4)"
         ///    "1 * 2 + 3 * 4" transforms into "(1 * 2) + (3 * 4)"
         /// </para>
         /// </remarks> 
         public Rule Precedence(Int64 Value) { return Precedence_136(h, (IntPtr)Value);          }
         
         /// <param name="SelectedProperty"> ...</param>
         /// <param name="TrueFalse"> ...</param>
         public Rule Property(ItemIsEnum SelectedProperty ,bool TrueFalse) { return Property_137(h, SelectedProperty , Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Sets quote sensitivity</summary> 
         /// <param name="TrueFalse"> Value that determines quote sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is quote sensitive or not.
         ///    Quote sensitivity is generally designed for use across all rules in a transform (or sub transform).  However,
         ///    it can also be set in for the context of an individual pattern.  [One exception is within text that matches a pattern variable.+++]</para>
         /// <para>   When set to true, it means that a block of text within quotes is treated as one token.  As such patterns are not searched for
         ///    within the quotes.  The contents of the quotes are skipped over.  You may still get around this and parse within quotes when
         ///    necessary, by capturing the quote character itself, then parsing subsequent text.</para>
         /// <para>   The actual character(s) used as quotes are configurable with DefineToken.
         /// </para>
         /// </remarks> 
         public Rule QuoteSensitive(bool TrueFalse) { return QuoteSensitive_138(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Returns the replacement text of a FromTo rule</summary> 
         /// <returns> String representing the second argument that was used in FromTo</returns>
         /// <remarks>
         /// <para>This allows you to keep track of the replacement text of any given rule, even after it has been defined.</para>
         /// </remarks> 
         public string ReplacementText() {
            IntPtr ReturnStrSize;
            var ReturnStr = ReplacementText_139(h, out ReturnStrSize );
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Sets the number of matches this rule must find before matches start counting</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 StartAfter() { return (Int64)StartAfter_140(h);          }
         
         /// <summary> Sets the number of matches this rule must find before matches start counting</summary> 
         /// <param name="Value"> Number of matches that must be found before matches start counting</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets a number of individual matches that this rule should find first.  These first few matches are
         ///    not counted in the results.  Onlny matches starting after this number of initial matches are counted.
         ///    If less than this number of matches are found in the text, no match will count.  For instance if a rule
         ///    searches for matches of "a" in "a a r d v a r k", starting after 2, then only the 3rd "a" (the one between
         ///    "v" and "r") will count.  If StartAfter is set to 3, there will be no matches.  If StartAfter is 1, then
         ///    then the 2nd and 3rd occurences of "a" will count as matches.</para>
         /// <para>   The default StartAfter value is 0.  This means all matches that are found will count.
         /// </para>
         /// </remarks> 
         public Rule StartAfter(Int64 Value) { return StartAfter_141(h, (IntPtr)Value);          }
         
         /// <summary> Sets the number of matches after which this rule should stop finding matches</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 StopAfter() { return (Int64)StopAfter_142(h);          }
         
         /// <summary> Sets the number of matches after which this rule should stop finding matches</summary> 
         /// <param name="Value"> Number of matches after which it should stop finding matches</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets a number of individual matches that this rule should find.  After this number of matches
         ///    are found, all other matches for this rule are ignored.  For instance if a rule searches for matches
         ///    of "a" in "a a r d v a r k", and stops after 2, then only the first two letters here wil match; the
         ///    third "a" (the one between "v" and "r") will not count as a match.</para>
         /// <para>   The default StopAfter value is -1, which means it will not stop counting matches for this rule.</para>
         /// <para>   This function has some similarities with Max.  However, with Max, if the maximum value is not attained,
         ///    none of the matches will count.
         /// </para>
         /// </remarks> 
         public Rule StopAfter(Int64 Value) { return StopAfter_143(h, (IntPtr)Value);          }
         
         /// <summary> Determines whether a given match is skipped over</summary> 
         /// <param name="TrueFalse"> Value that determines with match is skipped over</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>If SkipOver is set to true, then text that matches this pattern will be skipped over.
         ///    This is useful for preventing uCalc from searching for matches of any other rules within
         ///    certain text you want to skip over.</para>
         /// <para>   For instance if you skip over "({etc})", then everything in parenthesis will be skipped over.
         ///    So if you want to find occurences of "a" in "a b c (a b c a b c) a b c", it will find all occurences
         ///    of "a", except those within parenthesis, because everything in parenthesis is being skipped over.</para>
         /// <para>   Default: False
         /// </para>
         /// </remarks> 
         public Rule SkipOver(bool TrueFalse) { return SkipOver_144(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Determines whether to rewind back to the start of modified text for further parsing</summary> 
         /// <param name="TrueFalse"> Value that determines if parser should rewind and parse again after a change</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>After text is modified with the replacement text of a rule, if this value is false (default),
         ///    then uCalc will continue parsing from the position just after the insertion of the modified text.
         ///    If this property is set to true, then the parser will rewind to the location where the match was
         ///    found, and parse again, which will allow it to potentially find additional matches (of any rule,
         ///    not just the current one) within the already modified text.</para>
         /// <para>   This property can be extremely useful in many situations.  However, special care should be taken
         ///    so that an infinite reparsing session doesn't take place.  For instance, if a rule changes A to B,
         ///    and another rule changes B to A, and this property is set ot true, and a Maximum value is not set,
         ///    and there is an occurence of A, then A will change to B.  B will be parsed again and changed to A.
         ///    The cycle will repeat itself indefinitely.</para>
         /// <para>   Default: False
         /// </para>
         /// </remarks> 
         public Rule RewindOnChange(bool TrueFalse) { return RewindOnChange_145(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Sets whether a rule is case-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines case sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is case sensitive or not.
         /// </para>
         /// </remarks> 
         public Rule RightToLeft(bool TrueFalse) { return RightToLeft_146(h, Convert.ToInt32(TrueFalse));          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_147(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_148(h); h = (IntPtr)0;          }
         
         public static implicit operator Rule(IntPtr o) { return new Rule(o);          }
         public Rule(IntPtr PassedHandle) { h = PassedHandle; hb = h;          }
      } 
      
      /// <summary> Class for collection of tokens</summary> 
      public class Tokens: Base {
         
         /// <summary> Handle for tokens</summary> 
         public IntPtr h;
         
         /// <summary> Imports tokens from another token list</summary> 
         /// <param name="FromTokenList"> Token list to import +++ BYREF IntPtr(Tokens) ; +++ 2nd arg for Append</param>
         /// <returns> Object containing list of tokens</returns>
         /// <remarks>
         /// <para>
         ///    Instead of defining a set of tokens each time, you may import a pre-existing token list.  This function imports from
         ///    another token list object.  To import from a file, use Import (File).
         /// </para>
         /// </remarks> 
         public Tokens Import(IntPtr FromTokenList) { return Import_149(h, FromTokenList);          }
         
         /// <summary> Defines a new token</summary> 
         /// <param name="TokenDef"> Token definition</param>
         /// <param name="TokenType"> The type of token</param>
         /// <param name="CloseBracket"> String representing closing bracket, such as "}", ")", "]", etc.</param>
         /// <param name="SubMatch"> Submatch</param>
         /// <param name="RegExGrammar"> Type of RegEx grammar</param>
         /// <returns> Token item object</returns>
         /// <remarks>
         /// <para>
         ///    uCalc comes with a default set of tokens.  These are general tokens for things like numbers alphanumeric words, whitespace, quotes,
         ///    parenthesis, etc.  However you may define your own tokens to the exact specifications that you need.</para>
         /// <para>   A token is defined using a Regular Expression.</para>
         /// <para>   A token type can be any of those listed under TokenEnum (except for None).</para>
         /// <para>   Bracket tokens (such as parenthesis, square brackets, or curly braces) are typically defined as pairs.  So if "(", ")"
         ///    are defined as a token pair, then CloseBracket would be ")".</para>
         /// <para>   In cases where you want a submatch within the token, and not the whole token, use the SubMatch argument with a numerical
         ///    value represent the numerical index used in the regular expression.
         /// </para>
         /// </remarks> 
         public Item Define(string TokenDef ,TokenEnum TokenType = TokenEnum.Generic,string CloseBracket  = "",Int64 SubMatch  = 0,RegExGrammarEnum RegExGrammar = RegExGrammarEnum.RegEx_Default) { return Define_150(h, TokenDef, (IntPtr)TokenDef.Length , TokenType, CloseBracket, (IntPtr)CloseBracket.Length, (IntPtr)SubMatch, RegExGrammar);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_151(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_152(h); h = (IntPtr)0;          }
         
         public static implicit operator Tokens(IntPtr o) { return new Tokens(o);          }
         public Tokens(IntPtr PassedHandle) { h = PassedHandle; hb = h;          }
      } 
      
      /// <summary> uCalc string library class</summary> 
      public class String {
         
         /// <summary> Handle for uCalc String Library instance</summary> 
         public IntPtr h;
         
         /// <summary> ...</summary> 
         /// <param name="StartIndex"> ...</param>
         /// <param name="Count"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 TokenCharLen(Int64 StartIndex ,Int64 Count  = 1) { return (Int64)TokenCharLen_153(h, (IntPtr)StartIndex , (IntPtr)Count);          }
         
         /// <summary> Returns the numbers of tokens in the string</summary> 
         /// <param name="Index"> Index of match+++</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         public Int64 TokenCount(Int64 Index  = -1) { return (Int64)TokenCount_154(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public TokenEnum TokenType(Int64 Index) { return TokenType_155(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="OtherString"> ...</param>
         /// <param name="IndexA"> ...</param>
         /// <param name="IndexB"> ...</param>
         /// <param name="Length"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public uCalcCompareEnum Compare(string OtherString ,Int64 IndexA  = 0,Int64 IndexB  = 0,Int64 Length  = -1) { return Compare_156(h, OtherString, (IntPtr)OtherString.Length , (IntPtr)IndexA, (IntPtr)IndexB, (IntPtr)Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 TokenIndexAtChar(Int64 Index) { return (Int64)TokenIndexAtChar_157(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="expression"> ...</param>
         /// <param name="Variable"> Name of variable</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String Apply(string expression ,string Variable  = "") { return Apply_158(h, expression, (IntPtr)expression.Length , Variable, (IntPtr)Variable.Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String At(Int64 Index) { return At_159(h, (IntPtr)Index);          }
         
         /// <summary> +++
         /// <param name="Index"> Index of charactor location</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo
         /// </para>
         /// </remarks> 
         public String AtChar(Int64 Index) { return AtChar_160(h, (IntPtr)Index);          }
         
         /// <summary> +++</summary> 
         /// <param name="Index"> Index of token location</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo
         /// </para>
         /// </remarks> 
         public String AtToken(Int64 Index) { return AtToken_161(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String BracketMatch(Int64 Index) { return BracketMatch_162(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String BracketedText(Int64 Index) { return BracketedText_163(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String BracketedTextInside(Int64 Index) { return BracketedTextInside_164(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 BracketMatchTokenIndex(Int64 Index) { return (Int64)BracketMatchTokenIndex_165(h, (IntPtr)Index);          }
         
         /// <summary>...</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         public Int64 CharPos(Int64 Nth  = -1) { return (Int64)CharPos_166(h, (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 CharCount(Int64 Nth  = -1) { return (Int64)CharCount_167(h, (IntPtr)Nth);          }
         
         /// <summary> Returns the numbers of tokens in the string</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         public Int64 TokenPos(Int64 Nth  = -1) { return (Int64)TokenPos_168(h, (IntPtr)Nth);          }
         
         /// <summary> Returns the character position of a token</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         public Int64 TokenCharPos(Int64 Index) { return (Int64)TokenCharPos_169(h, (IntPtr)Index);          }
         
         /// <summary> Retrieves the string value of a uCalc String object</summary> 
         /// <param name="Nth"> Index of match</param>
         /// <param name="TokenCount"> Number of tokens</param>
         /// <returns> String value of the uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    This retrieves the string value associated with a uCalc String object.
         ///    +++ This is optional unless you are retrieving the index of a match.
         ///    Use Str(n) when you just want the string representation of a value.
         ///    Use Match(n) when you want uCalc String Object that you can manipulate further.
         /// </para>
         /// </remarks> 
         public string Str(Int64 Nth  = -1,Int64 TokenCount  = 1) {
            IntPtr ReturnStrSize;
            var ReturnStr = Str_170(h, out ReturnStrSize , (IntPtr)Nth, (IntPtr)TokenCount);
            return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
         }
         
         /// <summary> Assigns a string value to the uCalc String object</summary> 
         /// <param name="StringValue"> New string value +++ Should probably add Index arg</param>
         /// <remarks>
         /// <para>
         ///    This assigns a new string to the uCalc String object.
         /// </para>
         /// </remarks> 
         public String Str(string StringValue) { return Str_171(h, StringValue, (IntPtr)StringValue.Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///      ...
         /// </para>
         /// </remarks> 
         public String Find(string Pattern ,Int64 Nth  = 1) { return Find_172(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String FindOtherThan(string Pattern ,Int64 Nth  = 1) { return FindOtherThan_173(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> Returns the immediate parent of the current string</summary> 
         /// <remarks>
         /// <para></para>
         /// <para></para>
         /// </remarks> 
         public String Parent() { return Parent_174(h);          }
         
         /// <summary> Returns the immediate parent of the current string</summary> 
         /// <remarks>
         /// <para></para>
         /// <para></para>
         /// </remarks> 
         public String Root() { return Root_175(h);          }
         
         /// <summary> Sets the index base used in various functions</summary> 
         /// <param name="BaseValue"> value representing index of 1st element</param>
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this if you prefer to start by 1 or another non-zero value.  This value is passed on to string objects derived from a parent string.
         ///    Each string may have a different index base.
         /// </para>
         /// </remarks> 
         public String IndexBase(Int64 BaseValue) { return IndexBase_176(h, (IntPtr)BaseValue);          }
         
         /// <summary> Gets the index base used in various functions</summary> 
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this to check to see which base is being used.
         /// </para>
         /// </remarks> 
         public Int64 IndexBase() { return (Int64)IndexBase_177(h);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String UpTo(string Pattern ,Int64 Nth  = 1) { return UpTo_178(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String StartingFrom(string Pattern ,Int64 Nth  = 1) { return StartingFrom_179(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="StartPattern"> ...</param>
         /// <param name="EndPattern"> ...</param>
         /// <param name="StartNth"> ...</param>
         /// <param name="EndNth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String StartingFromEndingWith(string StartPattern ,string EndPattern ,Int64 StartNth  = 1,Int64 EndNth  = 1) { return StartingFromEndingWith_180(h, StartPattern, (IntPtr)StartPattern.Length , EndPattern, (IntPtr)EndPattern.Length , (IntPtr)StartNth, (IntPtr)EndNth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String Before(string Pattern ,Int64 Nth  = 1) { return Before_181(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String After(string Pattern ,Int64 Nth  = 1) { return After_182(h, Pattern, (IntPtr)Pattern.Length , (IntPtr)Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="StartPattern"> Pattern</param>
         /// <param name="StopPattern"> Pattern 2</param>
         /// <param name="StartNth"> Nth match</param>
         /// <param name="StopNth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String Between(string StartPattern ,string StopPattern ,Int64 StartNth  = 1,Int64 StopNth  = 1) { return Between_183(h, StartPattern, (IntPtr)StartPattern.Length , StopPattern, (IntPtr)StopPattern.Length , (IntPtr)StartNth, (IntPtr)StopNth);          }
         
         /// <summary> Returns list of tokens</summary> 
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         public String ListOfTokens() { return ListOfTokens_184(h);          }
         
         /// <summary> Returns list of tokens</summary> 
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         public String ListOfChars() { return ListOfChars_185(h);          }
         
         /// <summary> Returns substring</summary> 
         /// <param name="StartPos"> Starting position</param>
         /// <param name="Length"> Length of substring</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         public String SubString(Int64 StartPos ,Int64 Length  = -1) { return SubString_186(h, (IntPtr)StartPos , (IntPtr)Length);          }
         
         /// <summary> Sets rules for when a child object is created</summary> 
         /// <param name="Option"> +++</param>
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    Many functions create a new string object derived from another given object.  This option determins the persistence of previously
         ///    derived objects.  The right option depends on what you want to do.  If you're looking to conserve memory, then ClearAll is may be the
         ///    option you need.  However, with this option, you can no longer refer to previously derived strings, otherwise the behavior will be
         ///    undefined (such as crashing).  You may delay object deletetion be removing only the ones that overlap in location with the newly derived
         ///    string.  The decision to delete may be delayed based on when if object is being written to.   ClearOverlapOnWrite, allows you to
         ///    to have multiple overlapping views of the same parent string without any conflict.  Only when modifying a derived string are overlapped
         ///    derived strings removed.  Corresponding Detach options are similar, except that instead of actually erasing an overlapping object, it
         ///    is disassassiated from the parent string.  It can continue to be used as an independent string without undefined behavior.  With this
         ///    option, the independent strings are erased only when the parent string itself is erased.</para>
         /// <para></para>
         /// </remarks> 
         public String ChildStringOption(ChildStringOptionEnum Option) { return ChildStringOption_187(h, Option);          }
         
         /// <summary> Gets the option</summary> 
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         public ChildStringOptionEnum ChildStringOption() { return ChildStringOption_188(h);          }
         
         /// <summary> Clears derived strings from memory</summary> 
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         public String ClearDerivedStrings() { return ClearDerivedStrings_189(h);          }
         
         /// <summary> todo</summary> 
         /// <param name="From_"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String Remove(string From_) { return Remove_190(h, From_, (IntPtr)From_.Length);          }
         
         /// <summary> todo</summary> 
         /// <param name="From_"> ...</param>
         /// <param name="To_"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String Replace(string From_ ,string To_) { return Replace_191(h, From_, (IntPtr)From_.Length , To_, (IntPtr)To_.Length);          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String Skip(string Pattern) { return Skip_192(h, Pattern, (IntPtr)Pattern.Length);          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String ToUpper(string Pattern  = "",Int64 Nth  = -1) { return ToUpper_193(h, Pattern, (IntPtr)Pattern.Length, (IntPtr)Nth);          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String ToLower(string Pattern  = "",Int64 Nth  = -1) { return ToLower_194(h, Pattern, (IntPtr)Pattern.Length, (IntPtr)Nth);          }
         
         /// <summary> todo</summary> 
         /// <param name="ListType"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo
         /// </para>
         /// </remarks> 
         public String List(uCalcList ListType = uCalcList.Matches) { return List_195(h, ListType);          }
         
         /// <summary> todo</summary> 
         /// <param name="Separator"> ...</param>
         /// <param name="Prefix"> ...</param>
         /// <param name="Postfix"> ...</param>
         /// <param name="UserFunc"> ...</param>
         /// <param name="Element"> ...</param>
         /// <param name="Index"> ...</param>
         /// <param name="Count"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++ Maybe rename for clarity
         /// </para>
         /// </remarks> 
         public String ListFormat(string Separator ,string Prefix  = "",string Postfix  = "",string UserFunc  = "",string Element  = "",string Index  = "",string Count  = "") { return ListFormat_196(h, Separator, (IntPtr)Separator.Length , Prefix, (IntPtr)Prefix.Length, Postfix, (IntPtr)Postfix.Length, UserFunc, (IntPtr)UserFunc.Length, Element, (IntPtr)Element.Length, Index, (IntPtr)Index.Length, Count, (IntPtr)Count.Length);          }
         
         /// <summary> Sets the separator that will delimite the elements of a list</summary> 
         /// <param name="Separator"> Separator that will delimite each element of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         public String ListSeparator(string Separator) { return ListSeparator_197(h, Separator, (IntPtr)Separator.Length);          }
         
         /// <summary> Sets the prefix that is inserted at the start of lists</summary> 
         /// <param name="Prefix"> Prefix that will be inserted at the start of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         public String ListPrefix(string Prefix) { return ListPrefix_198(h, Prefix, (IntPtr)Prefix.Length);          }
         
         /// <summary> Sets the postfix that is inserted at the end of lists</summary> 
         /// <param name="Postfix"> Postfix that will be inserted at the end of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         public String ListPostfix(string Postfix) { return ListPostfix_199(h, Postfix, (IntPtr)Postfix.Length);          }
         
         /// <summary> Sets the formatting for displaying the elements of a list</summary> 
         /// <param name="UserFunc"> +++</param>
         /// <param name="Element"> +++</param>
         /// <param name="Index"> +++</param>
         /// <param name="MatchCount"> +++</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         public String ListFunction(string UserFunc ,string Element  = "",string Index  = "",string MatchCount  = "") { return ListFunction_200(h, UserFunc, (IntPtr)UserFunc.Length , Element, (IntPtr)Element.Length, Index, (IntPtr)Index.Length, MatchCount, (IntPtr)MatchCount.Length);          }
         
         /// <summary> todo</summary> 
         /// <param name="first"> ...</param>
         /// <param name="last"> ...</param>
         /// <param name="expression"> ...</param>
         /// <param name="Step"> ...+++ use "Escaped names" [Step] in VB to avoid keyword conflict</param>
         /// <param name="Condition"> ...</param>
         /// <param name="VarIndex"> ...</param>
         /// <param name="VarFirst"> ...</param>
         /// <param name="VarLast"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String Populate(double first ,double last ,string expression ,double Step  = 1,string Condition  = "",string VarIndex  = "",string VarFirst  = "",string VarLast  = "") { return Populate_201(h, first , last , expression, (IntPtr)expression.Length , Step, Condition, (IntPtr)Condition.Length, VarIndex, (IntPtr)VarIndex.Length, VarFirst, (IntPtr)VarFirst.Length, VarLast, (IntPtr)VarLast.Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public String Match(Int64 Index) { return Match_202(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> Index of the character who's match index you want</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 MatchIndexAtChar(Int64 Index) { return (Int64)MatchIndexAtChar_203(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> Index of the token who's match index you want</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 MatchIndexAtToken(Int64 Index) { return (Int64)MatchIndexAtToken_204(h, (IntPtr)Index);          }
         
         /// <summary> todo</summary> 
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String NonMatches() { return NonMatches_205(h);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ... +++ ???
         /// </para>
         /// </remarks> 
         public String SubMatch(Int64 Index) { return SubMatch_206(h, (IntPtr)Index);          }
         
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         public Int64 MatchCount() { return (Int64)MatchCount_207(h);          }
         
         /// <summary> todo</summary> 
         /// <param name="tt"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         public String Transform(Transforms tt) { return Transform_208(h, tt != null ? tt.h : (IntPtr)0);          }
         
         public String() { h = Default().NewString().h;          }
         public String(String Instance) { h = Instance.h;          }
         public String(string s) { h = Default().NewString(s).h;          }
         public static implicit operator string(String ucString) { return ucString.Str();          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         public IntPtr Handle() { return Handle_209(h);          }
         
         /// <summary> +++ comment for each</summary> 
         public void Release() { if (h != (IntPtr)0) Release_210(h); h = (IntPtr)0;          }
         
         public static implicit operator String(IntPtr o) { return new String(o);          }
         public String(IntPtr PassedHandle) { h = PassedHandle;          }
      } 
      
      /// <summary> Handle for uCalc instance</summary> 
      public IntPtr h;
      
      /// <summary> Adds an error handler</summary> 
      /// <param name="ErrorHandlerAddress"> Address of the callback function containing the error handler code</param>
      /// <param name="Position"> Position in which to insert the error handler</param>
      /// <returns> The error handler can later be removed using this return object</returns>
      /// <remarks>
      /// <para>Use this to set a a callback function that is called whenever there is an error.  Your callback can
      /// do things like alert the user of the error, correct the error and resume, keep a log of errors, etc.</para>
      /// <para>By default, if there are multiple error handlers, they are called starting with the most recently
      /// defined one first, ending with the first one to be defined last.  In order to define a handler in a different
      /// order, specify the Position value of where it should be inserted; 0 so that it is called first, -1 so it
      /// is called last, or a positive integer indicated where it should be inserted.  If the Postion value is out
      /// of bounds, it is adjusted into the maximum acceptable value.</para>
      /// <para>If you set ErrorResponse to ErrorHandlerResponseEnum.ErrorResume, subsequent error handler callbacks will
      /// be bypassed and uCalc will resume operations as though no error had taken place.  Note that the condition
      /// that caused the error must be corrected before resuming, otherwise uCalc may get stuck in an infinite loop.</para>
      /// <para>Some functions, such as ErrorExpression, ErrorLocation, and ErrorSymbol produce a meaningful result only
      /// during the parsing stage.  They do not cause other problems beyond meaningless data during the evaluation stage.
      /// </para>
      /// </remarks> 
      public Item AddErrorHandler(uCalcDelegate ErrorHandlerAddress ,Int64 Position  = 0) { return AddErrorHandler_211(h, ErrorHandlerAddress , (IntPtr)Position);       }
      
      /// <summary> Creates a new uCalc instance</summary> 
      /// <param name="BasedOn"> ...</param>
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      public static uCalc Create(uCalc BasedOn  = null) { return Create_212(default(IntPtr), BasedOn != null ? BasedOn.h : (IntPtr)0);       }
      
      /// <summary> Creates a new uCalc instance 
      /// <param name="BasedOn"> ...</param>
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      public static uCalc CreateTempDefault(uCalc BasedOn  = null) { return CreateTempDefault_213(default(IntPtr), BasedOn != null ? BasedOn.h : (IntPtr)0);       }
      
      /// <summary> Creates a new uCalc instance  +++Maybe rename TempDefaultRelease()</summary> 
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      public static uCalc ReleaseTempDefault() { return ReleaseTempDefault_214(default(IntPtr));       }
      
      /// <summary> Adds an alias to an existing symbol</summary> 
      /// <param name="NewSymbol"> New symbol that will be set as equivalent to an existing symbol</param>
      /// <param name="ExistingSymbol"> Pre-existing symbol</param>
      /// <remarks>
      /// <para>
      /// This function creates a new symbol that is pegged to an existing symbol.  Whenever this new symbol is encountered by the parser,
      /// it will be the same as if it had encountered the pre-existing symbol this new symbol is an alias of.  This new symbol shares the same handle as the
      /// pre-existing symbol within the symbol table.  The new symbol actually has its own handle, but that handle can only be used to delete the item.
      /// The pre-existing handle is used for all other purposes.</para>
      /// <para>For simple situations where you just want two symbols to be considered equivalent by the parser, Alias is prefered as a more efficient option over
      /// ExpressionTransforms().FromTo().</para>
      /// <para></para>
      /// </remarks> 
      public Item Alias(string NewSymbol ,string ExistingSymbol) { return Alias_215(h, NewSymbol, (IntPtr)NewSymbol.Length , ExistingSymbol, (IntPtr)ExistingSymbol.Length);       }
      
      /// <summary> Adds an alias to an existing symbol</summary> 
      /// <param name="NewSymbol"> New symbol that will be set as equivalent to an existing symbol</param>
      /// <param name="ExistingItem"> Pre-existing item</param>
      /// <remarks>
      /// <para>
      /// This function creates a new symbol that is pegged to an existing symbol.  Whenever this new symbol is encountered by the parser,
      /// it will be the same as if it had encountered the pre-existing symbol this new symbol is an alias of.  This new symbol shares the same handle as the
      /// pre-existing symbol within the symbol table.  The new symbol actually has its own handle, but that handle can only be used to delete the item.
      /// The pre-existing handle is used for all other purposes.</para>
      /// <para>This version of Alias uses an Item object as second argument.  It is a little more efficient than the one that uses a string (the string version calls
      /// the internal version of this function).
      /// </para>
      /// </remarks> 
      public Item Alias(string NewSymbol ,Item ExistingItem) { return Alias_216(h, NewSymbol, (IntPtr)NewSymbol.Length , ExistingItem != null ? ExistingItem.h : (IntPtr)0);       }
      
      /// <summary> Adds an alias name to an existing command name for Define()</summary> 
      /// <param name="NewCommandName"> New command name that will be set as equivalent to an existing command name</param>
      /// <param name="ExistingCommandName"> Pre-existing command name</param>
      /// <remarks>
      /// <para>
      /// This creates an alternative command name for use with the Define() function.
      /// </para>
      /// </remarks> 
      public void AliasForDefine(string NewCommandName ,string ExistingCommandName) { AliasForDefine_217(h, NewCommandName, (IntPtr)NewCommandName.Length , ExistingCommandName, (IntPtr)ExistingCommandName.Length);       }
      
      /// <summary> Returns the data type of the expression that was passed</summary> 
      /// <param name="expression"> Expression whose data type will be returned</param>
      /// <remarks>
      /// <para>
      ///    +++ Maybe consolidate with GetDataType
      ///    Returns the data type of the expression that was passed
      /// </para>
      /// </remarks> 
      public DataType DataTypeOf(string expression) { return DataTypeOf_218(h, expression, (IntPtr)expression.Length);       }
      
      /// <summary> Returns a data type object</summary> 
      /// <param name="Index"> Index associated with the data type</param>
      /// <remarks>
      /// <para>Each instance of uCalc has its own separate handle & data type object for any given data type.  For
      /// instance, Item("Int64") in one instance of uCalc is not the same object as Item("Int64") from
      /// another uCalc instance.  This allows the same data type to have a different name and different formatting
      /// in different instances.  However, they share the same data type index across instances.  Given the index
      /// of a data type, you can directly obtain the proper data type object for a particular uCalc instance,
      /// faster than obtaining it by name as text with Item().
      /// </para>
      /// </remarks> 
      public DataType DataTypeOf(BuiltInTypesEnum Index) { return DataTypeOf_219(h, Index);       }
      
      /// <summary> Defines a uCalc.Item object (a constunction, function, operator, variable, etc)</summary> 
      /// <param name="expression"> Text containing item to be defined.  expression must start with a keyword such as Function, Operator, Variable, Token, Syntax, etc., followed by a colon, before the expression</param>
      /// <param name="Address"> Address a function or variable is attached to</param>
      /// <param name="dType"> ...</param>
      /// <remarks>
      /// <para>Functions, operators, variables, constants, tokens, syntax constructs, etc., can be defined with
      /// this method.  Although there are specialized methods that do the same things, such as DefineFunction,
      /// DefineOperator, DefineVariable, and DefineConstant, this method may in same cases offer
      /// more flexibility.</para>
      /// <para>The expression must be preceded by a keyword and colon, such as "Variable:".  For a full list of keywords,
      /// see Definition Keywords.</para>
      /// <para>Sections are separated by ~~ (two tilda signs).
      /// </para>
      /// </remarks> 
      public Item Define(string expression ,IntPtr Address = default(IntPtr),DataType dType  = null) { return Define_220(h, expression, (IntPtr)expression.Length , Address, dType != null ? dType.h : (IntPtr)0);       }
      
      /// <summary> Defines a constant</summary> 
      /// <param name="Definition"> Text containing constant to be defined</param>
      /// <param name="VariableAddress"> Address the constant is attached to</param>
      /// <remarks>
      /// <para>
      /// A constant definition is similar to that of a variable defined with DefineVariable, except that the end-user is not allowed to modify the value of a constant.
      /// You are, however, allowed to perform lower-level operations such as renaming a constant, or deleting it and re-defining a new constant or variable with the same
      /// name but different value.  If you attach the constant to the address of a variable in your host program, the host program may change the value.  However, when
      /// the end-user attempts to assign a value to the constant, an error is raised.</para>
      /// <para>DefineConstant("x") is the same as: Define("Lock ~~ Variable: x")
      /// </para>
      /// </remarks> 
      public Item DefineConstant(string Definition ,IntPtr VariableAddress = default(IntPtr)) { return DefineConstant_221(h, Definition, (IntPtr)Definition.Length , VariableAddress);       }
      
      /// <summary> Defines a function</summary> 
      /// <param name="Definition"> Text containing function to be defined</param>
      /// <param name="FunctionAddr"> Address of callback function this function is attached to</param>
      /// <remarks>
      /// <para>
      /// A function definition can either be self-contained, or it may be attached to the address of a callback function in your
      /// source code.</para>
      /// <para>DefineFunction("f(x) = ...") is the same as: Define("Function: ...")
      /// </para>
      /// </remarks> 
      public Item DefineFunction(string Definition ,uCalcDelegate FunctionAddr = null) { return DefineFunction_222(h, Definition, (IntPtr)Definition.Length , FunctionAddr);       }
      
      /// <summary> Defines an operator</summary> 
      /// <param name="Definition"> Text containing operator to be defined</param>
      /// <param name="iPrecedence"> Precedence level of the operator. +++ Rename</param>
      /// <param name="Grouping"> Operator associativity; arithmetic operators are typically grouped left-to-right; special operators, such as the equal sign, =, assignment operator are right-to-left</param>
      /// <param name="FunctionAddr"> Address of callback function this operator is attached to</param>
      /// <remarks>
      /// <para>
      /// Many details for defining an operator are similar to those of defining a function.  In additionn, all operators must be
      /// defined with a precedence level.  You may use the Precedence function to obtain precedence levels of existing operators,
      /// and select a precedence level in comparison to those operators.  By default operators are grouped left to right.  But you
      /// may also set it to right to left.  This means that when adjacent operators have the same precedence level, the operands on
      /// the right will be evaluated first.</para>
      /// <para>DefineOperator("...") is the same as: Define("Operator: ...")
      /// More later+++
      /// </para>
      /// </remarks> 
      public Item DefineOperator(string Definition ,Int64 iPrecedence ,GroupingEnum Grouping = GroupingEnum.GroupLeftToRight,uCalcDelegate FunctionAddr = null) { return DefineOperator_223(h, Definition, (IntPtr)Definition.Length , (IntPtr)iPrecedence , Grouping, FunctionAddr);       }
      
      /// <summary> Defines a variable</summary> 
      /// <param name="Definition"> Text containing variable to be defined</param>
      /// <param name="VariableAddress"> Address of variable in host program this uCalc variable is attached to</param>
      /// <remarks>
      /// <para>
      /// A variable consists of ...</para>
      /// <para>DefineVariable("...") is the same as: Define("Variable: x")
      /// </para>
      /// </remarks> 
      public Item DefineVariable(string Definition ,IntPtr VariableAddress = default(IntPtr)) { return DefineVariable_224(h, Definition, (IntPtr)Definition.Length , VariableAddress);       }
      
      /// <summary> Returns the expression associated with an error that was raised</summary> 
      public string ErrorExpression() {
         IntPtr ReturnStrSize;
         var ReturnStr = ErrorExpression_225(h, out ReturnStrSize );
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> Sets a new expression after an error is raised</summary> 
      /// <param name="expression"> Error expression</param>
      public void ErrorExpression(string expression) { ErrorExpression_226(h, expression, (IntPtr)expression.Length);       }
      
      /// <summary> Returns the location of an error that was raised</summary> 
      public Int64 ErrorLocation() { return (Int64)ErrorLocation_227(h);       }
      
      /// <summary> Returns a message associated with the error that was raised</summary> 
      /// <param name="Index"> Index of error message to return</param>
      /// <remarks>
      /// <para>If an error was raised, this returns a message describing the recent error.  If the Index argument is specified,
      /// then the error message associated with this Index is returned.  A value must be chosen from ErrorNumberEnum.</para>
      /// <para>Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
      /// </para>
      /// </remarks> 
      public string ErrorMessage(ErrorNumberEnum Index = ErrorNumberEnum.Err_None) {
         IntPtr ReturnStrSize;
         var ReturnStr = ErrorMessage_228(h, out ReturnStrSize , Index);
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> Returns the error number of the error that was raised</summary> 
      /// <remarks>
      /// <para>
      /// Returns the error number of the most recently raised error.</para>
      /// <para>Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
      /// </para>
      /// </remarks> 
      public ErrorNumberEnum ErrorNumber() { return ErrorNumber_229(h);       }
      
      /// <summary> Sets the error response for an error handler</summary> 
      /// <param name="Response"> Indicates what should happen now that an error is raised</param>
      /// <remarks>
      /// <para>When an error is raised, you have the option of aborting the rest of the option (which is the default option),
      /// or you may correct the problem, and then resume the operation.  Or you may perform an action, and than raise the
      /// error again for a subsequent error handle to take care of.</para>
      /// <para>This method can only be called from within a callback of an error handler routine definined with AddErrorHandler.
      /// The options to use can be found at ErrorHandlerResponseEnum.
      /// </para>
      /// </remarks> 
      public void ErrorResponse(ErrorHandlerResponseEnum Response) { ErrorResponse_230(h, Response);       }
      
      /// <summary> Returns the symbol associated with the error that is raised</summary> 
      public string ErrorSymbol() {
         IntPtr ReturnStrSize;
         var ReturnStr = ErrorSymbol_231(h, out ReturnStrSize );
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> Parses and evaluates an expression in one step</summary> 
      /// <param name="expression"> Expression to be evaluated</param>
      /// <remarks>
      /// <para>This takes a math expression and returns a numeric result.</para>
      /// </remarks> 
      public double Eval(string expression) { return Eval_232(h, expression, (IntPtr)expression.Length);       }
      
      /// <summary> Parses and evaluates an expression of any data type in one step, returning the result as a string</summary> 
      /// <param name="expression"> Expression to be evaluated</param>
      /// <remarks>
      /// <para>This is similar to Eval, however, it can return non-numeric results, such as strings.</para>
      /// </remarks> 
      public string EvalStr(string expression) {
         IntPtr ReturnStrSize;
         var ReturnStr = EvalStr_233(h, out ReturnStrSize , expression, (IntPtr)expression.Length);
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> Causes division by 0 errors to be raised</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead of silently returning a special value when a division by 0 or pole error occurs.
      /// </para>
      /// </remarks> 
      public void RaiseErrorOnDivideByZero(bool TrueOrFalse  = true) { RaiseErrorOnDivideByZero_234(h, Convert.ToInt32(TrueOrFalse));       }
      
      /// <summary> Causes inexact results to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning an approximate value where an exact value cannot be represented.
      /// </para>
      /// </remarks> 
      public void RaiseErrorOnInexact(bool TrueOrFalse  = true) { RaiseErrorOnInexact_235(h, Convert.ToInt32(TrueOrFalse));       }
      
      /// <summary> Causes underflow to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised for underflow.
      /// </para>
      /// </remarks> 
      public void RaiseErrorOnUnderflow(bool TrueOrFalse  = true) { RaiseErrorOnUnderflow_236(h, Convert.ToInt32(TrueOrFalse));       }
      
      /// <summary> Causes overflow to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning infinity when there's an overflow.
      /// </para>
      /// </remarks> 
      public void RaiseErrorOnOverflow(bool TrueOrFalse  = true) { RaiseErrorOnOverflow_237(h, Convert.ToInt32(TrueOrFalse));       }
      
      /// <summary> Causes invalid value to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning NaN when an invalid value is encountered.
      /// </para>
      /// </remarks> 
      public void RaiseErrorOnInvalid(bool TrueOrFalse  = true) { RaiseErrorOnInvalid_238(h, Convert.ToInt32(TrueOrFalse));       }
      
      /// <summary> Returns the floating point errors to catch</summary> 
      /// <param name="Value"> ...</param>
      /// <remarks>
      /// <para>
      /// ...
      /// </para>
      /// </remarks> 
      public Int32 FloatingPointErrorsToCatch(Int32 Value  = -1) { return FloatingPointErrorsToCatch_239(h, Value);       }
      
      /// <summary> Returns the uCalc.Item object associated with the given name</summary> 
      /// <param name="ItemName"> Name of uCalc.Item that you want to get</param>
      /// <param name="Properties"> Properties to help pinpoint the right Item, in case several items share the same name +++ have Is[Alias] option (will loop through to find)</param>
      /// <remarks>
      /// <para>
      /// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.</para>
      /// <para>In case multiple items share the same name, you can narrow it down using properties.  For instance, the + operator has a
      /// binary and unary versions.  You can specify Prefix if you wanted the unary one.</para>
      /// <para>Note: A ItemIsEnum member should not be passed directly as the second argument.  Instead Properties, with one or more
      /// ItemIsEnum members should be passed.
      /// </para>
      /// </remarks> 
      public Item ItemOf(string ItemName ,Int64 Properties  = 0) { return ItemOf_240(h, ItemName, (IntPtr)ItemName.Length , Properties);       }
      
      /// <summary> Returns the nth uCalc.Item object that matches a property</summary> 
      /// <param name="Property_"> Property of the uCalc.Item object you're after</param>
      /// <param name="nth"> The nth object</param>
      /// <param name="DataTypeName"> The data type of the object</param>
      /// <remarks>
      /// <para>
      /// This can be used to cycle through defined items.
      /// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.
      /// </para>
      /// </remarks> 
      public Item ItemOf(ItemIsEnum Property_ ,Int64 nth ,string DataTypeName  = "") { return ItemOf_241(h, Property_ , (IntPtr)nth , DataTypeName, (IntPtr)DataTypeName.Length);       }
      /// <summary> ???</summary> 
      /// <param name="nth"> +++</param>
      public Item NamespaceChild(Int64 nth  = 0) { return NamespaceChild_242(h, (IntPtr)nth);       }
      
      /// <summary> ???</summary> 
      public Int64 NamespaceChildCount() { return (Int64)NamespaceChildCount_243(h);       }
      
      /// <summary> ???</summary> 
      /// <param name="Level"> +++</param>
      public Item NamespaceParent(Int64 Level  = 0) { return NamespaceParent_244(h, (IntPtr)Level);       }
      
      /// <summary> ???</summary> 
      /// <param name="nth"> +++</param>
      public Item NamespaceSymbol(Int64 nth) { return NamespaceSymbol_245(h, (IntPtr)nth);       }
      
      /// <summary> ???</summary> 
      public Int64 NamespaceSymbolCount() { return (Int64)NamespaceSymbolCount_246(h);       }
      
      /// <summary> Returns a new uCalc String object</summary> 
      /// <param name="InitialString"> String value</param>
      /// <remarks>
      /// <para>
      /// Returns a new uCalc String object.
      /// </para>
      /// </remarks> 
      public String NewString(string InitialString  = "") { return NewString_247(h, InitialString, (IntPtr)InitialString.Length);       }
      
      /// <summary> Returns a new transform object</summary> 
      /// <remarks>
      /// <para>
      /// Returns a new object that can be used to transform text.
      /// +++ Decide on name; could be CreateTransform() or TransformObj()
      /// </para>
      /// </remarks> 
      public Transforms NewTransform() { return NewTransform_248(h);       }
      
      /// <summary> Returns the transform object associated with the current uCalc object</summary> 
      /// <remarks>
      /// <para>
      /// Whenever a math expression is parsed, this transform is first called.  Use this when you want transforms that apply to math
      /// expressions parsed with Parse, Eval, or EvalStr.  To create a new transform that does not affect math expressions sent to
      /// Parse, use NewTransform instead.</para>
      /// <para>Independent transforms created with NewTransform can be released when no longer needed.  However, the object created with
      /// ExpressionTransforms should never be released explicitely, because the uCalc object requires it in order parse expressions.</para>
      /// <para>Note: For simple situations when you just want one keyword to be the equivalent of a pre-existing one, it is more efficient to
      /// use Alias().  With Alias, nothing is transformed.  Instead, an aliased symbol simply shares the same handle as a pre-existing
      /// one in the symbol table.  When there are no expression transforms at all, the transform step is skipped altogether, slightly
      /// speeding up parsing for all expressions in a uCalc object.
      /// </para>
      /// </remarks> 
      public Transforms ExpressionTransforms() { return ExpressionTransforms_249(h);       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataType"> Data type of return value</param>
      public Expression Parse(string expression ,DataType DataType  = null) { return Parse_250(h, expression, (IntPtr)expression.Length , DataType != null ? DataType.h : (IntPtr)0);       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataType"> Data type of return value</param>
      public Expression Parse(string expression ,string DataType) { return Parse_251(h, expression, (IntPtr)expression.Length , DataType, (IntPtr)DataType.Length);       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataTypeIndex"> Data type index of return value</param>
      public Expression Parse(string expression ,BuiltInTypesEnum DataTypeIndex) { return Parse_252(h, expression, (IntPtr)expression.Length , DataTypeIndex);       }
      
      /// <summary> Returns the precedence level of an operator or the level between two operators</summary> 
      /// <param name="Operator1"> Operator with lower (or equal) precedence</param>
      /// <param name="Operator2"> Operator with greater (or equal precedence)</param>
      /// <remarks>
      /// <para>
      /// This returns a precedence level based on levels of existing operators; useful when defining a new operator (or transform)
      /// with a level relative to levels of existing operators (or transforms).  If one argument is passed, then the precedence
      /// level of that item is returned.  This is useful for defining a new item at the same level as the specified item.  If two
      /// arguments are passed, then the average precedence level of the two items is returned.  This is useful for defining a level
      /// that's in between that of two existing items.
      /// </para>
      /// </remarks> 
      public Int64 Precedence(string Operator1 ,string Operator2  = "") { return (Int64)Precedence_253(h, Operator1, (IntPtr)Operator1.Length , Operator2, (IntPtr)Operator2.Length);       }
      
      /// <summary> Combines properties into a numeric value that can be passed to Item</summary> 
      /// <param name="p1"> +++</param>
      /// <param name="p2"> +++</param>
      /// <param name="p3"> +++</param>
      /// <param name="p4"> +++</param>
      /// <remarks>
      /// <para>
      /// ItemIsEnum properties are numbered sequentially (0, 1, 2, 3, 4, ...).  However the Properties argument
      /// of the Item function requires properties in the 2^x sequence (1, 2, 4, 8, 16, ...).  So you
      /// must pass one or more ItemIsEnum to Properties before passing it to Item.
      /// +++ Maybe rename for clarity (CombineProperties, or something much shorter)
      /// </para>
      /// </remarks> 
      public static Int64 Properties(ItemIsEnum p1 ,ItemIsEnum p2 = ItemIsEnum.SelectAny,ItemIsEnum p3 = ItemIsEnum.SelectAny,ItemIsEnum p4 = ItemIsEnum.SelectAny) { return Properties_254(default(IntPtr), p1 , p2, p3, p4);       }
      
      /// <summary> Returns default settings</summary> 
      /// <remarks>
      /// <para>The Item returned contains the default settings for the current uCalc instance.  To define new settings,
      /// use Define("Default ~~ ...").
      /// +++ Rename something like DefaultSettings or DefaultItemSettings
      /// </para>
      /// </remarks> 
      public Item DefaultItem() { return DefaultItem_255(h);       }
      
      /// <summary> ...</summary> 
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      public DataType DefaultDataType() { return DefaultDataType_256(h);       }
      
      /// <summary> ...</summary> 
      /// <param name="dType"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      public void DefaultDataType(DataType dType) { DefaultDataType_257(h, dType != null ? dType.h : (IntPtr)0);       }
      
      /// <summary> ..</summary> 
      /// <param name="DataTypeIndex"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      public void DefaultDataType(BuiltInTypesEnum DataTypeIndex) { DefaultDataType_258(h, DataTypeIndex);       }
      
      /// <summary> ...</summary> 
      /// <param name="dTypeStr"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      public void DefaultDataType(string dTypeStr) { DefaultDataType_259(h, dTypeStr, (IntPtr)dTypeStr.Length);       }
      
      /// <summary> Checks to see if this uCalc object instance is the default</summary> 
      /// <remarks>
      /// <para>
      /// Definitions from this instance will automatically be loaded into new instances unless directed otherwise.
      /// </para>
      /// </remarks> 
      public bool IsDefault() { return Convert.ToBoolean(IsDefault_260(h));       }
      
      /// <summary> Sets this uCalc object instance as the default</summary> 
      /// <param name="Condition"> ...</param>
      /// <remarks>
      /// <para>
      /// Definitions from this instance will automatically be loaded into new instances unless directed otherwise.
      /// Set this to True.  WHen set to False, nothing happens.
      /// </para>
      /// </remarks> 
      public void IsDefault(bool Condition) { IsDefault_261(h, Convert.ToInt32(Condition));       }
      
      /// <summary> +++</summary> 
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      public static uCalc Default() { return Default_262(default(IntPtr));       }
      
      /// <summary> +++</summary> 
      /// <param name="uCalcObj"> uCalc object to set as default</param>
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      public static void Default(uCalc uCalcObj) { Default_263(default(IntPtr), uCalcObj != null ? uCalcObj.h : (IntPtr)0);       }
      
      /// <summary> Allows a callback to decorate the output of EvalStr</summary> 
      /// <param name="FunctionAddr"> Address of callback function that formats the output</param>
      /// <param name="Properties"> Name of datatype that will have its output formated and/or ranking among other output formats; omit this to affect all data types and use default ranking.</param>
      public Item Format(uCalcDelegate FunctionAddr ,string Properties  = "") { return Format_264(h, FunctionAddr , Properties, (IntPtr)Properties.Length);       }
      
      /// <summary> Allows a callback to decorate the output of EvalStr</summary> 
      /// <param name="FunctionAddr"> Address of callback function that formats the output</param>
      /// <param name="dType"> +++ Test dType 
      public Item Format(uCalcDelegate FunctionAddr ,DataType dType) { return Format_265(h, FunctionAddr , dType != null ? dType.h : (IntPtr)0);       }
      
      /// <summary> Formats the appearance of results returned by EvalStr or EvaluateStr</summary> 
      /// <param name="Definition"> Format definition for the output</param>
      /// <param name="dType"> +++ Test dType</param>
      /// <remarks>
      /// <para>
      /// This function lets you modify the output returned by EvalStr or EvaluateStr.  The definition may contain one or more
      /// of the following:</para>
      /// <para>Datatype:  If you specify a data type, then the modification will affect only the evaluation result of expressions
      /// that evaluate to the specified data type.</para>
      /// <para>InsertAt:  By default, if you define multiple outputs, then the one defined most recently is applied first, followed by
      /// the other outputs in reverse order in which they were defined, ending with the output that was defined first.  You may
      /// specify a different insertion point than the default with this parameter.</para>
      /// <para>Expression:  This represents what the modified output should look like.  The expression consists of an identifier
      /// (any temporary variable name), followed by an equal sign, followed by a string expression representing the value
      /// that will be returned.  The variable holds the original value that would have been returned.
      /// </para>
      /// </remarks> 
      public Item Format(string Definition ,DataType dType  = null) { return Format_266(h, Definition, (IntPtr)Definition.Length , dType != null ? dType.h : (IntPtr)0);       }
      
      /// <summary> Removes any output formatting</summary> 
      /// <param name="dType"> Data type</param>
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      public void FormatRemove(DataType dType  = null) { FormatRemove_267(h, dType != null ? dType.h : (IntPtr)0);       }
      
      /// <summary> Returns the value located at the specified IntPtr address</summary> 
      /// <param name="ValuePtr"> IntPtr address containing the data +++ Swap args to match Function: ValueAt() +++ Also have overload w/ DataType as handle instead of string</param>
      /// <param name="dType"> Data type of the data you need, which helps to determine in which form to return the value at the given location</param>
      /// <remarks>
      /// <para>+++ Rename Value()
      /// +++ SetValueAt
      /// </para>
      /// </remarks> 
      public string ValueAt(IntPtr ValuePtr ,DataType dType  = null) {
         IntPtr ReturnStrSize;
         var ReturnStr = ValueAt_268(h, out ReturnStrSize , ValuePtr , dType != null ? dType.h : (IntPtr)0);
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> Returns the value located at the specified IntPtr address</summary> 
      /// <param name="ValuePtr"> IntPtr address containing the data +++ Swap args to match Function: ValueAt() +++ Also have overload w/ DataType as handle instead of string</param>
      /// <param name="ValueDataType"> Data type of the data you need, which helps to determine in which form to return the value at the given location</param>
      /// <remarks>
      /// <para>+++ maybe remove this & leave the other
      /// +++ SetValueAt
      /// </para>
      /// </remarks> 
      public string ValueAt(IntPtr ValuePtr ,string ValueDataType) {
         IntPtr ReturnStrSize;
         var ReturnStr = ValueAt_269(h, out ReturnStrSize , ValuePtr , ValueDataType, (IntPtr)ValueDataType.Length);
         return Marshal.PtrToStringAnsi(ReturnStr, (Int32)ReturnStrSize);
      }
      
      /// <summary> +++</summary> 
      /// <param name="LicenseType"> +++</param>
      /// <param name="L1"> +++</param>
      /// <param name="L2"> +++</param>
      /// <param name="L3"> +++</param>
      /// <param name="L4"> +++</param>
      /// <param name="L5"> +++</param>
      /// <returns> +++</returns>
      /// <remarks>
      /// <para>
      /// ...
      /// </para>
      /// </remarks> 
      public static void License(LicenseTypeEnum LicenseType ,Int64 L1  = 0,Int64 L2  = 0,Int64 L3  = 0,Int64 L4  = 0,Int64 L5  = 0) { License_270(default(IntPtr), LicenseType , (IntPtr)L1, (IntPtr)L2, (IntPtr)L3, (IntPtr)L4, (IntPtr)L5);       }
      
      public void Reset() { Release(); h = Create().h;       }
      public void Reset(uCalc uCalcObj) { Release(); h = Create(uCalcObj).h;       }
      
      public uCalc() { h = Create().h;       }
      
      /// <summary> Returns the handle of an object</summary> 
      /// <remarks>
      /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
      ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
      /// </remarks> 
      public IntPtr Handle() { return Handle_271(h);       }
      
      /// <summary> +++ comment for each</summary> 
      public void Release() { if (h != (IntPtr)0) Release_272(h); h = (IntPtr)0;       }
      
      public static implicit operator uCalc(IntPtr o) { return new uCalc(o);       }
      public uCalc(IntPtr PassedHandle) { h = PassedHandle;       }
      
      List<uCalcDelegate> Addresses = new List<uCalcDelegate>();
      public uCalcDelegate PinAddr(uCalcDelegate Address) { Addresses.Add(Address); return Address;          }
      
   }
} 

