' --> See BASIC.Txt for a line-by-line explanation of this file.

Dim _Type As String
Dim _ScrBuff As CONSOLE_SCREEN_BUFFER_INFO
Dim _Coord As COORD
Dim _AlphaNum  As String = "[a-z_][0-9a-z_]*[@#!%&$]?"
Dim _AlphaNumV As String = "[a-z_][0-9a-z_]*"

uCalc Load "Define.uc"

uCalc Prefix "uCalc Define Pattern:"
   Rem .*       ~~ Properties: ucWhiteSpace
   '.*          ~~ Properties: ucWhiteSpace
   ~FuncEnd     ~~ Properties: ucFuncDefEnd
   :            ~~ Properties: ucStatementSep
   :::          ~~ Properties: ucStatementSep
   \.           ~~ Properties: ucMemberAccess
   ,            ~~ Properties: ucArgSeparator
   \( ~~ \)     ~~ Properties: ucCodeBlock
   [ ]+         ~~ Properties: ucWhiteSpace
   [\|+/*^$&#\-=@!`\\<>?;%]+ ~~ Properties: ucReducible
   \\q ~~ \\q ~~ Properties: ucQuotedText + ucLiteral ~~ DataType: String
   \\y ~~ \\y ~~ Properties: ucQuotedText + ucLiteral ~~ DataType: String
   [\q] ~~ [\q] ~~ Properties: ucQuotedText + ucLiteral ~~ DataType: String
   ([0-9]+\.)?[0-9]*(e[-+]?[0-9]+)? ~~ Properties: ucLiteral~~DataType: Extended
   [a-z_][0-9a-z_]*[@#!%&$]? ~~ Properties: ucAlphaNumeric
uCalc Prefix ""

RenameItem("Print", "_Print")
RenameItem("=", "->") ' Assignment operator (string, numeric, table)
RenameItem("=", "->")
RenameItem("=", "->")
RenameItem("==", "=") ' comparison op (string, numeric)
RenameItem("==", "=")

uCalc Define PassOnce ~~ Syntax: TextData: ::= TextData:

' The numerical values at the begining represent precedence levels
uCalc Prefix "uCalc Syntax "
     Type {"[ ]+"} {name} ::= _
       SetInput("  _") : _
       SetInput("uCalc Prefix \q_UDT: \q") : _
       SetInput("_Type -> \qDataType: {name} ~~\q") : _
       SetInput("uCalc Prefix \q\q")

     _UDT: {member} As {type} ::= _ 
       SetInput("  _") : _
       SetInput("uCalc Eval _Type -> _Type + \q{Var: {member} As {type}} ~~\q")

     _UDT: End Type ::= _
       SetInput("uCalc Define " + _Type + "TypeHandler: ucAddr(uc_User_Type)") : _
       SetInput("uCalc Prefix \q_basic: \q")

     __Quote({text}) ::= \y{text}\y

5    _basic: ::=
5    _basic: {variable:"[ ]+[a-z_][0-9a-z_\.]*[@#!%&$]?[ ]*"}= ::= {variable} ->
5    {":"} {variable:"[ ]+[a-z_][0-9a-z_\.]*[@#!%&$]?[ ]*"}= ::= :{variable} ->

5    _basic: Mid$({Var}, {Start}) = {Replacement} _
     ::= Poke$(StrPtr({Var})+{Start}-1, {Replacement}) : _Void

20   Locate {row} [, {col=CursorX}] [{Sep:":"}] _
        ::= _Coord.x -> {col}-1 : _Coord.y -> {row}-1 _
        : SetConsoleCursorPosition(StdOut, _Coord) {Sep}
20   Locate , {col} [{Sep:":"}] _
        ::= _Coord.x -> {col}-1 : _Coord.y -> CurSorY-1 _
        : SetConsoleCursorPosition(StdOut, _Coord) {Sep}

20   Print [{data}]          ::= _Print({data: Str({data}) +} Chr(13) + Chr(10))
20   Print [{data}], [{etc}] ::= _
        {data: _Print(Str({data})) : } NextPrintZone() {etc: : Print {etc}}
20   Print {data} ; [{etc}]  ::= _Print(Str({data}))  {etc: : Print {etc}}
20   _Print(Str({data}, {etc})) _
     ::= _Print(Str({data})) : NextPrintZone() : _Print(Str({etc}))

10   For {Var} = {Start} To {Stop} [Step {Step=1}] _
     ::= ~mStart uc_For({Var}, {Start}, {Stop}, {Step},
10   Next ::= ) ~mEnd

15   For {Var} = {Start} To {Stop} [Step {Step=1}] : {Code} : Next _
     ::= uc_For({Var}, {Start}, {Stop}, {Step}, {Code})

10   Until {x}                   ::= ({x}) = 0
10   Do [[While] {DoCond=1}]     ::= ~mStart uc_Loop({DoCond},
10   Loop [[While] {LoopCond=1}] ::= , {LoopCond}) ~mEnd

15   Do [[While] {DoCond=1}] : {Code}  Loop [[While] {LoopCond=1}] _
     ::= uc_Loop({DoCond}, ({Code}), {LoopCond})

10   While {Cond} ::= ~mStart uc_Loop({Cond},
10   Wend         ::= , 1) ~mEnd

15   While {Cond} : {Code} : Wend ::= uc_Loop({Cond}, {Code}, 1)

10   If {cond} Then     ::= ~mStart _If({cond},
10   Else               ::= , 1,
10   ElseIf {cond} Then ::= , {cond},
10   End If             ::= ) ~mEnd

15   If {cond} Then {code} [Else {Other}] _
     ::= _If({cond}, _basic: {code} {Other: , 1, _basic: {Other}})

10   Val   ::= ToFloat
10   Timer ::= (GetTickCount/1000)

10   String * {size:" [0-9]+"} ::= FixedString ~~ Size: {size}

99   &{"b"}{BinaryNumber:"[0-1]+"} ::= BaseConvert("{BinaryNumber}", 2)
99   &{"o"}{OctalNumber:"[0-7]+"}  ::= BaseConvert("{OctalNumber}",  8)
99   &{"h"}{HexNumber:"[0-9A-F]+"} ::= BaseConvert("{HexNumber}",   16)

10   UBound({MyArray})::=~Eval(uCalc(uc_GetItemData,"{MyArray}",0,uc_ArgCount))

10   Function {FuncName} ([{ParamList}]) [As {Type}] ::=          _
     SetInput(\q{ Var: {FuncName} {Type:~~ DataType: {Type}} }    _
               ~~ { Execute: RenameItem("{FuncName}", "__", ~t) } _
               ~~ { Syntax: Function ::= __ }                     _
               ~~ { Syntax: {FuncName}{NoParenth:"[^\(]"} ::= __{NoParenth} } _
               ~~ Params: ({ParamList})                           _
               ~~ DataType: {Type}                                _
               ~~ name_: {FuncName}                               _
               ~~ Rank: 2                                         _
               ~~ Properties: ucFunction+ucPrefix                 _
               ~~ FuncStart\q)                                    _
     SetInput("uCalc Prefix \quCalc Define _basic: \q")           _
     SetInput("FuncName$ = \q{FuncName}\q")

10   End Function ::= ~FuncEnd                                           _
     SetInput("uCalc Prefix \q_basic: \q")                               _
     SetInput("Syntax: 10 " + FuncName$ + "{\q[ ]+\q}{Params:\q[^~]+\q}" _
              + "::=" + FuncName$ + "({Params})")

10   Sub {Def:" .+"} ::= Function {Def} As Void
10   End Sub         ::= SetInput("End Function") _
                         SetInput("__ -> 0") ' +++ SetInput shouldn't be needed in this line

10   TypeExtention {"[ ]+"}{Extention:"[$#!%&@?]{1,3}"}{"[ ]+"}{TypeName} _
     ::= SetInput(\quCalc Syntax 10 Name_: {ItemName:" *[a-z_][0-9a-z_]*[{Extention}]"} _
        ::= Name: {ItemName} ~~ DataType: {TypeName}\q)

15   Line Input [{Prompt:\q[ ]+"[^"]*"\q=""}] [,] {StringVar} _
     ::= {StringVar} -> _LineInput$({Prompt})
uCalc Prefix ""

uCalc Prefix "TypeExtention "
   $    String
   #    Double
   !    Single
   %    Integer
   &    Long
   @    Currency
uCalc Prefix ""

Dim FuncName$

uCalc Define Func:: Chr$(Code As Long) As String At ucAddr(uc_Func_Chr)

uCalc Prefix "uCalc Define Func: "
   CBYT(x) As Byte     = x
   CCUR(x) As Currency = x
   CDBL(x) As Double   = x
   CINT(x) As Integer  = x
   CLNG(x) As Long     = x
   CSNG(x) As Single   = x

   CursorX() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff) _
      : _ScrBuff.dwCursorPosition.x+1
   CursorY() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff) _
      : _ScrBuff.dwCursorPosition.y+1
   NextPrintZone() As Void = Locate , (CursorX+15)\14*14
uCalc Prefix ""
' +++    CSTR(x As AnyType)  As String = x ' VB flavor

uCalc Prefix "uCalc Define Op: "
   10 IsTrue  {x} = ((x)<>0)
   10 IsFalse {x} = ((x)=0)
uCalc Prefix ""

uCalc Prefix "_basic: "

Function MsgBox(Text$, Style& = 0, Title$ = "uCalc") As Long
   Function = MessageBox(0, Text$, Title$, Style&)
End function

Function String$(Count As Long, Code As Long)
   Dim TotalStr As String
   Dim x As Long

   For x = 1 To Count
      TotalStr = TotalStr + Chr$(Code)
   Next

   String$ = TotalStr
End Function


' PowerBASIC Flavor file
uCalc Load "PBFlavor.uc"


' Left$, Right$, and Mid$ below include some PB flavoring in that
' they can accept negative value for the second arg.

Function Left$(text$, Count As Long)
   Count = Min(Count, Len(Text$))
   If Count < 0 Then Count = Len(Text$)-Abs(Count)
   Left$ = Peek$(StrPtr(Text$), Count)
End Function

Function Right$(text$, Count As Long)
   Count = Min(Count, Len(Text$))
   If Count < 0 Then Count = Len(Text$)-Abs(Count)
   Right$ = Peek$(StrPtr(Text$)+Len(Text$)-Count, Count)
End Function

Function Mid$(text$, Start&, Length&)
   Length& = Min(Length&, Len(Text$)-Start&+1)
   If Length& < 0 Then Length& = Len(Text$)-Abs(Length&)
   Mid$ = Peek$(StrPtr(Text$)+Start&-1, Length&)
End Function

Function Mid$(Text$, Start&)
   Mid$ = Mid$(Text$, Start&, Len(Text$)-Start&+1)
End Function

Function LTrim$(text$, TrimChars$ = " ")
   Dim Start As Long
   Dim TrimCharLen As Long

   Start = 1
   TrimCharLen = Len(TrimChars$)

   While Mid$(text$, Start, TrimCharLen) = TrimChars$
      Start = Start + TrimCharLen
   Wend

   LTrim$ = Mid$(text$, Start)
End Function

Function _LineInput$(Prompt$)
   Dim LineLength&, Ignore&

   _Print(Prompt$)   
   SetConsoleMode(StdIn, ENABLE_LINE_INPUT+ENABLE_ECHO_INPUT+ENABLE_PROCESSED_INPUT)
   ReadConsole(StdIn, _lpText, 80, LineLength&, Ignore&)
   _LineInput$ -> Left$(_lpText, LineLength&-2)
End Function

ucVersion       = ucVersion + "uCalc BASIC. November 2007 (beta)"+\cr
MainPrompt      = "ucalc:BASIC> "
MultiLinePrompt = "ucalc:BASIC>>"

Print ucVersion
Print "Available constructs for now are things like Dim, For/Next, Do/Loop,"
Print "While/Wend, If/Then, LTrim$, Left$, Right$, Mid$ (statement & function),"
Print "Line Input, Print, Timer, Sub & Function definitions, MsgBox, etc..."
Print
Print "PB-flavored extensions include pointer types, Min/Max, Hi/Lo/Mak,"
Print "Peek$, Poke$, extended functionality for Chr$, String$(), etc..."
Print

' End of file
