//The numerical values at the begining represent precedence levels

uCalc Prefix "uCalc Define Op::" // Operator definitions
75   -{x} At ucAddr(uc_Op_Negate_Extended)
60   {x As String}+{y As String} As String At ucAddr(uc_Op_StrConcat)
60   {x As Long}  +{y As Long}   As Long   At ucAddr(uc_Op_Add_Int32)

50   {x}>{y}  As Long At ucAddr(uc_Op_GreaterThan_Extended)
50   {x}<{y}  As Long At ucAddr(uc_Op_LessThan_Extended)
50   {x}>={y} As Long At ucAddr(uc_Op_GreaterOrEqual_Extended)
50   {x}<={y} As Long At ucAddr(uc_Op_LessOrEqual_Extended)
50   {x}<>{y} As Long At ucAddr(uc_Op_NotEqual_Extended)
50   {x}=={y} As Long At ucAddr(uc_Op_Equal_Extended)

50   {x As String}>{y As String}  As Long At ucAddr(uc_Op_GreaterThan_Str)
50   {x As String}<{y As String}  As Long At ucAddr(uc_Op_LessThan_Str)
50   {x As String}>={y As String} As Long At ucAddr(uc_Op_GreaterOrEqual_Str)
50   {x As String}<={y As String} As Long At ucAddr(uc_Op_LessOrEqual_Str)
50   {x As String}<>{y As String} As Long At ucAddr(uc_Op_NotEqual_Str)
50   {x As String}=={y As String} As Long At ucAddr(uc_Op_Equal_Str)

40   {x As Long} And     {y As Long}        As Long At ucAddr(uc_Op_And_Int32)
40   {x As Long} AndAlso {ByExpr y As Long} As Long At ucAddr(uc_Op_AndAlso)
30   {x As Long} Or      {y As Long}        As Long At ucAddr(uc_Op_Or_Int32)
30   {x As Long} OrElse  {ByExpr y As Long} As Long At ucAddr(uc_Op_OrElse)

60   {x}+{y}         At ucAddr(uc_Op_Add_Extended)
60   {x}-{y}         At ucAddr(uc_Op_Subtract_Extended)
70   {x}*{y}         At ucAddr(uc_Op_Multiply_Extended)
70   {x}/{y}         At ucAddr(uc_Op_Divide_Extended)
70   {x} Mod {y}     At ucAddr(uc_Op_Mod_Extended)
80   {x}^{y}         At ucAddr(uc_Op_PowerOf_ExtToExt)
80   {x}^{y As Long} At ucAddr(uc_Op_PowerOf_ExtToLng)

60   {Stack1 As Stack}+{Stack2 As Stack} As Stack At ucAddr(uc_Op_Concat_Stack)

90   {x As Long}!                    At ucAddr(uc_Op_Factorial)
70   {x As Long}\{y As Long} As Long At ucAddr(uc_Op_Divide_Int32)

20   {ByHandle Variable As AnyType} = {ByHandle Value As Stack} As Void _
     At ucAddr(uc_SetVariableValue)

20   {ByHandle Variable As AnyType} = {ByHandle Value As String} As Void _
     At ucAddr(uc_SetVariableValue)

20   {ByHandle Variable As AnyType} = {ByHandle Value As Extended} As Void _
     At ucAddr(uc_SetVariableValue)
uCalc Prefix ""

uCalc Prefix "uCalc Define Var:"
   NullStr As String At ucAddr(uc_NullString)
   uc_Stack As Stack

   _Number As String   = "([0-9]+\.)?[0-9]*(e[-+]?[0-9]+)?"
   _AlphaNum As String = "[a-z_][0-9a-z_]*"
   _Space As String    = "[ \x09]+"

   _ToStr As String
   _ToFloat As Extended
   _Void As Void
   _Coord00 As COORD
   _Ignore As Dword

   Ok As Void
uCalc Prefix ""

uCalc Prefix "uCalc Define Func::" // Function definitions
   Sin(x)          At ucAddr(uc_Func_Sin)
   Cos(x)          At ucAddr(uc_Func_Cos)
   Tan(x)          At ucAddr(uc_Func_Tan)
   Atan(x)         At ucAddr(uc_Func_Atan)
   Abs(x)          At ucAddr(uc_Func_Abs_Extended)
   Exp(x)          At ucAddr(uc_Func_Exp)
   Log(x)          At ucAddr(uc_Func_Log)
   Ceil(x) As Long At ucAddr(uc_Func_Ceil)
   Sqr(x)          At ucAddr(uc_Func_SquareRoot)
   Int(x)          At ucAddr(uc_Func_Int)
   Frac(x)         At ucAddr(uc_Func_Frac)
   Sgn(x)          At ucAddr(uc_Func_Sgn)
   Rand(x = 1)     At ucAddr(uc_Func_Rand)
   Rand(x As Long, y As Long) At ucAddr(uc_Func_Rand)

   BaseConvert(Number As String, Base As Long) At ucAddr(uc_Func_BaseConvert)

   _if(ByExpr Cond1, ByExpr Code1 As AnyType ...) As Void _
      At ucAddr(uc_Func_If_ElseIf)

   iif(cond As Long, ByExpr DoTrue As Extended, ByExpr DoFalse As Extended) _
      As Extended At ucAddr(uc_Func_IIF)
   iif(cond As Long, ByExpr DoTrue As String, ByExpr DoFalse As String) _
      As String At ucAddr(uc_Func_IIF_Str)

   ValueAtAddr(DataType As Dword, Address As Dword, Index As Long = 0) _
      At ucAddr(uc_Func_ValueAtAddr) ~~ ValueAtAddr 

   uCalc(Command As Long, TextArg As String = NullStr, MiscArg1 As Long = 0, _
      MiscArg2 As Long = 0, ReturnPtr As Long = 0, t As Dword = 0) As Long _
      At ucAddr(uc_Func_uCalc)

   uCalcStr(Command As Long, TextArg As String = NullStr, MiscArg1 As Dword=0, _
      MiscArg2 As Dword = 0, ReturnPtr As Dword = 0, t As Dword = 0) As String _
      At ucAddr(uc_Func_uCalcStr)

   uCalcVoid(Command As Long, TextArg As String = NullStr, MiscArg1 As Dword=0, _
      MiscArg2 As Dword = 0, ReturnPtr As Dword = 0, t As Dword = 0) As Void _
      At ucAddr(uc_Func_uCalc)

   uc_Loop(ByExpr DoCondition As Extended, ByExpr Expression As AnyType, _
      ByExpr LoopCondition As Extended) As Void At ucAddr(uc_Func_Loop)
   uc_For(ByHandle Counter As AnyType, Start, Finish, Step, _
      ByExpr Expr As AnyType) As Void At ucAddr(uc_Func_For)

   uc_Peek(Address As Dword, Count As Long) As String At ucAddr(uc_Func_Peek)
   uc_Poke(Address As Dword, Text As String) As Void At ucAddr(uc_Func_Poke)

   uc_Count(StackName As Stack) As Long At ucAddr(uc_Func_Count_Stack)
   uc_Push(StackName As Stack, ByHandle Data As AnyType, Index As Long = 0) _
      As Long At ucAddr(uc_Func_PushData_Stack)
   uc_PopNum(StackName As Stack, Index As Long = 0) As Extended _
      At ucAddr(uc_Func_PopNum_Stack)
   uc_PopStr(StackName As Stack, Index As Long = 0) As String _
      At ucAddr(uc_Func_PopStr_Stack)
   uc_ReadNum(StackName As Stack, Index As Long = 0) As Extended _
      At ucAddr(uc_Func_ReadNum_Stack)
   uc_ReadStr(StackName As Stack, Index As Long = 0) As String _
      At ucAddr(uc_Func_ReadStr_Stack)

   StackFormat(a As String, b As String, c As String, d As String) As Void _
      At ucAddr(uc_Func_StackFormat)

   Handle(TableName As Table, Entry As String) As Dword _
      At ucAddr(uc_Handle_Table)
   uc_Delete(TableName As Table, Entry As String) As Void _
      At ucAddr(uc_Delete_Table)
   uc_Insert(TableName As Table, Entry As String, ByHandle Data As AnyType) _
      As Void At ucAddr(uc_Insert_Table)

   Asc(Character As String, Position As Long = 1) As Long At ucAddr(uc_Func_Asc)
   Chr(Code As Long) As String At ucAddr(uc_Func_Chr)

   VarPtr(Item As AnyType) As Dword At ucAddr(uc_Func_VarPtr)
   ExprHandle(ByHandle Item As AnyType) As Dword At ucAddr(uc_Func_ExprHandle)

   GenericConvert(ByHandle Variable As AnyType, ByHandle Value As AnyType) _
      As Void At ucAddr(uc_SetVariableValue)

   SetSyntaxParams(Params As String, Expr As String, t As Dword = 0) As String _
      At ucAddr(uc_Func_SetSyntaxParams)

   SpecialUCase(Expr As String, t As Dword = 0) As String _
      At ucAddr(uc_Func_SpecialUCase)
uCalc Prefix ""

StackFormat("{", \q"\q, ", ", "}")

uCalc Prefix "uCalc Define Func:"
   Inf() = 1/0
   NaN() = 0/0

   Address(Item As Dword)                     = uCalc(uc_GetItemData, "", Item, uc_Address)
   Address(Item As String, t As Dword = 0)    = uCalc(uc_GetItemData, Item, 0, uc_Address, 0, t)
   Handle(Item As string, t As Dword = 0)     = uCalc(uc_GetItemData, Item, 0, uc_Handle, 0, t)
   Precedence(Item As String, t As Dword = 0) = uCalc(uc_GetItemData, Item, 0, uc_Precedence, 0, t)
   Rank(Item As String, t As Dword = 0)       = uCalc(uc_GetItemData, Item, 0, uc_Rank, 0, t)
   DataType(Item As Dword)                    = uCalc(uc_GetItemData, "", Item, uc_DataType)
   DataType(Item As String, t As Dword = 0)   = uCalc(uc_GetItemData, Item, 0, uc_DataType, 0, t)

   ReleaseItem(ItemName As String, t As Dword = 0) As Void _
      = uCalc(uc_ReleaseItem, ItemName, 0, 0, 0, t)
   ReleaseItem(ItemHandle As Dword) As Void _
      = uCalc(uc_ReleaseItem, "", ItemHandle)

   RenameItem(ItemHandle As Dword, NewName As String) As Void _
      = uCalc(uc_SetItemData, NewName, ItemHandle, uc_SymbolName)

   RenameItem(ItemName As String, NewName As String, t As Dword = 0) As Void _
      = uCalc(uc_SetItemData, NewName, Handle(ItemName, t), uc_SymbolName, 0, t)

   StrPtr(Item As String) As Dword = ValueAtAddr(Dword, VarPtr(Item))

   Len(Text As String) As Long = SysStringByteLen(ValueAtAddr(DWORD, VarPtr(Text)))
   Print(Text As String) As Void = WriteConsole(StdOut, Text, Len(Text), 0, 0)

   Max(a, b) = IIf(a > b, a, b)
   Min(a, b) = IIf(a < b, a, b)
   Max(a As String, b As String) As String = IIf(a > b, a, b)
   Min(a As String, b As String) As String = IIf(a < b, a, b)

   SetInput_(Data As String, ShowOutput As Long = 0, Pos As Long = 0) As String _
      = uc_Push(OutputBuffer, ShowOutput, Pos) ::: _
        uc_Push(InputBuffer, Data, Pos) ::: ""
uCalc Prefix ""

uCalc Prefix "uCalc Define Op:"
50 {x}           <<{y}                       = x * 2^y
50 {x As Integer}>>{y As Integer} As Integer = ((x And (2^15-1))/(2^y)) Or 2^15
50 {x As Long}   >>{y As Long}    As Long    = ((x And (2^31-1))/(2^y)) Or 2^31
50 {x}          >>>{y}            As Dword   = x / (2^y)
uCalc Prefix ""

uCalc Prefix "uCalc Syntax "
   SetInput({Data} [, {Pos=0}])     ::= ~Eval(SetInput_({Data}, 0, {Pos}))
   SetInput(ShowOutput, {Data} [, {Pos=0}])     ::= ~Eval(SetInput_({Data}, 1, {Pos}))
   Type({ItemHandle})   ::= ~Eval(uCalc(uc_GetItemData, "", {ItemHandle}, uc_DataType))
   ExprType({Expr})     ::= uCalc(uc_GetItemData, "", ExprHandle({Expr}), uc_DataType)
   ExprTypeName({Expr}) ::= uCalcStr(uc_GetItemData, "", uCalc(uc_GetItemData, "", ExprHandle({Expr}), uc_DataType), uc_SymbolName)

10   Dim {Item} ::= ~Eval(uCalcVoid(uc_Define, \qVar: {Item}\q, 0, 0, 0, ~t))
10   Dim {TableName} As Table ::= _
        ~Eval(uCalc(uc_Define, "Var: {TableName} As Table", 0, 0, 0, ~t)) ::: _
        ~Eval(uCalc(uc_DefineSyntax, "{TableName}({ItemName}) ::= _
           ValueAtAddr(Type(Handle({TableName}, {ItemName})), _
           Address(Handle({TableName}, {ItemName})))", 0, 0, 0, ~t)) ::: _
        ~Eval(uCalcVoid(uc_DefineSyntax, "{TableName}({ItemName}) = {Value} ::= _
           uc_Insert({TableName}, {ItemName}, {Value})", 0, 0, 0, ~t))
10   Dim {FirstVar}, {OtherVars} ::= Dim {FirstVar} ::: Dim {OtherVars}

   Str              ::= ToStr
   ToStr({value})   ::= (GenericConvert(_ToStr, {value})   ::: _ToStr)
   ToFloat({value}) ::= (GenericConvert(_ToFloat, {value}) ::: _ToFloat)

   Cls ::= FillConsoleOutputCharacter(StdOut, 32, 100000, _Coord00, _Ignore) _
      ::: SetConsoleCursorPosition(StdOut, _Coord00) ::: ""

   ImplicitMult ::= _
      SetInput("uCalc Syntax ) ( ::= ) * (")  _
      SetInput("uCalc Syntax {Num:_Number} {Word:_AlphaNum} ::= {Num}*{Word}") _
      SetInput("uCalc Syntax {Num:_Number} {' +'} {Word:_AlphaNum} ::= {Num}*{Word}")  _
      SetInput("uCalc Syntax {Num:_Number} {' +'} {Num2:_Number} ::= {Num}*{Num2}")
uCalc Prefix ""

// +++ Needs to be fixed.
// Func:   Str(AnyItem As SpecialString) As String = AnyItem
// Func:   Str(StringItem As String) As String = StringItem
