' +++ Each file should have a header

' The constructs below are meant to mimic just a few of those found in
' PowerBASIC.  Though it's designed to produce the same kind of output,
' it is not designed to actually work identically in every way.  Hence,
' you can think of the following as PB-flavored definitions of BASIC.
' To see the full online documentation of the actual PowerBASIC language,
' with all its features, visit www.powerbasic.com .  PowerBASIC is not
' in any way affiliated with uCalc.

' +++ The original concept was to have a general BASIC, with PB, VB, and
' possibly other flavor files that you could load to add functionality
' peculiar to those versions of BASIC. But as it turns out, definitions
' for now aren't clear cut, and things required in the general BASIC are
' defined here, while some PB flavorings are included in BASIC.uc as part
' of the extended functionality of conventional BASIC routines. 


Dim PointerType As Table

uCalc Prefix "uCalc Define Func:" ' The rest defined in BASIC.uc
   Chr(text As String) As String = text

   CEXT(x) As Extended = x
   CWRD(x) As Word     = x
   CDWD(x) As Dword    = x
   CQUD(x) As Int64    = x
uCalc Prefix ""

' This arbitrarily chosen non-printable character (\x09) is for use
' with the #If definition further down.
uCalc Define Pattern: [\x09].* ~~ Properties: ucWhiteSpace

' +++ Don't use ~Eval in choose
uCalc Prefix "uCalc Syntax "
     ? {data} ::= Print {data}

10   #If {Symbol}        ::= #If ~Eval({Symbol})
10   #If 0               ::= SetInput("uCalc Prefix \q"+Chr$(9)+"\q")
10   #If {" +-?[1-9]+$"} ::= ' Do nothing
10   {"[\x09]"}#EndIf    ::= SetInput("uCalc Prefix \q\q")

10   #Include {File}     ::= SetInput("uCalc Load {File}")

10   Dim {VarName} As {Type} Ptr ::= (Dim {VarName} As Dword) : _
     ~Eval(PointerType("{VarName}") = "{Type}")

99   @{VarName} ::= ValueAtAddr(~Eval(Handle(PointerType("{VarName}"))), {VarName})
99   @{VarName} {"\["} {Index} {"\]"} ::= ValueAtAddr(~Eval(Handle(PointerType("{VarName}"))), {VarName}, {Index})

     Chr({Start} To {Finish}) ::= _To$({Start}, {Finish})
     Chr({first}, {rest})     ::= Chr({first}) + Chr({rest})
     Chr$                     ::= Chr

     Choose({n}, {ArgList}) ::= Choose(~Eval({n}-1), _rest({ArgList}))
     Choose(1, {ArgList})   ::= _first({ArgList})
     Choose({n},)           ::=
     Choose$                ::= Choose
     Choose%                ::= Choose
     Choose&                ::= Choose

10   Color [{Foreground=0}] [, {Background=0}] _
     ::= SetConsoleTextAttribute(StdOut, {Foreground}+{Background}*16)

     Console Name {Text} ::= SetConsoleTitle({Text})

     IIf$   ::= IIf
     IIf&   ::= IIf
     CBYTE  ::= CBYT
     Ext    ::= Extended
     Quad   ::= Int64
     ASCIIZ ::= LPCSTR
     ASCIIZ * {size:" *[0-9]+"} ::= ASCIIZ ~~ Size: {size}

10   Incr {x} ::= {x} = {x} + 1
10   Decr {x} ::= {x} = {x} - 1

     Macro {name} [{args:"\([^\)]+\)"}] = {replacement} ::= SetInput(\quCalc Syntax \q + __Quote(~Eval(SetSyntaxParams(\q{args}\q, \q{name}{args} ::= {replacement}\q))))

     Max({a}, {b}, {More}) ::= Max({a}, Max({b}, {More}))
     Max$                  ::= Max
     Max&                  ::= Max
     Max%                  ::= Max

     Min({a}, {b}, {More}) ::= Min({a}, Min({b}, {More}))
     Min$                  ::= Min
     Min&                  ::= Min
     Min%                  ::= Min

     Waitkey$ ::= (ReadConsole(StdIn, _lpText, 5, 0, 0) : _LpText)

     Lo(Byte, {Value})    ::= CByt({Value})
     Lo(Word, {Value})    ::= CWrd({Value})
     Hi(Byte, {Value})    ::= CByt(({Value} >> 8)  And &hFF)
     Hi(Word, {Value})    ::= CWrd(({Value} >> 16) And &hFFFF)
     Mak(Word,  {a}, {b}) ::= Cwrd(CByt({a}) Or (CWrd(CByt({b})) << 8))
     Mak(Long,  {a}, {b}) ::= CLng(CWrd({a}) Or (CLng(CWrd({b})) << 16))
     Mak(Dword, {a}, {b}) ::= CDwd(CWrd({a}) Or (CDwd(CWrd({b})) << 16))
uCalc Prefix ""

' +++ Revisit
'uCalc Define Pattern:[a-z_][0-9a-z_]*[@#!%&$?]{0,3} _
'   ~~ Properties: ucAlphaNumeric
'
'uCalc Prefix "TypeExtention "
'   &&   Quad
'   ?    Byte
'   ??   Word
'   ???  Dword
'   ##   Extended
'uCalc Prefix ""

uCalc Prefix "_basic: "

' +++ More efficient if Handle of pData is used instead of its name
Function Peek$(Address As Dword, Count As Long)
   Dim pData As FixedString At 1   ' 1 is just a place holder

   uCalc(uc_SetItemData, "pData", 0, uc_Address, Address, ~t)
   uCalc(uc_SetItemData, "pData", 0, uc_ByteSize, Count, ~t)

   Peek$ = pData
End Function

Sub Poke$(Address As Dword, text$)
   Dim pData As FixedString At 1

   uCalc(uc_SetItemData, "pData", 0, uc_Address, Address, ~t)
   uCalc(uc_SetItemData, "pData", 0, uc_ByteSize, Len(text$), ~t)
   pData = text$
End Sub

' Other version of String$ defined in BASIC.uc
Function String$(Count As Long, Text$)
   Dim Total$, x&

   For x& = 1 To Count
      Total$ = Total$ + Chr$(Asc(Text$))
   Next

   String$ = Total$
End Function

Function Repeat$(Count As Long, Text$)
   Dim Total$, x&

   For x& = 1 To Count
      Total$ = Total$ + Text$
   Next

   Repeat$ = Total$
End Function

' _To is for use in Chr$, as in Chr$(65 To 75)
Function _To$(Start&, Finish&)
   Dim x&, Total$

   For x& = Start& to Finish&
      Total$ = Total$ + Chr$(x&)
   Next

   _To$ = Total$
End Function

' End of File
