
#pragma once

// This file was auto-generated with uCalc Transform 3.0 using uCalcH.uc on 12/31/18 at 20:42 PM 

// #define uCalcForWindows 1
// #define uCalcForLinux 1
// #define uCalcForAndroid 1

#include <cstdint>
#include <string>
#include <cfenv>
#if defined(_WIN64)
#   pragma comment(lib, "uCalc64.lib")
#elif defined(_WIN32)
#   pragma comment(lib, "uCalc32.lib")
#else
#  include <dlfcn.h>
#endif

namespace uCalcSoftware {
   
   using namespace std;
   
#if defined(uCalcForLinux)
   #define StdCall
   #define DllImport
#elif defined(uCalcForAndroid)
   #define uCalcLib "./libuCalc.so"
   #define LoadLibraryA(lib) dlopen(lib, RTLD_LAZY)
   #define GetProcAddress(lib_handle, func) dlsym(lib_handle, func)
   #define HINSTANCE void *
#else // uCalcForWindows (implied)
   #define StdCall __stdcall
   #define DllImport __declspec(dllimport)
   
#if defined(_WIN64)
      #define uCalcLib "uCalc64.dll"
   #else // defined(_WIN32)
      #define uCalcLib "uCalc32.dll"
   #endif
#endif
   
   /// <summary> Data types that come with uCalc</summary>
   ///  <remarks>
   /// <para>These are built-in data types that come with uCalc +++ Use scoped enum w/ class; or insert enum in class for uCalc::member access</para>
   /// </remarks>
   enum BuiltInTypesEnum : int32_t {
      Type_Unspecified,
      Type_Auto,
      /// <summary> Boolean</summary>
      Type_Boolean,
      /// <summary> Int8 +++ Rename these to things like Type_Int8</summary>
      Type_Integer_8,
      /// <summary> uint8_t</summary>
      Type_Integer_8u,
      /// <summary> Int16</summary>
      Type_Integer_16,
      /// <summary> Int16u</summary>
      Type_Integer_16u,
      /// <summary> Int32</summary>
      Type_Integer_32,
      /// <summary> Int32u</summary>
      Type_Integer_32u,
      /// <summary> Int64</summary>
      Type_Integer_64,
      /// <summary> Int64u</summary>
      Type_Integer_64u,
      /// <summary> Int128</summary>
      Type_Integer_128,
      /// <summary> Int128u</summary>
      Type_Integer_128u,
      /// <summary> Single</summary>
      Type_Float_Single,
      /// <summary> Double</summary>
      Type_Float_Double,
      /// <summary> Extended</summary>
      Type_Float_Extended,
      Type_Size_t,
      Type_Complex,
      Type_Decimal,
      Type_BigNum,
      Type_Date,
      Type_String,
      Type_StringView,
      /// <summary> LPCSTR</summary>
      Type_String_LPCSTR,
      /// <summary> FixedStr</summary>
      Type_String_Fixed,
      /// <summary> WideStr</summary>
      Type_String_Wide,
      /// <summary> StackList</summary>
      Type_List_Stack,
      /// <summary> TableList</summary>
      Type_List_Table,
      /// <summary> SortedList</summary>
      Type_List_Sorted,
      Type_Null,
      Type_Void,
      Type_Any,
      Type_Pointer,
      Type_Omni,
      Type_UserDefined,
      Type_DataType,
      Type_Namespace,
      Type_IntPtr,
      Type_ADDR,
      Type_uCalcPtr,
      Type_Item,
      Type_ParsedExpr,
      Type_uCalcCallback,
      Type_Object,
      Type_Intrinsic
   };
   
   /// <summary> Data type constructors</summary>
   enum DataTypeConstruction : int32_t {
      TypeConstr_ByteSize,
      TypeConstr_AllocArray,
      TypeConstr_AllocScalar,
      TypeConstr_AllocByPtr,
      TypeConstr_ReleaseArray,
      TypeConstr_ReleaseScalar,
      TypeConstr_ResetScalar,
      TypeConstr_ResetArray,
      TypeConstr_SetArrayValue,
      TypeConstr_SetScalarValue,
      TypeConstr_SwapScalarValues
   };
   
   /// <summary> Error hander responses</summary>
   enum ErrorHandlerResponseEnum : int32_t {
      /// <summary> Immediately stops parsing</summary>
      ErrorAbort,
      /// <summary> Continues parsing (after the error is resolved)</summary>
      ErrorResume,
      /// <summary> Raises the same error again for the next error handler to take care of</summary>
      ErrorReRaise
   };
   
   /// <summary> Error numbers that uCalc may return</summary>
   enum ErrorNumberEnum : int32_t {
      /// <summary> No error</summary>
      Err_None,
      /// <summary> Inexact result</summary>
      Err_FloatInexact = 1,
      /// <summary> Floating point underflow</summary>
      Err_FloatUnderflow = 2,
      /// <summary> Floating point overflow</summary>
      Err_FloatOverflow = 4,
      /// <summary> Division by 0</summary>
      Err_FloatDivisionByZero = 8,
      /// <summary> Invalid floating point value</summary>
      Err_FloatInvalid = 16,
      /// <summary> Dynamically defined user error</summary>
      Err_Dynamically_Defined,
      /// <summary> Syntax error</summary>
      Err_Syntax_Error,
      /// <summary> Undefined identifier</summary>
      Err_Undefined_Identifier,
      /// <summary> File not found</summary>
      Err_FileNotFound,
      /// <summary> Unrecognized token</summary>
      Err_Unrecognized_Token,
      /// <summary> Unrecognized command</summary>
      Err_Unrecognized_Command,
      /// <summary> Data type mismatch</summary>
      Err_Datatype_Mismatch,
      /// <summary> Invalid number of arguments</summary>
      Err_Invalid_Argument_Count,
      /// <summary> Invalid definition</summary>
      Err_Invalid_Definition,
      /// <summary> Bracket delimiter error</summary>
      Err_Bracket_Error,
      /// <summary> Undefined callback</summary>
      Err_Undefined_Callback,
      /// <summary> Error message already defined</summary>
      Err_ErrorMessageAlreadyDefined,
      /// <summary> This item cannot be modified</summary>
      Err_ItemCannotBeModified,
      /// <summary> Unrecognized class member</summary>
      Err_Unrecognized_Class_Member,
      /// <summary> Unrecognized namespace member</summary>
      Err_Unrecognized_Namespace_Member,
      /// <summary> Unbalanced quote</summary>
      Err_Unbalanced_Quote,
      /// <summary> Value cannot be assigned here</summary>
      Err_ValueCannotBeAssigned,
      /// <summary> Reparsing has passed the specified limit</summary>
      Err_ReParseOverflow,
      /// <summary> Array or list bound exceeded</summary>
      Err_Array_Bounds_Exceeded,
      Err_Customized1 = 100,
      Err_Customized2,
      Err_Customized3,
      Err_Customized4,
      Err_Customized5,
      Err_Customized6,
      Err_Customized7,
      Err_Customized8,
      Err_Customized9,
      Err_Customized10,
      Err_Customized11,
      Err_Customized12,
      Err_Customized13,
      Err_Customized14,
      Err_Customized15,
      Err_Customized16,
      Err_Customized17,
      Err_Customized18,
      Err_Customized19,
      Err_Customized20
   };
   
   /// <summary> Operator grouping associativity</summary>
   enum GroupingEnum : int32_t {
      GroupLeftToRight,
      GroupRightToLeft
   };
   
   /// <summary> Properties that a uCalc item may have</summary>
   ///  <remarks>
   /// <para>
   /// Items defined with uCalc typically have a combination of properties.  A variable defined
   /// with DefineVariable for instance will have the ItemIsEnum.Variable property set.  An operator
   /// will have the ItemIsEnum.Operator property set.  If it's an infix operator, in addition to
   /// having the ItemIsEnum.Operator property set, ItemIsEnum.Infix will also be set.
   /// property will also be set.</para>
   /// <para>The IsProperty function can determine if a given uCalc.Item has a certain property.</para>
   /// <para>You can use the GetItemOfProperty function to cycle through the list of all items that share
   /// certain properties, or to disambiguate between items that share the same name but have
   /// different roperties (for instance the + operator with the Prefix property vs another one
   /// with the Infix property).</para>
   /// <para>Some members are keywords in VB.NET.  To avoid naming conflict, the following members have been
   /// renamed in the VB.NET header: Function_, Operator_, Optional_, ByVal_, ByRef_, Class_, and NameSpace_.
   /// </para>
   /// </remarks>
   enum ItemIsEnum : int32_t {
      SelectAny,
      SelectAll,
      RightToLeft_,
      DataType__,
      Array,
      Class,
      Namespace,
      Variable,
      Function,
      Operator,
      FunctionOrOperator,
      Prefix,
      Infix,
      Postfix,
      /// <summary> +++ Use MemoryIndex instead</summary>
      AddressOwner,
      ByVal,
      ByRef,
      ByCopy,
      ByExpr,
      ByHandle,
      Pointer,
      Optional,
      VariableNumberOfArgs,
      Alias_,
      LiteralItem,
      Locked,
      /// <summary> +++ May need to rename; Purpose of Exclude: cause match to fail if this search item is found</summary>
      Exclude,
      /// <summary> +++ Remove underscore after reorganization</summary>
      Transform_,
      Search,
      /// <summary> +++ Remove this; not used (for now)</summary>
      SubSearch,
      FinishedSearch,
      ReturnSelf,
      ErrorHandler,
      ApiCall,
      CaseSensitive_,
      QuotedText,
      /// <summary> +++ RewindOnModify, RewindOnUpdate, RewindOnAlter, RewindOnRevise, RewindOnRevision, RewindOnRewriteRewindOnEdit, other?</summary>
      RewindOnChange_,
      TransformArg,
      /// <summary> +++ Alternative name: Enabled</summary>
      Active_,
      /// <summary> +++ Maybe rename WhiteSpaceSensitive</summary>
      WhiteSpaceCounts,
      IgnoreQuote,
      IgnoreStatementSep,
      IgnoreBracket,
      SkipEvalTransform,
      ExprUnit,
      EagerArg,
      SkipPatternMatching,
      SkipOver_,
      Modified,
      UpdatePending,
      ParentUpdatePending,
      UpToEndOrSeparator,
      UpToCompleted,
      SkipReduce,
      PatternCheck,
      EvalStrOutput,
      SkipOutput,
      NotFound,
      ListReturned,
      /// <summary> +++ Temp solution</summary>
      DisconnectedParent,
      MiscItem
   };
   
   /// <summary> Licensing options for uCalc products</summary>
   enum LicenseTypeEnum : int32_t {
      License_Demo,
      License_FMP_Free,
      License_FMP_Standard_32,
      License_FMP_Standard_64,
      License_FMP_32_and_64,
      License_LanguageBuilder,
      License_GeneralParser,
      License_Interpreter,
      License_ConsoleCalc,
      License_WindowsCalc,
      License_StringLib,
      License_Transform,
      License_TransformLib,
      License_Search,
      License_SearchLib,
      License_Library1,
      License_Library2,
      License_Beta,
      License_Debugger,
      License_uCalc_All,
      License_Developer,
      License_EndUser
   };
   
   /// <summary> Types of tokens</summary>
   enum TokenEnum : int32_t {
      None,
      /// <summary> A token defined without any specified property is generic (default)</summary>
      Generic,
      /// <summary> Represents the absence of any character (token not found)</summary>
      Empty,
      /// <summary> A token that behaves as alphanuric (works with word boundaries)</summary>
      AlphaNumeric,
      /// <summary> A token that serves as argument separator (typically a comma)</summary>
      ArgSeparator,
      /// <summary> A token that starts a bracketed group; typically strings like {, [, or (</summary>
      Bracket,
      /// <summary> The closing token that matches a Bracket token. Ex: }, ], or )</summary>
      BracketMatch_,
      /// <summary> A token that separates an object from its member, typically a . (a dot)</summary>
      MemberAccess,
      /// <summary> A token that represents a literal value, typically a quoted string or number</summary>
      Literal,
      /// <summary> A token that represents a statement separator, typically a ; (semicolon)</summary>
      StatementSep,
      /// <summary> A token that represents whitespace, typically tab or space characters</summary>
      WhiteSpace,
      /// <summary> A token that is not delimited by word boundaries (+, -, *, etc), consecutive characters are reduced until they match a value that exists in the symbol table or until 1 character</summary>
      Reducible,
      /// <summary> Non-character that represents the end of a stream of text</summary>
      Eof,
      CurrentThread,
      LocalVar,
      StaticVar,
      /// <summary> Item in parenthesis (or quotes) following this token will be defined while the expression is parsed</summary>
      DefineNow = StaticVar,
      TempDef,
      /// <summary> The expression in parathesis (or quotes) following the token is evaluated and inserted in place of the token in the string</summary>
      EvalInsert,
      EvalDuringParse,
      /// <summary> Works like EvalInsert, except the expression is transformed instead of evaluated  +++ Is it used?</summary>
      TransformInsert,
      /// <summary> The contents of the quoted file name following this token is inserted into the string</summary>
      FileInclude,
      CurrentSpace,
      DefSpace,
      EvalSpace,
      TokenTransform
   };
   
   /// <summary> RegEx grammar option for defining tokens; based on C++ regex flags</summary>
   enum RegExGrammarEnum : int32_t {
      /// <summary> Default grammar; ECMAScript is default unless reconfigured with +++</summary>
      RegEx_Default,
      /// <summary> JavaScript-like regex grammar</summary>
      RegEx_ECMAScript,
      /// <summary> Basic POSIX grammar (BRE)</summary>
      RegEx_basic,
      /// <summary> Extended POSIX grammar (ERE)</summary>
      RegEx_extended,
      /// <summary> awk POSIX grammar</summary>
      RegEx_awk,
      /// <summary> grep POSIX grammar</summary>
      RegEx_grep,
      /// <summary> egrep POXIX grammar</summary>
      RegEx_egrep
   };
   
   /// <summary> Transform reset options</summary>
   ///  <remarks>
   /// <para>Use these options with Transform Reset.  The Default is Reset_All</para>
   /// </remarks>
   enum TransformResetEnum : int32_t {
      /// <summary> Resets all (Input, Tokens, Rules)</summary>
      Reset_All,
      /// <summary> Resets the input to an empty string</summary>
      Reset_Input,
      /// <summary> Resets token definitions</summary>
      Reset_Tokens,
      /// <summary> Resets the FromTo rules</summary>
      Reset_Rules,
      /// <summary> Resets transform results</summary>
      Reset_Results,
      /// <summary> Removes passes</summary>
      Reset_Passes
   };
   
   /// <summary> Options for Transform Pass</summary>
   enum PassEnum : int32_t {
      /// <summary> Creates a pass with new token definitions that are separate from those of the parent +++ and separate one for transforms</summary>
      Pass_Independent,
      /// <summary> Creates a pass that inherits a separate copy of the token list from the parent</summary>
      Pass_InheritCopy,
      /// <summary> Creates a pass with that shares the same tokens as the parent</summary>
      Pass_InheritShare
   };
   
   /// <summary> Options for transform steps</summary>
   enum StepsEnum : int32_t {
      Steps_None,
      Steps_All,
      Steps_Passes
   };
   
   /// <summary> Transform Properties</summary>
   enum TransformPropertiesEnum : int32_t {
      NoTransformProperties,
      /// <summary> Save snapshots of entire text for each change</summary>
      Snapshot_EachChange = 1,
      /// <summary> Save snapshots of entire text for each pass</summary>
      Snapshot_EachPass = 2,
      /// <summary> Save snapshots of each local change</summary>
      Snapshot_LocalChange = 4,
      /// <summary> Save snapshots of local text before each change</summary>
      Archive_LocalOriginals = 5,
      /// <summary> Count number of modifications made by each rule</summary>
      CountChanges = 8
   };
   
   enum uCalcCompareEnum : int32_t {
      uc_LessThan = -1,
      uc_Equal = 0,
      uc_Greater = 1
   };
   
   enum ChildStringOptionEnum : int32_t {
      ClearAllOnNewObj,
      ClearOverlapOnRead,
      ClearOverlapOnWrite,
      /// <summary> +++ Split Detach in 2; add to string obj vs add to ucalc Obj(/summary) 
      DetachAllOnNewObj,
      DetachOverlapOnRead,
      DetachOverlapOnWrite
   };
   
   enum uCalcList : int32_t {
      /// <summary> +++ Rethink uCalcList</summary>
      List_None,
      Chars,
      Tokens_,
      Elments,
      Statements,
      Lines,
      Matches
   };
   
   typedef void (*uCalcPtr)(bool, char, int, long, float, double);
   typedef void (StdCall *uCalcCallback)(uCalcPtr);
   
   extern "C" DllImport const char * StdCall Name_1(void * , size_t & );
   extern "C" DllImport const char * StdCall Text_2(void * , size_t & );
   extern "C" DllImport int32_t StdCall IsProperty_3(void *  , ItemIsEnum ItemProperty);
   extern "C" DllImport void StdCall IsProperty_4(void *  , ItemIsEnum ItemProperty , int32_t TrueOrFalse);
   extern "C" DllImport uCalcPtr StdCall NextOverload_5(void * );
   extern "C" DllImport const char * StdCall Comment_6(void * , size_t & );
   extern "C" DllImport uCalcPtr StdCall Comment_7(void *  , const char *, size_t CommentStr);
   extern "C" DllImport uCalcPtr StdCall DataType_8(void * );
   extern "C" DllImport void StdCall DataType_9(void *  , void * dType);
   extern "C" DllImport uCalcPtr StdCall uCalc_10(void * );
   extern "C" DllImport size_t StdCall Count_11(void * );
   extern "C" DllImport uCalcCallback StdCall FunctionAddress_12(void * );
   extern "C" DllImport size_t StdCall Precedence_13(void * );
   extern "C" DllImport void StdCall Precedence_14(void *  , size_t Level);
   extern "C" DllImport uCalcPtr StdCall Rename_15(void *  , const char *, size_t NewName);
   extern "C" DllImport double StdCall Value_16(void * );
   extern "C" DllImport void StdCall Value_17(void *  , double Value);
   extern "C" DllImport void StdCall Value_18(void *  , const char *, size_t Value);
   extern "C" DllImport int32_t StdCall ValueBool_19(void * );
   extern "C" DllImport void StdCall ValueBool_20(void *  , int32_t Value);
   extern "C" DllImport uint8_t StdCall ValueByte_21(void * );
   extern "C" DllImport void StdCall ValueByte_22(void *  , uint8_t Value);
   extern "C" DllImport int16_t StdCall ValueInt16_23(void * );
   extern "C" DllImport void StdCall ValueInt16_24(void *  , int16_t Value);
   extern "C" DllImport int32_t StdCall ValueInt32_25(void * );
   extern "C" DllImport void StdCall ValueInt32_26(void *  , int32_t Value);
   extern "C" DllImport int64_t StdCall ValueInt64_27(void * );
   extern "C" DllImport void StdCall ValueInt64_28(void *  , int64_t Value);
   extern "C" DllImport float StdCall ValueSng_29(void * );
   extern "C" DllImport void StdCall ValueSng_30(void *  , float Value);
   extern "C" DllImport double StdCall ValueDbl_31(void * );
   extern "C" DllImport void StdCall ValueDbl_32(void *  , double Value);
   extern "C" DllImport const char * StdCall ValueStr_33(void * , size_t & );
   extern "C" DllImport void StdCall ValueStr_34(void *  , const char *, size_t Value);
   extern "C" DllImport void * StdCall ValuePtr_35(void * );
   extern "C" DllImport void StdCall ValuePtr_36(void *  , void * Value);
   extern "C" DllImport void StdCall ValueByPtr_37(void *  , void * Value);
   extern "C" DllImport void * StdCall ValueAddr_38(void * );
   extern "C" DllImport void * StdCall Handle_39(void * );
   extern "C" DllImport void StdCall Release_40(void * );
   extern "C" DllImport double StdCall Evaluate_41(void * );
   extern "C" DllImport double StdCall EvaluateDbl_42(void * );
   extern "C" DllImport int32_t StdCall EvaluateInt32_43(void * );
   extern "C" DllImport int32_t StdCall EvaluateBool_44(void * );
   extern "C" DllImport const char * StdCall EvaluateStr_45(void * , size_t & );
   extern "C" DllImport void * StdCall EvaluateVoid_46(void * );
   extern "C" DllImport void StdCall Execute_47(void * );
   extern "C" DllImport uCalcPtr StdCall DataType_48(void * );
   extern "C" DllImport void * StdCall Handle_49(void * );
   extern "C" DllImport void StdCall Release_50(void * );
   extern "C" DllImport double StdCall Arg_51(void *  , size_t Index);
   extern "C" DllImport double StdCall ArgDbl_52(void *  , size_t Index);
   extern "C" DllImport double StdCall Arg1_53(void * );
   extern "C" DllImport double StdCall Arg2_54(void * );
   extern "C" DllImport int32_t StdCall ArgBool_55(void *  , size_t Index);
   extern "C" DllImport size_t StdCall ArgCount_56(void * );
   extern "C" DllImport uCalcPtr StdCall ArgObj_57(void *  , size_t Index);
   extern "C" DllImport void * StdCall ArgAddr_58(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall ArgExpr_59(void *  , size_t Index);
   extern "C" DllImport int32_t StdCall ArgInt32_60(void *  , size_t Index);
   extern "C" DllImport int64_t StdCall ArgInt64_61(void *  , size_t Index);
   extern "C" DllImport void * StdCall ArgPtr_62(void *  , size_t Index);
   extern "C" DllImport const char * StdCall ArgStr_63(void * , size_t & , size_t Index);
   extern "C" DllImport void StdCall Return_64(void *  , double Value);
   extern "C" DllImport void StdCall ReturnDbl_65(void *  , double Value);
   extern "C" DllImport void StdCall ReturnBool_66(void *  , int32_t Value);
   extern "C" DllImport void StdCall ReturnInt32_67(void *  , int32_t Value);
   extern "C" DllImport void StdCall ReturnInt64_68(void *  , int64_t Value);
   extern "C" DllImport void StdCall ReturnPtr_69(void *  , void * Value);
   extern "C" DllImport void StdCall ReturnStr_70(void *  , const char *, size_t Value);
   extern "C" DllImport void StdCall ErrorSet_71(void *  , ErrorNumberEnum ErrNumber);
   extern "C" DllImport ErrorHandlerResponseEnum StdCall ErrorRaise_72(void *  , ErrorNumberEnum ErrNumber);
   extern "C" DllImport ErrorHandlerResponseEnum StdCall ErrorRaiseMessage_73(void *  , const char *, size_t ErrMessage);
   extern "C" DllImport uCalcPtr StdCall uCalc_74(void * );
   extern "C" DllImport uCalcPtr StdCall Item_75(void * );
   extern "C" DllImport void * StdCall Handle_76(void * );
   extern "C" DllImport void StdCall Release_77(void * );
   extern "C" DllImport size_t StdCall ByteSize_78(void * );
   extern "C" DllImport BuiltInTypesEnum StdCall Index_79(void * );
   extern "C" DllImport uCalcPtr StdCall Item_80(void * );
   extern "C" DllImport const char * StdCall Name_81(void * , size_t & );
   extern "C" DllImport void StdCall Reset_82(void *  , void * ValuePtr , size_t Size);
   extern "C" DllImport void StdCall Reset_83(void *  , void * ValuePtr);
   extern "C" DllImport void StdCall SetArray_84(void *  , void * Destination , void * Source , size_t Index);
   extern "C" DllImport void StdCall SetScalar_85(void *  , void * Destination , void * Source);
   extern "C" DllImport void StdCall SwapScalarValues_86(void *  , void * ValuePtrA , void * ValuePtrB);
   extern "C" DllImport const char * StdCall ToString_87(void * , size_t & , void * ValuePtr);
   extern "C" DllImport const char * StdCall ToString_88(void * , size_t & , const char *, size_t Value);
   extern "C" DllImport void * StdCall Handle_89(void * );
   extern "C" DllImport void StdCall Release_90(void * );
   extern "C" DllImport uCalcPtr StdCall DefineRule_91(void *  , const char *, size_t Comment , const char *, size_t FindStr , const char *, size_t ToStr , size_t Min , size_t Max , size_t MinHard , size_t MaxHard , size_t Precedence , size_t StartAfter , size_t StopAfter , int32_t SkipOver , int32_t RewindOnChange , int32_t CaseSensitive , int32_t BracketSensitive , int32_t QuoteSensitive , int32_t RightToLeft);
   extern "C" DllImport uCalcPtr StdCall DefineToken_92(void *  , const char *, size_t TokenDef , TokenEnum TokenType, const char *, size_t CloseBracket, size_t SubMatch, RegExGrammarEnum RegExGrammar);
   extern "C" DllImport void StdCall RemoveToken_93(void * );
   extern "C" DllImport uCalcPtr StdCall Tokens_94(void * );
   extern "C" DllImport uCalcPtr StdCall FromTo_95(void *  , const char *, size_t FromStr , const char *, size_t ToStr);
   extern "C" DllImport uCalcPtr StdCall uCalc_96(void *  , void * uCalcHandle);
   extern "C" DllImport uCalcPtr StdCall NewPass_97(void *  , int32_t Share);
   extern "C" DllImport uCalcPtr StdCall Pass_98(void *  , size_t Index , int32_t Share);
   extern "C" DllImport uCalcPtr StdCall Reset_99(void *  , TransformResetEnum ResetOption);
   extern "C" DllImport uCalcPtr StdCall Transform_100(void * );
   extern "C" DllImport const char * StdCall Transform_101(void * , size_t & , const char *, size_t expression);
   extern "C" DllImport uCalcPtr StdCall TransformWithSteps_102(void *  , const char *, size_t expression);
   extern "C" DllImport const char * StdCall Str_103(void * , size_t & );
   extern "C" DllImport uCalcPtr StdCall Str_104(void *  , const char *, size_t InputStr);
   extern "C" DllImport const char * StdCall StrData_105(void * );
   extern "C" DllImport size_t StdCall StrLength_106(void * );
   extern "C" DllImport uCalcPtr StdCall IndexBase_107(void *  , size_t BaseValue);
   extern "C" DllImport size_t StdCall IndexBase_108(void * );
   extern "C" DllImport int32_t StdCall WasModified_109(void * );
   extern "C" DllImport uCalcPtr StdCall RulesDefault_110(void * );
   extern "C" DllImport uCalcPtr StdCall RulesOverall_111(void * );
   extern "C" DllImport uCalcPtr StdCall Rule_112(void *  , size_t Index);
   extern "C" DllImport void * StdCall Handle_113(void * );
   extern "C" DllImport void StdCall Release_114(void * );
   extern "C" DllImport uCalcPtr StdCall Active_115(void *  , int32_t TrueFalse);
   extern "C" DllImport const char * StdCall FindPart_116(void * , size_t & );
   extern "C" DllImport uCalcPtr StdCall FindPart_117(void *  , const char *, size_t Pattern);
   extern "C" DllImport const char * StdCall FromPart_118(void * , size_t & );
   extern "C" DllImport uCalcPtr StdCall FromPart_119(void *  , const char *, size_t Pattern);
   extern "C" DllImport const char * StdCall ToPart_120(void * , size_t & );
   extern "C" DllImport uCalcPtr StdCall ToPart_121(void *  , const char *, size_t Pattern);
   extern "C" DllImport uCalcPtr StdCall CaseSensitive_122(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall IgnoreInnerPatterns_123(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall WhitespaceSensitive_124(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall BracketSensitive_125(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall LocalTransform_126(void *  , void * t);
   extern "C" DllImport size_t StdCall Maximum_127(void * );
   extern "C" DllImport uCalcPtr StdCall Maximum_128(void *  , size_t Value);
   extern "C" DllImport size_t StdCall MaximumHard_129(void * );
   extern "C" DllImport uCalcPtr StdCall MaximumHard_130(void *  , size_t Value);
   extern "C" DllImport size_t StdCall Minimum_131(void * );
   extern "C" DllImport uCalcPtr StdCall Minimum_132(void *  , size_t Value);
   extern "C" DllImport size_t StdCall MinimumHard_133(void * );
   extern "C" DllImport uCalcPtr StdCall MinimumHard_134(void *  , size_t Value);
   extern "C" DllImport size_t StdCall Precedence_135(void * );
   extern "C" DllImport uCalcPtr StdCall Precedence_136(void *  , size_t Value);
   extern "C" DllImport uCalcPtr StdCall Property_137(void *  , ItemIsEnum SelectedProperty , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall QuoteSensitive_138(void *  , int32_t TrueFalse);
   extern "C" DllImport const char * StdCall ReplacementText_139(void * , size_t & );
   extern "C" DllImport size_t StdCall StartAfter_140(void * );
   extern "C" DllImport uCalcPtr StdCall StartAfter_141(void *  , size_t Value);
   extern "C" DllImport size_t StdCall StopAfter_142(void * );
   extern "C" DllImport uCalcPtr StdCall StopAfter_143(void *  , size_t Value);
   extern "C" DllImport uCalcPtr StdCall SkipOver_144(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall RewindOnChange_145(void *  , int32_t TrueFalse);
   extern "C" DllImport uCalcPtr StdCall RightToLeft_146(void *  , int32_t TrueFalse);
   extern "C" DllImport void * StdCall Handle_147(void * );
   extern "C" DllImport void StdCall Release_148(void * );
   extern "C" DllImport uCalcPtr StdCall Import_149(void *  , void * FromTokenList);
   extern "C" DllImport uCalcPtr StdCall Define_150(void *  , const char *, size_t TokenDef , TokenEnum TokenType, const char *, size_t CloseBracket, size_t SubMatch, RegExGrammarEnum RegExGrammar);
   extern "C" DllImport void * StdCall Handle_151(void * );
   extern "C" DllImport void StdCall Release_152(void * );
   extern "C" DllImport size_t StdCall TokenCharLen_153(void *  , size_t StartIndex , size_t Count);
   extern "C" DllImport size_t StdCall TokenCount_154(void *  , size_t Index);
   extern "C" DllImport TokenEnum StdCall TokenType_155(void *  , size_t Index);
   extern "C" DllImport uCalcCompareEnum StdCall Compare_156(void *  , const char *, size_t OtherString , size_t IndexA, size_t IndexB, size_t Length);
   extern "C" DllImport size_t StdCall TokenIndexAtChar_157(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall Apply_158(void *  , const char *, size_t expression , const char *, size_t Variable);
   extern "C" DllImport uCalcPtr StdCall At_159(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall AtChar_160(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall AtToken_161(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall BracketMatch_162(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall BracketedText_163(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall BracketedTextInside_164(void *  , size_t Index);
   extern "C" DllImport size_t StdCall BracketMatchTokenIndex_165(void *  , size_t Index);
   extern "C" DllImport size_t StdCall CharPos_166(void *  , size_t Nth);
   extern "C" DllImport size_t StdCall CharCount_167(void *  , size_t Nth);
   extern "C" DllImport size_t StdCall TokenPos_168(void *  , size_t Nth);
   extern "C" DllImport size_t StdCall TokenCharPos_169(void *  , size_t Index);
   extern "C" DllImport const char * StdCall Str_170(void * , size_t & , size_t Nth, size_t TokenCount);
   extern "C" DllImport uCalcPtr StdCall Str_171(void *  , const char *, size_t StringValue);
   extern "C" DllImport uCalcPtr StdCall Find_172(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall FindOtherThan_173(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall Parent_174(void * );
   extern "C" DllImport uCalcPtr StdCall Root_175(void * );
   extern "C" DllImport uCalcPtr StdCall IndexBase_176(void *  , size_t BaseValue);
   extern "C" DllImport size_t StdCall IndexBase_177(void * );
   extern "C" DllImport uCalcPtr StdCall UpTo_178(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall StartingFrom_179(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall StartingFromEndingWith_180(void *  , const char *, size_t StartPattern , const char *, size_t EndPattern , size_t StartNth, size_t EndNth);
   extern "C" DllImport uCalcPtr StdCall Before_181(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall After_182(void *  , const char *, size_t Pattern , size_t Nth);
   extern "C" DllImport uCalcPtr StdCall Between_183(void *  , const char *, size_t StartPattern , const char *, size_t StopPattern , size_t StartNth, size_t StopNth);
   extern "C" DllImport uCalcPtr StdCall ListOfTokens_184(void * );
   extern "C" DllImport uCalcPtr StdCall ListOfChars_185(void * );
   extern "C" DllImport uCalcPtr StdCall SubString_186(void *  , size_t StartPos , size_t Length);
   extern "C" DllImport uCalcPtr StdCall ChildStringOption_187(void *  , ChildStringOptionEnum Option);
   extern "C" DllImport ChildStringOptionEnum StdCall ChildStringOption_188(void * );
   extern "C" DllImport uCalcPtr StdCall ClearDerivedStrings_189(void * );
   extern "C" DllImport uCalcPtr StdCall Remove_190(void *  , const char *, size_t From_);
   extern "C" DllImport uCalcPtr StdCall Replace_191(void *  , const char *, size_t From_ , const char *, size_t To_);
   extern "C" DllImport uCalcPtr StdCall Skip_192(void *  , const char *, size_t Pattern);
   extern "C" DllImport uCalcPtr StdCall ToUpper_193(void *  , const char *, size_t Pattern, size_t Nth);
   extern "C" DllImport uCalcPtr StdCall ToLower_194(void *  , const char *, size_t Pattern, size_t Nth);
   extern "C" DllImport uCalcPtr StdCall List_195(void *  , uCalcList ListType);
   extern "C" DllImport uCalcPtr StdCall ListFormat_196(void *  , const char *, size_t Separator , const char *, size_t Prefix, const char *, size_t Postfix, const char *, size_t UserFunc, const char *, size_t Element, const char *, size_t Index, const char *, size_t Count);
   extern "C" DllImport uCalcPtr StdCall ListSeparator_197(void *  , const char *, size_t Separator);
   extern "C" DllImport uCalcPtr StdCall ListPrefix_198(void *  , const char *, size_t Prefix);
   extern "C" DllImport uCalcPtr StdCall ListPostfix_199(void *  , const char *, size_t Postfix);
   extern "C" DllImport uCalcPtr StdCall ListFunction_200(void *  , const char *, size_t UserFunc , const char *, size_t Element, const char *, size_t Index, const char *, size_t MatchCount);
   extern "C" DllImport uCalcPtr StdCall Populate_201(void *  , double first , double last , const char *, size_t expression , double Step, const char *, size_t Condition, const char *, size_t VarIndex, const char *, size_t VarFirst, const char *, size_t VarLast);
   extern "C" DllImport uCalcPtr StdCall Match_202(void *  , size_t Index);
   extern "C" DllImport size_t StdCall MatchIndexAtChar_203(void *  , size_t Index);
   extern "C" DllImport size_t StdCall MatchIndexAtToken_204(void *  , size_t Index);
   extern "C" DllImport uCalcPtr StdCall NonMatches_205(void * );
   extern "C" DllImport uCalcPtr StdCall SubMatch_206(void *  , size_t Index);
   extern "C" DllImport size_t StdCall MatchCount_207(void * );
   extern "C" DllImport uCalcPtr StdCall Transform_208(void *  , void * tt);
   extern "C" DllImport void * StdCall Handle_209(void * );
   extern "C" DllImport void StdCall Release_210(void * );
   extern "C" DllImport uCalcPtr StdCall AddErrorHandler_211(void *  , uCalcCallback ErrorHandlerAddress , size_t Position);
   extern "C" DllImport uCalcPtr StdCall Create_212(void *  , void * BasedOn);
   extern "C" DllImport uCalcPtr StdCall CreateTempDefault_213(void *  , void * BasedOn);
   extern "C" DllImport uCalcPtr StdCall ReleaseTempDefault_214(void * );
   extern "C" DllImport uCalcPtr StdCall Alias_215(void *  , const char *, size_t NewSymbol , const char *, size_t ExistingSymbol);
   extern "C" DllImport uCalcPtr StdCall Alias_216(void *  , const char *, size_t NewSymbol , void * ExistingItem);
   extern "C" DllImport void StdCall AliasForDefine_217(void *  , const char *, size_t NewCommandName , const char *, size_t ExistingCommandName);
   extern "C" DllImport uCalcPtr StdCall DataTypeOf_218(void *  , const char *, size_t expression);
   extern "C" DllImport uCalcPtr StdCall DataTypeOf_219(void *  , BuiltInTypesEnum Index);
   extern "C" DllImport uCalcPtr StdCall Define_220(void *  , const char *, size_t expression , void * Address, void * dType);
   extern "C" DllImport uCalcPtr StdCall DefineConstant_221(void *  , const char *, size_t Definition , void * VariableAddress);
   extern "C" DllImport uCalcPtr StdCall DefineFunction_222(void *  , const char *, size_t Definition , uCalcCallback FunctionAddr);
   extern "C" DllImport uCalcPtr StdCall DefineOperator_223(void *  , const char *, size_t Definition , size_t iPrecedence , GroupingEnum Grouping, uCalcCallback FunctionAddr);
   extern "C" DllImport uCalcPtr StdCall DefineVariable_224(void *  , const char *, size_t Definition , void * VariableAddress);
   extern "C" DllImport const char * StdCall ErrorExpression_225(void * , size_t & );
   extern "C" DllImport void StdCall ErrorExpression_226(void *  , const char *, size_t expression);
   extern "C" DllImport size_t StdCall ErrorLocation_227(void * );
   extern "C" DllImport const char * StdCall ErrorMessage_228(void * , size_t & , ErrorNumberEnum Index);
   extern "C" DllImport ErrorNumberEnum StdCall ErrorNumber_229(void * );
   extern "C" DllImport void StdCall ErrorResponse_230(void *  , ErrorHandlerResponseEnum Response);
   extern "C" DllImport const char * StdCall ErrorSymbol_231(void * , size_t & );
   extern "C" DllImport double StdCall Eval_232(void *  , const char *, size_t expression);
   extern "C" DllImport const char * StdCall EvalStr_233(void * , size_t & , const char *, size_t expression);
   extern "C" DllImport void StdCall RaiseErrorOnDivideByZero_234(void *  , int32_t TrueOrFalse);
   extern "C" DllImport void StdCall RaiseErrorOnInexact_235(void *  , int32_t TrueOrFalse);
   extern "C" DllImport void StdCall RaiseErrorOnUnderflow_236(void *  , int32_t TrueOrFalse);
   extern "C" DllImport void StdCall RaiseErrorOnOverflow_237(void *  , int32_t TrueOrFalse);
   extern "C" DllImport void StdCall RaiseErrorOnInvalid_238(void *  , int32_t TrueOrFalse);
   extern "C" DllImport int32_t StdCall FloatingPointErrorsToCatch_239(void *  , int32_t Value);
   extern "C" DllImport uCalcPtr StdCall ItemOf_240(void *  , const char *, size_t ItemName , int64_t Properties);
   extern "C" DllImport uCalcPtr StdCall ItemOf_241(void *  , ItemIsEnum Property_ , size_t nth , const char *, size_t DataTypeName);
   extern "C" DllImport uCalcPtr StdCall NamespaceChild_242(void *  , size_t nth);
   extern "C" DllImport size_t StdCall NamespaceChildCount_243(void * );
   extern "C" DllImport uCalcPtr StdCall NamespaceParent_244(void *  , size_t Level);
   extern "C" DllImport uCalcPtr StdCall NamespaceSymbol_245(void *  , size_t nth);
   extern "C" DllImport size_t StdCall NamespaceSymbolCount_246(void * );
   extern "C" DllImport uCalcPtr StdCall NewString_247(void *  , const char *, size_t InitialString);
   extern "C" DllImport uCalcPtr StdCall NewTransform_248(void * );
   extern "C" DllImport uCalcPtr StdCall ExpressionTransforms_249(void * );
   extern "C" DllImport uCalcPtr StdCall Parse_250(void *  , const char *, size_t expression , void * DataType);
   extern "C" DllImport uCalcPtr StdCall Parse_251(void *  , const char *, size_t expression , const char *, size_t DataType);
   extern "C" DllImport uCalcPtr StdCall Parse_252(void *  , const char *, size_t expression , BuiltInTypesEnum DataTypeIndex);
   extern "C" DllImport size_t StdCall Precedence_253(void *  , const char *, size_t Operator1 , const char *, size_t Operator2);
   extern "C" DllImport int64_t StdCall Properties_254(void *  , ItemIsEnum p1 , ItemIsEnum p2, ItemIsEnum p3, ItemIsEnum p4);
   extern "C" DllImport uCalcPtr StdCall DefaultItem_255(void * );
   extern "C" DllImport uCalcPtr StdCall DefaultDataType_256(void * );
   extern "C" DllImport void StdCall DefaultDataType_257(void *  , void * dType);
   extern "C" DllImport void StdCall DefaultDataType_258(void *  , BuiltInTypesEnum DataTypeIndex);
   extern "C" DllImport void StdCall DefaultDataType_259(void *  , const char *, size_t dTypeStr);
   extern "C" DllImport int32_t StdCall IsDefault_260(void * );
   extern "C" DllImport void StdCall IsDefault_261(void *  , int32_t Condition);
   extern "C" DllImport uCalcPtr StdCall Default_262(void * );
   extern "C" DllImport void StdCall Default_263(void *  , void * uCalcObj);
   extern "C" DllImport uCalcPtr StdCall Format_264(void *  , uCalcCallback FunctionAddr , const char *, size_t Properties);
   extern "C" DllImport uCalcPtr StdCall Format_265(void *  , uCalcCallback FunctionAddr , void * dType);
   extern "C" DllImport uCalcPtr StdCall Format_266(void *  , const char *, size_t Definition , void * dType);
   extern "C" DllImport void StdCall FormatRemove_267(void *  , void * dType);
   extern "C" DllImport const char * StdCall ValueAt_268(void * , size_t & , void * ValuePtr , void * dType);
   extern "C" DllImport const char * StdCall ValueAt_269(void * , size_t & , void * ValuePtr , const char *, size_t ValueDataType);
   extern "C" DllImport void StdCall License_270(void *  , LicenseTypeEnum LicenseType , size_t L1, size_t L2, size_t L3, size_t L4, size_t L5);
   extern "C" DllImport void * StdCall Handle_271(void * );
   extern "C" DllImport void StdCall Release_272(void * );
   
   /// <summary> uCalc main class</summary> 
   struct  uCalc {
      
      // CS ImportStatements
      
      struct Expression;
      struct Item;
      struct Callback;
      struct DataType;
      struct Transforms;
      struct Rule;
      struct Tokens;
      struct String;
      // +++ Add a base class with Is, SymbolName, etc.
      
      struct Base;
      
      struct Base {
         /// <summary> Handle for Base Class</summary> 
         uCalcPtr hb;
         
         /// <summary> Returns the name of the uCalc Item</summary> 
         /// <remarks>
         /// <para>Items such as functions, operators, variables, etc generally are given a name when they are defined.
         ///          That name can be retried with this function.</para>
         /// </remarks> 
         string Name() {
            size_t ReturnStrSize;
            const char * ReturnStr = Name_1(hb, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Returns the text data associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Certain items may have a text property that can be retrieved with a call to this function.  The literal text
         ///          used to define an item is usually stored here.
         /// </para>
         /// </remarks> 
         string Text() {
            size_t ReturnStrSize;
            const char * ReturnStr = Text_2(hb, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Determines if a uCalc Item has the given properties</summary> 
         /// <param name="ItemProperty"> The property you want to check for</param>
         /// <returns> Returns True if the uCalc Item matches the given property, or False otherwise.</returns>
         /// <remarks>
         /// <para>This helps you determine whether the uCalc Item is a function, operator, variable, data type,
         ///            literal value, etc, or has certain other special properties.  Note: Some items may have multiple
         ///            properties.  For instance the Function property may be set to true for arrays.
         ///            +++ Maybe (or maybe not; Transform class has them) have complete set of Is functions.  For instance IsCaseSensitive(), IsFunction(), IsVariable(), etc...
         ///            and for some you can change the value like IsCaseSensitive(true) sets the property to true.
         /// </para>
         /// </remarks> 
         bool IsProperty(ItemIsEnum ItemProperty) { return IsProperty_3(hb, ItemProperty);          }
         
         /// <summary> Sets a given property</summary> 
         /// <param name="ItemProperty"> The property you want to check for</param>
         /// <param name="TrueOrFalse"> Value to set the property to</param>
         /// <returns> Returns True if the uCalc Item matches the given property, or False otherwise.</returns>
         /// <remarks>
         /// <para>This helps you determine whether the uCalc Item is a function, operator, variable, data type,
         ///          literal value, etc, or has certain other special properties.  Note: Some items may have multiple
         ///          properties.  For instance the Function property may be set to true for arrays.
         ///          +++ Maybe (or maybe not; Transform class has them) have complete set of Is functions.  For instance IsCaseSensitive(), IsFunction(), IsVariable(), etc...
         ///          and for some you can change the value like IsCaseSensitive(true) sets the property to true.
         /// </para>
         /// </remarks> 
         void IsProperty(ItemIsEnum ItemProperty ,bool TrueOrFalse) { IsProperty_4(hb, ItemProperty , TrueOrFalse);          }
         
         /// <summary> Returns next uCalc Item object that shares the same name</summary> 
         /// <returns> Returns next uCalc Item object that shares the same name, or a NULL (or 0) if there is none</returns>
         /// <remarks>
         /// <para>If several functions, operators, parameters, etc are overloaded -- that is they are defined with different
         ///          parameters but share the same name --, or if they (or variables) overshadow each other, this function returns
         ///          the next uCalc.Item object that shares the same name.
         /// </para>
         /// </remarks> 
         Item NextOverload() { return NextOverload_5(hb);          }
         
         /// <summary> Associates a comment with a rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///          Each rule can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system, or as a tool tip.
         /// </para>
         /// </remarks> 
         string Comment() {
            size_t ReturnStrSize;
            const char * ReturnStr = Comment_6(hb, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Associates a comment with a rule</summary> 
         /// <param name="CommentStr"> Text of the comment</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///          Each rule can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system, or as a tool tip.
         /// </para>
         /// </remarks> 
         Rule Comment(const string & CommentStr) { return Comment_7(hb, CommentStr.data(), CommentStr.size());          }
         
         /// <summary> Returns the data type of a uCalc Item</summary> 
         /// <remarks>
         /// <para>The returned data type object can be used to determine the type name, size, etc.</para>
         /// </remarks> 
         DataType DataType() { return DataType_8(hb);          }
         
         /// <summary> Sets the data type of a uCalc Item +++ Might no longer be needed</summary> 
         /// <param name="dType"> ...</param>
         /// <remarks>
         /// <para>Intended mainly for use with DefaultItem()</para>
         /// </remarks> 
         void DataType(uCalc::DataType dType) { DataType_9(hb, dType.h);          }
         
         /// <summary> Returns the uCalc object that performs calculations related to the transform</summary> 
         /// <returns> uCalc object associated with current transform</returns>
         /// <remarks>
         /// <para>If your transform inovlves calcuations, then they will be performed using the
         ///          uCalc object returned by this function.  Each uCalc object can have its own sets of
         ///          variables, functions, and other definitions.</para>
         /// <para>         A uCalc.Item is defined in the context of a uCalc object.  You can later use this function to determine
         ///          the uCalc object the defined item belongs to.
         /// </para>
         /// </remarks> 
         uCalc uCalc() { return uCalc_10(hb);          }
      };
      
      /// <summary> Class for handling uCalc items</summary> 
      struct  Item : Base {
         
         /// <summary> Handle for a uCalc Item</summary> 
         uCalcPtr h;
         
         /// <summary> Returns the number of elements in a uCalc Item</summary> 
         /// <remarks>
         /// <para>Depending on the kind of object, this may represent the number of elements in an array, the number of parameters in a function,
         ///          the number of operands in an operator, the number of parameters in a syntax construct, the number of parts in a transform,
         ///          the number of parts in a compound token, or the value explicitlely set in the Count property when calling Define.</para>
         /// <para>         When determining the number of elements, optional parameters in a function count as an element.  If the function
         ///          has a variable number of arguments, then count is -1.</para>
         /// <para>         The value returned for a syntax construct may not seem obvious, especially if it has optional and/or alternative
         ///          parts or some other complexity.</para>
         /// <para>         +++ the number of symbols in a uCalc
         ///          instance,</para>
         /// </remarks> 
         size_t Count() { return Count_11(h);          }
         
         /// <summary> Returns the callback address of a defined function (or operator)</summary> 
         /// <remarks>
         /// <para>The returned value is the actual pointer address of the function as used by uCalc internally, and not
         ///          a delegate, even in .NET.  As such, in .NET this value can be used in the more general Define function but
         ///          not functions like DefineFunction or DefineneOperator.</para>
         /// </remarks> 
         uCalcCallback FunctionAddress() { return FunctionAddress_12(h);          }
         
         /// <summary> Returns the precedence level of the uCalc.Item</summary> 
         /// <remarks>
         /// <para>Operators, and some syntax constructs are defined with a precedence level.  When defining a new operator you
         ///          may sometimes want to give it the same level as a pre-existing operator.</para>
         /// </remarks> 
         size_t Precedence() { return Precedence_13(h);          }
         
         /// <summary> Sets the precedence level of the uCalc Item</summary> 
         /// <param name="Level"> ...</param>
         /// <remarks>
         /// <para>Operators, and some syntax constructs are defined with a precedence level.  When defining a new operator you
         ///          may sometimes want to give it the same level as a pre-existing operator.
         ///          For use mainly with DefaultItem.
         /// </para>
         /// </remarks> 
         void Precedence(size_t Level) { Precedence_14(h, Level);          }
         
         /// <summary> Renames an item</summary> 
         /// <param name="NewName"> The new name of the item</param>
         /// <remarks>
         /// <para>
         /// Any defined item that has a name (such as a variable, constant, function, operator, etc) can be renamed with this function.
         /// </para>
         /// </remarks> 
         Item Rename(const string & NewName) { return Rename_15(h, NewName.data(), NewName.size());          }
         
         /// <summary> Returns the value (default double precision) associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Double precision value associated with a variable.</para>
         /// </remarks> 
         double Value() { return Value_16(h);          }
         
         /// <summary> Sets the value of a floating point variable</summary> 
         /// <param name="Value"> Double precision floating point value that the variable will be set to</param>
         /// <remarks>
         /// <para>When a floating point variable is defined with DefineVariable, you can later set a value for this variable by passing an
         ///            argument to Value.  Note: If your compiler supports pointers, you can define a uCalc variable that is directly attached
         ///            to the address of a variable in your source code, and not have to use Value.
         /// </para>
         /// </remarks> 
         void Value(double Value) { Value_17(h, Value);          }
         
         /// <summary> Sets the value of a variable of any data type by passing a string</summary> 
         /// <param name="Value"> String containing the value that will be converted and stored in the variable</param>
         /// <remarks>
         /// <para>This lets you set the value of a variable defined with DefineVariable (or Define) regardless of the variable's data type.
         ///          The value is passed as a string, and internally converted to the appropriate data type.  Note: Because a conversion takes
         ///          place with ValueAny, it is typically slower than calling Value for floating point, or one of the
         ///          other versions of Value specific to a data type.</para>
         /// </remarks> 
         void Value(const string & Value) { Value_18(h, Value.data(), Value.size());          }
         
         /// <summary> Returns the Boolean value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Boolean value associated with a variable.</para>
         /// </remarks> 
         bool ValueBool() { return ValueBool_19(h);          }
         
         /// <summary> Sets the value of a Boolean variable</summary> 
         /// <param name="Value"> Boolean value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a Boolean variable defined with DefineVariable (or Define)</para>
         /// </remarks> 
         void ValueBool(bool Value) { ValueBool_20(h, Value);          }
         
         /// <summary> Returns the uint8_t value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the uint8_t value associated with a variable.</para>
         /// </remarks> 
         uint8_t ValueByte() { return ValueByte_21(h);          }
         
         /// <summary> Sets the value of a uint8_t variable</summary> 
         /// <param name="Value"> uint8_t value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a uint8_t variable defined with DefineVariable (or Define)</para>
         /// </remarks> 
         void ValueByte(uint8_t Value) { ValueByte_22(h, Value);          }
         
         /// <summary> Returns the 16-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int16 value associated with a variable.</para>
         /// </remarks> 
         int16_t ValueInt16() { return ValueInt16_23(h);          }
         
         /// <summary> Sets the value of a 16-bit integer variable</summary> 
         /// <param name="Value"> 16-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 16-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 16-bit integers.</para>
         /// </remarks> 
         void ValueInt16(int16_t Value) { ValueInt16_24(h, Value);          }
         
         /// <summary> Returns the 32-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int32 value associated with a variable.</para>
         /// </remarks> 
         int32_t ValueInt32() { return ValueInt32_25(h);          }
         
         /// <summary> Sets the value of a 32-bit integer variable</summary> 
         /// <param name="Value"> 32-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 32-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 32-bit integers.</para>
         /// </remarks> 
         void ValueInt32(int32_t Value) { ValueInt32_26(h, Value);          }
         
         /// <summary> Returns the 64-bit integer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Int64 value associated with a variable.</para>
         /// </remarks> 
         int64_t ValueInt64() { return ValueInt64_27(h);          }
         
         /// <summary> Sets the value of a 64-bit integer variable</summary> 
         /// <param name="Value"> 64-bit integer value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a 64-bit integer variable defined with DefineVariable (or Define).  This works for
         ///          both signed and unsigned 64-bit integers.</para>
         /// </remarks> 
         void ValueInt64(int64_t Value) { ValueInt64_28(h, Value);          }
         
         /// <summary> Returns the Double precision value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Single precision value associated with a variable.</para>
         /// </remarks> 
         float ValueSng() { return ValueSng_29(h);          }
         
         /// <summary> Sets the value of a single precision floating point variable</summary> 
         /// <param name="Value"> Single precision value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a single precision variable defined with DefineVariable (or Define).</para>
         /// </remarks> 
         void ValueSng(float Value) { ValueSng_30(h, Value);          }
         
         /// <summary> Returns the Double precision value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Synonymous with Value</para>
         /// </remarks> 
         double ValueDbl() { return ValueDbl_31(h);          }
         
         /// <summary> Sets the value of a double precision floating point variable</summary> 
         /// <param name="Value"> Double precision floating point value that the variable will be set to</param>
         /// <remarks>
         /// <para>ValueDbl is synonymous with Value</para>
         /// </remarks> 
         void ValueDbl(double Value) { ValueDbl_32(h, Value);          }
         
         /// <summary> Returns the String value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the String value associated with a variable.</para>
         /// <para>         ValueStr has a special property beyond the Value function for other data types in that it can return the value
         ///          of an item regardless of what data type it has.  The value is returned as a string.
         /// </para>
         /// </remarks> 
         string ValueStr() {
            size_t ReturnStrSize;
            const char * ReturnStr = ValueStr_33(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets the value of a string variable</summary> 
         /// <param name="Value"> String value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a string variable defined with DefineVariable (or Define).</para>
         /// </remarks> 
         void ValueStr(const string & Value) { ValueStr_34(h, Value.data(), Value.size());          }
         
         /// <summary> Returns the Pointer value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Pointer value associated with a variable.
         ///          Note: If the uCalc.Item is a Variable of type Pointer, then ValuePtr returns a pointer value
         ///          that is stored in that variable, whereas ValueAddr returns the Pointer of the variable itself.  In other words
         ///          ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any value you may
         ///          have set as the address the variable points to.</para>
         /// </remarks> 
         void * ValuePtr() { return ValuePtr_35(h);          }
         
         /// <summary> Sets the value of a pointer variable</summary> 
         /// <param name="Value"> Pointer that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a pointer variable defined with DefineVariable (or Define).  Note: This does not
         ///          change the pointer of the variable.  It simply stores a pointer value in the variable.</para>
         /// </remarks> 
         void ValuePtr(void * Value) { ValuePtr_36(h, Value);          }
         
         /// <summary> Sets the value of a variable to a value who's Pointer is passed</summary> 
         /// <param name="Value"> Pointer to the value that the variable will be set to</param>
         /// <remarks>
         /// <para>This lets you set the value of a variable by passing the pointer to the value you want to set the variable to.</para>
         /// </remarks> 
         void ValueByPtr(void * Value) { ValueByPtr_37(h, Value);          }
         
         /// <summary> Returns the Pointer address of the value associated with a uCalc.Item</summary> 
         /// <remarks>
         /// <para>Use this to retrieve the Pointer address of the value associated with a variable (instead of
         ///          the value itself).  Note: If the uCalc.Item is a Variable of type Pointer, then ValuePtr returns a pointer value
         ///          that is stored in that variable, whereas ValueAddr returns the Pointer of the variable itself.  In other words
         ///          ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any given address
         ///          you may have stored as the value of the variable.</para>
         /// </remarks> 
         void * ValueAddr() { return ValueAddr_38(h);          }
         
         // operator string() { return ValueStr(); }
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          +++ check optimization
         ///          ... +++ Do this for other structs too
         /// </para>
         /// </remarks>
         
         // operator double() { return ValueDbl(); }
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         
         Item() { h = nullptr;          } // +++ improve;
         Item(const string & Definition) { h = Default().Define(Definition).h;          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_39(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_40(h); h = nullptr;          }
         
         Item(uCalcPtr PassedHandle) { h = PassedHandle; hb = h;          }
         // +++ Add separate documentation for each Release()
      };
      
      /// <summary> Class for evaluating an already parsed expression or executing parsed code</summary> 
      struct  Expression {
         
         /// <summary> Handle for a uCalc expression</summary> 
         uCalcPtr h;
         
         // IMPORTANT: must have at least 2 blank lines between each EXPORT (for proper transform)
         
         /// <summary> Rapidly evaluates a floating point expression that was parsed with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated expression returned as a floating point number</returns>
         /// <remarks>
         /// <para>Evaluate can be used instead of Eval for faster results in time-critical loops where the same expression
         ///          is repeatedly re-evaluated, with the only change in each iteration typically being the value(s) of one or
         ///          more variables.  Evaluate works in pair with Parse, the relatively slower part, which is called first before
         ///          going into the time-critical loop.  The Expression object returned by Parse is what calls the Evaluate function.</para>
         /// <para>         // +++ Explain better; also in source code example
         ///          // EvaluateDbl vs Evaluate
         ///          // EvaluateDbl is strictly for Double precision floating point expressions.  An expression is Double precision
         ///          // by default, if it does not evaluate implicitlely to Boolean, String, Complex, a user type, nor is it explicitely set
         ///          // to a type other than Double precision.  In contrast, Evaluate automatically converts the return type to Double
         ///          // if the expression does not already evaluate to Double.  So with Evaluate, even if your expression evaluates to
         ///          // a Boolean or integer, for instance, an equivalent Double precision value is returned.  Evaluate is less prone
         ///          // to datatype mixups.  When a conversion does take place, there may be a slight speed penalty.</para>
         /// <para>         Evaluate can also be called by a Expression object that was passed to a callback By Expression.</para>
         /// <para>         If the expression evaluates to something other than Double precision floating point (such as various integers, complex,
         ///          single precision, etc), the value is converted before being returned.  In some cases (such as string, complex, etc), the
         ///          return result may or may not have a meaningful value.  However, an error is not raised.
         /// </para>
         /// </remarks> 
         double Evaluate() { return Evaluate_41(h);          }
         
         /// <summary> Rapidly evaluates a floating point expression that was parsed with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated floating point expression</returns>
         /// <remarks>
         /// <para>EvaluateDbl is similar to Evaluate, but is intended strictly for expressions that return a Double
         ///          precision value (determined by the operators used in the expression).  It will not work with Integers
         ///          or Single precision expressions for instance.</para>
         /// <para>         If the expression evaluates
         ///          to a non-numeric value (such as a string) or non-scalar numeric value (such as a complex number), or if a numeric
         ///          type other than the default was explicitely specified with Parse, the value returned will be invalid.  However,
         ///          an error will not be raised.
         /// </para>
         /// </remarks> 
         double EvaluateDbl() { return EvaluateDbl_42(h);          }
         
         /// <summary> Rapidly evaluates expression that was parsed as integer with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated integer expression</returns>
         /// <remarks>
         /// <para>
         ///          This is similar to Evaluate, but applies only to expressions that return a 32-bit integer.
         /// </para>
         /// </remarks> 
         int32_t EvaluateInt32() { return EvaluateInt32_43(h);          }
         
         /// <summary> Rapidly evaluates expression that was parsed as Boolean with Parse or passed By Expression</summary> 
         /// <returns> The result of the evaluated Boolean expression</returns>
         /// <remarks>
         /// <para>
         ///          This is similar to Evaluate, but applies only to expressions that return a Boolean.
         ///          Certain operators, such as comparison operators like <, >, ==, etc. return a Boolean.  If the final operation of an
         ///          expression is Boolean, for instance in Parse("x + 1 > 3"), then you can use EvaluateBool.  In earlier versions
         ///          Evaluate could not be used for types other than floating point, unless Double was specified in Parse so that a
         ///          conversion can take place (from Bool in this case) to Double before being returned.  Now you can either use
         ///          EvaluateBool (slightly more efficient) or else Evaluate as a catch all for any type including Boolean.
         /// </para>
         /// </remarks> 
         bool EvaluateBool() { return EvaluateBool_44(h);          }
         
         /// <summary> Rapidly evaluates an expression of any data type that was parsed with Parse or passed By Expression returning a string</summary> 
         /// <returns> The result of an evaluated expression of any data type, returned as a string</returns>
         /// <remarks>
         /// <para>EvaluateStr is similar to Evaluate.  However, EvaluateStr returns a value as a string.  Unlike Evaluate, which can only
         ///          return a floating point value, EvaluateStr can return a value of any data type.  Non-string values are converted to a string
         ///          before being returned.
         /// </para>
         /// </remarks> 
         string EvaluateStr() {
            size_t ReturnStrSize;
            const char * ReturnStr = EvaluateStr_45(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Rapidly evaluates an expression that was parsed with Parse or passed By Expression and returns a Pointer to the result</summary> 
         /// <returns> Returns a pointer to the result instead of the result itself</returns>
         /// <remarks>
         /// <para>Use this when you are interested in a pointer to the result instead of the result itself.  For instance, given an integer
         ///          result, you might use a pointer in order to retrieve the hi uint8_t and lo uint8_t values.
         /// </para>
         /// </remarks> 
         void * EvaluateVoid() { return EvaluateVoid_46(h);          }
         
         /// <summary> Rapidly executes code that was parsed with Parse or passed By Expression for which a result is not required</summary> 
         /// <remarks>
         /// <para>This can be used in cases where the reutrn value is not needed, such as statements that represent code to be executed
         ///          rather than a math expression.
         /// </para>
         /// </remarks> 
         void Execute() { Execute_47(h);          }
         
         /// <summary> Returns the data type of a parsed expression</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         DataType DataType() { return DataType_48(h);          }
         
         // operator string() { return EvaluateStr(); }
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          +++ check optimization
         ///          ...
         /// </para>
         /// </remarks>
         
         // operator double() { return Evaluate(); }
         /// <summary> ...</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_49(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_50(h); h = nullptr;          }
         
         Expression(uCalcPtr PassedHandle) { h = PassedHandle;          }
      };
      
      /// <summary> Class for retrieving arguments passed to a callback, returning a value, and more</summary> 
      struct  Callback {
         
         /// <summary> Handle of the expression part the current callback instance is refering to</summary> 
         uCalcPtr h;
         
         /// <summary> Returns the value of an argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>When the name of a callback function is specified in DefineFunction or DefineOperator, that
         ///          callback function will receive arguments uCalc passes to it through the Arg.  Arg handles values
         ///          of the default Double floating point data type.  For other data types, ArgInt32, ArgStr, etc instead.</para>
         /// <para>         Note that Index is 1-based.  So if there are 3 arguments, the Index of the first will be
         ///          1 (not 0), and the second and third will be 2 and 3 respectively.</para>
         /// <para>         If you are defining a binary operator, 1 is the index for the left operand, and 2 for the right operand.
         ///          For a unary operator, the index is 1.
         /// </para>
         /// </remarks> 
         double Arg(size_t Index) { return Arg_51(h, Index);          }
         
         /// <summary> Returns the value of an argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>When the name of a callback function is specified in DefineFunction or DefineOperator, that
         ///          callback function will receive arguments uCalc passes to it through the Arg.  Arg handles values
         ///          of the default Double floating point data type.  For other data types, ArgInt32, ArgStr, etc instead.</para>
         /// <para>         Note that Index is 1-based.  So if there are 3 arguments, the Index of the first will be
         ///          1 (not 0), and the second and third will be 2 and 3 respectively.</para>
         /// <para>         If you are defining a binary operator, 1 is the index for the left operand, and 2 for the right operand.
         ///          For a unary operator, the index is 1.
         /// </para>
         /// </remarks> 
         double ArgDbl(size_t Index) { return ArgDbl_52(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         double Arg1() { return Arg1_53(h);          }
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         double Arg2() { return Arg2_54(h);          }
         
         /// <summary> Returns the Boolean integer argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int32, then the callback function can
         ///          recieve it through ArgBool.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         bool ArgBool(size_t Index) { return ArgBool_55(h, Index);          }
         
         /// <summary> Returns the number of arguments being passed to a uCalc.Callback function</summary> 
         /// <returns> 0 if no arg is passed; or a positive integer representing the number of args being passed.</returns>
         /// <remarks>
         /// <para>This is useful for functions that have a variable number of arguments</para>
         /// </remarks> 
         size_t ArgCount() { return ArgCount_56(h);          }
         
         /// <summary> Returns an object instance of the argument being passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <returns> The returned object can be used (where relevent) just like any other uCalc.Item</returns>
         /// <remarks>
         /// <para>Each argument is a uCalc.Item, just like anything else defined with Define.  With this object,
         ///          you can do such things as determine the argument's data type, determine which instance of uCalc
         ///          it belongs to, retrieve the pointer of the value of the argument, etc.</para>
         /// </remarks> 
         Item ArgObj(size_t Index) { return ArgObj_57(h, Index);          }
         
         /// <summary> Returns the address of the argument value that is being passed</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>In addition to Arg which returns arguments that are of the default Double floating point numeric type, there
         ///          are specialized functions for other datatypes such as ArgInt32, ArgInt64, etc.  However, if the argument is of
         ///          a data type that does not have a specialized function, you can retrieve the address of the argument value as
         ///          a pointer, and use that to retrieve the value.</para>
         /// </remarks> 
         void * ArgAddr(size_t Index) { return ArgAddr_58(h, Index);          }
         //+++ Example
         
         /// <summary> Returns the object instance of the expression that's passed as an argument to a uCalc.Callback function+++Example</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <returns> Returns parsed expression object with which you can call functions like Evaluate or Execute</returns>
         /// <remarks>
         /// <para>uCalc allows you to not only pass arguments by value or by reference.  But it also lets you pass an argument
         ///          by expression.  When an expression is passed By Expression, the expresison is not evaluated before being passed.
         ///          Instead a handle to the parsed expression is passed, allowing the callback to perform the evaluation.</para>
         /// </remarks> 
         Expression ArgExpr(size_t Index) { return ArgExpr_59(h, Index);          }
         
         /// <summary> Returns the Int32 integer argument passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int32, then the callback function can
         ///          recieve it through ArgInt32.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         int32_t ArgInt32(size_t Index) { return ArgInt32_60(h, Index);          }
         
         /// <summary> Returns the Int64 integer argument being passed to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as Int64, then the callback function can
         ///          recieve it through ArgInt64.  If the argument is of a different but compatible numeric type, a conversion takes
         ///          place first before being passed.</para>
         /// </remarks> 
         int64_t ArgInt64(size_t Index) { return ArgInt64_61(h, Index);          }
         
         /// <summary> Returns a pointer value being passed as an argument to a uCalc.Callback function</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>If a function parameter (or operator operand) was explicitely defined as a Pointer, then the callback function can
         ///          recieve it through ArgPtr.  Note that ArgPtr returns any address value that is being sent, whereas ArgAddr returns the
         ///          address of the value being passed.</para>
         /// </remarks> 
         void * ArgPtr(size_t Index) { return ArgPtr_62(h, Index);          }
         
         /// <summary> Returns the value being passed as argument in to a uCalc.Callback function in form of a string</summary> 
         /// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
         /// <remarks>
         /// <para>Returns data of any type to a string.
         ///          In addition to returning an argument that was passed as a string, ArgStr has the special property of returning an argument that
         ///          was passed as any data type.  If the argument was not a string, ArgStr converts it to a string before returning its value.</para>
         /// </remarks> 
         string ArgStr(size_t Index) {
            size_t ReturnStrSize;
            const char * ReturnStr = ArgStr_63(h, ReturnStrSize , Index);
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets the return value (default floating point) of a uCalc.Callback function</summary> 
         /// <param name="Value"> Floating point value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a floating point number,
         ///          do it with Return.</para>
         /// <para>         Note: For compilers in which Return is a reserved keyword, use ReturnDbl instead.
         /// </para>
         /// </remarks> 
         void Return(double Value) { Return_64(h, Value);          }
         
         /// <summary> Sets the return value (default floating point) of a uCalc.Callback function</summary> 
         /// <param name="Value"> Floating point value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a floating point number,
         ///          do it with Return.</para>
         /// <para>         Note: For compilers in which Return is a reserved keyword, use ReturnDbl instead.
         /// </para>
         /// </remarks> 
         void ReturnDbl(double Value) { ReturnDbl_65(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Boolean integer</summary> 
         /// <param name="Value"> Boolean that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Boolean,
         ///          do it with ReturnBool.</para>
         /// </remarks> 
         void ReturnBool(bool Value) { ReturnBool_66(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Int32 integer</summary> 
         /// <param name="Value"> Integer (32-bit) that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Int32,
         ///          do it with ReturnInt32.</para>
         /// </remarks> 
         void ReturnInt32(int32_t Value) { ReturnInt32_67(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as an Int64 integer</summary> 
         /// <param name="Value"> Integer (64-bit) that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction and you want to return a Int64,
         ///          do it with ReturnInt64.</para>
         /// </remarks> 
         void ReturnInt64(int64_t Value) { ReturnInt64_68(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as a Pointer</summary> 
         /// <param name="Value"> Pointer value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction that returns a pointer value,
         ///          do it with ReturnPtr.</para>
         /// </remarks> 
         void ReturnPtr(void * Value) { ReturnPtr_69(h, Value);          }
         
         /// <summary> Sets the return value of a uCalc.Callback function as a String</summary> 
         /// <param name="Value"> String value that your callback returns</param>
         /// <remarks>
         /// <para>When you define a callback function with DefineFunction that returns a string,
         ///          do it with ReturnStr.</para>
         /// </remarks> 
         void ReturnStr(const string & Value) { ReturnStr_70(h, Value.data(), Value.size());          }
         
         /// <summary> ...</summary> 
         /// <param name="ErrNumber"> Index number of error to raise</param>
         /// <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks> 
         void ErrorSet(ErrorNumberEnum ErrNumber) { ErrorSet_71(h, ErrNumber);          }
         
         /// <summary> Raises an error in a uCalc.Callback function</summary> 
         /// <param name="ErrNumber"> Index number of error to raise</param>
         /// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
         /// <remarks>
         /// <para>Your callback can raise an error by calling this funciton with one of the values of the
         ///          ErrorNumberEnum enumerator.  End-user function definitions can also raise an error by calling Error().
         ///          The return value is determined by error handlers that you may have added.  ErrorAbort (value of 0)
         ///          is returned by default if there are no error handlers.</para>
         /// </remarks> 
         ErrorHandlerResponseEnum ErrorRaise(ErrorNumberEnum ErrNumber) { return ErrorRaise_72(h, ErrNumber);          }
         
         /// <summary> Raises an error with a user-defined message in a uCalc.Callback function</summary> 
         /// <param name="ErrMessage"> Text of custom error message to return</param>
         /// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
         /// <remarks>
         /// <para>Your callback can raise a custom error message (one not listed as a ErrorNumberEnum enumerator)
         ///          by simply passing the text of the message to this function.</para>
         /// </remarks> 
         ErrorHandlerResponseEnum ErrorRaiseMessage(const string & ErrMessage) { return ErrorRaiseMessage_73(h, ErrMessage.data(), ErrMessage.size());          }
         
         /// <summary> Returns the uCalc instance the current expression part belongs to</summary> 
         /// <remarks>
         /// <para>A callback is designed to work with all instances of uCalc.  However, at times you may need to know
         ///          which particular instance of uCalc the expression part being passed belongs to.</para>
         /// </remarks> 
         uCalc uCalc() { return uCalc_74(h);          }
         
         /// <summary> Returns the function or operator Item of the current expression part</summary> 
         /// <remarks>
         /// <para>If several functions and/or operators are mapped to the same callback function, you can use this to
         ///          let you determine which one is currently being called, based on properties you can check.</para>
         /// </remarks> 
         Item Item() { return Item_75(h);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_76(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_77(h); h = nullptr;          }
         
         Callback(uCalcPtr PassedHandle) { h = PassedHandle;          }
      }; // Callback
      
      /// <summary> Class for working with uCalc data types</summary> 
      struct  DataType {
         
         /// <summary> Handle for uCalc Data Type</summary> 
         uCalcPtr h;
         
         /// <summary> Returns the size (in bytes) of one unit of data for this data type</summary> 
         size_t ByteSize() { return ByteSize_78(h);          }
         
         /// <summary> Returns the index of the data type</summary> 
         /// <remarks>
         /// <para>The return value is a BuiltInTypesEnum enumerator value that represents the data type of the
         ///          current object.  For instance, if the data type is a string, the return value would be Type_String.
         /// </para>
         /// </remarks> 
         BuiltInTypesEnum Index() { return Index_79(h);          }
         
         /// <summary> Returns the uCalc.Item handle of the data type</summary> 
         /// <remarks>
         /// <para>Each data type object can also be represented as a uCalc object by using this return value.</para>
         /// </remarks> 
         Item Item() { return Item_80(h);          }
         
         /// <summary> Returns the name of the data type</summary> 
         string Name() {
            size_t ReturnStrSize;
            const char * ReturnStr = Name_81(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary> 
         /// <param name="ValuePtr"> Pointer of the uCalc array to be reset</param>
         /// <param name="Size"> Number of elements to reset</param>
         /// <remarks>
         /// <para>Resets all the elements of the array to the default value for the given data type.  This should only
         ///          be used for arrays that were explicitly allocated with uCalc's AllocArray.
         ///          +++ Test this
         /// </para>
         /// </remarks> 
         void Reset(void * ValuePtr ,size_t Size) { Reset_82(h, ValuePtr , Size);          }
         
         /// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary> 
         /// <param name="ValuePtr"> Pointer of the uCalc scalar to be reset</param>
         /// <remarks>
         /// <para>
         ///           +++ Test this
         /// </para>
         /// </remarks> 
         void Reset(void * ValuePtr) { Reset_83(h, ValuePtr);          }
         
         /// <summary> Sets the value of an array at a given memory location that was allocated by AllocArray</summary> 
         /// <param name="Destination"> Pointer of array (base address) of which the element value is to be set</param>
         /// <param name="Source"> Pointer to a value of the same data type that will be copied to the element</param>
         /// <param name="Index"> Index of the array element who's value needs to be set</param>
         /// <remarks>
         /// <para>
         ///          +++ Test this or remove
         /// </para>
         /// </remarks> 
         void SetArray(void * Destination ,void * Source ,size_t Index) { SetArray_84(h, Destination , Source , Index);          }
         
         /// <summary> Sets the value of a scalar at a given memory location that was allocated by AllocScalar</summary> 
         /// <param name="Destination"> Pointer of scalar who's value is to be set</param>
         /// <param name="Source"> Pointer to a value of the same data type that will be copied to the element</param>
         /// <remarks>
         /// <para>
         ///          +++ Test this or remove
         /// </para>
         /// </remarks> 
         void SetScalar(void * Destination ,void * Source) { SetScalar_85(h, Destination , Source);          }
         
         /// <summary> swaps the pointers of two variables that were allocated with AllocScalar or AllocArray</summary> 
         /// <param name="ValuePtrA"> Pointer of variable 1</param>
         /// <param name="ValuePtrB"> Pointer of variable 2</param>
         void SwapScalarValues(void * ValuePtrA ,void * ValuePtrB) { SwapScalarValues_86(h, ValuePtrA , ValuePtrB);          }
         
         /// <summary> Retuns a string representing the value at the given address formatted for the given data type</summary> 
         /// <param name="ValuePtr"> Pointer of the data containing the value you want to display</param>
         /// <remarks>
         /// <para>If you have a pointer to data of the given type, you can display this data as a string with this function.  Special formatting
         ///          associated with a data type is used, if such formatting was defined.  For instance, if you're dealing with a Boolean, then
         ///          you might get: True, Yes, On, etc, depending on how the formatting was configured with Format.</para>
         /// </remarks> 
         string ToString(void * ValuePtr) {
            size_t ReturnStrSize;
            const char * ReturnStr = ToString_87(h, ReturnStrSize , ValuePtr);
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Retuns a formatted string of the given data type representing the value that was passed as text</summary> 
         /// <param name="Value"> String representing data of any type that is to be represented as data of the given type</param>
         /// <remarks>
         /// <para>If you pass a string, it will be converted to the given data type, and return using the formatting
         ///          for that data type.</para>
         /// </remarks> 
         string ToString(const string & Value) {
            size_t ReturnStrSize;
            const char * ReturnStr = ToString_88(h, ReturnStrSize , Value.data(), Value.size());
            return string(ReturnStr, ReturnStrSize);
         }
         //+++ convert.
         
         string ToString(const char * Value ) { return ToString(string(Value));          }
         
         // operator string() { return Name(); }
         /// <summary> ... +++ check optimization</summary>
         ///  <remarks>
         /// <para>
         ///          ...
         /// </para>
         /// </remarks>
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_89(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_90(h); h = nullptr;          }
         
         DataType(uCalcPtr PassedHandle) { h = PassedHandle;          }
      }; // DataType
      
      //Product: uCalc Transform
      
      /// <summary> uCalc transform class</summary> 
      struct  Transforms : Base {
         
         /// <summary> Handle for uCalc Transform instance</summary> 
         uCalcPtr h;
         
         /// <summary> Defines a rule (for search, transform, or filter)</summary> 
         /// <param name="Comment"> Documentation/help/comment/tooltip type info associated with the rule. See Comment.</param>
         /// <param name="FindStr"> Pattern of text you want to match (The Find pattern in a search, or the From part in FromTo).</param>
         /// <param name="ToStr"> Replacement string (text that the From part should be changed to)</param>
         /// <param name="Min"> Soft minimum number of matches required.  See Min.</param>
         /// <param name="Max"> Soft maximum number of matches allowed.  See Max.</param>
         /// <param name="MinHard"> Hard minimum number of matches required. See MinHard</param>
         /// <param name="MaxHard"> Hard maximum number of matches allowed.  See MaxHard</param>
         /// <param name="Precedence"> Precedence level.  See Precedence.</param>
         /// <param name="StartAfter"> Number of matches to skip before matches start counting. See StartAfter.</param>
         /// <param name="StopAfter"> Number of matches to stop counting after.  See StopAfter.</param>
         /// <param name="SkipOver"> Makes it skip over text that is a match.  See SkipOver.</param>
         /// <param name="RewindOnChange"> Determines whether to rewind to the beginning of modified text and parse again</param>
         /// <param name="CaseSensitive"> Case sensitivity.  See CaseSensitive.</param>
         /// <param name="BracketSensitive"> Sets bracket sensitivity.  See BracketSensitive.</param>
         /// <param name="QuoteSensitive"> Sets quote sensitivity.  See QuoteSensitive.</param>
         /// <param name="RightToLeft"> Right to left</param>
         /// <returns> Rule object that has just been defined</returns>
         /// <remarks>
         /// <para>
         ///    Defines a rule that contains a pattern used for finding text, along with a replacement string, and all the other properties.
         ///    This function represents an alternative way of defining a rule, by supplying all the properties in this one function call.  These
         ///    same properties can be called individually with separate functions.  Additional details for each property can be found in separate
         ///    topics for function calls related to each property.</para>
         /// <para></para>
         /// </remarks> 
         Rule DefineRule(const string & Comment ,const string & FindStr ,const string & ToStr ,size_t Min ,size_t Max ,size_t MinHard ,size_t MaxHard ,size_t Precedence ,size_t StartAfter ,size_t StopAfter ,bool SkipOver ,bool RewindOnChange ,bool CaseSensitive ,bool BracketSensitive ,bool QuoteSensitive ,bool RightToLeft) { return DefineRule_91(h, Comment.data(), Comment.size() , FindStr.data(), FindStr.size() , ToStr.data(), ToStr.size() , Min , Max , MinHard , MaxHard , Precedence , StartAfter , StopAfter , SkipOver , RewindOnChange , CaseSensitive , BracketSensitive , QuoteSensitive , RightToLeft);          }
         
         /// <summary> Defines a new token</summary> 
         /// <param name="TokenDef"> Token definition</param>
         /// <param name="TokenType"> The type of token</param>
         /// <param name="CloseBracket"> String representing closing bracket, such as "}", ")", "]", etc.</param>
         /// <param name="SubMatch"> Submatch</param>
         /// <param name="RegExGrammar"> Type of RegEx grammar</param>
         /// <returns> Token item</returns>
         /// <remarks>
         /// <para>
         ///    For details see Define (Transforms)
         /// </para>
         /// </remarks> 
         Item DefineToken(const string & TokenDef ,TokenEnum TokenType  = Generic,const string & CloseBracket  = "",size_t SubMatch  = 0,RegExGrammarEnum RegExGrammar  = RegEx_Default) { return DefineToken_92(h, TokenDef.data(), TokenDef.size() , TokenType, CloseBracket.data(), CloseBracket.size(), SubMatch, RegExGrammar);          }
         
         /// <summary> +++ Remove this</summary> 
         void RemoveToken() { RemoveToken_93(h);          }
         
         /// <summary> Returns the Tokens object for the current transform</summary> 
         /// <returns> Token list object</returns>
         /// <remarks>
         /// <para>
         ///    Returns the Tokens object, which consists of a list of tokens for the current transform.
         ///    You can use this to add, modify, delete, or reset the tokens.
         /// </para>
         /// </remarks> 
         Tokens Tokens() { return Tokens_94(h);          }
         
         /// <summary> Defines a transform rule</summary> 
         /// <param name="FromStr"> Pattern that describes the text to match</param>
         /// <param name="ToStr"> New text that the match should be changed to</param>
         /// <returns> Object for rule being defined</returns>
         /// <remarks>
         /// <para>Whenever a piece of text matches the pattern described in FromStr, it is replaced with the text
         ///    found in ToStr.
         /// </para>
         /// </remarks> 
         Rule FromTo(const string & FromStr ,const string & ToStr  = "") { return FromTo_95(h, FromStr.data(), FromStr.size() , ToStr.data(), ToStr.size());          }
         
         /// <summary> Sets the uCalc object that performs calculations related to the transform</summary> 
         /// <param name="uCalcHandle"> Handle of a uCalc object // +++ use obj</param>
         /// <returns> uCalc object associated with current transform</returns>
         /// <remarks>
         /// <para>If your transform inovlves calcuations, then they will be performed using the
         ///    uCalc object the transform was defined in.  However, yoiu can change the uCalc object with this function.
         ///    Each uCalc object can have its own sets of variables, functions, and other definitions.
         ///    For instance when {@Eval: ...} is used in the pattern or ~Eval() in the text.
         /// </para>
         /// </remarks> 
         Transforms uCalc(void * uCalcHandle) { return uCalc_96(h, uCalcHandle);          }
         
         /// <summary> Returns a new Pass object</summary> 
         /// <param name="Share"> Share</param>
         /// <returns> Transform object</returns>
         /// <remarks>
         /// <para>
         ///    It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  The transform
         ///    of each pass is executed in sequential order.  Passes can later be referenced later by index.  Calling NewPass the first
         ///    time returns the same as Pass(0), the next call to NewPass refers to Pass(1), etc.
         /// </para>
         /// </remarks> 
         Transforms NewPass(bool Share  = false) { return NewPass_97(h, Share);          }
         
         /// <summary> Returns a new Pass object</summary> 
         /// <param name="Index"> Index of pass to select</param>
         /// <param name="Share"> Share</param>
         /// <returns> Transform object</returns>
         /// <remarks>
         /// <para>
         ///    It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  Each pass
         ///    is transformed in sequential order, starting with Pass(0).  A pass consists of a transform.
         /// </para>
         /// </remarks> 
         Transforms Pass(size_t Index ,bool Share  = false) { return Pass_98(h, Index , Share);          }
         
         /// <summary> Resets the transform object</summary> 
         /// <param name="ResetOption"> Reset option</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>This clears the input string, transform rules, token definitions, Results.  It also resets properties to default settings
         /// </para>
         /// </remarks> 
         Transforms Reset(TransformResetEnum ResetOption  = Reset_All) { return Reset_99(h, ResetOption);          }
         
         /// <summary> Performs the transformation of text</summary> 
         /// <returns> The current transform object</returns>
         /// <remarks>
         /// <para>Once all the rules and parameters are set, you can call this function in order to
         ///    perform the text transformation.</para>
         /// <para>   Prior to calling Transform, you must set the text to be transformed, with Str
         /// </para>
         /// </remarks> 
         Transforms Transform() { return Transform_100(h);          }
         
         /// <summary> Transforms an expression in one quick step</summary> 
         /// <param name="expression"> Expression to be transformed</param>
         /// <returns> String result of transform</returns>
         /// <remarks>
         /// <para>
         ///    When you would like to set text to be transformed, and transform the text, and return a result, all in one step,
         ///    you can use this function, instead of calling Str, then Transform, then Str.
         /// </para>
         /// </remarks> 
         string Transform(const string & expression) {
            size_t ReturnStrSize;
            const char * ReturnStr = Transform_101(h, ReturnStrSize , expression.data(), expression.size());
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Returns each step leading to an expression expansion</summary> 
         /// <param name="expression"> Expression to be transformed +++ See Transform_</param>
         /// <returns> String list containg steps leading up to transform result</returns>
         /// <remarks>
         /// <para>
         ///    Transforms an expression and returns intermediate steps
         /// </para>
         /// </remarks> 
         String TransformWithSteps(const string & expression) { return TransformWithSteps_102(h, expression.data(), expression.size());          }
         
         /// <summary> Returns string result of transformed text</summary> 
         /// <returns> String result of transformed text</returns>
         /// <remarks>
         /// <para>After performing a text transformation, you may obtain the transformed result with this
         ///    function
         /// </para>
         /// </remarks> 
         string Str() {
            size_t ReturnStrSize;
            const char * ReturnStr = Str_103(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets the text input that is to be transformed</summary> 
         /// <param name="InputStr"> Text that mast be parsed and modified</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>The text that you want to transform should be passed to this function.
         /// </para>
         /// </remarks> 
         Transforms Str(const string & InputStr) { return Str_104(h, InputStr.data(), InputStr.size());          }
         
         /// <summary> Returns actual char porsing of data</summary> 
         /// <returns> ... +++ test this; maybe with null-imbedded string</returns>
         /// <remarks>
         /// <para>
         ///    ... // Note: Should never be used alone.  Always use in pair with StrLength
         /// </para>
         /// </remarks> 
         const char * StrData() { return StrData_105(h);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t StrLength() { return StrLength_106(h);          }
         
         /// <summary> Sets the index base used in various functions+++</summary> 
         /// <param name="BaseValue"> value representing index of 1st element</param>
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this if you prefer to start by 1 or another non-zero value.  This value is passed on to string objects derived from a parent string.
         ///    Each string may have a different index base.
         /// </para>
         /// </remarks> 
         Transforms IndexBase(size_t BaseValue) { return IndexBase_107(h, BaseValue);          }
         
         /// <summary> Gets the index base used in various functions+++</summary> 
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this to check to see which base is being used.
         /// </para>
         /// </remarks> 
         size_t IndexBase() { return IndexBase_108(h);          }
         
         /// <summary> Indicates whether text was modified in the most recent Transform operation</summary> 
         /// <returns> True if text was modified in the most recent transformation operation or false otherwise</returns>
         /// <remarks>
         /// <para>
         ///    +++ Maybe rename IsModified; and have one that Sets the value; or maybe IsProperty for this & others.
         ///    If text was modified after a call to Transform, then this function returns True.  When transforming large amounts of text,
         ///    transferring strings back and forth with ReturnStr() can be expensive.  Checking this property allows you to skip unnecessary
         ///    steps when text has not been modified.
         /// </para>
         /// </remarks> 
         bool WasModified() { return WasModified_109(h);          }
         
         /// <summary> Returns the defaults settings for rules</summary> 
         /// <returns> Default rule object</returns>
         /// <remarks>
         /// <para>
         ///    Each FromTo or Find rule has many configurable properties that can be set.  Instead of excplicitely setting all of these many properties
         ///    with each rule definition, you may define default settings that will automatically be assigned to new rules.  Any of these default settings
         ///    can be overridden by explicitely setting the desired property for a given rule.
         /// </para>
         /// </remarks> 
         Rule RulesDefault() { return RulesDefault_110(h);          }
         
         /// <summary> Returns the overall settings for a transform</summary> 
         /// <returns> Overall rule object</returns>
         /// <remarks>
         /// <para>
         ///    This returns an object containing the properties for a transform or search object.  This object is a Rules object, and conatains the
         ///    same properties listed for individual rules, but works in a slightly different context.  For instance, if you set the StopAfter property
         ///    of FromTo("a", "b") to 5, then it will only change the first five occurences of "a" to "b", whereas if you set the RulesOverall StopAfter
         ///    property to 5, and you have rules FromTo("a", "b") and FromTo("x", "y") then it will stop changing any occurence of either rule, after the
         ///    combined total of changes reaches 5; "a" might change to "b" 2 times and "x" to "y" 3 times, or whichever combination does not total more
         ///    than 5.  You might set QuoteSensitive to "true" overall, while you may set it to false within a given rule.  In certain combinations,
         ///    overall rules may clash with individual rules.  Although all combinations are allowed, not all combinations make sense.  When setting
         ///    the case sensitivity property of individual rules differently from the overall property, keep in mind that if the overall case sensitivity
         ///    is false, then all symbols are stored in the symbol table in all upper case.
         /// </para>
         /// </remarks> 
         Rule RulesOverall() { return RulesOverall_111(h);          }
         
         /// <summary> Returns a rule object from a transform</summary> 
         /// <param name="Index"> Index of rule</param>
         /// <returns> Rule object</returns>
         /// <remarks>
         /// <para>
         ///    The default rule is located at index -1.  All subsequent rules inherent properties from the default rule.</para>
         /// <para>   If no argument is passed, then Rule returns the next empty new rule in the list.
         /// </para>
         /// </remarks> 
         Rule Rule(size_t Index  = 0) { return Rule_112(h, Index);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_113(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_114(h); h = nullptr;          }
         
         Transforms(uCalcPtr PassedHandle) { h = PassedHandle; hb = h;          }
      }; // Transforms
      
      /// <summary> Class for rules</summary> 
      struct  Rule : Base {
         
         /// <summary> Handle for Rule</summary> 
         uCalcPtr h;
         
         /// <summary> Sets whether a rule is active</summary> 
         /// <param name="TrueFalse"> Value that determines case is active</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets whether a rule is active or not.
         ///    When you no longer need a rule, you can release it entirely from memory with Release().  However, at times you may
         ///    want to only temporarily deactivate a transform, and then later reactivate it for further use.  That is when you use
         ///    this function.
         /// </para>
         /// </remarks> 
         Rule Active(bool TrueFalse) { return Active_115(h, TrueFalse);          }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         string FindPart() {
            size_t ReturnStrSize;
            const char * ReturnStr = FindPart_116(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <param name="Pattern"> Pattern for the Find part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         Rule FindPart(const string & Pattern) { return FindPart_117(h, Pattern.data(), Pattern.size());          }
         
         /// <summary> Sets Find part of a rule in a search</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the Find part of a rule in a search.
         /// </para>
         /// </remarks> 
         string FromPart() {
            size_t ReturnStrSize;
            const char * ReturnStr = FromPart_118(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets From part of a rule</summary> 
         /// <param name="Pattern"> Pattern for the From part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the From part of a rule.
         /// </para>
         /// </remarks> 
         Rule FromPart(const string & Pattern) { return FromPart_119(h, Pattern.data(), Pattern.size());          }
         
         /// <summary> Sets To part of a rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the To part of a rule.
         /// </para>
         /// </remarks> 
         string ToPart() {
            size_t ReturnStrSize;
            const char * ReturnStr = ToPart_120(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets To part of a rule</summary> 
         /// <param name="Pattern"> Pattern for the From part of a rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the To part of a rule.
         /// </para>
         /// </remarks> 
         Rule ToPart(const string & Pattern) { return ToPart_121(h, Pattern.data(), Pattern.size());          }
         
         /// <summary> Sets whether a rule is case-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines case sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is case-sensitive or not.
         ///    +++ Maybe IsProperty() for this and others
         /// </para>
         /// </remarks> 
         Rule CaseSensitive(bool TrueFalse) { return CaseSensitive_122(h, TrueFalse);          }
         
         /// <summary> ...</summary> 
         /// <param name="TrueFalse"> ...</param>
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>...
         /// </para>
         /// </remarks> 
         Rule IgnoreInnerPatterns(bool TrueFalse) { return IgnoreInnerPatterns_123(h, TrueFalse);          }
         
         /// <summary> Sets whether a rule is whitespace-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines whitespace sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is whitespace-sensitive or not.
         /// </para>
         /// </remarks> 
         Rule WhitespaceSensitive(bool TrueFalse) { return WhitespaceSensitive_124(h, TrueFalse);          }
         
         /// <summary> Sets bracket sensitivity</summary> 
         /// <param name="TrueFalse"> Value that determines bracket sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is bracket sensitive or not.  When set to True, a pattern will not match if it crosses the boundaries of
         ///    a bracket grouping.</para>
         /// <para>   If set to False, then clode block delimiters are treated as ordinary generic tokens, with no special property as delimiters.</para>
         /// <para>   A bracketed group is a pattern enclosed between tokens defined as a bracket pair.  By default square brackets, [],
         ///    parenthesis, (), and curly braces, {}, are defined as bracket pairs.  However, any string pairs can be defined as
         ///    bracket tokens.</para>
         /// <para>   So, if you define a pattern "a {etc} b", it will match "a x y z b c", "a (x y z) b c", "a (x) (y z) b c", but not "a x y z (b c)",
         ///    because the bracket grouping (b c) crosses the boundary of the "a {etc} b" pattern; the opening parenthesis is found in the would-be match,
         ///    but the closing parenthesis is beyond it, whereas in the other examples, the both opening and closing parenthesis (when present) are
         ///    fully within "a {etc} b".</para>
         /// <para>   Note: Brackets used in pattern definitions take precedence over bracket token pairs.  Therefore you may define a pattern that gives
         ///    brackets a different behavior than the default.
         /// </para>
         /// </remarks> 
         Rule BracketSensitive(bool TrueFalse) { return BracketSensitive_125(h, TrueFalse);          }
         
         /// <summary> Returns a local transform object</summary> 
         /// <param name="t"> ...</param>
         /// <returns> Local transform object</returns>
         /// <remarks>
         /// <para>
         ///    When a pattern is matched, you can zoom into the text and perform a local search just within the matched text, independantly
         ///    from the rest of the text outside of the match.  Among various possible uses, it's ideal for parsing escape characters within quotes.
         ///    Such characters are treated differently within the quote than outside the quote.
         /// </para>
         /// </remarks> 
         Transforms LocalTransform(Transforms t  = nullptr) { return LocalTransform_126(h, t.h);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t Maximum() { return Maximum_127(h);          }
         
         /// <summary> Sets the soft maximum number of matches of this rule allowed</summary> 
         /// <param name="Value"> Maximum number of matches of this rule allowed</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft maximum number of individual matches that this rule should find in order for any matches
         ///    of this rule to count.  If more than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the maximum is set to 2, then no matches of "a" will be counted at all, because there are more than
         ///    2 occurences of "a" in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
         ///    all the matches would count.</para>
         /// <para>   The default Maximum value is -1, which is the equivalent of no maximum limit.</para>
         /// <para>   If you want to stop counting after a given number of matches of a rule, without invalidating the matches
         ///    that were already found, use StopAfter instead.
         /// </para>
         /// </remarks> 
         Rule Maximum(size_t Value) { return Maximum_128(h, Value);          }
         
         /// <summary> Sets the hard maximum number of matches of this rule allowed</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t MaximumHard() { return MaximumHard_129(h);          }
         /// <summary> Sets the hard maximum number of matches of this rule allowed</summary> 
         /// <param name="Value"> Maximum number of matches of this rule allowed</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the maximum number of individual matches that this rule should find in order for any matches
         ///    of this rule to count.  If more than this number of matches are found in the text, then no matches from
         ///    any rule will count (whereas in a soft maximum, only matches from the current rule will be cancelled).
         ///    For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the maximum is set to 2, then no matches of "a" will be counted at all, because there are more than
         ///    2 occurences of "a" in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
         ///    all the matches would count.</para>
         /// <para>   The default Maximum value is -1, which is the equivalent of no maximum limit.</para>
         /// <para>   If you want to stop counting after a given number of matches of a rule, without invalidating the matches
         ///    that were already found, use StopAfter instead.
         /// </para>
         /// </remarks> 
         Rule MaximumHard(size_t Value) { return MaximumHard_130(h, Value);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t Minimum() { return Minimum_131(h);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <param name="Value"> Minimum number of matches required of this rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft minimum number of individual matches that this rule should find.</para>
         /// <para>   A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
         ///    reached, then it is considered that there are no matches for this particular rule.  Other rules
         ///    are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
         ///    then the entire search or transform is invalidated, and it's considered that no match of any
         ///    kind is found.</para>
         /// <para>   If less than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the minimum is set to 5, then no matches of "a" will be counted at all, because there are not at least
         ///    5 occurences of "a" in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.</para>
         /// <para>   Default: 0.
         /// </para>
         /// </remarks> 
         Rule Minimum(size_t Value) { return Minimum_132(h, Value);          }
         
         /// <summary> ...</summary> 
         /// <returns> ...</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t MinimumHard() { return MinimumHard_133(h);          }
         
         /// <summary> Sets the soft minimum number of matches that must be found in this rule</summary> 
         /// <param name="Value"> Minimum number of matches required of this rule</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets the soft minimum number of individual matches that this rule should find.</para>
         /// <para>   A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
         ///    reached, then it is considered that there are no matches for this particular rule.  Other rules
         ///    are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
         ///    then the entire search or transform is invalidated, and it's considered that no match of any
         ///    kind is found.</para>
         /// <para>   If less than this number of matches are found in the text, then none of the
         ///    matches in this rule will count.  For instance if a rule searches for matches of "a" in "a a r d v a r k",
         ///    and the minimum is set to 5, then no matches of "a" will be counted at all, because there are not at least
         ///    5 occurences of "a" in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.</para>
         /// <para>   Default: 0.
         /// </para>
         /// </remarks> 
         Rule MinimumHard(size_t Value) { return MinimumHard_134(h, Value);          }
         
         /// <summary> Sets the precedence level for a pattern</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t Precedence() { return Precedence_135(h);          }
         /// <summary> Sets the precedence level for a pattern</summary> 
         /// <param name="Value"> Precedence level</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    Patterns that start (and/or end) with a pattern variable instead of a token or identifier can
         ///    (and probably should) be assigned a precedence level.  You can choose any arbitrary numerical
         ///    value.  The meaning of the precedence level depends on whether the value is greater, equal, or
         ///    less than adjacent patterns with a precedence level.  It works similarly to precedence levels for
         ///    operators.  For instance, if you define:</para>
         /// <para>   FromTo("{a} + {b}", "({a} + {b})").Precedence(10);
         ///    FromTo("{a} * {b}", "({a} * {b})").Precedence(20);</para>
         /// <para>   Then</para>
         /// <para>   "1 + 2 * 3 + 4" transforms into "(1 + (2 * 3) + 4)"
         ///    "1 * 2 + 3 * 4" transforms into "(1 * 2) + (3 * 4)"
         /// </para>
         /// </remarks> 
         Rule Precedence(size_t Value) { return Precedence_136(h, Value);          }
         
         /// <param name="SelectedProperty"> ...</param>
         /// <param name="TrueFalse"> ...</param>
         Rule Property(ItemIsEnum SelectedProperty ,bool TrueFalse) { return Property_137(h, SelectedProperty , TrueFalse);          }
         
         /// <summary> Sets quote sensitivity</summary> 
         /// <param name="TrueFalse"> Value that determines quote sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is quote sensitive or not.
         ///    Quote sensitivity is generally designed for use across all rules in a transform (or sub transform).  However,
         ///    it can also be set in for the context of an individual pattern.  [One exception is within text that matches a pattern variable.+++]</para>
         /// <para>   When set to true, it means that a block of text within quotes is treated as one token.  As such patterns are not searched for
         ///    within the quotes.  The contents of the quotes are skipped over.  You may still get around this and parse within quotes when
         ///    necessary, by capturing the quote character itself, then parsing subsequent text.</para>
         /// <para>   The actual character(s) used as quotes are configurable with DefineToken.
         /// </para>
         /// </remarks> 
         Rule QuoteSensitive(bool TrueFalse) { return QuoteSensitive_138(h, TrueFalse);          }
         
         /// <summary> Returns the replacement text of a FromTo rule</summary> 
         /// <returns> String representing the second argument that was used in FromTo</returns>
         /// <remarks>
         /// <para>This allows you to keep track of the replacement text of any given rule, even after it has been defined.</para>
         /// </remarks> 
         string ReplacementText() {
            size_t ReturnStrSize;
            const char * ReturnStr = ReplacementText_139(h, ReturnStrSize );
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Sets the number of matches this rule must find before matches start counting</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t StartAfter() { return StartAfter_140(h);          }
         
         /// <summary> Sets the number of matches this rule must find before matches start counting</summary> 
         /// <param name="Value"> Number of matches that must be found before matches start counting</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets a number of individual matches that this rule should find first.  These first few matches are
         ///    not counted in the results.  Onlny matches starting after this number of initial matches are counted.
         ///    If less than this number of matches are found in the text, no match will count.  For instance if a rule
         ///    searches for matches of "a" in "a a r d v a r k", starting after 2, then only the 3rd "a" (the one between
         ///    "v" and "r") will count.  If StartAfter is set to 3, there will be no matches.  If StartAfter is 1, then
         ///    then the 2nd and 3rd occurences of "a" will count as matches.</para>
         /// <para>   The default StartAfter value is 0.  This means all matches that are found will count.
         /// </para>
         /// </remarks> 
         Rule StartAfter(size_t Value) { return StartAfter_141(h, Value);          }
         
         /// <summary> Sets the number of matches after which this rule should stop finding matches</summary> 
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t StopAfter() { return StopAfter_142(h);          }
         
         /// <summary> Sets the number of matches after which this rule should stop finding matches</summary> 
         /// <param name="Value"> Number of matches after which it should stop finding matches</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>
         ///    This sets a number of individual matches that this rule should find.  After this number of matches
         ///    are found, all other matches for this rule are ignored.  For instance if a rule searches for matches
         ///    of "a" in "a a r d v a r k", and stops after 2, then only the first two letters here wil match; the
         ///    third "a" (the one between "v" and "r") will not count as a match.</para>
         /// <para>   The default StopAfter value is -1, which means it will not stop counting matches for this rule.</para>
         /// <para>   This function has some similarities with Max.  However, with Max, if the maximum value is not attained,
         ///    none of the matches will count.
         /// </para>
         /// </remarks> 
         Rule StopAfter(size_t Value) { return StopAfter_143(h, Value);          }
         
         /// <summary> Determines whether a given match is skipped over</summary> 
         /// <param name="TrueFalse"> Value that determines with match is skipped over</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>If SkipOver is set to true, then text that matches this pattern will be skipped over.
         ///    This is useful for preventing uCalc from searching for matches of any other rules within
         ///    certain text you want to skip over.</para>
         /// <para>   For instance if you skip over "({etc})", then everything in parenthesis will be skipped over.
         ///    So if you want to find occurences of "a" in "a b c (a b c a b c) a b c", it will find all occurences
         ///    of "a", except those within parenthesis, because everything in parenthesis is being skipped over.</para>
         /// <para>   Default: False
         /// </para>
         /// </remarks> 
         Rule SkipOver(bool TrueFalse) { return SkipOver_144(h, TrueFalse);          }
         
         /// <summary> Determines whether to rewind back to the start of modified text for further parsing</summary> 
         /// <param name="TrueFalse"> Value that determines if parser should rewind and parse again after a change</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>After text is modified with the replacement text of a rule, if this value is false (default),
         ///    then uCalc will continue parsing from the position just after the insertion of the modified text.
         ///    If this property is set to true, then the parser will rewind to the location where the match was
         ///    found, and parse again, which will allow it to potentially find additional matches (of any rule,
         ///    not just the current one) within the already modified text.</para>
         /// <para>   This property can be extremely useful in many situations.  However, special care should be taken
         ///    so that an infinite reparsing session doesn't take place.  For instance, if a rule changes A to B,
         ///    and another rule changes B to A, and this property is set ot true, and a Maximum value is not set,
         ///    and there is an occurence of A, then A will change to B.  B will be parsed again and changed to A.
         ///    The cycle will repeat itself indefinitely.</para>
         /// <para>   Default: False
         /// </para>
         /// </remarks> 
         Rule RewindOnChange(bool TrueFalse) { return RewindOnChange_145(h, TrueFalse);          }
         
         /// <summary> Sets whether a rule is case-sensitive</summary> 
         /// <param name="TrueFalse"> Value that determines case sensitivity</param>
         /// <returns> The current rule object</returns>
         /// <remarks>
         /// <para>This sets whether a rule is case sensitive or not.
         /// </para>
         /// </remarks> 
         Rule RightToLeft(bool TrueFalse) { return RightToLeft_146(h, TrueFalse);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_147(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_148(h); h = nullptr;          }
         
         Rule(uCalcPtr PassedHandle) { h = PassedHandle; hb = h;          }
      }; // Rule
      
      /// <summary> Class for collection of tokens</summary> 
      struct  Tokens : Base {
         
         /// <summary> Handle for tokens</summary> 
         uCalcPtr h;
         
         /// <summary> Imports tokens from another token list</summary> 
         /// <param name="FromTokenList"> Token list to import +++ BYREF Obj(Tokens) ; +++ 2nd arg for Append</param>
         /// <returns> Object containing list of tokens</returns>
         /// <remarks>
         /// <para>
         ///    Instead of defining a set of tokens each time, you may import a pre-existing token list.  This function imports from
         ///    another token list object.  To import from a file, use Import (File).
         /// </para>
         /// </remarks> 
         Tokens Import(void * FromTokenList) { return Import_149(h, FromTokenList);          }
         
         /// <summary> Defines a new token</summary> 
         /// <param name="TokenDef"> Token definition</param>
         /// <param name="TokenType"> The type of token</param>
         /// <param name="CloseBracket"> String representing closing bracket, such as "}", ")", "]", etc.</param>
         /// <param name="SubMatch"> Submatch</param>
         /// <param name="RegExGrammar"> Type of RegEx grammar</param>
         /// <returns> Token item object</returns>
         /// <remarks>
         /// <para>
         ///    uCalc comes with a default set of tokens.  These are general tokens for things like numbers alphanumeric words, whitespace, quotes,
         ///    parenthesis, etc.  However you may define your own tokens to the exact specifications that you need.</para>
         /// <para>   A token is defined using a Regular Expression.</para>
         /// <para>   A token type can be any of those listed under TokenEnum (except for None).</para>
         /// <para>   Bracket tokens (such as parenthesis, square brackets, or curly braces) are typically defined as pairs.  So if "(", ")"
         ///    are defined as a token pair, then CloseBracket would be ")".</para>
         /// <para>   In cases where you want a submatch within the token, and not the whole token, use the SubMatch argument with a numerical
         ///    value represent the numerical index used in the regular expression.
         /// </para>
         /// </remarks> 
         Item Define(const string & TokenDef ,TokenEnum TokenType  = Generic,const string & CloseBracket  = "",size_t SubMatch  = 0,RegExGrammarEnum RegExGrammar  = RegEx_Default) { return Define_150(h, TokenDef.data(), TokenDef.size() , TokenType, CloseBracket.data(), CloseBracket.size(), SubMatch, RegExGrammar);          }
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_151(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_152(h); h = nullptr;          }
         
         Tokens(uCalcPtr PassedHandle) { h = PassedHandle; hb = h;          }
      }; // Tokens
      
      //Product: uCalc String Library
      
      /// <summary> uCalc string library class</summary> 
      struct  String {
         
         /// <summary> Handle for uCalc String Library instance</summary> 
         uCalcPtr h;
         
         /// <summary> ...</summary> 
         /// <param name="StartIndex"> ...</param>
         /// <param name="Count"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t TokenCharLen(size_t StartIndex ,size_t Count  = 1) { return TokenCharLen_153(h, StartIndex , Count);          }
         
         /// <summary> Returns the numbers of tokens in the string</summary> 
         /// <param name="Index"> Index of match+++</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         size_t TokenCount(size_t Index  = -1) { return TokenCount_154(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         TokenEnum TokenType(size_t Index) { return TokenType_155(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="OtherString"> ...</param>
         /// <param name="IndexA"> ...</param>
         /// <param name="IndexB"> ...</param>
         /// <param name="Length"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         uCalcCompareEnum Compare(const string & OtherString ,size_t IndexA  = 0,size_t IndexB  = 0,size_t Length  = -1) { return Compare_156(h, OtherString.data(), OtherString.size() , IndexA, IndexB, Length);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t TokenIndexAtChar(size_t Index) { return TokenIndexAtChar_157(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="expression"> ...</param>
         /// <param name="Variable"> Name of variable</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String Apply(const string & expression ,const string & Variable  = "") { return Apply_158(h, expression.data(), expression.size() , Variable.data(), Variable.size());          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String At(size_t Index) { return At_159(h, Index);          }
         
         /// <summary> +++//</summary> 
         /// <param name="Index"> Index of charactor location</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo
         /// </para>
         /// </remarks> 
         String AtChar(size_t Index) { return AtChar_160(h, Index);          }
         
         /// <summary> +++</summary> 
         /// <param name="Index"> Index of token location</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo
         /// </para>
         /// </remarks> 
         String AtToken(size_t Index) { return AtToken_161(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String BracketMatch(size_t Index) { return BracketMatch_162(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String BracketedText(size_t Index) { return BracketedText_163(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String BracketedTextInside(size_t Index) { return BracketedTextInside_164(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ..</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t BracketMatchTokenIndex(size_t Index) { return BracketMatchTokenIndex_165(h, Index);          }
         
         /// <summary>...</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         size_t CharPos(size_t Nth  = -1) { return CharPos_166(h, Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t CharCount(size_t Nth  = -1) { return CharCount_167(h, Nth);          }
         
         /// <summary> Returns the numbers of tokens in the string</summary> 
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         size_t TokenPos(size_t Nth  = -1) { return TokenPos_168(h, Nth);          }
         
         /// <summary> Returns the character position of a token</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    This returns the number of tokens that are found in the string;
         /// </para>
         /// </remarks> 
         size_t TokenCharPos(size_t Index) { return TokenCharPos_169(h, Index);          }
         
         /// <summary> Retrieves the string value of a uCalc String object</summary> 
         /// <param name="Nth"> Index of match</param>
         /// <param name="TokenCount"> Number of tokens</param>
         /// <returns> String value of the uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    This retrieves the string value associated with a uCalc String object.
         ///    +++ This is optional unless you are retrieving the index of a match.
         ///    Use Str(n) when you just want the string representation of a value.
         ///    Use Match(n) when you want uCalc String Object that you can manipulate further.
         /// </para>
         /// </remarks> 
         string Str(size_t Nth  = -1,size_t TokenCount  = 1) {
            size_t ReturnStrSize;
            const char * ReturnStr = Str_170(h, ReturnStrSize , Nth, TokenCount);
            return string(ReturnStr, ReturnStrSize);
         }
         
         /// <summary> Assigns a string value to the uCalc String object</summary> 
         /// <param name="StringValue"> New string value +++ Should probably add Index arg</param>
         /// <remarks>
         /// <para>
         ///    This assigns a new string to the uCalc String object.
         /// </para>
         /// </remarks> 
         String Str(const string & StringValue) { return Str_171(h, StringValue.data(), StringValue.size());          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///      ...
         /// </para>
         /// </remarks> 
         String Find(const string & Pattern ,size_t Nth  = 1) { return Find_172(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String FindOtherThan(const string & Pattern ,size_t Nth  = 1) { return FindOtherThan_173(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> Returns the immediate parent of the current string</summary> 
         /// <remarks>
         /// <para></para>
         /// <para></para>
         /// </remarks> 
         String Parent() { return Parent_174(h);          }
         
         /// <summary> Returns the immediate parent of the current string</summary> 
         /// <remarks>
         /// <para></para>
         /// <para></para>
         /// </remarks> 
         String Root() { return Root_175(h);          }
         
         /// <summary> Sets the index base used in various functions</summary> 
         /// <param name="BaseValue"> value representing index of 1st element</param>
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this if you prefer to start by 1 or another non-zero value.  This value is passed on to string objects derived from a parent string.
         ///    Each string may have a different index base.
         /// </para>
         /// </remarks> 
         String IndexBase(size_t BaseValue) { return IndexBase_176(h, BaseValue);          }
         
         /// <summary> Gets the index base used in various functions</summary> 
         /// <remarks>
         /// <para>
         ///    By default, uCalc String Library functions use a 0-based index.  So the first element is 0 (not 1), followed by 2, 3, 4 etc.
         ///    Use this to check to see which base is being used.
         /// </para>
         /// </remarks> 
         size_t IndexBase() { return IndexBase_177(h);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String UpTo(const string & Pattern ,size_t Nth  = 1) { return UpTo_178(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String StartingFrom(const string & Pattern ,size_t Nth  = 1) { return StartingFrom_179(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="StartPattern"> ...</param>
         /// <param name="EndPattern"> ...</param>
         /// <param name="StartNth"> ...</param>
         /// <param name="EndNth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String StartingFromEndingWith(const string & StartPattern ,const string & EndPattern ,size_t StartNth  = 1,size_t EndNth  = 1) { return StartingFromEndingWith_180(h, StartPattern.data(), StartPattern.size() , EndPattern.data(), EndPattern.size() , StartNth, EndNth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String Before(const string & Pattern ,size_t Nth  = 1) { return Before_181(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="Pattern"> Pattern</param>
         /// <param name="Nth"> Nth match</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String After(const string & Pattern ,size_t Nth  = 1) { return After_182(h, Pattern.data(), Pattern.size() , Nth);          }
         
         /// <summary> ...</summary> 
         /// <param name="StartPattern"> Pattern</param>
         /// <param name="StopPattern"> Pattern 2</param>
         /// <param name="StartNth"> Nth match</param>
         /// <param name="StopNth"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String Between(const string & StartPattern ,const string & StopPattern ,size_t StartNth  = 1,size_t StopNth  = 1) { return Between_183(h, StartPattern.data(), StartPattern.size() , StopPattern.data(), StopPattern.size() , StartNth, StopNth);          }
         
         /// <summary> Returns list of tokens</summary> 
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         String ListOfTokens() { return ListOfTokens_184(h);          }
         
         /// <summary> Returns list of tokens</summary> 
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         String ListOfChars() { return ListOfChars_185(h);          }
         
         /// <summary> Returns substring</summary> 
         /// <param name="StartPos"> Starting position</param>
         /// <param name="Length"> Length of substring</param>
         /// <returns> Object</returns>
         /// <remarks>
         /// <para>
         ///    ToDo +++
         /// </para>
         /// </remarks> 
         String SubString(size_t StartPos ,size_t Length  = -1) { return SubString_186(h, StartPos , Length);          }
         
         /// <summary> Sets rules for when a child object is created</summary> 
         /// <param name="Option"> +++</param>
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    Many functions create a new string object derived from another given object.  This option determins the persistence of previously
         ///    derived objects.  The right option depends on what you want to do.  If you're looking to conserve memory, then ClearAll is may be the
         ///    option you need.  However, with this option, you can no longer refer to previously derived strings, otherwise the behavior will be
         ///    undefined (such as crashing).  You may delay object deletetion be removing only the ones that overlap in location with the newly derived
         ///    string.  The decision to delete may be delayed based on when if object is being written to.   ClearOverlapOnWrite, allows you to
         ///    to have multiple overlapping views of the same parent string without any conflict.  Only when modifying a derived string are overlapped
         ///    derived strings removed.  Corresponding Detach options are similar, except that instead of actually erasing an overlapping object, it
         ///    is disassassiated from the parent string.  It can continue to be used as an independent string without undefined behavior.  With this
         ///    option, the independent strings are erased only when the parent string itself is erased.</para>
         /// <para></para>
         /// </remarks> 
         String ChildStringOption(ChildStringOptionEnum Option) { return ChildStringOption_187(h, Option);          }
         
         /// <summary> Gets the option</summary> 
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         ChildStringOptionEnum ChildStringOption() { return ChildStringOption_188(h);          }
         
         /// <summary> Clears derived strings from memory</summary> 
         /// <returns> String object</returns>
         /// <remarks>
         /// <para>
         ///    +++
         /// </para>
         /// </remarks> 
         String ClearDerivedStrings() { return ClearDerivedStrings_189(h);          }
         
         /// <summary> todo</summary> 
         /// <param name="From_"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String Remove(const string & From_) { return Remove_190(h, From_.data(), From_.size());          }
         
         /// <summary> todo</summary> 
         /// <param name="From_"> ...</param>
         /// <param name="To_"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String Replace(const string & From_ ,const string & To_) { return Replace_191(h, From_.data(), From_.size() , To_.data(), To_.size());          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String Skip(const string & Pattern) { return Skip_192(h, Pattern.data(), Pattern.size());          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String ToUpper(const string & Pattern  = "",size_t Nth  = -1) { return ToUpper_193(h, Pattern.data(), Pattern.size(), Nth);          }
         
         /// <summary> todo</summary> 
         /// <param name="Pattern"> ...</param>
         /// <param name="Nth"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String ToLower(const string & Pattern  = "",size_t Nth  = -1) { return ToLower_194(h, Pattern.data(), Pattern.size(), Nth);          }
         
         /// <summary> todo</summary> 
         /// <param name="ListType"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo
         /// </para>
         /// </remarks> 
         String List(uCalcList ListType  = Matches) { return List_195(h, ListType);          }
         
         /// <summary> todo</summary> 
         /// <param name="Separator"> ...</param>
         /// <param name="Prefix"> ...</param>
         /// <param name="Postfix"> ...</param>
         /// <param name="UserFunc"> ...</param>
         /// <param name="Element"> ...</param>
         /// <param name="Index"> ...</param>
         /// <param name="Count"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++ Maybe rename for clarity
         /// </para>
         /// </remarks> 
         String ListFormat(const string & Separator ,const string & Prefix  = "",const string & Postfix  = "",const string & UserFunc  = "",const string & Element  = "",const string & Index  = "",const string & Count  = "") { return ListFormat_196(h, Separator.data(), Separator.size() , Prefix.data(), Prefix.size(), Postfix.data(), Postfix.size(), UserFunc.data(), UserFunc.size(), Element.data(), Element.size(), Index.data(), Index.size(), Count.data(), Count.size());          }
         
         /// <summary> Sets the separator that will delimite the elements of a list</summary> 
         /// <param name="Separator"> Separator that will delimite each element of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         String ListSeparator(const string & Separator) { return ListSeparator_197(h, Separator.data(), Separator.size());          }
         
         /// <summary> Sets the prefix that is inserted at the start of lists</summary> 
         /// <param name="Prefix"> Prefix that will be inserted at the start of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         String ListPrefix(const string & Prefix) { return ListPrefix_198(h, Prefix.data(), Prefix.size());          }
         
         /// <summary> Sets the postfix that is inserted at the end of lists</summary> 
         /// <param name="Postfix"> Postfix that will be inserted at the end of a list</param>
         /// <returns> Current uCalc String object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         String ListPostfix(const string & Postfix) { return ListPostfix_199(h, Postfix.data(), Postfix.size());          }
         
         /// <summary> Sets the formatting for displaying the elements of a list</summary> 
         /// <param name="UserFunc"> +++</param>
         /// <param name="Element"> +++</param>
         /// <param name="Index"> +++</param>
         /// <param name="MatchCount"> +++</param>
         /// <returns> Current transform object</returns>
         /// <remarks>
         /// <para>
         ///    Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
         ///    within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
         /// </para>
         /// </remarks> 
         String ListFunction(const string & UserFunc ,const string & Element  = "",const string & Index  = "",const string & MatchCount  = "") { return ListFunction_200(h, UserFunc.data(), UserFunc.size() , Element.data(), Element.size(), Index.data(), Index.size(), MatchCount.data(), MatchCount.size());          }
         
         /// <summary> todo</summary> 
         /// <param name="first"> ...</param>
         /// <param name="last"> ...</param>
         /// <param name="expression"> ...</param>
         /// <param name="Step"> ...+++ use "Escaped names" [Step] in VB to avoid keyword conflict</param>
         /// <param name="Condition"> ...</param>
         /// <param name="VarIndex"> ...</param>
         /// <param name="VarFirst"> ...</param>
         /// <param name="VarLast"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String Populate(double first ,double last ,const string & expression ,double Step  = 1,const string & Condition  = "",const string & VarIndex  = "",const string & VarFirst  = "",const string & VarLast  = "") { return Populate_201(h, first , last , expression.data(), expression.size() , Step, Condition.data(), Condition.size(), VarIndex.data(), VarIndex.size(), VarFirst.data(), VarFirst.size(), VarLast.data(), VarLast.size());          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         String Match(size_t Index) { return Match_202(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> Index of the character who's match index you want</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t MatchIndexAtChar(size_t Index) { return MatchIndexAtChar_203(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> Index of the token who's match index you want</param>
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t MatchIndexAtToken(size_t Index) { return MatchIndexAtToken_204(h, Index);          }
         
         /// <summary> todo</summary> 
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String NonMatches() { return NonMatches_205(h);          }
         
         /// <summary> ...</summary> 
         /// <param name="Index"> ...</param>
         /// <remarks>
         /// <para>
         ///    ... +++ ???
         /// </para>
         /// </remarks> 
         String SubMatch(size_t Index) { return SubMatch_206(h, Index);          }
         
         /// <summary> ...</summary> 
         /// <remarks>
         /// <para>
         ///    ...
         /// </para>
         /// </remarks> 
         size_t MatchCount() { return MatchCount_207(h);          }
         
         /// <summary> todo</summary> 
         /// <param name="tt"> ...</param>
         /// <remarks>
         /// <para>
         ///    todo +++
         /// </para>
         /// </remarks> 
         String Transform(Transforms tt) { return Transform_208(h, tt.h);          }
         
         String() { h = Default().NewString().h;          }
         String(const String &Instance) { h = Instance.h;          } // +++ Check again
         String(const string & s) { h = Default().NewString(s).h;          }
         String(const char * s) { h = Default().NewString(s).h;          }
         operator string() { return Str();          } // +++ Check optimization
         String& operator=(const string & other) { Str(other); return *this;          }
         String& operator=(const char * other) { Str(other); return *this;          }
         // String& operator=(String & other) { Str(other.Str()); return *this; } //+++ Did not have the desired effect works in one kind of context but not the other
         // +++ String(String & s) { h = Default().NewString(s.Str()).h; } // +++ Copy other stuff too
         
         /// <summary> Returns the handle of an object</summary> 
         /// <remarks>
         /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
         ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
         /// </remarks> 
         void * Handle() { return Handle_209(h);          }
         
         /// <summary> +++ comment for each</summary> 
         void Release() { if (h != nullptr) Release_210(h); h = nullptr;          }
         
         String(uCalcPtr PassedHandle) { h = PassedHandle;          }
      }; // uCalcStringLib
      
      /// <summary> Handle for uCalc instance</summary> 
      uCalcPtr h;
      
      /// <summary> Adds an error handler</summary> 
      /// <param name="ErrorHandlerAddress"> Address of the callback function containing the error handler code</param>
      /// <param name="Position"> Position in which to insert the error handler</param>
      /// <returns> The error handler can later be removed using this return object</returns>
      /// <remarks>
      /// <para>Use this to set a a callback function that is called whenever there is an error.  Your callback can
      /// do things like alert the user of the error, correct the error and resume, keep a log of errors, etc.</para>
      /// <para>By default, if there are multiple error handlers, they are called starting with the most recently
      /// defined one first, ending with the first one to be defined last.  In order to define a handler in a different
      /// order, specify the Position value of where it should be inserted; 0 so that it is called first, -1 so it
      /// is called last, or a positive integer indicated where it should be inserted.  If the Postion value is out
      /// of bounds, it is adjusted into the maximum acceptable value.</para>
      /// <para>If you set ErrorResponse to ErrorHandlerResponseEnum.ErrorResume, subsequent error handler callbacks will
      /// be bypassed and uCalc will resume operations as though no error had taken place.  Note that the condition
      /// that caused the error must be corrected before resuming, otherwise uCalc may get stuck in an infinite loop.</para>
      /// <para>Some functions, such as ErrorExpression, ErrorLocation, and ErrorSymbol produce a meaningful result only
      /// during the parsing stage.  They do not cause other problems beyond meaningless data during the evaluation stage.
      /// </para>
      /// </remarks> 
      Item AddErrorHandler(uCalcCallback ErrorHandlerAddress ,size_t Position  = 0) { return AddErrorHandler_211(h, ErrorHandlerAddress , Position);       }
      
      /// <summary> Creates a new uCalc instance</summary> 
      /// <param name="BasedOn"> ...</param>
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      static uCalc Create(uCalc BasedOn  = nullptr) { return Create_212(0, BasedOn.h);       }
      
      /// <summary> Creates a new uCalc instance // +++ Maybe rename TempDefaultCreate() (or have both)</summary> 
      /// <param name="BasedOn"> ...</param>
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      static uCalc CreateTempDefault(uCalc BasedOn  = nullptr) { return CreateTempDefault_213(0, BasedOn.h);       }
      
      /// <summary> Creates a new uCalc instance  +++Maybe rename TempDefaultRelease()</summary> 
      /// <remarks>
      /// <para>This is not meant to be called directly.</para>
      /// </remarks> 
      static uCalc ReleaseTempDefault() { return ReleaseTempDefault_214(0);       }
      
      /// <summary> Adds an alias to an existing symbol</summary> 
      /// <param name="NewSymbol"> New symbol that will be set as equivalent to an existing symbol</param>
      /// <param name="ExistingSymbol"> Pre-existing symbol</param>
      /// <remarks>
      /// <para>
      /// This function creates a new symbol that is pegged to an existing symbol.  Whenever this new symbol is encountered by the parser,
      /// it will be the same as if it had encountered the pre-existing symbol this new symbol is an alias of.  This new symbol shares the same handle as the
      /// pre-existing symbol within the symbol table.  The new symbol actually has its own handle, but that handle can only be used to delete the item.
      /// The pre-existing handle is used for all other purposes.</para>
      /// <para>For simple situations where you just want two symbols to be considered equivalent by the parser, Alias is prefered as a more efficient option over
      /// ExpressionTransforms().FromTo().</para>
      /// <para></para>
      /// </remarks> 
      Item Alias(const string & NewSymbol ,const string & ExistingSymbol) { return Alias_215(h, NewSymbol.data(), NewSymbol.size() , ExistingSymbol.data(), ExistingSymbol.size());       }
      
      /// <summary> Adds an alias to an existing symbol</summary> 
      /// <param name="NewSymbol"> New symbol that will be set as equivalent to an existing symbol</param>
      /// <param name="ExistingItem"> Pre-existing item</param>
      /// <remarks>
      /// <para>
      /// This function creates a new symbol that is pegged to an existing symbol.  Whenever this new symbol is encountered by the parser,
      /// it will be the same as if it had encountered the pre-existing symbol this new symbol is an alias of.  This new symbol shares the same handle as the
      /// pre-existing symbol within the symbol table.  The new symbol actually has its own handle, but that handle can only be used to delete the item.
      /// The pre-existing handle is used for all other purposes.</para>
      /// <para>This version of Alias uses an Item object as second argument.  It is a little more efficient than the one that uses a string (the string version calls
      /// the internal version of this function).
      /// </para>
      /// </remarks> 
      Item Alias(const string & NewSymbol ,Item ExistingItem) { return Alias_216(h, NewSymbol.data(), NewSymbol.size() , ExistingItem.h);       }
      
      /// <summary> Adds an alias name to an existing command name for Define()</summary> 
      /// <param name="NewCommandName"> New command name that will be set as equivalent to an existing command name</param>
      /// <param name="ExistingCommandName"> Pre-existing command name</param>
      /// <remarks>
      /// <para>
      /// This creates an alternative command name for use with the Define() function.
      /// </para>
      /// </remarks> 
      void AliasForDefine(const string & NewCommandName ,const string & ExistingCommandName) { AliasForDefine_217(h, NewCommandName.data(), NewCommandName.size() , ExistingCommandName.data(), ExistingCommandName.size());       }
      
      /// <summary> Returns the data type of the expression that was passed</summary> 
      /// <param name="expression"> Expression whose data type will be returned</param>
      /// <remarks>
      /// <para>
      ///    +++ Maybe consolidate with GetDataType
      ///    Returns the data type of the expression that was passed
      /// </para>
      /// </remarks> 
      DataType DataTypeOf(const string & expression) { return DataTypeOf_218(h, expression.data(), expression.size());       }
      
      /// <summary> Returns a data type object</summary> 
      /// <param name="Index"> Index associated with the data type</param>
      /// <remarks>
      /// <para>Each instance of uCalc has its own separate handle & data type object for any given data type.  For
      /// instance, Item("Int64") in one instance of uCalc is not the same object as Item("Int64") from
      /// another uCalc instance.  This allows the same data type to have a different name and different formatting
      /// in different instances.  However, they share the same data type index across instances.  Given the index
      /// of a data type, you can directly obtain the proper data type object for a particular uCalc instance,
      /// faster than obtaining it by name as text with Item().
      /// </para>
      /// </remarks> 
      DataType DataTypeOf(BuiltInTypesEnum Index) { return DataTypeOf_219(h, Index);       }
      
      /// <summary> Defines a uCalc.Item object (a constunction, function, operator, variable, etc)</summary> 
      /// <param name="expression"> Text containing item to be defined.  expression must start with a keyword such as Function, Operator, Variable, Token, Syntax, etc., followed by a colon, before the expression</param>
      /// <param name="Address"> Address a function or variable is attached to</param>
      /// <param name="dType"> ...</param>
      /// <remarks>
      /// <para>Functions, operators, variables, constants, tokens, syntax constructs, etc., can be defined with
      /// this method.  Although there are specialized methods that do the same things, such as DefineFunction,
      /// DefineOperator, DefineVariable, and DefineConstant, this method may in same cases offer
      /// more flexibility.</para>
      /// <para>The expression must be preceded by a keyword and colon, such as "Variable:".  For a full list of keywords,
      /// see Definition Keywords.</para>
      /// <para>Sections are separated by ~~ (two tilda signs).
      /// </para>
      /// </remarks> 
      Item Define(const string & expression ,void * Address  = 0,DataType dType  = nullptr) { return Define_220(h, expression.data(), expression.size() , Address, dType.h);       }
      
      /// <summary> Defines a constant</summary> 
      /// <param name="Definition"> Text containing constant to be defined</param>
      /// <param name="VariableAddress"> Address the constant is attached to</param>
      /// <remarks>
      /// <para>
      /// A constant definition is similar to that of a variable defined with DefineVariable, except that the end-user is not allowed to modify the value of a constant.
      /// You are, however, allowed to perform lower-level operations such as renaming a constant, or deleting it and re-defining a new constant or variable with the same
      /// name but different value.  If you attach the constant to the address of a variable in your host program, the host program may change the value.  However, when
      /// the end-user attempts to assign a value to the constant, an error is raised.</para>
      /// <para>DefineConstant("x") is the same as: Define("Lock ~~ Variable: x")
      /// </para>
      /// </remarks> 
      Item DefineConstant(const string & Definition ,void * VariableAddress  = 0) { return DefineConstant_221(h, Definition.data(), Definition.size() , VariableAddress);       }
      
      /// <summary> Defines a function</summary> 
      /// <param name="Definition"> Text containing function to be defined</param>
      /// <param name="FunctionAddr"> Address of callback function this function is attached to</param>
      /// <remarks>
      /// <para>
      /// A function definition can either be self-contained, or it may be attached to the address of a callback function in your
      /// source code.</para>
      /// <para>DefineFunction("f(x) = ...") is the same as: Define("Function: ...")
      /// </para>
      /// </remarks> 
      Item DefineFunction(const string & Definition ,uCalcCallback FunctionAddr  = 0) { return DefineFunction_222(h, Definition.data(), Definition.size() , FunctionAddr);       }
      
      /// <summary> Defines an operator</summary> 
      /// <param name="Definition"> Text containing operator to be defined</param>
      /// <param name="iPrecedence"> Precedence level of the operator. +++ Rename</param>
      /// <param name="Grouping"> Operator associativity; arithmetic operators are typically grouped left-to-right; special operators, such as the equal sign, =, assignment operator are right-to-left</param>
      /// <param name="FunctionAddr"> Address of callback function this operator is attached to</param>
      /// <remarks>
      /// <para>
      /// Many details for defining an operator are similar to those of defining a function.  In additionn, all operators must be
      /// defined with a precedence level.  You may use the Precedence function to obtain precedence levels of existing operators,
      /// and select a precedence level in comparison to those operators.  By default operators are grouped left to right.  But you
      /// may also set it to right to left.  This means that when adjacent operators have the same precedence level, the operands on
      /// the right will be evaluated first.</para>
      /// <para>DefineOperator("...") is the same as: Define("Operator: ...")
      /// More later+++
      /// </para>
      /// </remarks> 
      Item DefineOperator(const string & Definition ,size_t iPrecedence ,GroupingEnum Grouping  = GroupLeftToRight,uCalcCallback FunctionAddr  = 0) { return DefineOperator_223(h, Definition.data(), Definition.size() , iPrecedence , Grouping, FunctionAddr);       }
      
      /// <summary> Defines a variable</summary> 
      /// <param name="Definition"> Text containing variable to be defined</param>
      /// <param name="VariableAddress"> Address of variable in host program this uCalc variable is attached to</param>
      /// <remarks>
      /// <para>
      /// A variable consists of ...</para>
      /// <para>DefineVariable("...") is the same as: Define("Variable: x")
      /// </para>
      /// </remarks> 
      Item DefineVariable(const string & Definition ,void * VariableAddress  = 0) { return DefineVariable_224(h, Definition.data(), Definition.size() , VariableAddress);       }
      
      /// <summary> Returns the expression associated with an error that was raised</summary> 
      string ErrorExpression() {
         size_t ReturnStrSize;
         const char * ReturnStr = ErrorExpression_225(h, ReturnStrSize );
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> Sets a new expression after an error is raised</summary> 
      /// <param name="expression"> Error expression</param>
      void ErrorExpression(const string & expression) { ErrorExpression_226(h, expression.data(), expression.size());       }
      
      /// <summary> Returns the location of an error that was raised</summary> 
      size_t ErrorLocation() { return ErrorLocation_227(h);       }
      
      /// <summary> Returns a message associated with the error that was raised</summary> 
      /// <param name="Index"> Index of error message to return</param>
      /// <remarks>
      /// <para>If an error was raised, this returns a message describing the recent error.  If the Index argument is specified,
      /// then the error message associated with this Index is returned.  A value must be chosen from ErrorNumberEnum.</para>
      /// <para>Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
      /// </para>
      /// </remarks> 
      string ErrorMessage(ErrorNumberEnum Index  = Err_None) {
         size_t ReturnStrSize;
         const char * ReturnStr = ErrorMessage_228(h, ReturnStrSize , Index);
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> Returns the error number of the error that was raised</summary> 
      /// <remarks>
      /// <para>
      /// Returns the error number of the most recently raised error.</para>
      /// <para>Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
      /// </para>
      /// </remarks> 
      ErrorNumberEnum ErrorNumber() { return ErrorNumber_229(h);       }
      
      /// <summary> Sets the error response for an error handler</summary> 
      /// <param name="Response"> Indicates what should happen now that an error is raised</param>
      /// <remarks>
      /// <para>When an error is raised, you have the option of aborting the rest of the option (which is the default option),
      /// or you may correct the problem, and then resume the operation.  Or you may perform an action, and than raise the
      /// error again for a subsequent error handle to take care of.</para>
      /// <para>This method can only be called from within a callback of an error handler routine definined with AddErrorHandler.
      /// The options to use can be found at ErrorHandlerResponseEnum.
      /// </para>
      /// </remarks> 
      void ErrorResponse(ErrorHandlerResponseEnum Response) { ErrorResponse_230(h, Response);       }
      
      /// <summary> Returns the symbol associated with the error that is raised</summary> 
      string ErrorSymbol() {
         size_t ReturnStrSize;
         const char * ReturnStr = ErrorSymbol_231(h, ReturnStrSize );
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> Parses and evaluates an expression in one step</summary> 
      /// <param name="expression"> Expression to be evaluated</param>
      /// <remarks>
      /// <para>This takes a math expression and returns a numeric result.</para>
      /// </remarks> 
      double Eval(const string & expression) { return Eval_232(h, expression.data(), expression.size());       }
      
      /// <summary> Parses and evaluates an expression of any data type in one step, returning the result as a string</summary> 
      /// <param name="expression"> Expression to be evaluated</param>
      /// <remarks>
      /// <para>This is similar to Eval, however, it can return non-numeric results, such as strings.</para>
      /// </remarks> 
      string EvalStr(const string & expression) {
         size_t ReturnStrSize;
         const char * ReturnStr = EvalStr_233(h, ReturnStrSize , expression.data(), expression.size());
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> Causes division by 0 errors to be raised</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead of silently returning a special value when a division by 0 or pole error occurs.
      /// </para>
      /// </remarks> 
      void RaiseErrorOnDivideByZero(bool TrueOrFalse  = true) { RaiseErrorOnDivideByZero_234(h, TrueOrFalse);       }
      
      /// <summary> Causes inexact results to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning an approximate value where an exact value cannot be represented.
      /// </para>
      /// </remarks> 
      void RaiseErrorOnInexact(bool TrueOrFalse  = true) { RaiseErrorOnInexact_235(h, TrueOrFalse);       }
      
      /// <summary> Causes underflow to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised for underflow.
      /// </para>
      /// </remarks> 
      void RaiseErrorOnUnderflow(bool TrueOrFalse  = true) { RaiseErrorOnUnderflow_236(h, TrueOrFalse);       }
      
      /// <summary> Causes overflow to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning infinity when there's an overflow.
      /// </para>
      /// </remarks> 
      void RaiseErrorOnOverflow(bool TrueOrFalse  = true) { RaiseErrorOnOverflow_237(h, TrueOrFalse);       }
      
      /// <summary> Causes invalid value to raise an error</summary> 
      /// <param name="TrueOrFalse">...</param>
      /// <remarks>
      /// <para>
      /// This causes an error to be raised instead returning NaN when an invalid value is encountered.
      /// </para>
      /// </remarks> 
      void RaiseErrorOnInvalid(bool TrueOrFalse  = true) { RaiseErrorOnInvalid_238(h, TrueOrFalse);       }
      
      /// <summary> Returns the floating point errors to catch</summary> 
      /// <param name="Value"> ...</param>
      /// <remarks>
      /// <para>
      /// ...
      /// </para>
      /// </remarks> 
      int32_t FloatingPointErrorsToCatch(int32_t Value  = -1) { return FloatingPointErrorsToCatch_239(h, Value);       }
      
      /// <summary> Returns the uCalc.Item object associated with the given name</summary> 
      /// <param name="ItemName"> Name of uCalc.Item that you want to get</param>
      /// <param name="Properties"> Properties to help pinpoint the right Item, in case several items share the same name +++ have Is[Alias] option (will loop through to find)</param>
      /// <remarks>
      /// <para>
      /// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.</para>
      /// <para>In case multiple items share the same name, you can narrow it down using properties.  For instance, the + operator has a
      /// binary and unary versions.  You can specify Prefix if you wanted the unary one.</para>
      /// <para>Note: A ItemIsEnum member should not be passed directly as the second argument.  Instead Properties, with one or more
      /// ItemIsEnum members should be passed.
      /// </para>
      /// </remarks> 
      Item ItemOf(const string & ItemName ,int64_t Properties  = 0) { return ItemOf_240(h, ItemName.data(), ItemName.size() , Properties);       }
      
      /// <summary> Returns the nth uCalc.Item object that matches a property</summary> 
      /// <param name="Property_"> Property of the uCalc.Item object you're after</param>
      /// <param name="nth"> The nth object</param>
      /// <param name="DataTypeName"> The data type of the object</param>
      /// <remarks>
      /// <para>
      /// This can be used to cycle through defined items.
      /// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.
      /// </para>
      /// </remarks> 
      Item ItemOf(ItemIsEnum Property_ ,size_t nth ,const string & DataTypeName  = "") { return ItemOf_241(h, Property_ , nth , DataTypeName.data(), DataTypeName.size());       }
      /// <summary> ???</summary> 
      /// <param name="nth"> +++</param>
      Item NamespaceChild(size_t nth  = 0) { return NamespaceChild_242(h, nth);       }
      
      /// <summary> ???</summary> 
      size_t NamespaceChildCount() { return NamespaceChildCount_243(h);       }
      
      /// <summary> ???</summary> 
      /// <param name="Level"> +++</param>
      Item NamespaceParent(size_t Level  = 0) { return NamespaceParent_244(h, Level);       }
      
      /// <summary> ???</summary> 
      /// <param name="nth"> +++</param>
      Item NamespaceSymbol(size_t nth) { return NamespaceSymbol_245(h, nth);       }
      
      /// <summary> ???</summary> 
      size_t NamespaceSymbolCount() { return NamespaceSymbolCount_246(h);       }
      
      /// <summary> Returns a new uCalc String object</summary> 
      /// <param name="InitialString"> String value</param>
      /// <remarks>
      /// <para>
      /// Returns a new uCalc String object.
      /// </para>
      /// </remarks> 
      String NewString(const string & InitialString  = "") { return NewString_247(h, InitialString.data(), InitialString.size());       }
      
      /// <summary> Returns a new transform object</summary> 
      /// <remarks>
      /// <para>
      /// Returns a new object that can be used to transform text.
      /// +++ Decide on name; could be CreateTransform() or TransformObj()
      /// </para>
      /// </remarks> 
      Transforms NewTransform() { return NewTransform_248(h);       }
      
      /// <summary> Returns the transform object associated with the current uCalc object</summary> 
      /// <remarks>
      /// <para>
      /// Whenever a math expression is parsed, this transform is first called.  Use this when you want transforms that apply to math
      /// expressions parsed with Parse, Eval, or EvalStr.  To create a new transform that does not affect math expressions sent to
      /// Parse, use NewTransform instead.</para>
      /// <para>Independent transforms created with NewTransform can be released when no longer needed.  However, the object created with
      /// ExpressionTransforms should never be released explicitely, because the uCalc object requires it in order parse expressions.</para>
      /// <para>Note: For simple situations when you just want one keyword to be the equivalent of a pre-existing one, it is more efficient to
      /// use Alias().  With Alias, nothing is transformed.  Instead, an aliased symbol simply shares the same handle as a pre-existing
      /// one in the symbol table.  When there are no expression transforms at all, the transform step is skipped altogether, slightly
      /// speeding up parsing for all expressions in a uCalc object.
      /// </para>
      /// </remarks> 
      Transforms ExpressionTransforms() { return ExpressionTransforms_249(h);       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataType"> Data type of return value</param>
      Expression Parse(const string & expression ,DataType DataType  = nullptr) { return Parse_250(h, expression.data(), expression.size() , DataType.h);       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataType"> Data type of return value</param>
      Expression Parse(const string & expression ,const string & DataType) { return Parse_251(h, expression.data(), expression.size() , DataType.data(), DataType.size());       }
      
      /// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary> 
      /// <param name="expression"> Expression to be parsed</param>
      /// <param name="DataTypeIndex"> Data type index of return value</param>
      Expression Parse(const string & expression ,BuiltInTypesEnum DataTypeIndex) { return Parse_252(h, expression.data(), expression.size() , DataTypeIndex);       }
      
      /// <summary> Returns the precedence level of an operator or the level between two operators</summary> 
      /// <param name="Operator1"> Operator with lower (or equal) precedence</param>
      /// <param name="Operator2"> Operator with greater (or equal precedence)</param>
      /// <remarks>
      /// <para>
      /// This returns a precedence level based on levels of existing operators; useful when defining a new operator (or transform)
      /// with a level relative to levels of existing operators (or transforms).  If one argument is passed, then the precedence
      /// level of that item is returned.  This is useful for defining a new item at the same level as the specified item.  If two
      /// arguments are passed, then the average precedence level of the two items is returned.  This is useful for defining a level
      /// that's in between that of two existing items.
      /// </para>
      /// </remarks> 
      size_t Precedence(const string & Operator1 ,const string & Operator2  = "") { return Precedence_253(h, Operator1.data(), Operator1.size() , Operator2.data(), Operator2.size());       }
      
      /// <summary> Combines properties into a numeric value that can be passed to Item</summary> 
      /// <param name="p1"> +++</param>
      /// <param name="p2"> +++</param>
      /// <param name="p3"> +++</param>
      /// <param name="p4"> +++</param>
      /// <remarks>
      /// <para>
      /// ItemIsEnum properties are numbered sequentially (0, 1, 2, 3, 4, ...).  However the Properties argument
      /// of the Item function requires properties in the 2^x sequence (1, 2, 4, 8, 16, ...).  So you
      /// must pass one or more ItemIsEnum to Properties before passing it to Item.
      /// +++ Maybe rename for clarity (CombineProperties, or something much shorter)
      /// </para>
      /// </remarks> 
      static int64_t Properties(ItemIsEnum p1 ,ItemIsEnum p2  = SelectAny,ItemIsEnum p3  = SelectAny,ItemIsEnum p4  = SelectAny) { return Properties_254(0, p1 , p2, p3, p4);       }
      
      /// <summary> Returns default settings</summary> 
      /// <remarks>
      /// <para>The Item returned contains the default settings for the current uCalc instance.  To define new settings,
      /// use Define("Default ~~ ...").
      /// +++ Rename something like DefaultSettings or DefaultItemSettings
      /// </para>
      /// </remarks> 
      Item DefaultItem() { return DefaultItem_255(h);       }
      
      /// <summary> ...</summary> 
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      DataType DefaultDataType() { return DefaultDataType_256(h);       }
      
      /// <summary> ...</summary> 
      /// <param name="dType"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      void DefaultDataType(DataType dType) { DefaultDataType_257(h, dType.h);       }
      
      /// <summary> ..</summary> 
      /// <param name="DataTypeIndex"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      void DefaultDataType(BuiltInTypesEnum DataTypeIndex) { DefaultDataType_258(h, DataTypeIndex);       }
      
      /// <summary> ...</summary> 
      /// <param name="dTypeStr"> ...</param>
      /// <remarks>
      /// <para>...
      /// </para>
      /// </remarks> 
      void DefaultDataType(const string & dTypeStr) { DefaultDataType_259(h, dTypeStr.data(), dTypeStr.size());       }
      
      /// <summary> Checks to see if this uCalc object instance is the default</summary> 
      /// <remarks>
      /// <para>
      /// Definitions from this instance will automatically be loaded into new instances unless directed otherwise.
      /// </para>
      /// </remarks> 
      bool IsDefault() { return IsDefault_260(h);       }
      
      /// <summary> Sets this uCalc object instance as the default</summary> 
      /// <param name="Condition"> ...</param>
      /// <remarks>
      /// <para>
      /// Definitions from this instance will automatically be loaded into new instances unless directed otherwise.
      /// Set this to True.  WHen set to False, nothing happens.
      /// </para>
      /// </remarks> 
      void IsDefault(bool Condition) { IsDefault_261(h, Condition);       }
      
      /// <summary> +++</summary> 
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      static uCalc Default() { return Default_262(0);       }
      
      /// <summary> +++</summary> 
      /// <param name="uCalcObj"> uCalc object to set as default</param>
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      static void Default(uCalc uCalcObj) { Default_263(0, uCalcObj.h);       }
      
      /// <summary> Allows a callback to decorate the output of EvalStr</summary> 
      /// <param name="FunctionAddr"> Address of callback function that formats the output</param>
      /// <param name="Properties"> Name of datatype that will have its output formated and/or ranking among other output formats; omit this to affect all data types and use default ranking.</param>
      Item Format(uCalcCallback FunctionAddr ,const string & Properties  = "") { return Format_264(h, FunctionAddr , Properties.data(), Properties.size());       }
      
      /// <summary> Allows a callback to decorate the output of EvalStr</summary> 
      /// <param name="FunctionAddr"> Address of callback function that formats the output</param>
      /// <param name="dType"> +++ Test dType // Data type that will have its output formated and/or ranking among other output formats; omit this to affect all data types and use default ranking.</param>
      Item Format(uCalcCallback FunctionAddr ,DataType dType) { return Format_265(h, FunctionAddr , dType.h);       }
      
      /// <summary> Formats the appearance of results returned by EvalStr or EvaluateStr</summary> 
      /// <param name="Definition"> Format definition for the output</param>
      /// <param name="dType"> +++ Test dType</param>
      /// <remarks>
      /// <para>
      /// This function lets you modify the output returned by EvalStr or EvaluateStr.  The definition may contain one or more
      /// of the following:</para>
      /// <para>Datatype:  If you specify a data type, then the modification will affect only the evaluation result of expressions
      /// that evaluate to the specified data type.</para>
      /// <para>InsertAt:  By default, if you define multiple outputs, then the one defined most recently is applied first, followed by
      /// the other outputs in reverse order in which they were defined, ending with the output that was defined first.  You may
      /// specify a different insertion point than the default with this parameter.</para>
      /// <para>Expression:  This represents what the modified output should look like.  The expression consists of an identifier
      /// (any temporary variable name), followed by an equal sign, followed by a string expression representing the value
      /// that will be returned.  The variable holds the original value that would have been returned.
      /// </para>
      /// </remarks> 
      Item Format(const string & Definition ,DataType dType  = nullptr) { return Format_266(h, Definition.data(), Definition.size() , dType.h);       }
      
      /// <summary> Removes any output formatting</summary> 
      /// <param name="dType"> Data type</param>
      /// <remarks>
      /// <para>
      /// +++
      /// </para>
      /// </remarks> 
      void FormatRemove(DataType dType  = nullptr) { FormatRemove_267(h, dType.h);       }
      
      /// <summary> Returns the value located at the specified Pointer address</summary> 
      /// <param name="ValuePtr"> Pointer address containing the data +++ Swap args to match Function: ValueAt() +++ Also have overload w/ DataType as handle instead of string</param>
      /// <param name="dType"> Data type of the data you need, which helps to determine in which form to return the value at the given location</param>
      /// <remarks>
      /// <para>+++ Rename Value()
      /// +++ SetValueAt
      /// </para>
      /// </remarks> 
      string ValueAt(void * ValuePtr ,DataType dType  = nullptr) {
         size_t ReturnStrSize;
         const char * ReturnStr = ValueAt_268(h, ReturnStrSize , ValuePtr , dType.h);
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> Returns the value located at the specified Pointer address</summary> 
      /// <param name="ValuePtr"> Pointer address containing the data +++ Swap args to match Function: ValueAt() +++ Also have overload w/ DataType as handle instead of string</param>
      /// <param name="ValueDataType"> Data type of the data you need, which helps to determine in which form to return the value at the given location</param>
      /// <remarks>
      /// <para>+++ maybe remove this & leave the other
      /// +++ SetValueAt
      /// </para>
      /// </remarks> 
      string ValueAt(void * ValuePtr ,const string & ValueDataType) {
         size_t ReturnStrSize;
         const char * ReturnStr = ValueAt_269(h, ReturnStrSize , ValuePtr , ValueDataType.data(), ValueDataType.size());
         return string(ReturnStr, ReturnStrSize);
      }
      
      /// <summary> +++</summary> 
      /// <param name="LicenseType"> +++</param>
      /// <param name="L1"> +++</param>
      /// <param name="L2"> +++</param>
      /// <param name="L3"> +++</param>
      /// <param name="L4"> +++</param>
      /// <param name="L5"> +++</param>
      /// <returns> +++</returns>
      /// <remarks>
      /// <para>
      /// ...
      /// </para>
      /// </remarks> 
      static void License(LicenseTypeEnum LicenseType ,size_t L1  = 0,size_t L2  = 0,size_t L3  = 0,size_t L4  = 0,size_t L5  = 0) { License_270(0, LicenseType , L1, L2, L3, L4, L5);       }
      
      void Reset() { Release(); h = Create().h;       }
      void Reset(uCalc uCalcObj) { Release(); h = Create(uCalcObj).h;       }
      static String Copy(String s) { String sRet(s.Str()); return sRet.h;       } // +++ Do more thorough copy
      static String Share(String s) { return s.h;       } // +++ Default (or maybe
      static String Move(String s) { return s.h;       } // +++ Not needed
      static String Borrow(String s) {       } // +++ Starts out with same string pointer
      uCalc() { h = Create().h;       }
      
      /// <summary> Returns the handle of an object</summary> 
      /// <remarks>
      /// <para>Mostly for internal use.  However, if you are iterating through a series of objects with NextOverload
      ///    (when applicable), you may check Handle() to see when it becomes NULL (or 0) to know when to stop.</para>
      /// </remarks> 
      void * Handle() { return Handle_271(h);       }
      
      /// <summary> +++ comment for each</summary> 
      void Release() { if (h != nullptr) Release_272(h); h = nullptr;       }
      
      uCalc(uCalcPtr PassedHandle) { h = PassedHandle;       }
      
   };
} // Namespace End

using namespace uCalcSoftware; // +++ Determine if this should be left up to the user

// End of Template
