using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;






/// <summary>S: Data types that come with uCalc</summary>
/// <remarks>These are built-in data types that come with uCalc</remarks>
public enum BuiltInTypesEnum : int {
   Type_Unspecified,
   Type_Auto,
   /// <summary> Boolean -- </summary>
   Type_Boolean,
   /// <summary> Int8 +++ Rename these to things like Type_Int8</summary>
   Type_Integer_8,
   /// <summary> Byte</summary>
   Type_Integer_8u,
   /// <summary> Int16</summary>
   Type_Integer_16,
   /// <summary> Int16u</summary>
   Type_Integer_16u,
   /// <summary> Int32</summary>
   Type_Integer_32,
   /// <summary> Int32u</summary>
   Type_Integer_32u,
   /// <summary> Int64</summary>
   Type_Integer_64,
   /// <summary> Int64u</summary>
   Type_Integer_64u,
   /// <summary> Int128</summary>
   Type_Integer_128,
   /// <summary> Int128u</summary>
   Type_Integer_128u,
   /// <summary> Single</summary>
   Type_Float_Single,
   /// <summary> Double</summary>
   Type_Float_Double,
   /// <summary> Extended</summary>
   Type_Float_Extended,
   Type_Size_t,
   Type_Complex,
   Type_Decimal,
   Type_BigNum,
   Type_Date,
   Type_String,
   /// <summary> LPCSTR</summary>
   Type_String_LPCSTR,
   /// <summary> FixedStr</summary>
   Type_String_Fixed,
   /// <summary> WideStr</summary>
   Type_String_Wide,
   /// <summary> StackList</summary>
   Type_List_Stack,
   /// <summary> TableList</summary>
   Type_List_Table,
   /// <summary> SortedList</summary>
   Type_List_Sorted,
   Type_Null,
   Type_Void,
   Type_Any,
   Type_Pointer,
   Type_Omni,
   Type_UserDefined,
   Type_DataType,
   Type_Namespace,
   Type_IntPtr,
   Type_ADDR,
   Type_uCalcPtr,
   Type_Item,
   Type_ParsedExpr,
   Type_uCalcCallback,
   Type_Object,
   Type_Intrinsic
};

/// <summary>S: Data type constructors</summary>
public enum DataTypeConstruction : int {
   TypeConstr_ByteSize,
   TypeConstr_AllocArray,
   TypeConstr_AllocScalar,
   TypeConstr_AllocByPtr,
   TypeConstr_ReleaseArray,
   TypeConstr_ReleaseScalar,
   TypeConstr_ResetScalar,
   TypeConstr_ResetArray,
   TypeConstr_SetArrayValue,
   TypeConstr_SetScalarValue,
   TypeConstr_SwapScalarValues
};

/// <summary>S: Error hander responses</summary>
public enum ErrorHandlerResponseEnum : int {
   /// <summary> Immediately stops parsing</summary>
   ErrorAbort,
   /// <summary> Continues parsing (after the error is resolved)</summary>
   ErrorResume,
   /// <summary> Raises the same error again for the next error handler to take care of</summary>
   ErrorReRaise
};

/// <summary>S: Error numbers that uCalc may return</summary>
public enum ErrorNumberEnum : int {
   /// <summary> No error</summary>
   Err_None,
   /// <summary> Dynamically defined user error</summary>
   Err_Dynamically_Defined,
   /// <summary> Syntax error</summary>
   Err_Syntax_Error,
   /// <summary> Undefined identifier</summary>
   Err_Undefined_Identifier,
   /// <summary> File not found</summary>
   Err_FileNotFound,
   /// <summary> Unrecognized token</summary>
   Err_Unrecognized_Token,
   /// <summary> Unrecognized command</summary>
   Err_Unrecognized_Command,
   /// <summary> Data type mismatch</summary>
   Err_Datatype_Mismatch,
   /// <summary> Invalid number of arguments</summary>
   Err_Invalid_Argument_Count,
   /// <summary> Invalid definition</summary>
   Err_Invalid_Definition,
   /// <summary> Code block delimiter error</summary>
   Err_CodeBlock_Error,
   /// <summary> Undefined callback</summary>
   Err_Undefined_Callback,
   /// <summary> Error message already defined</summary>
   Err_ErrorMessageAlreadyDefined,
   /// <summary> This item cannot be modified</summary>
   Err_ItemCannotBeModified,
   /// <summary> Unrecognized class member</summary>
   Err_Unrecognized_Class_Member,
   /// <summary> Unrecognized namespace member</summary>
   Err_Unrecognized_Namespace_Member,
   /// <summary> Unbalanced quote</summary>
   Err_Unbalanced_Quote,
   /// <summary> Value cannot be assigned here</summary>
   Err_ValueCannotBeAssigned,
   /// <summary> Reparsing has passed the specified limit</summary>
   Err_ReParseOverflow,
   /// <summary> Array or list bound exceeded</summary>
   Err_Array_Bounds_Exceeded,
   /// <summary> Division by 0</summary>
   Err_Float_Division_By_Zero,
   /// <summary> Inexact result</summary>
   Err_Float_Inexact_Result,
   /// <summary> Invalid operation</summary>
   Err_Float_Invalid_Operation,
   /// <summary> Floating point overflow</summary>
   Err_Float_Overflow,
   /// <summary> Floating point underflow</summary>
   Err_Float_Underflow,
   Err_Customized1 = 100,
   Err_Customized2,
   Err_Customized3,
   Err_Customized4,
   Err_Customized5,
   Err_Customized6,
   Err_Customized7,
   Err_Customized8,
   Err_Customized9,
   Err_Customized10,
   Err_Customized11,
   Err_Customized12,
   Err_Customized13,
   Err_Customized14,
   Err_Customized15,
   Err_Customized16,
   Err_Customized17,
   Err_Customized18,
   Err_Customized19,
   Err_Customized20
};

/// <summary>S: Operator grouping associativity</summary>
public enum GroupingEnum : int {
   GroupLeftToRight,
   GroupRightToLeft
};

/// <summary>S: Properties that a uCalc item may have</summary>
/// <remarks>
///Items defined with uCalc typically have a combination of properties.  A variable defined
///with DefineVariable for instance will have the ItemIsEnum.Variable property set.  An operator
///will have the ItemIsEnum.Operator property set.  If it's an infix operator, in addition to
///having the ItemIsEnum.Operator property set, ItemIsEnum.Infix will also be set.
///property will also be set.
///
///The IsProperty function can determine if a given uCalc.Item has a certain property.
///
///You can use the GetItemOfProperty function to cycle through the list of all items that share
///certain properties, or to disambiguate between items that share the same name but have
///different roperties (for instance the + operator with the Prefix property vs another one
///with the Infix property).
///
///Some members are keywords in VB.NET.  To avoid naming conflict, the following members have been
///renamed in the VB.NET header: Function_, Operator_, Optional_, ByVal_, ByRef_, Class_, and NameSpace_.
///</remarks>
public enum ItemIsEnum : int {
   AnyItem,
   RightToLeft,
   DataType,
   Array,
   Class,
   NameSpace,
   Variable,
   LocalVariable,
   Function,
   Operator,
   FunctionOrOperator,
   Prefix,
   Infix,
   Postfix,
   AddressOwner,
   ByVal,
   ByRef,
   ByCopy,
   ByExpr,
   ByHandle,
   Pointer,
   Optional,
   VariableNumberOfArgs,
   LiteralItem,
   Locked,
   Enabled,
   /// <summary> +++ May need to rename; Purpose of Exclude: cause match to fail if this search item is found   </summary>
   Exclude,
   Transform,
   Search,
   ItemDef,
   ErrorHandler,
   StopNow,
   ApiCall,
   CaseSensitive,
   QuotedText,
   /// <summary> +++ RewindOnModify, RewindOnUpdate, RewindOnAlter, RewindOnRevise, RewindOnRevision, RewindOnRewriteRewindOnEdit, other?</summary>
   RewindOnChange,
   ExpandArg,
   Active,
   IgnoreStatementSep,
   IgnoreCodeBlock,   
   SkipEvalExpand,
   ExprUnit,
   EagerArg,
   SkipSyntax,
   SkipOver,
   Modified,
   /// <summary> +++ Maybe rename WhiteSpaceSensitive   </summary>
   WhiteSpaceCounts,
   IgnoreQuote,
   UpToEndOrSeparator,
   UpToUserStop,
   UpToCompleted,   
   ExpandMode,
   StepsOn,
   EvalStrOutput,
   SkipOutput,
   DefaultSettings,
   NotFound,  
   MiscItem
};

/// <summary>S: Licensing options for uCalc products</summary>
public enum LicenseTypeEnum : int {
   License_Demo,
   License_FMP_Free,
   License_FMP_Standard_32,
   License_FMP_Standard_64,
   License_FMP_32_and_64,
   License_LanguageBuilder,
   License_GeneralParser,
   License_Interpreter,
   License_ConsoleCalc,
   License_WindowsCalc,
   License_StringLib,
   License_Transform,
   License_TransformLib,
   License_Search,
   License_SearchLib,
   License_Library1,
   License_Library2,
   License_Beta,
   License_Debugger,
   License_uCalc_All,
   License_Developer,
   License_EndUser
};

/// <summary>S: Types of tokens</summary>
public enum TokenEnum : int {
   None,
   /// <summary> A token defined without any specified property is generic (default)</summary>
   Generic,
   /// <summary> Represents the absence of any character (token not found)</summary>
   Empty,
   /// <summary> A token that behaves as alphanuric (works with word boundaries)</summary>
   AlphaNumeric,
   /// <summary> A token that serves as argument separator (typically a comma)</summary>
   ArgSeparator,
   /// <summary> A token that starts a code block; typically characters like {, [, or (</summary>
   CodeBlock,
   /// <summary> The closing token that matches a CodeBlock token, such as }, ], or )</summary>
   CodeBlockMatch,
   /// <summary> A token that separates an object from its member, typically a . (a dot)</summary>
   MemberAccess,
   /// <summary> A token that represents a literal value, typically a quoted string or number</summary>
   Literal,
   /// <summary> A token that represents a statement separator, typically a ; (semicolon)</summary>
   StatementSep,
   /// <summary> A token that represents whitespace, typically tab or space characters</summary>
   WhiteSpace,
   /// <summary> A token that is not delimited by word boundaries (+, -, *, etc), consecutive characters are reduced until they match a value that exists in the symbol table or until 1 character</summary>
   Reducible,
   /// <summary> Non-character that represents the end of a stream of text</summary>
   Eof,
   CurrentThread, 
   LocalVar,
   StaticVar,
   /// <summary> Item in parenthesis (or quotes) following this token will be defined while the expression is parsed</summary>
   DefineNow = StaticVar,
   TempDef,
   /// <summary> The expression in parathesis (or quotes) following the token is evaluated and inserted in place of the token in the string</summary>
   EvalInsert,
   EvalDuringParse,
   /// <summary> Works like EvalInsert, except the expression is expanded instead of evaluated</summary>
   ExpandInsert,
   /// <summary> The contents of the quoted file name following this token is inserted into the string</summary>
   FileInclude,
   CurrentSpace,
   DefSpace,
   EvalSpace
};

/// <summary>S: Boolean True or False</summary>
public enum TrueFalseEnum : int {
   /// <summary> For compilers in which False is a keyword use False_ instead</summary>
   False,
   /// <summary> For compilers in which True is a keyword use True_ instead</summary>
   True
};

/// <summary>S: Floating point environment exceptions</summary>
public enum FPEnvExceptionEnum : int {
   /// <summary> Floating point division by zero, or operation resulting in infinity, occured (pole error)</summary>
   DivisionByZero = 8 ,
   /// <summary> The result is not an exact floating point number</summary>
   Inexact = 1 ,
   /// <summary> Argument passed to a function or operator was invalid (domain error)</summary>
   Invalid = 16 ,
   /// <summary> The result is too large to be represented as a floating point value of the return type (overflow range error)</summary>
   Overflow = 4 ,
   /// <summary> The result is too small to be represented as a floating point value of the return type, causing loss of precision (underflow range error)</summary>
   Underflow = 2 ,
   /// <summary> Represents selection of all the floating point exceptions: DivisionByZero, Inexact, Invalid, Overflow, and Underflow (Bitwise ORed)</summary>
   AllExceptions = 31 
};

/// <summary>S: Floating point rouding options</summary>
public enum FPEnvRoundingEnum : int {
   /// <summary> Rounds downward (towards negative infinity)</summary>
   Round_Down = 512 ,
   /// <summary> Rounds towards nearest value</summary>
   Round_ToNearest = 0 ,
   /// <summary> Rounds towards zero</summary>
   Round_TowardZero = 768 ,
   /// <summary> Rounds upward (towards positive infinity)</summary>
   Round_Up = 256 
};

/// <summary>S: RegEx grammar option for defining tokens; based on C++ regex flags</summary>
public enum RegExGrammarEnum : int {
   /// <summary> Default grammar; ECMAScript is default unless reconfigured with +++</summary>
   RegEx_Default,
   /// <summary> JavaScript-like regex grammar</summary>
   RegEx_ECMAScript,
   /// <summary> Basic POSIX grammar (BRE)</summary>
   RegEx_basic,
   /// <summary> Extended POSIX grammar (ERE)</summary>
   RegEx_extended,
   /// <summary> awk POSIX grammar</summary>
   RegEx_awk,
   /// <summary> grep POSIX grammar</summary>
   RegEx_grep,
   /// <summary> egrep POXIX grammar</summary>
   RegEx_egrep
};

/// <summary>S: Transform reset options</summary>
/// <remarks>Use these options with Transform Reset.  The Default is Reset_All</remarks>
public enum TransformResetEnum : int {
   /// <summary> Resets all (Input, Tokens, Rules)</summary>
   Reset_All,
   /// <summary> Resets the input to an empty string</summary>
   Reset_Input,
   /// <summary> Resets token definitions</summary>
   Reset_Tokens,
   /// <summary> Resets the FromTo rules</summary>
   Reset_Rules,
   /// <summary> Resets transform results</summary>
   Reset_Results,
   /// <summary> Removes passes</summary>
   Reset_Passes
};

/// <summary>S: Options for Transform Pass</summary>
public enum PassEnum : int {
   /// <summary> Creates a pass with new token definitions that are separate from those of the parent +++ and separate one for transforms</summary>
   Pass_Independent,
   /// <summary> Creates a pass that inherits a separate copy of the token list from the parent</summary>
   Pass_InheritCopy,
   /// <summary> Creates a pass with that shares the same tokens as the parent</summary>
   Pass_InheritShare
};

/// <summary>S: Options for transform steps</summary>
public enum StepsEnum : int {
   Steps_None,
   Steps_All,
   Steps_Passes
};

/// <summary>S: Transform Properties</summary>
public enum TransformPropertiesEnum : int {
   NoTransformProperties,
   /// <summary> Save snapshots of entire text for each change</summary>
   Snapshot_EachChange = 1,
   /// <summary> Save snapshots of entire text for each pass</summary>
   Snapshot_EachPass = 2,
   /// <summary> Save snapshots of each local change</summary>
   Snapshot_LocalChange = 4,
   /// <summary> Save snapshots of local text before each change</summary>
   Archive_LocalOriginals = 5,
   /// <summary> Count number of modifications made by each rule</summary>
   CountChanges = 8
};



/// <summary> uCalc main class</summary>
public class uCalc {
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Evaluate")]
    protected static extern  double Evaluate_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="EvaluateNTE")]
    protected static extern  double EvaluateNTE_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="EvaluateInt32")]
    protected static extern  Int32 EvaluateInt32_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="EvaluateStr")]
    protected static extern  IntPtr EvaluateStr_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="EvaluateVoid")]
    protected static extern  IntPtr EvaluateVoid_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Execute")]
    protected static extern  void Execute_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseExpr")]
    protected static extern  void ReleaseExpr_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Handle_Overload_ParsedExpr")]
    protected static extern  IntPtr Handle_Overload_ParsedExpr_(IntPtr ExprHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ElementCount")]
    protected static extern  Int32 ElementCount_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetDataType")]
    protected static extern IntPtr GetDataType_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FunctionAddress")]
    protected static extern  IntPtr FunctionAddress_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="IsProperty")]
    protected static extern Int32 IsProperty_(IntPtr ItemHandle,ItemIsEnum ItemProperty);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Name_Overload_Item")]
    protected static extern  IntPtr Name_Overload_Item_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NextOverload")]
    protected static extern IntPtr NextOverload_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Precedence_Overload_Item")]
    protected static extern  Int32 Precedence_Overload_Item_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseItem")]
    protected static extern  void ReleaseItem_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Rename")]
    protected static extern  void Rename_(IntPtr ItemHandle, string NewName);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValue")]
    protected static extern  void SetVariableValue_(IntPtr ItemHandle, double Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueAny")]
    protected static extern  void SetVariableValueAny_(IntPtr ItemHandle, string Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueByte")]
    protected static extern  void SetVariableValueByte_(IntPtr ItemHandle, Byte Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueInt16")]
    protected static extern  void SetVariableValueInt16_(IntPtr ItemHandle, Int16 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueInt32")]
    protected static extern  void SetVariableValueInt32_(IntPtr ItemHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueInt64")]
    protected static extern  void SetVariableValueInt64_(IntPtr ItemHandle, Int64 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueSng")]
    protected static extern  void SetVariableValueSng_(IntPtr ItemHandle, float Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueDbl")]
    protected static extern  void SetVariableValueDbl_(IntPtr ItemHandle, double Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueStr")]
    protected static extern  void SetVariableValueStr_(IntPtr ItemHandle, string Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValuePtr")]
    protected static extern  void SetVariableValuePtr_(IntPtr ItemHandle, IntPtr Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetVariableValueByPtr")]
    protected static extern  void SetVariableValueByPtr_(IntPtr ItemHandle, IntPtr Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Text")]
    protected static extern  IntPtr Text_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetuCalc_Overload_Item")]
    protected static extern IntPtr GetuCalc_Overload_Item_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Value")]
    protected static extern  double Value_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueByte")]
    protected static extern  Byte ValueByte_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueInt16")]
    protected static extern  Int16 ValueInt16_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueInt32")]
    protected static extern  Int32 ValueInt32_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueInt64")]
    protected static extern  Int64 ValueInt64_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueSng")]
    protected static extern  float ValueSng_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueDbl")]
    protected static extern  double ValueDbl_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueStr")]
    protected static extern  IntPtr ValueStr_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValuePtr")]
    protected static extern  IntPtr ValuePtr_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueAddr")]
    protected static extern  IntPtr ValueAddr_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Handle_Overload_Item")]
    protected static extern  IntPtr Handle_Overload_Item_(IntPtr ItemHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Arg")]
    protected static extern  double Arg_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgCount")]
    protected static extern  Int32 ArgCount_(IntPtr ExprPartHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgObj")]
    protected static extern IntPtr ArgObj_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgAddr")]
    protected static extern  IntPtr ArgAddr_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgExpr")]
    protected static extern IntPtr ArgExpr_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgInt32")]
    protected static extern  Int32 ArgInt32_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgInt64")]
    protected static extern  Int64 ArgInt64_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgPtr")]
    protected static extern  IntPtr ArgPtr_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ArgStr")]
    protected static extern  IntPtr ArgStr_(IntPtr ExprPartHandle, Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Return")]
    protected static extern  void Return_(IntPtr ExprPartHandle, double Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReturnInt32")]
    protected static extern  void ReturnInt32_(IntPtr ExprPartHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReturnInt64")]
    protected static extern  void ReturnInt64_(IntPtr ExprPartHandle, Int64 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReturnPtr")]
    protected static extern  void ReturnPtr_(IntPtr ExprPartHandle, IntPtr Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReturnStr")]
    protected static extern  void ReturnStr_(IntPtr ExprPartHandle, string Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorRaise")]
    protected static extern  Int32 ErrorRaise_(IntPtr ExprPartHandle,ErrorNumberEnum ErrNumber);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorRaiseMessage")]
    protected static extern  Int32 ErrorRaiseMessage_(IntPtr ExprPartHandle, string ErrMessage);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetuCalc_Overload_Callback")]
    protected static extern IntPtr GetuCalc_Overload_Callback_(IntPtr ExprPartHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Handle_Overload_Callback")]
    protected static extern  IntPtr Handle_Overload_Callback_(IntPtr ExprPartHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="OpItem")]
    protected static extern IntPtr OpItem_(IntPtr ExprPartHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="AllocArray")]
    protected static extern  IntPtr AllocArray_(IntPtr DataTypeHandle, Int32 ArraySize);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="AllocByPtr")]
    protected static extern  IntPtr AllocByPtr_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="AllocScalar")]
    protected static extern  IntPtr AllocScalar_(IntPtr DataTypeHandle,  string Value  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ByteSize")]
    protected static extern  Int32 ByteSize_(IntPtr DataTypeHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Index")]
    protected static extern  BuiltInTypesEnum Index_(IntPtr DataTypeHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetItem")]
    protected static extern IntPtr GetItem_(IntPtr DataTypeHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Name_Overload_DataType")]
    protected static extern  IntPtr Name_Overload_DataType_(IntPtr DataTypeHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseArray")]
    protected static extern  void ReleaseArray_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseScalar")]
    protected static extern  void ReleaseScalar_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ResetArray")]
    protected static extern  void ResetArray_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ResetScalar")]
    protected static extern  void ResetScalar_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetArray")]
    protected static extern  void SetArray_(IntPtr DataTypeHandle, IntPtr Destination ,  IntPtr Source ,  Int32 Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetScalar")]
    protected static extern  void SetScalar_(IntPtr DataTypeHandle, IntPtr Destination ,  IntPtr Source);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SwapScalarValues")]
    protected static extern  void SwapScalarValues_(IntPtr DataTypeHandle, IntPtr ValuePtrA ,  IntPtr ValuePtrB);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ToString_Overload_DataType__ByPtr")]
    protected static extern  IntPtr ToString_Overload_DataType__ByPtr_(IntPtr DataTypeHandle, IntPtr ValuePtr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ToString_Overload_DataType__ByStr")]
    protected static extern  IntPtr ToString_Overload_DataType__ByStr_(IntPtr DataTypeHandle, string Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Handle_Overload_DataType")]
    protected static extern  IntPtr Handle_Overload_DataType_(IntPtr DataTypeHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Active")]
    protected static extern IntPtr Active_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FindPart")]
    protected static extern IntPtr FindPart_(IntPtr RuleHandle, string Pattern);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FromPart")]
    protected static extern IntPtr FromPart_(IntPtr RuleHandle, string Pattern);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ToPart")]
    protected static extern IntPtr ToPart_(IntPtr RuleHandle, string Pattern);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="CaseSensitive")]
    protected static extern IntPtr CaseSensitive_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="WhitespaceSensitive")]
    protected static extern IntPtr WhitespaceSensitive_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="CodeBlockSensitive")]
    protected static extern IntPtr CodeBlockSensitive_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Comment_Overload_uCalcTransform_RuleClass")]
    protected static extern IntPtr Comment_Overload_uCalcTransform_RuleClass_(IntPtr RuleHandle, string CommentStr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="LocalTransform")]
    protected static extern IntPtr LocalTransform_(IntPtr RuleHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Maximum")]
    protected static extern IntPtr Maximum_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="MaximumHard")]
    protected static extern IntPtr MaximumHard_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Minimum")]
    protected static extern IntPtr Minimum_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="MinimumHard")]
    protected static extern IntPtr MinimumHard_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Precedence")]
    protected static extern IntPtr Precedence_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="QuoteSensitive")]
    protected static extern IntPtr QuoteSensitive_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReplacementText")]
    protected static extern  IntPtr ReplacementText_(IntPtr RuleHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="StartAfter")]
    protected static extern IntPtr StartAfter_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="StopAfter")]
    protected static extern IntPtr StopAfter_(IntPtr RuleHandle, Int32 Value);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SkipOver")]
    protected static extern IntPtr SkipOver_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="RewindOnChange")]
    protected static extern IntPtr RewindOnChange_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ParseAgainMax")]
    protected static extern IntPtr ParseAgainMax_(IntPtr RuleHandle, bool TrueFalse ,  bool RaiseError);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="RightToLeft")]
    protected static extern IntPtr RightToLeft_(IntPtr RuleHandle, bool TrueFalse);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseRule")]
    protected static extern  void ReleaseRule_(IntPtr RuleHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Comment_Overload_uCalcTransform_Tokens")]
    protected static extern IntPtr Comment_Overload_uCalcTransform_Tokens_(IntPtr TokensHandle, string CommentStr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Import_Overload_uCalcTransform_Tokens__Obj")]
    protected static extern IntPtr Import_Overload_uCalcTransform_Tokens__Obj_(IntPtr TokensHandle,IntPtr FromTokenList );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Import_Overload_uCalcTransform_Tokens__File")]
    protected static extern IntPtr Import_Overload_uCalcTransform_Tokens__File_(IntPtr TokensHandle, string TokenFile);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Define_Overload_uCalcTransform_Tokens")]
    protected static extern IntPtr Define_Overload_uCalcTransform_Tokens_(IntPtr TokensHandle, string TokenDef , TokenEnum TokenType  ,  string EndMatch  ,  Int32 SubMatch  , RegExGrammarEnum RegExGrammar  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Comment_Overload_uCalcTransform")]
    protected static extern IntPtr Comment_Overload_uCalcTransform_(IntPtr TransformHandle, string CommentStr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineRule")]
    protected static extern IntPtr DefineRule_(IntPtr TransformHandle, string Comment ,  string FindStr ,  string ToStr ,  Int32 Min ,  Int32 Max ,  Int32 MinHard ,  Int32 MaxHard ,  Int32 Precedence ,  Int32 StartAfter ,  Int32 StopAfter ,  bool SkipOver ,  bool RewindOnChange ,  bool CaseSensitive ,  bool CodeblockSensitive ,  bool QuoteSensitive ,  bool RightToLeft);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineToken")]
    protected static extern IntPtr DefineToken_(IntPtr TransformHandle, string TokenDef , TokenEnum TokenType  ,  string EndMatch  ,  Int32 SubMatch  , RegExGrammarEnum RegExGrammar  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetTokens")]
    protected static extern IntPtr GetTokens_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FromTo")]
    protected static extern IntPtr FromTo_(IntPtr TransformHandle, string FromStr ,  string ToStr  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Import_Overload_uCalcTransform")]
    protected static extern IntPtr Import_Overload_uCalcTransform_(IntPtr TransformHandle, string FileName);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ListPrefix")]
    protected static extern IntPtr ListPrefix_(IntPtr TransformHandle, string Prefix);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ListPostfix")]
    protected static extern IntPtr ListPostfix_(IntPtr TransformHandle, string Postfix);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ListSeparator")]
    protected static extern IntPtr ListSeparator_(IntPtr TransformHandle, string Separator);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ListDelimiters")]
    protected static extern IntPtr ListDelimiters_(IntPtr TransformHandle, string Prefix ,  string Separator ,  string Postfix);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="MathParser")]
    protected static extern IntPtr MathParser_(IntPtr TransformHandle, IntPtr FMP   );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NewPass")]
    protected static extern IntPtr NewPass_(IntPtr TransformHandle,  bool Share  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Pass")]
    protected static extern IntPtr Pass_(IntPtr TransformHandle, Int32 Index ,  bool Share  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Reset")]
    protected static extern IntPtr Reset_(IntPtr TransformHandle, TransformResetEnum ResetOption  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ResultStr")]
    protected static extern  IntPtr ResultStr_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Transform")]
    protected static extern IntPtr Transform_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Expand")]
    protected static extern  IntPtr Expand_(IntPtr TransformHandle, string Expression);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ExpandWithSteps")]
    protected static extern  IntPtr ExpandWithSteps_(IntPtr TransformHandle, string Expression ,  string Separator  ,  string Prefix  ,  string Postfix  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetInput")]
    protected static extern IntPtr SetInput_(IntPtr TransformHandle, string InputStr);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetInputByRef")]
    protected static extern IntPtr SetInputByRef_(IntPtr TransformHandle,IntPtr InputStr );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetParser")]
    protected static extern IntPtr SetParser_(IntPtr TransformHandle,IntPtr FMP );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetProperties")]
    protected static extern IntPtr SetProperties_(IntPtr TransformHandle, TransformPropertiesEnum TransformProperties  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="WasModified")]
    protected static extern Int32 WasModified_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseTransform")]
    protected static extern  void ReleaseTransform_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetRule")]
    protected static extern IntPtr GetRule_(IntPtr TransformHandle,  Int32 Index  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="RulesDefault")]
    protected static extern IntPtr RulesDefault_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="RulesOverall")]
    protected static extern IntPtr RulesOverall_(IntPtr TransformHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="AddErrorHandler")]
    protected static extern IntPtr AddErrorHandler_(IntPtr uCalcHandle,uCalcDelegate ErrorHandlerAddress ,  Int32 Position  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="CreateuCalc")]
    protected static extern  IntPtr CreateuCalc_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DataTypeOfIndex")]
    protected static extern IntPtr DataTypeOfIndex_(IntPtr uCalcHandle,BuiltInTypesEnum Index);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Define_Overload_uCalc")]
    protected static extern IntPtr Define_Overload_uCalc_(IntPtr uCalcHandle, string Expression , IntPtr Address   , IntPtr ExistingItem   );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineConstant")]
    protected static extern IntPtr DefineConstant_(IntPtr uCalcHandle, string Definition , IntPtr VariableAddress   );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineDataType")]
    protected static extern IntPtr DefineDataType_(IntPtr uCalcHandle, Int32 TypeSize , IntPtr AllocArrayValue  , IntPtr AllocScalar  , IntPtr AllocScalarByPtr  , IntPtr DeleteArray  , IntPtr DeleteScalar  , IntPtr ResetScalar  , IntPtr ResetArray  , IntPtr SetValueArray  , IntPtr SetValueScalar  , IntPtr SwapValues  , IntPtr ToString );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineFunction")]
    protected static extern IntPtr DefineFunction_(IntPtr uCalcHandle, string Definition , uCalcDelegate FunctionAddress  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineOperator")]
    protected static extern IntPtr DefineOperator_(IntPtr uCalcHandle, string Definition ,  Int32 iPrecedence , GroupingEnum Grouping  , uCalcDelegate FunctionAddress  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="DefineVariable")]
    protected static extern IntPtr DefineVariable_(IntPtr uCalcHandle, string Definition , IntPtr VariableAddress   );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorExpression")]
    protected static extern  IntPtr ErrorExpression_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorLocation")]
    protected static extern  Int32 ErrorLocation_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorMessage")]
    protected static extern  IntPtr ErrorMessage_(IntPtr uCalcHandle, ErrorNumberEnum Index  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorNumber")]
    protected static extern  ErrorNumberEnum ErrorNumber_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorResponse")]
    protected static extern  void ErrorResponse_(IntPtr uCalcHandle,ErrorHandlerResponseEnum Response);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorSymbol")]
    protected static extern  IntPtr ErrorSymbol_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ErrorSetExpression")]
    protected static extern  void ErrorSetExpression_(IntPtr uCalcHandle, string Expression);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Eval")]
    protected static extern  double Eval_(IntPtr uCalcHandle, string Expression);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="EvalStr")]
    protected static extern  IntPtr EvalStr_(IntPtr uCalcHandle, string Expression);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvClearException")]
    protected static extern  Int32 FPEnvClearException_(IntPtr uCalcHandle,  Int32 Exceptions  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvGetExceptionMask")]
    protected static extern  Int32 FPEnvGetExceptionMask_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvRaiseException")]
    protected static extern  Int32 FPEnvRaiseException_(IntPtr uCalcHandle, FPEnvExceptionEnum Exception  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvGetRounding")]
    protected static extern  FPEnvRoundingEnum FPEnvGetRounding_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvSetExceptionMask")]
    protected static extern  void FPEnvSetExceptionMask_(IntPtr uCalcHandle, Int32 Exceptions);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvSetExceptionUnMask")]
    protected static extern  void FPEnvSetExceptionUnMask_(IntPtr uCalcHandle, Int32 Exceptions);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvSetRounding")]
    protected static extern  Int32 FPEnvSetRounding_(IntPtr uCalcHandle,FPEnvRoundingEnum Direction);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="FPEnvToggleExceptionMask")]
    protected static extern  void FPEnvToggleExceptionMask_(IntPtr uCalcHandle,FPEnvExceptionEnum Exception);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="HandleOf")]
    protected static extern  IntPtr HandleOf_(IntPtr uCalcHandle, string ItemName ,  Int64 Properties  ,  bool SkipTransform  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetItemOf")]
    protected static extern IntPtr GetItemOf_(IntPtr uCalcHandle, string ItemName ,  Int64 Properties  ,  bool SkipExpansion  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="GetItemOfProperty")]
    protected static extern IntPtr GetItemOfProperty_(IntPtr uCalcHandle,ItemIsEnum Property_ ,  Int32 nth ,  string DataTypeName  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="License")]
    protected static extern  Int32 License_(IntPtr uCalcHandle,LicenseTypeEnum LicenseType,   Int32 L1 ,   Int32 L2 ,   Int32 L3 ,   Int32 L4 ,   Int32 L5 );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NamespaceChild")]
    protected static extern IntPtr NamespaceChild_(IntPtr uCalcHandle,  Int32 nth );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NamespaceChildCount")]
    protected static extern  Int32 NamespaceChildCount_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NamespaceParent")]
    protected static extern IntPtr NamespaceParent_(IntPtr uCalcHandle,  Int32 Level );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NamespaceSymbol")]
    protected static extern IntPtr NamespaceSymbol_(IntPtr uCalcHandle, Int32 nth);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NamespaceSymbolCount")]
    protected static extern  Int32 NamespaceSymbolCount_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="NewTransform")]
    protected static extern IntPtr NewTransform_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ParserTransform")]
    protected static extern IntPtr ParserTransform_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Parse")]
    protected static extern IntPtr Parse_(IntPtr uCalcHandle, string Expression ,  string DataType  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Precedence_Overload_uCalc")]
    protected static extern  Int32 Precedence_Overload_uCalc_(IntPtr uCalcHandle, string Operator1 ,  string Operator2  );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Properties")]
    protected static extern  Int64 Properties_(IntPtr uCalcHandle,ItemIsEnum p1,  ItemIsEnum p2 ,  ItemIsEnum p3 ,  ItemIsEnum p4 );
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ReleaseuCalc")]
    protected static extern  void ReleaseuCalc_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ResetOutput")]
    protected static extern  void ResetOutput_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Default")]
    protected static extern IntPtr Default_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetOutput_Overload_uCalc__Callback")]
    protected static extern IntPtr SetOutput_Overload_uCalc__Callback_(IntPtr uCalcHandle,uCalcDelegate FunctionAddress ,  string Properties);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="SetOutput_Overload_uCalc__NoCallback")]
    protected static extern IntPtr SetOutput_Overload_uCalc__NoCallback_(IntPtr uCalcHandle, string Definition);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="CreateTransform")]
    protected static extern IntPtr CreateTransform_(IntPtr uCalcHandle);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="ValueAt")]
    protected static extern  IntPtr ValueAt_(IntPtr uCalcHandle, IntPtr ValuePtr ,  string DataType);
[DllImport("uCalcAndroid", CharSet=CharSet.Ansi, CallingConvention=CallingConvention.Cdecl, EntryPoint="Handle_Overload_uCalc")]
    protected static extern  IntPtr Handle_Overload_uCalc_(IntPtr uCalcHandle);


    public delegate void uCalcDelegate(IntPtr Expr); 
/// <summary> Handle for uCalc instance</summary>
public IntPtr uCalcHandle = default(IntPtr);

/// <summary> Class for evaluating an already parsed expression or executing parsed code</summary>
public class ParsedExpr {
 public IntPtr ExprHandle;






/// <summary> Rapidly evaluates a floating point expression that was parsed with Parse or passed By Expression</summary>
/// <returns> The result of the evaluated floating point expression</returns>
/// <remarks><para>Evaluate can be used instead of Eval for faster results in time-critical loops where the same expression
/// is repeatedly re-evaluated, with the only change in each iteration typically being the value(s) of one or
/// more variables.  Evaluate works in pair with Parse, the relatively slower part, which is called first before
/// going into the time-critical loop.  The ParsedExpr object returned by Parse is what calls the Evaluate function.
/// </para><para>
/// Evaluate can also be called by a ParsedExpr object that was passed to a callback By Expression.
/// </para><para>
/// The expression must be one who&#39;s evaluation returns a floating point numeric value.  If the expression evaluates
/// to a non-numeric value (such as a string) or non-scalar numeric value (such as a complex number), or if a numeric
/// type other than the default was explicitely specified with Parse, the value returned will be invalid.  However,
/// an error will not be raised.
/// </para></remarks>
public  double Evaluate() { return Evaluate_(ExprHandle); }
  


/// <summary> Same as Evaluate, but with no testing or handling for floating point exceptions</summary>
/// <returns> The result of the evaluated floating point expression</returns>
/// <remarks><para>This is similar to Evaluate, with the difference being that EvaluateNTE does not perform any exception handling
/// test.  As a consequence, the uCalc error handler callback does not handle these exceptions.
/// </para><para>
/// This option can speed up evaluations.  However, it&#39;s important to have a plan for handling exceptions.  You can either
/// mask all exceptions with FPEnvSetExceptionMask or FPEnvToggleExceptionMask, or catch exceptions with your own source
/// code (such as with try/catch).  If such provisions are not met, floating point exceptions (such as division by 0), may
/// cause your program to behave unexpectadly or to terminate abruptly.
/// </para></remarks>
public  double EvaluateNTE() { return EvaluateNTE_(ExprHandle); }
  


/// <summary> Rapidly evaluates expression that was parsed as integer with Parse or passed By Expression</summary>
/// <returns> The result of the evaluated integer expression</returns>
/// <remarks><para>
/// This is similar to Evaluate, but applies only to integer expressions.
/// </para></remarks>
public  Int32 EvaluateInt32() { return EvaluateInt32_(ExprHandle); }
  


/// <summary> Rapidly evaluates an expression of any data type that was parsed with Parse or passed By Expression returning a string</summary>
/// <returns> The result of an evaluated expression of any data type, returned as a string</returns>
/// <remarks><para>EvaluateStr is similar to Evaluate.  However, EvaluateStr returns a value as a string.  Unlike Evaluate, which can only
/// return a floating point value, EvaluateStr can return a value of any data type.  Non-string values are converted to a string
/// before being returned.
/// </para></remarks>
public  string EvaluateStr() { return Marshal.PtrToStringAnsi(EvaluateStr_(ExprHandle)); } 
  


/// <summary> Rapidly evaluates an expression that was parsed with Parse or passed By Expression and returns a IntPtr to the result</summary>
/// <returns> Returns a IntPtr to the result instead of the result itself</returns>
/// <remarks><para>Use this when you are interested in a IntPtr to the result instead of the result itself.  For instance, given an integer
/// result, you might use a IntPtr in order to retrieve the hi byte and lo byte values.
/// </para></remarks>
public  IntPtr EvaluateVoid() { return EvaluateVoid_(ExprHandle); }
  


/// <summary> Rapidly executes code that was parsed with Parse or passed By Expression for which a result is not required</summary>
/// <remarks><para>This can be used in cases where the reutrn value is not needed, such as statements that represent code to be executed
/// rather than a math expression.
/// </para></remarks>
public  void Execute() {  Execute_(ExprHandle); }
  


/// <summary> (Use Release instead)</summary>
/// <remarks><para>Use Release</para></remarks>
public  void ReleaseExpr() {  ReleaseExpr_(ExprHandle); }
  


/// <summary> Returns the handle of the parsed expression</summary>
/// <remarks><para>This numeric value represents the IntPtr that uCalc uses internally for the ParsedExpr object.
/// If you are iterating through a series of objects, such as with NextOverload, you may check Handle()
/// to see when it becomes NULL (or 0) to know when to stop.</para></remarks>
public IntPtr  Handle() { return Handle_Overload_ParsedExpr_(ExprHandle); }
  
/// <summary> Releases an expression that was parsed with Parse</summary>
/// <remarks><para>Whenever an expression is parsed with Parse, the parsed expression remains in memory until released.
/// When the parsed expression is no longer needed it should be released with Release to preserve memory.
/// Note: An expression parsed with Parse must explicitely be released with Release unless the uCalc
/// object it is in is released.  A parsed expression will not be released automatically when it simply
/// goes out of scope.
/// </para></remarks>
public void Release()  { ReleaseExpr(); ExprHandle = default(IntPtr); }

public ParsedExpr() { ExprHandle = default(IntPtr); }
public ParsedExpr( IntPtr ExpressionHandle) { ExprHandle = ExpressionHandle; }
public ParsedExpr( ParsedExpr ParsedExprInstance) { ExprHandle = ParsedExprInstance.ExprHandle; }
}


/// <summary> Class for handling uCalc items</summary>
public class Item {

/// <summary> Handle for a uCalc.Item</summary>
public IntPtr ItemHandle = default(IntPtr);



/// <summary> Returns the number of elements in a uCalc.Item</summary>
/// <remarks><para>Depending on the kind of object, this may represent the number of elements in an array, the number of parameters in a function,
/// the number of operands in an operator, the number of parameters in a syntax construct, the number of parts in a transform,
/// the number of parts in a compound token, or the value explicitlely set in the Count property when calling Define.
/// </para><para>
/// When determining the number of elements, optional parameters in a function count as an element.  If the function
/// has a variable number of arguments, then count is -1.
/// </para><para>
/// The value returned for a syntax construct may not seem obvious, especially if it has optional and/or alternative
/// parts or some other complexity.
/// </para><para>
/// +++ the number of symbols in a uCalc
/// instance,</para></remarks>
public  Int32 ElementCount() { return ElementCount_(ItemHandle); }
  


/// <summary> Returns the data type of a uCalc.Item</summary>
/// <remarks><para>The returned data type object can be used to determine the type name, size, etc.</para></remarks>
public DataType GetDataType() { return new DataType(GetDataType_(ItemHandle)); }
  


/// <summary> Returns the callback address of a defined function (or operator)</summary>
/// <remarks><para>The returned value is the actual IntPtr address of the function as used by uCalc internally, and not
/// a delegate, even in .NET.  As such, in .NET this value can be used in the more general Define function but
/// not functions like DefineFunction or DefineneOperator.</para></remarks>
public  IntPtr FunctionAddress() { return FunctionAddress_(ItemHandle); }
  


/// <summary> Determines if a uCalc.Item has the given properties</summary>
/// <param name="ItemProperty"> The property you want to check for</param>
/// <returns> Returns True if the uCalc.Item matches the given property, or False otherwise.</returns>
/// <remarks><para>This helps you determine whether the uCalc.Item is a function, operator, variable, data type,
/// literal value, etc, or has certain other special properties.  Note: Some items may have multiple
/// properties.  For instance the Function property may be set to true for arrays.
/// </para></remarks>
public  bool IsProperty(ItemIsEnum ItemProperty) { return IsProperty_(ItemHandle,ItemProperty) != 0; }
  


/// <summary> Returns the name of the uCalc.Item</summary>
/// <remarks><para>Items such as functions, operators, variables, etc generally are given a name when they are defined.
/// That name can be retried with this function.</para></remarks>
public string  Name() { return Marshal.PtrToStringAnsi(Name_Overload_Item_(ItemHandle)); } 
  


/// <summary> Returns next uCalc.Item object that shares the same name</summary>
/// <returns> Returns next uCalc.Item object that shares the same name, or a NULL (or 0) if there is none</returns>
/// <remarks><para>If several functions, operators, parameters, etc are overloaded -- that is they are defined with different
/// parameters but share the same name --, or if they (or variables) overshadow each other, this function returns
/// the next uCalc.Item object that shares the same name.</para></remarks>
public Item NextOverload() { return new Item(NextOverload_(ItemHandle)); }
  


/// <summary> Returns the precedence level of the uCalc.Item</summary>
/// <remarks><para>Operators, and some syntax constructs are defined with a precedence level.  When defining a new operator you
/// may sometimes want to give it the same level as a pre-existing operator.</para></remarks>
public Int32  Precedence() { return Precedence_Overload_Item_(ItemHandle); }
  


/// <summary> (Use Release instead)</summary>
/// <remarks><para>Use Release</para></remarks>
public  void ReleaseItem() {  ReleaseItem_(ItemHandle); }
  


/// <summary> Renames an item</summary>
/// <param name="NewName"> The new name of the item</param>
/// <remarks><para>
/// Any defined item that has a name (such as a variable, constant, function, operator, etc) can be renamed with this function.
/// </para></remarks>
public  void Rename( string NewName) {  Rename_(ItemHandle,NewName); }
  


/// <summary> Sets the value of a floating point variable +++ maybe SetValue instead of SetVariableValue</summary>
/// <param name="Value"> Double precision floating point value that the variable will be set to</param>
/// <remarks><para>When a floating point variable is defined with DefineVariable, you can later set a value for this variable using
/// SetVariableValue.  Note: If your compiler supports pointers, you can define a uCalc variable that is directly attached
/// to the address of a variable in your source code, and not have to use SetVariableValue.</para></remarks>
public  void SetVariableValue( double Value) {  SetVariableValue_(ItemHandle,Value); }
  


/// <summary> Sets the value of a variable of any data type by passing a string</summary>
/// <param name="Value"> String containing the value that will be converted and stored in the variable</param>
/// <remarks><para>This lets you set the value of a variable defined with DefineVariable (or Define) regardless of the variable&#39;s data type.
/// The value is passed as a string, and internally converted to the appropriate data type.  Note: Because a conversion takes
/// place with SetVariableValueAny, it is typically slower than calling SetVariableValue for floating point, or one of the
/// other versions of SetVariableValue specific to a data type.</para></remarks>
public  void SetVariableValueAny( string Value) {  SetVariableValueAny_(ItemHandle,Value); }
  


/// <summary> Sets the value of a Byte variable</summary>
/// <param name="Value"> Byte value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a Byte variable defined with DefineVariable (or Define)</para></remarks>
public  void SetVariableValueByte( Byte Value) {  SetVariableValueByte_(ItemHandle,Value); }
  


/// <summary> Sets the value of a 16-bit integer variable</summary>
/// <param name="Value"> 16-bit integer value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a 16-bit integer variable defined with DefineVariable (or Define).  This works for
/// both signed and unsigned 16-bit integers.</para></remarks>
public  void SetVariableValueInt16( Int16 Value) {  SetVariableValueInt16_(ItemHandle,Value); }
  


/// <summary> Sets the value of a 32-bit integer variable</summary>
/// <param name="Value"> 32-bit integer value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a 32-bit integer variable defined with DefineVariable (or Define).  This works for
/// both signed and unsigned 32-bit integers.</para></remarks>
public  void SetVariableValueInt32( Int32 Value) {  SetVariableValueInt32_(ItemHandle,Value); }
  


/// <summary> Sets the value of a 64-bit integer variable</summary>
/// <param name="Value"> 64-bit integer value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a 64-bit integer variable defined with DefineVariable (or Define).  This works for
/// both signed and unsigned 64-bit integers.</para></remarks>
public  void SetVariableValueInt64( Int64 Value) {  SetVariableValueInt64_(ItemHandle,Value); }
  


/// <summary> Sets the value of a single precision floating point variable</summary>
/// <param name="Value"> Single precision value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a single precision variable defined with DefineVariable (or Define).</para></remarks>
public  void SetVariableValueSng( float Value) {  SetVariableValueSng_(ItemHandle,Value); }
  


/// <summary> Sets the value of a double precision floating point variable</summary>
/// <param name="Value"> Double precision floating point value that the variable will be set to</param>
/// <remarks><para>SetVariableValueDbl is synonymous with SetVariableValue</para></remarks>
public  void SetVariableValueDbl( double Value) {  SetVariableValueDbl_(ItemHandle,Value); }
  


/// <summary> Sets the value of a string variable</summary>
/// <param name="Value"> String value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a string variable defined with DefineVariable (or Define).</para></remarks>
public  void SetVariableValueStr( string Value) {  SetVariableValueStr_(ItemHandle,Value); }
  


/// <summary> Sets the value of a IntPtr variable</summary>
/// <param name="Value"> IntPtr that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a IntPtr variable defined with DefineVariable (or Define).  Note: This does not
/// change the IntPtr of the variable.  It simply stores a IntPtr value in the variable.</para></remarks>
public  void SetVariableValuePtr( IntPtr Value) {  SetVariableValuePtr_(ItemHandle,Value); }
  


/// <summary> Sets the value of a variable to a value who&#39;s IntPtr is passed</summary>
/// <param name="Value"> IntPtr to the value that the variable will be set to</param>
/// <remarks><para>This lets you set the value of a variable by passing the IntPtr to the value you want to set the variable to.</para></remarks>
public  void SetVariableValueByPtr( IntPtr Value) {  SetVariableValueByPtr_(ItemHandle,Value); }
  


/// <summary> Returns the text data associated with a uCalc.Item</summary>
/// <remarks><para>Certain items may have a text property that can be retrieved with a call to this function.  The literal text
/// used to define an item is usually stored here.
/// </para></remarks>
public  string Text() { return Marshal.PtrToStringAnsi(Text_(ItemHandle)); } 
  


/// <summary> Returns the uCalc object that the uCalc.Item belongs to</summary>
/// <remarks><para>A uCalc.Item is defined in the context of a uCalc object.  You can later use this function to determine
/// the uCalc object the defined item belongs to.</para></remarks>
public uCalc  GetuCalc() { return new uCalc(GetuCalc_Overload_Item_(ItemHandle)); }
  


/// <summary> Returns the value (default double precision) associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Double precision value associated with a variable.</para></remarks>
public  double Value() { return Value_(ItemHandle); }
  


/// <summary> Returns the value (default double precision) associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Byte value associated with a variable.</para></remarks>
public  Byte ValueByte() { return ValueByte_(ItemHandle); }
  


/// <summary> Returns the 16-bit integer value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Int16 value associated with a variable.</para></remarks>
public  Int16 ValueInt16() { return ValueInt16_(ItemHandle); }
  


/// <summary> Returns the 32-bit integer value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Int32 value associated with a variable.</para></remarks>
public  Int32 ValueInt32() { return ValueInt32_(ItemHandle); }
  


/// <summary> Returns the 64-bit integer value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Int64 value associated with a variable.</para></remarks>
public  Int64 ValueInt64() { return ValueInt64_(ItemHandle); }
  


/// <summary> Returns the Double precision value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the Single precision value associated with a variable.</para></remarks>
public  float ValueSng() { return ValueSng_(ItemHandle); }
  


/// <summary> Returns the Double precision value associated with a uCalc.Item</summary>
/// <remarks><para>Synonymous with Value</para></remarks>
public  double ValueDbl() { return ValueDbl_(ItemHandle); }
  


/// <summary> Returns the String value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the String value associated with a variable.
/// </para><para>
/// ValueStr has a special property beyond the Value function for other data types in that it can return the value
/// of an item regardless of what data type it has.  The value is returned as a string.
/// </para></remarks>
public  string ValueStr() { return Marshal.PtrToStringAnsi(ValueStr_(ItemHandle)); } 
  


/// <summary> Returns the IntPtr value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the IntPtr value associated with a variable.
/// Note: If the uCalc.Item is a Variable of type IntPtr, then ValuePtr returns a IntPtr value
/// that is stored in that variable, whereas ValueAddr returns the IntPtr of the variable itself.  In other words
/// ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any value you may
/// have set as the address the variable points to.</para></remarks>
public  IntPtr ValuePtr() { return ValuePtr_(ItemHandle); }
  


/// <summary> Returns the IntPtr address of the value associated with a uCalc.Item</summary>
/// <remarks><para>Use this to retrieve the IntPtr address of the value associated with a variable (instead of
/// the value itself).  Note: If the uCalc.Item is a Variable of type IntPtr, then ValuePtr returns a IntPtr value
/// that is stored in that variable, whereas ValueAddr returns the IntPtr of the variable itself.  In other words
/// ValueAddr returns the address in memory of the current uCalc.Item value, while ValuePtr returns any given address
/// you may have stored as the value of the variable.</para></remarks>
public  IntPtr ValueAddr() { return ValueAddr_(ItemHandle); }
  


/// <summary> Returns the handle of the current uCalc.Item object</summary>
public IntPtr  Handle() { return Handle_Overload_Item_(ItemHandle); }
  
/// <summary> Releases an Item defined with Define or other related function</summary>
/// <remarks><para>When a function, operator, variable, or other item is defined with such functions as
/// Define, DefineFunction, DefineOperator, DefineVariable, these items remain in memory, until they are
/// released with this function.  Items should generally be released when they are no longer needed, in order
/// to preserve memory.
/// </para><para>
/// Note: A uCalc Item object must explicitely be released with Release unless the entire uCalc
/// object it is a part of is is released.  An Item object will not be released automatically when it
/// simply goes out of scope.
/// </para></remarks>
public void Release()  { ReleaseItem(); ItemHandle = default(IntPtr); }

public Item() { ItemHandle = default(IntPtr); }
public Item( IntPtr PassedItemHandle) { ItemHandle = PassedItemHandle; }
public Item( Item ItemHandleInstance) { ItemHandle = ItemHandleInstance.ItemHandle; }
}




/// <summary> Class for retrieving arguments passed to a callback, returning a value, and more</summary>
public class Callback {

/// <summary> Handle of the expression part the current callback instance is refering to</summary>
public IntPtr ExprPartHandle = default(IntPtr);



/// <summary> Returns the value of an argument passed to a uCalc.Callback function</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>When the name of a callback function is specified in DefineFunction or DefineOperator, that
/// callback function will receive arguments uCalc passes to it through the Arg.  Arg handles values
/// of the default Double floating point data type.  For other data types, ArgInt32, ArgStr, etc instead.
/// </para><para>
/// Note that Index is 1-based.  So if there are 3 arguments, the Index of the first will be
/// 1 (not 0), and the second and third will be 2 and 3 respectively.
/// </para><para>
/// If you are defining a binary operator, 1 is the index for the left operand, and 2 for the right operand.
/// For a unary operator, the index is 1.
/// </para></remarks>
public  double Arg( Int32 Index) { return Arg_(ExprPartHandle,Index); }
  


/// <summary> Returns the number of arguments being passed to a uCalc.Callback function</summary>
/// <returns> 0 if no arg is passed; or a positive integer representing the number of args being passed.</returns>
/// <remarks><para>This is useful for functions that have a variable number of arguments</para></remarks>
public  Int32 ArgCount() { return ArgCount_(ExprPartHandle); }
  


/// <summary> Returns an object instance of the argument being passed to a uCalc.Callback function</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <returns> The returned object can be used (where relevent) just like any other uCalc.Item</returns>
/// <remarks><para>Each argument is a uCalc.Item, just like anything else defined with Define.  With this object,
/// you can do such things as determine the argument&#39;s data type, determine which instance of uCalc
/// it belongs to, retrieve the IntPtr of the value of the argument, etc.</para></remarks>
public Item ArgObj( Int32 Index) { return new Item(ArgObj_(ExprPartHandle,Index)); }
  


/// <summary> Returns the address of the argument value that is being passed</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>In addition to Arg which returns arguments that are of the default Double floating point numeric type, there
/// are specialized functions for other datatypes such as ArgInt32, ArgInt64, etc.  However, if the argument is of
/// a data type that does not have a specialized function, you can retrieve the address of the argument value as
/// a IntPtr, and use that to retrieve the value.</para></remarks>
public  IntPtr ArgAddr( Int32 Index) { return ArgAddr_(ExprPartHandle,Index); }
  


/// <summary> Returns the object instance of the expression that&#39;s passed as an argument to a uCalc.Callback function+++Example</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <returns> Returns parsed expression object with which you can call functions like Evaluate or Execute</returns>
/// <remarks><para>uCalc allows you to not only pass arguments by value or by reference.  But it also lets you pass an argument
/// by expression.  When an expression is passed By Expression, the expresison is not evaluated before being passed.
/// Instead a handle to the parsed expression is passed, allowing the callback to perform the evaluation.</para></remarks>
public ParsedExpr ArgExpr( Int32 Index) { return new ParsedExpr(ArgExpr_(ExprPartHandle,Index)); }
  


/// <summary> Returns the Int32 integer argument passed to a uCalc.Callback function</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>If a function parameter (or operator operand) was explicitely defined as Int32, then the callback function can
/// recieve it through ArgInt32.  If the argument is of a different but compatible numeric type, a conversion takes
/// place first before being passed.</para></remarks>
public  Int32 ArgInt32( Int32 Index) { return ArgInt32_(ExprPartHandle,Index); }
  


/// <summary> Returns the Int64 integer argument being passed to a uCalc.Callback function</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>If a function parameter (or operator operand) was explicitely defined as Int64, then the callback function can
/// recieve it through ArgInt64.  If the argument is of a different but compatible numeric type, a conversion takes
/// place first before being passed.</para></remarks>
public  Int64 ArgInt64( Int32 Index) { return ArgInt64_(ExprPartHandle,Index); }
  


/// <summary> Returns a IntPtr value being passed as an argument to a uCalc.Callback function</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>If a function parameter (or operator operand) was explicitely defined as a IntPtr, then the callback function can
/// recieve it through ArgPtr.  Note that ArgPtr returns any address value that is being sent, whereas ArgAddr returns the
/// address of the value being passed.</para></remarks>
public  IntPtr ArgPtr( Int32 Index) { return ArgPtr_(ExprPartHandle,Index); }
  


/// <summary> Returns the value being passed as argument in to a uCalc.Callback function in form of a string</summary>
/// <param name="Index"> Index of the given argument.  Note that Index is 1-based; the Index for the first arg is 1 (not 0)</param>
/// <remarks><para>In addition to returning an argument that was passed as a string, ArgStr has the special property of returning an argument that
/// was passed as any data type.  If the argument was not a string, ArgStr converts it to a string before returning its value.</para></remarks>
public  string ArgStr( Int32 Index) { return Marshal.PtrToStringAnsi(ArgStr_(ExprPartHandle,Index)); } 
  


/// <summary> Sets the return value (default floating point) of a uCalc.Callback function</summary>
/// <param name="Value"> Floating point value that your callback returns</param>
/// <remarks><para>When you define a callback function with DefineFunction and you want to return a floating point number,
/// do it with Return.
/// </para><para>
/// Note: For compilers in which Return is a reserved keyword, use ReturnDbl instead.
/// </para></remarks>
public  void Return( double Value) {  Return_(ExprPartHandle,Value); }
  


/// <summary> Sets the return value of a uCalc.Callback function as an Int32 integer</summary>
/// <param name="Value"> Integer (32-bit) that your callback returns</param>
/// <remarks><para>When you define a callback function with DefineFunction and you want to return a Int32,
/// do it with ReturnInt32.</para></remarks>
public  void ReturnInt32( Int32 Value) {  ReturnInt32_(ExprPartHandle,Value); }
  


/// <summary> Sets the return value of a uCalc.Callback function as an Int64 integer</summary>
/// <param name="Value"> Integer (64-bit) that your callback returns</param>
/// <remarks><para>When you define a callback function with DefineFunction and you want to return a Int64,
/// do it with ReturnInt64.</para></remarks>
public  void ReturnInt64( Int64 Value) {  ReturnInt64_(ExprPartHandle,Value); }
  


/// <summary> Sets the return value of a uCalc.Callback function as a IntPtr</summary>
/// <param name="Value"> IntPtr value that your callback returns</param>
/// <remarks><para>When you define a callback function with DefineFunction that returns a IntPtr value,
/// do it with ReturnPtr.</para></remarks>
public  void ReturnPtr( IntPtr Value) {  ReturnPtr_(ExprPartHandle,Value); }
  


/// <summary> Sets the return value of a uCalc.Callback function as a String</summary>
/// <param name="Value"> String value that your callback returns</param>
/// <remarks><para>When you define a callback function with DefineFunction that returns a string,
/// do it with ReturnStr.</para></remarks>
public  void ReturnStr( string Value) {  ReturnStr_(ExprPartHandle,Value); }
  


/// <summary> Raises an error in a uCalc.Callback function</summary>
/// <param name="ErrNumber"> Index number of error to raise</param>
/// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
/// <remarks><para>Your callback can raise an error by calling this funciton with one of the values of the
/// ErrorNumberEnum enumerator.  End-user function definitions can also raise an error by calling Error().
/// The return value is determined by error handlers that you may have added.  ErrorAbort (value of 0)
/// is returned by default if there are no error handlers.</para></remarks>
public  Int32 ErrorRaise(ErrorNumberEnum ErrNumber) { return ErrorRaise_(ExprPartHandle,ErrNumber); }
  


/// <summary> Raises an error with a user-defined message in a uCalc.Callback function</summary>
/// <param name="ErrMessage"> Text of custom error message to return</param>
/// <returns> Returns ErrorAbort, ErrorResume, or ErrorReRaise.</returns>
/// <remarks><para>Your callback can raise a custom error message (one not listed as a ErrorNumberEnum enumerator)
/// by simply passing the text of the message to this function.</para></remarks>
public  Int32 ErrorRaiseMessage( string ErrMessage) { return ErrorRaiseMessage_(ExprPartHandle,ErrMessage); }
  


/// <summary> Returns the uCalc instance the current expression part belongs to</summary>
/// <remarks><para>A callback is designed to work with all instances of uCalc.  However, at times you may need to know
/// which particular instance of uCalc the expression part being passed belongs to.</para></remarks>
public uCalc  GetuCalc() { return new uCalc(GetuCalc_Overload_Callback_(ExprPartHandle)); }
  


/// <summary> Returns the handle of the sub expression passed to the callback</summary>
/// <remarks><para>This IntPtr value is the argument received by a callback function associated with a function or operator
/// defined with DefineFunction or DefineOperator.  Once a uCalc.Callback object is construct with this handle, this
/// handle typically no longer needs to be refered to directly.  However, it&#39;s still avaible should you need it.
/// uCalc interfaces with this handle underneath the hood of the uCalc.Callback object.
/// </para></remarks>
public IntPtr  Handle() { return Handle_Overload_Callback_(ExprPartHandle); }
  


/// <summary> Returns the function or operator Item of the current expression part</summary>
/// <remarks><para>If several functions and/or operators are mapped to the same callback function, you can use this to
/// let you determine which one is currently being called, based on properties you can check.</para></remarks>
public Item OpItem() { return new Item(OpItem_(ExprPartHandle)); }
  
public Callback() { ExprPartHandle = default(IntPtr); }
public Callback( IntPtr ExpressionHandle) { ExprPartHandle = ExpressionHandle; }
public Callback( Callback ExprInstance) { ExprPartHandle = ExprInstance.ExprPartHandle; }
}


/// <summary> Class for working with uCalc data types</summary>
public class DataType {

/// <summary> Handle for uCalc Data Type</summary>
public IntPtr DataTypeHandle = default(IntPtr);



/// <summary> Allocates an array of the given data type</summary>
/// <param name="ArraySize"> Size - in umber of elements - of the array you&#39;re allocating</param>
/// <returns> IntPtr of the array that was allocated</returns>
/// <remarks><para>This allocates an array of the given type.  Elements of the array are set to the default value
/// of that type.</para></remarks>
public  IntPtr AllocArray( Int32 ArraySize) { return AllocArray_(DataTypeHandle,ArraySize); }
  


/// <summary> Allocates a scalar of the given type and copies data from the area indicated by the IntPtr</summary>
/// <param name="ValuePtr"> IntPtr to the data that is copied to the scalar being defined</param>
/// <returns> IntPtr of the scalar that was allocated</returns>
public  IntPtr AllocByPtr( IntPtr ValuePtr) { return AllocByPtr_(DataTypeHandle,ValuePtr); }
  


/// <summary> Allocates a scalar of the given data type</summary>
/// <param name="Value"> Expression who&#39;s evaluated value will be copied to the allocated scalar</param>
/// <returns> IntPtr of the scalar that was allocated</returns>
public  IntPtr AllocScalar( string Value = "") { return AllocScalar_(DataTypeHandle,Value); }
  


/// <summary> Returns the size (in bytes) of one unit of data for this data type</summary>
public  Int32 ByteSize() { return ByteSize_(DataTypeHandle); }
  


/// <summary> Returns the index of the data type</summary>
/// <remarks><para>The return value is a BuiltInTypesEnum enumerator value that represents the data type of the
/// current object.  For instance, if the data type is a string, the return value would be Type_String.
/// </para></remarks>
public  BuiltInTypesEnum Index() { return Index_(DataTypeHandle); }
  


/// <summary> Returns the uCalc.Item handle of the data type</summary>
/// <remarks><para>Each data type object can also be represented as a uCalc object by using this return value.</para></remarks>
public Item GetItem() { return new Item(GetItem_(DataTypeHandle)); }
  


/// <summary> Returns the name of the data type</summary>
public string  Name() { return Marshal.PtrToStringAnsi(Name_Overload_DataType_(DataTypeHandle)); } 
  


/// <summary> Releases an array that was allocated with AllocArray</summary>
/// <param name="ValuePtr"> IntPtr of uCalc array to be released from memory</param>
/// <remarks><para>This should only be used for arrays that were explicitly allocated with uCalc&#39;s AllocArray.</para></remarks>
public  void ReleaseArray( IntPtr ValuePtr) {  ReleaseArray_(DataTypeHandle,ValuePtr); }
  


/// <summary> Releases a scalar that was allocated with AllocScalar</summary>
/// <param name="ValuePtr"> IntPtr of uCalc scalar to be released from memory</param>
/// <remarks><para>This should only be used for scalars that were explicitly allocated with uCalc&#39;s AllocScalar.</para></remarks>
public  void ReleaseScalar( IntPtr ValuePtr) {  ReleaseScalar_(DataTypeHandle,ValuePtr); }
  


/// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary>
/// <param name="ValuePtr"> IntPtr of the uCalc array to be reset</param>
/// <remarks><para>Resets all the elements of the array to the default value for the given data type.  This should only
/// be used for arrays that were explicitly allocated with uCalc&#39;s AllocArray.</para></remarks>
public  void ResetArray( IntPtr ValuePtr) {  ResetArray_(DataTypeHandle,ValuePtr); }
  


/// <summary> Resets the value of data that was allocated with SetScalar to the default value of the given data type</summary>
/// <param name="ValuePtr"> IntPtr of the uCalc scalar to be reset</param>
public  void ResetScalar( IntPtr ValuePtr) {  ResetScalar_(DataTypeHandle,ValuePtr); }
  


/// <summary> Sets the value of an array at a given memory location that was allocated by AllocArray</summary>
/// <param name="Destination"> IntPtr of array (base address) who&#39;s element value is to be set</param>
/// <param name="Source"> IntPtr to a value of the same data type that will be copied to the element</param>
/// <param name="Index"> Index of the array element who&#39;s value needs to be set</param>
public  void SetArray( IntPtr Destination ,  IntPtr Source ,  Int32 Index) {  SetArray_(DataTypeHandle,Destination , Source , Index); }
  


/// <summary> Sets the value of a scalar at a given memory location that was allocated by AllocScalar</summary>
/// <param name="Destination"> IntPtr of scalar who&#39;se value is to be set</param>
/// <param name="Source"> IntPtr to a value of the same data type that will be copied to the element</param>
public  void SetScalar( IntPtr Destination ,  IntPtr Source) {  SetScalar_(DataTypeHandle,Destination , Source); }
  


/// <summary> swaps the pointers of two variables that were allocated with AllocScalar or AllocArray</summary>
/// <param name="ValuePtrA"> IntPtr of variable 1</param>
/// <param name="ValuePtrB"> IntPtr of variable 2</param>
public  void SwapScalarValues( IntPtr ValuePtrA ,  IntPtr ValuePtrB) {  SwapScalarValues_(DataTypeHandle,ValuePtrA , ValuePtrB); }
  


/// <summary> Retuns a string representing the value at the given address formatted for the given data type</summary>
/// <param name="ValuePtr"> IntPtr of the data containing the value you want to display</param>
/// <remarks><para>If you have a IntPtr to data of the given type, you can display this data as a string with this function.  Special formatting
/// associated with a data type is used, if such formatting was defined.  For instance, if you&#39;re dealing with a bool, then
/// you might get: True, Yes, On, etc, depending on how the formatting was configured with SetOutput.</para></remarks>
public string  ToString( IntPtr ValuePtr) { return Marshal.PtrToStringAnsi(ToString_Overload_DataType__ByPtr_(DataTypeHandle,ValuePtr)); } 
  


/// <summary> Retuns a formatted string of the given data type representing the value that was passed as text</summary>
/// <param name="Value"> String representing data of any type that is to be represented as data of the given type</param>
/// <remarks><para>If you pass a string, it will be converted to the given data type, and return using the formatting
/// for that data type.</para></remarks>
public string  ToString( string Value) { return Marshal.PtrToStringAnsi(ToString_Overload_DataType__ByStr_(DataTypeHandle,Value)); } 
  


/// <summary> Returns the handle of the data type object</summary>
/// <remarks><para>Generally for internal use</para></remarks>
public IntPtr  Handle() { return Handle_Overload_DataType_(DataTypeHandle); }
public DataType() { DataTypeHandle = default(IntPtr); }
public DataType( IntPtr PassedDataTypeHandle) { DataTypeHandle = PassedDataTypeHandle; }
public DataType( DataType DataTypeHandleInstance) { DataTypeHandle = DataTypeHandleInstance.DataTypeHandle; }
}





/// <summary> uCalc transform class</summary>
public class uCalcTransform {

/// <summary> Handle for uCalc Transform instance</summary>
public IntPtr TransformHandle = default(IntPtr);

/// <summary> Class for rules</summary>
public class RuleClass {

/// <summary> Handle for RuleClass</summary>
public IntPtr RuleHandle = default(IntPtr);



/// <summary> Sets whether a rule is active</summary>
/// <param name="TrueFalse"> Value that determines case is active</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets whether a rule is active or not.
/// When you no longer need a rule, you can release it entirely from memory with Release().  However, at times you may
/// want to only temporarily deactivate a transform, and then later reactivate it for further use.  That is when you use
/// this function.
/// </para></remarks>
public RuleClass Active( bool TrueFalse) { return new RuleClass(Active_(RuleHandle,TrueFalse)); }
  


/// <summary> Sets Find part of a rule in a search</summary>
/// <param name="Pattern"> Pattern for the Find part of a rule</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the Find part of a rule in a search.
/// </para></remarks>
public RuleClass FindPart( string Pattern) { return new RuleClass(FindPart_(RuleHandle,Pattern)); }
  


/// <summary> Sets From part of a rule</summary>
/// <param name="Pattern"> Pattern for the From part of a rule</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the From part of a rule.
/// </para></remarks>
public RuleClass FromPart( string Pattern) { return new RuleClass(FromPart_(RuleHandle,Pattern)); }
  


/// <summary> Sets To part of a rule</summary>
/// <param name="Pattern"> Pattern for the From part of a rule</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the To part of a rule.
/// </para></remarks>
public RuleClass ToPart( string Pattern) { return new RuleClass(ToPart_(RuleHandle,Pattern)); }
  


/// <summary> Sets whether a rule is case-sensitive</summary>
/// <param name="TrueFalse"> Value that determines case sensitivity</param>
/// <returns> The current rule object</returns>
/// <remarks><para>This sets whether a rule is case-sensitive or not.
/// </para></remarks>
public RuleClass CaseSensitive( bool TrueFalse) { return new RuleClass(CaseSensitive_(RuleHandle,TrueFalse)); }
  


/// <summary> Sets whether a rule is whitespace-sensitive</summary>
/// <param name="TrueFalse"> Value that determines whitespace sensitivity</param>
/// <returns> The current rule object</returns>
/// <remarks><para>This sets whether a rule is whitespace-sensitive or not.
/// </para></remarks>
public RuleClass WhitespaceSensitive( bool TrueFalse) { return new RuleClass(WhitespaceSensitive_(RuleHandle,TrueFalse)); }
  


/// <summary> Sets code block sensitivity</summary>
/// <param name="TrueFalse"> Value that determines code block sensitivity</param>
/// <returns> The current rule object</returns>
/// <remarks><para>This sets whether a rule is code block sensitive or not.  When set to True, a pattern will not match if it crosses the boundaries of
/// a code block.
/// </para><para>
/// If set to False, then clode block delimiters are treated as ordinary generic tokens, with no special property as delimiters.
/// </para><para>
/// A code block [+++ for lack of better name] is a pattern enclosed between a starting token and an ending pattern.  Typically,
/// things like parenthesis, brackets, and curly braces are defined as such.
/// </para><para>
/// So, if you define a pattern &quot;a {etc} b&quot;, it will match &quot;a x y z b c&quot;, &quot;a (x y z) b c&quot;, &quot;a (x) (y z) b c&quot;, but not &quot;a x y z (b c)&quot;,
/// because the code block (b c) crosses the boundary of the &quot;a {etc} b&quot; pattern; the opening parenthesis is found in the would-be match,
/// but the closing parenthesis is beyond it, whereas in the other examples, the both opening and closing parenthesis (when present) are
/// fully within &quot;a {etc} b&quot;.
/// </para><para>
/// Note: You may use code block delimiter tokens in your patterns.
/// </para></remarks>
public RuleClass CodeBlockSensitive( bool TrueFalse) { return new RuleClass(CodeBlockSensitive_(RuleHandle,TrueFalse)); }
  


/// <summary> Associates a comment with a rule</summary>
/// <param name="CommentStr"> Text of the comment</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// Each rule can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system, or as a tool tip.
/// </para></remarks>
public RuleClass  Comment( string CommentStr) { return new RuleClass(Comment_Overload_uCalcTransform_RuleClass_(RuleHandle,CommentStr)); }
  


/// <summary> Returns a local transform object</summary>
/// <returns> Local transform object</returns>
/// <remarks><para>
/// When a pattern is matched, you can zoom into the text and perform a local search just within the matched text, independantly
/// from the rest of the text outside of the match.  Among various possible uses, it&#39;s ideal for parsing escape characters within quotes.
/// Such characters are treated differently within the quote than outside the quote.
/// </para></remarks>
public uCalcTransform LocalTransform() { return new uCalcTransform(LocalTransform_(RuleHandle)); }
  


/// <summary> Sets the soft maximum number of matches of this rule allowed</summary>
/// <param name="Value"> Maximum number of matches of this rule allowed</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the soft maximum number of individual matches that this rule should find in order for any matches
/// of this rule to count.  If more than this number of matches are found in the text, then none of the
/// matches in this rule will count.  For instance if a rule searches for matches of &quot;a&quot; in &quot;a a r d v a r k&quot;,
/// and the maximum is set to 2, then no matches of &quot;a&quot; will be counted at all, because there are more than
/// 2 occurences of &quot;a&quot; in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
/// all the matches would count.
/// </para><para>
/// The default Maximum value is -1, which is the equivalent of no maximum limit.
/// </para><para>
/// If you want to stop counting after a given number of matches of a rule, without invalidating the matches
/// that were already found, use StopAfter instead.
/// </para></remarks>
public RuleClass Maximum( Int32 Value) { return new RuleClass(Maximum_(RuleHandle,Value)); }
  


/// <summary> Sets the hard maximum number of matches of this rule allowed</summary>
/// <param name="Value"> Maximum number of matches of this rule allowed</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the maximum number of individual matches that this rule should find in order for any matches
/// of this rule to count.  If more than this number of matches are found in the text, then no matches from
/// any rule will count (whereas in a soft maximum, only matches from the current rule will be cancelled).
/// For instance if a rule searches for matches of &quot;a&quot; in &quot;a a r d v a r k&quot;,
/// and the maximum is set to 2, then no matches of &quot;a&quot; will be counted at all, because there are more than
/// 2 occurences of &quot;a&quot; in the text.  On the other hand, if Max is set to 3 or 4 or any larger value, then
/// all the matches would count.
/// </para><para>
/// The default Maximum value is -1, which is the equivalent of no maximum limit.
/// </para><para>
/// If you want to stop counting after a given number of matches of a rule, without invalidating the matches
/// that were already found, use StopAfter instead.
/// </para></remarks>
public RuleClass MaximumHard( Int32 Value) { return new RuleClass(MaximumHard_(RuleHandle,Value)); }
  


/// <summary> Sets the soft minimum number of matches that must be found in this rule</summary>
/// <param name="Value"> Minimum number of matches required of this rule</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the soft minimum number of individual matches that this rule should find.
/// </para><para>
/// A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
/// reached, then it is considered that there are no matches for this particular rule.  Other rules
/// are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
/// then the entire search or transform is invalidated, and it&#39;s considered that no match of any
/// kind is found.
/// </para><para>
/// If less than this number of matches are found in the text, then none of the
/// matches in this rule will count.  For instance if a rule searches for matches of &quot;a&quot; in &quot;a a r d v a r k&quot;,
/// and the minimum is set to 5, then no matches of &quot;a&quot; will be counted at all, because there are not at least
/// 5 occurences of &quot;a&quot; in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.
/// </para><para>
/// Default: 0.
/// </para></remarks>
public RuleClass Minimum( Int32 Value) { return new RuleClass(Minimum_(RuleHandle,Value)); }
  


/// <summary> Sets the soft minimum number of matches that must be found in this rule</summary>
/// <param name="Value"> Minimum number of matches required of this rule</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets the soft minimum number of individual matches that this rule should find.
/// </para><para>
/// A soft minum (this one) differs from a hard minum (MinimumHard) in that if the soft minimum is not
/// reached, then it is considered that there are no matches for this particular rule.  Other rules
/// are not affected.  Whereas in a hard minimum, if this rule does not reach the required minimum,
/// then the entire search or transform is invalidated, and it&#39;s considered that no match of any
/// kind is found.
/// </para><para>
/// If less than this number of matches are found in the text, then none of the
/// matches in this rule will count.  For instance if a rule searches for matches of &quot;a&quot; in &quot;a a r d v a r k&quot;,
/// and the minimum is set to 5, then no matches of &quot;a&quot; will be counted at all, because there are not at least
/// 5 occurences of &quot;a&quot; in the text.  On the other hand, if Min is set to 3 or less, then all the matches count.
/// </para><para>
/// Default: 0.
/// </para></remarks>
public RuleClass MinimumHard( Int32 Value) { return new RuleClass(MinimumHard_(RuleHandle,Value)); }
  


/// <summary> Sets the precedence level for a pattern</summary>
/// <param name="Value"> Number of matches after which it should stop finding matches</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// Patterns that start (and/or end) with a pattern variable instead of a token or identifier can
/// (and probably should) be assigned a precedence level.  You can choose any arbitrary numerical
/// value.  The meaning of the precedence level depends on whether the value is greater, equal, or
/// less than adjacent patterns with a precedence level.  It works similarly to precedence levels for
/// operators.  For instance, if you define:
/// </para><para>
/// FromTo(&quot;{a} + {b}&quot;, &quot;({a} + {b})&quot;).Precedence(10);
/// FromTo(&quot;{a} * {b}&quot;, &quot;({a} * {b})&quot;).Precedence(20);
/// </para><para>
/// Then
/// </para><para>
/// &quot;1 + 2 * 3 + 4&quot; Expands to &quot;(1 + (2 * 3) + 4)&quot;
/// &quot;1 * 2 + 3 * 4&quot; Expands to &quot;(1 * 2) + (3 * 4)&quot;
/// </para></remarks>
public RuleClass Precedence( Int32 Value) { return new RuleClass(Precedence_(RuleHandle,Value)); }
  


/// <summary> Sets quote sensitivity</summary>
/// <param name="TrueFalse"> Value that determines quote sensitivity</param>
/// <returns> The current rule object</returns>
/// <remarks><para>This sets whether a rule is quote sensitive or not.
/// Quote sensitivity is generally designed for use across all rules in a transform (or sub transform).  However,
/// it can also be set in for the context of an individual pattern.  [One exception is within text that matches a pattern variable.+++]
/// </para><para>
/// When set to true, it means that a block of text within quotes is treated as one token.  As such patterns are not searched for
/// within the quotes.  The contents of the quotes are skipped over.  You may still get around this and parse within quotes when
/// necessary, by capturing the quote character itself, then parsing subsequent text.
/// </para><para>
/// The actual character(s) used as quotes are configurable with DefineToken.
/// </para></remarks>
public RuleClass QuoteSensitive( bool TrueFalse) { return new RuleClass(QuoteSensitive_(RuleHandle,TrueFalse)); }
  


/// <summary> Returns the replacement text of a FromTo rule</summary>
/// <returns> String representing the second argument that was used in FromTo</returns>
/// <remarks><para>This allows you to keep track of the replacement text of any given rule, even after it has been defined.</para></remarks>
public  string ReplacementText() { return Marshal.PtrToStringAnsi(ReplacementText_(RuleHandle)); } 
  


/// <summary> Sets the number of matches this rule must find before matches start counting</summary>
/// <param name="Value"> Number of matches that must be found before matches start counting</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets a number of individual matches that this rule should find first.  These first few matches are
/// not counted in the results.  Onlny matches starting after this number of initial matches are counted.
/// If less than this number of matches are found in the text, no match will count.  For instance if a rule
/// searches for matches of &quot;a&quot; in &quot;a a r d v a r k&quot;, starting after 2, then only the 3rd &quot;a&quot; (the one between
/// &quot;v&quot; and &quot;r&quot;) will count.  If StartAfter is set to 3, there will be no matches.  If StartAfter is 1, then
/// then the 2nd and 3rd occurences of &quot;a&quot; will count as matches.
/// </para><para>
/// The default StartAfter value is 0.  This means all matches that are found will count.
/// </para></remarks>
public RuleClass StartAfter( Int32 Value) { return new RuleClass(StartAfter_(RuleHandle,Value)); }
  


/// <summary> Sets the number of matches after which this rule should stop finding matches</summary>
/// <param name="Value"> Number of matches after which it should stop finding matches</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// This sets a number of individual matches that this rule should find.  After this number of matches
/// are found, all other matches for this rule are ignored.  For instance if a rule searches for matches
/// of &quot;a&quot; in &quot;a a r d v a r k&quot;, and stops after 2, then only the first two letters here wil match; the
/// third &quot;a&quot; (the one between &quot;v&quot; and &quot;r&quot;) will not count as a match.
/// </para><para>
/// The default StopAfter value is -1, which means it will not stop counting matches for this rule.
/// </para><para>
/// This function has some similarities with Max.  However, with Max, if the maximum value is not attained,
/// none of the matches will count.
/// </para></remarks>
public RuleClass StopAfter( Int32 Value) { return new RuleClass(StopAfter_(RuleHandle,Value)); }
  


/// <summary> Determines whether a given match is skipped over</summary>
/// <param name="TrueFalse"> Value that determines with match is skipped over</param>
/// <returns> The current rule object</returns>
/// <remarks><para>If SkipOver is set to true, then text that matches this pattern will be skipped over.
/// This is useful for preventing uCalc from searching for matches of any other rules within
/// certain text you want to skip over.
/// </para><para>
/// For instance if you skip over &quot;({etc})&quot;, then everything in parenthesis will be skipped over.
/// So if you want to find occurences of &quot;a&quot; in &quot;a b c (a b c a b c) a b c&quot;, it will find all occurences
/// of &quot;a&quot;, except those within parenthesis, because everything in parenthesis is being skipped over.
/// </para><para>
/// Default: False
/// </para></remarks>
public RuleClass SkipOver( bool TrueFalse) { return new RuleClass(SkipOver_(RuleHandle,TrueFalse)); }
  


/// <summary> Determines whether to rewind back to the start of modified text for further parsing</summary>
/// <param name="TrueFalse"> Value that determines if parser should rewind and parse again after a change</param>
/// <returns> The current rule object</returns>
/// <remarks><para>After text is modified with the replacement text of a rule, if this value is false (default),
/// then uCalc will continue parsing from the position just after the insertion of the modified text.
/// If this property is set to true, then the parser will rewind to the location where the match was
/// found, and parse again, which will allow it to potentially find additional matches (of any rule,
/// not just the current one) within the already modified text.
/// </para><para>
/// This property can be extremely useful in many situations.  However, special care should be taken
/// so that an infinite reparsing session doesn&#39;t take place.  For instance, if a rule changes A to B,
/// and another rule changes B to A, and this property is set ot true, and a Maximum value is not set,
/// and there is an occurence of A, then A will change to B.  B will be parsed again and changed to A.
/// The cycle will repeat itself indefinitely.
/// </para><para>
/// Default: False
/// </para></remarks>
public RuleClass RewindOnChange( bool TrueFalse) { return new RuleClass(RewindOnChange_(RuleHandle,TrueFalse)); }
  


/// <summary> Sets the maximum number of times a rule will cause a reparse at a given location</summary>
/// <param name="TrueFalse"> Maximum number of times this rule can cause a re-parse</param>
/// <param name="RaiseError"> Raises an error if the maximum is reached</param>
/// <returns> The current rule object</returns>
/// <remarks><para>
/// [+++ Not completely thought out; might be removed]
/// When ParseAgain is set to true, there is the potential for an infinite reparsing to take place.
/// An obvious case is if a rule changes A to B, and another rule changes B to A.  However, there are
/// less obvious cases where text might be modified in several ways before ending up in an infinite loop.
/// </para><para>
/// This property allows uCalc to break out of the cycle after text has been reparsed at a given location
/// a certain number of times.
/// </para><para>
/// Once the maximum is passed, if RaiseError is set to true, an error indicating that the maximum was passed
/// will be raised.  Otherwise, parsing will then silently continue from the end location of the modified text,
/// as though ParseAgain were now false.
/// </para></remarks>
public RuleClass ParseAgainMax( bool TrueFalse ,  bool RaiseError) { return new RuleClass(ParseAgainMax_(RuleHandle,TrueFalse , RaiseError)); }
  


/// <summary> Sets whether a rule is case-sensitive</summary>
/// <param name="TrueFalse"> Value that determines case sensitivity</param>
/// <returns> The current rule object</returns>
/// <remarks><para>This sets whether a rule is case sensitive or not.
/// </para></remarks>
public RuleClass RightToLeft( bool TrueFalse) { return new RuleClass(RightToLeft_(RuleHandle,TrueFalse)); }
  


/// <summary> Releases a transform rule</summary>
/// <remarks><para>When a transform rule is no longer needed it can be released in order to conserve memnory.
/// </para></remarks>
public  void ReleaseRule() {  ReleaseRule_(RuleHandle); }
  
/// <summary> Releases a transform rule.  Transform rules are defined with FromTo.</summary>
/// <remarks><para>
/// This releases a transform rule from memory.
/// </para></remarks>
public void Release()  { ReleaseRule(); RuleHandle = default(IntPtr); }

public RuleClass() { RuleHandle = default(IntPtr); }
public RuleClass( IntPtr rHandle) { RuleHandle = rHandle; }
public RuleClass( RuleClass RuleInstance) { RuleHandle = RuleInstance.RuleHandle; }
}


/// <summary> Class for collection of tokens</summary>
public class Tokens {

/// <summary> Handle for tokens</summary>
public IntPtr TokensHandle = default(IntPtr);



/// <summary> Associates a comment with a token list</summary>
/// <param name="CommentStr"> Text of the comment</param>
/// <returns> Object containing list of tokens</returns>
/// <remarks><para>Each token list can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system.
/// </para></remarks>
public Tokens  Comment( string CommentStr) { return new Tokens(Comment_Overload_uCalcTransform_Tokens_(TokensHandle,CommentStr)); }
  


/// <summary> Imports tokens from another token list</summary>
/// <param name="FromTokenList"> Token list to import +++ BYREF OBJ Tokens</param>
/// <returns> Object containing list of tokens</returns>
/// <remarks><para>
/// Instead of defining a set of tokens each time, you may import a pre-existing token list.  This function imports from
/// another token list object.  To import from a file, use Import (File).
/// </para></remarks>
public Tokens  Import(IntPtr FromTokenList ) { return new Tokens(Import_Overload_uCalcTransform_Tokens__Obj_(TokensHandle,FromTokenList)); }
  


/// <summary> Imports tokens from a token file</summary>
/// <param name="TokenFile"> Token list file to import from</param>
/// <returns> Object containing list of tokens</returns>
/// <remarks><para>
/// Instead of defining a set of tokens each time, you may import a pre-existing token list.  This function imports from
/// a file.  To import from a token list object, use Import (Object).
/// </para></remarks>
public Tokens  Import( string TokenFile) { return new Tokens(Import_Overload_uCalcTransform_Tokens__File_(TokensHandle,TokenFile)); }
  


/// <summary> Defines a new token</summary>
/// <param name="TokenDef"> Token definition</param>
/// <param name="TokenType"> The type of token</param>
/// <param name="EndMatch"> End match in a pair such as closing parenthesis or bracket</param>
/// <param name="SubMatch"> Submatch</param>
/// <param name="RegExGrammar"> Type of RegEx grammar</param>
/// <returns> Token item object</returns>
/// <remarks><para>
/// uCalc comes with a default set of tokens.  These are general tokens for things like numbers alphanumeric words, whitespace, quotes,
/// parenthesis, etc.  However you may define your own tokens to the exact specifications that you need.
/// </para><para>
/// A token is defined using a Regular Expression.
/// </para><para>
/// A token type can be any of those listed under TokenEnum (except for None).
/// </para><para>
/// Some tokens, such as parenthesis, brackets, or curly braces are typically defined as pairs.  So if &quot;(&quot; is defined
/// as a token pair, then &quot;)&quot; would be the EndMatch.
/// </para><para>
/// In cases where you want a submatch within the token, and not the whole token, use the SubMatch argument with a numerical
/// value represent the numerical index used in the regular expression.
/// </para></remarks>
public Item  Define( string TokenDef ,TokenEnum TokenType = TokenEnum.Generic, string EndMatch = "", Int32 SubMatch  = 0,RegExGrammarEnum RegExGrammar = RegExGrammarEnum.RegEx_Default) { return new Item(Define_Overload_uCalcTransform_Tokens_(TokensHandle,TokenDef ,TokenType,EndMatch,SubMatch,RegExGrammar)); }
  

public Tokens() { TokensHandle = default(IntPtr); }
public Tokens( IntPtr tHandle) { TokensHandle = tHandle; }
public Tokens( Tokens TokensInstance) { TokensHandle = TokensInstance.TokensHandle; }
}




/// <summary> Associates a comment with a transform</summary>
/// <param name="CommentStr"> Text of the comment</param>
/// <returns> Transform object</returns>
/// <remarks><para>Each transform can be assigned a comment.  This comment can later be used at your discretion, for instance in a help file system.
/// </para></remarks>
public uCalcTransform  Comment( string CommentStr) { return new uCalcTransform(Comment_Overload_uCalcTransform_(TransformHandle,CommentStr)); }
  


/// <summary> Defines a rule (for search, transform, or filter)</summary>
/// <param name="Comment"> Documentation/help/comment/tooltip type info associated with the rule. See Comment.</param>
/// <param name="FindStr"> Pattern of text you want to match (The Find pattern in a search, or the From part in FromTo).</param>
/// <param name="ToStr"> Replacement string (text that the From part should be changed to)</param>
/// <param name="Min"> Soft minimum number of matches required.  See Min.</param>
/// <param name="Max"> Soft maximum number of matches allowed.  See Max.</param>
/// <param name="MinHard"> Hard minimum number of matches required. See MinHard</param>
/// <param name="MaxHard"> Hard maximum number of matches allowed.  See MaxHard</param>
/// <param name="Precedence"> Precedence level.  See Precedence.</param>
/// <param name="StartAfter"> Number of matches to skip before matches start counting. See StartAfter.</param>
/// <param name="StopAfter"> Number of matches to stop counting after.  See StopAfter.</param>
/// <param name="SkipOver"> Makes it skip over text that is a match.  See SkipOver.</param>
/// <param name="RewindOnChange"> Determines whether to rewind to the beginning of modified text and parse again</param>
/// <param name="CaseSensitive"> Case sensitivity.  See CaseSensitive.</param>
/// <param name="CodeblockSensitive"> Sets code block sensitivity.  See CodeblockSensitive.</param>
/// <param name="QuoteSensitive"> Sets quote sensitivity.  See QuoteSensitive.</param>
/// <param name="RightToLeft"> Right to left</param>
/// <returns> Rule object that has just been defined</returns>
/// <remarks><para>
/// Defines a rule that contains a pattern used for finding text, along with a replacement string, and all the other properties.
/// This function represents an alternative way of defining a rule, by supplying all the properties in this one function call.  These
/// same properties can be called individually with separate functions.  Additional details for each property can be found in separate
/// topics for function calls related to each property.
/// </para><para>
/// </para></remarks>
public RuleClass DefineRule( string Comment ,  string FindStr ,  string ToStr ,  Int32 Min ,  Int32 Max ,  Int32 MinHard ,  Int32 MaxHard ,  Int32 Precedence ,  Int32 StartAfter ,  Int32 StopAfter ,  bool SkipOver ,  bool RewindOnChange ,  bool CaseSensitive ,  bool CodeblockSensitive ,  bool QuoteSensitive ,  bool RightToLeft) { return new RuleClass(DefineRule_(TransformHandle,Comment , FindStr , ToStr , Min , Max , MinHard , MaxHard , Precedence , StartAfter , StopAfter , SkipOver , RewindOnChange , CaseSensitive , CodeblockSensitive , QuoteSensitive , RightToLeft)); }
  


/// <summary> Defines a new token</summary>
/// <param name="TokenDef"> Token definition</param>
/// <param name="TokenType"> The type of token</param>
/// <param name="EndMatch"> End match in a pair such as closing parenthesis or bracket</param>
/// <param name="SubMatch"> Submatch</param>
/// <param name="RegExGrammar"> Type of RegEx grammar</param>
/// <returns> Token item</returns>
/// <remarks><para>
/// For details see Define (uCalcTransform)
/// </para></remarks>
public Item DefineToken( string TokenDef ,TokenEnum TokenType = TokenEnum.Generic, string EndMatch = "", Int32 SubMatch  = 0,RegExGrammarEnum RegExGrammar = RegExGrammarEnum.RegEx_Default) { return new Item(DefineToken_(TransformHandle,TokenDef ,TokenType,EndMatch,SubMatch,RegExGrammar)); }
  


/// <summary> Returns the Tokens object for the current transform</summary>
/// <returns> Token list object</returns>
/// <remarks><para>
/// Returns the Tokens object, which consists of a list of tokens for the current transform.
/// You can use this to add, modify, delete, or reset the tokens.
/// </para></remarks>
public Tokens GetTokens() { return new Tokens(GetTokens_(TransformHandle)); }
  


/// <summary> Defines a transform rule</summary>
/// <param name="FromStr"> Pattern that describes the text to match</param>
/// <param name="ToStr"> New text that the match should be changed to</param>
/// <returns> Object for rule being defined</returns>
/// <remarks><para>Whenever a piece of text matches the pattern described in FromStr, it is replaced with the text
/// found in ToStr.
/// </para></remarks>
public RuleClass FromTo( string FromStr , string ToStr = "") { return new RuleClass(FromTo_(TransformHandle,FromStr ,ToStr)); }
  


/// <summary> Imports a transform from a file</summary>
/// <param name="FileName"> Name of file containing transform to import</param>
/// <returns> Transform object</returns>
/// <remarks><para>
/// This imports a transfrom from a file.  It can be a text file, in XML, uc, or ... format.
/// </para></remarks>
public uCalcTransform  Import( string FileName) { return new uCalcTransform(Import_Overload_uCalcTransform_(TransformHandle,FileName)); }
  


/// <summary> Sets the prefix that is inserted at the start of lists</summary>
/// <param name="Prefix"> Prefix that will be inserted at the start of a list</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
/// within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
/// </para></remarks>
public uCalcTransform ListPrefix( string Prefix) { return new uCalcTransform(ListPrefix_(TransformHandle,Prefix)); }
  


/// <summary> Sets the postfix that is inserted at the end of lists</summary>
/// <param name="Postfix"> Postfix that will be inserted at the end of a list</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
/// within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
/// </para></remarks>
public uCalcTransform ListPostfix( string Postfix) { return new uCalcTransform(ListPostfix_(TransformHandle,Postfix)); }
  


/// <summary> Sets the separator that will delimite the elements of a list</summary>
/// <param name="Separator"> Separator that will delimite each element of a list</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
/// within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
/// </para></remarks>
public uCalcTransform ListSeparator( string Separator) { return new uCalcTransform(ListSeparator_(TransformHandle,Separator)); }
  


/// <summary> Sets the separator that will delimite the elements of a list</summary>
/// <param name="Prefix"> Prefix that will be inserted at the start of a list</param>
/// <param name="Separator"> Separator that will delimite each element of a list</param>
/// <param name="Postfix"> Postfix that will be inserted at the end of a list</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// Text that is returned as a list can have a prefix, postfix, and separators between elements.  A list of items
/// within curly braces might have an open curly brace as prefix, a comma as delimiter, and a closing curly brace as postfix.
/// </para></remarks>
public uCalcTransform ListDelimiters( string Prefix ,  string Separator ,  string Postfix) { return new uCalcTransform(ListDelimiters_(TransformHandle,Prefix , Separator , Postfix)); }
  


/// <summary> Sets and/or returns handle of math parser object that performs calculations related to the transform</summary>
/// <param name="FMP"> Handle of a uCalc Fast Math Parser object // +++ use obj</param>
/// <returns> Math parser object associated with current transform</returns>
/// <remarks><para>If your transform inovlves calcuations, then they will be performed using the
/// uCalc Fast Math Parser object set with this function, or a default math parser
/// object if this function is not called.  Each math parser can have its own sets of
/// variables, functions, and other definitions.
/// </para><para>
/// If you pass the handle to an existing math parser, then that one will be used.  If nothing is passed to
/// the function, then this function will merely return the existing math parser object.
/// </para></remarks>
public uCalc MathParser(IntPtr FMP  = default(IntPtr)) { return new uCalc(MathParser_(TransformHandle,FMP)); }
  


/// <summary> Returns a new Pass object</summary>
/// <param name="Share"> Share</param>
/// <returns> Transform object</returns>
/// <remarks><para>
/// It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  The transform
/// of each pass is executed in sequential order.  Passes can later be referenced later by index.  Calling NewPass the first
/// time returns the same as Pass(0), the next call to NewPass refers to Pass(1), etc.
/// </para></remarks>
public uCalcTransform NewPass( bool Share = false) { return new uCalcTransform(NewPass_(TransformHandle,Share)); }
  


/// <summary> Returns a new Pass object</summary>
/// <param name="Index"> Index of pass to select</param>
/// <param name="Share"> Share</param>
/// <returns> Transform object</returns>
/// <remarks><para>
/// It is possible to create a transform with multiple passes.  Each pass can have a different set of rules.  Each pass
/// is transformed in sequential order, starting with Pass(0).  A pass consists of a transform.
/// </para></remarks>
public uCalcTransform Pass( Int32 Index , bool Share = false) { return new uCalcTransform(Pass_(TransformHandle,Index ,Share)); }
  


/// <summary> Resets the transform object</summary>
/// <param name="ResetOption"> Reset option</param>
/// <returns> Current transform object</returns>
/// <remarks><para>This clears the input string, transform rules, token definitions, Results.  It also resets properties to default settings
/// </para></remarks>
public uCalcTransform Reset(TransformResetEnum ResetOption = TransformResetEnum.Reset_All) { return new uCalcTransform(Reset_(TransformHandle,ResetOption)); }
  


/// <summary> Returns string result of transformed text</summary>
/// <returns> String result of transformed text</returns>
/// <remarks><para>After performing a text transformation, you may obtain the transformed result with this
/// function
/// </para></remarks>
public  string ResultStr() { return Marshal.PtrToStringAnsi(ResultStr_(TransformHandle)); } 
  


/// <summary> Performs the transformation of text</summary>
/// <returns> The current transform object</returns>
/// <remarks><para>Once all the rules and parameters are set, you can call this function in order to
/// perform the text transformation.
/// </para><para>
/// Prior to calling Transform, you must set the text to be transformed, with SetInput or SetInputByRef
/// </para></remarks>
public uCalcTransform Transform() { return new uCalcTransform(Transform_(TransformHandle)); }
  


/// <summary> Transforms an expression in one quick step</summary>
/// <param name="Expression"> Expression to be expanded</param>
/// <returns> String result of transform</returns>
/// <remarks><para>
/// [+++ Maybe rename Expand to something like Transform[string]]
/// When you would like to set text to be transformed, and transform the text, and return a result, all in one step,
/// you can use this function, instead of calling SetInput, then Transform, then ResultStr.
/// </para></remarks>
public  string Expand( string Expression) { return Marshal.PtrToStringAnsi(Expand_(TransformHandle,Expression)); } 
  


/// <summary> Returns each step leading to an expression expansion</summary>
/// <param name="Expression"> Expression to be expanded +++ See Expand_</param>
/// <param name="Separator"> Separator used between steps</param>
/// <param name="Prefix"> Prefix</param>
/// <param name="Postfix"> Postfix</param>
/// <returns> String containg steps leading up to transform result</returns>
/// <remarks><para>
/// Transforms an expression and shows intermediate steps
/// </para></remarks>
public  string ExpandWithSteps( string Expression , string Separator = "", string Prefix = "", string Postfix = "") { return Marshal.PtrToStringAnsi(ExpandWithSteps_(TransformHandle,Expression ,Separator,Prefix,Postfix)); } 
  


/// <summary> Sets the text input that is to be transformed</summary>
/// <param name="InputStr"> Text that mast be parsed and modified</param>
/// <returns> Current transform object</returns>
/// <remarks><para>The text that you want to transform should be passed to this function.
/// </para></remarks>
public uCalcTransform SetInput( string InputStr) { return new uCalcTransform(SetInput_(TransformHandle,InputStr)); }
  


/// <summary> Sets the string variable containing text that is to be transformed or searched through</summary>
/// <param name="InputStr"> Variable containing text thta must be parsed and modified</param>
/// <returns> Current transform object</returns>
/// <remarks><para>The text that you want to transform or search through should be passed to this function.
/// This function is similar to Input, except that instead of copying a string, this passes a
/// string variable by reference.  This is more speed and memory efficient when dealing with large
/// amounts of text and/or situations where text is being parsed repeatedly.
/// </para></remarks>
public uCalcTransform SetInputByRef(IntPtr InputStr ) { return new uCalcTransform(SetInputByRef_(TransformHandle,InputStr)); }
  


/// <summary> Sets the math parser object by handle</summary>
/// <param name="FMP"> Handle of uCalc object +++ BYREF OBJ uCalc FMP</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// This sets the math parser object that is used when expression evaluations are involved in transforming text.
/// For instance when {@Eval: ...} is used in the pattern or ~Eval() in the text.
/// </para></remarks>
public uCalcTransform SetParser(IntPtr FMP ) { return new uCalcTransform(SetParser_(TransformHandle,FMP)); }
  


/// <summary> Sets properties for a transform</summary>
/// <param name="TransformProperties"> Properties for transforms</param>
/// <returns> Current transform object</returns>
/// <remarks><para>
/// This sets the properties for a transform.  A transform can keep track of each change, which can
/// </para><para>
/// These properties are all off by default, as they add a small speed
/// penalty and take up memory to store each change, depending on the option.
/// </para><para>
/// To set multiple properties, add them up, or use the OR operator (|| in some programming languages).
/// </para></remarks>
public uCalcTransform SetProperties(TransformPropertiesEnum TransformProperties = TransformPropertiesEnum.NoTransformProperties) { return new uCalcTransform(SetProperties_(TransformHandle,TransformProperties)); }
  


/// <summary> Indicates whether text was modified in the most recent Transform operation</summary>
/// <returns> True if text was modified in the most recent transformation operation or false otherwise</returns>
/// <remarks><para>
/// If text was modified after a call to Transform, then this function returns True.  When transforming large amounts of text,
/// transferring strings back and forth with ReturnStr() can be expensive.  Checking this property allows you to skip unnecessary
/// steps when text has not been modified.
/// </para></remarks>
public  bool WasModified() { return WasModified_(TransformHandle) != 0; }
  


/// <summary> Releases a transform</summary>
/// <remarks><para>When a transform is no longer needed it can be released in order to conserve memnory.
/// </para></remarks>
public  void ReleaseTransform() {  ReleaseTransform_(TransformHandle); }
  


/// <summary> Returns a rule object from a transform</summary>
/// <param name="Index"> Index of rule</param>
/// <returns> Rule object</returns>
/// <remarks><para>
/// The default rule is located at index -1.  All subsequent rules inherent properties from the default rule.
/// </para><para>
/// If no argument is passed, then RuleClass returns the next empty new rule in the list.
/// </para></remarks>
public RuleClass GetRule( Int32 Index  = 0) { return new RuleClass(GetRule_(TransformHandle,Index)); }
  


/// <summary> Returns the defaults settings for rules</summary>
/// <returns> Default rule object</returns>
/// <remarks><para>
/// Each FromTo or Find rule has many configurable properties that can be set.  Instead of excplicitely setting all of these many properties
/// with each rule definition, you may define default settings that will automatically be assigned to new rules.  Any of these default settings
/// can be overridden by explicitely setting the desired property for a given rule.
/// </para></remarks>
public RuleClass RulesDefault() { return new RuleClass(RulesDefault_(TransformHandle)); }
  


/// <summary> Returns the overall settings for a transform</summary>
/// <returns> Overall rule object</returns>
/// <remarks><para>
/// This returns an object containing the properties for a transform or search object.  This object is a Rules object, and conatains the
/// same properties listed for individual rules, but works in a slightly different context.  For instance, if you set the StopAfter property
/// of FromTo(&quot;a&quot;, &quot;b&quot;) to 5, then it will only change the first five occurences of &quot;a&quot; to &quot;b&quot;, whereas if you set the RulesOverall StopAfter
/// property to 5, and you have rules FromTo(&quot;a&quot;, &quot;b&quot;) and FromTo(&quot;x&quot;, &quot;y&quot;) then it will stop changing any occurence of either rule, after the
/// combined total of changes reaches 5; &quot;a&quot; might change to &quot;b&quot; 2 times and &quot;x&quot; to &quot;y&quot; 3 times, or whichever combination does not total more
/// than 5.  You might set QuoteSensitive to &quot;true&quot; overall, while you may set it to false within a given rule.  In certain combinations,
/// overall rules may clash with individual rules.  Although all combinations are allowed, not all combinations make sense.  When setting
/// the case sensitivity property of individual rules differently from the overall property, keep in mind that if the overall case sensitivity
/// is false, then all symbols are stored in the symbol table in all upper case.
/// </para></remarks>
public RuleClass RulesOverall() { return new RuleClass(RulesOverall_(TransformHandle)); }
  
/// <summary> Releases a transform</summary>
/// <remarks><para>
/// This releases a transform from memory.
/// </para></remarks>
public void Release()  { ReleaseTransform(); TransformHandle = default(IntPtr); }

public uCalcTransform() {  }
public uCalcTransform( IntPtr tHandle) { TransformHandle = tHandle; }
public uCalcTransform( uCalcTransform TransformInstance) { TransformHandle = TransformInstance.TransformHandle; }
} 







/// <summary> Adds an error handler</summary>
/// <param name="ErrorHandlerAddress"> Address of the callback function containing the error handler code</param>
/// <param name="Position"> Position in which to insert the error handler</param>
/// <returns> The error handler can later be removed using this return object</returns>
/// <remarks><para>Use this to set a a callback function that is called whenever there is an error.  Your callback can
/// do things like alert the user of the error, correct the error and resume, keep a log of errors, etc.
/// </para><para>
/// By default, if there are multiple error handlers, they are called starting with the most recently
/// defined one first, ending with the first one to be defined last.  In order to define a handler in a different
/// order, specify the Position value of where it should be inserted; 0 so that it is called first, -1 so it
/// is called last, or a positive integer indicated where it should be inserted.  If the Postion value is out
/// of bounds, it is adjusted into the maximum acceptable value.
/// </para><para>
/// If you set ErrorResponse to ErrorHandlerResponseEnum.ErrorResume, subsequent error handler callbacks will
/// be bypassed and uCalc will resume operations as though no error had taken place.  Note that the condition
/// that caused the error must be corrected before resuming, otherwise uCalc may get stuck in an infinite loop.
/// </para><para>
/// Some functions, such as ErrorExpression, ErrorLocation, and ErrorSymbol produce a meaningful result only
/// during the parsing stage.  They do not cause other problems beyond meaningless data during the evaluation stage.
/// </para><para>
/// For Floating Point Environment errors, such as: Err_Float_Division_By_Zero, Err_Float_Inexact_Result,
/// Err_Float_Invalid_Operation, Err_Float_Overflow, and Err_Float_Underflow, the uCalc error handler callbacks
/// are called only if the corresponding environment bits are not masked.
/// </para><para>
/// </para></remarks>
public Item AddErrorHandler(uCalcDelegate ErrorHandlerAddress , Int32 Position  = 0) { return new Item(AddErrorHandler_(uCalcHandle,ErrorHandlerAddress ,Position)); }
  


/// <summary> Creates a new uCalc instance</summary>
/// <remarks><para>This is not meant to be called directly.</para></remarks>
public  IntPtr CreateuCalc() { return CreateuCalc_(uCalcHandle); }
  


/// <summary> Returns a data type object</summary>
/// <param name="Index"> Index associated with the data type</param>
/// <remarks><para>Each instance of uCalc has its own separate handle &amp; data type object for any given data type.  For
/// instance, GetItemOf(&quot;Int64&quot;) in one instance of uCalc does not share the same handle as GetItemOf(&quot;Int64&quot;) in
/// another instance.  This allows the same data type to have a different name and different formatting in
/// different instances.  However, they share the same data type index across instances.  Given the index
/// of a data type, you can directly obtain the proper data type object for a particular uCalc instance,
/// faster than obtaining it by name as text with GetItemOf.</para></remarks>
public DataType DataTypeOfIndex(BuiltInTypesEnum Index) { return new DataType(DataTypeOfIndex_(uCalcHandle,Index)); }
  


/// <summary> Defines a uCalc.Item object (a constunction, function, operator, variable, etc)</summary>
/// <param name="Expression"> Text containing item to be defined.  Expression must start with a keyword such as Function, Operator, Variable, Token, Syntax, etc., followed by a colon, before the expression</param>
/// <param name="Address"> Address a function or variable is attached to</param>
/// <param name="ExistingItem"> Handle of existing item this definition is associated with</param>
/// <remarks><para>Functions, operators, variables, constants, tokens, syntax constructs, etc., can be defined with
/// this method.  Although there are specialized methods that do the same things, such as DefineFunction,
/// DefineOperator, DefineVariable, and DefineConstant, this method may in same cases offer
/// more flexibility.
/// </para><para>
/// The expression must be preceded by a keyword and colon, such as &quot;Variable:&quot;.  For a full list of keywords,
/// see Definition Keywords.
/// </para><para>
/// Sections are separated by ~~ (two tilda signs).
/// </para></remarks>
public Item  Define( string Expression ,IntPtr Address  = default(IntPtr),IntPtr ExistingItem  = default(IntPtr)) { return new Item(Define_Overload_uCalc_(uCalcHandle,Expression ,Address,ExistingItem)); }
  


/// <summary> Defines a constant</summary>
/// <param name="Definition"> Text containing constant to be defined</param>
/// <param name="VariableAddress"> Address the constant is attached to</param>
/// <remarks><para>
/// A constant definition is similar to that of a variable defined with DefineVariable, except that the end-user is not allowed to modify the value of a constant.
/// You are, however, allowed to perform lower-level operations such as renaming a constant, or deleting it and re-defining a new constant or variable with the same
/// name but different value.  If you attach the constant to the address of a variable in your host program, the host program may change the value.  However, when
/// the end-user attempts to assign a value to the constant, an error is raised.
/// </para><para>
/// DefineConstant(&quot;x&quot;) is the same as: Define(&quot;Lock ~~ Variable: x&quot;)
/// </para></remarks>
public Item DefineConstant( string Definition ,IntPtr VariableAddress  = default(IntPtr)) { return new Item(DefineConstant_(uCalcHandle,Definition ,VariableAddress)); }
  


/// <summary> Defines a data type</summary>
/// <param name="TypeSize"> Number of bytes 1 scalar value of this type takes</param>
/// <param name="AllocArrayValue"> Address of a function that will allocate an array of this type</param>
/// <param name="AllocScalar"> Address of a function that will allocate a scalar of this type.  If a string is passed, this function must convert it to this type and store the value, otherwise the function must store a default value for this type.</param>
/// <param name="AllocScalarByPtr"> Address of a function that takes a IntPtr to a value of this type, allocates a scalar and stores the copied value in the allocated space.</param>
/// <param name="DeleteArray"> Address of a function that frees a memory block that was allocated with AllocValueArray</param>
/// <param name="DeleteScalar"> Address of a function that frees a memory block that was allocated by AllocScalar or AllocScalarByPtr.</param>
/// <param name="ResetScalar"> Address of a function that resets an allocated scalar back to the default value of this type.</param>
/// <param name="ResetArray"> Address of a function that resets array elements back to the default value of this type.</param>
/// <param name="SetValueArray"> Address of a function that stores an array element value.</param>
/// <param name="SetValueScalar"> Address of a function that stores a scalar value.</param>
/// <param name="SwapValues"> Address of a function that swaps two values of this type.</param>
/// <param name="ToString"> Address of a function that converts this data type to a string.</param>
/// <remarks><para>
/// This allows you to define a data type that functions at the same level as the intrinsic types that come with uCalc.
/// </para></remarks>
public Item DefineDataType( Int32 TypeSize , IntPtr AllocArrayValue  , IntPtr AllocScalar  , IntPtr AllocScalarByPtr  , IntPtr DeleteArray  , IntPtr DeleteScalar  , IntPtr ResetScalar  , IntPtr ResetArray  , IntPtr SetValueArray  , IntPtr SetValueScalar  , IntPtr SwapValues  , IntPtr ToString ) { return new Item(DefineDataType_(uCalcHandle,TypeSize , AllocArrayValue , AllocScalar , AllocScalarByPtr , DeleteArray , DeleteScalar , ResetScalar , ResetArray , SetValueArray , SetValueScalar , SwapValues , ToString)); }
  


/// <summary> Defines a function</summary>
/// <param name="Definition"> Text containing function to be defined</param>
/// <param name="FunctionAddress"> Address of callback function this function is attached to</param>
/// <remarks><para>
/// A function definition can either be self-contained, or it may be attached to the address of a callback function in your
/// source code.
/// </para><para>
/// DefineFunction(&quot;f(x) = ...&quot;) is the same as: Define(&quot;Function: ...&quot;)
/// </para></remarks>
public Item DefineFunction( string Definition ,uCalcDelegate FunctionAddress = null) { return new Item(DefineFunction_(uCalcHandle,Definition ,FunctionAddress)); }
  


/// <summary> Defines an operator</summary>
/// <param name="Definition"> Text containing operator to be defined</param>
/// <param name="iPrecedence"> Precedence level of the operator.</param>
/// <param name="Grouping"> Operator associativity; arithmetic operators are typically grouped left-to-right; special operators, such as the equal sign, =, assignment operator are right-to-left</param>
/// <param name="FunctionAddress"> Address of callback function this operator is attached to</param>
/// <remarks><para>
/// Many details for defining an operator are similar to those of defining a function.  In additionn, all operators must be
/// defined with a precedence level.  You may use the Precedence function to obtain precedence levels of existing operators,
/// and select a precedence level in comparison to those operators.  By default operators are grouped left to right.  But you
/// may also set it to right to left.  This means that when adjacent operators have the same precedence level, the operands on
/// the right will be evaluated first.
/// </para><para>
/// DefineOperator(&quot;...&quot;) is the same as: Define(&quot;Operator: ...&quot;)
/// More later+++
/// </para></remarks>
public Item DefineOperator( string Definition ,  Int32 iPrecedence ,GroupingEnum Grouping = GroupingEnum.GroupLeftToRight,uCalcDelegate FunctionAddress = null) { return new Item(DefineOperator_(uCalcHandle,Definition , iPrecedence ,Grouping,FunctionAddress)); }
  


/// <summary> Defines a variable</summary>
/// <param name="Definition"> Text containing variable to be defined</param>
/// <param name="VariableAddress"> Address of variable in host program this uCalc variable is attached to</param>
/// <remarks><para>
/// A variable consists of ...
/// </para><para>
/// DefineVariable(&quot;...&quot;) is the same as: Define(&quot;Variable: x&quot;)
/// </para></remarks>
public Item DefineVariable( string Definition ,IntPtr VariableAddress  = default(IntPtr)) { return new Item(DefineVariable_(uCalcHandle,Definition ,VariableAddress)); }
  


/// <summary> Returns the expression associated with an error that was raised</summary>
public  string ErrorExpression() { return Marshal.PtrToStringAnsi(ErrorExpression_(uCalcHandle)); } 
  


/// <summary> Returns the location of an error that was raised</summary>
public  Int32 ErrorLocation() { return ErrorLocation_(uCalcHandle); }
  


/// <summary> Returns a message associated with the error that was raised</summary>
/// <param name="Index"> Index of error message to return</param>
/// <remarks><para>If an error was raised, this returns a message describing the recent error.  If the Index argument is specified,
/// then the error message associated with this Index is returned.  A value must be chosen from ErrorNumberEnum.
/// </para><para>
/// Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
/// </para></remarks>
public  string ErrorMessage(ErrorNumberEnum Index = ErrorNumberEnum.Err_None) { return Marshal.PtrToStringAnsi(ErrorMessage_(uCalcHandle,Index)); } 
  


/// <summary> Returns the error number of the error that was raised</summary>
/// <remarks><para>
/// Returns the error number of the most recently raised error.
/// </para><para>
/// Note: Errors are cleared whenever a new expression is parsed or a new item is defined.
/// </para></remarks>
public  ErrorNumberEnum ErrorNumber() { return ErrorNumber_(uCalcHandle); }
  


/// <summary> Sets the error response for an error handler</summary>
/// <param name="Response"> Indicates what should happen now that an error is raised</param>
/// <remarks><para>When an error is raised, you have the option of aborting the rest of the option (which is the default option),
/// or you may correct the problem, and then resume the operation.  Or you may perform an action, and than raise the
/// error again for a subsequent error handle to take care of.
/// </para><para>
/// This method can only be called from within a callback of an error handler routine definined with AddErrorHandler.
/// The options to use can be found at ErrorHandlerResponseEnum.
/// </para></remarks>
public  void ErrorResponse(ErrorHandlerResponseEnum Response) {  ErrorResponse_(uCalcHandle,Response); }
  


/// <summary> Returns the symbol associated with the error that is raised</summary>
public  string ErrorSymbol() { return Marshal.PtrToStringAnsi(ErrorSymbol_(uCalcHandle)); } 
  


/// <summary> Sets a new expression after an error is raised</summary>
/// <param name="Expression"> Error expression</param>
public  void ErrorSetExpression( string Expression) {  ErrorSetExpression_(uCalcHandle,Expression); }
  


/// <summary> Parses and evaluates an expression in one step</summary>
/// <param name="Expression"> Expression to be evaluated</param>
/// <remarks><para>This takes a math expression and returns a numeric result.</para></remarks>
public  double Eval( string Expression) { return Eval_(uCalcHandle,Expression); }
  


/// <summary> Parses and evaluates an expression of any data type in one step, returning the result as a string</summary>
/// <param name="Expression"> Expression to be evaluated</param>
/// <remarks><para>This is similar to Eval, however, it can return non-numeric results, such as strings.</para></remarks>
public  string EvalStr( string Expression) { return Marshal.PtrToStringAnsi(EvalStr_(uCalcHandle,Expression)); } 
  


/// <summary> Clears floating point exception(s) that were raised</summary>
/// <param name="Exceptions"> Exceptions</param>
public  Int32 FPEnvClearException( Int32 Exceptions  = 0) { return FPEnvClearException_(uCalcHandle,Exceptions); }
  


/// <summary> Returns the floating point environment error mask</summary>
public  Int32 FPEnvGetExceptionMask() { return FPEnvGetExceptionMask_(uCalcHandle); }
  


/// <summary> Raises a floating point exception in a uCalc.Callback function</summary>
/// <param name="Exception"> Bitmask value consisting of one or more exception flags to raise</param>
/// <returns> Returns a 0 if all the specified execptions were raised successfully, otherwise a non-zero value is returned.</returns>
/// <remarks><para>This attempts to raise the exception(s) specfied by the Exception parameter.  This is based on the C++
/// feraiseexcept() function.  If you are using C++, you may use the pre-defined macro values of 8 ,
/// 1 , 16 , 4 , 2 , 31 .  If you are using another compiler, you may
/// use the matching members of the FPEnvExceptionEnum enumerator.
/// </para></remarks>
public  Int32 FPEnvRaiseException(FPEnvExceptionEnum Exception = FPEnvExceptionEnum.Invalid) { return FPEnvRaiseException_(uCalcHandle,Exception); }
  


/// <summary> Gets the current floating point environment rounding option</summary>
public  FPEnvRoundingEnum FPEnvGetRounding() { return FPEnvGetRounding_(uCalcHandle); }
  


/// <summary> Sets the current floating point environment mask</summary>
/// <param name="Exceptions"> Exceptions (FPEnvExceptionEnum)</param>
/// <remarks><para>
/// The floating point environment can be set to a value from FPEnvExceptionEnum.  If you are setting multiple values, then
/// add them up.  For instance: FPEnvSetExceptionMask(Inexact + Overflow + Invalid);
/// </para></remarks>
public  void FPEnvSetExceptionMask( Int32 Exceptions) {  FPEnvSetExceptionMask_(uCalcHandle,Exceptions); }
  


/// <summary> Unmasks the current floating point environment mask</summary>
/// <param name="Exceptions"> Exceptions (FPEnvExceptionEnum)</param>
/// <remarks><para>
/// This unmasks (turns off) the floating point exceptions for the values are passed.  If you are setting multiple values, then
/// add them up.  For instance: FPEnvSetExceptionUnMask(Inexact + Overflow + Invalid);
/// </para></remarks>
public  void FPEnvSetExceptionUnMask( Int32 Exceptions) {  FPEnvSetExceptionUnMask_(uCalcHandle,Exceptions); }
  


/// <summary> Sets the floating point environment rounding option</summary>
/// <param name="Direction"> Direction for rouding</param>
/// <remarks><para>
/// This sets the rounding mode for floating points.
/// </para></remarks>
public  Int32 FPEnvSetRounding(FPEnvRoundingEnum Direction) { return FPEnvSetRounding_(uCalcHandle,Direction); }
  


/// <summary> Toggles the floating point environment mask</summary>
/// <param name="Exception"> Exception to toggle</param>
/// <remarks><para>
/// This toggles an individual exception.
/// </para></remarks>
public  void FPEnvToggleExceptionMask(FPEnvExceptionEnum Exception) {  FPEnvToggleExceptionMask_(uCalcHandle,Exception); }
  


/// <summary> Returns the handle of a uCalc.Item given a name</summary>
/// <param name="ItemName"> Name of the item who&#39;s handle you want</param>
/// <param name="Properties"> Properties to narrow down the search to the desired item, where the same name is shared by multiple items with different properties</param>
/// <param name="SkipTransform"> Skips any transform that would normally be associated with the item name, before returning a value (for instance, if you are interested in the transform itself)</param>
public  IntPtr HandleOf( string ItemName , Int64 Properties  = 0, bool SkipTransform = false) { return HandleOf_(uCalcHandle,ItemName ,Properties,SkipTransform); }
  


/// <summary> Returns the uCalc.Item object associated with the given name</summary>
/// <param name="ItemName"> Name of uCalc.Item that you want to get</param>
/// <param name="Properties"> Properties to help pinpoint the right Item, in case several items share the same name</param>
/// <param name="SkipExpansion"> Some items are define as a syntax construct alias of another item.  By default the symbol is expanded first.  However, use this option if the alias is the object you&#39;re actually after.</param>
/// <remarks><para>
/// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.
/// </para><para>
/// In case multiple items share the same name, you can narrow it down using properties.  For instance, the + operator has a
/// binary and unary versions.  You can specify Prefix if you wanted the unary one.
/// </para><para>
/// Note: A ItemIsEnum member should not be passed directly as the second argument.  Instead Properties, with one or more
/// ItemIsEnum members should be passed.
/// </para></remarks>
public Item GetItemOf( string ItemName , Int64 Properties  = 0, bool SkipExpansion = false) { return new Item(GetItemOf_(uCalcHandle,ItemName ,Properties,SkipExpansion)); }
  


/// <summary> Returns the nth uCalc.Item object that matches a property</summary>
/// <param name="Property_"> Property of the uCalc.Item object you&#39;re after</param>
/// <param name="nth"> The nth object</param>
/// <param name="DataTypeName"> The data type of the object</param>
/// <remarks><para>
/// This can be used to cycle through defined items.
/// If there is no match, an item whose IsProperty ItemIsEnum.NotFound value is true is returned.
/// </para></remarks>
public Item GetItemOfProperty(ItemIsEnum Property_ ,  Int32 nth , string DataTypeName = "") { return new Item(GetItemOfProperty_(uCalcHandle,Property_ , nth ,DataTypeName)); }
  




/// <summary> Sets the license code</summary>
public  Int32 License(LicenseTypeEnum LicenseType,  Int32 L1 = 0,  Int32 L2 = 0,  Int32 L3 = 0,  Int32 L4 = 0,  Int32 L5 = 0) { return License_(uCalcHandle,LicenseType, L1, L2, L3, L4, L5); }
  


/// <summary> ???</summary>
public Item NamespaceChild( Int32 nth = 0) { return new Item(NamespaceChild_(uCalcHandle,nth)); }
  


/// <summary> ???</summary>
public  Int32 NamespaceChildCount() { return NamespaceChildCount_(uCalcHandle); }
  


/// <summary> ???</summary>
public Item NamespaceParent( Int32 Level = 0) { return new Item(NamespaceParent_(uCalcHandle,Level)); }
  


/// <summary> ???</summary>
public Item NamespaceSymbol( Int32 nth) { return new Item(NamespaceSymbol_(uCalcHandle,nth)); }
  


/// <summary> ???</summary>
public  Int32 NamespaceSymbolCount() { return NamespaceSymbolCount_(uCalcHandle); }
  


/// <summary> Returns a new transform object</summary>
/// <remarks><para>
/// Returns a new object that can be used to transform text.
/// </para></remarks>
public uCalcTransform NewTransform() { return new uCalcTransform(NewTransform_(uCalcHandle)); }
  


/// <summary> Returns the transform object associated with the current math parser object</summary>
/// <remarks><para>
/// Whenever a math expression is parsed, this transform is first called.  Use this when you want transforms that apply to math
/// expressions parsed with Parse, Eval, or EvalStr.  To create a new transform that does not affect math expressions sent to
/// Parse, use NewTransform instead.
/// </para><para>
/// Independent transforms created with NewTransform can be released when no longer needed.  However, the object created with
/// ParserTransform should never be released explicitely, because the math parser object requires it in order to function properly.
/// </para></remarks>
public uCalcTransform ParserTransform() { return new uCalcTransform(ParserTransform_(uCalcHandle)); }
  


/// <summary> Parses an expression that will later be evaluated with Evaluate or EvaluateStr</summary>
/// <param name="Expression"> Expression to be parsed</param>
/// <param name="DataType"> Data type of return value</param>
public ParsedExpr Parse( string Expression , string DataType = "") { return new ParsedExpr(Parse_(uCalcHandle,Expression ,DataType)); }
  


/// <summary> Returns the precedence level of an operator or the level between two operators</summary>
/// <param name="Operator1"> Operator with lower (or equal) precedence</param>
/// <param name="Operator2"> Operator with greater (or equal precedence)</param>
/// <remarks><para>
/// This returns a precedence level based on levels of existing operators; useful when defining a new operator (or transform)
/// with a level relative to levels of existing operators (or transforms).  If one argument is passed, then the precedence
/// level of that item is returned.  This is useful for defining a new item at the same level as the specified item.  If two
/// arguments are passed, then the average precedence level of the two items is returned.  This is useful for defining a level
/// that&#39;s in between that of two existing items.
/// </para></remarks>
public Int32  Precedence( string Operator1 , string Operator2 = "") { return Precedence_Overload_uCalc_(uCalcHandle,Operator1 ,Operator2); }
  


/// <summary> Combines properties into a numeric value that can be passed to GetItemOf</summary>
/// <remarks><para>
/// ItemIsEnum properties are numbered sequentially (0, 1, 2, 3, 4, ...).  However the Properties argument
/// of the GetItemOf function requires properties in the 2^x sequence (1, 2, 4, 8, 16, ...).  So you
/// must pass one or more ItemIsEnum to Properties before passing it to GetItemOf.
/// </para></remarks>
public  Int64 Properties(ItemIsEnum p1, ItemIsEnum p2 = ItemIsEnum.AnyItem, ItemIsEnum p3 = ItemIsEnum.AnyItem, ItemIsEnum p4 = ItemIsEnum.AnyItem) { return Properties_(uCalcHandle,p1, p2, p3, p4); }
  


/// <summary> (Use Release instead)</summary>
/// <remarks><para>Use Release</para></remarks>
public  void ReleaseuCalc() {  ReleaseuCalc_(uCalcHandle); }
  


/// <summary> Removes any output decoration</summary>
public  void ResetOutput() {  ResetOutput_(uCalcHandle); }
  


/// <summary> Returns default settings</summary>
/// <remarks><para>The Item returned contains the default settings for the current uCalc instance.  To define new settings,
/// use Define(&quot;Default ~~ ...&quot;).</para></remarks>
public Item Default() { return new Item(Default_(uCalcHandle)); }
  


/// <summary> Allows a callback to decorate the output of EvalStr</summary>
/// <param name="FunctionAddress"> Address of callback function that formats the output</param>
/// <param name="Properties"> Name of datatype whose output will be formated and/or ranking among other output formats; leave blank to affect all data types and use default ranking.</param>
public Item  SetOutput(uCalcDelegate FunctionAddress ,  string Properties) { return new Item(SetOutput_Overload_uCalc__Callback_(uCalcHandle,FunctionAddress , Properties)); }
  


/// <summary> Formats the appearance of results returned by EvalStr or EvaluateStr</summary>
/// <param name="Definition"> Format definition for the output</param>
/// <remarks><para>
/// This function lets you modify the output returned by EvalStr or EvaluateStr.  The definition may contain one or more
/// of the following:
/// </para><para>
/// Datatype:  If you specify a data type, then the modification will affect only the evaluation result of expressions
/// that evaluate to the specified data type.
/// </para><para>
/// InsertAt:  By default, if you define multiple outputs, then the one defined most recently is applied first, followed by
/// the other outputs in reverse order in which they were defined, ending with the output that was defined first.  You may
/// specify a different insertion point than the default with this parameter.
/// </para><para>
/// Expression:  This represents what the modified output should look like.  The expression consists of an identifier
/// (any temporary variable name), followed by an equal sign, followed by a string expression representing the value
/// that will be returned.  The variable holds the original value that would have been returned.
/// </para></remarks>
public Item  SetOutput( string Definition) { return new Item(SetOutput_Overload_uCalc__NoCallback_(uCalcHandle,Definition)); }
  


/// <summary> Creates a transform that can modify text or search through text</summary>
/// <returns> Returns a transform object</returns>
/// <remarks><para>
/// +++
/// </para></remarks>
public Item CreateTransform() { return new Item(CreateTransform_(uCalcHandle)); }
  


/// <summary> Returns the value located at the specified IntPtr address</summary>
/// <param name="ValuePtr"> IntPtr address containing the data</param>
/// <param name="DataType"> Data type of the data you need, which helps to determine in which form to return the value at the given location</param>
/// <remarks><para>+++EXP ORT IntPtr ValueAt( IntPtr uCalcHandle,  IntPtr ValuePtr, OBJ DataType)
/// +++ SetValueAt
/// </para></remarks>
public  string ValueAt( IntPtr ValuePtr ,  string DataType) { return Marshal.PtrToStringAnsi(ValueAt_(uCalcHandle,ValuePtr , DataType)); } 
  


/// <summary> Returns the handle of the uCalc object</summary>
/// <remarks><para>Generally for internal use</para></remarks>
public IntPtr  Handle() { return Handle_Overload_uCalc_(uCalcHandle); }
  
/// <summary> Releases a uCalc instance</summary>
/// <remarks><para>When a uCalc instance is no longer needed, it can be released with this function.  This releases all items
/// associated with the uCalc instance.
/// </para><para>
/// Note: The uCalc object named uc, which is instantiated at startup (except in C#) should not be explicitely released.
/// In C#, if there is only 1 uCalc object left, do not explicitely release it.
/// </para><para>
/// Note: A uCalc object must explicitely be released with Release for it to be released.  A uCalc object is not
/// automatically released from memory when the object goes out of scope.</para></remarks>
public void Release()  { ReleaseuCalc(); uCalcHandle = default(IntPtr); }

/// 
public void Reset()  { ReleaseuCalc(); uCalcHandle = CreateuCalc(); }

public uCalc() { uCalcHandle = default(IntPtr); uCalcHandle = CreateuCalc(); }
public uCalc( uCalc uCalcInstance) { uCalcHandle = uCalcInstance.uCalcHandle; }
public uCalc( IntPtr InstHandle) { uCalcHandle = InstHandle; }
public uCalc(LicenseTypeEnum LicenseType,  Int32 L1 = 0,  Int32 L2 = 0,  Int32 L3 = 0,  Int32 L4 = 0,  Int32 L5 = 0) { License(LicenseType, L1, L2, L3, L4, L5); uCalcHandle = CreateuCalc(); }
List<uCalcDelegate> Addresses = new List<uCalcDelegate>();
public uCalcDelegate PinAddr(uCalcDelegate Address) { Addresses.Add(Address); return Address; }
} // uCalc










