//---------------------------------------------------------------------------
#include <vcl.h>
#include <shellapi.h>
#pragma hdrstop

#include "DemoCB.h"
#include "uCalcCB.h" // Run Setup.Bat to copy this and other uCalc files.
#include  <math.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
Extended H, W;
void CartesianLineTo(Extended a, Extended b);

// uCalc callback routines

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
DWORD _stdcall MyErrorHandler(long t)
{
   static long AlreadyDisplayedOnce = 0;

   if(AlreadyDisplayedOnce == ucFalse)
	  ShowMessage("Error Handler message: " + ucErrorMessage(0, t) + '\n'
		 + "Offending symbol: " + ucErrorSymbol(t) + '\n'
		 + "Error Location: " + IntToStr(ucErrorLocation(t)) + '\n' + '\n'
		 + "This message box will not be displayed for the next error. " + '\n'
		 + "Remove 'AlreadyDisplayedOnce = ucTrue;' in the demo source code to change this. ");

   // Remove the line below if you want the message box to be
   // displayed every time there's an error.
   AlreadyDisplayedOnce = ucTrue;
   return ucAbort;
}

void _stdcall MyNumericFormat(long Expr)
{
   AnsiString fmt;
   Extended Value;
   TVarRec args[] = {StrToFloat(ucArgStr(Expr, 1))};
   Value = StrToFloat(ucArgStr(Expr, 1));
   fmt = "%g";

   if (Form1->cmbNumericFormat->Text == "Scientific") fmt = "%e";
   if (Form1->cmbNumericFormat->Text == "Fixed")      fmt = "%f";
   if (Form1->cmbNumericFormat->Text == "Number")     fmt = "%n";
   if (Form1->cmbNumericFormat->Text == "Money")      fmt = "%m";

   ucReturnStr(Expr, Format(fmt, args, 0));
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall MyArea(DWORD Expr)
{
   Extended MyLength, MyWidth;

   MyLength = ucArg(Expr, 1);
   MyWidth = ucArg(Expr, 2);

   if(MyLength < 0) ucRaiseErrorMessage(Expr, "Length cannot be negative");
   if(MyWidth  < 0) ucRaiseErrorMessage(Expr, "Width cannot be negative");

   ucReturn(Expr, MyLength * MyWidth);
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
Extended _stdcall NonNativeFunc(double a, long& b, byte c)
{
   return a + b + c;
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall MyIIF_Numeric(DWORD Expr)
{
   Extended Condition;
   DWORD TruePart, FalsePart;

   Condition = ucArg(Expr, 1);
   TruePart = ucArgHandle(Expr, 2);
   FalsePart = ucArgHandle(Expr, 3);

   if (Condition != 0)
   ucReturn(Expr, ucEvaluate(TruePart));
   else ucReturn(Expr, ucEvaluate(FalsePart));
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall MyIIF_String(DWORD Expr)
{
   Extended Condition;
   DWORD TruePart, FalsePart;

   Condition = ucArg(Expr, 1);
   TruePart = ucArgHandle(Expr, 2);
   FalsePart = ucArgHandle(Expr, 3);

   if (Condition != 0)
   ucReturnStr(Expr, ucEvaluateStr(TruePart).c_str());
   else ucReturnStr(Expr, ucEvaluateStr(FalsePart).c_str());
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall Native_MsgBox(DWORD Expr)
{
   ucReturnLng(Expr, MessageBox(0, ucArgStr(Expr, 1).c_str(), ucArgStr(Expr, 2).c_str(), ucArgLng(Expr, 3)));
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
long _stdcall NonNative_MsgBox(AnsiString Prompt, AnsiString& Title, long Buttons)
{
   return MessageBox(0, Prompt.c_str(), Title.c_str(), Buttons);
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall MyAverage(DWORD Expr)
{
   long x;
   double Total = 0;

   for(x = 1; x <= ucArgCount(Expr); x++)
      Total = Total + ucArg(Expr, x);

   ucReturn(Expr, Total / ucArgCount(Expr));
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall MyLeft(DWORD Expr)
{
  AnsiString MyString;
  MyString = ucArgStr(Expr, 1);
  ucReturnStr(Expr, MyString.SubString(1, ucArg(Expr, 2)).c_str());
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall StringRepeat(DWORD Expr)
{
   long x;
   AnsiString MyString;
   static AnsiString TotalString;

   TotalString = "";
   MyString = ucArgStr(Expr, 1);

   for(x = 1; x <= ucArg(Expr, 2); x++)
      TotalString = TotalString + MyString;

   ucReturnStr(Expr, TotalString.c_str());
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall ucSum(long Expr)
{
   long Expression, VarHandle;
   long Start, Finish, sStep;
   Extended x, Total;

   Expression = ucArgHandle(Expr, 1);
   Start = ucArg(Expr, 2);
   Finish = ucArg(Expr, 3);
   sStep = ucArg(Expr, 4);
   VarHandle = ucArgHandle(Expr, 5);

   x = Start;
   Total = 0;

   while(x <= Finish)
   {
      ucSetVariableValue(VarHandle, x);
	  Total = Total + ucEvaluate(Expression);
      x = x + sStep;
   }

   ucReturn(Expr, Total);
}

// IMPORTANT: Remember to use _stdcall for your uCalc callbacks
void _stdcall ucSolve(DWORD Expr)
{
   DWORD Expression, Variable;
   long Iterations = 0;
   Extended a, b, fa, fb, Value, tmp;

   Expression = ucArgHandle(Expr, 1);
   a = ucArg(Expr, 2);
   b = ucArg(Expr, 3);
   Variable = ucArgHandle(Expr, 4);

   ucSetVariableValue(Variable, a); fa = ucEvaluate(Expression);
   ucSetVariableValue(Variable, b); fb = ucEvaluate(Expression);
   
   if(fb < fa) {tmp = a; a = b; b = tmp;}  // swap a, b
    
   while(fabs(b - a) > 0.000000000000001)
   {
      ucSetVariableValue(Variable, (a + b) / 2);
      
      Value = ucEvaluate(Expression);
      
      if(Value == 0) {a = (a + b) / 2; break;}

      if(Value < 0) a = (a + b) / 2; else b = (a + b) / 2;

      Iterations = Iterations + 1;
      if(Iterations == 100) break;
   }
   
   if(fabs(Value) > 0.0000000001) ucRaiseErrorMessage(Expr, "Solution not found");

   ucReturn(Expr, a);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   Image1->Canvas->Rectangle(0, 0, Image1->Width, Image1->Height);

   // The definitions here are for "callback" routines.
   // The actual code for these routines can be found elsewhere in this file.
   // Do a search for MyErrorHandler, for instance, to see the actual code for it.
   // Each line ends with the name of the callback routine. FuncPtr converts the
   // address pointer of a routine to 32-bit integer for use with uCalc().

   // The MyErrorHandler() function will be called whenever and wherever an
   // error (such as "Syntax Error") is raised.
   ucAddErrorHandler(MyErrorHandler);

   // Lets user configure numeric output: Scientific, Fixed, Money, Standard, etc.
   ucSetOutput(MyNumericFormat);

   // Native callback definitions, which start with "Native: " are recommended for
   // speed, and for routines that use uCalc's default numeric and string types.
   // MyArea() returns the product of multiplying the two arguments.
   // MyLeft() returns the left-most characters of a string.  The second argument represents the number of characters.
   // MessgeBox() displays a message box.  The 1st argument is required.  The others are optional.
   ucDefineFunction("Native: MyArea(Length, Width)", MyArea);
   ucDefineFunction("Native: MyLeft(Text As String, Count) As String", MyLeft);
   ucDefineFunction("Native: MyMsgBox(Prompt As String, Title As String = 'uCalc', Buttons As Long = 0) As Long", Native_MsgBox);
   ucDefineSyntax("MsgBox ::= MyMsgBox");

   // The three consecutive dots "..." mean that MyAverage can take any number of arguments
   // (however, because "x" is specified, there must be at least one argument).
   ucDefineFunction("Native: MyAverage(x ...)", MyAverage);

   // Two versions of MyIIF can co-exist peacefully with the same name because
   // they are defined with different argument types (numeric vs string).
   // By passing the last two arguments ByExpr, the callback can chose to evaluate only one of of them.
   ucDefineFunction("Native: MyIIf(ByVal cond, ByExpr TruePart, ByExpr FalsePart)", MyIIF_Numeric);
   ucDefineFunction("Native: MyIIf(cond, ByExpr TruePart As String, ByExpr FalsePart As String) As String", MyIIF_String);

   // The following defines the "*" operator so that MyString * n returns MyString repeated n times.
   // For instance, "He " * 3, would return "He He He".  20 represents the precedence level.  It is
   // arbitrarily set at the same level as that of the "*" multiplication operator defined in uCalcCPP.cpp.
   ucDefineOperator("Native: Precedence('*') {MyString As String} * {Number} As String", StringRepeat);

   // Non-native callbacks are intended for routines that were not created with
   // uCalc in mind, such as the Windows API, or other pre-existing DLL routines.
   // It is convenient (no need to adapt the routines; all you need is a function
   // address), but not as fast as Native callbacks.
   // NonNativeFunc() simply adds the three arguments.
   // nn_MsgBox is a Non-Native version of MessageBox, which displays a message box.
   ucDefineFunction("NonNativeFunc(ByVal a As Double, ByRef b As Long, ByVal c As Byte) As Extended", NonNativeFunc);
   ucDefineFunction("NonNativeMsgBox(ByVal Prompt As String, ByRef Title As String = 'uCalc', ByVal Buttons As Long = 0) As Long", NonNative_MsgBox);

   // This definition is for a summation.  See the callback Sum() routine for the
   // actual code, which runs a loop that adds up the total for the expression in
   // the first argument a number of times based on the second and third arguments.
   // For instance Sum(g^2+1, 1, 5, 1, g) returns 60 and Sum(x^2, 1, 10) returns 385.
   // The last two arguments are optional, so they default to 1 and x if omitted.
   //
   // The first argument is passed "ByExpr".  So instead of being evaluated before
   // being passed to the callback the way an ordinary argument would be, a handle
   // for the expression is passed so that the callback can evaluate it (in this
   // case numerous times).
   //
   // The last argument is passed "ByHandle".  This causes the callback to receive
   // a handle for the variable being passed, in such a way that it can be linked to
   // the summation counter, and integrated into the expression in the first argument.
   //
   // The actual function being defined is Sum_().  Then a syntax construct named
   // Sum() is defined in such a way that the last argument gets defined as a local
   // variable.  So if you evaluate Sum(x^2, 5, 10, 1, x), the local "x" in this
   // expression will not interfere with a pre-existing variable named x.  Also you
   // do not need to declare a variable ahead of time to use it as a counter for Sum().
   ucDefineFunction("Native: Sum_(ByExpr Expr, Start, Finish, Step, ByHandle Var)", ucSum);
   ucDefineSyntax("Sum({Expr}, {Start}, {Finish} [, {Step=1} [, {Var=x}]])"
                  "::= Local({Var}, Sum_({Expr}, {Start}, {Finish}, {Step}, {Var}))");

   // The following routine solves an equation.
   // The callback code is based on the Bisection Method algorithm.
   // The concept here is very similar to that of Sum().
   // Two syntax constructs are defined.  The second one rearranges the equation
   // if it includes an equal sign.
   // For instance Solve(x^2 = 9+x) becomes Solve(x^2 - (9+x))
   // Solve(x^2 + 1 = 26) returns 5.
   // Solve(x^2 + 1 = 26, -1000, 0) returns -5.
   ucDefineFunction("Native: Solve_(ByExpr Expr, a, b, ByHandle Var)", ucSolve);
   ucDefineSyntax("Solve({Expr} [, {a=-100000000} [, {b=100000000} [, {Var=x}]]]) "
		          "::= Local({Var}, Solve_({Expr}, {a}, {b}, {Var}))");
   ucDefineSyntax("Solve({Left} = {Right} [, {etc}]) ::= Solve({Left}-({Right}) {etc: , {etc}})");
}
//---------------------------------------------------------------------------

void CartesianLineTo(Extended a, Extended b)
{
   int x, y;

   x = W * (a + 10) / 20;
   y = H * (2 - b) / 4;
   Form1->Image1->Canvas->LineTo(x, y);
}

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnEvalClick(TObject *Sender)
{
   // ucEval() evaluates an expression and returns a numeric result.
   // ucEvalStr() can evaluate expressions of any data type (numeric, string, or other).
   // If the result is numeric ucEvalStr conveniently converts it to a string for you.

   txtResult->Text = ucEvalStr(cmbExpression->Text);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnDefineClick(TObject *Sender)
{
   // ucDefine can define a variable, function, operator, syntax construct,
   // constant, pattern, data type, and more.
   //
   // Examples:
   //
   // ucDefine("Var: MyVariable As String");
   // ucDefine("Func: Area(Length, Width) = Length * Width");
   // ucDefine("Op: 50 {x}%  :=  x / 100");   // 50 is an arbitrary precedence level.
   // ucDefine("Syntax: {a} + {a} ::= 'Two {a}s are better than one {a}'");
   // ucDefine("Const: Pi = Atan(1) * 4");
   ucDefine(cmbDefinition->Text);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::btnPlotClick(TObject *Sender)
{
   Extended x = -10;
   DWORD EqHandle, xHandle;

   xHandle = ucDefineVariable("x", &x);
   EqHandle = ucParse(txtPlotEq->Text);

   Image1->Canvas->FillRect(ClientRect);

   W = Image1->Width;
   H = Image1->Height;

   Image1->Canvas->MoveTo(0, H/2);

   while (x <= 10)
   {
      CartesianLineTo(x, ucEvaluate(EqHandle));
      x = x + 0.125;
   }

   ucReleaseItem(EqHandle);
   ucReleaseItem(xHandle);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnSumClick(TObject *Sender)
{
   Extended x = 1, SumTotal = 0, SumMax;
   DWORD ExprHandle, xHandle;
   TDateTime TimerStart;
   TTimeStamp Elapsed;

   SumMax = StrToFloat(txtSumMax->Text);
   xHandle = ucDefineVariable("x", &x);
   ExprHandle = ucParse(txtSumExpression->Text);
   TimerStart = Time();

   while (x <= SumMax)
   {
      SumTotal = SumTotal + ucEvaluate(ExprHandle);
      x++;
   }

   Elapsed = DateTimeToTimeStamp(Time() - TimerStart);
   txtSumResult->Text = FormatFloat("#", SumTotal);
   lblElapsed->Caption = "Elapsed Time: " + FloatToStr(Elapsed.Time/1000.00) + " seconds";

   ucReleaseItem(ExprHandle);
   ucReleaseItem(xHandle);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkInvalidOpClick(TObject *Sender)
{
   // If toggled, then an expression such as 0 / 0 raises an error.
   // If toggled again, then 0 / 0 returns NaN.
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_InvalidOp);    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkDenormalOpClick(TObject *Sender)
{
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_DenormalOp);    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkDivisionBy0Click(TObject *Sender)
{
   // If toggled, then 1 / 0 raises an error.
   // If toggled again, then 1 / 0 returns Inf.
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_ZeroDivide);    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkOverflowClick(TObject *Sender)
{
   // If toggled, then 100! ^ 150 raises an error.
   // If toggled again, then 100! ^ 150 returns Inf.
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_Overflow);    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkUnderflowClick(TObject *Sender)
{
   // If toggled, then (1/100!)^150 raises an error.
   // If toggled again, then (1/100!)^150 returns 0.
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_Underflow);    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::chkPrecisionLossClick(TObject *Sender)
{
   // If toggled, an expression that cannot be represented in exact form
   // such as "1/3" will raise an error.
   // If toggled again, "1/3" returns the closest extended precision approximation.
   uCalc(uc_ToggleFPU, 0, uc_FPU_Mask_PrecisionLoss);    
}
//---------------------------------------------------------------------------

