﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SpreadsheetDemo
{
    public partial class Form1 : Form
    {
        int[,] FormulaHandle = new int[11, 11];
        string[,] FormulaText = new string[11, 11];
        int Row, Col;
       
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            for (int number=1; number <=10; number++) DataGridView1.Rows.Add(number.ToString());
        }

        private void txtCellFormula_TextChanged(object sender, EventArgs e)
        {
            DataGridView1.CurrentCell.Value = txtCellFormula.Text;
        }

        private void DataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            Col = e.ColumnIndex; Row = e.RowIndex + 1;
            txtCellName.Text = DataGridView1.Columns[Col].HeaderText + Row.ToString();
            txtCellFormula.Text = FormulaText[e.ColumnIndex, e.RowIndex + 1];
            txtCellFormula.Focus();
        }

        private void txtCellFormula_Leave(object sender, EventArgs e)
        {
            if (txtCellFormula.Text.Length > 0) {
                FormulaText[Col, Row] = txtCellFormula.Text;
                FormulaHandle[Col, Row] = uc.ucParse(txtCellFormula.Text);
                DataGridView1[Col, Row - 1].Value = uc.ucEvalStr(txtCellFormula.Text);
                uc.ucDefine("Overwrite ~~ Func: " + txtCellName.Text + "() =" +txtCellFormula.Text);
                for (int x = 1; x <= 10; x++) {
                    for (int y = 1; y <=10; y++) {
                        if (FormulaHandle[x, y] != 0) DataGridView1[x, y - 1].Value = uc.ucEvaluateStr(FormulaHandle[x, y]);
                    }
                }
            }
        }

                
    }
}
