unit Spreadsheet;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls, Grids, uCalcDlp;

type
   TForm1 = class(TForm)
      txtCellName: TEdit;
      txtFormula: TEdit;
      Label1: TLabel;
      Grid1: TStringGrid;
      Label2: TLabel;
      procedure Grid1Click(Sender: TObject);
      procedure txtFormulaChange(Sender: TObject);
      procedure txtFormulaExit(Sender: TObject);
      procedure FormCreate(Sender: TObject);
   private
      { Private declarations }
   public
      { Public declarations }
   end;

var
   Form1: TForm1;
   Row, Col: Longint;
   ColumnName: array[0..10] of string;
   FormulaHandle: array[0..10, 0..10] of Longint;
   FormulaText: array[0..10, 0..10] of string;

implementation

{$R *.DFM}

procedure TForm1.Grid1Click(Sender: TObject);
begin
   Col := Grid1.Col;
   Row := Grid1.Row;

   txtCellName.Text := ColumnName[Col] + IntToStr(Row);
   txtFormula.Text := FormulaText[Col, Row];
   txtFormula.SetFocus();
end;

procedure TForm1.txtFormulaChange(Sender: TObject);
begin
   Grid1.Cells[Col, Row] := txtFormula.Text;
end;

procedure TForm1.txtFormulaExit(Sender: TObject);
var
   x, y: Longint;
begin
   if txtFormula.Text <> '' then
   begin
      FormulaText[Col, Row] := txtFormula.Text;
      FormulaHandle[Col, Row] := ucParse(txtFormula.Text);
      Grid1.Cells[Col, Row] := ucEvalStr(txtFormula.Text);
      ucDefine('Overwrite ~~ Func: ' + txtCellName.Text + '() =' + txtFormula.Text);
      for x := 1 To 10 do
      begin
         for y := 1 To 10 do
         begin
            if FormulaHandle[x, y] <> 0 then Grid1.Cells[x, y] := ucEvaluateStr(FormulaHandle[x, y]);
         end;
      end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   x: Longint;
   Alpha: String;
begin
   Alpha := 'ABCDEFGHIJK';

   for x := 1 To 10 do
   begin
      Grid1.Cells[0, x] := IntToStr(x);
      Grid1.Cells[x, 0] := Copy(Alpha, x, 1);
      ColumnName[x] := Copy(Alpha, x, 1);
   end;

   Grid1.Row := 1;
   Grid1.Col := 1;
   Show;
   Grid1Click(Sender);
end;

end.
