$Version = "4.00"
' ---------------------------------------------------------------------------
' Interface.Bas : @Language include file for uCalc Fast Math Parser @Version
' Designed for : @CompilerName
'
' This file auto-generated by : @CompilerTransformFile using @AppName
' Auto-generation timestamp: @DateTime
' @CompilerTransformFile prepared by : Daniel Corbier
' Visit www.ucalc.com for additional resources.
' ---------------------------------------------------------------------------

' VB.NET: Public Module uCalcVBNET
' Definition properties
%ucAlphaNumeric   = 1
%ucArgSeparator   = 2
%ucCodeBlock      = 3
%ucCodeBlockMatch = 4
%ucMemberAccess   = 5
%ucQuotedText     = 6
%ucStatementSep   = 7
%ucWhiteSpace     = 8

%ucCurrentThread  = 9

%ucLocalVar        = 10
%ucStaticVar       = 11
%ucDefineNow       = 11 ' same as ucStaticVar
%ucTempDef         = 12
%ucEvalInsert      = 13
%ucEvalDuringParse = 14
%ucExpandInsert    = 15
%ucFileInclude     = 16

%ucCurrentSpace    = 17
%ucDefSpace        = 18
%ucEvalSpace       = 19

%ucFunction       = 64
%ucOperator       = 128
%ucVariable       = 256
%ucSyntax         = 512
%ucLiteral        = 1024
%ucSymbol         = 2048
%ucReducible      = 4096
%ucLock           = 8192
%ucInfix          = 16384
%ucPrefix         = 32768
%ucPostfix        = 49152

' uCalc Commands
%uc_Define               = 1
%uc_DefineSyntax         = 2
%uc_Eval                 = 3
%uc_EvalStr              = 4
%uc_Evaluate             = 5
%uc_EvaluateLng          = 6
%uc_EvaluateStr          = 7
%uc_GetCaseSensitivity   = 8
%uc_GetDefaultPass       = 9
%uc_GetDefaultPrecedence = 10
%uc_GetDefaultRank       = 11
%uc_GetCodeAddr = 12
%uc_GetDefaultThread     = 13
%uc_GetDefaultType       = 14
%uc_GetDefSeparator      = 15
%uc_GetDefSpace          = 16
%uc_GetErrorNumber       = 17
%uc_GetEvalSpace         = 18
%uc_GetParentThread      = 20
%uc_GetSyntaxEqual       = 21
%uc_Parse                = 22
%uc_ReleaseItem          = 23
%uc_SetCaseSensitivity   = 24
%uc_SetCodeAddr          = 25
%uc_SetDefaultPrecedence = 26
%uc_SetDefaultRank       = 27
%uc_SetDefaultThread     = 28
%uc_SetDefaultType       = 29
%uc_SetDefSeparator      = 30
%uc_SetErrorNumber       = 31
%uc_SetParentThread      = 32
%uc_SetSyntaxEqual       = 33
%uc_NewThread            = 34

%uc_RegExWordBoundaryChars = 35
%uc_RegExEscapeChar = 36
%uc_License = 37

' License options
%uc_License_Demo = 0
%uc_License_FMP_Free = 1
%uc_License_FMP_Standard_32 = 2
%uc_License_FMP_Standard_64 = 3
%uc_License_FMP_32_and_64 = 4
%uc_License_LanguageBuilder = 5
%uc_License_GeneralParser = 6
%uc_License_Interpreter = 7
%uc_License_ConsoleCalc = 8
%uc_License_WindowsCalc = 9
%uc_License_StringLib = 10
%uc_License_Transform = 11
%uc_License_TransformLib = 12
%uc_License_Search = 13
%uc_License_SearchLib = 14
%uc_License_Library1 = 15
%uc_License_Library2 = 16
%uc_License_Beta = 17
%uc_License_Debugger = 18
%uc_License_uCalc_All = 50
%uc_License_Developer = 100
%uc_License_EndUser = 101

%uc_AddDebugger = 39
%Debug_ReleaseItem    = 1
%Debug_StdFuncCall    = 2
%Debug_UserFuncCall   = 3
%Debug_GetTextToken   = 4
%Debug_ErrorHandler   = 5
%Debug_ParseExpr      = 6
%Debug_ParseItem      = 7
%Debug_EvalOperation  = 8
%Debug_DefSyntax      = 9
%Debug_Define         = 10
%Debug_DefinePart     = 11
%Debug_Expand         = 12
%Debug_ExpandSuccess  = 13
%Debug_ExpandMiss     = 14
%Debug_ExpandFail     = 15
%Debug_GetSyntaxBlock = 16
%Debug_GetCodeBlock   = 17
%Debug_LineNumber     = 18
%Debug_TotalTally     = 19
%Debug_Breakpoint     = 20
%Debug_Delay          = 21
%Debug_JumpTo         = 22
%Debug_StepAction     = 23

%uc_AddErrorHandler = 40
%uc_GetSymbolTable = 41
%uc_GetSteps = 42
%uc_GetStepsCount = 43

%uc_SetTypeOutput = 45
%uc_Group = 46
%uc_GetTag = 47
%uc_SetTag = 48

%uc_GetCallbackData = 50
%uc_SetCallbackReturn = 51

%uc_GetErrorExpression = 60
%uc_SetExpression = 61
%uc_GetSymbol = 62
%uc_SetSymbol = 63
%uc_GetLocation = 64

%uc_GetTokenType = 65
%uc_GetTokenProperties = 66

%uc_TrigMode = 67

%uc_ItemClone = 70
%uc_DataConvert = 71
%uc_DataCopy = 72
%uc_DataAlloc = 72
%uc_DataFree = 73
%uc_DataReset = 74

' FPU commands
%uc_SetFPU = 75
%uc_SetFPU_HostProg = 76
%uc_GetFPU = 77
%uc_GetFPU_HostProg = 78
%uc_ToggleFPU = 79
%uc_ToggleFPU_HostProg = 80

%uc_ErrorClear = 85
%uc_RestoreErrorMessageBox = 86

%uc_SetErrorMessage = 91
%uc_GetErrorMessage = 92

%uc_SerialNumber = 93
%uc_SetTurbo = 94
%uc_Expand = 95
%uc_GetNextToken = 96
%uc_GetItemData = 97
%uc_SetItemData = 98
%uc_GetThreadAddr = 99
%uc_GetCodeBlock = 100

%uc_Status_CurrentPass = 101
%uc_Status_MaxPass = 102
%uc_Status_Location = 103
%uc_Status_NestedLevel = 104
%uc_Status_TextLength = 105

%uc_Find = 110
%uc_FindAddMatch = 111
%uc_FindGetIndex = 112
%uc_FindGetCount = 113
%uc_FindGetStart = 114
%uc_FindGetLength = 115
%uc_FindGetText = 116
%uc_FindReset = 117
%uc_FindReplace = 118
%uc_FindFilter = 119
%uc_FindSetFilter = 120

%uc_FindFilterSort = 1
%uc_FindFilterUnique = 2
%uc_FindFilterTally = 4
%uc_FindFilterSeparator = 8
%uc_FindFilterStartText = 16
%uc_FindFilterEndText = 32

%uc_FindContext_Other = 0
%uc_FindContext_Found = 1
%uc_FindContext_Replaced = 2

%uc_FindZoomIn = 1
%uc_FindTransformInPlace = 2

%uc_Properties = 1
%uc_Thread = 2
%uc_Address = 3
%uc_SymbolName = 4
%uc_Rank = 5
%uc_Precedence = 6
%uc_OverloadHandle = 7
%uc_OverloadCount = 8
%uc_ByteSize = 9
%uc_ArgCount = 10
%uc_DataType = 12
%uc_Handle = 13
%uc_Value = 14
%uc_Property = 15

' Error numbers
%uc_Err_None                    = 0
%uc_Err_Dynamically_Defined     = 1
%uc_Err_Syntax_Error            = 2
%uc_Err_Undefined_Identifier    = 3
%uc_Err_FileNotFound            = 4
%uc_Err_Unrecognized_Token      = 5
%uc_Err_Unrecognized_Command    = 6
%uc_Err_Datatype_Mismatch       = 7
%uc_Err_Invalid_Argument_Count  = 8
%uc_Err_Invalid_Definition      = 9
%uc_Err_CodeBlock_Error         = 10
%uc_Err_Undefined_Callback      = 11
%uc_Err_ErrMsgAlreadyDefined    = 12
%uc_Err_ItemCannotBeModified    = 13
%uc_Err_Unrecognized_Member     = 14
%uc_Err_Unbalanced_Quote        = 15

%uc_Err_Array_Bounds_Exceeded   = 20
%uc_Err_Float_Denormal_Operand  = 21
%uc_Err_Float_Divide_By_Zero    = 22
%uc_Err_Float_Inexact_Result    = 23
%uc_Err_Float_Invalid_Operation = 24
%uc_Err_Float_Overflow          = 25
%uc_Err_Float_Stack_Check       = 26
%uc_Err_Float_Underflow         = 27
%uc_Err_Integer_Divide_By_Zero  = 28
%uc_Err_Integer_Overflow        = 29
%uc_Err_Privileged_Instruction  = 30

' Error response
%ucAbort = 0
%ucResume = 1
%ucReRaise = 2

' FPU Control Word Settings
%uc_FPU_Mask_InvalidOp     = 1
%uc_FPU_Mask_DenormalOp    = 2
%uc_FPU_Mask_ZeroDivide    = 4
%uc_FPU_Mask_Overflow      = 8
%uc_FPU_Mask_Underflow     = 16
%uc_FPU_Mask_PrecisionLoss = 32

%uc_FPU_Precision_Single   = 0
%uc_FPU_Precision_Double   = 256
%uc_FPU_Precision_Extended = 768

%uc_FPU_Round_Even         = 0
%uc_FPU_Round_Down         = 1024
%uc_FPU_Round_Up           = 2048
%uc_FPU_Round_Toward       = 3072

' Data type handler callback action modes
%uc_TypeHandler_Store = 2
%uc_TypeHandler_StringOutput = 3
%uc_TypeHandler_Free = 4
%uc_TypeHandler_FuncRet = 5
%uc_TypeHandler_Copy = 6
%uc_TypeHandler_Alloc = 7
%uc_TypeHandler_Reset = 8

%uc_Callback_Undefined = 0 ' Returns error

' Data Type callbacks
%uc_Complex     = 1
%uc_Currency    = 2
%uc_Double      = 3
%uc_Extended    = 4
%uc_Int8        = 5
%uc_Int8u       = 6
%uc_Int16       = 7
%uc_Int16u      = 8
%uc_Int32       = 9
%uc_Int32u      = 10
%uc_Int64       = 11
%uc_Int64u      = 12
%uc_Single      = 13
%uc_String      = 14
%uc_String_LPCSTR= 15
%uc_String_Fixed= 16
%uc_String_Wide = 17
%uc_Stack       = 18
%uc_Table       = 19
%uc_SortedList  = 20
%uc_Void        = 21
%uc_User_Type   = 22

%uc_Convert_Generic = 23
%uc_Convert_Same = 24
%uc_Convert_Double_Extended = 25
%uc_Convert_Int8_Extended = 26
%uc_Convert_Int8u_Extended = 27
%uc_Convert_Int16_Extended = 28
%uc_Convert_Int16u_Extended = 29
%uc_Convert_Int32_Extended = 30
%uc_Convert_Int32u_Extended = 31
%uc_Convert_Int64_Extended = 32
%uc_Convert_Int64u_Extended = 33
%uc_Convert_Single_Extended = 34
%uc_Convert_Void_Extended = 35
%uc_Convert_Extended_Double = 37
%uc_Convert_Extended_Single = 38
%uc_Convert_Extended_Int16u = 39
%uc_Convert_Extended_Int32 = 40
%uc_Convert_Complex_Extended = 41
%uc_Convert_Extended_Complex = 42

' Default built-in routines
%uc_Op_Negate = 43
%uc_Op_UnaryPlus = 44
%uc_Op_Percentage = 45
%uc_Op_StrConcat = 46
%uc_Op_Add_Int32 = 47
%uc_Op_Add = 48
%uc_Op_Add_Complex = 49
%uc_Op_Subtract_Int32 = 50
%uc_Op_Subtract = 51
%uc_Op_Multiply_Int32 = 52
%uc_Op_Multiply = 53
%uc_Op_Multiply_Complex = 54
%uc_Op_Divide_Int32 = 55
%uc_Op_Divide = 56
%uc_Op_Mod_Int32 = 57
%uc_Op_Mod = 58
%uc_Op_PowerOf_ExtToExt = 59
%uc_Op_PowerOf_ExtToLng = 60
%uc_Op_PowerOf_CplxToCplx = 61

%uc_Op_GreaterThan = 62
%uc_Op_GreaterOrEqual = 63
%uc_Op_LessThan = 64
%uc_Op_LessOrEqual = 65
%uc_Op_Equal = 66
%uc_Op_NotEqual = 67

%uc_Op_GreaterThan_Str = 68
%uc_Op_GreaterOrEqual_Str = 69
%uc_Op_LessThan_Str = 70
%uc_Op_LessOrEqual_Str = 71
%uc_Op_Equal_Str = 72
%uc_Op_NotEqual_Str = 73

%uc_Op_Not_Int32 = 74
%uc_Op_And_Int32 = 75
%uc_Op_Or_Int32 = 76
%uc_Op_Xor_Int32 = 77
%uc_Op_Eqv_Int32 = 78
%uc_Op_Imp_Int32 = 79

%uc_Op_AndAlso = 80
%uc_Op_OrElse = 81

%uc_Op_Factorial = 82

%uc_Func_IIf = 83
%uc_Func_IIf_Str = 84

%uc_Func_Sin = 85
%uc_Func_Cos = 86
%uc_Func_Tan = 87
%uc_Func_Atan = 88
%uc_Func_Ceil = 89
%uc_Func_Abs = 90
%uc_Func_Abs_Int32 = 91
%uc_Func_Exp = 92
%uc_Func_Log = 93
%uc_Func_Floor = 94
%uc_Func_SquareRoot = 95
%uc_Func_BaseConvert = 96

%uc_Func_ExprHandle = 97
%uc_Func_VarPtr = 98
%uc_Func_uCalc = 99
%uc_Func_uCalcStr = 100
%uc_Func_ucAddr = 101
%uc_Func_ValueAtAddr = 102
%uc_Func_SpecialArg = 103
%uc_Op_StringMult = 104

%uc_Func_For  = 105
%uc_Func_Loop = 107

%uc_Func_LoadLibrary = 108
%uc_Func_GetProcAddress = 109

%uc_NullString = 110
%uc_True = 111

%uc_Func_Peek = 112
%uc_Func_Poke = 113

%uc_Func_Int = 115
%uc_Func_Frac = 116
%uc_Func_Sgn = 117

%uc_Func_PushData_Stack = 120
' %uc_Func_PopHandle_Stack = 121
%uc_Func_PopNum_Stack = 122
%uc_Func_PopStr_Stack = 123
%uc_Func_ReadHandle_Stack = 124
%uc_Func_ReadNum_Stack = 125
%uc_Func_ReadStr_Stack = 126
%uc_Func_Count_Stack = 127
%uc_Op_Concat_Stack = 128
%uc_Func_Populate_Stack = 129

%uc_Insert_Table = 130
%uc_Delete_Table = 131
%uc_Index_Table  = 132
%uc_Handle_Table = 133
%uc_HandleB_Table = 134
%uc_ReadData_Table = 135
%uc_ReadNum_Table = 136

%uc_Func_Min = 137
%uc_Func_Max = 138
%uc_Func_Min_Str = 139
%uc_Func_Max_Str = 140

%uc_SetVariableValue = 141
%uc_SetVariableValueAnyType = 141
%uc_SetVariableValueLong = 142
%uc_SetVariableValueDouble = 143
%uc_SetVariableValueExtended = 144
%uc_ResetVariable = 145

' Misc other callbacks
%uc_EvaluateAddr = 150
%uc_EvaluateTurboAddr = 151
%uc_ExceptionHelper = 152
%uc_DefaultErrorHandler = 153
%uc_Raise_Error = 154
%uc_Func_IsIncomplete = 155

%uc_ScriptTimerStart = 160
%uc_LoadTimeTix = 161

%uc_Op_Ext_Plus_Complex = 190
%uc_Op_Ext_Times_Complex = 191

%uc_Func_If_ElseIf = 195
%uc_Func_SetSyntaxParams = 196
%uc_Func_SpecialUCase = 197
%uc_Func_Rand = 198
%uc_Func_GetmatchArg = 199
%uc_Func_PatternNum = 200
%uc_Func_PatternStr = 201

%uc_Convert_Stack_Table = 220
%uc_Convert_Stack_SortedList = 221
%uc_Convert_Table_Stack = 222
%uc_Convert_SortedList_Stack = 223

%uc_Expand_List = 1
%uc_Expand_StackPtr = 2

%uc_HandleToken = 21 ' &h15

' Trig Mode
%uc_ReturnTrigMode = 0
%uc_Radians = 1
%uc_Degrees = 2
%uc_Grad    = 3

' Misc
%ucTrue  = 1
%ucFalse = 0
%uc_Rank_First = 1
%uc_Rank_Last  = -1

' Pattern options
%uc_Pattern_ArgCount = 1
%uc_Pattern_ArgIndex = 2
%uc_Pattern_ArgLength = 3
%uc_Pattern_ArgLocation = 4
%uc_Pattern_ArgText = 5
%uc_Pattern_DocumentLength = 6
%uc_Pattern_DocumentText = 7
%uc_Pattern_CriteriaCount = 8
%uc_Pattern_CriteriaIndex = 9
%uc_Pattern_MatchLength = 10
%uc_Pattern_MatchLocation = 11
%uc_Pattern_MatchText = 12
%uc_Pattern_MatchTally = 13
%uc_Pattern_SkipTally = 14

' String Library
%uc_StringLibNum = 230
%uc_StringLibStr = 231
%ucs_SetStringDefaults = 4
%ucs_Start = 5
%ucs_Limit = 6
%ucs_StartAfter = 7
%ucs_StopAfter = 8
%ucs_Between = 9
%ucs_Nth = 10
%ucs_File = 11
%ucs_Pos = 12
%ucs_Length = 13
%ucs_Text = 14
%ucs_Count = 15
%ucs_CountSkipped = 16
%ucs_InStr = 17
%ucs_Tally = 18
%ucs_UCase = 19
%ucs_LCase = 20
%ucs_MCase = 21
%ucs_Replace = 22
%ucs_Remove = 23
%ucs_Mid = 24
%ucs_Left = 25
%ucs_Right = 26
%ucs_Len = 27
%ucs_Extract = 28
%ucs_Remain = 29
%ucs_Skip = 30
%ucs_Delim = 31
%ucs_Retain = 32
%ucs_Range = 33
%ucs_Compare = 34
%ucs_Equals = 35
%ucs_Split = 36
%ucs_StringItem = 37
%ucs_StringItemCount = 38

' String Libarary Options
%ucByte = 1
%ucChar = 2
%ucWord = 4
%ucToken = 8
%ucBlock = 16
%ucExpr = 32
%ucQuote = 64
%ucSpace = 128
%ucCase = 256
' End Of String Library Options

' VB.NET: Public Delegate Sub ucFunctionDelegate(ByVal Expr As Integer)
' VB.NET: Public Delegate Function ucErrorHandlerDelegate(ByVal t As Integer) As Integer
' VB.NET: Public Delegate Function ucCheckForStop(ByVal FindContext As Integer, ByVal t As Integer) As Integer

#If %Def(%ucMakeOrDebug)
   Global ucIsInitialized As Long, ucString, ucExtended As Dword
#EndIf

#If %Def(%ucDebug)
   Global ucLPCSTR, ucFixedString, ucDouble, ucSingle As Dword
   Global ucLong, ucDword, ucComplex, ucByte, ucTable, ucVoid, ucStack As Dword
   Global ucSortedList As Dword
#EndIf

' Main Functions

Function ucAddr Alias "ucAddr" (ByVal AddressIndex As Long) Export As Long
   Function = uCalc_(%uc_GetCodeAddr, "", AddressIndex)
End Function

Function uCalc_ Alias "uCalc" (ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) Export As Long
   If ucIsInitialized = %ucFalse Then Call ucInitialize()
   Function = uCalcIO("", ucCommand, IIf$(IsMissing(TextIn), "", TextIn), a, b, c, t)
End Function
' Function uCalc2 Alias "uCalc" (ByVal ucCommand As Long, ByRef TextIn As String, ByVal a As ucCheckForStop, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) Export As Long
' Function uCalc3 Alias "uCalc" (ByVal ucCommand As Long, ByRef TextIn As String, ByVal a As ucFunctionDelegate, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) Export As Long

' Insert Other Exports
' Function ExceptionHelper Alias "ExceptionHelper" (ByVal Expr As Long, ByVal SystemError As Long) Export As Long
' Function ucEvaluate Alias "ucEvaluate" (ByVal Item As Long) Export As Extended
' Function ucArgLng Alias "ucArgLng" (ByVal Expr As Long, ByVal index As Long) Export As Long
' Function ucArg Alias "ucArg" (ByVal Expr As Long, ByVal index As Long) Export As Extended
' Sub ucArgStr_ Alias "ucArgStr" (ByRef ReturnStr As String, ByVal Expr As Long, ByVal index As Long) Export
' Function ucArgHandle Alias "ucArgHandle" (ByVal Expr As Long, ByVal index As Long) Export As Long
' Function ucArgCount Alias "ucArgCount" (ByVal Expr As Long) Export As Long
' Sub ucReturnLng Alias "ucReturnLng" (ByVal Expr As Long, ByVal ReturnValue As Long) Export
' Sub ucReturnDbl Alias "ucReturnDbl" (ByVal Expr As Long, ByVal ReturnValue As Double) Export
' Sub ucReturnExt Alias "ucReturnExt" (ByVal Expr As Long, ByVal ReturnValue As Extended) Export
' Sub ucReturnStr Alias "ucReturnStr" (ByVal Expr As Long, ByRef ReturnValue As String) Export
' Function ucGetVariableValue Alias "ucGetVariableValue" (ByVal Item As Long) Export As Extended
' Function ucGetVariableValueLng Alias "ucGetVariableValueLng" (ByVal Item As Long) Export As Long
' Sub ucGetVariableValueStr_ Alias "ucGetVariableValueStr" (ByRef ReturnStr As String, ByVal Item As Long) Export
' Sub ucSetVariableValueLng Alias "ucSetVariableValueLng" (ByVal Item As Long, ByVal NewValue As Long) Export
' Sub ucSetVariableValueDbl Alias "ucSetVariableValueDbl" (ByVal Item As Long, ByVal NewValue As Double) Export
' Sub ucSetVariableValueExt Alias "ucSetVariableValueExt" (ByVal Item As Long, ByVal NewValue As Extended) Export
' Sub ucSetVariableValueStr Alias "ucSetVariableValueStr" (ByVal Item As Long, ByRef NewValue As String) Export
' Function ucExprThread Alias "ucExprThread" (ByVal Expr As Long) Export As Long
' Function ucLicense Alias "ucLicense" (ByVal Product As Long, Optional ByVal L1 As Dword, Optional ByVal L2 As Dword, Optional ByVal L3 As Dword, Optional ByVal L4 As Dword, Optional ByVal L5 As Dword) Export As Long
' End Insert

Sub uCalcStr_ Alias "uCalcStr" (ByRef ReturnStr As String, ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) Export
   If ucIsInitialized = %ucFalse Then Call ucInitialize()
   uCalcIO(ReturnStr, ucCommand, IIf$(IsMissing(TextIn), "", TextIn), a, b, c, t)
End Sub

Function ucClose32bitDLL Alias "ucClose32bitDLL" (ByVal ReserverdArg As Long) Export As Long
   Function = %True ' Causes the 32-bit DLL to be closed by the 64-bit DLL IPC caller (process terminates when Close32bitDLL = %True)
End Function

Function ucDefine Alias "ucDefine" (ByRef Definition As String, Optional ByVal Arg1 As Long, Optional ByVal Arg2 As Long, Optional ByVal Arg3 As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Define, Definition, Arg1, Arg2, Arg3, t)
End Function

Function ucDefineConstant Alias "ucDefineConstant" (ByRef Definition As String, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Define, "Var: " + Definition , %ucLock, 0, 0, t)
End Function

Function ucDefineFunction Alias "ucDefineFunction" (ByRef Definition As String, Optional ByVal FunctionAddress As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Define, "Func: " + Definition + IIf$(FunctionAddress, " At" + Str$(FunctionAddress), ""), 0, 0, 0, t)
End Function

Function ucDefineOperator Alias "ucDefineOperator" (ByRef Definition As String, Optional ByVal FunctionAddress As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Define, "Op: " + Definition + IIf$(FunctionAddress, " At" + Str$(FunctionAddress), ""), 0, 0, 0, t)
End Function

Function ucDefineSyntax Alias "ucDefineSyntax" (ByRef Definition As String, Optional ByVal Rank As Long, Optional ByVal t As Long) Export As Long
   If Rank = 0 Then Rank = 1
   Function = uCalc_(%uc_DefineSyntax, Definition, Rank, 0, 0, t)
End Function

Function ucDefineVariable Alias "ucDefineVariable" (ByRef Definition As String, Optional ByVal VarAddress As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Define, "Var: " + Definition + IIf$(VarAddress, " At" + Str$(VarAddress), ""), 0, 0, 0, t)
End Function

Function ucEval Alias "ucEval" (ByRef Expr As String, Optional ByVal t As Long) Export As Extended
   Dim Answer As Extended

   uCalc_(%uc_Eval, Expr, 0, 0, VarPtr(Answer), t)
   Function = Answer
End Function

Sub ucEvalStr_ Alias "ucEvalStr" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long) Export
   uCalcStr_(ReturnStr, %uc_EvalStr, Expr, ExprType, 0, 0, t)
End Sub

Sub ucEvaluateStr_ Alias "ucEvaluateStr" (ByRef ReturnStr As String, ByVal ucItem As Long) Export
   uCalcStr_(ReturnStr, %uc_EvaluateStr, "", ucItem)
End Sub

Sub ucExpand_ Alias "ucExpand" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal t As Long) Export
   uCalcStr_(ReturnStr, %uc_Expand, Expr, 0, 0, 0, t)
End Sub

Function ucFPU Alias "ucFPU" (ByVal FPU_Command As Long, Optional ByVal FPU_Option As Long) Export As Long
   Function = uCalc_(FPU_Command, "", FPU_Option)
End Function

Function ucGetTrigMode Alias "ucGetTrigMode" () Export As Long
   Function = uCalc_(%uc_TrigMode, "", %uc_ReturnTrigMode)
End Function

Function ucInitialize Alias "ucInitialize" (Optional ByVal NewThread As Long) Export As Long
   Dim TempAddress64 As Quad

   If ipc_Address64 Then ' For 64-bit error handler (because ipc_Address64 gets sets to 0 if ucAddErrorHandler is the very first call)
      TempAddress64 = @ipc_Address64
      @ipc_Address64 = 0
   End If

   uCalc(%uc_License, "", %uc_License_FMP_Standard_32, 1)
   ucIsInitialized = uCalc(%uc_SetDefaultThread, "", NewThread)
   Function = ucIsInitialized

   ucSetErrorMessage %uc_Err_None,                    "No error"
   ucSetErrorMessage %uc_Err_Syntax_Error,            "Syntax error"
   ucSetErrorMessage %uc_Err_Undefined_Identifier,    "Undefined identifier"
   ucSetErrorMessage %uc_Err_FileNotFound,            "File not found"
   ucSetErrorMessage %uc_Err_Unrecognized_Token,      "Unrecognized token"
   ucSetErrorMessage %uc_Err_Unrecognized_Command,    "Unrecognized command"
   ucSetErrorMessage %uc_Err_Datatype_Mismatch,       "Data type mismatch"
   ucSetErrorMessage %uc_Err_CodeBlock_Error,         "Code block delimiter error"
   ucSetErrorMessage %uc_Err_Invalid_Argument_Count,  "Invalid number of arguments"
   ucSetErrorMessage %uc_Err_Invalid_Definition,      "Invalid definition"
   ucSetErrorMessage %uc_Err_Undefined_Callback,      "Undefined callback"
   ucSetErrorMessage %uc_Err_ErrMsgAlreadyDefined,    "Error message already defined"
   ucSetErrorMessage %uc_Err_ItemCannotBeModified,    "This item cannot be modified"
   ucSetErrorMessage %uc_Err_Unrecognized_Member,     "Unrecognized member"
   ucSetErrorMessage %uc_Err_Unbalanced_Quote,        "Unbalanced quote"
   ucSetErrorMessage %uc_Err_Array_Bounds_Exceeded,   "Array or list bound exceeded"
   ucSetErrorMessage %uc_Err_Float_Denormal_Operand,  "Denormal operand"
   ucSetErrorMessage %uc_Err_Float_Divide_By_Zero,    "Division by 0"
   ucSetErrorMessage %uc_Err_Float_Inexact_Result,    "Inexact result"
   ucSetErrorMessage %uc_Err_Float_Invalid_Operation, "Invalid operation"
   ucSetErrorMessage %uc_Err_Float_Overflow,          "Floating point overflow"
   ucSetErrorMessage %uc_Err_Float_Stack_Check,       "Floating point stack error"
   ucSetErrorMessage %uc_Err_Float_Underflow,         "Floating point underflow"
   ucSetErrorMessage %uc_Err_Integer_Divide_By_Zero,  "Integer division by 0"
   ucSetErrorMessage %uc_Err_Integer_Overflow,        "Integer overflow"
   ucSetErrorMessage %uc_Err_Privileged_Instruction,  "Privileged instruction denied"

   ucDefine("DefSeparator: ~~")
   ucDefine("SyntaxEqual: ::=")

   ' Extended, Double, and Single must be defined in that order, and prior to other types.
   ucExtended = ucDefine("DataType: Extended ~~ Size: 10 ~~ TypeHandler: #", ucAddr(%uc_Extended))
   ucDouble   = ucDefine("DataType: Double   ~~ Size: 8  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Double), ucAddr(%uc_Convert_Double_Extended))
   ucSingle   = ucDefine("DataType: Single   ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Single), ucAddr(%uc_Convert_Single_Extended))
   ucLong     = ucDefine("DataType: Long     ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int32),  ucAddr(%uc_Convert_Int32_Extended))
   ucDword    = ucDefine("DataType: Dword    ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int32u), ucAddr(%uc_Convert_Int32u_Extended))
   ucBoolean  = ucDefine("DataType: Boolean  ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int32),  ucAddr(%uc_Convert_Int32_Extended))
   ucString   = ucDefine("DataType: String   ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: LPCSTR ~~ Overhead", ucAddr(%uc_String))
   ucWideString = ucDefine("DataType: WideString ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: String", ucAddr(%uc_String_Wide))
   ucString = ucDefine("DataType: String ~~ ConvertsTo: WideString")
   ucFixedString = ucDefine("DataType: FixedString ~~ TypeHandler: # ~~ ConvertsTo: String ~~ ConvertsFrom: String", ucAddr(%uc_String_Fixed))
   ucByte     = ucDefine("DataType: Byte     ~~ Size: 1  ~~ TypeHandler: # ~~ ConvertsTo: Extended, #", ucAddr(%uc_Int8u), ucAddr(%uc_Convert_Int8u_Extended))
   ucLPCSTR   = ucDefine("DataType: LPCSTR               ~~ TypeHandler: # ~~ ConvertsTo: String", ucAddr(%uc_String_LPCSTR))
   ucStack    = ucDefine("DataType: Stack    ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: SortedList, #", ucAddr(%uc_Stack), ucAddr(%uc_Convert_Stack_SortedList))
   ucStack    = ucDefine("DataType: Stack ~~ ConvertsTo: Table, #", ucAddr(%uc_Convert_Stack_Table))
   ucSortedList = ucDefine("DataType: SortedList ~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Stack, #", ucAddr(%uc_SortedList), ucAddr(%uc_Convert_SortedList_Stack))
   ucTable    = ucDefine("DataType: Table~~ Size: 4  ~~ TypeHandler: # ~~ ConvertsTo: Stack, #", ucAddr(%uc_Table), ucAddr(%uc_Convert_Table_Stack))
   ucVoid     = ucDefine("DataType: Void ~~ Size: 10 ~~ TypeHandler: # ~~ ConvertsTo: Extended", ucAddr(%uc_Void))
   ucOmni     = ucDefine("DataType: OmniType ~~ Size: 4 ~~ TypeHandler: # ~~ ConvertsToAny ~~ ConvertsFromAny", ucAddr(%uc_String))

   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Long, #", ucAddr(%uc_Convert_Extended_Int32))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Dword, #", ucAddr(%uc_Convert_Extended_Int32))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Boolean, #", ucAddr(%uc_Convert_Extended_Int32))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Double, #", ucAddr(%uc_Convert_Extended_Double))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Single, #", ucAddr(%uc_Convert_Extended_Single))
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Byte")
   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Void")

   ucDword = ucDefine("DataType: Dword ~~ ConvertsTo: Long")
   ucDefine("DataType: Byte ~~ ConvertsTo: Long")
   ucDefine("DataType: Double ~~ ConvertsFrom: Single ~~ ConvertsTo: Single")
   ucDefine("DataType: Double ~~ ConvertsFrom: Byte ~~ ConvertsTo: Byte")
   ucDefine("DataType: Double ~~ ConvertsFrom: Dword ~~ ConvertsTo: Dword")
   ucDefine("DataType: Double ~~ ConvertsFrom: Long ~~ ConvertsTo: Long")

   ucDefine("Token:\x01.")            ' # Special tokens
   ucDefine("Token:\x01[\x15-\x20]....")     ' # Other special tokens
   ucDefine("Token:\x01\x01 ~~ \x01\x01 ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Token:\x01\x0B ~~ \x01\x0C", %ucCodeBlock)
   ucDefine("Token: [~:]")
   ucDefine("Token: :=")
   ucDefine("Token:\[ ~~ \]", %ucCodeBlock)
   ucDefine("Token:\{ ~~ \} ~~ DataType: #2 ~~ Address: #3", %ucCodeBlock, ucStack, ucAddr(%uc_Func_Populate_Stack))
   ucDefine("Token:[\q] ~~ [\q] ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Token:['] ~~ ['] ~~ DataType: #2", %ucQuotedText+%ucLiteral, ucString)
   ucDefine("Token:[\r]?\n", %ucStatementSep) ' Carriage Return
   ucDefine("Token:;", %ucStatementSep)
   ucDefine("Token:~t", %ucCurrentThread)
   ucDefine("Token:~d", %ucDefSpace)
   ucDefine("Token:~e", %ucEvalSpace)
   ucDefine("Token:~Define", %ucDefineNow)
   ucDefine("Token:~Eval", %ucEvalInsert)
   ucDefine("Token:~Eval_1 ~~ PassOnce", %ucEvalInsert)
   ucDefine("Token:~Eval_P", %ucEvalDuringParse)
   ucDefine("Token:~Expand", %ucExpandInsert)
   ucDefine("Token:~Expand_1 ~~ PassOnce", %ucExpandInsert)
   ucDefine("Token:~FileInclude", %ucFileInclude)
   ucDefine("Token:~Local", %ucLocalVar)
   ucDefine("Token:~Static", %ucStaticVar)
   ucDefine("Token:~TempDef", %ucTempDef)
   ucDefine("Token:\.", %ucMemberAccess+%ucInfix)
   ucDefine("Token:\~\~", %ucStatementSep)
   ucDefine("Token:,", %ucArgSeparator)
   ucDefine("Token:\( ~~ \)", %ucCodeBlock)
   ucDefine("Token:[ \t]+", %ucWhiteSpace)
   ucDefine("Token:[\|+/*^$&#\-=%@!`\\<>?]+", %ucReducible)  ' For operators
   ucDefine("Token:[0-9]+\.? ~~ DataType: #2", %ucLiteral, ucExtended) ' Numeric
   ucDefine("Token:([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)? ~~ DataType: #2", %ucLiteral, ucExtended) ' Numeric
   ucDefine("Token:[a-z_][0-9a-z_]* ~~ Name: AlphaNum", %ucAlphaNumeric)

' +++   ucDefineSyntax "Number ::= Extended"

   ucDefineSyntax "Op: {Name} '{' {Operand} '}' [As {type}] ::=" _ ' Prefix Operator
                 +"Name: {Name} ~~ Param: {Operand} ~~ DataType: {type} ~~ Properties: " + Str$(%ucPrefix+%ucOperator)
   ucDefineSyntax "Op: '{' {Operand} '}' {Name} [As {type}] ::=" _ ' Postfix Operator
                 +"Name: {Name} ~~ Param: {Operand} ~~ DataType: {type} ~~ Properties: " + Str$(%ucPostfix+%ucOperator)
   ucDefineSyntax "Op: '{' {LeftOp} '}' {Name} '{' {RightOp} '}' [As {type}] ::=" _ ' Infix Operator
                 +"Name: {Name} ~~ Param: {LeftOp} ~~ Param: {RightOp} ~~ DataType: {type} ~~ Properties: " + Str$(%ucInfix+%ucOperator)

   ucDefineSyntax "Op: {Def} { ':=' {Expr:'.+'} || At {addr} } ::= Op: {Def} {addr: ~~ Address: {addr} ~~ StdCall} {Expr: ~~ FuncBody: {Expr}}"
   ucDefineSyntax "Op: {pValue:' *[0-9]+ '} {Def} ::= Precedence: {pValue} ~~ Op: {Def}"
   ucDefineSyntax "Op: Precedence({op}) ::= Op: ~Eval(Precedence({op}))"
   ucDefineSyntax "Op:: {Def:'.+'} ::= NativeCall ~~ Address: # ~~ Op: {Def}"
   ucDefineSyntax "Op: Native: {Def} At {Addr} ::= NativeCall ~~ Address: {Addr} ~~ Op: {Def}"

   ucDefineSyntax "Var: {VarName:1} [As {Type:1}] [= {Value}] [At {Addr:' .+'}] ::=" _
                  +"Name: {VarName} ~~ Variable" _
                  +"{Type: ~~ DataType: {Type}}" _
                  +"{Value: ~~ Value: {Value}}" _
                  +"{Addr: ~~ Address: {Addr}}"
   ucDefineSyntax "Var: {VarName:1} As AnyType ::= AnyType ~~ Var: {VarName}"
   ucDefineSyntax "Var: {PassBy:'( +ByRef)|( +ByVal)|( +ByHandle)|( +ByExpr)'} ::= {PassBy} ~~ Var:"
   ucDefineSyntax "Var: {Def} ... ::= Var: {Def} ~~ VariableArgList"
   ucDefineSyntax "Var: ... ::= Var: _ ~~ VariableArgList"
   ucDefineSyntax "Var: {name:1} = {quote:' *[\x22\x27]'} ::= Var: {name} As String = {quote}"
   ucDefineSyntax "Const: {Def:'.*'} ::= Lock ~~ Var: {Def}"

   ucDefineSyntax "Func: {FuncName:1} ([{ParamList}]) [As {type:1}] [{ = {Def:'.+'} || At {addr} }] ::= " _
                  +"Name: {FuncName} ~~ Params: ({ParamList}) ~~ DataType: {type}" _
                  +"~~ Properties: " + Str$(%ucFunction + %ucPrefix) _
                  +"{addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}"
   ucDefineSyntax "Func:: {Def:'.+'} ::= NativeCall ~~ Address: # ~~ Func: {Def}"
   ucDefineSyntax "Func: Native: {Def} At {Addr} ::= NativeCall ~~ Address: {Addr} ~~ Func: {Def}"

   ucDefineSyntax "Params: ([{SingleParam+}]) ::= IsParam ~~ { {SingleParam: Var: {SingleParam}} }"
   ucDefineSyntax "Params: ({Variable} = {Default}) ::= Params: ({Variable} ~~ TextData: {Default})"
   ucDefineSyntax "Params: ({Param1}, {OtherParams}) ::= Params: ({Param1}) ~~ Params: ({OtherParams})"
   ucDefineSyntax "Param: {ParamDef} [~~] ::= IsParam ~~ { Var: {ParamDef} } ~~ "

   ucDefine("Op: +{x} := x ~~ Precedence: 70")
   ucDefine("Op:: -{x}     ~~ Precedence: 70", ucAddr(%uc_Op_Negate))
   ucDefine("Op:: {x As String}+{y As String} As String ~~ Precedence: 50", ucAddr(%uc_Op_StrConcat))
   ucDefine("Op:: {x As Long}+{y As Long} As Long ~~ Precedence: 50", ucAddr(%uc_Op_Add_Int32))
   ucDefine("Op:: {s As String}*{count} As String ~~ Precedence: 60", ucAddr(%uc_Op_StringMult))

   ucDefine("Precedence: 100 ~~ Syntax: {variable}++ {@End} ::= (SetVar({variable}, {variable}+1); {variable}-1)")
   ucDefine("Precedence: 100 ~~ Syntax: {variable}-- {@End} ::= (SetVar({variable}, {variable}-1); {variable}+1)")
   ucDefine("Precedence: 1   ~~ Syntax: {Arg1} {Op: + | - | * | / }= {Arg2} ::= SetVar({Arg1}, {Arg1} {Op} ({Arg2}))")

   ucExtended = ucDefine("DataType: Extended ~~ ConvertsTo: Complex, #", ucAddr(%uc_Convert_Extended_Complex))
   ucComplex  = ucDefine("DataType: Complex ~~ {Var: Real As Extended} ~~ {Var: Imag As Extended = 1} ~~ TypeHandler: #", ucAddr(%uc_Complex))
   ucDefine("Token:#i ~~ DataType: #2", %ucLiteral, ucComplex)
   ucDefine("Op:: {x As Complex}+{y As Complex} As Complex ~~ Precedence: 50", ucAddr(%uc_Op_Add_Complex))
   ucDefine("Op:: {x As Complex}*{y As Complex} As Complex ~~ Precedence: 60", ucAddr(%uc_Op_Multiply_Complex))

   ucDefine("Op:: {x}>{y}  As Long ~~ Precedence: 40", ucAddr(%uc_Op_GreaterThan))
   ucDefine("Op:: {x}<{y}  As Long ~~ Precedence: 40", ucAddr(%uc_Op_LessThan))
   ucDefine("Op:: {x}>={y} As Long ~~ Precedence: 40", ucAddr(%uc_Op_GreaterOrEqual))
   ucDefine("Op:: {x}<={y} As Long ~~ Precedence: 40", ucAddr(%uc_Op_LessOrEqual))
   ucDefine("Op:: {x}<>{y} As Long ~~ Precedence: 40", ucAddr(%uc_Op_NotEqual))
   ucDefine("Op:: {x}=={y} As Long ~~ Precedence: 40", ucAddr(%uc_Op_Equal))

   ucDefine("Op:: {x As String}>{y As String}  As Long ~~ Precedence: 40", ucAddr(%uc_Op_GreaterThan_Str))
   ucDefine("Op:: {x As String}<{y As String}  As Long ~~ Precedence: 40", ucAddr(%uc_Op_LessThan_Str))
   ucDefine("Op:: {x As String}>={y As String} As Long ~~ Precedence: 40", ucAddr(%uc_Op_GreaterOrEqual_Str))
   ucDefine("Op:: {x As String}<={y As String} As Long ~~ Precedence: 40", ucAddr(%uc_Op_LessOrEqual_Str))
   ucDefine("Op:: {x As String}<>{y As String} As Long ~~ Precedence: 40", ucAddr(%uc_Op_NotEqual_Str))
   ucDefine("Op:: {x As String}=={y As String} As Long ~~ Precedence: 40", ucAddr(%uc_Op_Equal_Str))

   ucDefine("Op:: Not {x As Long}                 As Long ~~ Precedence: 35", ucAddr(%uc_Op_Not_Int32))
   ucDefine("Op:: {x As Long} And     {y As Long} As Long ~~ Precedence: 30", ucAddr(%uc_Op_And_Int32))
   ucDefine("Op:: {x}         AndAlso {ByExpr y}          ~~ Precedence: 30", ucAddr(%uc_Op_AndAlso))
   ucDefine("Op:: {x As Long} Or      {y As Long} As Long ~~ Precedence: 20", ucAddr(%uc_Op_Or_Int32))
   ucDefine("Op:: {x}         OrElse  {ByExpr y}          ~~ Precedence: 20", ucAddr(%uc_Op_OrElse))
   ucDefine("Op:: {x As Long} Xor     {y As Long} As Long ~~ Precedence: 20", ucAddr(%uc_Op_Xor_Int32))
   ucDefine("Op:: {x As Long} Eqv     {y As Long} As Long ~~ Precedence: 19", ucAddr(%uc_Op_Eqv_Int32))
   ucDefine("Op:: {x As Long} Imp     {y As Long} As Long ~~ Precedence: 18", ucAddr(%uc_Op_Imp_Int32))

   ucDefine("Op:: {x}+{y} ~~ Precedence: 50", ucAddr(%uc_Op_Add))
   ucDefine("Op:: {x}-{y} ~~ Precedence: 50", ucAddr(%uc_Op_Subtract))
   ucDefine("Op:: {x}*{y} ~~ Precedence: 60", ucAddr(%uc_Op_Multiply))
   ucDefine("Op:: {x}/{y} ~~ Precedence: 60", ucAddr(%uc_Op_Divide))
   ucDefine("Op:: {x} Mod {y} ~~ Precedence: 60", ucAddr(%uc_Op_Mod))
   ucDefine("Op:: {x}^{y} ~~ Precedence: 80", ucAddr(%uc_Op_PowerOf_ExtToExt))

   ucDefine("Op:: {x As Long}!  ~~ Precedence: 90", ucAddr(%uc_Op_Factorial))
   ucDefine("Op:: {x As Long}\{y As Long} As Long ~~ Precedence: 60", ucAddr(%uc_Op_Divide_Int32))

   ucDefine("Func:: Sin(x)", ucAddr(%uc_Func_Sin))
   ucDefine("Func:: Cos(x)", ucAddr(%uc_Func_Cos))
   ucDefine("Func:: Tan(x)", ucAddr(%uc_Func_Tan))
   ucDefine("Func:: Atan(x)", ucAddr(%uc_Func_Atan))
   ucDefine("Func:: Abs(x)", ucAddr(%uc_Func_Abs))
   ucDefine("Func:: Exp(x)", ucAddr(%uc_Func_Exp))
   ucDefine("Func:: Log(x)", ucAddr(%uc_Func_Log))
   ucDefine("Func:: Ceil(x) As Long", ucAddr(%uc_Func_Ceil))
   ucDefine("Func:: Sqr(x)", ucAddr(%uc_Func_SquareRoot))
   ucDefine("Func:: Int(x)", ucAddr(%uc_Func_Int))
   ucDefine("Func:: Frac(x)", ucAddr(%uc_Func_Frac))
   ucDefine("Func:: Sgn(x)", ucAddr(%uc_Func_Sgn))
   ucDefine("Func:: Rand(x = 1)", ucAddr(%uc_Func_Rand))
   ucDefine("Func:: Rand(x As Long, y As Long)", ucAddr(%uc_Func_Rand))

   ucDefine("Func:: Min(x ...)", ucAddr(%uc_Func_Min))
   ucDefine("Func:: Max(x ...)", ucAddr(%uc_Func_Max))
   ucDefine("Func:: Min(x As String ...) As String", ucAddr(%uc_Func_Min_Str))
   ucDefine("Func:: Max(x As String ...) As String", ucAddr(%uc_Func_Max_Str))

   ucDefine("Func:: BaseConvert(Number As String, Base As Long)", ucAddr(%uc_Func_BaseConvert))

'   ucDefine "Func:: iif(cond As Long, ByExpr TruePart As Void, ByExpr FalsePart As AnyType = '') As String", ucAddr(%uc_Func_IIF_Str)
   ucDefine "Func:: iif(cond As Long, ByExpr TruePart As String, ByExpr FalsePart As String = '') As String", ucAddr(%uc_Func_IIF_Str)
   ucDefine "Func:: iif(cond As Long, ByExpr TruePart, ByExpr FalsePart = 0)", ucAddr(%uc_Func_IIF)
   ucDefine "Func: Inf() = 1/0"
   ucDefine "Func: NaN() = 0/0"

   ucDefine "Func:: Error(Message As String)", ucAddr(%uc_Raise_Error)
   ucDefine "Func:: ucAddr(index)", ucAddr(%uc_Func_ucAddr)
   ucDefine "Func:: ValueAtAddr(DataType As Dword, Address As Dword, Index As Long = 0)", ucAddr(%uc_Func_ValueAtAddr)
   ucDefine "Func:: SpecialArg(Value As Dword)", ucAddr(%uc_Func_SpecialArg)
   ucDefine "Func:: uc_Peek(Address As Dword, Count As Long) As String", ucAddr(%uc_Func_Peek)
   ucDefine "Func:: VarPtr(Item As AnyType) As Dword", ucAddr(%uc_Func_VarPtr)
   ucDefine "Func:: PatternNum(Choice As Long, Index As Long = 0, t As Long = ~d)", ucAddr(%uc_Func_PatternNum)
   ucDefine "Func:: PatternStr(Choice As Long, Index As Long = 0, t As Long = ~d) As String", ucAddr(%uc_Func_PatternStr)
   ucDefine "Func: StrPtr(ByRef Item As String) As Dword = ValueAtAddr(Dword, VarPtr(Item))"

   ucDefine "Var: NullStr As String At #", ucAddr(%uc_NullString)
   ucDefine "Func:: uCalc(Command As Long, TextArg As String = NullStr, MiscArg1 As Long = 0," _
           +"MiscArg2 As Long = 0, ReturnPtr As Long = 0, t As Long = ~t) As Dword", ucAddr(%uc_Func_uCalc)

   ucDefine "Func:: uCalcStr(Command As Long, TextArg As String = NullStr, MiscArg1 As Long = 0," _
           +"MiscArg2 As Long = 0, ReturnPtr As Long = 0, t As Long = ~t) As String", ucAddr(%uc_Func_uCalcStr)

   ucDefine "Syntax: Precedence({Item}) ::= uCalc("+Str$(%uc_GetItemData)+", {Item}, 0, "+Str$(%uc_Precedence)+", 0, {@Eval: ~t})"

   ucDefine "Func:: uc_Loop(ByExpr DoCondition, ByExpr Expression As AnyType, ByExpr LoopCondition) As Void", ucAddr(%uc_Func_Loop)
   ucDefine "Func:: uc_For(ByHandle Counter As AnyType, Start, Finish, Step, ByExpr Expr As AnyType) As Void", ucAddr(%uc_Func_For)

   ucDefine "Func: Asc(Character As String, Index As Long = 1) As Byte = ValueAtAddr(Byte, StrPtr(Character), Index-1)"
   ucDefine "Func: Chr(ASCII As Byte) As String = uc_Peek(VarPtr(ASCII), 1)"
   ucDefine "Syntax: Chr({a}, {b}) ::= Chr({a}) + Chr({b})"

   ucDefine "Var: _Number As String = '([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)?'"
   ucDefine "Var: _HexNumber As String = '([0-9a-z]*\.)?[0-9a-z]+(e[-+]?[0-9]+)?'"
   ucDefine "Var: _Alpha As String = '[a-z_][0-9a-z_]*'"
   ucDefine "Precedence: Precedence('*') ~~ Syntax: {Num:_Number}{Alpha:_Alpha} ::= {Num}*{Alpha}"
   ucDefine "Syntax: {'#b'}{Number:_Number} ::= ~Eval(BaseConvert('{Number}', 2))"
   ucDefine "Syntax: {'#o'}{Number:_Number} ::= ~Eval(BaseConvert('{Number}', 8))"
   ucDefine "Syntax: {'#h'}{Number:_HexNumber} ::= ~Eval(BaseConvert('{Number}', 16))"

   ucDefine "Const: True As Boolean At #", ucAddr(%uc_True)
   ucDefine "Const: False As Boolean = 0"

   ucDefine "Const: uc_Define = " + Str$(%uc_Define)
   ucDefine "Syntax: ucDefine({Def}) ::= uCalc(uc_Define, {Def}, 0, 0, 0, {@Eval: ~t})"
   ucDefine "Syntax: ucEval({Expr}) ::= uCalcStr(" + Str$(%uc_EvalStr) +", {Expr}, 0, 0, 0, {@Eval: ~t})"

   ucDefine "Syntax: Local([{' +'}]{Variable:'[^=, ]+'}[{etc}], {Expr}) ::= ~TempDef(Var: {Variable} {etc}) {Expr} ~Eval_P(ucRename('{Variable}', ''))"
   ucDefine "Syntax: Local({Variable1}, {OtherVariables}, {Expr}) ::= Local({Variable1}, Local({OtherVariables}, {Expr}))"

   ucDefine "Const: uc_DefineSyntax = " + Str$(%uc_DefineSyntax)
   ucDefine "Func:: SetSyntaxParams(Params As String, Expr As String, Properties As String = NullStr, t As Long = ~t) As String", ucAddr(%uc_Func_SetSyntaxParams)
   ucDefineSyntax "Macro: {name} [{args:'\([^\)]*\)'}] = {replacement} ::= Syntax: ~Eval(SetSyntaxParams('{args}', '{name}{args} ::= {replacement}', NullStr, {@Eval: ~t}))"

   ucDefine "Const: uc_GetItemData = " + Str$(%uc_GetItemData)
   ucDefine "Const: uc_SetItemData = " + Str$(%uc_SetItemData)
   ucDefine "Const: uc_SymbolName = " + Str$(%uc_SymbolName)
   ucDefine "Const: uc_Handle = " + Str$(%uc_Handle)
   ucDefine "Syntax: ucHandle({Item}) ::= uCalc(-uc_GetItemData, {Item}, 0, uc_Handle, 0, {@Eval: ~t})"
   ucDefine "Syntax: ucRename({OldName}, {NewName})" _
           +"::= uCalc(uc_SetItemData, {NewName}, ucHandle({OldName}), uc_SymbolName, 0, {@Eval: ~t})"

   ucDefine "Syntax: Dim {Item~} ::= ~Local(Var: {Item})"
   ucDefine "Syntax: Dim {FirstVar~}, {OtherVars~} ::= Dim {FirstVar}; Dim {OtherVars}"

'+++   Temp$ = "'Ok'" : uCalc_(%uc_SetTypeOutput, Temp$, ucVoid)

   ' Arrays
   ucDefine("Const: uc_Address = " + Str$(%uc_Address))
   ucDefine("Const: uc_DataType = " + Str$(%uc_DataType))
   ucDefineSyntax("Address({Item}) ::= ~Eval(uCalc(uc_GetItemData, '{Item}', 0, uc_Address, 0, {@Eval: ~t}))")
   ucDefineSyntax("DataType({Item})::= ~Eval(uCalc(uc_GetItemData, '{Item}', 0, uc_DataType, 0, {@Eval: ~t}))")

   ucDefineSyntax("Var: {ArrayName:1}({MaxIndex}) [{etc}]" _
   + "::= Count: {MaxIndex} ~~ Var: {ArrayName} {etc} ~~ NextDef ~~" _
   + "Syntax: {ArrayName}({Index}) ::= ValueAtAddr(DataType({ArrayName}), Address({ArrayName}), {Index})")

   ' Assign Value to Variable
   ' +++ Arg name Var (instead of MyVar) shouldn't cause a problem
   ' ucDefine("Precedence: 10 ~~ Syntax: {Variable} = {Value} ::= SetVar({Variable}, {Value})")
   ucDefine("Op:: {ByHandle MyVar As AnyType} = {ByHandle Value As AnyType} As Void ~~ Precedence: 10", ucAddr(%uc_SetVariableValueAnyType))
   ucDefine("Op:: {ByHandle MyVar As Extended} = {ByHandle Value As Extended} As Void ~~ Precedence: 10", ucAddr(%uc_SetVariableValueExtended))
   ucDefine("Func:: SetVar(ByHandle MyVar As AnyType,  ByHandle Value As AnyType)  As Void", ucAddr(%uc_SetVariableValueAnyType))
   ucDefine("Func:: SetVar(ByHandle MyVar As AnyType,  ByHandle Value As String)   As Void", ucAddr(%uc_SetVariableValueAnyType))
   ucDefine("Func:: SetVar(ByHandle MyVar As AnyType,  ByHandle Value As Extended) As Void", ucAddr(%uc_SetVariableValueAnyType))
   ucDefine("Func:: SetVar(ByHandle MyVar As Double,  ByHandle Value As Double) As Void", ucAddr(%uc_SetVariableValueDouble))
   ucDefine("Func:: SetVar(ByHandle MyVar As Extended, ByHandle Value As Extended) As Void", ucAddr(%uc_SetVariableValueExtended))

   ucDefine("Func: Omni(x as OmniType) As OmniType = x")
   ucDefine("Func: Str(Value As OmniType) As String = Value")
   ucDefine("Func: Val(Value As OmniType) As Extended = Value")

   ' Stack, Table, List type routines
   ucDefine("Func:: Push(StackName As Stack, ByHandle Data As AnyType, Index As Long = 0) As Long", ucAddr(%uc_Func_PushData_Stack))
'+++   ucDefine("Func:: PopHandle(StackName As Stack, Index As Long = 0) As Dword", ucAddr(%uc_Func_PopHandle_Stack))
   ucDefine("Func:: PopNum(StackName As Stack, Index = 0) As Extended", ucAddr(%uc_Func_PopNum_Stack))
   ucDefine("Func:: PopStr(StackName As Stack, Index = 0) As String", ucAddr(%uc_Func_PopStr_Stack))
   ucDefine("Func:: ReadHandle(TableName As Table, Index = 0) As Dword", ucAddr(%uc_Func_ReadHandle_Stack))
   ucDefine("Func:: ReadKey(TableName As Table, Index = 0) As String", ucAddr(%uc_Func_ReadStr_Stack))
   ucDefine("Func:: ReadNum(StackName As Stack, Index = 0) As Extended", ucAddr(%uc_Func_ReadNum_Stack))
   ucDefine("Func:: ReadNum(TableName As Table, Key As String) As Extended", ucAddr(%uc_ReadNum_Table))
   ucDefine("Func:: ReadStr(StackName As Stack, Index = 0) As String", ucAddr(%uc_Func_ReadStr_Stack))
   ucDefine("Func:: ReadStr(TableName As Table, Key As String) As String", ucAddr(%uc_ReadData_Table))
   ucDefine("Func:: Count(StackName As Stack) As Long", ucAddr(%uc_Func_Count_Stack))
   ucDefine("Func:: Count(ListName As SortedList) As Long", ucAddr(%uc_Func_Count_Stack))
   ucDefine("Func:: Count(TableName As Table) As Long", ucAddr(%uc_Func_Count_Stack))
   ucDefine("Func:: Index(ListName As SortedList, Text As String) As Long", ucAddr(%uc_Index_Table))
   ucDefine("Func:: Index(TableName As Table, Text As String) As Long", ucAddr(%uc_Index_Table))
   ucDefine("Func:: Insert(ListName As SortedList, Text As String) As Void", ucAddr(%uc_Insert_Table))
   ucDefine("Func:: Insert(TableName As Table, Text As String, ByHandle Data As AnyType = 0) As Void", ucAddr(%uc_Insert_Table))
   ucDefine("Func:: Delete(ListName As SortedList, Text As String)", ucAddr(%uc_Delete_Table))
   ucDefine("Func:: Delete(TableName As Table, Text As String)", ucAddr(%uc_Delete_Table))
   ucDefine("Func:: Handle(TableName As Table, Text As String) As Dword", ucAddr(%uc_Handle_Table))
   ucDefine("Func:: HandleB(TableName As String, Text As String, t As Long = ~t) As Dword", ucAddr(%uc_HandleB_Table))
'   ucDefine("Op:: {Stack1 As Stack} + {Stack2 As Stack} As Stack ~~ Precedence: Precedence('+')", ucAddr(%uc_Op_Concat_Stack))

   If ipc_Address64 Then @ipc_Address64 = TempAddress64
   FreeLicenseCount = 11
End Function

Function ucNewThread Alias "ucNewThread" (Optional ByVal ParentThread As Long, Optional ByVal MakeThisDefault As Long) Export As Long
   Dim OriginalThread As Long, NewThread As Long ' +++ Simplify this function (maybe)

   If ucIsInitialized = %False Then
      Function = uCalc_(%uc_GetDefaultThread)
      Exit Function
   End If

   OriginalThread = uCalc_(%uc_GetDefaultThread)
   NewThread = uCalc_(%uc_NewThread, "", ParentThread, MakeThisDefault)
   If ParentThread = 0 Then
      ucInitialize(NewThread)
      If MakeThisDefault = %ucFalse Then uCalc_(%uc_SetDefaultThread, "", OriginalThread)
   End If
   Function = NewThread
End Function

Function ucParse Alias "ucParse" (ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_Parse, Expr, ExprType, 0, 0, t)
End Function

Function ucReleaseItem Alias "ucReleaseItem" (ByVal ucItem As Long) Export As Long
   Function = uCalc_(%uc_ReleaseItem, "", ucItem)
End Function

Sub ucRun_ Alias "ucRun" (ByRef ReturnStr As String, ByRef RunOption As String, ByRef TextIn As String, Optional ByVal ExpandCount As Long, Optional ByVal t As Long) Export
   ucRunIO(ReturnStr, RunOption, TextIn, ExpandCount, t)
End Sub

Function ucSetOutput Alias "ucSetOutput" (Optional ByVal FunctionAddress As Long, Optional ByRef FuncName As String, Optional ByRef DataType As String, Optional ByVal t As Long) Export As Long
   If IsMissing(FuncName) Or Len(FuncName) = 0 Then ucDefine("Func:: Output__(Value As String, Item As Dword) As String", FunctionAddress)
   Function = uCalc_(%uc_SetTypeOutput, IIf$(IsMissing(FuncName) Or Len(FuncName) = 0, "Output__", FuncName), ucEval(IIf$(IsMissing(DataType) Or Len(DataType) = 0, "Extended", DataType), t), 0, 0, t)
End Function

Function ucSetTrigMode Alias "ucSetTrigMode" (ByVal TrigMode As Long) Export As Long
   Function = uCalc_(%uc_TrigMode, "", TrigMode)
End Function

' Error handling
Function ucAddErrorHandler Alias "ucAddErrorHandler" (Optional ByVal ErrorHandlerAddress As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_AddErrorHandler, "", ErrorHandlerAddress, 0, 0, t)
End Function
Function ucError Alias "ucError" (Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_GetErrorNumber, "", 0, 0, 0, t)
End Function
Sub ucErrorMessage_ Alias "ucErrorMessage" (ByRef ReturnStr As String, Optional ByVal ErrorNumber As Long, Optional ByVal t As Long) Export
   uCalcStr_(ReturnStr, %uc_GetErrorMessage, "", ErrorNumber, 0, 0, t)
End Sub
Sub ucErrorExpression_ Alias "ucErrorExpression" (ByRef ReturnStr As String, Optional ByVal t As Long) Export
   uCalcStr_(ReturnStr, %uc_GetErrorExpression, "", 0, 0, 0, t)
End Sub
Function ucErrorLocation Alias "ucErrorLocation" (ByVal t As Long) Export As Long
   Function = uCalc_(%uc_GetLocation, "", 0, 0, 0, t)
End Function
Sub ucErrorSymbol_ Alias "ucErrorSymbol" (ByRef ReturnStr As String, ByVal t As Long) Export
   uCalcStr_(ReturnStr, %uc_GetSymbol, "", 0, 0, 0, t)
End Sub
Function ucRaiseError Alias "ucRaiseError" (ByVal Expr As Long, ByVal ErrorNumber As Long) Export As Long
   Function = uCalc_(%uc_SetErrorNumber, "", ErrorNumber, Expr, 0, ucExprThread(Expr))
End Function
Function ucRaiseErrorMessage Alias "ucRaiseErrorMessage" (ByVal Expr As Long, ByRef ErrorMessage As String) Export As Long
   uCalc_(%uc_SetErrorMessage, ErrorMessage, %uc_Err_Dynamically_Defined, 0, 0, ucExprThread(Expr))
   Function = uCalc_(%uc_SetErrorNumber, "", %uc_Err_Dynamically_Defined, Expr, 0, ucExprThread(Expr))
End Function
Function ucSetError Alias "ucSetError" (ByVal ErrorNumber As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_SetErrorNumber, "", ErrorNumber, 0, 0, t)
End Function
Function ucSetErrorMessage Alias "ucSetErrorMessage" (ByVal ErrorIndex As Long, ByRef ErrorMessage As String, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_SetErrorMessage, ErrorMessage, ErrorIndex, 0, 0, t)
End Function
Function ucSetErrorNumber Alias "ucSetErrorNumber" (ByVal ErrorNumber As Long, Optional ByVal t As Long) Export As Long
   Function = uCalc_(%uc_SetErrorNumber, "", ErrorNumber, 0, 0, t)
End Function

' uCalc String Library
#Include "StringLibExport.Bas"

Function uCalcRaw Alias "uCalcRaw" (ByRef ReturnStr_ As String, ByVal uc As Long, ByRef TextIn As String, ByVal Misc1 As Long, ByVal Misc2 As Long, ByVal ReturnPtr As Long, ByVal tHandle As Long) Export As Long
   Function = uCalcIO(ReturnStr_, uc, TextIn, Misc1, Misc2, ReturnPtr, tHandle) ' +++ Move this function up afterwards
End Function

' Deprecated notations
' Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
' Deprecated ucParam Alias "ucArg" (ByVal ExprHandle As Long, ByVal Index As Long) Export As Extended
' Deprecated ucParamStr Alias "ucArgStr" (ByVal ExprHandle As Long, ByVal Index As Long) Export As String
' Deprecated ucParamCount Alias "ucArgCount" (ByVal ExprHandle As Long) Export As Long
' Deprecated ucParamHandle Alias "ucArgHandle" (ByVal ExprHandle As Long, ByVal Index As Long) Export As Long
' Deprecated ucErrLocation Alias "ucErrorLocation" (ByVal t As Long) Export As Long
' Deprecated ucErrSymbol Alias "ucErrorSymbol" (ByVal t As Long) Export As String
' Deprecated ucSetErrMsg Alias "ucSetErrorMessage" (ByVal Index As Long, ByRef Msg As String) Export As Long

' VB.NET: End Module
