// ---------------------------------------------------------------------------
// uCalcCB.h: C++ Builder header file for uCalc Fast Math Parser 4.00
// Designed for : C++ Builder XE
//                Add the following line to your code:
//                #include "uCalcCB.h" in your code.
//
// This file auto-generated by : CBuilder.uc using uCalc Transform 3.0
// Auto-generation timestamp: 08/14/14
// CBuilder.uc prepared by : Daniel Corbier
// Visit www.ucalc.com for additional resources.
// ---------------------------------------------------------------------------

#pragma once
#include <windows.h>
#include <oleauto.h>
using namespace std;

// Definition properties
const Int32 ucAlphaNumeric = 1;
const Int32 ucArgSeparator = 2;
const Int32 ucCodeBlock = 3;
const Int32 ucCodeBlockMatch = 4;
const Int32 ucMemberAccess = 5;
const Int32 ucQuotedText = 6;
const Int32 ucStatementSep = 7;
const Int32 ucWhiteSpace = 8;

const Int32 ucCurrentThread = 9;

const Int32 ucLocalVar = 10;
const Int32 ucStaticVar = 11;
const Int32 ucDefineNow = 11;
const Int32 ucTempDef = 12;
const Int32 ucEvalInsert = 13;
const Int32 ucEvalDuringParse = 14;
const Int32 ucExpandInsert = 15;
const Int32 ucFileInclude = 16;

const Int32 ucCurrentSpace = 17;
const Int32 ucDefSpace = 18;
const Int32 ucEvalSpace = 19;

const Int32 ucFunction = 64;
const Int32 ucOperator = 128;
const Int32 ucVariable = 256;
const Int32 ucSyntax = 512;
const Int32 ucLiteral = 1024;
const Int32 ucSymbol = 2048;
const Int32 ucReducible = 4096;
const Int32 ucLock = 8192;
const Int32 ucInfix = 16384;
const Int32 ucPrefix = 32768;
const Int32 ucPostfix = 49152;

// uCalc Commands
const Int32 uc_Define = 1;
const Int32 uc_DefineSyntax = 2;
const Int32 uc_Eval = 3;
const Int32 uc_EvalStr = 4;
const Int32 uc_Evaluate = 5;
const Int32 uc_EvaluateLng = 6;
const Int32 uc_EvaluateStr = 7;
const Int32 uc_GetCaseSensitivity = 8;
const Int32 uc_GetDefaultPass = 9;
const Int32 uc_GetDefaultPrecedence = 10;
const Int32 uc_GetDefaultRank = 11;
const Int32 uc_GetCodeAddr = 12;
const Int32 uc_GetDefaultThread = 13;
const Int32 uc_GetDefaultType = 14;
const Int32 uc_GetDefSeparator = 15;
const Int32 uc_GetDefSpace = 16;
const Int32 uc_GetErrorNumber = 17;
const Int32 uc_GetEvalSpace = 18;
const Int32 uc_GetParentThread = 20;
const Int32 uc_GetSyntaxEqual = 21;
const Int32 uc_Parse = 22;
const Int32 uc_ReleaseItem = 23;
const Int32 uc_SetCaseSensitivity = 24;
const Int32 uc_SetCodeAddr = 25;
const Int32 uc_SetDefaultPrecedence = 26;
const Int32 uc_SetDefaultRank = 27;
const Int32 uc_SetDefaultThread = 28;
const Int32 uc_SetDefaultType = 29;
const Int32 uc_SetDefSeparator = 30;
const Int32 uc_SetErrorNumber = 31;
const Int32 uc_SetParentThread = 32;
const Int32 uc_SetSyntaxEqual = 33;
const Int32 uc_NewThread = 34;

const Int32 uc_RegExWordBoundaryChars = 35;
const Int32 uc_RegExEscapeChar = 36;
const Int32 uc_License = 37;

// License options
const Int32 uc_License_Demo = 0;
const Int32 uc_License_FMP_Free = 1;
const Int32 uc_License_FMP_Standard_32 = 2;
const Int32 uc_License_FMP_Standard_64 = 3;
const Int32 uc_License_FMP_32_and_64 = 4;
const Int32 uc_License_LanguageBuilder = 5;
const Int32 uc_License_GeneralParser = 6;
const Int32 uc_License_Interpreter = 7;
const Int32 uc_License_ConsoleCalc = 8;
const Int32 uc_License_WindowsCalc = 9;
const Int32 uc_License_StringLib = 10;
const Int32 uc_License_Transform = 11;
const Int32 uc_License_TransformLib = 12;
const Int32 uc_License_Search = 13;
const Int32 uc_License_SearchLib = 14;
const Int32 uc_License_Library1 = 15;
const Int32 uc_License_Library2 = 16;
const Int32 uc_License_Beta = 17;
const Int32 uc_License_Debugger = 18;
const Int32 uc_License_uCalc_All = 50;
const Int32 uc_License_Developer = 100;
const Int32 uc_License_EndUser = 101;

const Int32 uc_AddDebugger = 39;
const Int32 Debug_ReleaseItem = 1;
const Int32 Debug_StdFuncCall = 2;
const Int32 Debug_UserFuncCall = 3;
const Int32 Debug_GetTextToken = 4;
const Int32 Debug_ErrorHandler = 5;
const Int32 Debug_ParseExpr = 6;
const Int32 Debug_ParseItem = 7;
const Int32 Debug_EvalOperation = 8;
const Int32 Debug_DefSyntax = 9;
const Int32 Debug_Define = 10;
const Int32 Debug_DefinePart = 11;
const Int32 Debug_Expand = 12;
const Int32 Debug_ExpandSuccess = 13;
const Int32 Debug_ExpandMiss = 14;
const Int32 Debug_ExpandFail = 15;
const Int32 Debug_GetSyntaxBlock = 16;
const Int32 Debug_GetCodeBlock = 17;
const Int32 Debug_LineNumber = 18;
const Int32 Debug_TotalTally = 19;
const Int32 Debug_Breakpoint = 20;
const Int32 Debug_Delay = 21;
const Int32 Debug_JumpTo = 22;
const Int32 Debug_StepAction = 23;

const Int32 uc_AddErrorHandler = 40;
const Int32 uc_GetSymbolTable = 41;
const Int32 uc_GetSteps = 42;
const Int32 uc_GetStepsCount = 43;

const Int32 uc_SetTypeOutput = 45;
const Int32 uc_Group = 46;
const Int32 uc_GetTag = 47;
const Int32 uc_SetTag = 48;

const Int32 uc_GetCallbackData = 50;
const Int32 uc_SetCallbackReturn = 51;

const Int32 uc_GetErrorExpression = 60;
const Int32 uc_SetExpression = 61;
const Int32 uc_GetSymbol = 62;
const Int32 uc_SetSymbol = 63;
const Int32 uc_GetLocation = 64;

const Int32 uc_GetTokenType = 65;
const Int32 uc_GetTokenProperties = 66;

const Int32 uc_TrigMode = 67;

const Int32 uc_ItemClone = 70;
const Int32 uc_DataConvert = 71;
const Int32 uc_DataCopy = 72;
const Int32 uc_DataAlloc = 72;
const Int32 uc_DataFree = 73;
const Int32 uc_DataReset = 74;

// FPU commands
const Int32 uc_SetFPU = 75;
const Int32 uc_SetFPU_HostProg = 76;
const Int32 uc_GetFPU = 77;
const Int32 uc_GetFPU_HostProg = 78;
const Int32 uc_ToggleFPU = 79;
const Int32 uc_ToggleFPU_HostProg = 80;

const Int32 uc_ErrorClear = 85;
const Int32 uc_RestoreErrorMessageBox = 86;

const Int32 uc_SetErrorMessage = 91;
const Int32 uc_GetErrorMessage = 92;

const Int32 uc_SerialNumber = 93;
const Int32 uc_SetTurbo = 94;
const Int32 uc_Expand = 95;
const Int32 uc_GetNextToken = 96;
const Int32 uc_GetItemData = 97;
const Int32 uc_SetItemData = 98;
const Int32 uc_GetThreadAddr = 99;
const Int32 uc_GetCodeBlock = 100;

const Int32 uc_Status_CurrentPass = 101;
const Int32 uc_Status_MaxPass = 102;
const Int32 uc_Status_Location = 103;
const Int32 uc_Status_NestedLevel = 104;
const Int32 uc_Status_TextLength = 105;

const Int32 uc_Find = 110;
const Int32 uc_FindAddMatch = 111;
const Int32 uc_FindGetIndex = 112;
const Int32 uc_FindGetCount = 113;
const Int32 uc_FindGetStart = 114;
const Int32 uc_FindGetLength = 115;
const Int32 uc_FindGetText = 116;
const Int32 uc_FindReset = 117;
const Int32 uc_FindReplace = 118;
const Int32 uc_FindFilter = 119;
const Int32 uc_FindSetFilter = 120;

const Int32 uc_FindFilterSort = 1;
const Int32 uc_FindFilterUnique = 2;
const Int32 uc_FindFilterTally = 4;
const Int32 uc_FindFilterSeparator = 8;
const Int32 uc_FindFilterStartText = 16;
const Int32 uc_FindFilterEndText = 32;

const Int32 uc_FindContext_Other = 0;
const Int32 uc_FindContext_Found = 1;
const Int32 uc_FindContext_Replaced = 2;

const Int32 uc_FindZoomIn = 1;
const Int32 uc_FindTransformInPlace = 2;

const Int32 uc_Properties = 1;
const Int32 uc_Thread = 2;
const Int32 uc_Address = 3;
const Int32 uc_SymbolName = 4;
const Int32 uc_Rank = 5;
const Int32 uc_Precedence = 6;
const Int32 uc_OverloadHandle = 7;
const Int32 uc_OverloadCount = 8;
const Int32 uc_ByteSize = 9;
const Int32 uc_ArgCount = 10;
const Int32 uc_DataType = 12;
const Int32 uc_Handle = 13;
const Int32 uc_Value = 14;
const Int32 uc_Property = 15;

// Error numbers
const Int32 uc_Err_None = 0;
const Int32 uc_Err_Dynamically_Defined = 1;
const Int32 uc_Err_Syntax_Error = 2;
const Int32 uc_Err_Undefined_Identifier = 3;
const Int32 uc_Err_FileNotFound = 4;
const Int32 uc_Err_Unrecognized_Token = 5;
const Int32 uc_Err_Unrecognized_Command = 6;
const Int32 uc_Err_Datatype_Mismatch = 7;
const Int32 uc_Err_Invalid_Argument_Count = 8;
const Int32 uc_Err_Invalid_Definition = 9;
const Int32 uc_Err_CodeBlock_Error = 10;
const Int32 uc_Err_Undefined_Callback = 11;
const Int32 uc_Err_ErrMsgAlreadyDefined = 12;
const Int32 uc_Err_ItemCannotBeModified = 13;
const Int32 uc_Err_Unrecognized_Member = 14;
const Int32 uc_Err_Unbalanced_Quote = 15;

const Int32 uc_Err_Array_Bounds_Exceeded = 20;
const Int32 uc_Err_Float_Denormal_Operand = 21;
const Int32 uc_Err_Float_Divide_By_Zero = 22;
const Int32 uc_Err_Float_Inexact_Result = 23;
const Int32 uc_Err_Float_Invalid_Operation = 24;
const Int32 uc_Err_Float_Overflow = 25;
const Int32 uc_Err_Float_Stack_Check = 26;
const Int32 uc_Err_Float_Underflow = 27;
const Int32 uc_Err_Integer_Divide_By_Zero = 28;
const Int32 uc_Err_Integer_Overflow = 29;
const Int32 uc_Err_Privileged_Instruction = 30;

// Error response
const Int32 ucAbort = 0;
const Int32 ucResume = 1;
const Int32 ucReRaise = 2;

// FPU Control Word Settings
const Int32 uc_FPU_Mask_InvalidOp = 1;
const Int32 uc_FPU_Mask_DenormalOp = 2;
const Int32 uc_FPU_Mask_ZeroDivide = 4;
const Int32 uc_FPU_Mask_Overflow = 8;
const Int32 uc_FPU_Mask_Underflow = 16;
const Int32 uc_FPU_Mask_PrecisionLoss = 32;

const Int32 uc_FPU_Precision_Single = 0;
const Int32 uc_FPU_Precision_Double = 256;
const Int32 uc_FPU_Precision_Extended = 768;

const Int32 uc_FPU_Round_Even = 0;
const Int32 uc_FPU_Round_Down = 1024;
const Int32 uc_FPU_Round_Up = 2048;
const Int32 uc_FPU_Round_Toward = 3072;

// Data type handler callback action modes
const Int32 uc_TypeHandler_Store = 2;
const Int32 uc_TypeHandler_StringOutput = 3;
const Int32 uc_TypeHandler_Free = 4;
const Int32 uc_TypeHandler_FuncRet = 5;
const Int32 uc_TypeHandler_Copy = 6;
const Int32 uc_TypeHandler_Alloc = 7;
const Int32 uc_TypeHandler_Reset = 8;

const Int32 uc_Callback_Undefined = 0;

// Data Type callbacks
const Int32 uc_Complex = 1;
const Int32 uc_Currency = 2;
const Int32 uc_Double = 3;
const Int32 uc_Extended = 4;
const Int32 uc_Int8 = 5;
const Int32 uc_Int8u = 6;
const Int32 uc_Int16 = 7;
const Int32 uc_Int16u = 8;
const Int32 uc_Int32 = 9;
const Int32 uc_Int32u = 10;
const Int32 uc_Int64 = 11;
const Int32 uc_Int64u = 12;
const Int32 uc_Single = 13;
const Int32 uc_String = 14;
const Int32 uc_String_LPCSTR = 15;
const Int32 uc_String_Fixed = 16;
const Int32 uc_String_Wide = 17;
const Int32 uc_Stack = 18;
const Int32 uc_Table = 19;
const Int32 uc_SortedList = 20;
const Int32 uc_Void = 21;
const Int32 uc_User_Type = 22;

const Int32 uc_Convert_Generic = 23;
const Int32 uc_Convert_Same = 24;
const Int32 uc_Convert_Double_Extended = 25;
const Int32 uc_Convert_Int8_Extended = 26;
const Int32 uc_Convert_Int8u_Extended = 27;
const Int32 uc_Convert_Int16_Extended = 28;
const Int32 uc_Convert_Int16u_Extended = 29;
const Int32 uc_Convert_Int32_Extended = 30;
const Int32 uc_Convert_Int32u_Extended = 31;
const Int32 uc_Convert_Int64_Extended = 32;
const Int32 uc_Convert_Int64u_Extended = 33;
const Int32 uc_Convert_Single_Extended = 34;
const Int32 uc_Convert_Void_Extended = 35;
const Int32 uc_Convert_Extended_Double = 37;
const Int32 uc_Convert_Extended_Single = 38;
const Int32 uc_Convert_Extended_Int16u = 39;
const Int32 uc_Convert_Extended_Int32 = 40;
const Int32 uc_Convert_Complex_Extended = 41;
const Int32 uc_Convert_Extended_Complex = 42;

// Default built-in routines
const Int32 uc_Op_Negate = 43;
const Int32 uc_Op_UnaryPlus = 44;
const Int32 uc_Op_Percentage = 45;
const Int32 uc_Op_StrConcat = 46;
const Int32 uc_Op_Add_Int32 = 47;
const Int32 uc_Op_Add = 48;
const Int32 uc_Op_Add_Complex = 49;
const Int32 uc_Op_Subtract_Int32 = 50;
const Int32 uc_Op_Subtract = 51;
const Int32 uc_Op_Multiply_Int32 = 52;
const Int32 uc_Op_Multiply = 53;
const Int32 uc_Op_Multiply_Complex = 54;
const Int32 uc_Op_Divide_Int32 = 55;
const Int32 uc_Op_Divide = 56;
const Int32 uc_Op_Mod_Int32 = 57;
const Int32 uc_Op_Mod = 58;
const Int32 uc_Op_PowerOf_ExtToExt = 59;
const Int32 uc_Op_PowerOf_ExtToLng = 60;
const Int32 uc_Op_PowerOf_CplxToCplx = 61;

const Int32 uc_Op_GreaterThan = 62;
const Int32 uc_Op_GreaterOrEqual = 63;
const Int32 uc_Op_LessThan = 64;
const Int32 uc_Op_LessOrEqual = 65;
const Int32 uc_Op_Equal = 66;
const Int32 uc_Op_NotEqual = 67;

const Int32 uc_Op_GreaterThan_Str = 68;
const Int32 uc_Op_GreaterOrEqual_Str = 69;
const Int32 uc_Op_LessThan_Str = 70;
const Int32 uc_Op_LessOrEqual_Str = 71;
const Int32 uc_Op_Equal_Str = 72;
const Int32 uc_Op_NotEqual_Str = 73;

const Int32 uc_Op_Not_Int32 = 74;
const Int32 uc_Op_And_Int32 = 75;
const Int32 uc_Op_Or_Int32 = 76;
const Int32 uc_Op_Xor_Int32 = 77;
const Int32 uc_Op_Eqv_Int32 = 78;
const Int32 uc_Op_Imp_Int32 = 79;

const Int32 uc_Op_AndAlso = 80;
const Int32 uc_Op_OrElse = 81;

const Int32 uc_Op_Factorial = 82;

const Int32 uc_Func_IIf = 83;
const Int32 uc_Func_IIf_Str = 84;

const Int32 uc_Func_Sin = 85;
const Int32 uc_Func_Cos = 86;
const Int32 uc_Func_Tan = 87;
const Int32 uc_Func_Atan = 88;
const Int32 uc_Func_Ceil = 89;
const Int32 uc_Func_Abs = 90;
const Int32 uc_Func_Abs_Int32 = 91;
const Int32 uc_Func_Exp = 92;
const Int32 uc_Func_Log = 93;
const Int32 uc_Func_Floor = 94;
const Int32 uc_Func_SquareRoot = 95;
const Int32 uc_Func_BaseConvert = 96;

const Int32 uc_Func_ExprHandle = 97;
const Int32 uc_Func_VarPtr = 98;
const Int32 uc_Func_uCalc = 99;
const Int32 uc_Func_uCalcStr = 100;
const Int32 uc_Func_ucAddr = 101;
const Int32 uc_Func_ValueAtAddr = 102;
const Int32 uc_Func_SpecialArg = 103;
const Int32 uc_Op_StringMult = 104;

const Int32 uc_Func_For = 105;
const Int32 uc_Func_Loop = 107;

const Int32 uc_Func_LoadLibrary = 108;
const Int32 uc_Func_GetProcAddress = 109;

const Int32 uc_NullString = 110;
const Int32 uc_True = 111;

const Int32 uc_Func_Peek = 112;
const Int32 uc_Func_Poke = 113;

const Int32 uc_Func_Int = 115;
const Int32 uc_Func_Frac = 116;
const Int32 uc_Func_Sgn = 117;

const Int32 uc_Func_PushData_Stack = 120;
// const Int32 uc_Func_PopHandle_Stack = 121;
const Int32 uc_Func_PopNum_Stack = 122;
const Int32 uc_Func_PopStr_Stack = 123;
const Int32 uc_Func_ReadHandle_Stack = 124;
const Int32 uc_Func_ReadNum_Stack = 125;
const Int32 uc_Func_ReadStr_Stack = 126;
const Int32 uc_Func_Count_Stack = 127;
const Int32 uc_Op_Concat_Stack = 128;
const Int32 uc_Func_Populate_Stack = 129;

const Int32 uc_Insert_Table = 130;
const Int32 uc_Delete_Table = 131;
const Int32 uc_Index_Table = 132;
const Int32 uc_Handle_Table = 133;
const Int32 uc_HandleB_Table = 134;
const Int32 uc_ReadData_Table = 135;
const Int32 uc_ReadNum_Table = 136;

const Int32 uc_Func_Min = 137;
const Int32 uc_Func_Max = 138;
const Int32 uc_Func_Min_Str = 139;
const Int32 uc_Func_Max_Str = 140;

const Int32 uc_SetVariableValue = 141;
const Int32 uc_SetVariableValueAnyType = 141;
const Int32 uc_SetVariableValueLong = 142;
const Int32 uc_SetVariableValueDouble = 143;
const Int32 uc_SetVariableValueExtended = 144;
const Int32 uc_ResetVariable = 145;

// Misc other callbacks
const Int32 uc_EvaluateAddr = 150;
const Int32 uc_EvaluateTurboAddr = 151;
const Int32 uc_ExceptionHelper = 152;
const Int32 uc_DefaultErrorHandler = 153;
const Int32 uc_Raise_Error = 154;
const Int32 uc_Func_IsIncomplete = 155;

const Int32 uc_ScriptTimerStart = 160;
const Int32 uc_LoadTimeTix = 161;

const Int32 uc_Op_Ext_Plus_Complex = 190;
const Int32 uc_Op_Ext_Times_Complex = 191;

const Int32 uc_Func_If_ElseIf = 195;
const Int32 uc_Func_SetSyntaxParams = 196;
const Int32 uc_Func_SpecialUCase = 197;
const Int32 uc_Func_Rand = 198;
const Int32 uc_Func_GetmatchArg = 199;
const Int32 uc_Func_PatternNum = 200;
const Int32 uc_Func_PatternStr = 201;

const Int32 uc_Convert_Stack_Table = 220;
const Int32 uc_Convert_Stack_SortedList = 221;
const Int32 uc_Convert_Table_Stack = 222;
const Int32 uc_Convert_SortedList_Stack = 223;

const Int32 uc_Expand_List = 1;
const Int32 uc_Expand_StackPtr = 2;

const Int32 uc_HandleToken = 21;

// Trig Mode
const Int32 uc_ReturnTrigMode = 0;
const Int32 uc_Radians = 1;
const Int32 uc_Degrees = 2;
const Int32 uc_Grad = 3;

// Misc
const Int32 ucTrue = 1;
const Int32 ucFalse = 0;
const Int32 uc_Rank_First = 1;
const Int32 uc_Rank_Last = -1;

// Pattern options
const Int32 uc_Pattern_ArgCount = 1;
const Int32 uc_Pattern_ArgIndex = 2;
const Int32 uc_Pattern_ArgLength = 3;
const Int32 uc_Pattern_ArgLocation = 4;
const Int32 uc_Pattern_ArgText = 5;
const Int32 uc_Pattern_DocumentLength = 6;
const Int32 uc_Pattern_DocumentText = 7;
const Int32 uc_Pattern_CriteriaCount = 8;
const Int32 uc_Pattern_CriteriaIndex = 9;
const Int32 uc_Pattern_MatchLength = 10;
const Int32 uc_Pattern_MatchLocation = 11;
const Int32 uc_Pattern_MatchText = 12;
const Int32 uc_Pattern_MatchTally = 13;
const Int32 uc_Pattern_SkipTally = 14;

// String Library
const Int32 uc_StringLibNum = 230;
const Int32 uc_StringLibStr = 231;
const Int32 ucs_SetStringDefaults = 4;
const Int32 ucs_Start = 5;
const Int32 ucs_Limit = 6;
const Int32 ucs_StartAfter = 7;
const Int32 ucs_StopAfter = 8;
const Int32 ucs_Between = 9;
const Int32 ucs_Nth = 10;
const Int32 ucs_File = 11;
const Int32 ucs_Pos = 12;
const Int32 ucs_Length = 13;
const Int32 ucs_Text = 14;
const Int32 ucs_Count = 15;
const Int32 ucs_CountSkipped = 16;
const Int32 ucs_InStr = 17;
const Int32 ucs_Tally = 18;
const Int32 ucs_UCase = 19;
const Int32 ucs_LCase = 20;
const Int32 ucs_MCase = 21;
const Int32 ucs_Replace = 22;
const Int32 ucs_Remove = 23;
const Int32 ucs_Mid = 24;
const Int32 ucs_Left = 25;
const Int32 ucs_Right = 26;
const Int32 ucs_Len = 27;
const Int32 ucs_Extract = 28;
const Int32 ucs_Remain = 29;
const Int32 ucs_Skip = 30;
const Int32 ucs_Delim = 31;
const Int32 ucs_Retain = 32;
const Int32 ucs_Range = 33;
const Int32 ucs_Compare = 34;
const Int32 ucs_Equals = 35;
const Int32 ucs_Split = 36;
const Int32 ucs_StringItem = 37;
const Int32 ucs_StringItemCount = 38;

// String Libarary Options
const Int32 ucByte = 1;
const Int32 ucChar = 2;
const Int32 ucWord = 4;
const Int32 ucToken = 8;
const Int32 ucBlock = 16;
const Int32 ucExpr = 32;
const Int32 ucQuote = 64;
const Int32 ucSpace = 128;
const Int32 ucCase = 256;
// End Of String Library Options

// Main Functions

Int32 ucInit = 0;
Int32 uCalcInit();
typedef Int32 (CALLBACK* __ucAddr)(Int32 AddressIndex); extern __ucAddr _ucAddr_; __ucAddr _ucAddr_;
typedef Int32 (CALLBACK* __uCalc)(Int32 ucCommand, AnsiString& TextIn, Int32 a, Int32 b, Int32 c, Int32 t ); extern __uCalc _uCalc_; __uCalc _uCalc_;
typedef Int32 (CALLBACK* __ExceptionHelper)(Int32 Expr, Int32 SystemError); extern __ExceptionHelper _ExceptionHelper_; __ExceptionHelper _ExceptionHelper_;
typedef Extended (CALLBACK* __ucEvaluate)(Int32 Item); extern __ucEvaluate _ucEvaluate_; __ucEvaluate _ucEvaluate_;
typedef Int32 (CALLBACK* __ucArgLng)(Int32 Expr, Int32 index); extern __ucArgLng _ucArgLng_; __ucArgLng _ucArgLng_;
typedef Extended (CALLBACK* __ucArg)(Int32 Expr, Int32 index); extern __ucArg _ucArg_; __ucArg _ucArg_;
typedef void (CALLBACK* __ucArgStr)(BSTR& ReturnStr, Int32 Expr, Int32 index); extern __ucArgStr _ucArgStr_; __ucArgStr _ucArgStr_;
typedef Int32 (CALLBACK* __ucArgHandle)(Int32 Expr, Int32 index); extern __ucArgHandle _ucArgHandle_; __ucArgHandle _ucArgHandle_;
typedef Int32 (CALLBACK* __ucArgCount)(Int32 Expr); extern __ucArgCount _ucArgCount_; __ucArgCount _ucArgCount_;
typedef void (CALLBACK* __ucReturnLng)(Int32 Expr, Int32 ReturnValue); extern __ucReturnLng _ucReturnLng_; __ucReturnLng _ucReturnLng_;
typedef void (CALLBACK* __ucReturn)(Int32 Expr, Extended ReturnValue); extern __ucReturn _ucReturn_; __ucReturn _ucReturn_;
typedef void (CALLBACK* __ucReturnStr)(Int32 Expr, AnsiString& ReturnValue); extern __ucReturnStr _ucReturnStr_; __ucReturnStr _ucReturnStr_;
typedef Extended (CALLBACK* __ucGetVariableValue)(Int32 Item); extern __ucGetVariableValue _ucGetVariableValue_; __ucGetVariableValue _ucGetVariableValue_;
typedef Int32 (CALLBACK* __ucGetVariableValueLng)(Int32 Item); extern __ucGetVariableValueLng _ucGetVariableValueLng_; __ucGetVariableValueLng _ucGetVariableValueLng_;
typedef void (CALLBACK* __ucGetVariableValueStr)(BSTR& ReturnStr, Int32 Item); extern __ucGetVariableValueStr _ucGetVariableValueStr_; __ucGetVariableValueStr _ucGetVariableValueStr_;
typedef void (CALLBACK* __ucSetVariableValueLng)(Int32 Item, Int32 NewValue); extern __ucSetVariableValueLng _ucSetVariableValueLng_; __ucSetVariableValueLng _ucSetVariableValueLng_;
typedef void (CALLBACK* __ucSetVariableValue)(Int32 Item, Extended NewValue); extern __ucSetVariableValue _ucSetVariableValue_; __ucSetVariableValue _ucSetVariableValue_;
typedef void (CALLBACK* __ucSetVariableValueStr)(Int32 Item, AnsiString& NewValue); extern __ucSetVariableValueStr _ucSetVariableValueStr_; __ucSetVariableValueStr _ucSetVariableValueStr_;
typedef Int32 (CALLBACK* __ucExprThread)(Int32 Expr); extern __ucExprThread _ucExprThread_; __ucExprThread _ucExprThread_;
typedef Int32 (CALLBACK* __ucLicense)(Int32 Product, UInt32 L1, UInt32 L2, UInt32 L3, UInt32 L4, UInt32 L5 ); extern __ucLicense _ucLicense_; __ucLicense _ucLicense_;
typedef void (CALLBACK* __uCalcStr)(BSTR& ReturnStr, Int32 ucCommand, AnsiString& TextIn, Int32 a, Int32 b, Int32 c, Int32 t ); extern __uCalcStr _uCalcStr_; __uCalcStr _uCalcStr_;
typedef Int32 (CALLBACK* __ucClose32bitDLL)(Int32 ReserverdArg); extern __ucClose32bitDLL _ucClose32bitDLL_; __ucClose32bitDLL _ucClose32bitDLL_;
typedef Int32 (CALLBACK* __ucDefine)(AnsiString& Definition, Int32 Arg1, Int32 Arg2, Int32 Arg3, Int32 t ); extern __ucDefine _ucDefine_; __ucDefine _ucDefine_;
typedef Int32 (CALLBACK* __ucDefineConstant)(AnsiString& Definition, Int32 t ); extern __ucDefineConstant _ucDefineConstant_; __ucDefineConstant _ucDefineConstant_;
typedef Int32 (CALLBACK* __ucDefineFunction)(AnsiString& Definition, void *FunctionAddress, Int32 t ); extern __ucDefineFunction _ucDefineFunction_; __ucDefineFunction _ucDefineFunction_;
typedef Int32 (CALLBACK* __ucDefineOperator)(AnsiString& Definition, void *FunctionAddress, Int32 t ); extern __ucDefineOperator _ucDefineOperator_; __ucDefineOperator _ucDefineOperator_;
typedef Int32 (CALLBACK* __ucDefineSyntax)(AnsiString& Definition, Int32 Rank, Int32 t ); extern __ucDefineSyntax _ucDefineSyntax_; __ucDefineSyntax _ucDefineSyntax_;
typedef Int32 (CALLBACK* __ucDefineVariable)(AnsiString& Definition, void *VarAddress, Int32 t ); extern __ucDefineVariable _ucDefineVariable_; __ucDefineVariable _ucDefineVariable_;
typedef Extended (CALLBACK* __ucEval)(AnsiString& Expr, Int32 t ); extern __ucEval _ucEval_; __ucEval _ucEval_;
typedef void (CALLBACK* __ucEvalStr)(BSTR& ReturnStr, AnsiString& Expr, Int32 ExprType, Int32 t ); extern __ucEvalStr _ucEvalStr_; __ucEvalStr _ucEvalStr_;
typedef void (CALLBACK* __ucEvaluateStr)(BSTR& ReturnStr, Int32 ucItem); extern __ucEvaluateStr _ucEvaluateStr_; __ucEvaluateStr _ucEvaluateStr_;
typedef void (CALLBACK* __ucExpand)(BSTR& ReturnStr, AnsiString& Expr, Int32 t ); extern __ucExpand _ucExpand_; __ucExpand _ucExpand_;
typedef Int32 (CALLBACK* __ucFPU)(Int32 FPU_Command, Int32 FPU_Option ); extern __ucFPU _ucFPU_; __ucFPU _ucFPU_;
typedef Int32 (CALLBACK* __ucGetTrigMode)(); extern __ucGetTrigMode _ucGetTrigMode_; __ucGetTrigMode _ucGetTrigMode_;
typedef Int32 (CALLBACK* __ucInitialize)(Int32 NewThread ); extern __ucInitialize _ucInitialize_; __ucInitialize _ucInitialize_;
typedef Int32 (CALLBACK* __ucNewThread)(Int32 ParentThread, Int32 MakeThisDefault ); extern __ucNewThread _ucNewThread_; __ucNewThread _ucNewThread_;
typedef Int32 (CALLBACK* __ucParse)(AnsiString& Expr, Int32 ExprType, Int32 t ); extern __ucParse _ucParse_; __ucParse _ucParse_;
typedef Int32 (CALLBACK* __ucReleaseItem)(Int32 ucItem); extern __ucReleaseItem _ucReleaseItem_; __ucReleaseItem _ucReleaseItem_;
typedef void (CALLBACK* __ucRun)(BSTR& ReturnStr, AnsiString& RunOption, AnsiString& TextIn, Int32 ExpandCount, Int32 t ); extern __ucRun _ucRun_; __ucRun _ucRun_;
typedef Int32 (CALLBACK* __ucSetOutput)(void *FunctionAddress, AnsiString& FuncName, AnsiString& DataType, Int32 t ); extern __ucSetOutput _ucSetOutput_; __ucSetOutput _ucSetOutput_;
typedef Int32 (CALLBACK* __ucSetTrigMode)(Int32 TrigMode); extern __ucSetTrigMode _ucSetTrigMode_; __ucSetTrigMode _ucSetTrigMode_;
typedef Int32 (CALLBACK* __ucAddErrorHandler)(void *ErrorHandlerAddress, Int32 t ); extern __ucAddErrorHandler _ucAddErrorHandler_; __ucAddErrorHandler _ucAddErrorHandler_;
typedef Int32 (CALLBACK* __ucError)(Int32 t ); extern __ucError _ucError_; __ucError _ucError_;
typedef void (CALLBACK* __ucErrorMessage)(BSTR& ReturnStr, Int32 ErrorNumber, Int32 t ); extern __ucErrorMessage _ucErrorMessage_; __ucErrorMessage _ucErrorMessage_;
typedef void (CALLBACK* __ucErrorExpression)(BSTR& ReturnStr, Int32 t ); extern __ucErrorExpression _ucErrorExpression_; __ucErrorExpression _ucErrorExpression_;
typedef Int32 (CALLBACK* __ucErrorLocation)(Int32 t); extern __ucErrorLocation _ucErrorLocation_; __ucErrorLocation _ucErrorLocation_;
typedef void (CALLBACK* __ucErrorSymbol)(BSTR& ReturnStr, Int32 t); extern __ucErrorSymbol _ucErrorSymbol_; __ucErrorSymbol _ucErrorSymbol_;
typedef Int32 (CALLBACK* __ucRaiseError)(Int32 Expr, Int32 ErrorNumber); extern __ucRaiseError _ucRaiseError_; __ucRaiseError _ucRaiseError_;
typedef Int32 (CALLBACK* __ucRaiseErrorMessage)(Int32 Expr, AnsiString& ErrorMessage); extern __ucRaiseErrorMessage _ucRaiseErrorMessage_; __ucRaiseErrorMessage _ucRaiseErrorMessage_;
typedef Int32 (CALLBACK* __ucSetError)(Int32 ErrorNumber, Int32 t ); extern __ucSetError _ucSetError_; __ucSetError _ucSetError_;
typedef Int32 (CALLBACK* __ucSetErrorMessage)(Int32 ErrorIndex, AnsiString& ErrorMessage, Int32 t ); extern __ucSetErrorMessage _ucSetErrorMessage_; __ucSetErrorMessage _ucSetErrorMessage_;
typedef Int32 (CALLBACK* __ucSetErrorNumber)(Int32 ErrorNumber, Int32 t ); extern __ucSetErrorNumber _ucSetErrorNumber_; __ucSetErrorNumber _ucSetErrorNumber_;
typedef Int32 (CALLBACK* __ucLoadStringLibInFMP)(Int32 tHandle ); extern __ucLoadStringLibInFMP _ucLoadStringLibInFMP_; __ucLoadStringLibInFMP _ucLoadStringLibInFMP_;
typedef Int32 (CALLBACK* __ucBetween)(Int32 a, Int32 b); extern __ucBetween _ucBetween_; __ucBetween _ucBetween_;
typedef Int32 (CALLBACK* __ucCompare)(AnsiString& String1, AnsiString& String2, Int32 Options ); extern __ucCompare _ucCompare_; __ucCompare _ucCompare_;
typedef Int32 (CALLBACK* __ucCount)(); extern __ucCount _ucCount_; __ucCount _ucCount_;
typedef Int32 (CALLBACK* __ucCountSkipped)(); extern __ucCountSkipped _ucCountSkipped_; __ucCountSkipped _ucCountSkipped_;
typedef Int32 (CALLBACK* __ucDelim)(AnsiString& Delim, AnsiString& L, AnsiString& R ); extern __ucDelim _ucDelim_; __ucDelim _ucDelim_;
typedef Int32 (CALLBACK* __ucEquals)(AnsiString& String1, AnsiString& String2, Int32 Options ); extern __ucEquals _ucEquals_; __ucEquals _ucEquals_;
typedef Int32 (CALLBACK* __ucInStr)(Int32 Start, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucInStr _ucInStr_; __ucInStr _ucInStr_;
typedef Int32 (CALLBACK* __ucLen)(AnsiString& MainString, Int32 Options ); extern __ucLen _ucLen_; __ucLen _ucLen_;
typedef Int32 (CALLBACK* __ucLength)(Int32 x ); extern __ucLength _ucLength_; __ucLength _ucLength_;
typedef Int32 (CALLBACK* __ucLimit)(Int32 Limit); extern __ucLimit _ucLimit_; __ucLimit _ucLimit_;
typedef Int32 (CALLBACK* __ucNth)(Int32 Number); extern __ucNth _ucNth_; __ucNth _ucNth_;
typedef Int32 (CALLBACK* __ucPos)(Int32 x ); extern __ucPos _ucPos_; __ucPos _ucPos_;
typedef Int32 (CALLBACK* __ucSetStringDefaults)(Int32 Options); extern __ucSetStringDefaults _ucSetStringDefaults_; __ucSetStringDefaults _ucSetStringDefaults_;
typedef Int32 (CALLBACK* __ucSkip)(AnsiString& MainString); extern __ucSkip _ucSkip_; __ucSkip _ucSkip_;
typedef Int32 (CALLBACK* __ucSplit)(AnsiString& MainString, AnsiString& Delim, Int32 Options ); extern __ucSplit _ucSplit_; __ucSplit _ucSplit_;
typedef Int32 (CALLBACK* __ucStart)(Int32 Position); extern __ucStart _ucStart_; __ucStart _ucStart_;
typedef Int32 (CALLBACK* __ucStartAfter)(Int32 Number); extern __ucStartAfter _ucStartAfter_; __ucStartAfter _ucStartAfter_;
typedef Int32 (CALLBACK* __ucStopAfter)(Int32 Number); extern __ucStopAfter _ucStopAfter_; __ucStopAfter _ucStopAfter_;
typedef Int32 (CALLBACK* __ucStringItemCount)(); extern __ucStringItemCount _ucStringItemCount_; __ucStringItemCount _ucStringItemCount_;
typedef Int32 (CALLBACK* __ucTally)(AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucTally _ucTally_; __ucTally _ucTally_;
typedef void (CALLBACK* __ucExtract)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucExtract _ucExtract_; __ucExtract _ucExtract_;
typedef void (CALLBACK* __ucFile)(BSTR& ReturnStr, AnsiString& NameOfFile); extern __ucFile _ucFile_; __ucFile _ucFile_;
typedef void (CALLBACK* __ucLCase)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucLCase _ucLCase_; __ucLCase _ucLCase_;
typedef void (CALLBACK* __ucLeft)(BSTR& ReturnStr, AnsiString& MainString, Int32 Number, Int32 Options ); extern __ucLeft _ucLeft_; __ucLeft _ucLeft_;
typedef void (CALLBACK* __ucMCase)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucMCase _ucMCase_; __ucMCase _ucMCase_;
typedef void (CALLBACK* __ucMid)(BSTR& ReturnStr, AnsiString& MainString, Int32 Start, Int32 Length, Int32 Options ); extern __ucMid _ucMid_; __ucMid _ucMid_;
typedef void (CALLBACK* __ucRange)(BSTR& ReturnStr, Int32 Start, Int32 Finish, AnsiString& Expression, Int32 Options ); extern __ucRange _ucRange_; __ucRange _ucRange_;
typedef void (CALLBACK* __ucRemain)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucRemain _ucRemain_; __ucRemain _ucRemain_;
typedef void (CALLBACK* __ucRemove)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucRemove _ucRemove_; __ucRemove _ucRemove_;
typedef void (CALLBACK* __ucReplace)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, AnsiString& Replacement, Int32 Options ); extern __ucReplace _ucReplace_; __ucReplace _ucReplace_;
typedef void (CALLBACK* __ucRetain)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, AnsiString& Filter, Int32 Options ); extern __ucRetain _ucRetain_; __ucRetain _ucRetain_;
typedef void (CALLBACK* __ucRight)(BSTR& ReturnStr, AnsiString& MainString, Int32 Number, Int32 Options ); extern __ucRight _ucRight_; __ucRight _ucRight_;
typedef void (CALLBACK* __ucStringItem)(BSTR& ReturnStr, Int32 Index); extern __ucStringItem _ucStringItem_; __ucStringItem _ucStringItem_;
typedef void (CALLBACK* __ucUCase)(BSTR& ReturnStr, AnsiString& MainString, AnsiString& Pattern, Int32 Options ); extern __ucUCase _ucUCase_; __ucUCase _ucUCase_;
typedef Int32 (CALLBACK* __uCalcRaw)(AnsiString& ReturnStr_, Int32 uc, AnsiString& TextIn, Int32 Misc1, Int32 Misc2, Int32 ReturnPtr, Int32 tHandle); extern __uCalcRaw _uCalcRaw_; __uCalcRaw _uCalcRaw_;

Int32 ucAddr(Int32 AddressIndex) {
   if(ucInit==0) uCalcInit();
   return _ucAddr_( AddressIndex);
}

Int32 uCalc(Int32 ucCommand, AnsiString TextIn = "", Int32 a = 0, Int32 b = 0, Int32 c = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _uCalc_( ucCommand, TextIn, a, b, c, t );
}

Int32 ExceptionHelper(Int32 Expr, Int32 SystemError) {
   if(ucInit==0) uCalcInit();
   return _ExceptionHelper_( Expr, SystemError);
}

Extended ucEvaluate(Int32 Item) {
   if(ucInit==0) uCalcInit();
   return _ucEvaluate_( Item);
}

Int32 ucArgLng(Int32 Expr, Int32 index) {
   if(ucInit==0) uCalcInit();
   return _ucArgLng_( Expr, index);
}

Extended ucArg(Int32 Expr, Int32 index) {
   if(ucInit==0) uCalcInit();
   return _ucArg_( Expr, index);
}

AnsiString ucArgStr(Int32 Expr, Int32 index) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucArgStr_( ReturnStr_, Expr, index);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucArgHandle(Int32 Expr, Int32 index) {
   if(ucInit==0) uCalcInit();
   return _ucArgHandle_( Expr, index);
}

Int32 ucArgCount(Int32 Expr) {
   if(ucInit==0) uCalcInit();
   return _ucArgCount_( Expr);
}

void ucReturnLng(Int32 Expr, Int32 ReturnValue) {
   if(ucInit==0) uCalcInit();
   _ucReturnLng_( Expr, ReturnValue);
}

void ucReturn(Int32 Expr, Extended ReturnValue) {
   if(ucInit==0) uCalcInit();
   _ucReturn_( Expr, ReturnValue);
}

void ucReturnStr(Int32 Expr, AnsiString ReturnValue) {
   if(ucInit==0) uCalcInit();
   _ucReturnStr_( Expr, ReturnValue);
}

Extended ucGetVariableValue(Int32 Item) {
   if(ucInit==0) uCalcInit();
   return _ucGetVariableValue_( Item);
}

Int32 ucGetVariableValueLng(Int32 Item) {
   if(ucInit==0) uCalcInit();
   return _ucGetVariableValueLng_( Item);
}

AnsiString ucGetVariableValueStr(Int32 Item) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucGetVariableValueStr_( ReturnStr_, Item);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

void ucSetVariableValueLng(Int32 Item, Int32 NewValue) {
   if(ucInit==0) uCalcInit();
   _ucSetVariableValueLng_( Item, NewValue);
}

void ucSetVariableValue(Int32 Item, Extended NewValue) {
   if(ucInit==0) uCalcInit();
   _ucSetVariableValue_( Item, NewValue);
}

void ucSetVariableValueStr(Int32 Item, AnsiString NewValue) {
   if(ucInit==0) uCalcInit();
   _ucSetVariableValueStr_( Item, NewValue);
}

Int32 ucExprThread(Int32 Expr) {
   if(ucInit==0) uCalcInit();
   return _ucExprThread_( Expr);
}

Int32 ucLicense(Int32 Product, UInt32 L1 = 0, UInt32 L2 = 0, UInt32 L3 = 0, UInt32 L4 = 0, UInt32 L5 = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLicense_( Product, L1, L2, L3, L4, L5 );
}

AnsiString uCalcStr(Int32 ucCommand, AnsiString TextIn = "", Int32 a = 0, Int32 b = 0, Int32 c = 0, Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _uCalcStr_( ReturnStr_, ucCommand, TextIn, a, b, c, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucClose32bitDLL(Int32 ReserverdArg) {
   if(ucInit==0) uCalcInit();
   return _ucClose32bitDLL_( ReserverdArg);
}

Int32 ucDefine(AnsiString Definition, Int32 Arg1 = 0, Int32 Arg2 = 0, Int32 Arg3 = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefine_( Definition, Arg1, Arg2, Arg3, t );
}

Int32 ucDefineConstant(AnsiString Definition, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefineConstant_( Definition, t );
}

Int32 ucDefineFunction(AnsiString Definition, void *FunctionAddress = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefineFunction_( Definition, FunctionAddress, t );
}

Int32 ucDefineOperator(AnsiString Definition, void *FunctionAddress = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefineOperator_( Definition, FunctionAddress, t );
}

Int32 ucDefineSyntax(AnsiString Definition, Int32 Rank = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefineSyntax_( Definition, Rank, t );
}

Int32 ucDefineVariable(AnsiString Definition, void *VarAddress = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucDefineVariable_( Definition, VarAddress, t );
}

Extended ucEval(AnsiString Expr, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucEval_( Expr, t );
}

AnsiString ucEvalStr(AnsiString Expr, Int32 ExprType = 0, Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucEvalStr_( ReturnStr_, Expr, ExprType, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucEvaluateStr(Int32 ucItem) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucEvaluateStr_( ReturnStr_, ucItem);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucExpand(AnsiString Expr, Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucExpand_( ReturnStr_, Expr, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucFPU(Int32 FPU_Command, Int32 FPU_Option = 0) {
   if(ucInit==0) uCalcInit();
   return _ucFPU_( FPU_Command, FPU_Option );
}

Int32 ucGetTrigMode() {
   if(ucInit==0) uCalcInit();
   return _ucGetTrigMode_();
}

Int32 ucInitialize(Int32 NewThread = 0) {
   if(ucInit==0) uCalcInit();
   return _ucInitialize_( NewThread );
}

Int32 ucNewThread(Int32 ParentThread = 0, Int32 MakeThisDefault = 0) {
   if(ucInit==0) uCalcInit();
   return _ucNewThread_( ParentThread, MakeThisDefault );
}

Int32 ucParse(AnsiString Expr, Int32 ExprType = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucParse_( Expr, ExprType, t );
}

Int32 ucReleaseItem(Int32 ucItem) {
   if(ucInit==0) uCalcInit();
   return _ucReleaseItem_( ucItem);
}

AnsiString ucRun(AnsiString RunOption, AnsiString TextIn, Int32 ExpandCount = 0, Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRun_( ReturnStr_, RunOption, TextIn, ExpandCount, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucSetOutput(void *FunctionAddress = 0, AnsiString FuncName = "", AnsiString DataType = "", Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetOutput_(FunctionAddress, FuncName, DataType, t );
}

Int32 ucSetTrigMode(Int32 TrigMode) {
   if(ucInit==0) uCalcInit();
   return _ucSetTrigMode_( TrigMode);
}

Int32 ucAddErrorHandler(void *ErrorHandlerAddress = 0, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucAddErrorHandler_(ErrorHandlerAddress, t );
}

Int32 ucError(Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucError_( t );
}

AnsiString ucErrorMessage(Int32 ErrorNumber = 0, Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorMessage_( ReturnStr_, ErrorNumber, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucErrorExpression(Int32 t = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorExpression_( ReturnStr_, t );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucErrorLocation(Int32 t) {
   if(ucInit==0) uCalcInit();
   return _ucErrorLocation_( t);
}

AnsiString ucErrorSymbol(Int32 t) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorSymbol_( ReturnStr_, t);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 ucRaiseError(Int32 Expr, Int32 ErrorNumber) {
   if(ucInit==0) uCalcInit();
   return _ucRaiseError_( Expr, ErrorNumber);
}

Int32 ucRaiseErrorMessage(Int32 Expr, AnsiString ErrorMessage) {
   if(ucInit==0) uCalcInit();
   return _ucRaiseErrorMessage_( Expr, ErrorMessage);
}

Int32 ucSetError(Int32 ErrorNumber, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetError_( ErrorNumber, t );
}

Int32 ucSetErrorMessage(Int32 ErrorIndex, AnsiString ErrorMessage, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetErrorMessage_( ErrorIndex, ErrorMessage, t );
}

Int32 ucSetErrorNumber(Int32 ErrorNumber, Int32 t = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetErrorNumber_( ErrorNumber, t );
}

Int32 ucLoadStringLibInFMP(Int32 tHandle = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLoadStringLibInFMP_( tHandle );
}

Int32 ucBetween(Int32 a, Int32 b) {
   if(ucInit==0) uCalcInit();
   return _ucBetween_( a, b);
}

Int32 ucCompare(AnsiString String1, AnsiString String2, Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucCompare_( String1, String2, Options );
}

Int32 ucCount() {
   if(ucInit==0) uCalcInit();
   return _ucCount_();
}

Int32 ucCountSkipped() {
   if(ucInit==0) uCalcInit();
   return _ucCountSkipped_();
}

Int32 ucDelim(AnsiString Delim, AnsiString L = "", AnsiString R = "") {
   if(ucInit==0) uCalcInit();
   return _ucDelim_( Delim, L, R );
}

Int32 ucEquals(AnsiString String1, AnsiString String2, Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucEquals_( String1, String2, Options );
}

Int32 ucInStr(Int32 Start, AnsiString MainString, AnsiString Pattern, Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucInStr_( Start, MainString, Pattern, Options );
}

Int32 ucLen(AnsiString MainString, Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLen_( MainString, Options );
}

Int32 ucLength(Int32 x = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLength_( x );
}

Int32 ucLimit(Int32 Limit) {
   if(ucInit==0) uCalcInit();
   return _ucLimit_( Limit);
}

Int32 ucNth(Int32 Number) {
   if(ucInit==0) uCalcInit();
   return _ucNth_( Number);
}

Int32 ucPos(Int32 x = 0) {
   if(ucInit==0) uCalcInit();
   return _ucPos_( x );
}

Int32 ucSetStringDefaults(Int32 Options) {
   if(ucInit==0) uCalcInit();
   return _ucSetStringDefaults_( Options);
}

Int32 ucSkip(AnsiString MainString) {
   if(ucInit==0) uCalcInit();
   return _ucSkip_( MainString);
}

Int32 ucSplit(AnsiString MainString, AnsiString Delim = "", Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSplit_( MainString, Delim, Options );
}

Int32 ucStart(Int32 Position) {
   if(ucInit==0) uCalcInit();
   return _ucStart_( Position);
}

Int32 ucStartAfter(Int32 Number) {
   if(ucInit==0) uCalcInit();
   return _ucStartAfter_( Number);
}

Int32 ucStopAfter(Int32 Number) {
   if(ucInit==0) uCalcInit();
   return _ucStopAfter_( Number);
}

Int32 ucStringItemCount() {
   if(ucInit==0) uCalcInit();
   return _ucStringItemCount_();
}

Int32 ucTally(AnsiString MainString, AnsiString Pattern, Int32 Options = 0) {
   if(ucInit==0) uCalcInit();
   return _ucTally_( MainString, Pattern, Options );
}

AnsiString ucExtract(AnsiString MainString, AnsiString Pattern, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucExtract_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucFile(AnsiString NameOfFile) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucFile_( ReturnStr_, NameOfFile);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucLCase(AnsiString MainString, AnsiString Pattern = "", Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucLCase_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucLeft(AnsiString MainString, Int32 Number, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucLeft_( ReturnStr_, MainString, Number, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucMCase(AnsiString MainString, AnsiString Pattern = "", Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucMCase_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucMid(AnsiString MainString, Int32 Start, Int32 Length = 0, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucMid_( ReturnStr_, MainString, Start, Length, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucRange(Int32 Start, Int32 Finish, AnsiString Expression, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRange_( ReturnStr_, Start, Finish, Expression, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucRemain(AnsiString MainString, AnsiString Pattern, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRemain_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucRemove(AnsiString MainString, AnsiString Pattern, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRemove_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucReplace(AnsiString MainString, AnsiString Pattern, AnsiString Replacement = "", Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucReplace_( ReturnStr_, MainString, Pattern, Replacement, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucRetain(AnsiString MainString, AnsiString Pattern, AnsiString Filter = "", Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRetain_( ReturnStr_, MainString, Pattern, Filter, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucRight(AnsiString MainString, Int32 Number, Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucRight_( ReturnStr_, MainString, Number, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucStringItem(Int32 Index) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucStringItem_( ReturnStr_, Index);
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

AnsiString ucUCase(AnsiString MainString, AnsiString Pattern = "", Int32 Options = 0) {
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucUCase_( ReturnStr_, MainString, Pattern, Options );
   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

Int32 uCalcRaw(AnsiString ReturnStr_, Int32 uc, AnsiString TextIn, Int32 Misc1, Int32 Misc2, Int32 ReturnPtr, Int32 tHandle) {
   if(ucInit==0) uCalcInit();
   return _uCalcRaw_( ReturnStr_, uc, TextIn, Misc1, Misc2, ReturnPtr, tHandle);
}

Int32 uCalcInit() {
   static HINSTANCE hDLL;
   hDLL = LoadLibraryA("uCalc32v400.dll");
   
   if (hDLL == NULL) return 0;
   ucInit = 1;   

   _ucAddr_ = (__ucAddr)GetProcAddress(hDLL, "ucAddr");
   _uCalc_ = (__uCalc)GetProcAddress(hDLL, "uCalc");
   _ExceptionHelper_ = (__ExceptionHelper)GetProcAddress(hDLL, "ExceptionHelper");
   _ucEvaluate_ = (__ucEvaluate)GetProcAddress(hDLL, "ucEvaluate");
   _ucArgLng_ = (__ucArgLng)GetProcAddress(hDLL, "ucArgLng");
   _ucArg_ = (__ucArg)GetProcAddress(hDLL, "ucArg");
   _ucArgStr_ = (__ucArgStr)GetProcAddress(hDLL, "ucArgStr");
   _ucArgHandle_ = (__ucArgHandle)GetProcAddress(hDLL, "ucArgHandle");
   _ucArgCount_ = (__ucArgCount)GetProcAddress(hDLL, "ucArgCount");
   _ucReturnLng_ = (__ucReturnLng)GetProcAddress(hDLL, "ucReturnLng");
   _ucReturn_ = (__ucReturn)GetProcAddress(hDLL, "ucReturnExt");
   _ucReturnStr_ = (__ucReturnStr)GetProcAddress(hDLL, "ucReturnStr");
   _ucGetVariableValue_ = (__ucGetVariableValue)GetProcAddress(hDLL, "ucGetVariableValue");
   _ucGetVariableValueLng_ = (__ucGetVariableValueLng)GetProcAddress(hDLL, "ucGetVariableValueLng");
   _ucGetVariableValueStr_ = (__ucGetVariableValueStr)GetProcAddress(hDLL, "ucGetVariableValueStr");
   _ucSetVariableValueLng_ = (__ucSetVariableValueLng)GetProcAddress(hDLL, "ucSetVariableValueLng");
   _ucSetVariableValue_ = (__ucSetVariableValue)GetProcAddress(hDLL, "ucSetVariableValueExt");
   _ucSetVariableValueStr_ = (__ucSetVariableValueStr)GetProcAddress(hDLL, "ucSetVariableValueStr");
   _ucExprThread_ = (__ucExprThread)GetProcAddress(hDLL, "ucExprThread");
   _ucLicense_ = (__ucLicense)GetProcAddress(hDLL, "ucLicense");
   _uCalcStr_ = (__uCalcStr)GetProcAddress(hDLL, "uCalcStr");
   _ucClose32bitDLL_ = (__ucClose32bitDLL)GetProcAddress(hDLL, "ucClose32bitDLL");
   _ucDefine_ = (__ucDefine)GetProcAddress(hDLL, "ucDefine");
   _ucDefineConstant_ = (__ucDefineConstant)GetProcAddress(hDLL, "ucDefineConstant");
   _ucDefineFunction_ = (__ucDefineFunction)GetProcAddress(hDLL, "ucDefineFunction");
   _ucDefineOperator_ = (__ucDefineOperator)GetProcAddress(hDLL, "ucDefineOperator");
   _ucDefineSyntax_ = (__ucDefineSyntax)GetProcAddress(hDLL, "ucDefineSyntax");
   _ucDefineVariable_ = (__ucDefineVariable)GetProcAddress(hDLL, "ucDefineVariable");
   _ucEval_ = (__ucEval)GetProcAddress(hDLL, "ucEval");
   _ucEvalStr_ = (__ucEvalStr)GetProcAddress(hDLL, "ucEvalStr");
   _ucEvaluateStr_ = (__ucEvaluateStr)GetProcAddress(hDLL, "ucEvaluateStr");
   _ucExpand_ = (__ucExpand)GetProcAddress(hDLL, "ucExpand");
   _ucFPU_ = (__ucFPU)GetProcAddress(hDLL, "ucFPU");
   _ucGetTrigMode_ = (__ucGetTrigMode)GetProcAddress(hDLL, "ucGetTrigMode");
   _ucInitialize_ = (__ucInitialize)GetProcAddress(hDLL, "ucInitialize");
   _ucNewThread_ = (__ucNewThread)GetProcAddress(hDLL, "ucNewThread");
   _ucParse_ = (__ucParse)GetProcAddress(hDLL, "ucParse");
   _ucReleaseItem_ = (__ucReleaseItem)GetProcAddress(hDLL, "ucReleaseItem");
   _ucRun_ = (__ucRun)GetProcAddress(hDLL, "ucRun");
   _ucSetOutput_ = (__ucSetOutput)GetProcAddress(hDLL, "ucSetOutput");
   _ucSetTrigMode_ = (__ucSetTrigMode)GetProcAddress(hDLL, "ucSetTrigMode");
   _ucAddErrorHandler_ = (__ucAddErrorHandler)GetProcAddress(hDLL, "ucAddErrorHandler");
   _ucError_ = (__ucError)GetProcAddress(hDLL, "ucError");
   _ucErrorMessage_ = (__ucErrorMessage)GetProcAddress(hDLL, "ucErrorMessage");
   _ucErrorExpression_ = (__ucErrorExpression)GetProcAddress(hDLL, "ucErrorExpression");
   _ucErrorLocation_ = (__ucErrorLocation)GetProcAddress(hDLL, "ucErrorLocation");
   _ucErrorSymbol_ = (__ucErrorSymbol)GetProcAddress(hDLL, "ucErrorSymbol");
   _ucRaiseError_ = (__ucRaiseError)GetProcAddress(hDLL, "ucRaiseError");
   _ucRaiseErrorMessage_ = (__ucRaiseErrorMessage)GetProcAddress(hDLL, "ucRaiseErrorMessage");
   _ucSetError_ = (__ucSetError)GetProcAddress(hDLL, "ucSetError");
   _ucSetErrorMessage_ = (__ucSetErrorMessage)GetProcAddress(hDLL, "ucSetErrorMessage");
   _ucSetErrorNumber_ = (__ucSetErrorNumber)GetProcAddress(hDLL, "ucSetErrorNumber");
   _ucLoadStringLibInFMP_ = (__ucLoadStringLibInFMP)GetProcAddress(hDLL, "ucLoadStringLibInFMP");
   _ucBetween_ = (__ucBetween)GetProcAddress(hDLL, "ucBetween");
   _ucCompare_ = (__ucCompare)GetProcAddress(hDLL, "ucCompare");
   _ucCount_ = (__ucCount)GetProcAddress(hDLL, "ucCount");
   _ucCountSkipped_ = (__ucCountSkipped)GetProcAddress(hDLL, "ucCountSkipped");
   _ucDelim_ = (__ucDelim)GetProcAddress(hDLL, "ucDelim");
   _ucEquals_ = (__ucEquals)GetProcAddress(hDLL, "ucEquals");
   _ucInStr_ = (__ucInStr)GetProcAddress(hDLL, "ucInStr");
   _ucLen_ = (__ucLen)GetProcAddress(hDLL, "ucLen");
   _ucLength_ = (__ucLength)GetProcAddress(hDLL, "ucLength");
   _ucLimit_ = (__ucLimit)GetProcAddress(hDLL, "ucLimit");
   _ucNth_ = (__ucNth)GetProcAddress(hDLL, "ucNth");
   _ucPos_ = (__ucPos)GetProcAddress(hDLL, "ucPos");
   _ucSetStringDefaults_ = (__ucSetStringDefaults)GetProcAddress(hDLL, "ucSetStringDefaults");
   _ucSkip_ = (__ucSkip)GetProcAddress(hDLL, "ucSkip");
   _ucSplit_ = (__ucSplit)GetProcAddress(hDLL, "ucSplit");
   _ucStart_ = (__ucStart)GetProcAddress(hDLL, "ucStart");
   _ucStartAfter_ = (__ucStartAfter)GetProcAddress(hDLL, "ucStartAfter");
   _ucStopAfter_ = (__ucStopAfter)GetProcAddress(hDLL, "ucStopAfter");
   _ucStringItemCount_ = (__ucStringItemCount)GetProcAddress(hDLL, "ucStringItemCount");
   _ucTally_ = (__ucTally)GetProcAddress(hDLL, "ucTally");
   _ucExtract_ = (__ucExtract)GetProcAddress(hDLL, "ucExtract");
   _ucFile_ = (__ucFile)GetProcAddress(hDLL, "ucFile");
   _ucLCase_ = (__ucLCase)GetProcAddress(hDLL, "ucLCase");
   _ucLeft_ = (__ucLeft)GetProcAddress(hDLL, "ucLeft");
   _ucMCase_ = (__ucMCase)GetProcAddress(hDLL, "ucMCase");
   _ucMid_ = (__ucMid)GetProcAddress(hDLL, "ucMid");
   _ucRange_ = (__ucRange)GetProcAddress(hDLL, "ucRange");
   _ucRemain_ = (__ucRemain)GetProcAddress(hDLL, "ucRemain");
   _ucRemove_ = (__ucRemove)GetProcAddress(hDLL, "ucRemove");
   _ucReplace_ = (__ucReplace)GetProcAddress(hDLL, "ucReplace");
   _ucRetain_ = (__ucRetain)GetProcAddress(hDLL, "ucRetain");
   _ucRight_ = (__ucRight)GetProcAddress(hDLL, "ucRight");
   _ucStringItem_ = (__ucStringItem)GetProcAddress(hDLL, "ucStringItem");
   _ucUCase_ = (__ucUCase)GetProcAddress(hDLL, "ucUCase");
   _uCalcRaw_ = (__uCalcRaw)GetProcAddress(hDLL, "uCalcRaw");
   return 1;
}