// ---------------------------------------------------------------------------
// uCalcCSx64.cs: C# include file for uCalc Fast Math Parser 4.00
// Designed for : C# 2010 and 2012
// Instructions: Add this file to your project's directory (from the menu:
//               Project / Add Existing Item...) and copy uCalc DLLs to
//               your bin and/or bin\Debug directory (or any directory in
//               the path) and you're ready to go.
//
// This file auto-generated by : CSharp.uc using uCalc Transform 3.0
// Auto-generation timestamp: 08/14/14
// CSharp.uc prepared by : Daniel Corbier
// Visit www.ucalc.com for additional resources.
// ---------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

public class uc
{
   public const string uCalcDLL = "uCalc64v400.dll";
// Definition properties
public const int ucAlphaNumeric = 1;
public const int ucArgSeparator = 2;
public const int ucCodeBlock = 3;
public const int ucCodeBlockMatch = 4;
public const int ucMemberAccess = 5;
public const int ucQuotedText = 6;
public const int ucStatementSep = 7;
public const int ucWhiteSpace = 8;

public const int ucCurrentThread = 9;

public const int ucLocalVar = 10;
public const int ucStaticVar = 11;
public const int ucDefineNow = 11; // same as ucStaticVar
public const int ucTempDef = 12;
public const int ucEvalInsert = 13;
public const int ucEvalDuringParse = 14;
public const int ucExpandInsert = 15;
public const int ucFileInclude = 16;

public const int ucCurrentSpace = 17;
public const int ucDefSpace = 18;
public const int ucEvalSpace = 19;

public const int ucFunction = 64;
public const int ucOperator = 128;
public const int ucVariable = 256;
public const int ucSyntax = 512;
public const int ucLiteral = 1024;
public const int ucSymbol = 2048;
public const int ucReducible = 4096;
public const int ucLock = 8192;
public const int ucInfix = 16384;
public const int ucPrefix = 32768;
public const int ucPostfix = 49152;

// uCalc Commands
public const int uc_Define = 1;
public const int uc_DefineSyntax = 2;
public const int uc_Eval = 3;
public const int uc_EvalStr = 4;
public const int uc_Evaluate = 5;
public const int uc_EvaluateLng = 6;
public const int uc_EvaluateStr = 7;
public const int uc_GetCaseSensitivity = 8;
public const int uc_GetDefaultPass = 9;
public const int uc_GetDefaultPrecedence = 10;
public const int uc_GetDefaultRank = 11;
public const int uc_GetCodeAddr = 12;
public const int uc_GetDefaultThread = 13;
public const int uc_GetDefaultType = 14;
public const int uc_GetDefSeparator = 15;
public const int uc_GetDefSpace = 16;
public const int uc_GetErrorNumber = 17;
public const int uc_GetEvalSpace = 18;
public const int uc_GetParentThread = 20;
public const int uc_GetSyntaxEqual = 21;
public const int uc_Parse = 22;
public const int uc_ReleaseItem = 23;
public const int uc_SetCaseSensitivity = 24;
public const int uc_SetCodeAddr = 25;
public const int uc_SetDefaultPrecedence = 26;
public const int uc_SetDefaultRank = 27;
public const int uc_SetDefaultThread = 28;
public const int uc_SetDefaultType = 29;
public const int uc_SetDefSeparator = 30;
public const int uc_SetErrorNumber = 31;
public const int uc_SetParentThread = 32;
public const int uc_SetSyntaxEqual = 33;
public const int uc_NewThread = 34;

public const int uc_RegExWordBoundaryChars = 35;
public const int uc_RegExEscapeChar = 36;
public const int uc_License = 37;

// License options
public const int uc_License_Demo = 0;
public const int uc_License_FMP_Free = 1;
public const int uc_License_FMP_Standard_32 = 2;
public const int uc_License_FMP_Standard_64 = 3;
public const int uc_License_FMP_32_and_64 = 4;
public const int uc_License_LanguageBuilder = 5;
public const int uc_License_GeneralParser = 6;
public const int uc_License_Interpreter = 7;
public const int uc_License_ConsoleCalc = 8;
public const int uc_License_WindowsCalc = 9;
public const int uc_License_StringLib = 10;
public const int uc_License_Transform = 11;
public const int uc_License_TransformLib = 12;
public const int uc_License_Search = 13;
public const int uc_License_SearchLib = 14;
public const int uc_License_Library1 = 15;
public const int uc_License_Library2 = 16;
public const int uc_License_Beta = 17;
public const int uc_License_Debugger = 18;
public const int uc_License_uCalc_All = 50;
public const int uc_License_Developer = 100;
public const int uc_License_EndUser = 101;

public const int uc_AddDebugger = 39;
public const int Debug_ReleaseItem = 1;
public const int Debug_StdFuncCall = 2;
public const int Debug_UserFuncCall = 3;
public const int Debug_GetTextToken = 4;
public const int Debug_ErrorHandler = 5;
public const int Debug_ParseExpr = 6;
public const int Debug_ParseItem = 7;
public const int Debug_EvalOperation = 8;
public const int Debug_DefSyntax = 9;
public const int Debug_Define = 10;
public const int Debug_DefinePart = 11;
public const int Debug_Expand = 12;
public const int Debug_ExpandSuccess = 13;
public const int Debug_ExpandMiss = 14;
public const int Debug_ExpandFail = 15;
public const int Debug_GetSyntaxBlock = 16;
public const int Debug_GetCodeBlock = 17;
public const int Debug_LineNumber = 18;
public const int Debug_TotalTally = 19;
public const int Debug_Breakpoint = 20;
public const int Debug_Delay = 21;
public const int Debug_JumpTo = 22;
public const int Debug_StepAction = 23;

public const int uc_AddErrorHandler = 40;
public const int uc_GetSymbolTable = 41;
public const int uc_GetSteps = 42;
public const int uc_GetStepsCount = 43;

public const int uc_SetTypeOutput = 45;
public const int uc_Group = 46;
public const int uc_GetTag = 47;
public const int uc_SetTag = 48;

public const int uc_GetCallbackData = 50;
public const int uc_SetCallbackReturn = 51;

public const int uc_GetErrorExpression = 60;
public const int uc_SetExpression = 61;
public const int uc_GetSymbol = 62;
public const int uc_SetSymbol = 63;
public const int uc_GetLocation = 64;

public const int uc_GetTokenType = 65;
public const int uc_GetTokenProperties = 66;

public const int uc_TrigMode = 67;

public const int uc_ItemClone = 70;
public const int uc_DataConvert = 71;
public const int uc_DataCopy = 72;
public const int uc_DataAlloc = 72;
public const int uc_DataFree = 73;
public const int uc_DataReset = 74;

// FPU commands
public const int uc_SetFPU = 75;
public const int uc_SetFPU_HostProg = 76;
public const int uc_GetFPU = 77;
public const int uc_GetFPU_HostProg = 78;
public const int uc_ToggleFPU = 79;
public const int uc_ToggleFPU_HostProg = 80;

public const int uc_ErrorClear = 85;
public const int uc_RestoreErrorMessageBox = 86;

public const int uc_SetErrorMessage = 91;
public const int uc_GetErrorMessage = 92;

public const int uc_SerialNumber = 93;
public const int uc_SetTurbo = 94;
public const int uc_Expand = 95;
public const int uc_GetNextToken = 96;
public const int uc_GetItemData = 97;
public const int uc_SetItemData = 98;
public const int uc_GetThreadAddr = 99;
public const int uc_GetCodeBlock = 100;

public const int uc_Status_CurrentPass = 101;
public const int uc_Status_MaxPass = 102;
public const int uc_Status_Location = 103;
public const int uc_Status_NestedLevel = 104;
public const int uc_Status_TextLength = 105;

public const int uc_Find = 110;
public const int uc_FindAddMatch = 111;
public const int uc_FindGetIndex = 112;
public const int uc_FindGetCount = 113;
public const int uc_FindGetStart = 114;
public const int uc_FindGetLength = 115;
public const int uc_FindGetText = 116;
public const int uc_FindReset = 117;
public const int uc_FindReplace = 118;
public const int uc_FindFilter = 119;
public const int uc_FindSetFilter = 120;

public const int uc_FindFilterSort = 1;
public const int uc_FindFilterUnique = 2;
public const int uc_FindFilterTally = 4;
public const int uc_FindFilterSeparator = 8;
public const int uc_FindFilterStartText = 16;
public const int uc_FindFilterEndText = 32;

public const int uc_FindContext_Other = 0;
public const int uc_FindContext_Found = 1;
public const int uc_FindContext_Replaced = 2;

public const int uc_FindZoomIn = 1;
public const int uc_FindTransformInPlace = 2;

public const int uc_Properties = 1;
public const int uc_Thread = 2;
public const int uc_Address = 3;
public const int uc_SymbolName = 4;
public const int uc_Rank = 5;
public const int uc_Precedence = 6;
public const int uc_OverloadHandle = 7;
public const int uc_OverloadCount = 8;
public const int uc_ByteSize = 9;
public const int uc_ArgCount = 10;
public const int uc_DataType = 12;
public const int uc_Handle = 13;
public const int uc_Value = 14;
public const int uc_Property = 15;

// Error numbers
public const int uc_Err_None = 0;
public const int uc_Err_Dynamically_Defined = 1;
public const int uc_Err_Syntax_Error = 2;
public const int uc_Err_Undefined_Identifier = 3;
public const int uc_Err_FileNotFound = 4;
public const int uc_Err_Unrecognized_Token = 5;
public const int uc_Err_Unrecognized_Command = 6;
public const int uc_Err_Datatype_Mismatch = 7;
public const int uc_Err_Invalid_Argument_Count = 8;
public const int uc_Err_Invalid_Definition = 9;
public const int uc_Err_CodeBlock_Error = 10;
public const int uc_Err_Undefined_Callback = 11;
public const int uc_Err_ErrMsgAlreadyDefined = 12;
public const int uc_Err_ItemCannotBeModified = 13;
public const int uc_Err_Unrecognized_Member = 14;
public const int uc_Err_Unbalanced_Quote = 15;

public const int uc_Err_Array_Bounds_Exceeded = 20;
public const int uc_Err_Float_Denormal_Operand = 21;
public const int uc_Err_Float_Divide_By_Zero = 22;
public const int uc_Err_Float_Inexact_Result = 23;
public const int uc_Err_Float_Invalid_Operation = 24;
public const int uc_Err_Float_Overflow = 25;
public const int uc_Err_Float_Stack_Check = 26;
public const int uc_Err_Float_Underflow = 27;
public const int uc_Err_Integer_Divide_By_Zero = 28;
public const int uc_Err_Integer_Overflow = 29;
public const int uc_Err_Privileged_Instruction = 30;

// Error response
public const int ucAbort = 0;
public const int ucResume = 1;
public const int ucReRaise = 2;

// FPU Control Word Settings
public const int uc_FPU_Mask_InvalidOp = 1;
public const int uc_FPU_Mask_DenormalOp = 2;
public const int uc_FPU_Mask_ZeroDivide = 4;
public const int uc_FPU_Mask_Overflow = 8;
public const int uc_FPU_Mask_Underflow = 16;
public const int uc_FPU_Mask_PrecisionLoss = 32;

public const int uc_FPU_Precision_Single = 0;
public const int uc_FPU_Precision_Double = 256;
public const int uc_FPU_Precision_Extended = 768;

public const int uc_FPU_Round_Even = 0;
public const int uc_FPU_Round_Down = 1024;
public const int uc_FPU_Round_Up = 2048;
public const int uc_FPU_Round_Toward = 3072;

// Data type handler callback action modes
public const int uc_TypeHandler_Store = 2;
public const int uc_TypeHandler_StringOutput = 3;
public const int uc_TypeHandler_Free = 4;
public const int uc_TypeHandler_FuncRet = 5;
public const int uc_TypeHandler_Copy = 6;
public const int uc_TypeHandler_Alloc = 7;
public const int uc_TypeHandler_Reset = 8;

public const int uc_Callback_Undefined = 0; // Returns error

// Data Type callbacks
public const int uc_Complex = 1;
public const int uc_Currency = 2;
public const int uc_Double = 3;
public const int uc_Extended = 4;
public const int uc_Int8 = 5;
public const int uc_Int8u = 6;
public const int uc_Int16 = 7;
public const int uc_Int16u = 8;
public const int uc_Int32 = 9;
public const int uc_Int32u = 10;
public const int uc_Int64 = 11;
public const int uc_Int64u = 12;
public const int uc_Single = 13;
public const int uc_String = 14;
public const int uc_String_LPCSTR = 15;
public const int uc_String_Fixed = 16;
public const int uc_String_Wide = 17;
public const int uc_Stack = 18;
public const int uc_Table = 19;
public const int uc_SortedList = 20;
public const int uc_Void = 21;
public const int uc_User_Type = 22;

public const int uc_Convert_Generic = 23;
public const int uc_Convert_Same = 24;
public const int uc_Convert_Double_Extended = 25;
public const int uc_Convert_Int8_Extended = 26;
public const int uc_Convert_Int8u_Extended = 27;
public const int uc_Convert_Int16_Extended = 28;
public const int uc_Convert_Int16u_Extended = 29;
public const int uc_Convert_Int32_Extended = 30;
public const int uc_Convert_Int32u_Extended = 31;
public const int uc_Convert_Int64_Extended = 32;
public const int uc_Convert_Int64u_Extended = 33;
public const int uc_Convert_Single_Extended = 34;
public const int uc_Convert_Void_Extended = 35;
public const int uc_Convert_Extended_Double = 37;
public const int uc_Convert_Extended_Single = 38;
public const int uc_Convert_Extended_Int16u = 39;
public const int uc_Convert_Extended_Int32 = 40;
public const int uc_Convert_Complex_Extended = 41;
public const int uc_Convert_Extended_Complex = 42;

// Default built-in routines
public const int uc_Op_Negate = 43;
public const int uc_Op_UnaryPlus = 44;
public const int uc_Op_Percentage = 45;
public const int uc_Op_StrConcat = 46;
public const int uc_Op_Add_Int32 = 47;
public const int uc_Op_Add = 48;
public const int uc_Op_Add_Complex = 49;
public const int uc_Op_Subtract_Int32 = 50;
public const int uc_Op_Subtract = 51;
public const int uc_Op_Multiply_Int32 = 52;
public const int uc_Op_Multiply = 53;
public const int uc_Op_Multiply_Complex = 54;
public const int uc_Op_Divide_Int32 = 55;
public const int uc_Op_Divide = 56;
public const int uc_Op_Mod_Int32 = 57;
public const int uc_Op_Mod = 58;
public const int uc_Op_PowerOf_ExtToExt = 59;
public const int uc_Op_PowerOf_ExtToLng = 60;
public const int uc_Op_PowerOf_CplxToCplx = 61;

public const int uc_Op_GreaterThan = 62;
public const int uc_Op_GreaterOrEqual = 63;
public const int uc_Op_LessThan = 64;
public const int uc_Op_LessOrEqual = 65;
public const int uc_Op_Equal = 66;
public const int uc_Op_NotEqual = 67;

public const int uc_Op_GreaterThan_Str = 68;
public const int uc_Op_GreaterOrEqual_Str = 69;
public const int uc_Op_LessThan_Str = 70;
public const int uc_Op_LessOrEqual_Str = 71;
public const int uc_Op_Equal_Str = 72;
public const int uc_Op_NotEqual_Str = 73;

public const int uc_Op_Not_Int32 = 74;
public const int uc_Op_And_Int32 = 75;
public const int uc_Op_Or_Int32 = 76;
public const int uc_Op_Xor_Int32 = 77;
public const int uc_Op_Eqv_Int32 = 78;
public const int uc_Op_Imp_Int32 = 79;

public const int uc_Op_AndAlso = 80;
public const int uc_Op_OrElse = 81;

public const int uc_Op_Factorial = 82;

public const int uc_Func_IIf = 83;
public const int uc_Func_IIf_Str = 84;

public const int uc_Func_Sin = 85;
public const int uc_Func_Cos = 86;
public const int uc_Func_Tan = 87;
public const int uc_Func_Atan = 88;
public const int uc_Func_Ceil = 89;
public const int uc_Func_Abs = 90;
public const int uc_Func_Abs_Int32 = 91;
public const int uc_Func_Exp = 92;
public const int uc_Func_Log = 93;
public const int uc_Func_Floor = 94;
public const int uc_Func_SquareRoot = 95;
public const int uc_Func_BaseConvert = 96;

public const int uc_Func_ExprHandle = 97;
public const int uc_Func_VarPtr = 98;
public const int uc_Func_uCalc = 99;
public const int uc_Func_uCalcStr = 100;
public const int uc_Func_ucAddr = 101;
public const int uc_Func_ValueAtAddr = 102;
public const int uc_Func_SpecialArg = 103;
public const int uc_Op_StringMult = 104;

public const int uc_Func_For = 105;
public const int uc_Func_Loop = 107;

public const int uc_Func_LoadLibrary = 108;
public const int uc_Func_GetProcAddress = 109;

public const int uc_NullString = 110;
public const int uc_True = 111;

public const int uc_Func_Peek = 112;
public const int uc_Func_Poke = 113;

public const int uc_Func_Int = 115;
public const int uc_Func_Frac = 116;
public const int uc_Func_Sgn = 117;

public const int uc_Func_PushData_Stack = 120;
// public const int uc_Func_PopHandle_Stack = 121;
public const int uc_Func_PopNum_Stack = 122;
public const int uc_Func_PopStr_Stack = 123;
public const int uc_Func_ReadHandle_Stack = 124;
public const int uc_Func_ReadNum_Stack = 125;
public const int uc_Func_ReadStr_Stack = 126;
public const int uc_Func_Count_Stack = 127;
public const int uc_Op_Concat_Stack = 128;
public const int uc_Func_Populate_Stack = 129;

public const int uc_Insert_Table = 130;
public const int uc_Delete_Table = 131;
public const int uc_Index_Table = 132;
public const int uc_Handle_Table = 133;
public const int uc_HandleB_Table = 134;
public const int uc_ReadData_Table = 135;
public const int uc_ReadNum_Table = 136;

public const int uc_Func_Min = 137;
public const int uc_Func_Max = 138;
public const int uc_Func_Min_Str = 139;
public const int uc_Func_Max_Str = 140;

public const int uc_SetVariableValue = 141;
public const int uc_SetVariableValueAnyType = 141;
public const int uc_SetVariableValueLong = 142;
public const int uc_SetVariableValueDouble = 143;
public const int uc_SetVariableValueExtended = 144;
public const int uc_ResetVariable = 145;

// Misc other callbacks
public const int uc_EvaluateAddr = 150;
public const int uc_EvaluateTurboAddr = 151;
public const int uc_ExceptionHelper = 152;
public const int uc_DefaultErrorHandler = 153;
public const int uc_Raise_Error = 154;
public const int uc_Func_IsIncomplete = 155;

public const int uc_ScriptTimerStart = 160;
public const int uc_LoadTimeTix = 161;

public const int uc_Op_Ext_Plus_Complex = 190;
public const int uc_Op_Ext_Times_Complex = 191;

public const int uc_Func_If_ElseIf = 195;
public const int uc_Func_SetSyntaxParams = 196;
public const int uc_Func_SpecialUCase = 197;
public const int uc_Func_Rand = 198;
public const int uc_Func_GetmatchArg = 199;
public const int uc_Func_PatternNum = 200;
public const int uc_Func_PatternStr = 201;

public const int uc_Convert_Stack_Table = 220;
public const int uc_Convert_Stack_SortedList = 221;
public const int uc_Convert_Table_Stack = 222;
public const int uc_Convert_SortedList_Stack = 223;

public const int uc_Expand_List = 1;
public const int uc_Expand_StackPtr = 2;

public const int uc_HandleToken = 21; // &h15

// Trig Mode
public const int uc_ReturnTrigMode = 0;
public const int uc_Radians = 1;
public const int uc_Degrees = 2;
public const int uc_Grad = 3;

// Misc
public const int ucTrue = 1;
public const int ucFalse = 0;
public const int uc_Rank_First = 1;
public const int uc_Rank_Last = -1;

// Pattern options
public const int uc_Pattern_ArgCount = 1;
public const int uc_Pattern_ArgIndex = 2;
public const int uc_Pattern_ArgLength = 3;
public const int uc_Pattern_ArgLocation = 4;
public const int uc_Pattern_ArgText = 5;
public const int uc_Pattern_DocumentLength = 6;
public const int uc_Pattern_DocumentText = 7;
public const int uc_Pattern_CriteriaCount = 8;
public const int uc_Pattern_CriteriaIndex = 9;
public const int uc_Pattern_MatchLength = 10;
public const int uc_Pattern_MatchLocation = 11;
public const int uc_Pattern_MatchText = 12;
public const int uc_Pattern_MatchTally = 13;
public const int uc_Pattern_SkipTally = 14;

// String Library
public const int uc_StringLibNum = 230;
public const int uc_StringLibStr = 231;
public const int ucs_SetStringDefaults = 4;
public const int ucs_Start = 5;
public const int ucs_Limit = 6;
public const int ucs_StartAfter = 7;
public const int ucs_StopAfter = 8;
public const int ucs_Between = 9;
public const int ucs_Nth = 10;
public const int ucs_File = 11;
public const int ucs_Pos = 12;
public const int ucs_Length = 13;
public const int ucs_Text = 14;
public const int ucs_Count = 15;
public const int ucs_CountSkipped = 16;
public const int ucs_InStr = 17;
public const int ucs_Tally = 18;
public const int ucs_UCase = 19;
public const int ucs_LCase = 20;
public const int ucs_MCase = 21;
public const int ucs_Replace = 22;
public const int ucs_Remove = 23;
public const int ucs_Mid = 24;
public const int ucs_Left = 25;
public const int ucs_Right = 26;
public const int ucs_Len = 27;
public const int ucs_Extract = 28;
public const int ucs_Remain = 29;
public const int ucs_Skip = 30;
public const int ucs_Delim = 31;
public const int ucs_Retain = 32;
public const int ucs_Range = 33;
public const int ucs_Compare = 34;
public const int ucs_Equals = 35;
public const int ucs_Split = 36;
public const int ucs_StringItem = 37;
public const int ucs_StringItemCount = 38;

// String Libarary Options
public const int ucByte = 1;
public const int ucChar = 2;
public const int ucWord = 4;
public const int ucToken = 8;
public const int ucBlock = 16;
public const int ucExpr = 32;
public const int ucQuote = 64;
public const int ucSpace = 128;
public const int ucCase = 256;
// End Of String Library Options

public delegate void ucFunctionDelegate(int Expr);
public delegate int ucErrorHandlerDelegate(int t);
public delegate int ucCheckForStop(int FindContext, int t);

// Main Functions
[DllImport(uCalcDLL)] public static extern int ucAddr(int AddressIndex);
[DllImport(uCalcDLL, EntryPoint="uCalc")] public static extern int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string TextIn , int a , int b , int c , int t );
public static int uCalc(int ucCommand,  string TextIn = "", int a = 0, int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand, ref TextIn ,  a ,  b ,  c ,  t );
}
[DllImport(uCalcDLL, EntryPoint="uCalc")] public static extern int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string TextIn, ucCheckForStop a, int b , int c , int t );
public static int uCalc(int ucCommand,  string TextIn, ucCheckForStop a, int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand, ref TextIn,  a,  b ,  c ,  t );
}
[DllImport(uCalcDLL, EntryPoint="uCalc")] public static extern int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string TextIn, ucFunctionDelegate a, int b , int c , int t );
public static int uCalc(int ucCommand,  string TextIn, ucFunctionDelegate a, int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand, ref TextIn,  a,  b ,  c ,  t );
}

// Insert Other Exports
[DllImport(uCalcDLL)] public static extern int ExceptionHelper(int Expr, int SystemError);
[DllImport(uCalcDLL)] public static extern double ucEvaluate(int Item);
[DllImport(uCalcDLL)] public static extern int ucArgLng(int Expr, int index);
[DllImport(uCalcDLL)] public static extern double ucArg(int Expr, int index);
[DllImport(uCalcDLL, EntryPoint="ucArgStr")] public static extern void ucArgStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int Expr, int index);
public static string ucArgStr(int Expr, int index) {
   string ReturnStr = "";
   ucArgStr_(ref ReturnStr,  Expr,  index);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern int ucArgHandle(int Expr, int index);
[DllImport(uCalcDLL)] public static extern int ucArgCount(int Expr);
[DllImport(uCalcDLL)] public static extern void ucReturnLng (int Expr, int ReturnValue);
[DllImport(uCalcDLL, EntryPoint="ucReturnDbl")] public static extern void ucReturn(int Expr, Double ReturnValue);
[DllImport(uCalcDLL, EntryPoint="ucReturnStr")] public static extern void ucReturnStr_(int Expr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string ReturnValue);
public static void ucReturnStr(int Expr,  string ReturnValue) {
    ucReturnStr_( Expr, ref ReturnValue);
}
[DllImport(uCalcDLL)] public static extern double ucGetVariableValue(int Item);
[DllImport(uCalcDLL)] public static extern int ucGetVariableValueLng(int Item);
[DllImport(uCalcDLL, EntryPoint="ucGetVariableValueStr")] public static extern void ucGetVariableValueStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int Item);
public static string ucGetVariableValueStr(int Item) {
   string ReturnStr = "";
   ucGetVariableValueStr_(ref ReturnStr,  Item);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern void ucSetVariableValueLng (int Item, int NewValue);
[DllImport(uCalcDLL, EntryPoint="ucSetVariableValueDbl")] public static extern void ucSetVariableValue(int Item, Double NewValue);
[DllImport(uCalcDLL, EntryPoint="ucSetVariableValueStr")] public static extern void ucSetVariableValueStr_(int Item, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string NewValue);
public static void ucSetVariableValueStr(int Item,  string NewValue) {
    ucSetVariableValueStr_( Item, ref NewValue);
}
[DllImport(uCalcDLL)] public static extern int ucExprThread(int Expr);
[DllImport(uCalcDLL)] public static extern int ucLicense(int Product, UInt32 L1 = 0, UInt32 L2 = 0, UInt32 L3 = 0, UInt32 L4 = 0, UInt32 L5 = 0);
// End Insert
[DllImport(uCalcDLL, EntryPoint="uCalcStr")] public static extern void uCalcStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int ucCommand, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string TextIn , int a , int b , int c , int t );
public static string uCalcStr(int ucCommand,  string TextIn = "", int a = 0, int b = 0, int c = 0, int t = 0) {
   string ReturnStr = "";
   uCalcStr_(ref ReturnStr,  ucCommand, ref TextIn ,  a ,  b ,  c ,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern int ucClose32bitDLL(int ReserverdArg);
[DllImport(uCalcDLL, EntryPoint="ucDefine")] public static extern int ucDefine_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, int Arg1 , int Arg2 , int Arg3 , int t );
public static int ucDefine( string Definition, int Arg1 = 0, int Arg2 = 0, int Arg3 = 0, int t = 0) {
   return ucDefine_(ref Definition,  Arg1 ,  Arg2 ,  Arg3 ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineConstant")] public static extern int ucDefineConstant_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, int t );
public static int ucDefineConstant( string Definition, int t = 0) {
   return ucDefineConstant_(ref Definition,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineFunction")] public static extern int ucDefineFunction_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, ucFunctionDelegate FuncAddress , int t );
public static int ucDefineFunction( string Definition, ucFunctionDelegate FuncAddress = null, int t = 0) {
   return ucDefineFunction_(ref Definition,  FuncAddress ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineOperator")] public static extern int ucDefineOperator_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, ucFunctionDelegate FuncAddress , int t );
public static int ucDefineOperator( string Definition, ucFunctionDelegate FuncAddress = null, int t = 0) {
   return ucDefineOperator_(ref Definition,  FuncAddress ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineSyntax")] public static extern int ucDefineSyntax_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, int Rank , int t );
public static int ucDefineSyntax( string Definition, int Rank = 0, int t = 0) {
   return ucDefineSyntax_(ref Definition,  Rank ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineVariable")] public static extern int ucDefineVariable_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Definition, Int64 VarAddress , int t );
public static int ucDefineVariable( string Definition, Int64 VarAddress = 0, int t = 0) {
   return ucDefineVariable_(ref Definition,  VarAddress ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucEval")] public static extern double ucEval_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Expr, int t );
public static double ucEval( string Expr, int t = 0) {
   return ucEval_(ref Expr,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucEvalStr")] public static extern void ucEvalStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Expr, int ExprType , int t );
public static string ucEvalStr( string Expr, int ExprType = 0, int t = 0) {
   string ReturnStr = "";
   ucEvalStr_(ref ReturnStr, ref Expr,  ExprType ,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucEvaluateStr")] public static extern void ucEvaluateStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int ucItem);
public static string ucEvaluateStr(int ucItem) {
   string ReturnStr = "";
   ucEvaluateStr_(ref ReturnStr,  ucItem);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucExpand")] public static extern void ucExpand_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Expr, int t );
public static string ucExpand( string Expr, int t = 0) {
   string ReturnStr = "";
   ucExpand_(ref ReturnStr, ref Expr,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern int ucFPU(int FPU_Command, int FPU_Option = 0);
[DllImport(uCalcDLL)] public static extern int ucGetTrigMode();
[DllImport(uCalcDLL)] public static extern int ucInitialize(int NewThread = 0);
[DllImport(uCalcDLL)] public static extern int ucNewThread(int ParentThread = 0, int MakeThisDefault = 0);
[DllImport(uCalcDLL, EntryPoint="ucParse")] public static extern int ucParse_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Expr, int ExprType , int t );
public static int ucParse( string Expr, int ExprType = 0, int t = 0) {
   return ucParse_(ref Expr,  ExprType ,  t );
}
[DllImport(uCalcDLL)] public static extern int ucReleaseItem(int ucItem);
[DllImport(uCalcDLL, EntryPoint="ucRun")] public static extern void ucRun_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string RunOption, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string TextIn, int ExpandCount , int t );
public static string ucRun( string RunOption,  string TextIn, int ExpandCount = 0, int t = 0) {
   string ReturnStr = "";
   ucRun_(ref ReturnStr, ref RunOption, ref TextIn,  ExpandCount ,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucSetOutput")] public static extern int ucSetOutput_(ucFunctionDelegate FuncAddress , [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string FuncName , [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string DataType , int t );
public static int ucSetOutput(ucFunctionDelegate FuncAddress = null,  string FuncName = "",  string DataType = "", int t = 0) {
   return ucSetOutput_( FuncAddress , ref FuncName , ref DataType ,  t );
}
[DllImport(uCalcDLL)] public static extern int ucSetTrigMode(int TrigMode);

// Error handling
[DllImport(uCalcDLL)] public static extern int ucAddErrorHandler(ucErrorHandlerDelegate ErrorHandlerAddress = null, int t = 0);
[DllImport(uCalcDLL)] public static extern int ucError(int t = 0);
[DllImport(uCalcDLL, EntryPoint="ucErrorMessage")] public static extern void ucErrorMessage_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int ErrorNumber , int t );
public static string ucErrorMessage(int ErrorNumber = 0, int t = 0) {
   string ReturnStr = "";
   ucErrorMessage_(ref ReturnStr,  ErrorNumber ,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucErrorExpression")] public static extern void ucErrorExpression_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int t );
public static string ucErrorExpression(int t = 0) {
   string ReturnStr = "";
   ucErrorExpression_(ref ReturnStr,  t );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern int ucErrorLocation(int t);
[DllImport(uCalcDLL, EntryPoint="ucErrorSymbol")] public static extern void ucErrorSymbol_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int t);
public static string ucErrorSymbol(int t) {
   string ReturnStr = "";
   ucErrorSymbol_(ref ReturnStr,  t);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL)] public static extern int ucRaiseError(int Expr, int ErrorNumber);
[DllImport(uCalcDLL, EntryPoint="ucRaiseErrorMessage")] public static extern int ucRaiseErrorMessage_(int Expr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string ErrorMessage);
public static int ucRaiseErrorMessage(int Expr,  string ErrorMessage) {
   return ucRaiseErrorMessage_( Expr, ref ErrorMessage);
}
[DllImport(uCalcDLL)] public static extern int ucSetError(int ErrorNumber, int t = 0);
[DllImport(uCalcDLL, EntryPoint="ucSetErrorMessage")] public static extern int ucSetErrorMessage_(int ErrorIndex, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string ErrorMessage, int t );
public static int ucSetErrorMessage(int ErrorIndex,  string ErrorMessage, int t = 0) {
   return ucSetErrorMessage_( ErrorIndex, ref ErrorMessage,  t );
}
[DllImport(uCalcDLL)] public static extern int ucSetErrorNumber(int ErrorNumber, int t = 0);

// uCalc String Library
[DllImport(uCalcDLL)] public static extern int ucLoadStringLibInFMP(int tHandle = 0);

// uCalc String Library Routine Exports
[DllImport(uCalcDLL)] public static extern int ucBetween(int a, int b);
[DllImport(uCalcDLL, EntryPoint="ucCompare")] public static extern int ucCompare_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string String1, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string String2, int Options );
public static int ucCompare( string String1,  string String2, int Options = 0) {
   return ucCompare_(ref String1, ref String2,  Options );
}
[DllImport(uCalcDLL)] public static extern int ucCount();
[DllImport(uCalcDLL)] public static extern int ucCountSkipped();
[DllImport(uCalcDLL, EntryPoint="ucDelim")] public static extern int ucDelim_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Delim, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string L , [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string R );
public static int ucDelim( string Delim,  string L = "",  string R = "") {
   return ucDelim_(ref Delim, ref L , ref R );
}
[DllImport(uCalcDLL, EntryPoint="ucEquals")] public static extern int ucEquals_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string String1, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string String2, int Options );
public static int ucEquals( string String1,  string String2, int Options = 0) {
   return ucEquals_(ref String1, ref String2,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucInStr")] public static extern int ucInStr_(int Start, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, int Options );
public static int ucInStr(int Start,  string MainString,  string Pattern, int Options = 0) {
   return ucInStr_( Start, ref MainString, ref Pattern,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucLen")] public static extern int ucLen_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string MainString, int Options );
public static int ucLen( string MainString, int Options = 0) {
   return ucLen_(ref MainString,  Options );
}
[DllImport(uCalcDLL)] public static extern int ucLength(int x = 0);
[DllImport(uCalcDLL)] public static extern int ucLimit(int Limit);
[DllImport(uCalcDLL)] public static extern int ucNth(int Number);
[DllImport(uCalcDLL)] public static extern int ucPos(int x = 0);
[DllImport(uCalcDLL)] public static extern int ucSetStringDefaults(int Options);
[DllImport(uCalcDLL, EntryPoint="ucSkip")] public static extern int ucSkip_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string MainString);
public static int ucSkip( string MainString) {
   return ucSkip_(ref MainString);
}
[DllImport(uCalcDLL, EntryPoint="ucSplit")] public static extern int ucSplit_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Delim , int Options );
public static int ucSplit( string MainString,  string Delim = "", int Options = 0) {
   return ucSplit_(ref MainString, ref Delim ,  Options );
}
[DllImport(uCalcDLL)] public static extern int ucStart(int Position);
[DllImport(uCalcDLL)] public static extern int ucStartAfter(int Number);
[DllImport(uCalcDLL)] public static extern int ucStopAfter(int Number);
[DllImport(uCalcDLL)] public static extern int ucStringItemCount();
[DllImport(uCalcDLL, EntryPoint="ucTally")] public static extern int ucTally_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, int Options );
public static int ucTally( string MainString,  string Pattern, int Options = 0) {
   return ucTally_(ref MainString, ref Pattern,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucExtract")] public static extern void ucExtract_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, int Options );
public static string ucExtract( string MainString,  string Pattern, int Options = 0) {
   string ReturnStr = "";
   ucExtract_(ref ReturnStr, ref MainString, ref Pattern,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucFile")] public static extern void ucFile_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string NameOfFile);
public static string ucFile( string NameOfFile) {
   string ReturnStr = "";
   ucFile_(ref ReturnStr, ref NameOfFile);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucLCase")] public static extern void ucLCase_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern , int Options );
public static string ucLCase( string MainString,  string Pattern = "", int Options = 0) {
   string ReturnStr = "";
   ucLCase_(ref ReturnStr, ref MainString, ref Pattern ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucLeft")] public static extern void ucLeft_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, int Number, int Options );
public static string ucLeft( string MainString, int Number, int Options = 0) {
   string ReturnStr = "";
   ucLeft_(ref ReturnStr, ref MainString,  Number,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucMCase")] public static extern void ucMCase_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern , int Options );
public static string ucMCase( string MainString,  string Pattern = "", int Options = 0) {
   string ReturnStr = "";
   ucMCase_(ref ReturnStr, ref MainString, ref Pattern ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucMid")] public static extern void ucMid_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, int Start, int Length , int Options );
public static string ucMid( string MainString, int Start, int Length = 0, int Options = 0) {
   string ReturnStr = "";
   ucMid_(ref ReturnStr, ref MainString,  Start,  Length ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRange")] public static extern void ucRange_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int Start, int Finish, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Expression, int Options );
public static string ucRange(int Start, int Finish,  string Expression, int Options = 0) {
   string ReturnStr = "";
   ucRange_(ref ReturnStr,  Start,  Finish, ref Expression,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRemain")] public static extern void ucRemain_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, int Options );
public static string ucRemain( string MainString,  string Pattern, int Options = 0) {
   string ReturnStr = "";
   ucRemain_(ref ReturnStr, ref MainString, ref Pattern,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRemove")] public static extern void ucRemove_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, int Options );
public static string ucRemove( string MainString,  string Pattern, int Options = 0) {
   string ReturnStr = "";
   ucRemove_(ref ReturnStr, ref MainString, ref Pattern,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucReplace")] public static extern void ucReplace_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Replacement , int Options );
public static string ucReplace( string MainString,  string Pattern,  string Replacement = "", int Options = 0) {
   string ReturnStr = "";
   ucReplace_(ref ReturnStr, ref MainString, ref Pattern, ref Replacement ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRetain")] public static extern void ucRetain_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Filter , int Options );
public static string ucRetain( string MainString,  string Pattern,  string Filter = "", int Options = 0) {
   string ReturnStr = "";
   ucRetain_(ref ReturnStr, ref MainString, ref Pattern, ref Filter ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRight")] public static extern void ucRight_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, int Number, int Options );
public static string ucRight( string MainString, int Number, int Options = 0) {
   string ReturnStr = "";
   ucRight_(ref ReturnStr, ref MainString,  Number,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucStringItem")] public static extern void ucStringItem_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int Index);
public static string ucStringItem(int Index) {
   string ReturnStr = "";
   ucStringItem_(ref ReturnStr,  Index);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucUCase")] public static extern void ucUCase_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string MainString, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string Pattern , int Options );
public static string ucUCase( string MainString,  string Pattern = "", int Options = 0) {
   string ReturnStr = "";
   ucUCase_(ref ReturnStr, ref MainString, ref Pattern ,  Options );
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="uCalcRaw")] public static extern int uCalcRaw_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string ReturnStr_, int uc, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle);
public static int uCalcRaw( string ReturnStr_, int uc,  string TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle) {
   return uCalcRaw_(ref ReturnStr_,  uc, ref TextIn,  Misc1,  Misc2,  ReturnPtr,  tHandle);
}

// Deprecated notations
// Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
[DllImport(uCalcDLL, EntryPoint="ucArg")] public static extern double ucParam(int ExprHandle, int Index);
[DllImport(uCalcDLL, EntryPoint="ucArgStr")] public static extern void ucParamStr_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int ExprHandle, int Index);
public static string ucParamStr(int ExprHandle, int Index) {
   string ReturnStr = "";
   ucParamStr_(ref ReturnStr,  ExprHandle,  Index);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucArgCount")] public static extern int ucParamCount(int ExprHandle);
[DllImport(uCalcDLL, EntryPoint="ucArgHandle")] public static extern int ucParamHandle(int ExprHandle, int Index);
[DllImport(uCalcDLL, EntryPoint="ucErrorLocation")] public static extern int ucErrLocation(int t);
[DllImport(uCalcDLL, EntryPoint="ucErrorSymbol")] public static extern void ucErrSymbol_([In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string ReturnStr, int t);
public static string ucErrSymbol(int t) {
   string ReturnStr = "";
   ucErrSymbol_(ref ReturnStr,  t);
   if(ReturnStr==null) {return "";} else return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucSetErrorMessage")] public static extern int ucSetErrMsg_(int Index, [In,Out,MarshalAs(UnmanagedType.AnsiBStr)] ref string Msg);
public static int ucSetErrMsg(int Index,  string Msg) {
   return ucSetErrMsg_( Index, ref Msg);
}

}
