// ---------------------------------------------------------------------------
// uCalcDlpx64.pas: Delphi include file for uCalc Fast Math Parser 4.00
// Designed for: Delphi XE
// Instructions: Add this file to your project's directory and the uCalc DLLs
//               there as well (or copy the DLLs to a directory that is in the
//               path).  Then Add "uCalcDlp" to the "uses" section of your code
//               and you're ready go.
//
// This file auto-generated by : Delphi.uc using uCalc Transform 3.0
// Auto-generation timestamp: 08/14/14
// Delphi.uc prepared by : Daniel Corbier
// Visit www.ucalc.com for additional resources.
// ---------------------------------------------------------------------------

unit uCalcDlp;
interface
const
// Definition properties
ucAlphaNumeric = 1; 
ucArgSeparator = 2; 
ucCodeBlock = 3; 
ucCodeBlockMatch = 4; 
ucMemberAccess = 5; 
ucQuotedText = 6; 
ucStatementSep = 7; 
ucWhiteSpace = 8; 

ucCurrentThread = 9; 

ucLocalVar = 10; 
ucStaticVar = 11; 
ucDefineNow = 11;  // same as ucStaticVar
ucTempDef = 12; 
ucEvalInsert = 13; 
ucEvalDuringParse = 14; 
ucExpandInsert = 15; 
ucFileInclude = 16; 

ucCurrentSpace = 17; 
ucDefSpace = 18; 
ucEvalSpace = 19; 

ucFunction = 64; 
ucOperator = 128; 
ucVariable = 256; 
ucSyntax = 512; 
ucLiteral = 1024; 
ucSymbol = 2048; 
ucReducible = 4096; 
ucLock = 8192; 
ucInfix = 16384; 
ucPrefix = 32768; 
ucPostfix = 49152; 

// uCalc Commands
uc_Define = 1; 
uc_DefineSyntax = 2; 
uc_Eval = 3; 
uc_EvalStr = 4; 
uc_Evaluate = 5; 
uc_EvaluateLng = 6; 
uc_EvaluateStr = 7; 
uc_GetCaseSensitivity = 8; 
uc_GetDefaultPass = 9; 
uc_GetDefaultPrecedence = 10; 
uc_GetDefaultRank = 11; 
uc_GetCodeAddr = 12; 
uc_GetDefaultThread = 13; 
uc_GetDefaultType = 14; 
uc_GetDefSeparator = 15; 
uc_GetDefSpace = 16; 
uc_GetErrorNumber = 17; 
uc_GetEvalSpace = 18; 
uc_GetParentThread = 20; 
uc_GetSyntaxEqual = 21; 
uc_Parse = 22; 
uc_ReleaseItem = 23; 
uc_SetCaseSensitivity = 24; 
uc_SetCodeAddr = 25; 
uc_SetDefaultPrecedence = 26; 
uc_SetDefaultRank = 27; 
uc_SetDefaultThread = 28; 
uc_SetDefaultType = 29; 
uc_SetDefSeparator = 30; 
uc_SetErrorNumber = 31; 
uc_SetParentThread = 32; 
uc_SetSyntaxEqual = 33; 
uc_NewThread = 34; 

uc_RegExWordBoundaryChars = 35; 
uc_RegExEscapeChar = 36; 
uc_License = 37; 

// License options
uc_License_Demo = 0; 
uc_License_FMP_Free = 1; 
uc_License_FMP_Standard_32 = 2; 
uc_License_FMP_Standard_64 = 3; 
uc_License_FMP_32_and_64 = 4; 
uc_License_LanguageBuilder = 5; 
uc_License_GeneralParser = 6; 
uc_License_Interpreter = 7; 
uc_License_ConsoleCalc = 8; 
uc_License_WindowsCalc = 9; 
uc_License_StringLib = 10; 
uc_License_Transform = 11; 
uc_License_TransformLib = 12; 
uc_License_Search = 13; 
uc_License_SearchLib = 14; 
uc_License_Library1 = 15; 
uc_License_Library2 = 16; 
uc_License_Beta = 17; 
uc_License_Debugger = 18; 
uc_License_uCalc_All = 50; 
uc_License_Developer = 100; 
uc_License_EndUser = 101; 

uc_AddDebugger = 39; 
Debug_ReleaseItem = 1; 
Debug_StdFuncCall = 2; 
Debug_UserFuncCall = 3; 
Debug_GetTextToken = 4; 
Debug_ErrorHandler = 5; 
Debug_ParseExpr = 6; 
Debug_ParseItem = 7; 
Debug_EvalOperation = 8; 
Debug_DefSyntax = 9; 
Debug_Define = 10; 
Debug_DefinePart = 11; 
Debug_Expand = 12; 
Debug_ExpandSuccess = 13; 
Debug_ExpandMiss = 14; 
Debug_ExpandFail = 15; 
Debug_GetSyntaxBlock = 16; 
Debug_GetCodeBlock = 17; 
Debug_LineNumber = 18; 
Debug_TotalTally = 19; 
Debug_Breakpoint = 20; 
Debug_Delay = 21; 
Debug_JumpTo = 22; 
Debug_StepAction = 23; 

uc_AddErrorHandler = 40; 
uc_GetSymbolTable = 41; 
uc_GetSteps = 42; 
uc_GetStepsCount = 43; 

uc_SetTypeOutput = 45; 
uc_Group = 46; 
uc_GetTag = 47; 
uc_SetTag = 48; 

uc_GetCallbackData = 50; 
uc_SetCallbackReturn = 51; 

uc_GetErrorExpression = 60; 
uc_SetExpression = 61; 
uc_GetSymbol = 62; 
uc_SetSymbol = 63; 
uc_GetLocation = 64; 

uc_GetTokenType = 65; 
uc_GetTokenProperties = 66; 

uc_TrigMode = 67; 

uc_ItemClone = 70; 
uc_DataConvert = 71; 
uc_DataCopy = 72; 
uc_DataAlloc = 72; 
uc_DataFree = 73; 
uc_DataReset = 74; 

// FPU commands
uc_SetFPU = 75; 
uc_SetFPU_HostProg = 76; 
uc_GetFPU = 77; 
uc_GetFPU_HostProg = 78; 
uc_ToggleFPU = 79; 
uc_ToggleFPU_HostProg = 80; 

uc_ErrorClear = 85; 
uc_RestoreErrorMessageBox = 86; 

uc_SetErrorMessage = 91; 
uc_GetErrorMessage = 92; 

uc_SerialNumber = 93; 
uc_SetTurbo = 94; 
uc_Expand = 95; 
uc_GetNextToken = 96; 
uc_GetItemData = 97; 
uc_SetItemData = 98; 
uc_GetThreadAddr = 99; 
uc_GetCodeBlock = 100; 

uc_Status_CurrentPass = 101; 
uc_Status_MaxPass = 102; 
uc_Status_Location = 103; 
uc_Status_NestedLevel = 104; 
uc_Status_TextLength = 105; 

uc_Find = 110; 
uc_FindAddMatch = 111; 
uc_FindGetIndex = 112; 
uc_FindGetCount = 113; 
uc_FindGetStart = 114; 
uc_FindGetLength = 115; 
uc_FindGetText = 116; 
uc_FindReset = 117; 
uc_FindReplace = 118; 
uc_FindFilter = 119; 
uc_FindSetFilter = 120; 

uc_FindFilterSort = 1; 
uc_FindFilterUnique = 2; 
uc_FindFilterTally = 4; 
uc_FindFilterSeparator = 8; 
uc_FindFilterStartText = 16; 
uc_FindFilterEndText = 32; 

uc_FindContext_Other = 0; 
uc_FindContext_Found = 1; 
uc_FindContext_Replaced = 2; 

uc_FindZoomIn = 1; 
uc_FindTransformInPlace = 2; 

uc_Properties = 1; 
uc_Thread = 2; 
uc_Address = 3; 
uc_SymbolName = 4; 
uc_Rank = 5; 
uc_Precedence = 6; 
uc_OverloadHandle = 7; 
uc_OverloadCount = 8; 
uc_ByteSize = 9; 
uc_ArgCount = 10; 
uc_DataType = 12; 
uc_Handle = 13; 
uc_Value = 14; 
uc_Property = 15; 

// Error numbers
uc_Err_None = 0; 
uc_Err_Dynamically_Defined = 1; 
uc_Err_Syntax_Error = 2; 
uc_Err_Undefined_Identifier = 3; 
uc_Err_FileNotFound = 4; 
uc_Err_Unrecognized_Token = 5; 
uc_Err_Unrecognized_Command = 6; 
uc_Err_Datatype_Mismatch = 7; 
uc_Err_Invalid_Argument_Count = 8; 
uc_Err_Invalid_Definition = 9; 
uc_Err_CodeBlock_Error = 10; 
uc_Err_Undefined_Callback = 11; 
uc_Err_ErrMsgAlreadyDefined = 12; 
uc_Err_ItemCannotBeModified = 13; 
uc_Err_Unrecognized_Member = 14; 
uc_Err_Unbalanced_Quote = 15; 

uc_Err_Array_Bounds_Exceeded = 20; 
uc_Err_Float_Denormal_Operand = 21; 
uc_Err_Float_Divide_By_Zero = 22; 
uc_Err_Float_Inexact_Result = 23; 
uc_Err_Float_Invalid_Operation = 24; 
uc_Err_Float_Overflow = 25; 
uc_Err_Float_Stack_Check = 26; 
uc_Err_Float_Underflow = 27; 
uc_Err_Integer_Divide_By_Zero = 28; 
uc_Err_Integer_Overflow = 29; 
uc_Err_Privileged_Instruction = 30; 

// Error response
ucAbort = 0; 
ucResume = 1; 
ucReRaise = 2; 

// FPU Control Word Settings
uc_FPU_Mask_InvalidOp = 1; 
uc_FPU_Mask_DenormalOp = 2; 
uc_FPU_Mask_ZeroDivide = 4; 
uc_FPU_Mask_Overflow = 8; 
uc_FPU_Mask_Underflow = 16; 
uc_FPU_Mask_PrecisionLoss = 32; 

uc_FPU_Precision_Single = 0; 
uc_FPU_Precision_Double = 256; 
uc_FPU_Precision_Extended = 768; 

uc_FPU_Round_Even = 0; 
uc_FPU_Round_Down = 1024; 
uc_FPU_Round_Up = 2048; 
uc_FPU_Round_Toward = 3072; 

// Data type handler callback action modes
uc_TypeHandler_Store = 2; 
uc_TypeHandler_StringOutput = 3; 
uc_TypeHandler_Free = 4; 
uc_TypeHandler_FuncRet = 5; 
uc_TypeHandler_Copy = 6; 
uc_TypeHandler_Alloc = 7; 
uc_TypeHandler_Reset = 8; 

uc_Callback_Undefined = 0;  // Returns error

// Data Type callbacks
uc_Complex = 1; 
uc_Currency = 2; 
uc_Double = 3; 
uc_Extended = 4; 
uc_Int8 = 5; 
uc_Int8u = 6; 
uc_Int16 = 7; 
uc_Int16u = 8; 
uc_Int32 = 9; 
uc_Int32u = 10; 
uc_Int64 = 11; 
uc_Int64u = 12; 
uc_Single = 13; 
uc_String = 14; 
uc_String_LPCSTR = 15; 
uc_String_Fixed = 16; 
uc_String_Wide = 17; 
uc_Stack = 18; 
uc_Table = 19; 
uc_SortedList = 20; 
uc_Void = 21; 
uc_User_Type = 22; 

uc_Convert_Generic = 23; 
uc_Convert_Same = 24; 
uc_Convert_Double_Extended = 25; 
uc_Convert_Int8_Extended = 26; 
uc_Convert_Int8u_Extended = 27; 
uc_Convert_Int16_Extended = 28; 
uc_Convert_Int16u_Extended = 29; 
uc_Convert_Int32_Extended = 30; 
uc_Convert_Int32u_Extended = 31; 
uc_Convert_Int64_Extended = 32; 
uc_Convert_Int64u_Extended = 33; 
uc_Convert_Single_Extended = 34; 
uc_Convert_Void_Extended = 35; 
uc_Convert_Extended_Double = 37; 
uc_Convert_Extended_Single = 38; 
uc_Convert_Extended_Int16u = 39; 
uc_Convert_Extended_Int32 = 40; 
uc_Convert_Complex_Extended = 41; 
uc_Convert_Extended_Complex = 42; 

// Default built-in routines
uc_Op_Negate = 43; 
uc_Op_UnaryPlus = 44; 
uc_Op_Percentage = 45; 
uc_Op_StrConcat = 46; 
uc_Op_Add_Int32 = 47; 
uc_Op_Add = 48; 
uc_Op_Add_Complex = 49; 
uc_Op_Subtract_Int32 = 50; 
uc_Op_Subtract = 51; 
uc_Op_Multiply_Int32 = 52; 
uc_Op_Multiply = 53; 
uc_Op_Multiply_Complex = 54; 
uc_Op_Divide_Int32 = 55; 
uc_Op_Divide = 56; 
uc_Op_Mod_Int32 = 57; 
uc_Op_Mod = 58; 
uc_Op_PowerOf_ExtToExt = 59; 
uc_Op_PowerOf_ExtToLng = 60; 
uc_Op_PowerOf_CplxToCplx = 61; 

uc_Op_GreaterThan = 62; 
uc_Op_GreaterOrEqual = 63; 
uc_Op_LessThan = 64; 
uc_Op_LessOrEqual = 65; 
uc_Op_Equal = 66; 
uc_Op_NotEqual = 67; 

uc_Op_GreaterThan_Str = 68; 
uc_Op_GreaterOrEqual_Str = 69; 
uc_Op_LessThan_Str = 70; 
uc_Op_LessOrEqual_Str = 71; 
uc_Op_Equal_Str = 72; 
uc_Op_NotEqual_Str = 73; 

uc_Op_Not_Int32 = 74; 
uc_Op_And_Int32 = 75; 
uc_Op_Or_Int32 = 76; 
uc_Op_Xor_Int32 = 77; 
uc_Op_Eqv_Int32 = 78; 
uc_Op_Imp_Int32 = 79; 

uc_Op_AndAlso = 80; 
uc_Op_OrElse = 81; 

uc_Op_Factorial = 82; 

uc_Func_IIf = 83; 
uc_Func_IIf_Str = 84; 

uc_Func_Sin = 85; 
uc_Func_Cos = 86; 
uc_Func_Tan = 87; 
uc_Func_Atan = 88; 
uc_Func_Ceil = 89; 
uc_Func_Abs = 90; 
uc_Func_Abs_Int32 = 91; 
uc_Func_Exp = 92; 
uc_Func_Log = 93; 
uc_Func_Floor = 94; 
uc_Func_SquareRoot = 95; 
uc_Func_BaseConvert = 96; 

uc_Func_ExprHandle = 97; 
uc_Func_VarPtr = 98; 
uc_Func_uCalc = 99; 
uc_Func_uCalcStr = 100; 
uc_Func_ucAddr = 101; 
uc_Func_ValueAtAddr = 102; 
uc_Func_SpecialArg = 103; 
uc_Op_StringMult = 104; 

uc_Func_For = 105; 
uc_Func_Loop = 107; 

uc_Func_LoadLibrary = 108; 
uc_Func_GetProcAddress = 109; 

uc_NullString = 110; 
uc_True = 111; 

uc_Func_Peek = 112; 
uc_Func_Poke = 113; 

uc_Func_Int = 115; 
uc_Func_Frac = 116; 
uc_Func_Sgn = 117; 

uc_Func_PushData_Stack = 120; 
// uc_Func_PopHandle_Stack = 121; 
uc_Func_PopNum_Stack = 122; 
uc_Func_PopStr_Stack = 123; 
uc_Func_ReadHandle_Stack = 124; 
uc_Func_ReadNum_Stack = 125; 
uc_Func_ReadStr_Stack = 126; 
uc_Func_Count_Stack = 127; 
uc_Op_Concat_Stack = 128; 
uc_Func_Populate_Stack = 129; 

uc_Insert_Table = 130; 
uc_Delete_Table = 131; 
uc_Index_Table = 132; 
uc_Handle_Table = 133; 
uc_HandleB_Table = 134; 
uc_ReadData_Table = 135; 
uc_ReadNum_Table = 136; 

uc_Func_Min = 137; 
uc_Func_Max = 138; 
uc_Func_Min_Str = 139; 
uc_Func_Max_Str = 140; 

uc_SetVariableValue = 141; 
uc_SetVariableValueAnyType = 141; 
uc_SetVariableValueLong = 142; 
uc_SetVariableValueDouble = 143; 
uc_SetVariableValueExtended = 144; 
uc_ResetVariable = 145; 

// Misc other callbacks
uc_EvaluateAddr = 150; 
uc_EvaluateTurboAddr = 151; 
uc_ExceptionHelper = 152; 
uc_DefaultErrorHandler = 153; 
uc_Raise_Error = 154; 
uc_Func_IsIncomplete = 155; 

uc_ScriptTimerStart = 160; 
uc_LoadTimeTix = 161; 

uc_Op_Ext_Plus_Complex = 190; 
uc_Op_Ext_Times_Complex = 191; 

uc_Func_If_ElseIf = 195; 
uc_Func_SetSyntaxParams = 196; 
uc_Func_SpecialUCase = 197; 
uc_Func_Rand = 198; 
uc_Func_GetmatchArg = 199; 
uc_Func_PatternNum = 200; 
uc_Func_PatternStr = 201; 

uc_Convert_Stack_Table = 220; 
uc_Convert_Stack_SortedList = 221; 
uc_Convert_Table_Stack = 222; 
uc_Convert_SortedList_Stack = 223; 

uc_Expand_List = 1; 
uc_Expand_StackPtr = 2; 

uc_HandleToken = 21;  // &h15

// Trig Mode
uc_ReturnTrigMode = 0; 
uc_Radians = 1; 
uc_Degrees = 2; 
uc_Grad = 3; 

// Misc
ucTrue = 1; 
ucFalse = 0; 
uc_Rank_First = 1; 
uc_Rank_Last = -1; 

// Pattern options
uc_Pattern_ArgCount = 1; 
uc_Pattern_ArgIndex = 2; 
uc_Pattern_ArgLength = 3; 
uc_Pattern_ArgLocation = 4; 
uc_Pattern_ArgText = 5; 
uc_Pattern_DocumentLength = 6; 
uc_Pattern_DocumentText = 7; 
uc_Pattern_CriteriaCount = 8; 
uc_Pattern_CriteriaIndex = 9; 
uc_Pattern_MatchLength = 10; 
uc_Pattern_MatchLocation = 11; 
uc_Pattern_MatchText = 12; 
uc_Pattern_MatchTally = 13; 
uc_Pattern_SkipTally = 14; 

// String Library
uc_StringLibNum = 230; 
uc_StringLibStr = 231; 
ucs_SetStringDefaults = 4; 
ucs_Start = 5; 
ucs_Limit = 6; 
ucs_StartAfter = 7; 
ucs_StopAfter = 8; 
ucs_Between = 9; 
ucs_Nth = 10; 
ucs_File = 11; 
ucs_Pos = 12; 
ucs_Length = 13; 
ucs_Text = 14; 
ucs_Count = 15; 
ucs_CountSkipped = 16; 
ucs_InStr = 17; 
ucs_Tally = 18; 
ucs_UCase = 19; 
ucs_LCase = 20; 
ucs_MCase = 21; 
ucs_Replace = 22; 
ucs_Remove = 23; 
ucs_Mid = 24; 
ucs_Left = 25; 
ucs_Right = 26; 
ucs_Len = 27; 
ucs_Extract = 28; 
ucs_Remain = 29; 
ucs_Skip = 30; 
ucs_Delim = 31; 
ucs_Retain = 32; 
ucs_Range = 33; 
ucs_Compare = 34; 
ucs_Equals = 35; 
ucs_Split = 36; 
ucs_StringItem = 37; 
ucs_StringItemCount = 38; 

// String Libarary Options
ucByte = 1; 
ucChar = 2; 
ucWord = 4; 
ucToken = 8; 
ucBlock = 16; 
ucExpr = 32; 
ucQuote = 64; 
ucSpace = 128; 
ucCase = 256; 
// End Of String Library Options

// Main Functions
function ucAddr(AddressIndex: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function uCalc_(ucCommand: LongInt; var TextIn: AnsiString ; a: LongInt ; b: LongInt ; c: LongInt ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'uCalc';
function uCalc(ucCommand: LongInt;  TextIn: AnsiString = ''; a: LongInt = 0; b: LongInt = 0; c: LongInt = 0; t: LongInt = 0): LongInt;

// Insert Other Exports
function ExceptionHelper(Expr: LongInt; SystemError: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucEvaluate(Item: LongInt): Extended; stdcall; external 'uCalc64v400.dll';
function ucArgLng(Expr: LongInt; index: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucArg(Expr: LongInt; index: LongInt): Extended; stdcall; external 'uCalc64v400.dll';
procedure ucArgStr_(var ReturnStr: Pointer; Expr: LongInt; index: LongInt); stdcall; external 'uCalc64v400.dll' name 'ucArgStr';
function ucArgStr(Expr: LongInt; index: LongInt): AnsiString;
function ucArgHandle(Expr: LongInt; index: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucArgCount(Expr: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
procedure ucReturnLng(Expr: LongInt; ReturnValue: LongInt); stdcall; external 'uCalc64v400.dll';
procedure ucReturn(Expr: LongInt; ReturnValue: Extended); stdcall; external 'uCalc64v400.dll' name 'ucReturnExt';
procedure ucReturnStr_(Expr: LongInt; var ReturnValue: AnsiString); stdcall; external 'uCalc64v400.dll' name 'ucReturnStr';
procedure ucReturnStr(Expr: LongInt;  ReturnValue: AnsiString);
function ucGetVariableValue(Item: LongInt): Extended; stdcall; external 'uCalc64v400.dll';
function ucGetVariableValueLng(Item: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
procedure ucGetVariableValueStr_(var ReturnStr: Pointer; Item: LongInt); stdcall; external 'uCalc64v400.dll' name 'ucGetVariableValueStr';
function ucGetVariableValueStr(Item: LongInt): AnsiString;
procedure ucSetVariableValueLng(Item: LongInt; NewValue: LongInt); stdcall; external 'uCalc64v400.dll';
procedure ucSetVariableValue(Item: LongInt; NewValue: Extended); stdcall; external 'uCalc64v400.dll' name 'ucSetVariableValueExt';
procedure ucSetVariableValueStr_(Item: LongInt; var NewValue: AnsiString); stdcall; external 'uCalc64v400.dll' name 'ucSetVariableValueStr';
procedure ucSetVariableValueStr(Item: LongInt;  NewValue: AnsiString);
function ucExprThread(Expr: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucLicense(Product: LongInt; L1: LongWord = 0; L2: LongWord = 0; L3: LongWord = 0; L4: LongWord = 0; L5: LongWord = 0): LongInt; stdcall; external 'uCalc64v400.dll';
// End Insert
procedure uCalcStr_(var ReturnStr: Pointer; ucCommand: LongInt; var TextIn: AnsiString ; a: LongInt ; b: LongInt ; c: LongInt ; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'uCalcStr';
function uCalcStr(ucCommand: LongInt;  TextIn: AnsiString = ''; a: LongInt = 0; b: LongInt = 0; c: LongInt = 0; t: LongInt = 0): AnsiString;
function ucClose32bitDLL(ReserverdArg: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucDefine_(var Definition: AnsiString; Arg1: LongInt ; Arg2: LongInt ; Arg3: LongInt ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefine';
function ucDefine( Definition: AnsiString; Arg1: LongInt = 0; Arg2: LongInt = 0; Arg3: LongInt = 0; t: LongInt = 0): LongInt;
function ucDefineConstant_(var Definition: AnsiString; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefineConstant';
function ucDefineConstant( Definition: AnsiString; t: LongInt = 0): LongInt;
function ucDefineFunction_(var Definition: AnsiString; FunctionAddress: Pointer ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefineFunction';
function ucDefineFunction( Definition: AnsiString; FunctionAddress: Pointer = nil; t: LongInt = 0): LongInt;
function ucDefineOperator_(var Definition: AnsiString; FunctionAddress: Pointer ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefineOperator';
function ucDefineOperator( Definition: AnsiString; FunctionAddress: Pointer = nil; t: LongInt = 0): LongInt;
function ucDefineSyntax_(var Definition: AnsiString; Rank: LongInt ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefineSyntax';
function ucDefineSyntax( Definition: AnsiString; Rank: LongInt = 0; t: LongInt = 0): LongInt;
function ucDefineVariable_(var Definition: AnsiString; VarAddress: Pointer ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDefineVariable';
function ucDefineVariable( Definition: AnsiString; VarAddress: Pointer = nil; t: LongInt = 0): LongInt;
function ucEval_(var Expr: AnsiString; t: LongInt ): Extended; stdcall; external 'uCalc64v400.dll' name 'ucEval';
function ucEval( Expr: AnsiString; t: LongInt = 0): Extended;
procedure ucEvalStr_(var ReturnStr: Pointer; var Expr: AnsiString; ExprType: LongInt ; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucEvalStr';
function ucEvalStr(Expr: AnsiString; ExprType: LongInt = 0; t: LongInt = 0): AnsiString;
procedure ucEvaluateStr_(var ReturnStr: Pointer; ucItem: LongInt); stdcall; external 'uCalc64v400.dll' name 'ucEvaluateStr';
function ucEvaluateStr(ucItem: LongInt): AnsiString;
procedure ucExpand_(var ReturnStr: Pointer; var Expr: AnsiString; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucExpand';
function ucExpand(Expr: AnsiString; t: LongInt = 0): AnsiString;
function ucFPU(FPU_Command: LongInt; FPU_Option: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucGetTrigMode(): LongInt; stdcall; external 'uCalc64v400.dll';
function ucInitialize(NewThread: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucNewThread(ParentThread: LongInt = 0; MakeThisDefault: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucParse_(var Expr: AnsiString; ExprType: LongInt ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucParse';
function ucParse( Expr: AnsiString; ExprType: LongInt = 0; t: LongInt = 0): LongInt;
function ucReleaseItem(ucItem: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
procedure ucRun_(var ReturnStr: Pointer; var RunOption: AnsiString; var TextIn: AnsiString; ExpandCount: LongInt ; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRun';
function ucRun(RunOption: AnsiString;  TextIn: AnsiString; ExpandCount: LongInt = 0; t: LongInt = 0): AnsiString;
function ucSetOutput_(FunctionAddress: Pointer ; var FuncName: AnsiString ; var DataType: AnsiString ; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucSetOutput';
function ucSetOutput(FunctionAddress: Pointer = nil;  FuncName: AnsiString = '';  DataType: AnsiString = ''; t: LongInt = 0): LongInt;
function ucSetTrigMode(TrigMode: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';

// Error handling
function ucAddErrorHandler(ErrorHandlerAddress: Pointer = nil; t: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucError(t: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
procedure ucErrorMessage_(var ReturnStr: Pointer; ErrorNumber: LongInt ; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucErrorMessage';
function ucErrorMessage(ErrorNumber: LongInt = 0; t: LongInt = 0): AnsiString;
procedure ucErrorExpression_(var ReturnStr: Pointer; t: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucErrorExpression';
function ucErrorExpression(t: LongInt = 0): AnsiString;
function ucErrorLocation(t: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
procedure ucErrorSymbol_(var ReturnStr: Pointer; t: LongInt); stdcall; external 'uCalc64v400.dll' name 'ucErrorSymbol';
function ucErrorSymbol(t: LongInt): AnsiString;
function ucRaiseError(Expr: LongInt; ErrorNumber: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucRaiseErrorMessage_(Expr: LongInt; var ErrorMessage: AnsiString): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucRaiseErrorMessage';
function ucRaiseErrorMessage(Expr: LongInt;  ErrorMessage: AnsiString): LongInt;
function ucSetError(ErrorNumber: LongInt; t: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucSetErrorMessage_(ErrorIndex: LongInt; var ErrorMessage: AnsiString; t: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucSetErrorMessage';
function ucSetErrorMessage(ErrorIndex: LongInt;  ErrorMessage: AnsiString; t: LongInt = 0): LongInt;
function ucSetErrorNumber(ErrorNumber: LongInt; t: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';

// uCalc String Library
function ucLoadStringLibInFMP(tHandle: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';

// uCalc String Library Routine Exports
function ucBetween(a: LongInt; b: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucCompare_(var String1: AnsiString; var String2: AnsiString; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucCompare';
function ucCompare( String1: AnsiString;  String2: AnsiString; Options: LongInt = 0): LongInt;
function ucCount(): LongInt; stdcall; external 'uCalc64v400.dll';
function ucCountSkipped(): LongInt; stdcall; external 'uCalc64v400.dll';
function ucDelim_(var Delim: AnsiString; var L: AnsiString ; var R: AnsiString ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucDelim';
function ucDelim( Delim: AnsiString;  L: AnsiString = '';  R: AnsiString = ''): LongInt;
function ucEquals_(var String1: AnsiString; var String2: AnsiString; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucEquals';
function ucEquals( String1: AnsiString;  String2: AnsiString; Options: LongInt = 0): LongInt;
function ucInStr_(Start: LongInt; var MainString: AnsiString; var Pattern: AnsiString; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucInStr';
function ucInStr(Start: LongInt;  MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): LongInt;
function ucLen_(var MainString: AnsiString; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucLen';
function ucLen( MainString: AnsiString; Options: LongInt = 0): LongInt;
function ucLength(x: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucLimit(Limit: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucNth(Number: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucPos(x: LongInt = 0): LongInt; stdcall; external 'uCalc64v400.dll';
function ucSetStringDefaults(Options: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucSkip_(var MainString: AnsiString): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucSkip';
function ucSkip( MainString: AnsiString): LongInt;
function ucSplit_(var MainString: AnsiString; var Delim: AnsiString ; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucSplit';
function ucSplit( MainString: AnsiString;  Delim: AnsiString = ''; Options: LongInt = 0): LongInt;
function ucStart(Position: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucStartAfter(Number: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucStopAfter(Number: LongInt): LongInt; stdcall; external 'uCalc64v400.dll';
function ucStringItemCount(): LongInt; stdcall; external 'uCalc64v400.dll';
function ucTally_(var MainString: AnsiString; var Pattern: AnsiString; Options: LongInt ): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucTally';
function ucTally( MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): LongInt;
procedure ucExtract_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucExtract';
function ucExtract(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
procedure ucFile_(var ReturnStr: Pointer; var NameOfFile: AnsiString); stdcall; external 'uCalc64v400.dll' name 'ucFile';
function ucFile(NameOfFile: AnsiString): AnsiString;
procedure ucLCase_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucLCase';
function ucLCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
procedure ucLeft_(var ReturnStr: Pointer; var MainString: AnsiString; Number: LongInt; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucLeft';
function ucLeft(MainString: AnsiString; Number: LongInt; Options: LongInt = 0): AnsiString;
procedure ucMCase_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucMCase';
function ucMCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
procedure ucMid_(var ReturnStr: Pointer; var MainString: AnsiString; Start: LongInt; Length: LongInt ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucMid';
function ucMid(MainString: AnsiString; Start: LongInt; Length: LongInt = 0; Options: LongInt = 0): AnsiString;
procedure ucRange_(var ReturnStr: Pointer; Start: LongInt; Finish: LongInt; var Expression: AnsiString; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRange';
function ucRange(Start: LongInt; Finish: LongInt;  Expression: AnsiString; Options: LongInt = 0): AnsiString;
procedure ucRemain_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRemain';
function ucRemain(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
procedure ucRemove_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRemove';
function ucRemove(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
procedure ucReplace_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString; var Replacement: AnsiString ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucReplace';
function ucReplace(MainString: AnsiString;  Pattern: AnsiString;  Replacement: AnsiString = ''; Options: LongInt = 0): AnsiString;
procedure ucRetain_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString; var Filter: AnsiString ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRetain';
function ucRetain(MainString: AnsiString;  Pattern: AnsiString;  Filter: AnsiString = ''; Options: LongInt = 0): AnsiString;
procedure ucRight_(var ReturnStr: Pointer; var MainString: AnsiString; Number: LongInt; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucRight';
function ucRight(MainString: AnsiString; Number: LongInt; Options: LongInt = 0): AnsiString;
procedure ucStringItem_(var ReturnStr: Pointer; Index: LongInt); stdcall; external 'uCalc64v400.dll' name 'ucStringItem';
function ucStringItem(Index: LongInt): AnsiString;
procedure ucUCase_(var ReturnStr: Pointer; var MainString: AnsiString; var Pattern: AnsiString ; Options: LongInt ); stdcall; external 'uCalc64v400.dll' name 'ucUCase';
function ucUCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
function uCalcRaw_(var ReturnStr_: AnsiString; uc: LongInt; var TextIn: AnsiString; Misc1: LongInt; Misc2: LongInt; ReturnPtr: LongInt; tHandle: LongInt): LongInt; stdcall; external 'uCalc64v400.dll' name 'uCalcRaw';
function uCalcRaw( ReturnStr_: AnsiString; uc: LongInt;  TextIn: AnsiString; Misc1: LongInt; Misc2: LongInt; ReturnPtr: LongInt; tHandle: LongInt): LongInt;

// Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
function ucParam(ExprHandle: LongInt; Index: LongInt): Extended; stdcall; external 'uCalc64v400.dll' name 'ucArg';
function ucParamStr(ExprHandle: LongInt; Index: LongInt): AnsiString; stdcall; external 'uCalc64v400.dll' name 'ucArgStr';
function ucParamCount(ExprHandle: LongInt): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucArgCount';
function ucParamHandle(ExprHandle: LongInt; Index: LongInt): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucArgHandle';
function ucErrLocation(t: LongInt): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucErrorLocation';
function ucErrSymbol(t: LongInt): AnsiString; stdcall; external 'uCalc64v400.dll' name 'ucErrorSymbol';
function ucSetErrMsg_(Index: LongInt; var Msg: AnsiString): LongInt; stdcall; external 'uCalc64v400.dll' name 'ucSetErrorMessage';
function ucSetErrMsg(Index: LongInt;  Msg: AnsiString): LongInt;

implementation
uses ActiveX;

function uCalc(ucCommand: LongInt;  TextIn: AnsiString = ''; a: LongInt = 0; b: LongInt = 0; c: LongInt = 0; t: LongInt = 0): LongInt;
begin
    uCalc := uCalc_(ucCommand,  TextIn, a, b, c, t);
end;

function ucArgStr(Expr: LongInt; index: LongInt): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucArgStr_( ReturnStr, Expr, index);
   ucArgStr := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

procedure ucReturnStr(Expr: LongInt;  ReturnValue: AnsiString);
begin
   ucReturnStr_(Expr,  ReturnValue);
end;

function ucGetVariableValueStr(Item: LongInt): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucGetVariableValueStr_( ReturnStr, Item);
   ucGetVariableValueStr := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

procedure ucSetVariableValueStr(Item: LongInt;  NewValue: AnsiString);
begin
   ucSetVariableValueStr_(Item,  NewValue);
end;

function uCalcStr(ucCommand: LongInt;  TextIn: AnsiString = ''; a: LongInt = 0; b: LongInt = 0; c: LongInt = 0; t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   uCalcStr_( ReturnStr, ucCommand,  TextIn, a, b, c, t);
   uCalcStr := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucDefine( Definition: AnsiString; Arg1: LongInt = 0; Arg2: LongInt = 0; Arg3: LongInt = 0; t: LongInt = 0): LongInt;
begin
    ucDefine := ucDefine_( Definition, Arg1, Arg2, Arg3, t);
end;

function ucDefineConstant( Definition: AnsiString; t: LongInt = 0): LongInt;
begin
    ucDefineConstant := ucDefineConstant_( Definition, t);
end;

function ucDefineFunction( Definition: AnsiString; FunctionAddress: Pointer = nil; t: LongInt = 0): LongInt;
begin
    ucDefineFunction := ucDefineFunction_( Definition, FunctionAddress, t);
end;

function ucDefineOperator( Definition: AnsiString; FunctionAddress: Pointer = nil; t: LongInt = 0): LongInt;
begin
    ucDefineOperator := ucDefineOperator_( Definition, FunctionAddress, t);
end;

function ucDefineSyntax( Definition: AnsiString; Rank: LongInt = 0; t: LongInt = 0): LongInt;
begin
    ucDefineSyntax := ucDefineSyntax_( Definition, Rank, t);
end;

function ucDefineVariable( Definition: AnsiString; VarAddress: Pointer = nil; t: LongInt = 0): LongInt;
begin
    ucDefineVariable := ucDefineVariable_( Definition, VarAddress, t);
end;

function ucEval( Expr: AnsiString; t: LongInt = 0): Extended;
begin
    ucEval := ucEval_( Expr, t);
end;

function ucEvalStr(Expr: AnsiString; ExprType: LongInt = 0; t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucEvalStr_( ReturnStr,  Expr, ExprType, t);
   ucEvalStr := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucEvaluateStr(ucItem: LongInt): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucEvaluateStr_( ReturnStr, ucItem);
   ucEvaluateStr := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucExpand(Expr: AnsiString; t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucExpand_( ReturnStr,  Expr, t);
   ucExpand := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucParse( Expr: AnsiString; ExprType: LongInt = 0; t: LongInt = 0): LongInt;
begin
    ucParse := ucParse_( Expr, ExprType, t);
end;

function ucRun(RunOption: AnsiString;  TextIn: AnsiString; ExpandCount: LongInt = 0; t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRun_( ReturnStr,  RunOption,  TextIn, ExpandCount, t);
   ucRun := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucSetOutput(FunctionAddress: Pointer = nil;  FuncName: AnsiString = '';  DataType: AnsiString = ''; t: LongInt = 0): LongInt;
begin
    ucSetOutput := ucSetOutput_(FunctionAddress,  FuncName,  DataType, t);
end;

function ucErrorMessage(ErrorNumber: LongInt = 0; t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucErrorMessage_( ReturnStr, ErrorNumber, t);
   ucErrorMessage := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucErrorExpression(t: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucErrorExpression_( ReturnStr, t);
   ucErrorExpression := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucErrorSymbol(t: LongInt): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucErrorSymbol_( ReturnStr, t);
   ucErrorSymbol := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRaiseErrorMessage(Expr: LongInt;  ErrorMessage: AnsiString): LongInt;
begin
    ucRaiseErrorMessage := ucRaiseErrorMessage_(Expr,  ErrorMessage);
end;

function ucSetErrorMessage(ErrorIndex: LongInt;  ErrorMessage: AnsiString; t: LongInt = 0): LongInt;
begin
    ucSetErrorMessage := ucSetErrorMessage_(ErrorIndex,  ErrorMessage, t);
end;

function ucCompare( String1: AnsiString;  String2: AnsiString; Options: LongInt = 0): LongInt;
begin
    ucCompare := ucCompare_( String1,  String2, Options);
end;

function ucDelim( Delim: AnsiString;  L: AnsiString = '';  R: AnsiString = ''): LongInt;
begin
    ucDelim := ucDelim_( Delim,  L,  R);
end;

function ucEquals( String1: AnsiString;  String2: AnsiString; Options: LongInt = 0): LongInt;
begin
    ucEquals := ucEquals_( String1,  String2, Options);
end;

function ucInStr(Start: LongInt;  MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): LongInt;
begin
    ucInStr := ucInStr_(Start,  MainString,  Pattern, Options);
end;

function ucLen( MainString: AnsiString; Options: LongInt = 0): LongInt;
begin
    ucLen := ucLen_( MainString, Options);
end;

function ucSkip( MainString: AnsiString): LongInt;
begin
    ucSkip := ucSkip_( MainString);
end;

function ucSplit( MainString: AnsiString;  Delim: AnsiString = ''; Options: LongInt = 0): LongInt;
begin
    ucSplit := ucSplit_( MainString,  Delim, Options);
end;

function ucTally( MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): LongInt;
begin
    ucTally := ucTally_( MainString,  Pattern, Options);
end;

function ucExtract(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucExtract_( ReturnStr,  MainString,  Pattern, Options);
   ucExtract := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucFile(NameOfFile: AnsiString): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucFile_( ReturnStr,  NameOfFile);
   ucFile := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucLCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucLCase_( ReturnStr,  MainString,  Pattern, Options);
   ucLCase := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucLeft(MainString: AnsiString; Number: LongInt; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucLeft_( ReturnStr,  MainString, Number, Options);
   ucLeft := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucMCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucMCase_( ReturnStr,  MainString,  Pattern, Options);
   ucMCase := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucMid(MainString: AnsiString; Start: LongInt; Length: LongInt = 0; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucMid_( ReturnStr,  MainString, Start, Length, Options);
   ucMid := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRange(Start: LongInt; Finish: LongInt;  Expression: AnsiString; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRange_( ReturnStr, Start, Finish,  Expression, Options);
   ucRange := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRemain(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRemain_( ReturnStr,  MainString,  Pattern, Options);
   ucRemain := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRemove(MainString: AnsiString;  Pattern: AnsiString; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRemove_( ReturnStr,  MainString,  Pattern, Options);
   ucRemove := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucReplace(MainString: AnsiString;  Pattern: AnsiString;  Replacement: AnsiString = ''; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucReplace_( ReturnStr,  MainString,  Pattern,  Replacement, Options);
   ucReplace := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRetain(MainString: AnsiString;  Pattern: AnsiString;  Filter: AnsiString = ''; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRetain_( ReturnStr,  MainString,  Pattern,  Filter, Options);
   ucRetain := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucRight(MainString: AnsiString; Number: LongInt; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucRight_( ReturnStr,  MainString, Number, Options);
   ucRight := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucStringItem(Index: LongInt): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucStringItem_( ReturnStr, Index);
   ucStringItem := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function ucUCase(MainString: AnsiString;  Pattern: AnsiString = ''; Options: LongInt = 0): AnsiString;
var
   ReturnStr: Pointer;
begin
   ReturnStr := SysAllocStringByteLen(nil, 0);
   ucUCase_( ReturnStr,  MainString,  Pattern, Options);
   ucUCase := PAnsiChar(ReturnStr);
   SysFreeString(ReturnStr);
end;

function uCalcRaw( ReturnStr_: AnsiString; uc: LongInt;  TextIn: AnsiString; Misc1: LongInt; Misc2: LongInt; ReturnPtr: LongInt; tHandle: LongInt): LongInt;
begin
    uCalcRaw := uCalcRaw_( ReturnStr_, uc,  TextIn, Misc1, Misc2, ReturnPtr, tHandle);
end;

function ucSetErrMsg(Index: LongInt;  Msg: AnsiString): LongInt;
begin
    ucSetErrMsg := ucSetErrMsg_(Index,  Msg);
end;


end.
