' ---------------------------------------------------------------------------
' uCalcPB.Bas: PowerBASIC include file for uCalc Fast Math Parser 4.00
' Designed for : PB/CC 5+ and PB/Win 9+
' Instruction: Add the following line to your program and you're ready to go:
'              #Include "uCalcPB.Bas"
'
' This file auto-generated by : PowerBASIC.uc using uCalc Transform 3.0
' Auto-generation timestamp: 08/14/14
' PowerBASIC.uc prepared by : Daniel Corbier
' Visit www.ucalc.com for additional resources.
' ---------------------------------------------------------------------------

' Definition properties
%ucAlphaNumeric   = 1
%ucArgSeparator   = 2
%ucCodeBlock      = 3
%ucCodeBlockMatch = 4
%ucMemberAccess   = 5
%ucQuotedText     = 6
%ucStatementSep   = 7
%ucWhiteSpace     = 8

%ucCurrentThread  = 9

%ucLocalVar        = 10
%ucStaticVar       = 11
%ucDefineNow       = 11 ' same as ucStaticVar
%ucTempDef         = 12
%ucEvalInsert      = 13
%ucEvalDuringParse = 14
%ucExpandInsert    = 15
%ucFileInclude     = 16

%ucCurrentSpace    = 17
%ucDefSpace        = 18
%ucEvalSpace       = 19

%ucFunction       = 64
%ucOperator       = 128
%ucVariable       = 256
%ucSyntax         = 512
%ucLiteral        = 1024
%ucSymbol         = 2048
%ucReducible      = 4096
%ucLock           = 8192
%ucInfix          = 16384
%ucPrefix         = 32768
%ucPostfix        = 49152

' uCalc Commands
%uc_Define               = 1
%uc_DefineSyntax         = 2
%uc_Eval                 = 3
%uc_EvalStr              = 4
%uc_Evaluate             = 5
%uc_EvaluateLng          = 6
%uc_EvaluateStr          = 7
%uc_GetCaseSensitivity   = 8
%uc_GetDefaultPass       = 9
%uc_GetDefaultPrecedence = 10
%uc_GetDefaultRank       = 11
%uc_GetCodeAddr = 12
%uc_GetDefaultThread     = 13
%uc_GetDefaultType       = 14
%uc_GetDefSeparator      = 15
%uc_GetDefSpace          = 16
%uc_GetErrorNumber       = 17
%uc_GetEvalSpace         = 18
%uc_GetParentThread      = 20
%uc_GetSyntaxEqual       = 21
%uc_Parse                = 22
%uc_ReleaseItem          = 23
%uc_SetCaseSensitivity   = 24
%uc_SetCodeAddr          = 25
%uc_SetDefaultPrecedence = 26
%uc_SetDefaultRank       = 27
%uc_SetDefaultThread     = 28
%uc_SetDefaultType       = 29
%uc_SetDefSeparator      = 30
%uc_SetErrorNumber       = 31
%uc_SetParentThread      = 32
%uc_SetSyntaxEqual       = 33
%uc_NewThread            = 34

%uc_RegExWordBoundaryChars = 35
%uc_RegExEscapeChar = 36
%uc_License = 37

' License options
%uc_License_Demo = 0
%uc_License_FMP_Free = 1
%uc_License_FMP_Standard_32 = 2
%uc_License_FMP_Standard_64 = 3
%uc_License_FMP_32_and_64 = 4
%uc_License_LanguageBuilder = 5
%uc_License_GeneralParser = 6
%uc_License_Interpreter = 7
%uc_License_ConsoleCalc = 8
%uc_License_WindowsCalc = 9
%uc_License_StringLib = 10
%uc_License_Transform = 11
%uc_License_TransformLib = 12
%uc_License_Search = 13
%uc_License_SearchLib = 14
%uc_License_Library1 = 15
%uc_License_Library2 = 16
%uc_License_Beta = 17
%uc_License_Debugger = 18
%uc_License_uCalc_All = 50
%uc_License_Developer = 100
%uc_License_EndUser = 101

%uc_AddDebugger = 39
%Debug_ReleaseItem    = 1
%Debug_StdFuncCall    = 2
%Debug_UserFuncCall   = 3
%Debug_GetTextToken   = 4
%Debug_ErrorHandler   = 5
%Debug_ParseExpr      = 6
%Debug_ParseItem      = 7
%Debug_EvalOperation  = 8
%Debug_DefSyntax      = 9
%Debug_Define         = 10
%Debug_DefinePart     = 11
%Debug_Expand         = 12
%Debug_ExpandSuccess  = 13
%Debug_ExpandMiss     = 14
%Debug_ExpandFail     = 15
%Debug_GetSyntaxBlock = 16
%Debug_GetCodeBlock   = 17
%Debug_LineNumber     = 18
%Debug_TotalTally     = 19
%Debug_Breakpoint     = 20
%Debug_Delay          = 21
%Debug_JumpTo         = 22
%Debug_StepAction     = 23

%uc_AddErrorHandler = 40
%uc_GetSymbolTable = 41
%uc_GetSteps = 42
%uc_GetStepsCount = 43

%uc_SetTypeOutput = 45
%uc_Group = 46
%uc_GetTag = 47
%uc_SetTag = 48

%uc_GetCallbackData = 50
%uc_SetCallbackReturn = 51

%uc_GetErrorExpression = 60
%uc_SetExpression = 61
%uc_GetSymbol = 62
%uc_SetSymbol = 63
%uc_GetLocation = 64

%uc_GetTokenType = 65
%uc_GetTokenProperties = 66

%uc_TrigMode = 67

%uc_ItemClone = 70
%uc_DataConvert = 71
%uc_DataCopy = 72
%uc_DataAlloc = 72
%uc_DataFree = 73
%uc_DataReset = 74

' FPU commands
%uc_SetFPU = 75
%uc_SetFPU_HostProg = 76
%uc_GetFPU = 77
%uc_GetFPU_HostProg = 78
%uc_ToggleFPU = 79
%uc_ToggleFPU_HostProg = 80

%uc_ErrorClear = 85
%uc_RestoreErrorMessageBox = 86

%uc_SetErrorMessage = 91
%uc_GetErrorMessage = 92

%uc_SerialNumber = 93
%uc_SetTurbo = 94
%uc_Expand = 95
%uc_GetNextToken = 96
%uc_GetItemData = 97
%uc_SetItemData = 98
%uc_GetThreadAddr = 99
%uc_GetCodeBlock = 100

%uc_Status_CurrentPass = 101
%uc_Status_MaxPass = 102
%uc_Status_Location = 103
%uc_Status_NestedLevel = 104
%uc_Status_TextLength = 105

%uc_Find = 110
%uc_FindAddMatch = 111
%uc_FindGetIndex = 112
%uc_FindGetCount = 113
%uc_FindGetStart = 114
%uc_FindGetLength = 115
%uc_FindGetText = 116
%uc_FindReset = 117
%uc_FindReplace = 118
%uc_FindFilter = 119
%uc_FindSetFilter = 120

%uc_FindFilterSort = 1
%uc_FindFilterUnique = 2
%uc_FindFilterTally = 4
%uc_FindFilterSeparator = 8
%uc_FindFilterStartText = 16
%uc_FindFilterEndText = 32

%uc_FindContext_Other = 0
%uc_FindContext_Found = 1
%uc_FindContext_Replaced = 2

%uc_FindZoomIn = 1
%uc_FindTransformInPlace = 2

%uc_Properties = 1
%uc_Thread = 2
%uc_Address = 3
%uc_SymbolName = 4
%uc_Rank = 5
%uc_Precedence = 6
%uc_OverloadHandle = 7
%uc_OverloadCount = 8
%uc_ByteSize = 9
%uc_ArgCount = 10
%uc_DataType = 12
%uc_Handle = 13
%uc_Value = 14
%uc_Property = 15

' Error numbers
%uc_Err_None                    = 0
%uc_Err_Dynamically_Defined     = 1
%uc_Err_Syntax_Error            = 2
%uc_Err_Undefined_Identifier    = 3
%uc_Err_FileNotFound            = 4
%uc_Err_Unrecognized_Token      = 5
%uc_Err_Unrecognized_Command    = 6
%uc_Err_Datatype_Mismatch       = 7
%uc_Err_Invalid_Argument_Count  = 8
%uc_Err_Invalid_Definition      = 9
%uc_Err_CodeBlock_Error         = 10
%uc_Err_Undefined_Callback      = 11
%uc_Err_ErrMsgAlreadyDefined    = 12
%uc_Err_ItemCannotBeModified    = 13
%uc_Err_Unrecognized_Member     = 14
%uc_Err_Unbalanced_Quote        = 15

%uc_Err_Array_Bounds_Exceeded   = 20
%uc_Err_Float_Denormal_Operand  = 21
%uc_Err_Float_Divide_By_Zero    = 22
%uc_Err_Float_Inexact_Result    = 23
%uc_Err_Float_Invalid_Operation = 24
%uc_Err_Float_Overflow          = 25
%uc_Err_Float_Stack_Check       = 26
%uc_Err_Float_Underflow         = 27
%uc_Err_Integer_Divide_By_Zero  = 28
%uc_Err_Integer_Overflow        = 29
%uc_Err_Privileged_Instruction  = 30

' Error response
%ucAbort = 0
%ucResume = 1
%ucReRaise = 2

' FPU Control Word Settings
%uc_FPU_Mask_InvalidOp     = 1
%uc_FPU_Mask_DenormalOp    = 2
%uc_FPU_Mask_ZeroDivide    = 4
%uc_FPU_Mask_Overflow      = 8
%uc_FPU_Mask_Underflow     = 16
%uc_FPU_Mask_PrecisionLoss = 32

%uc_FPU_Precision_Single   = 0
%uc_FPU_Precision_Double   = 256
%uc_FPU_Precision_Extended = 768

%uc_FPU_Round_Even         = 0
%uc_FPU_Round_Down         = 1024
%uc_FPU_Round_Up           = 2048
%uc_FPU_Round_Toward       = 3072

' Data type handler callback action modes
%uc_TypeHandler_Store = 2
%uc_TypeHandler_StringOutput = 3
%uc_TypeHandler_Free = 4
%uc_TypeHandler_FuncRet = 5
%uc_TypeHandler_Copy = 6
%uc_TypeHandler_Alloc = 7
%uc_TypeHandler_Reset = 8

%uc_Callback_Undefined = 0 ' Returns error

' Data Type callbacks
%uc_Complex     = 1
%uc_Currency    = 2
%uc_Double      = 3
%uc_Extended    = 4
%uc_Int8        = 5
%uc_Int8u       = 6
%uc_Int16       = 7
%uc_Int16u      = 8
%uc_Int32       = 9
%uc_Int32u      = 10
%uc_Int64       = 11
%uc_Int64u      = 12
%uc_Single      = 13
%uc_String      = 14
%uc_String_LPCSTR= 15
%uc_String_Fixed= 16
%uc_String_Wide = 17
%uc_Stack       = 18
%uc_Table       = 19
%uc_SortedList  = 20
%uc_Void        = 21
%uc_User_Type   = 22

%uc_Convert_Generic = 23
%uc_Convert_Same = 24
%uc_Convert_Double_Extended = 25
%uc_Convert_Int8_Extended = 26
%uc_Convert_Int8u_Extended = 27
%uc_Convert_Int16_Extended = 28
%uc_Convert_Int16u_Extended = 29
%uc_Convert_Int32_Extended = 30
%uc_Convert_Int32u_Extended = 31
%uc_Convert_Int64_Extended = 32
%uc_Convert_Int64u_Extended = 33
%uc_Convert_Single_Extended = 34
%uc_Convert_Void_Extended = 35
%uc_Convert_Extended_Double = 37
%uc_Convert_Extended_Single = 38
%uc_Convert_Extended_Int16u = 39
%uc_Convert_Extended_Int32 = 40
%uc_Convert_Complex_Extended = 41
%uc_Convert_Extended_Complex = 42

' Default built-in routines
%uc_Op_Negate = 43
%uc_Op_UnaryPlus = 44
%uc_Op_Percentage = 45
%uc_Op_StrConcat = 46
%uc_Op_Add_Int32 = 47
%uc_Op_Add = 48
%uc_Op_Add_Complex = 49
%uc_Op_Subtract_Int32 = 50
%uc_Op_Subtract = 51
%uc_Op_Multiply_Int32 = 52
%uc_Op_Multiply = 53
%uc_Op_Multiply_Complex = 54
%uc_Op_Divide_Int32 = 55
%uc_Op_Divide = 56
%uc_Op_Mod_Int32 = 57
%uc_Op_Mod = 58
%uc_Op_PowerOf_ExtToExt = 59
%uc_Op_PowerOf_ExtToLng = 60
%uc_Op_PowerOf_CplxToCplx = 61

%uc_Op_GreaterThan = 62
%uc_Op_GreaterOrEqual = 63
%uc_Op_LessThan = 64
%uc_Op_LessOrEqual = 65
%uc_Op_Equal = 66
%uc_Op_NotEqual = 67

%uc_Op_GreaterThan_Str = 68
%uc_Op_GreaterOrEqual_Str = 69
%uc_Op_LessThan_Str = 70
%uc_Op_LessOrEqual_Str = 71
%uc_Op_Equal_Str = 72
%uc_Op_NotEqual_Str = 73

%uc_Op_Not_Int32 = 74
%uc_Op_And_Int32 = 75
%uc_Op_Or_Int32 = 76
%uc_Op_Xor_Int32 = 77
%uc_Op_Eqv_Int32 = 78
%uc_Op_Imp_Int32 = 79

%uc_Op_AndAlso = 80
%uc_Op_OrElse = 81

%uc_Op_Factorial = 82

%uc_Func_IIf = 83
%uc_Func_IIf_Str = 84

%uc_Func_Sin = 85
%uc_Func_Cos = 86
%uc_Func_Tan = 87
%uc_Func_Atan = 88
%uc_Func_Ceil = 89
%uc_Func_Abs = 90
%uc_Func_Abs_Int32 = 91
%uc_Func_Exp = 92
%uc_Func_Log = 93
%uc_Func_Floor = 94
%uc_Func_SquareRoot = 95
%uc_Func_BaseConvert = 96

%uc_Func_ExprHandle = 97
%uc_Func_VarPtr = 98
%uc_Func_uCalc = 99
%uc_Func_uCalcStr = 100
%uc_Func_ucAddr = 101
%uc_Func_ValueAtAddr = 102
%uc_Func_SpecialArg = 103
%uc_Op_StringMult = 104

%uc_Func_For  = 105
%uc_Func_Loop = 107

%uc_Func_LoadLibrary = 108
%uc_Func_GetProcAddress = 109

%uc_NullString = 110
%uc_True = 111

%uc_Func_Peek = 112
%uc_Func_Poke = 113

%uc_Func_Int = 115
%uc_Func_Frac = 116
%uc_Func_Sgn = 117

%uc_Func_PushData_Stack = 120
' %uc_Func_PopHandle_Stack = 121
%uc_Func_PopNum_Stack = 122
%uc_Func_PopStr_Stack = 123
%uc_Func_ReadHandle_Stack = 124
%uc_Func_ReadNum_Stack = 125
%uc_Func_ReadStr_Stack = 126
%uc_Func_Count_Stack = 127
%uc_Op_Concat_Stack = 128
%uc_Func_Populate_Stack = 129

%uc_Insert_Table = 130
%uc_Delete_Table = 131
%uc_Index_Table  = 132
%uc_Handle_Table = 133
%uc_HandleB_Table = 134
%uc_ReadData_Table = 135
%uc_ReadNum_Table = 136

%uc_Func_Min = 137
%uc_Func_Max = 138
%uc_Func_Min_Str = 139
%uc_Func_Max_Str = 140

%uc_SetVariableValue = 141
%uc_SetVariableValueAnyType = 141
%uc_SetVariableValueLong = 142
%uc_SetVariableValueDouble = 143
%uc_SetVariableValueExtended = 144
%uc_ResetVariable = 145

' Misc other callbacks
%uc_EvaluateAddr = 150
%uc_EvaluateTurboAddr = 151
%uc_ExceptionHelper = 152
%uc_DefaultErrorHandler = 153
%uc_Raise_Error = 154
%uc_Func_IsIncomplete = 155

%uc_ScriptTimerStart = 160
%uc_LoadTimeTix = 161

%uc_Op_Ext_Plus_Complex = 190
%uc_Op_Ext_Times_Complex = 191

%uc_Func_If_ElseIf = 195
%uc_Func_SetSyntaxParams = 196
%uc_Func_SpecialUCase = 197
%uc_Func_Rand = 198
%uc_Func_GetmatchArg = 199
%uc_Func_PatternNum = 200
%uc_Func_PatternStr = 201

%uc_Convert_Stack_Table = 220
%uc_Convert_Stack_SortedList = 221
%uc_Convert_Table_Stack = 222
%uc_Convert_SortedList_Stack = 223

%uc_Expand_List = 1
%uc_Expand_StackPtr = 2

%uc_HandleToken = 21 ' &h15

' Trig Mode
%uc_ReturnTrigMode = 0
%uc_Radians = 1
%uc_Degrees = 2
%uc_Grad    = 3

' Misc
%ucTrue  = 1
%ucFalse = 0
%uc_Rank_First = 1
%uc_Rank_Last  = -1

' Pattern options
%uc_Pattern_ArgCount = 1
%uc_Pattern_ArgIndex = 2
%uc_Pattern_ArgLength = 3
%uc_Pattern_ArgLocation = 4
%uc_Pattern_ArgText = 5
%uc_Pattern_DocumentLength = 6
%uc_Pattern_DocumentText = 7
%uc_Pattern_CriteriaCount = 8
%uc_Pattern_CriteriaIndex = 9
%uc_Pattern_MatchLength = 10
%uc_Pattern_MatchLocation = 11
%uc_Pattern_MatchText = 12
%uc_Pattern_MatchTally = 13
%uc_Pattern_SkipTally = 14

' String Library
%uc_StringLibNum = 230
%uc_StringLibStr = 231
%ucs_SetStringDefaults = 4
%ucs_Start = 5
%ucs_Limit = 6
%ucs_StartAfter = 7
%ucs_StopAfter = 8
%ucs_Between = 9
%ucs_Nth = 10
%ucs_File = 11
%ucs_Pos = 12
%ucs_Length = 13
%ucs_Text = 14
%ucs_Count = 15
%ucs_CountSkipped = 16
%ucs_InStr = 17
%ucs_Tally = 18
%ucs_UCase = 19
%ucs_LCase = 20
%ucs_MCase = 21
%ucs_Replace = 22
%ucs_Remove = 23
%ucs_Mid = 24
%ucs_Left = 25
%ucs_Right = 26
%ucs_Len = 27
%ucs_Extract = 28
%ucs_Remain = 29
%ucs_Skip = 30
%ucs_Delim = 31
%ucs_Retain = 32
%ucs_Range = 33
%ucs_Compare = 34
%ucs_Equals = 35
%ucs_Split = 36
%ucs_StringItem = 37
%ucs_StringItemCount = 38

' String Libarary Options
%ucByte = 1
%ucChar = 2
%ucWord = 4
%ucToken = 8
%ucBlock = 16
%ucExpr = 32
%ucQuote = 64
%ucSpace = 128
%ucCase = 256
' End Of String Library Options

' Main Functions
Declare Function ucAddr Lib "uCalc32v400.dll" Alias "ucAddr" (ByVal AddressIndex As Long) As Long
Declare Function uCalc Lib "uCalc32v400.dll" Alias "uCalc" (ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) As Long

' Insert Other Exports
Declare Function ExceptionHelper Lib "uCalc32v400.dll" Alias "ExceptionHelper" (ByVal Expr As Long, ByVal SystemError As Long) As Long
Declare Function ucEvaluate Lib "uCalc32v400.dll" Alias "ucEvaluate" (ByVal Item As Long) As Extended
Declare Function ucArgLng Lib "uCalc32v400.dll" Alias "ucArgLng" (ByVal Expr As Long, ByVal index As Long) As Long
Declare Function ucArg Lib "uCalc32v400.dll" Alias "ucArg" (ByVal Expr As Long, ByVal index As Long) As Extended
Declare Sub ucArgStr_ Lib "uCalc32v400.dll" Alias "ucArgStr" (ByRef ReturnStr As String, ByVal Expr As Long, ByVal index As Long)
Function ucArgStr(ByVal Expr As Long, ByVal index As Long) As String
   Dim ReturnStr As String
   ucArgStr_(ReturnStr,  Expr ,  index )
   ucArgStr = ReturnStr
End Function
Declare Function ucArgHandle Lib "uCalc32v400.dll" Alias "ucArgHandle" (ByVal Expr As Long, ByVal index As Long) As Long
Declare Function ucArgCount Lib "uCalc32v400.dll" Alias "ucArgCount" (ByVal Expr As Long) As Long
Declare Sub ucReturnLng Lib "uCalc32v400.dll" Alias "ucReturnLng" (ByVal Expr As Long, ByVal ReturnValue As Long)
Declare Sub ucReturn Lib "uCalc32v400.dll" Alias "ucReturnExt" (ByVal Expr As Long, ByVal ReturnValue As Extended)
Declare Sub ucReturnStr Lib "uCalc32v400.dll" Alias "ucReturnStr" (ByVal Expr As Long, ByRef ReturnValue As String)
Declare Function ucGetVariableValue Lib "uCalc32v400.dll" Alias "ucGetVariableValue" (ByVal Item As Long) As Extended
Declare Function ucGetVariableValueLng Lib "uCalc32v400.dll" Alias "ucGetVariableValueLng" (ByVal Item As Long) As Long
Declare Sub ucGetVariableValueStr_ Lib "uCalc32v400.dll" Alias "ucGetVariableValueStr" (ByRef ReturnStr As String, ByVal Item As Long)
Function ucGetVariableValueStr(ByVal Item As Long) As String
   Dim ReturnStr As String
   ucGetVariableValueStr_(ReturnStr,  Item )
   ucGetVariableValueStr = ReturnStr
End Function
Declare Sub ucSetVariableValueLng Lib "uCalc32v400.dll" Alias "ucSetVariableValueLng" (ByVal Item As Long, ByVal NewValue As Long)
Declare Sub ucSetVariableValue Lib "uCalc32v400.dll" Alias "ucSetVariableValueExt" (ByVal Item As Long, ByVal NewValue As Extended)
Declare Sub ucSetVariableValueStr Lib "uCalc32v400.dll" Alias "ucSetVariableValueStr" (ByVal Item As Long, ByRef NewValue As String)
Declare Function ucExprThread Lib "uCalc32v400.dll" Alias "ucExprThread" (ByVal Expr As Long) As Long
Declare Function ucLicense Lib "uCalc32v400.dll" Alias "ucLicense" (ByVal Product As Long, Optional ByVal L1 As Dword, Optional ByVal L2 As Dword, Optional ByVal L3 As Dword, Optional ByVal L4 As Dword, Optional ByVal L5 As Dword) As Long
' End Insert
Declare Sub uCalcStr_ Lib "uCalc32v400.dll" Alias "uCalcStr" (ByRef ReturnStr As String, ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long)
Function uCalcStr(ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   uCalcStr_(ReturnStr,  ucCommand , IIf$(VarPtr(TextIn), TextIn, ""),   a ,   b ,   c ,   t )
   uCalcStr = ReturnStr
End Function
Declare Function ucClose32bitDLL Lib "uCalc32v400.dll" Alias "ucClose32bitDLL" (ByVal ReserverdArg As Long) As Long
Declare Function ucDefine Lib "uCalc32v400.dll" Alias "ucDefine" (ByRef Definition As String, Optional ByVal Arg1 As Long, Optional ByVal Arg2 As Long, Optional ByVal Arg3 As Long, Optional ByVal t As Long) As Long
Declare Function ucDefineConstant Lib "uCalc32v400.dll" Alias "ucDefineConstant" (ByRef Definition As String, Optional ByVal t As Long) As Long
Declare Function ucDefineFunction Lib "uCalc32v400.dll" Alias "ucDefineFunction" (ByRef Definition As String, Optional ByVal FunctionAddress As Long, Optional ByVal t As Long) As Long
Declare Function ucDefineOperator Lib "uCalc32v400.dll" Alias "ucDefineOperator" (ByRef Definition As String, Optional ByVal FunctionAddress As Long, Optional ByVal t As Long) As Long
Declare Function ucDefineSyntax Lib "uCalc32v400.dll" Alias "ucDefineSyntax" (ByRef Definition As String, Optional ByVal Rank As Long, Optional ByVal t As Long) As Long
Declare Function ucDefineVariable Lib "uCalc32v400.dll" Alias "ucDefineVariable" (ByRef Definition As String, Optional ByVal VarAddress As Long, Optional ByVal t As Long) As Long
Declare Function ucEval Lib "uCalc32v400.dll" Alias "ucEval" (ByRef Expr As String, Optional ByVal t As Long) As Extended
Declare Sub ucEvalStr_ Lib "uCalc32v400.dll" Alias "ucEvalStr" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long)
Function ucEvalStr(ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   ucEvalStr_(ReturnStr,  Expr ,   ExprType ,   t )
   ucEvalStr = ReturnStr
End Function
Declare Sub ucEvaluateStr_ Lib "uCalc32v400.dll" Alias "ucEvaluateStr" (ByRef ReturnStr As String, ByVal ucItem As Long)
Function ucEvaluateStr(ByVal ucItem As Long) As String
   Dim ReturnStr As String
   ucEvaluateStr_(ReturnStr,  ucItem )
   ucEvaluateStr = ReturnStr
End Function
Declare Sub ucExpand_ Lib "uCalc32v400.dll" Alias "ucExpand" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal t As Long)
Function ucExpand(ByRef Expr As String, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   ucExpand_(ReturnStr,  Expr ,   t )
   ucExpand = ReturnStr
End Function
Declare Function ucFPU Lib "uCalc32v400.dll" Alias "ucFPU" (ByVal FPU_Command As Long, Optional ByVal FPU_Option As Long) As Long
Declare Function ucGetTrigMode Lib "uCalc32v400.dll" Alias "ucGetTrigMode" () As Long
Declare Function ucInitialize Lib "uCalc32v400.dll" Alias "ucInitialize" (Optional ByVal NewThread As Long) As Long
Declare Function ucNewThread Lib "uCalc32v400.dll" Alias "ucNewThread" (Optional ByVal ParentThread As Long, Optional ByVal MakeThisDefault As Long) As Long
Declare Function ucParse Lib "uCalc32v400.dll" Alias "ucParse" (ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long) As Long
Declare Function ucReleaseItem Lib "uCalc32v400.dll" Alias "ucReleaseItem" (ByVal ucItem As Long) As Long
Declare Sub ucRun_ Lib "uCalc32v400.dll" Alias "ucRun" (ByRef ReturnStr As String, ByRef RunOption As String, ByRef TextIn As String, Optional ByVal ExpandCount As Long, Optional ByVal t As Long)
Function ucRun(ByRef RunOption As String, ByRef TextIn As String, Optional ByVal ExpandCount As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   ucRun_(ReturnStr,  RunOption ,  TextIn ,   ExpandCount ,   t )
   ucRun = ReturnStr
End Function
Declare Function ucSetOutput Lib "uCalc32v400.dll" Alias "ucSetOutput" (Optional ByVal FunctionAddress As Long, Optional ByRef FuncName As String, Optional ByRef DataType As String, Optional ByVal t As Long) As Long
Declare Function ucSetTrigMode Lib "uCalc32v400.dll" Alias "ucSetTrigMode" (ByVal TrigMode As Long) As Long

' Error handling
Declare Function ucAddErrorHandler Lib "uCalc32v400.dll" Alias "ucAddErrorHandler" (Optional ByVal ErrorHandlerAddress As Long, Optional ByVal t As Long) As Long
Declare Function ucError Lib "uCalc32v400.dll" Alias "ucError" (Optional ByVal t As Long) As Long
Declare Sub ucErrorMessage_ Lib "uCalc32v400.dll" Alias "ucErrorMessage" (ByRef ReturnStr As String, Optional ByVal ErrorNumber As Long, Optional ByVal t As Long)
Function ucErrorMessage(Optional ByVal ErrorNumber As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   ucErrorMessage_(ReturnStr,   ErrorNumber ,   t )
   ucErrorMessage = ReturnStr
End Function
Declare Sub ucErrorExpression_ Lib "uCalc32v400.dll" Alias "ucErrorExpression" (ByRef ReturnStr As String, Optional ByVal t As Long)
Function ucErrorExpression(Optional ByVal t As Long) As String
   Dim ReturnStr As String
   ucErrorExpression_(ReturnStr,   t )
   ucErrorExpression = ReturnStr
End Function
Declare Function ucErrorLocation Lib "uCalc32v400.dll" Alias "ucErrorLocation" (ByVal t As Long) As Long
Declare Sub ucErrorSymbol_ Lib "uCalc32v400.dll" Alias "ucErrorSymbol" (ByRef ReturnStr As String, ByVal t As Long)
Function ucErrorSymbol(ByVal t As Long) As String
   Dim ReturnStr As String
   ucErrorSymbol_(ReturnStr,  t )
   ucErrorSymbol = ReturnStr
End Function
Declare Function ucRaiseError Lib "uCalc32v400.dll" Alias "ucRaiseError" (ByVal Expr As Long, ByVal ErrorNumber As Long) As Long
Declare Function ucRaiseErrorMessage Lib "uCalc32v400.dll" Alias "ucRaiseErrorMessage" (ByVal Expr As Long, ByRef ErrorMessage As String) As Long
Declare Function ucSetError Lib "uCalc32v400.dll" Alias "ucSetError" (ByVal ErrorNumber As Long, Optional ByVal t As Long) As Long
Declare Function ucSetErrorMessage Lib "uCalc32v400.dll" Alias "ucSetErrorMessage" (ByVal ErrorIndex As Long, ByRef ErrorMessage As String, Optional ByVal t As Long) As Long
Declare Function ucSetErrorNumber Lib "uCalc32v400.dll" Alias "ucSetErrorNumber" (ByVal ErrorNumber As Long, Optional ByVal t As Long) As Long

' uCalc String Library
Declare Function ucLoadStringLibInFMP Lib "uCalc32v400.dll" Alias "ucLoadStringLibInFMP" (Optional ByVal tHandle As Long) As Long

' uCalc String Library Routine Exports
Declare Function ucBetween Lib "uCalc32v400.dll" Alias "ucBetween" (ByVal a As Long, ByVal b As Long) As Long
Declare Function ucCompare Lib "uCalc32v400.dll" Alias "ucCompare" (ByRef String1 As String, ByRef String2 As String, Optional ByVal Options As Long) As Long
Declare Function ucCount Lib "uCalc32v400.dll" Alias "ucCount" () As Long
Declare Function ucCountSkipped Lib "uCalc32v400.dll" Alias "ucCountSkipped" () As Long
Declare Function ucDelim Lib "uCalc32v400.dll" Alias "ucDelim" (ByRef Delim As String, Optional ByRef L As String, Optional ByRef R As String) As Long
Declare Function ucEquals Lib "uCalc32v400.dll" Alias "ucEquals" (ByRef String1 As String, ByRef String2 As String, Optional ByVal Options As Long) As Long
Declare Function ucInStr Lib "uCalc32v400.dll" Alias "ucInStr" (ByVal Start As Long, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As Long
Declare Function ucLen Lib "uCalc32v400.dll" Alias "ucLen" (ByRef MainString As String, Optional ByVal Options As Long) As Long
Declare Function ucLength Lib "uCalc32v400.dll" Alias "ucLength" (Optional ByVal x As Long) As Long
Declare Function ucLimit Lib "uCalc32v400.dll" Alias "ucLimit" (ByVal Limit As Long) As Long
Declare Function ucNth Lib "uCalc32v400.dll" Alias "ucNth" (ByVal Number As Long) As Long
Declare Function ucPos Lib "uCalc32v400.dll" Alias "ucPos" (Optional ByVal x As Long) As Long
Declare Function ucSetStringDefaults Lib "uCalc32v400.dll" Alias "ucSetStringDefaults" (ByVal Options As Long) As Long
Declare Function ucSkip Lib "uCalc32v400.dll" Alias "ucSkip" (ByRef MainString As String) As Long
Declare Function ucSplit Lib "uCalc32v400.dll" Alias "ucSplit" (ByRef MainString As String, Optional ByRef Delim As String, Optional ByVal Options As Long) As Long
Declare Function ucStart Lib "uCalc32v400.dll" Alias "ucStart" (ByVal Position As Long) As Long
Declare Function ucStartAfter Lib "uCalc32v400.dll" Alias "ucStartAfter" (ByVal Number As Long) As Long
Declare Function ucStopAfter Lib "uCalc32v400.dll" Alias "ucStopAfter" (ByVal Number As Long) As Long
Declare Function ucStringItemCount Lib "uCalc32v400.dll" Alias "ucStringItemCount" () As Long
Declare Function ucTally Lib "uCalc32v400.dll" Alias "ucTally" (ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As Long
Declare Sub ucExtract_ Lib "uCalc32v400.dll" Alias "ucExtract" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Function ucExtract(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucExtract_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucExtract = ReturnStr
End Function
Declare Sub ucFile_ Lib "uCalc32v400.dll" Alias "ucFile" (ByRef ReturnStr As String, ByRef NameOfFile As String)
Function ucFile(ByRef NameOfFile As String) As String
   Dim ReturnStr As String
   ucFile_(ReturnStr,  NameOfFile )
   ucFile = ReturnStr
End Function
Declare Sub ucLCase_ Lib "uCalc32v400.dll" Alias "ucLCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Function ucLCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucLCase_(ReturnStr,  MainString , IIf$(VarPtr(Pattern), Pattern, ""),   Options )
   ucLCase = ReturnStr
End Function
Declare Sub ucLeft_ Lib "uCalc32v400.dll" Alias "ucLeft" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long)
Function ucLeft(ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucLeft_(ReturnStr,  MainString ,  Number ,   Options )
   ucLeft = ReturnStr
End Function
Declare Sub ucMCase_ Lib "uCalc32v400.dll" Alias "ucMCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Function ucMCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucMCase_(ReturnStr,  MainString , IIf$(VarPtr(Pattern), Pattern, ""),   Options )
   ucMCase = ReturnStr
End Function
Declare Sub ucMid_ Lib "uCalc32v400.dll" Alias "ucMid" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Start As Long, Optional ByVal Length As Long, Optional ByVal Options As Long)
Function ucMid(ByRef MainString As String, ByVal Start As Long, Optional ByVal Length As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucMid_(ReturnStr,  MainString ,  Start ,   Length ,   Options )
   ucMid = ReturnStr
End Function
Declare Sub ucRange_ Lib "uCalc32v400.dll" Alias "ucRange" (ByRef ReturnStr As String, ByVal Start As Long, ByVal Finish As Long, ByRef Expression As String, Optional ByVal Options As Long)
Function ucRange(ByVal Start As Long, ByVal Finish As Long, ByRef Expression As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucRange_(ReturnStr,  Start ,  Finish ,  Expression ,   Options )
   ucRange = ReturnStr
End Function
Declare Sub ucRemain_ Lib "uCalc32v400.dll" Alias "ucRemain" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Function ucRemain(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucRemain_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucRemain = ReturnStr
End Function
Declare Sub ucRemove_ Lib "uCalc32v400.dll" Alias "ucRemove" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Function ucRemove(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucRemove_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucRemove = ReturnStr
End Function
Declare Sub ucReplace_ Lib "uCalc32v400.dll" Alias "ucReplace" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByRef Replacement As String, Optional ByVal Options As Long)
Function ucReplace(ByRef MainString As String, ByRef Pattern As String, Optional ByRef Replacement As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucReplace_(ReturnStr,  MainString ,  Pattern , IIf$(VarPtr(Replacement), Replacement, ""),   Options )
   ucReplace = ReturnStr
End Function
Declare Sub ucRetain_ Lib "uCalc32v400.dll" Alias "ucRetain" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByRef Filter As String, Optional ByVal Options As Long)
Function ucRetain(ByRef MainString As String, ByRef Pattern As String, Optional ByRef Filter As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucRetain_(ReturnStr,  MainString ,  Pattern , IIf$(VarPtr(Filter), Filter, ""),   Options )
   ucRetain = ReturnStr
End Function
Declare Sub ucRight_ Lib "uCalc32v400.dll" Alias "ucRight" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long)
Function ucRight(ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucRight_(ReturnStr,  MainString ,  Number ,   Options )
   ucRight = ReturnStr
End Function
Declare Sub ucStringItem_ Lib "uCalc32v400.dll" Alias "ucStringItem" (ByRef ReturnStr As String, ByVal Index As Long)
Function ucStringItem(ByVal Index As Long) As String
   Dim ReturnStr As String
   ucStringItem_(ReturnStr,  Index )
   ucStringItem = ReturnStr
End Function
Declare Sub ucUCase_ Lib "uCalc32v400.dll" Alias "ucUCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Function ucUCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   ucUCase_(ReturnStr,  MainString , IIf$(VarPtr(Pattern), Pattern, ""),   Options )
   ucUCase = ReturnStr
End Function
Declare Function uCalcRaw Lib "uCalc32v400.dll" Alias "uCalcRaw" (ByRef ReturnStr_ As String, ByVal uc As Long, ByRef TextIn As String, ByVal Misc1 As Long, ByVal Misc2 As Long, ByVal ReturnPtr As Long, ByVal tHandle As Long) As Long

' Deprecated notations
' Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
Declare Function ucParam Lib "uCalc32v400.dll" Alias "ucArg" (ByVal ExprHandle As Long, ByVal Index As Long) As Extended
Declare Function ucParamStr Lib "uCalc32v400.dll" Alias "ucArgStr" (ByVal ExprHandle As Long, ByVal Index As Long) As String
Declare Function ucParamCount Lib "uCalc32v400.dll" Alias "ucArgCount" (ByVal ExprHandle As Long) As Long
Declare Function ucParamHandle Lib "uCalc32v400.dll" Alias "ucArgHandle" (ByVal ExprHandle As Long, ByVal Index As Long) As Long
Declare Function ucErrLocation Lib "uCalc32v400.dll" Alias "ucErrorLocation" (ByVal t As Long) As Long
Declare Function ucErrSymbol Lib "uCalc32v400.dll" Alias "ucErrorSymbol" (ByVal t As Long) As String
Declare Function ucSetErrMsg Lib "uCalc32v400.dll" Alias "ucSetErrorMessage" (ByVal Index As Long, ByRef Msg As String) As Long

