// ---------------------------------------------------------------------------
// uCalcVC_NET.h: VC++ NET include file for uCalc Fast Math Parser 4.00
// Designed for : Visual C++.NET 2010 and 2012 with CLR
//
// This file auto-generated by : VisualCppNET.uc using uCalc Transform 3.0
// Auto-generation timestamp: 08/14/14
// VisualCppNET.uc prepared by : Daniel Corbier
// Visit www.ucalc.com for additional resources.
// ---------------------------------------------------------------------------

#pragma once
using namespace System;
using namespace System::Runtime::InteropServices;

#define uCalcDLL "uCalc32v400.dll"

// Definition properties
const int ucAlphaNumeric = 1;
const int ucArgSeparator = 2;
const int ucCodeBlock = 3;
const int ucCodeBlockMatch = 4;
const int ucMemberAccess = 5;
const int ucQuotedText = 6;
const int ucStatementSep = 7;
const int ucWhiteSpace = 8;

const int ucCurrentThread = 9;

const int ucLocalVar = 10;
const int ucStaticVar = 11;
const int ucDefineNow = 11; // same as ucStaticVar
const int ucTempDef = 12;
const int ucEvalInsert = 13;
const int ucEvalDuringParse = 14;
const int ucExpandInsert = 15;
const int ucFileInclude = 16;

const int ucCurrentSpace = 17;
const int ucDefSpace = 18;
const int ucEvalSpace = 19;

const int ucFunction = 64;
const int ucOperator = 128;
const int ucVariable = 256;
const int ucSyntax = 512;
const int ucLiteral = 1024;
const int ucSymbol = 2048;
const int ucReducible = 4096;
const int ucLock = 8192;
const int ucInfix = 16384;
const int ucPrefix = 32768;
const int ucPostfix = 49152;

// uCalc Commands
const int uc_Define = 1;
const int uc_DefineSyntax = 2;
const int uc_Eval = 3;
const int uc_EvalStr = 4;
const int uc_Evaluate = 5;
const int uc_EvaluateLng = 6;
const int uc_EvaluateStr = 7;
const int uc_GetCaseSensitivity = 8;
const int uc_GetDefaultPass = 9;
const int uc_GetDefaultPrecedence = 10;
const int uc_GetDefaultRank = 11;
const int uc_GetCodeAddr = 12;
const int uc_GetDefaultThread = 13;
const int uc_GetDefaultType = 14;
const int uc_GetDefSeparator = 15;
const int uc_GetDefSpace = 16;
const int uc_GetErrorNumber = 17;
const int uc_GetEvalSpace = 18;
const int uc_GetParentThread = 20;
const int uc_GetSyntaxEqual = 21;
const int uc_Parse = 22;
const int uc_ReleaseItem = 23;
const int uc_SetCaseSensitivity = 24;
const int uc_SetCodeAddr = 25;
const int uc_SetDefaultPrecedence = 26;
const int uc_SetDefaultRank = 27;
const int uc_SetDefaultThread = 28;
const int uc_SetDefaultType = 29;
const int uc_SetDefSeparator = 30;
const int uc_SetErrorNumber = 31;
const int uc_SetParentThread = 32;
const int uc_SetSyntaxEqual = 33;
const int uc_NewThread = 34;

const int uc_RegExWordBoundaryChars = 35;
const int uc_RegExEscapeChar = 36;
const int uc_License = 37;

// License options
const int uc_License_Demo = 0;
const int uc_License_FMP_Free = 1;
const int uc_License_FMP_Standard_32 = 2;
const int uc_License_FMP_Standard_64 = 3;
const int uc_License_FMP_32_and_64 = 4;
const int uc_License_LanguageBuilder = 5;
const int uc_License_GeneralParser = 6;
const int uc_License_Interpreter = 7;
const int uc_License_ConsoleCalc = 8;
const int uc_License_WindowsCalc = 9;
const int uc_License_StringLib = 10;
const int uc_License_Transform = 11;
const int uc_License_TransformLib = 12;
const int uc_License_Search = 13;
const int uc_License_SearchLib = 14;
const int uc_License_Library1 = 15;
const int uc_License_Library2 = 16;
const int uc_License_Beta = 17;
const int uc_License_Debugger = 18;
const int uc_License_uCalc_All = 50;
const int uc_License_Developer = 100;
const int uc_License_EndUser = 101;

const int uc_AddDebugger = 39;
const int Debug_ReleaseItem = 1;
const int Debug_StdFuncCall = 2;
const int Debug_UserFuncCall = 3;
const int Debug_GetTextToken = 4;
const int Debug_ErrorHandler = 5;
const int Debug_ParseExpr = 6;
const int Debug_ParseItem = 7;
const int Debug_EvalOperation = 8;
const int Debug_DefSyntax = 9;
const int Debug_Define = 10;
const int Debug_DefinePart = 11;
const int Debug_Expand = 12;
const int Debug_ExpandSuccess = 13;
const int Debug_ExpandMiss = 14;
const int Debug_ExpandFail = 15;
const int Debug_GetSyntaxBlock = 16;
const int Debug_GetCodeBlock = 17;
const int Debug_LineNumber = 18;
const int Debug_TotalTally = 19;
const int Debug_Breakpoint = 20;
const int Debug_Delay = 21;
const int Debug_JumpTo = 22;
const int Debug_StepAction = 23;

const int uc_AddErrorHandler = 40;
const int uc_GetSymbolTable = 41;
const int uc_GetSteps = 42;
const int uc_GetStepsCount = 43;

const int uc_SetTypeOutput = 45;
const int uc_Group = 46;
const int uc_GetTag = 47;
const int uc_SetTag = 48;

const int uc_GetCallbackData = 50;
const int uc_SetCallbackReturn = 51;

const int uc_GetErrorExpression = 60;
const int uc_SetExpression = 61;
const int uc_GetSymbol = 62;
const int uc_SetSymbol = 63;
const int uc_GetLocation = 64;

const int uc_GetTokenType = 65;
const int uc_GetTokenProperties = 66;

const int uc_TrigMode = 67;

const int uc_ItemClone = 70;
const int uc_DataConvert = 71;
const int uc_DataCopy = 72;
const int uc_DataAlloc = 72;
const int uc_DataFree = 73;
const int uc_DataReset = 74;

// FPU commands
const int uc_SetFPU = 75;
const int uc_SetFPU_HostProg = 76;
const int uc_GetFPU = 77;
const int uc_GetFPU_HostProg = 78;
const int uc_ToggleFPU = 79;
const int uc_ToggleFPU_HostProg = 80;

const int uc_ErrorClear = 85;
const int uc_RestoreErrorMessageBox = 86;

const int uc_SetErrorMessage = 91;
const int uc_GetErrorMessage = 92;

const int uc_SerialNumber = 93;
const int uc_SetTurbo = 94;
const int uc_Expand = 95;
const int uc_GetNextToken = 96;
const int uc_GetItemData = 97;
const int uc_SetItemData = 98;
const int uc_GetThreadAddr = 99;
const int uc_GetCodeBlock = 100;

const int uc_Status_CurrentPass = 101;
const int uc_Status_MaxPass = 102;
const int uc_Status_Location = 103;
const int uc_Status_NestedLevel = 104;
const int uc_Status_TextLength = 105;

const int uc_Find = 110;
const int uc_FindAddMatch = 111;
const int uc_FindGetIndex = 112;
const int uc_FindGetCount = 113;
const int uc_FindGetStart = 114;
const int uc_FindGetLength = 115;
const int uc_FindGetText = 116;
const int uc_FindReset = 117;
const int uc_FindReplace = 118;
const int uc_FindFilter = 119;
const int uc_FindSetFilter = 120;

const int uc_FindFilterSort = 1;
const int uc_FindFilterUnique = 2;
const int uc_FindFilterTally = 4;
const int uc_FindFilterSeparator = 8;
const int uc_FindFilterStartText = 16;
const int uc_FindFilterEndText = 32;

const int uc_FindContext_Other = 0;
const int uc_FindContext_Found = 1;
const int uc_FindContext_Replaced = 2;

const int uc_FindZoomIn = 1;
const int uc_FindTransformInPlace = 2;

const int uc_Properties = 1;
const int uc_Thread = 2;
const int uc_Address = 3;
const int uc_SymbolName = 4;
const int uc_Rank = 5;
const int uc_Precedence = 6;
const int uc_OverloadHandle = 7;
const int uc_OverloadCount = 8;
const int uc_ByteSize = 9;
const int uc_ArgCount = 10;
const int uc_DataType = 12;
const int uc_Handle = 13;
const int uc_Value = 14;
const int uc_Property = 15;

// Error numbers
const int uc_Err_None = 0;
const int uc_Err_Dynamically_Defined = 1;
const int uc_Err_Syntax_Error = 2;
const int uc_Err_Undefined_Identifier = 3;
const int uc_Err_FileNotFound = 4;
const int uc_Err_Unrecognized_Token = 5;
const int uc_Err_Unrecognized_Command = 6;
const int uc_Err_Datatype_Mismatch = 7;
const int uc_Err_Invalid_Argument_Count = 8;
const int uc_Err_Invalid_Definition = 9;
const int uc_Err_CodeBlock_Error = 10;
const int uc_Err_Undefined_Callback = 11;
const int uc_Err_ErrMsgAlreadyDefined = 12;
const int uc_Err_ItemCannotBeModified = 13;
const int uc_Err_Unrecognized_Member = 14;
const int uc_Err_Unbalanced_Quote = 15;

const int uc_Err_Array_Bounds_Exceeded = 20;
const int uc_Err_Float_Denormal_Operand = 21;
const int uc_Err_Float_Divide_By_Zero = 22;
const int uc_Err_Float_Inexact_Result = 23;
const int uc_Err_Float_Invalid_Operation = 24;
const int uc_Err_Float_Overflow = 25;
const int uc_Err_Float_Stack_Check = 26;
const int uc_Err_Float_Underflow = 27;
const int uc_Err_Integer_Divide_By_Zero = 28;
const int uc_Err_Integer_Overflow = 29;
const int uc_Err_Privileged_Instruction = 30;

// Error response
const int ucAbort = 0;
const int ucResume = 1;
const int ucReRaise = 2;

// FPU Control Word Settings
const int uc_FPU_Mask_InvalidOp = 1;
const int uc_FPU_Mask_DenormalOp = 2;
const int uc_FPU_Mask_ZeroDivide = 4;
const int uc_FPU_Mask_Overflow = 8;
const int uc_FPU_Mask_Underflow = 16;
const int uc_FPU_Mask_PrecisionLoss = 32;

const int uc_FPU_Precision_Single = 0;
const int uc_FPU_Precision_Double = 256;
const int uc_FPU_Precision_Extended = 768;

const int uc_FPU_Round_Even = 0;
const int uc_FPU_Round_Down = 1024;
const int uc_FPU_Round_Up = 2048;
const int uc_FPU_Round_Toward = 3072;

// Data type handler callback action modes
const int uc_TypeHandler_Store = 2;
const int uc_TypeHandler_StringOutput = 3;
const int uc_TypeHandler_Free = 4;
const int uc_TypeHandler_FuncRet = 5;
const int uc_TypeHandler_Copy = 6;
const int uc_TypeHandler_Alloc = 7;
const int uc_TypeHandler_Reset = 8;

const int uc_Callback_Undefined = 0; // Returns error

// Data Type callbacks
const int uc_Complex = 1;
const int uc_Currency = 2;
const int uc_Double = 3;
const int uc_Extended = 4;
const int uc_Int8 = 5;
const int uc_Int8u = 6;
const int uc_Int16 = 7;
const int uc_Int16u = 8;
const int uc_Int32 = 9;
const int uc_Int32u = 10;
const int uc_Int64 = 11;
const int uc_Int64u = 12;
const int uc_Single = 13;
const int uc_String = 14;
const int uc_String_LPCSTR = 15;
const int uc_String_Fixed = 16;
const int uc_String_Wide = 17;
const int uc_Stack = 18;
const int uc_Table = 19;
const int uc_SortedList = 20;
const int uc_Void = 21;
const int uc_User_Type = 22;

const int uc_Convert_Generic = 23;
const int uc_Convert_Same = 24;
const int uc_Convert_Double_Extended = 25;
const int uc_Convert_Int8_Extended = 26;
const int uc_Convert_Int8u_Extended = 27;
const int uc_Convert_Int16_Extended = 28;
const int uc_Convert_Int16u_Extended = 29;
const int uc_Convert_Int32_Extended = 30;
const int uc_Convert_Int32u_Extended = 31;
const int uc_Convert_Int64_Extended = 32;
const int uc_Convert_Int64u_Extended = 33;
const int uc_Convert_Single_Extended = 34;
const int uc_Convert_Void_Extended = 35;
const int uc_Convert_Extended_Double = 37;
const int uc_Convert_Extended_Single = 38;
const int uc_Convert_Extended_Int16u = 39;
const int uc_Convert_Extended_Int32 = 40;
const int uc_Convert_Complex_Extended = 41;
const int uc_Convert_Extended_Complex = 42;

// Default built-in routines
const int uc_Op_Negate = 43;
const int uc_Op_UnaryPlus = 44;
const int uc_Op_Percentage = 45;
const int uc_Op_StrConcat = 46;
const int uc_Op_Add_Int32 = 47;
const int uc_Op_Add = 48;
const int uc_Op_Add_Complex = 49;
const int uc_Op_Subtract_Int32 = 50;
const int uc_Op_Subtract = 51;
const int uc_Op_Multiply_Int32 = 52;
const int uc_Op_Multiply = 53;
const int uc_Op_Multiply_Complex = 54;
const int uc_Op_Divide_Int32 = 55;
const int uc_Op_Divide = 56;
const int uc_Op_Mod_Int32 = 57;
const int uc_Op_Mod = 58;
const int uc_Op_PowerOf_ExtToExt = 59;
const int uc_Op_PowerOf_ExtToLng = 60;
const int uc_Op_PowerOf_CplxToCplx = 61;

const int uc_Op_GreaterThan = 62;
const int uc_Op_GreaterOrEqual = 63;
const int uc_Op_LessThan = 64;
const int uc_Op_LessOrEqual = 65;
const int uc_Op_Equal = 66;
const int uc_Op_NotEqual = 67;

const int uc_Op_GreaterThan_Str = 68;
const int uc_Op_GreaterOrEqual_Str = 69;
const int uc_Op_LessThan_Str = 70;
const int uc_Op_LessOrEqual_Str = 71;
const int uc_Op_Equal_Str = 72;
const int uc_Op_NotEqual_Str = 73;

const int uc_Op_Not_Int32 = 74;
const int uc_Op_And_Int32 = 75;
const int uc_Op_Or_Int32 = 76;
const int uc_Op_Xor_Int32 = 77;
const int uc_Op_Eqv_Int32 = 78;
const int uc_Op_Imp_Int32 = 79;

const int uc_Op_AndAlso = 80;
const int uc_Op_OrElse = 81;

const int uc_Op_Factorial = 82;

const int uc_Func_IIf = 83;
const int uc_Func_IIf_Str = 84;

const int uc_Func_Sin = 85;
const int uc_Func_Cos = 86;
const int uc_Func_Tan = 87;
const int uc_Func_Atan = 88;
const int uc_Func_Ceil = 89;
const int uc_Func_Abs = 90;
const int uc_Func_Abs_Int32 = 91;
const int uc_Func_Exp = 92;
const int uc_Func_Log = 93;
const int uc_Func_Floor = 94;
const int uc_Func_SquareRoot = 95;
const int uc_Func_BaseConvert = 96;

const int uc_Func_ExprHandle = 97;
const int uc_Func_VarPtr = 98;
const int uc_Func_uCalc = 99;
const int uc_Func_uCalcStr = 100;
const int uc_Func_ucAddr = 101;
const int uc_Func_ValueAtAddr = 102;
const int uc_Func_SpecialArg = 103;
const int uc_Op_StringMult = 104;

const int uc_Func_For = 105;
const int uc_Func_Loop = 107;

const int uc_Func_LoadLibrary = 108;
const int uc_Func_GetProcAddress = 109;

const int uc_NullString = 110;
const int uc_True = 111;

const int uc_Func_Peek = 112;
const int uc_Func_Poke = 113;

const int uc_Func_Int = 115;
const int uc_Func_Frac = 116;
const int uc_Func_Sgn = 117;

const int uc_Func_PushData_Stack = 120;
// const int uc_Func_PopHandle_Stack = 121;
const int uc_Func_PopNum_Stack = 122;
const int uc_Func_PopStr_Stack = 123;
const int uc_Func_ReadHandle_Stack = 124;
const int uc_Func_ReadNum_Stack = 125;
const int uc_Func_ReadStr_Stack = 126;
const int uc_Func_Count_Stack = 127;
const int uc_Op_Concat_Stack = 128;
const int uc_Func_Populate_Stack = 129;

const int uc_Insert_Table = 130;
const int uc_Delete_Table = 131;
const int uc_Index_Table = 132;
const int uc_Handle_Table = 133;
const int uc_HandleB_Table = 134;
const int uc_ReadData_Table = 135;
const int uc_ReadNum_Table = 136;

const int uc_Func_Min = 137;
const int uc_Func_Max = 138;
const int uc_Func_Min_Str = 139;
const int uc_Func_Max_Str = 140;

const int uc_SetVariableValue = 141;
const int uc_SetVariableValueAnyType = 141;
const int uc_SetVariableValueLong = 142;
const int uc_SetVariableValueDouble = 143;
const int uc_SetVariableValueExtended = 144;
const int uc_ResetVariable = 145;

// Misc other callbacks
const int uc_EvaluateAddr = 150;
const int uc_EvaluateTurboAddr = 151;
const int uc_ExceptionHelper = 152;
const int uc_DefaultErrorHandler = 153;
const int uc_Raise_Error = 154;
const int uc_Func_IsIncomplete = 155;

const int uc_ScriptTimerStart = 160;
const int uc_LoadTimeTix = 161;

const int uc_Op_Ext_Plus_Complex = 190;
const int uc_Op_Ext_Times_Complex = 191;

const int uc_Func_If_ElseIf = 195;
const int uc_Func_SetSyntaxParams = 196;
const int uc_Func_SpecialUCase = 197;
const int uc_Func_Rand = 198;
const int uc_Func_GetmatchArg = 199;
const int uc_Func_PatternNum = 200;
const int uc_Func_PatternStr = 201;

const int uc_Convert_Stack_Table = 220;
const int uc_Convert_Stack_SortedList = 221;
const int uc_Convert_Table_Stack = 222;
const int uc_Convert_SortedList_Stack = 223;

const int uc_Expand_List = 1;
const int uc_Expand_StackPtr = 2;

const int uc_HandleToken = 21; // &h15

// Trig Mode
const int uc_ReturnTrigMode = 0;
const int uc_Radians = 1;
const int uc_Degrees = 2;
const int uc_Grad = 3;

// Misc
const int ucTrue = 1;
const int ucFalse = 0;
const int uc_Rank_First = 1;
const int uc_Rank_Last = -1;

// Pattern options
const int uc_Pattern_ArgCount = 1;
const int uc_Pattern_ArgIndex = 2;
const int uc_Pattern_ArgLength = 3;
const int uc_Pattern_ArgLocation = 4;
const int uc_Pattern_ArgText = 5;
const int uc_Pattern_DocumentLength = 6;
const int uc_Pattern_DocumentText = 7;
const int uc_Pattern_CriteriaCount = 8;
const int uc_Pattern_CriteriaIndex = 9;
const int uc_Pattern_MatchLength = 10;
const int uc_Pattern_MatchLocation = 11;
const int uc_Pattern_MatchText = 12;
const int uc_Pattern_MatchTally = 13;
const int uc_Pattern_SkipTally = 14;

// String Library
const int uc_StringLibNum = 230;
const int uc_StringLibStr = 231;
const int ucs_SetStringDefaults = 4;
const int ucs_Start = 5;
const int ucs_Limit = 6;
const int ucs_StartAfter = 7;
const int ucs_StopAfter = 8;
const int ucs_Between = 9;
const int ucs_Nth = 10;
const int ucs_File = 11;
const int ucs_Pos = 12;
const int ucs_Length = 13;
const int ucs_Text = 14;
const int ucs_Count = 15;
const int ucs_CountSkipped = 16;
const int ucs_InStr = 17;
const int ucs_Tally = 18;
const int ucs_UCase = 19;
const int ucs_LCase = 20;
const int ucs_MCase = 21;
const int ucs_Replace = 22;
const int ucs_Remove = 23;
const int ucs_Mid = 24;
const int ucs_Left = 25;
const int ucs_Right = 26;
const int ucs_Len = 27;
const int ucs_Extract = 28;
const int ucs_Remain = 29;
const int ucs_Skip = 30;
const int ucs_Delim = 31;
const int ucs_Retain = 32;
const int ucs_Range = 33;
const int ucs_Compare = 34;
const int ucs_Equals = 35;
const int ucs_Split = 36;
const int ucs_StringItem = 37;
const int ucs_StringItemCount = 38;

// String Libarary Options
const int ucByte = 1;
const int ucChar = 2;
const int ucWord = 4;
const int ucToken = 8;
const int ucBlock = 16;
const int ucExpr = 32;
const int ucQuote = 64;
const int ucSpace = 128;
const int ucCase = 256;
// End Of String Library Options

public delegate void ucFunctionDelegate(int Expr);
public delegate int ucErrorHandlerDelegate(int t);
public delegate int ucCheckForStop(int FindContext, int t);

// Main Functions
[DllImport(uCalcDLL)] int ucAddr(int AddressIndex);
[DllImport(uCalcDLL, EntryPoint="uCalc")] int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % TextIn , int a , int b , int c , int t );
int uCalc(int ucCommand, String ^ TextIn = "", int a = 0, int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand,    TextIn ,  a ,  b ,  c ,  t );
}
[DllImport(uCalcDLL, EntryPoint="uCalc")] int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % TextIn, ucCheckForStop ^ a , int b , int c , int t );
int uCalc(int ucCommand, String ^ TextIn, ucCheckForStop ^ a , int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand,    TextIn,   a ,  b ,  c ,  t );
}
[DllImport(uCalcDLL, EntryPoint="uCalc")] int uCalc_(int ucCommand, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % TextIn, ucFunctionDelegate ^ a , int b , int c , int t );
int uCalc(int ucCommand, String ^ TextIn, ucFunctionDelegate ^ a , int b = 0, int c = 0, int t = 0) {
   return uCalc_( ucCommand,    TextIn,   a ,  b ,  c ,  t );
}

// Insert Other Exports
[DllImport(uCalcDLL)] int ExceptionHelper(int Expr, int SystemError);
[DllImport(uCalcDLL)] double ucEvaluate(int Item);
[DllImport(uCalcDLL)] int ucArgLng(int Expr, int index);
[DllImport(uCalcDLL)] double ucArg(int Expr, int index);
[DllImport(uCalcDLL, EntryPoint="ucArgStr")] void ucArgStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int Expr, int index);
String ^ ucArgStr(int Expr, int index) {
   String ^ ReturnStr = "";
   ucArgStr_(ReturnStr,  Expr,  index);
   return ReturnStr;
}
[DllImport(uCalcDLL)] int ucArgHandle(int Expr, int index);
[DllImport(uCalcDLL)] int ucArgCount(int Expr);
[DllImport(uCalcDLL)] void ucReturnLng (int Expr, int ReturnValue);
[DllImport(uCalcDLL, EntryPoint="ucReturnDbl")] void ucReturn(int Expr, Double ReturnValue);
[DllImport(uCalcDLL, EntryPoint="ucReturnStr")] void ucReturnStr_(int Expr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % ReturnValue);
void ucReturnStr(int Expr, String ^ ReturnValue) {
    ucReturnStr_( Expr,    ReturnValue);
}
[DllImport(uCalcDLL)] double ucGetVariableValue(int Item);
[DllImport(uCalcDLL)] int ucGetVariableValueLng(int Item);
[DllImport(uCalcDLL, EntryPoint="ucGetVariableValueStr")] void ucGetVariableValueStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int Item);
String ^ ucGetVariableValueStr(int Item) {
   String ^ ReturnStr = "";
   ucGetVariableValueStr_(ReturnStr,  Item);
   return ReturnStr;
}
[DllImport(uCalcDLL)] void ucSetVariableValueLng (int Item, int NewValue);
[DllImport(uCalcDLL, EntryPoint="ucSetVariableValueDbl")] void ucSetVariableValue(int Item, Double NewValue);
[DllImport(uCalcDLL, EntryPoint="ucSetVariableValueStr")] void ucSetVariableValueStr_(int Item, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % NewValue);
void ucSetVariableValueStr(int Item, String ^ NewValue) {
    ucSetVariableValueStr_( Item,    NewValue);
}
[DllImport(uCalcDLL)] int ucExprThread(int Expr);
[DllImport(uCalcDLL)] int ucLicense(int Product, UInt32 L1 = 0, UInt32 L2 = 0, UInt32 L3 = 0, UInt32 L4 = 0, UInt32 L5 = 0);
// End Insert
[DllImport(uCalcDLL, EntryPoint="uCalcStr")] void uCalcStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int ucCommand, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % TextIn , int a , int b , int c , int t );
String ^ uCalcStr(int ucCommand, String ^  TextIn = "", int a = 0, int b = 0, int c = 0, int t = 0) {
   String ^ ReturnStr = "";
   uCalcStr_(ReturnStr,  ucCommand,    TextIn ,  a ,  b ,  c ,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL)] int ucClose32bitDLL(int ReserverdArg);
[DllImport(uCalcDLL, EntryPoint="ucDefine")] int ucDefine_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, int Arg1 , int Arg2 , int Arg3 , int t );
int ucDefine(String ^ Definition, int Arg1 = 0, int Arg2 = 0, int Arg3 = 0, int t = 0) {
   return ucDefine_(   Definition,  Arg1 ,  Arg2 ,  Arg3 ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineConstant")] int ucDefineConstant_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, int t );
int ucDefineConstant(String ^ Definition, int t = 0) {
   return ucDefineConstant_(   Definition,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineFunction")] int ucDefineFunction_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, ucFunctionDelegate ^ FuncAddress  , int t );
int ucDefineFunction(String ^ Definition, ucFunctionDelegate ^ FuncAddress  = nullptr, int t = 0) {
   return ucDefineFunction_(   Definition,   FuncAddress  ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineOperator")] int ucDefineOperator_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, ucFunctionDelegate ^ FuncAddress  , int t );
int ucDefineOperator(String ^ Definition, ucFunctionDelegate ^ FuncAddress  = nullptr, int t = 0) {
   return ucDefineOperator_(   Definition,   FuncAddress  ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineSyntax")] int ucDefineSyntax_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, int Rank , int t );
int ucDefineSyntax(String ^ Definition, int Rank = 0, int t = 0) {
   return ucDefineSyntax_(   Definition,  Rank ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucDefineVariable")] int ucDefineVariable_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Definition, int VarAddress , int t );
int ucDefineVariable(String ^ Definition, int VarAddress = 0, int t = 0) {
   return ucDefineVariable_(   Definition,  VarAddress ,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucEval")] double ucEval_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Expr, int t );
double ucEval(String ^ Expr, int t = 0) {
   return ucEval_(   Expr,  t );
}
[DllImport(uCalcDLL, EntryPoint="ucEvalStr")] void ucEvalStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Expr, int ExprType , int t );
String ^ ucEvalStr(String ^  Expr, int ExprType = 0, int t = 0) {
   String ^ ReturnStr = "";
   ucEvalStr_(ReturnStr,    Expr,  ExprType ,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucEvaluateStr")] void ucEvaluateStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int ucItem);
String ^ ucEvaluateStr(int ucItem) {
   String ^ ReturnStr = "";
   ucEvaluateStr_(ReturnStr,  ucItem);
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucExpand")] void ucExpand_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Expr, int t );
String ^ ucExpand(String ^  Expr, int t = 0) {
   String ^ ReturnStr = "";
   ucExpand_(ReturnStr,    Expr,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL)] int ucFPU(int FPU_Command, int FPU_Option = 0);
[DllImport(uCalcDLL)] int ucGetTrigMode();
[DllImport(uCalcDLL)] int ucInitialize(int NewThread = 0);
[DllImport(uCalcDLL)] int ucNewThread(int ParentThread = 0, int MakeThisDefault = 0);
[DllImport(uCalcDLL, EntryPoint="ucParse")] int ucParse_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Expr, int ExprType , int t );
int ucParse(String ^ Expr, int ExprType = 0, int t = 0) {
   return ucParse_(   Expr,  ExprType ,  t );
}
[DllImport(uCalcDLL)] int ucReleaseItem(int ucItem);
[DllImport(uCalcDLL, EntryPoint="ucRun")] void ucRun_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % RunOption, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % TextIn, int ExpandCount , int t );
String ^ ucRun(String ^  RunOption, String ^  TextIn, int ExpandCount = 0, int t = 0) {
   String ^ ReturnStr = "";
   ucRun_(ReturnStr,    RunOption,    TextIn,  ExpandCount ,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucSetOutput")] int ucSetOutput_(ucFunctionDelegate ^ FuncAddress  , [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % FuncName , [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % DataType , int t );
int ucSetOutput(ucFunctionDelegate ^ FuncAddress  = nullptr, String ^ FuncName = "", String ^ DataType = "", int t = 0) {
   return ucSetOutput_(  FuncAddress  ,    FuncName ,    DataType ,  t );
}
[DllImport(uCalcDLL)] int ucSetTrigMode(int TrigMode);

// Error handling
[DllImport(uCalcDLL)] int ucAddErrorHandler(ucErrorHandlerDelegate ^ ErrorHandlerAddress  = nullptr, int t = 0);
[DllImport(uCalcDLL)] int ucError(int t = 0);
[DllImport(uCalcDLL, EntryPoint="ucErrorMessage")] void ucErrorMessage_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int ErrorNumber , int t );
String ^ ucErrorMessage(int ErrorNumber = 0, int t = 0) {
   String ^ ReturnStr = "";
   ucErrorMessage_(ReturnStr,  ErrorNumber ,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucErrorExpression")] void ucErrorExpression_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int t );
String ^ ucErrorExpression(int t = 0) {
   String ^ ReturnStr = "";
   ucErrorExpression_(ReturnStr,  t );
   return ReturnStr;
}
[DllImport(uCalcDLL)] int ucErrorLocation(int t);
[DllImport(uCalcDLL, EntryPoint="ucErrorSymbol")] void ucErrorSymbol_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int t);
String ^ ucErrorSymbol(int t) {
   String ^ ReturnStr = "";
   ucErrorSymbol_(ReturnStr,  t);
   return ReturnStr;
}
[DllImport(uCalcDLL)] int ucRaiseError(int Expr, int ErrorNumber);
[DllImport(uCalcDLL, EntryPoint="ucRaiseErrorMessage")] int ucRaiseErrorMessage_(int Expr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % ErrorMessage);
int ucRaiseErrorMessage(int Expr, String ^ ErrorMessage) {
   return ucRaiseErrorMessage_( Expr,    ErrorMessage);
}
[DllImport(uCalcDLL)] int ucSetError(int ErrorNumber, int t = 0);
[DllImport(uCalcDLL, EntryPoint="ucSetErrorMessage")] int ucSetErrorMessage_(int ErrorIndex, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % ErrorMessage, int t );
int ucSetErrorMessage(int ErrorIndex, String ^ ErrorMessage, int t = 0) {
   return ucSetErrorMessage_( ErrorIndex,    ErrorMessage,  t );
}
[DllImport(uCalcDLL)] int ucSetErrorNumber(int ErrorNumber, int t = 0);

// uCalc String Library
[DllImport(uCalcDLL)] int ucLoadStringLibInFMP(int tHandle = 0);

// uCalc String Library Routine Exports
[DllImport(uCalcDLL)] int ucBetween(int a, int b);
[DllImport(uCalcDLL, EntryPoint="ucCompare")] int ucCompare_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % String1, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % String2, int Options );
int ucCompare(String ^ String1, String ^ String2, int Options = 0) {
   return ucCompare_(   String1,    String2,  Options );
}
[DllImport(uCalcDLL)] int ucCount();
[DllImport(uCalcDLL)] int ucCountSkipped();
[DllImport(uCalcDLL, EntryPoint="ucDelim")] int ucDelim_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Delim, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % L , [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % R );
int ucDelim(String ^ Delim, String ^ L = "", String ^ R = "") {
   return ucDelim_(   Delim,    L ,    R );
}
[DllImport(uCalcDLL, EntryPoint="ucEquals")] int ucEquals_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % String1, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % String2, int Options );
int ucEquals(String ^ String1, String ^ String2, int Options = 0) {
   return ucEquals_(   String1,    String2,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucInStr")] int ucInStr_(int Start, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, int Options );
int ucInStr(int Start, String ^ MainString, String ^ Pattern, int Options = 0) {
   return ucInStr_( Start,    MainString,    Pattern,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucLen")] int ucLen_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % MainString, int Options );
int ucLen(String ^ MainString, int Options = 0) {
   return ucLen_(   MainString,  Options );
}
[DllImport(uCalcDLL)] int ucLength(int x = 0);
[DllImport(uCalcDLL)] int ucLimit(int Limit);
[DllImport(uCalcDLL)] int ucNth(int Number);
[DllImport(uCalcDLL)] int ucPos(int x = 0);
[DllImport(uCalcDLL)] int ucSetStringDefaults(int Options);
[DllImport(uCalcDLL, EntryPoint="ucSkip")] int ucSkip_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % MainString);
int ucSkip(String ^ MainString) {
   return ucSkip_(   MainString);
}
[DllImport(uCalcDLL, EntryPoint="ucSplit")] int ucSplit_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Delim , int Options );
int ucSplit(String ^ MainString, String ^ Delim = "", int Options = 0) {
   return ucSplit_(   MainString,    Delim ,  Options );
}
[DllImport(uCalcDLL)] int ucStart(int Position);
[DllImport(uCalcDLL)] int ucStartAfter(int Number);
[DllImport(uCalcDLL)] int ucStopAfter(int Number);
[DllImport(uCalcDLL)] int ucStringItemCount();
[DllImport(uCalcDLL, EntryPoint="ucTally")] int ucTally_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, int Options );
int ucTally(String ^ MainString, String ^ Pattern, int Options = 0) {
   return ucTally_(   MainString,    Pattern,  Options );
}
[DllImport(uCalcDLL, EntryPoint="ucExtract")] void ucExtract_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, int Options );
String ^ ucExtract(String ^  MainString, String ^  Pattern, int Options = 0) {
   String ^ ReturnStr = "";
   ucExtract_(ReturnStr,    MainString,    Pattern,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucFile")] void ucFile_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % NameOfFile);
String ^ ucFile(String ^  NameOfFile) {
   String ^ ReturnStr = "";
   ucFile_(ReturnStr,    NameOfFile);
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucLCase")] void ucLCase_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern , int Options );
String ^ ucLCase(String ^  MainString, String ^  Pattern = "", int Options = 0) {
   String ^ ReturnStr = "";
   ucLCase_(ReturnStr,    MainString,    Pattern ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucLeft")] void ucLeft_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, int Number, int Options );
String ^ ucLeft(String ^  MainString, int Number, int Options = 0) {
   String ^ ReturnStr = "";
   ucLeft_(ReturnStr,    MainString,  Number,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucMCase")] void ucMCase_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern , int Options );
String ^ ucMCase(String ^  MainString, String ^  Pattern = "", int Options = 0) {
   String ^ ReturnStr = "";
   ucMCase_(ReturnStr,    MainString,    Pattern ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucMid")] void ucMid_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, int Start, int Length , int Options );
String ^ ucMid(String ^  MainString, int Start, int Length = 0, int Options = 0) {
   String ^ ReturnStr = "";
   ucMid_(ReturnStr,    MainString,  Start,  Length ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRange")] void ucRange_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int Start, int Finish, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Expression, int Options );
String ^ ucRange(int Start, int Finish, String ^  Expression, int Options = 0) {
   String ^ ReturnStr = "";
   ucRange_(ReturnStr,  Start,  Finish,    Expression,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRemain")] void ucRemain_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, int Options );
String ^ ucRemain(String ^  MainString, String ^  Pattern, int Options = 0) {
   String ^ ReturnStr = "";
   ucRemain_(ReturnStr,    MainString,    Pattern,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRemove")] void ucRemove_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, int Options );
String ^ ucRemove(String ^  MainString, String ^  Pattern, int Options = 0) {
   String ^ ReturnStr = "";
   ucRemove_(ReturnStr,    MainString,    Pattern,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucReplace")] void ucReplace_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Replacement , int Options );
String ^ ucReplace(String ^  MainString, String ^  Pattern, String ^  Replacement = "", int Options = 0) {
   String ^ ReturnStr = "";
   ucReplace_(ReturnStr,    MainString,    Pattern,    Replacement ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRetain")] void ucRetain_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Filter , int Options );
String ^ ucRetain(String ^  MainString, String ^  Pattern, String ^  Filter = "", int Options = 0) {
   String ^ ReturnStr = "";
   ucRetain_(ReturnStr,    MainString,    Pattern,    Filter ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucRight")] void ucRight_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, int Number, int Options );
String ^ ucRight(String ^  MainString, int Number, int Options = 0) {
   String ^ ReturnStr = "";
   ucRight_(ReturnStr,    MainString,  Number,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucStringItem")] void ucStringItem_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int Index);
String ^ ucStringItem(int Index) {
   String ^ ReturnStr = "";
   ucStringItem_(ReturnStr,  Index);
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucUCase")] void ucUCase_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % MainString, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % Pattern , int Options );
String ^ ucUCase(String ^  MainString, String ^  Pattern = "", int Options = 0) {
   String ^ ReturnStr = "";
   ucUCase_(ReturnStr,    MainString,    Pattern ,  Options );
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="uCalcRaw")] int uCalcRaw_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % ReturnStr_, int uc, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle);
int uCalcRaw(String ^ ReturnStr_, int uc, String ^ TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle) {
   return uCalcRaw_(   ReturnStr_,  uc,    TextIn,  Misc1,  Misc2,  ReturnPtr,  tHandle);
}

// Deprecated notations
// Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
[DllImport(uCalcDLL, EntryPoint="ucArg")] double ucParam(int ExprHandle, int Index);
[DllImport(uCalcDLL, EntryPoint="ucArgStr")] void ucParamStr_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int ExprHandle, int Index);
String ^ ucParamStr(int ExprHandle, int Index) {
   String ^ ReturnStr = "";
   ucParamStr_(ReturnStr,  ExprHandle,  Index);
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucArgCount")] int ucParamCount(int ExprHandle);
[DllImport(uCalcDLL, EntryPoint="ucArgHandle")] int ucParamHandle(int ExprHandle, int Index);
[DllImport(uCalcDLL, EntryPoint="ucErrorLocation")] int ucErrLocation(int t);
[DllImport(uCalcDLL, EntryPoint="ucErrorSymbol")] void ucErrSymbol_([In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ % ReturnStr, int t);
String ^ ucErrSymbol(int t) {
   String ^ ReturnStr = "";
   ucErrSymbol_(ReturnStr,  t);
   return ReturnStr;
}
[DllImport(uCalcDLL, EntryPoint="ucSetErrorMessage")] int ucSetErrMsg_(int Index, [In,Out,MarshalAs(UnmanagedType::AnsiBStr)] String ^ % Msg);
int ucSetErrMsg(int Index, String ^ Msg) {
   return ucSetErrMsg_( Index,    Msg);
}

