// ---------------------------------------------------------------------------
// uCalcVCx64.h: VC++ Native include file for uCalc Fast Math Parser 4.00
// Designed for : Visual C++ 2010 & 2012 - Native/No MFC/No CLR (unmanaged)
//                Add the following line to your code:
//                #include "uCalcVC.h" in your code.
//
// This file auto-generated by : VisualCPP.uc using uCalc Transform 3.0
// Auto-generation timestamp: 08/14/14
// VisualCPP.uc prepared by : Daniel Corbier
// Visit www.ucalc.com for additional resources.
// ---------------------------------------------------------------------------

#pragma once
#include <windows.h>
#include <oleauto.h>
#include <wtypes.h>
#include <string>
using namespace std;

// Definition properties
const int ucAlphaNumeric = 1;
const int ucArgSeparator = 2;
const int ucCodeBlock = 3;
const int ucCodeBlockMatch = 4;
const int ucMemberAccess = 5;
const int ucQuotedText = 6;
const int ucStatementSep = 7;
const int ucWhiteSpace = 8;

const int ucCurrentThread = 9;

const int ucLocalVar = 10;
const int ucStaticVar = 11;
const int ucDefineNow = 11;
const int ucTempDef = 12;
const int ucEvalInsert = 13;
const int ucEvalDuringParse = 14;
const int ucExpandInsert = 15;
const int ucFileInclude = 16;

const int ucCurrentSpace = 17;
const int ucDefSpace = 18;
const int ucEvalSpace = 19;

const int ucFunction = 64;
const int ucOperator = 128;
const int ucVariable = 256;
const int ucSyntax = 512;
const int ucLiteral = 1024;
const int ucSymbol = 2048;
const int ucReducible = 4096;
const int ucLock = 8192;
const int ucInfix = 16384;
const int ucPrefix = 32768;
const int ucPostfix = 49152;

// uCalc Commands
const int uc_Define = 1;
const int uc_DefineSyntax = 2;
const int uc_Eval = 3;
const int uc_EvalStr = 4;
const int uc_Evaluate = 5;
const int uc_EvaluateLng = 6;
const int uc_EvaluateStr = 7;
const int uc_GetCaseSensitivity = 8;
const int uc_GetDefaultPass = 9;
const int uc_GetDefaultPrecedence = 10;
const int uc_GetDefaultRank = 11;
const int uc_GetCodeAddr = 12;
const int uc_GetDefaultThread = 13;
const int uc_GetDefaultType = 14;
const int uc_GetDefSeparator = 15;
const int uc_GetDefSpace = 16;
const int uc_GetErrorNumber = 17;
const int uc_GetEvalSpace = 18;
const int uc_GetParentThread = 20;
const int uc_GetSyntaxEqual = 21;
const int uc_Parse = 22;
const int uc_ReleaseItem = 23;
const int uc_SetCaseSensitivity = 24;
const int uc_SetCodeAddr = 25;
const int uc_SetDefaultPrecedence = 26;
const int uc_SetDefaultRank = 27;
const int uc_SetDefaultThread = 28;
const int uc_SetDefaultType = 29;
const int uc_SetDefSeparator = 30;
const int uc_SetErrorNumber = 31;
const int uc_SetParentThread = 32;
const int uc_SetSyntaxEqual = 33;
const int uc_NewThread = 34;

const int uc_RegExWordBoundaryChars = 35;
const int uc_RegExEscapeChar = 36;
const int uc_License = 37;

// License options
const int uc_License_Demo = 0;
const int uc_License_FMP_Free = 1;
const int uc_License_FMP_Standard_32 = 2;
const int uc_License_FMP_Standard_64 = 3;
const int uc_License_FMP_32_and_64 = 4;
const int uc_License_LanguageBuilder = 5;
const int uc_License_GeneralParser = 6;
const int uc_License_Interpreter = 7;
const int uc_License_ConsoleCalc = 8;
const int uc_License_WindowsCalc = 9;
const int uc_License_StringLib = 10;
const int uc_License_Transform = 11;
const int uc_License_TransformLib = 12;
const int uc_License_Search = 13;
const int uc_License_SearchLib = 14;
const int uc_License_Library1 = 15;
const int uc_License_Library2 = 16;
const int uc_License_Beta = 17;
const int uc_License_Debugger = 18;
const int uc_License_uCalc_All = 50;
const int uc_License_Developer = 100;
const int uc_License_EndUser = 101;

const int uc_AddDebugger = 39;
const int Debug_ReleaseItem = 1;
const int Debug_StdFuncCall = 2;
const int Debug_UserFuncCall = 3;
const int Debug_GetTextToken = 4;
const int Debug_ErrorHandler = 5;
const int Debug_ParseExpr = 6;
const int Debug_ParseItem = 7;
const int Debug_EvalOperation = 8;
const int Debug_DefSyntax = 9;
const int Debug_Define = 10;
const int Debug_DefinePart = 11;
const int Debug_Expand = 12;
const int Debug_ExpandSuccess = 13;
const int Debug_ExpandMiss = 14;
const int Debug_ExpandFail = 15;
const int Debug_GetSyntaxBlock = 16;
const int Debug_GetCodeBlock = 17;
const int Debug_LineNumber = 18;
const int Debug_TotalTally = 19;
const int Debug_Breakpoint = 20;
const int Debug_Delay = 21;
const int Debug_JumpTo = 22;
const int Debug_StepAction = 23;

const int uc_AddErrorHandler = 40;
const int uc_GetSymbolTable = 41;
const int uc_GetSteps = 42;
const int uc_GetStepsCount = 43;

const int uc_SetTypeOutput = 45;
const int uc_Group = 46;
const int uc_GetTag = 47;
const int uc_SetTag = 48;

const int uc_GetCallbackData = 50;
const int uc_SetCallbackReturn = 51;

const int uc_GetErrorExpression = 60;
const int uc_SetExpression = 61;
const int uc_GetSymbol = 62;
const int uc_SetSymbol = 63;
const int uc_GetLocation = 64;

const int uc_GetTokenType = 65;
const int uc_GetTokenProperties = 66;

const int uc_TrigMode = 67;

const int uc_ItemClone = 70;
const int uc_DataConvert = 71;
const int uc_DataCopy = 72;
const int uc_DataAlloc = 72;
const int uc_DataFree = 73;
const int uc_DataReset = 74;

// FPU commands
const int uc_SetFPU = 75;
const int uc_SetFPU_HostProg = 76;
const int uc_GetFPU = 77;
const int uc_GetFPU_HostProg = 78;
const int uc_ToggleFPU = 79;
const int uc_ToggleFPU_HostProg = 80;

const int uc_ErrorClear = 85;
const int uc_RestoreErrorMessageBox = 86;

const int uc_SetErrorMessage = 91;
const int uc_GetErrorMessage = 92;

const int uc_SerialNumber = 93;
const int uc_SetTurbo = 94;
const int uc_Expand = 95;
const int uc_GetNextToken = 96;
const int uc_GetItemData = 97;
const int uc_SetItemData = 98;
const int uc_GetThreadAddr = 99;
const int uc_GetCodeBlock = 100;

const int uc_Status_CurrentPass = 101;
const int uc_Status_MaxPass = 102;
const int uc_Status_Location = 103;
const int uc_Status_NestedLevel = 104;
const int uc_Status_TextLength = 105;

const int uc_Find = 110;
const int uc_FindAddMatch = 111;
const int uc_FindGetIndex = 112;
const int uc_FindGetCount = 113;
const int uc_FindGetStart = 114;
const int uc_FindGetLength = 115;
const int uc_FindGetText = 116;
const int uc_FindReset = 117;
const int uc_FindReplace = 118;
const int uc_FindFilter = 119;
const int uc_FindSetFilter = 120;

const int uc_FindFilterSort = 1;
const int uc_FindFilterUnique = 2;
const int uc_FindFilterTally = 4;
const int uc_FindFilterSeparator = 8;
const int uc_FindFilterStartText = 16;
const int uc_FindFilterEndText = 32;

const int uc_FindContext_Other = 0;
const int uc_FindContext_Found = 1;
const int uc_FindContext_Replaced = 2;

const int uc_FindZoomIn = 1;
const int uc_FindTransformInPlace = 2;

const int uc_Properties = 1;
const int uc_Thread = 2;
const int uc_Address = 3;
const int uc_SymbolName = 4;
const int uc_Rank = 5;
const int uc_Precedence = 6;
const int uc_OverloadHandle = 7;
const int uc_OverloadCount = 8;
const int uc_ByteSize = 9;
const int uc_ArgCount = 10;
const int uc_DataType = 12;
const int uc_Handle = 13;
const int uc_Value = 14;
const int uc_Property = 15;

// Error numbers
const int uc_Err_None = 0;
const int uc_Err_Dynamically_Defined = 1;
const int uc_Err_Syntax_Error = 2;
const int uc_Err_Undefined_Identifier = 3;
const int uc_Err_FileNotFound = 4;
const int uc_Err_Unrecognized_Token = 5;
const int uc_Err_Unrecognized_Command = 6;
const int uc_Err_Datatype_Mismatch = 7;
const int uc_Err_Invalid_Argument_Count = 8;
const int uc_Err_Invalid_Definition = 9;
const int uc_Err_CodeBlock_Error = 10;
const int uc_Err_Undefined_Callback = 11;
const int uc_Err_ErrMsgAlreadyDefined = 12;
const int uc_Err_ItemCannotBeModified = 13;
const int uc_Err_Unrecognized_Member = 14;
const int uc_Err_Unbalanced_Quote = 15;

const int uc_Err_Array_Bounds_Exceeded = 20;
const int uc_Err_Float_Denormal_Operand = 21;
const int uc_Err_Float_Divide_By_Zero = 22;
const int uc_Err_Float_Inexact_Result = 23;
const int uc_Err_Float_Invalid_Operation = 24;
const int uc_Err_Float_Overflow = 25;
const int uc_Err_Float_Stack_Check = 26;
const int uc_Err_Float_Underflow = 27;
const int uc_Err_Integer_Divide_By_Zero = 28;
const int uc_Err_Integer_Overflow = 29;
const int uc_Err_Privileged_Instruction = 30;

// Error response
const int ucAbort = 0;
const int ucResume = 1;
const int ucReRaise = 2;

// FPU Control Word Settings
const int uc_FPU_Mask_InvalidOp = 1;
const int uc_FPU_Mask_DenormalOp = 2;
const int uc_FPU_Mask_ZeroDivide = 4;
const int uc_FPU_Mask_Overflow = 8;
const int uc_FPU_Mask_Underflow = 16;
const int uc_FPU_Mask_PrecisionLoss = 32;

const int uc_FPU_Precision_Single = 0;
const int uc_FPU_Precision_Double = 256;
const int uc_FPU_Precision_Extended = 768;

const int uc_FPU_Round_Even = 0;
const int uc_FPU_Round_Down = 1024;
const int uc_FPU_Round_Up = 2048;
const int uc_FPU_Round_Toward = 3072;

// Data type handler callback action modes
const int uc_TypeHandler_Store = 2;
const int uc_TypeHandler_StringOutput = 3;
const int uc_TypeHandler_Free = 4;
const int uc_TypeHandler_FuncRet = 5;
const int uc_TypeHandler_Copy = 6;
const int uc_TypeHandler_Alloc = 7;
const int uc_TypeHandler_Reset = 8;

const int uc_Callback_Undefined = 0;

// Data Type callbacks
const int uc_Complex = 1;
const int uc_Currency = 2;
const int uc_Double = 3;
const int uc_Extended = 4;
const int uc_Int8 = 5;
const int uc_Int8u = 6;
const int uc_Int16 = 7;
const int uc_Int16u = 8;
const int uc_Int32 = 9;
const int uc_Int32u = 10;
const int uc_Int64 = 11;
const int uc_Int64u = 12;
const int uc_Single = 13;
const int uc_String = 14;
const int uc_String_LPCSTR = 15;
const int uc_String_Fixed = 16;
const int uc_String_Wide = 17;
const int uc_Stack = 18;
const int uc_Table = 19;
const int uc_SortedList = 20;
const int uc_Void = 21;
const int uc_User_Type = 22;

const int uc_Convert_Generic = 23;
const int uc_Convert_Same = 24;
const int uc_Convert_Double_Extended = 25;
const int uc_Convert_Int8_Extended = 26;
const int uc_Convert_Int8u_Extended = 27;
const int uc_Convert_Int16_Extended = 28;
const int uc_Convert_Int16u_Extended = 29;
const int uc_Convert_Int32_Extended = 30;
const int uc_Convert_Int32u_Extended = 31;
const int uc_Convert_Int64_Extended = 32;
const int uc_Convert_Int64u_Extended = 33;
const int uc_Convert_Single_Extended = 34;
const int uc_Convert_Void_Extended = 35;
const int uc_Convert_Extended_Double = 37;
const int uc_Convert_Extended_Single = 38;
const int uc_Convert_Extended_Int16u = 39;
const int uc_Convert_Extended_Int32 = 40;
const int uc_Convert_Complex_Extended = 41;
const int uc_Convert_Extended_Complex = 42;

// Default built-in routines
const int uc_Op_Negate = 43;
const int uc_Op_UnaryPlus = 44;
const int uc_Op_Percentage = 45;
const int uc_Op_StrConcat = 46;
const int uc_Op_Add_Int32 = 47;
const int uc_Op_Add = 48;
const int uc_Op_Add_Complex = 49;
const int uc_Op_Subtract_Int32 = 50;
const int uc_Op_Subtract = 51;
const int uc_Op_Multiply_Int32 = 52;
const int uc_Op_Multiply = 53;
const int uc_Op_Multiply_Complex = 54;
const int uc_Op_Divide_Int32 = 55;
const int uc_Op_Divide = 56;
const int uc_Op_Mod_Int32 = 57;
const int uc_Op_Mod = 58;
const int uc_Op_PowerOf_ExtToExt = 59;
const int uc_Op_PowerOf_ExtToLng = 60;
const int uc_Op_PowerOf_CplxToCplx = 61;

const int uc_Op_GreaterThan = 62;
const int uc_Op_GreaterOrEqual = 63;
const int uc_Op_LessThan = 64;
const int uc_Op_LessOrEqual = 65;
const int uc_Op_Equal = 66;
const int uc_Op_NotEqual = 67;

const int uc_Op_GreaterThan_Str = 68;
const int uc_Op_GreaterOrEqual_Str = 69;
const int uc_Op_LessThan_Str = 70;
const int uc_Op_LessOrEqual_Str = 71;
const int uc_Op_Equal_Str = 72;
const int uc_Op_NotEqual_Str = 73;

const int uc_Op_Not_Int32 = 74;
const int uc_Op_And_Int32 = 75;
const int uc_Op_Or_Int32 = 76;
const int uc_Op_Xor_Int32 = 77;
const int uc_Op_Eqv_Int32 = 78;
const int uc_Op_Imp_Int32 = 79;

const int uc_Op_AndAlso = 80;
const int uc_Op_OrElse = 81;

const int uc_Op_Factorial = 82;

const int uc_Func_IIf = 83;
const int uc_Func_IIf_Str = 84;

const int uc_Func_Sin = 85;
const int uc_Func_Cos = 86;
const int uc_Func_Tan = 87;
const int uc_Func_Atan = 88;
const int uc_Func_Ceil = 89;
const int uc_Func_Abs = 90;
const int uc_Func_Abs_Int32 = 91;
const int uc_Func_Exp = 92;
const int uc_Func_Log = 93;
const int uc_Func_Floor = 94;
const int uc_Func_SquareRoot = 95;
const int uc_Func_BaseConvert = 96;

const int uc_Func_ExprHandle = 97;
const int uc_Func_VarPtr = 98;
const int uc_Func_uCalc = 99;
const int uc_Func_uCalcStr = 100;
const int uc_Func_ucAddr = 101;
const int uc_Func_ValueAtAddr = 102;
const int uc_Func_SpecialArg = 103;
const int uc_Op_StringMult = 104;

const int uc_Func_For = 105;
const int uc_Func_Loop = 107;

const int uc_Func_LoadLibrary = 108;
const int uc_Func_GetProcAddress = 109;

const int uc_NullString = 110;
const int uc_True = 111;

const int uc_Func_Peek = 112;
const int uc_Func_Poke = 113;

const int uc_Func_Int = 115;
const int uc_Func_Frac = 116;
const int uc_Func_Sgn = 117;

const int uc_Func_PushData_Stack = 120;
// const int uc_Func_PopHandle_Stack = 121;
const int uc_Func_PopNum_Stack = 122;
const int uc_Func_PopStr_Stack = 123;
const int uc_Func_ReadHandle_Stack = 124;
const int uc_Func_ReadNum_Stack = 125;
const int uc_Func_ReadStr_Stack = 126;
const int uc_Func_Count_Stack = 127;
const int uc_Op_Concat_Stack = 128;
const int uc_Func_Populate_Stack = 129;

const int uc_Insert_Table = 130;
const int uc_Delete_Table = 131;
const int uc_Index_Table = 132;
const int uc_Handle_Table = 133;
const int uc_HandleB_Table = 134;
const int uc_ReadData_Table = 135;
const int uc_ReadNum_Table = 136;

const int uc_Func_Min = 137;
const int uc_Func_Max = 138;
const int uc_Func_Min_Str = 139;
const int uc_Func_Max_Str = 140;

const int uc_SetVariableValue = 141;
const int uc_SetVariableValueAnyType = 141;
const int uc_SetVariableValueLong = 142;
const int uc_SetVariableValueDouble = 143;
const int uc_SetVariableValueExtended = 144;
const int uc_ResetVariable = 145;

// Misc other callbacks
const int uc_EvaluateAddr = 150;
const int uc_EvaluateTurboAddr = 151;
const int uc_ExceptionHelper = 152;
const int uc_DefaultErrorHandler = 153;
const int uc_Raise_Error = 154;
const int uc_Func_IsIncomplete = 155;

const int uc_ScriptTimerStart = 160;
const int uc_LoadTimeTix = 161;

const int uc_Op_Ext_Plus_Complex = 190;
const int uc_Op_Ext_Times_Complex = 191;

const int uc_Func_If_ElseIf = 195;
const int uc_Func_SetSyntaxParams = 196;
const int uc_Func_SpecialUCase = 197;
const int uc_Func_Rand = 198;
const int uc_Func_GetmatchArg = 199;
const int uc_Func_PatternNum = 200;
const int uc_Func_PatternStr = 201;

const int uc_Convert_Stack_Table = 220;
const int uc_Convert_Stack_SortedList = 221;
const int uc_Convert_Table_Stack = 222;
const int uc_Convert_SortedList_Stack = 223;

const int uc_Expand_List = 1;
const int uc_Expand_StackPtr = 2;

const int uc_HandleToken = 21;

// Trig Mode
const int uc_ReturnTrigMode = 0;
const int uc_Radians = 1;
const int uc_Degrees = 2;
const int uc_Grad = 3;

// Misc
const int ucTrue = 1;
const int ucFalse = 0;
const int uc_Rank_First = 1;
const int uc_Rank_Last = -1;

// Pattern options
const int uc_Pattern_ArgCount = 1;
const int uc_Pattern_ArgIndex = 2;
const int uc_Pattern_ArgLength = 3;
const int uc_Pattern_ArgLocation = 4;
const int uc_Pattern_ArgText = 5;
const int uc_Pattern_DocumentLength = 6;
const int uc_Pattern_DocumentText = 7;
const int uc_Pattern_CriteriaCount = 8;
const int uc_Pattern_CriteriaIndex = 9;
const int uc_Pattern_MatchLength = 10;
const int uc_Pattern_MatchLocation = 11;
const int uc_Pattern_MatchText = 12;
const int uc_Pattern_MatchTally = 13;
const int uc_Pattern_SkipTally = 14;

// String Library
const int uc_StringLibNum = 230;
const int uc_StringLibStr = 231;
const int ucs_SetStringDefaults = 4;
const int ucs_Start = 5;
const int ucs_Limit = 6;
const int ucs_StartAfter = 7;
const int ucs_StopAfter = 8;
const int ucs_Between = 9;
const int ucs_Nth = 10;
const int ucs_File = 11;
const int ucs_Pos = 12;
const int ucs_Length = 13;
const int ucs_Text = 14;
const int ucs_Count = 15;
const int ucs_CountSkipped = 16;
const int ucs_InStr = 17;
const int ucs_Tally = 18;
const int ucs_UCase = 19;
const int ucs_LCase = 20;
const int ucs_MCase = 21;
const int ucs_Replace = 22;
const int ucs_Remove = 23;
const int ucs_Mid = 24;
const int ucs_Left = 25;
const int ucs_Right = 26;
const int ucs_Len = 27;
const int ucs_Extract = 28;
const int ucs_Remain = 29;
const int ucs_Skip = 30;
const int ucs_Delim = 31;
const int ucs_Retain = 32;
const int ucs_Range = 33;
const int ucs_Compare = 34;
const int ucs_Equals = 35;
const int ucs_Split = 36;
const int ucs_StringItem = 37;
const int ucs_StringItemCount = 38;

// String Libarary Options
const int ucByte = 1;
const int ucChar = 2;
const int ucWord = 4;
const int ucToken = 8;
const int ucBlock = 16;
const int ucExpr = 32;
const int ucQuote = 64;
const int ucSpace = 128;
const int ucCase = 256;
// End Of String Library Options

// Main Functions

int ucInit = 0;
int uCalcInit();
typedef int (CALLBACK* __ucAddr)(int AddressIndex ); extern __ucAddr _ucAddr_; __ucAddr _ucAddr_;
typedef int (CALLBACK* __uCalc)(int ucCommand, BSTR& TextIn, int a, int b, int c, int t  ); extern __uCalc _uCalc_; __uCalc _uCalc_;
typedef int (CALLBACK* __ExceptionHelper)(int Expr, int SystemError ); extern __ExceptionHelper _ExceptionHelper_; __ExceptionHelper _ExceptionHelper_;
typedef double (CALLBACK* __ucEvaluate)(int Item ); extern __ucEvaluate _ucEvaluate_; __ucEvaluate _ucEvaluate_;
typedef int (CALLBACK* __ucArgLng)(int Expr, int index ); extern __ucArgLng _ucArgLng_; __ucArgLng _ucArgLng_;
typedef double (CALLBACK* __ucArg)(int Expr, int index ); extern __ucArg _ucArg_; __ucArg _ucArg_;
typedef void (CALLBACK* __ucArgStr)(BSTR& ReturnStr, int Expr, int index ); extern __ucArgStr _ucArgStr_; __ucArgStr _ucArgStr_;
typedef int (CALLBACK* __ucArgHandle)(int Expr, int index ); extern __ucArgHandle _ucArgHandle_; __ucArgHandle _ucArgHandle_;
typedef int (CALLBACK* __ucArgCount)(int Expr ); extern __ucArgCount _ucArgCount_; __ucArgCount _ucArgCount_;
typedef void (CALLBACK* __ucReturnLng)(int Expr, int ReturnValue ); extern __ucReturnLng _ucReturnLng_; __ucReturnLng _ucReturnLng_;
typedef void (CALLBACK* __ucReturn)(int Expr, double ReturnValue ); extern __ucReturn _ucReturn_; __ucReturn _ucReturn_;
typedef void (CALLBACK* __ucReturnStr)(int Expr, BSTR& ReturnValue ); extern __ucReturnStr _ucReturnStr_; __ucReturnStr _ucReturnStr_;
typedef double (CALLBACK* __ucGetVariableValue)(int Item ); extern __ucGetVariableValue _ucGetVariableValue_; __ucGetVariableValue _ucGetVariableValue_;
typedef int (CALLBACK* __ucGetVariableValueLng)(int Item ); extern __ucGetVariableValueLng _ucGetVariableValueLng_; __ucGetVariableValueLng _ucGetVariableValueLng_;
typedef void (CALLBACK* __ucGetVariableValueStr)(BSTR& ReturnStr, int Item ); extern __ucGetVariableValueStr _ucGetVariableValueStr_; __ucGetVariableValueStr _ucGetVariableValueStr_;
typedef void (CALLBACK* __ucSetVariableValueLng)(int Item, int NewValue ); extern __ucSetVariableValueLng _ucSetVariableValueLng_; __ucSetVariableValueLng _ucSetVariableValueLng_;
typedef void (CALLBACK* __ucSetVariableValue)(int Item, double NewValue ); extern __ucSetVariableValue _ucSetVariableValue_; __ucSetVariableValue _ucSetVariableValue_;
typedef void (CALLBACK* __ucSetVariableValueStr)(int Item, BSTR& NewValue ); extern __ucSetVariableValueStr _ucSetVariableValueStr_; __ucSetVariableValueStr _ucSetVariableValueStr_;
typedef int (CALLBACK* __ucExprThread)(int Expr ); extern __ucExprThread _ucExprThread_; __ucExprThread _ucExprThread_;
typedef int (CALLBACK* __ucLicense)(int Product, DWORD L1, DWORD L2, DWORD L3, DWORD L4, DWORD L5  ); extern __ucLicense _ucLicense_; __ucLicense _ucLicense_;
typedef void (CALLBACK* __uCalcStr)(BSTR& ReturnStr, int ucCommand, BSTR& TextIn, int a, int b, int c, int t  ); extern __uCalcStr _uCalcStr_; __uCalcStr _uCalcStr_;
typedef int (CALLBACK* __ucClose32bitDLL)(int ReserverdArg ); extern __ucClose32bitDLL _ucClose32bitDLL_; __ucClose32bitDLL _ucClose32bitDLL_;
typedef int (CALLBACK* __ucDefine)(BSTR& Definition, int Arg1, int Arg2, int Arg3, int t  ); extern __ucDefine _ucDefine_; __ucDefine _ucDefine_;
typedef int (CALLBACK* __ucDefineConstant)(BSTR& Definition, int t  ); extern __ucDefineConstant _ucDefineConstant_; __ucDefineConstant _ucDefineConstant_;
typedef int (CALLBACK* __ucDefineFunction)(BSTR& Definition, void *FunctionAddress, int t  ); extern __ucDefineFunction _ucDefineFunction_; __ucDefineFunction _ucDefineFunction_;
typedef int (CALLBACK* __ucDefineOperator)(BSTR& Definition, void *FunctionAddress, int t  ); extern __ucDefineOperator _ucDefineOperator_; __ucDefineOperator _ucDefineOperator_;
typedef int (CALLBACK* __ucDefineSyntax)(BSTR& Definition, int Rank, int t  ); extern __ucDefineSyntax _ucDefineSyntax_; __ucDefineSyntax _ucDefineSyntax_;
typedef int (CALLBACK* __ucDefineVariable)(BSTR& Definition, void *VarAddress, int t  ); extern __ucDefineVariable _ucDefineVariable_; __ucDefineVariable _ucDefineVariable_;
typedef double (CALLBACK* __ucEval)(BSTR& Expr, int t  ); extern __ucEval _ucEval_; __ucEval _ucEval_;
typedef void (CALLBACK* __ucEvalStr)(BSTR& ReturnStr, BSTR& Expr, int ExprType, int t  ); extern __ucEvalStr _ucEvalStr_; __ucEvalStr _ucEvalStr_;
typedef void (CALLBACK* __ucEvaluateStr)(BSTR& ReturnStr, int ucItem ); extern __ucEvaluateStr _ucEvaluateStr_; __ucEvaluateStr _ucEvaluateStr_;
typedef void (CALLBACK* __ucExpand)(BSTR& ReturnStr, BSTR& Expr, int t  ); extern __ucExpand _ucExpand_; __ucExpand _ucExpand_;
typedef int (CALLBACK* __ucFPU)(int FPU_Command, int FPU_Option  ); extern __ucFPU _ucFPU_; __ucFPU _ucFPU_;
typedef int (CALLBACK* __ucGetTrigMode)(); extern __ucGetTrigMode _ucGetTrigMode_; __ucGetTrigMode _ucGetTrigMode_;
typedef int (CALLBACK* __ucInitialize)(int NewThread  ); extern __ucInitialize _ucInitialize_; __ucInitialize _ucInitialize_;
typedef int (CALLBACK* __ucNewThread)(int ParentThread, int MakeThisDefault  ); extern __ucNewThread _ucNewThread_; __ucNewThread _ucNewThread_;
typedef int (CALLBACK* __ucParse)(BSTR& Expr, int ExprType, int t  ); extern __ucParse _ucParse_; __ucParse _ucParse_;
typedef int (CALLBACK* __ucReleaseItem)(int ucItem ); extern __ucReleaseItem _ucReleaseItem_; __ucReleaseItem _ucReleaseItem_;
typedef void (CALLBACK* __ucRun)(BSTR& ReturnStr, BSTR& RunOption, BSTR& TextIn, int ExpandCount, int t  ); extern __ucRun _ucRun_; __ucRun _ucRun_;
typedef int (CALLBACK* __ucSetOutput)(void *FunctionAddress, BSTR& FuncName, BSTR& DataType, int t  ); extern __ucSetOutput _ucSetOutput_; __ucSetOutput _ucSetOutput_;
typedef int (CALLBACK* __ucSetTrigMode)(int TrigMode ); extern __ucSetTrigMode _ucSetTrigMode_; __ucSetTrigMode _ucSetTrigMode_;
typedef int (CALLBACK* __ucAddErrorHandler)(void *ErrorHandlerAddress, int t  ); extern __ucAddErrorHandler _ucAddErrorHandler_; __ucAddErrorHandler _ucAddErrorHandler_;
typedef int (CALLBACK* __ucError)(int t  ); extern __ucError _ucError_; __ucError _ucError_;
typedef void (CALLBACK* __ucErrorMessage)(BSTR& ReturnStr, int ErrorNumber, int t  ); extern __ucErrorMessage _ucErrorMessage_; __ucErrorMessage _ucErrorMessage_;
typedef void (CALLBACK* __ucErrorExpression)(BSTR& ReturnStr, int t  ); extern __ucErrorExpression _ucErrorExpression_; __ucErrorExpression _ucErrorExpression_;
typedef int (CALLBACK* __ucErrorLocation)(int t ); extern __ucErrorLocation _ucErrorLocation_; __ucErrorLocation _ucErrorLocation_;
typedef void (CALLBACK* __ucErrorSymbol)(BSTR& ReturnStr, int t ); extern __ucErrorSymbol _ucErrorSymbol_; __ucErrorSymbol _ucErrorSymbol_;
typedef int (CALLBACK* __ucRaiseError)(int Expr, int ErrorNumber ); extern __ucRaiseError _ucRaiseError_; __ucRaiseError _ucRaiseError_;
typedef int (CALLBACK* __ucRaiseErrorMessage)(int Expr, BSTR& ErrorMessage ); extern __ucRaiseErrorMessage _ucRaiseErrorMessage_; __ucRaiseErrorMessage _ucRaiseErrorMessage_;
typedef int (CALLBACK* __ucSetError)(int ErrorNumber, int t  ); extern __ucSetError _ucSetError_; __ucSetError _ucSetError_;
typedef int (CALLBACK* __ucSetErrorMessage)(int ErrorIndex, BSTR& ErrorMessage, int t  ); extern __ucSetErrorMessage _ucSetErrorMessage_; __ucSetErrorMessage _ucSetErrorMessage_;
typedef int (CALLBACK* __ucSetErrorNumber)(int ErrorNumber, int t  ); extern __ucSetErrorNumber _ucSetErrorNumber_; __ucSetErrorNumber _ucSetErrorNumber_;
typedef int (CALLBACK* __ucLoadStringLibInFMP)(int tHandle  ); extern __ucLoadStringLibInFMP _ucLoadStringLibInFMP_; __ucLoadStringLibInFMP _ucLoadStringLibInFMP_;
typedef int (CALLBACK* __ucBetween)(int a, int b ); extern __ucBetween _ucBetween_; __ucBetween _ucBetween_;
typedef int (CALLBACK* __ucCompare)(BSTR& String1, BSTR& String2, int Options  ); extern __ucCompare _ucCompare_; __ucCompare _ucCompare_;
typedef int (CALLBACK* __ucCount)(); extern __ucCount _ucCount_; __ucCount _ucCount_;
typedef int (CALLBACK* __ucCountSkipped)(); extern __ucCountSkipped _ucCountSkipped_; __ucCountSkipped _ucCountSkipped_;
typedef int (CALLBACK* __ucDelim)(BSTR& Delim, BSTR& L, BSTR& R  ); extern __ucDelim _ucDelim_; __ucDelim _ucDelim_;
typedef int (CALLBACK* __ucEquals)(BSTR& String1, BSTR& String2, int Options  ); extern __ucEquals _ucEquals_; __ucEquals _ucEquals_;
typedef int (CALLBACK* __ucInStr)(int Start, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucInStr _ucInStr_; __ucInStr _ucInStr_;
typedef int (CALLBACK* __ucLen)(BSTR& MainString, int Options  ); extern __ucLen _ucLen_; __ucLen _ucLen_;
typedef int (CALLBACK* __ucLength)(int x  ); extern __ucLength _ucLength_; __ucLength _ucLength_;
typedef int (CALLBACK* __ucLimit)(int Limit ); extern __ucLimit _ucLimit_; __ucLimit _ucLimit_;
typedef int (CALLBACK* __ucNth)(int Number ); extern __ucNth _ucNth_; __ucNth _ucNth_;
typedef int (CALLBACK* __ucPos)(int x  ); extern __ucPos _ucPos_; __ucPos _ucPos_;
typedef int (CALLBACK* __ucSetStringDefaults)(int Options ); extern __ucSetStringDefaults _ucSetStringDefaults_; __ucSetStringDefaults _ucSetStringDefaults_;
typedef int (CALLBACK* __ucSkip)(BSTR& MainString ); extern __ucSkip _ucSkip_; __ucSkip _ucSkip_;
typedef int (CALLBACK* __ucSplit)(BSTR& MainString, BSTR& Delim, int Options  ); extern __ucSplit _ucSplit_; __ucSplit _ucSplit_;
typedef int (CALLBACK* __ucStart)(int Position ); extern __ucStart _ucStart_; __ucStart _ucStart_;
typedef int (CALLBACK* __ucStartAfter)(int Number ); extern __ucStartAfter _ucStartAfter_; __ucStartAfter _ucStartAfter_;
typedef int (CALLBACK* __ucStopAfter)(int Number ); extern __ucStopAfter _ucStopAfter_; __ucStopAfter _ucStopAfter_;
typedef int (CALLBACK* __ucStringItemCount)(); extern __ucStringItemCount _ucStringItemCount_; __ucStringItemCount _ucStringItemCount_;
typedef int (CALLBACK* __ucTally)(BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucTally _ucTally_; __ucTally _ucTally_;
typedef void (CALLBACK* __ucExtract)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucExtract _ucExtract_; __ucExtract _ucExtract_;
typedef void (CALLBACK* __ucFile)(BSTR& ReturnStr, BSTR& NameOfFile ); extern __ucFile _ucFile_; __ucFile _ucFile_;
typedef void (CALLBACK* __ucLCase)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucLCase _ucLCase_; __ucLCase _ucLCase_;
typedef void (CALLBACK* __ucLeft)(BSTR& ReturnStr, BSTR& MainString, int Number, int Options  ); extern __ucLeft _ucLeft_; __ucLeft _ucLeft_;
typedef void (CALLBACK* __ucMCase)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucMCase _ucMCase_; __ucMCase _ucMCase_;
typedef void (CALLBACK* __ucMid)(BSTR& ReturnStr, BSTR& MainString, int Start, int Length, int Options  ); extern __ucMid _ucMid_; __ucMid _ucMid_;
typedef void (CALLBACK* __ucRange)(BSTR& ReturnStr, int Start, int Finish, BSTR& Expression, int Options  ); extern __ucRange _ucRange_; __ucRange _ucRange_;
typedef void (CALLBACK* __ucRemain)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucRemain _ucRemain_; __ucRemain _ucRemain_;
typedef void (CALLBACK* __ucRemove)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucRemove _ucRemove_; __ucRemove _ucRemove_;
typedef void (CALLBACK* __ucReplace)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, BSTR& Replacement, int Options  ); extern __ucReplace _ucReplace_; __ucReplace _ucReplace_;
typedef void (CALLBACK* __ucRetain)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, BSTR& Filter, int Options  ); extern __ucRetain _ucRetain_; __ucRetain _ucRetain_;
typedef void (CALLBACK* __ucRight)(BSTR& ReturnStr, BSTR& MainString, int Number, int Options  ); extern __ucRight _ucRight_; __ucRight _ucRight_;
typedef void (CALLBACK* __ucStringItem)(BSTR& ReturnStr, int Index ); extern __ucStringItem _ucStringItem_; __ucStringItem _ucStringItem_;
typedef void (CALLBACK* __ucUCase)(BSTR& ReturnStr, BSTR& MainString, BSTR& Pattern, int Options  ); extern __ucUCase _ucUCase_; __ucUCase _ucUCase_;
typedef int (CALLBACK* __uCalcRaw)(BSTR& ReturnStr_, int uc, BSTR& TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle ); extern __uCalcRaw _uCalcRaw_; __uCalcRaw _uCalcRaw_;

int ucAddr(int AddressIndex ) {
   if(ucInit==0) uCalcInit();
   return _ucAddr_( AddressIndex );
}

int uCalc(int ucCommand, string TextIn = "", int a  = 0, int b  = 0, int c  = 0, int t  = 0) {
   BSTR TextIn_ = SysAllocStringByteLen(TextIn.c_str(), TextIn.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _uCalc_( ucCommand, TextIn_, a, b, c, t  );
   SysFreeString(TextIn_);
   return RetVal;
}

int ExceptionHelper(int Expr, int SystemError ) {
   if(ucInit==0) uCalcInit();
   return _ExceptionHelper_( Expr, SystemError );
}

double ucEvaluate(int Item ) {
   if(ucInit==0) uCalcInit();
   return _ucEvaluate_( Item );
}

int ucArgLng(int Expr, int index ) {
   if(ucInit==0) uCalcInit();
   return _ucArgLng_( Expr, index );
}

double ucArg(int Expr, int index ) {
   if(ucInit==0) uCalcInit();
   return _ucArg_( Expr, index );
}

string ucArgStr(int Expr, int index) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucArgStr_(ReturnStr_, Expr, index );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucArgHandle(int Expr, int index ) {
   if(ucInit==0) uCalcInit();
   return _ucArgHandle_( Expr, index );
}

int ucArgCount(int Expr ) {
   if(ucInit==0) uCalcInit();
   return _ucArgCount_( Expr );
}

void ucReturnLng(int Expr, int ReturnValue ) {
   if(ucInit==0) uCalcInit();
   _ucReturnLng_( Expr, ReturnValue );
}

void ucReturn(int Expr, double ReturnValue ) {
   if(ucInit==0) uCalcInit();
   _ucReturn_( Expr, ReturnValue );
}

void ucReturnStr(int Expr, string ReturnValue ) {
   BSTR ReturnValue_ = SysAllocStringByteLen(ReturnValue.c_str(), ReturnValue.length());
   if(ucInit==0) uCalcInit();
   _ucReturnStr_( Expr, ReturnValue_ );
   SysFreeString(ReturnValue_);
}

double ucGetVariableValue(int Item ) {
   if(ucInit==0) uCalcInit();
   return _ucGetVariableValue_( Item );
}

int ucGetVariableValueLng(int Item ) {
   if(ucInit==0) uCalcInit();
   return _ucGetVariableValueLng_( Item );
}

string ucGetVariableValueStr(int Item) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucGetVariableValueStr_(ReturnStr_, Item );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

void ucSetVariableValueLng(int Item, int NewValue ) {
   if(ucInit==0) uCalcInit();
   _ucSetVariableValueLng_( Item, NewValue );
}

void ucSetVariableValue(int Item, double NewValue ) {
   if(ucInit==0) uCalcInit();
   _ucSetVariableValue_( Item, NewValue );
}

void ucSetVariableValueStr(int Item, string NewValue ) {
   BSTR NewValue_ = SysAllocStringByteLen(NewValue.c_str(), NewValue.length());
   if(ucInit==0) uCalcInit();
   _ucSetVariableValueStr_( Item, NewValue_ );
   SysFreeString(NewValue_);
}

int ucExprThread(int Expr ) {
   if(ucInit==0) uCalcInit();
   return _ucExprThread_( Expr );
}

int ucLicense(int Product, DWORD L1  = 0, DWORD L2  = 0, DWORD L3  = 0, DWORD L4  = 0, DWORD L5  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLicense_( Product, L1, L2, L3, L4, L5  );
}

string uCalcStr(int ucCommand, string TextIn = "", int a  = 0, int b  = 0, int c  = 0, int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR TextIn_ = SysAllocStringByteLen(TextIn.c_str(), TextIn.length());
   if(ucInit==0) uCalcInit();
   _uCalcStr_(ReturnStr_, ucCommand, TextIn_, a, b, c, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(TextIn_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucClose32bitDLL(int ReserverdArg ) {
   if(ucInit==0) uCalcInit();
   return _ucClose32bitDLL_( ReserverdArg );
}

int ucDefine(string Definition, int Arg1  = 0, int Arg2  = 0, int Arg3  = 0, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefine_(Definition_, Arg1, Arg2, Arg3, t  );
   SysFreeString(Definition_);
   return RetVal;
}

int ucDefineConstant(string Definition, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefineConstant_(Definition_, t  );
   SysFreeString(Definition_);
   return RetVal;
}

int ucDefineFunction(string Definition, void *FunctionAddress = 0, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefineFunction_(Definition_, FunctionAddress, t  );
   SysFreeString(Definition_);
   return RetVal;
}

int ucDefineOperator(string Definition, void *FunctionAddress = 0, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefineOperator_(Definition_, FunctionAddress, t  );
   SysFreeString(Definition_);
   return RetVal;
}

int ucDefineSyntax(string Definition, int Rank  = 0, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefineSyntax_(Definition_, Rank, t  );
   SysFreeString(Definition_);
   return RetVal;
}

int ucDefineVariable(string Definition, void *VarAddress = 0, int t  = 0) {
   BSTR Definition_ = SysAllocStringByteLen(Definition.c_str(), Definition.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDefineVariable_(Definition_, VarAddress, t  );
   SysFreeString(Definition_);
   return RetVal;
}

double ucEval(string Expr, int t  = 0) {
   BSTR Expr_ = SysAllocStringByteLen(Expr.c_str(), Expr.length());
   if(ucInit==0) uCalcInit();
   double RetVal = _ucEval_(Expr_, t  );
   SysFreeString(Expr_);
   return RetVal;
}

string ucEvalStr(string Expr, int ExprType  = 0, int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Expr_ = SysAllocStringByteLen(Expr.c_str(), Expr.length());
   if(ucInit==0) uCalcInit();
   _ucEvalStr_(ReturnStr_, Expr_, ExprType, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(Expr_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucEvaluateStr(int ucItem) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucEvaluateStr_(ReturnStr_, ucItem );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucExpand(string Expr, int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Expr_ = SysAllocStringByteLen(Expr.c_str(), Expr.length());
   if(ucInit==0) uCalcInit();
   _ucExpand_(ReturnStr_, Expr_, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(Expr_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucFPU(int FPU_Command, int FPU_Option  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucFPU_( FPU_Command, FPU_Option  );
}

int ucGetTrigMode() {
   if(ucInit==0) uCalcInit();
   return _ucGetTrigMode_();
}

int ucInitialize(int NewThread  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucInitialize_( NewThread  );
}

int ucNewThread(int ParentThread  = 0, int MakeThisDefault  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucNewThread_( ParentThread, MakeThisDefault  );
}

int ucParse(string Expr, int ExprType  = 0, int t  = 0) {
   BSTR Expr_ = SysAllocStringByteLen(Expr.c_str(), Expr.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucParse_(Expr_, ExprType, t  );
   SysFreeString(Expr_);
   return RetVal;
}

int ucReleaseItem(int ucItem ) {
   if(ucInit==0) uCalcInit();
   return _ucReleaseItem_( ucItem );
}

string ucRun(string RunOption, string TextIn, int ExpandCount  = 0, int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR TextIn_ = SysAllocStringByteLen(TextIn.c_str(), TextIn.length());
   BSTR RunOption_ = SysAllocStringByteLen(RunOption.c_str(), RunOption.length());
   if(ucInit==0) uCalcInit();
   _ucRun_(ReturnStr_, RunOption_, TextIn_, ExpandCount, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(RunOption_);
   SysFreeString(TextIn_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucSetOutput(void *FunctionAddress = 0, string FuncName = "", string DataType = "", int t  = 0) {
   BSTR DataType_ = SysAllocStringByteLen(DataType.c_str(), DataType.length());
   BSTR FuncName_ = SysAllocStringByteLen(FuncName.c_str(), FuncName.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucSetOutput_(FunctionAddress, FuncName_, DataType_, t  );
   SysFreeString(FuncName_);
   SysFreeString(DataType_);
   return RetVal;
}

int ucSetTrigMode(int TrigMode ) {
   if(ucInit==0) uCalcInit();
   return _ucSetTrigMode_( TrigMode );
}

int ucAddErrorHandler(void *ErrorHandlerAddress = 0, int t  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucAddErrorHandler_(ErrorHandlerAddress, t  );
}

int ucError(int t  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucError_( t  );
}

string ucErrorMessage(int ErrorNumber  = 0, int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorMessage_(ReturnStr_, ErrorNumber, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucErrorExpression(int t  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorExpression_(ReturnStr_, t  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucErrorLocation(int t ) {
   if(ucInit==0) uCalcInit();
   return _ucErrorLocation_( t );
}

string ucErrorSymbol(int t) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucErrorSymbol_(ReturnStr_, t );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int ucRaiseError(int Expr, int ErrorNumber ) {
   if(ucInit==0) uCalcInit();
   return _ucRaiseError_( Expr, ErrorNumber );
}

int ucRaiseErrorMessage(int Expr, string ErrorMessage) {
   BSTR ErrorMessage_ = SysAllocStringByteLen(ErrorMessage.c_str(), ErrorMessage.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucRaiseErrorMessage_( Expr, ErrorMessage_ );
   SysFreeString(ErrorMessage_);
   return RetVal;
}

int ucSetError(int ErrorNumber, int t  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetError_( ErrorNumber, t  );
}

int ucSetErrorMessage(int ErrorIndex, string ErrorMessage, int t  = 0) {
   BSTR ErrorMessage_ = SysAllocStringByteLen(ErrorMessage.c_str(), ErrorMessage.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucSetErrorMessage_( ErrorIndex, ErrorMessage_, t  );
   SysFreeString(ErrorMessage_);
   return RetVal;
}

int ucSetErrorNumber(int ErrorNumber, int t  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucSetErrorNumber_( ErrorNumber, t  );
}

int ucLoadStringLibInFMP(int tHandle  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLoadStringLibInFMP_( tHandle  );
}

int ucBetween(int a, int b ) {
   if(ucInit==0) uCalcInit();
   return _ucBetween_( a, b );
}

int ucCompare(string String1, string String2, int Options  = 0) {
   BSTR String1_ = SysAllocStringByteLen(String1.c_str(), String1.length());
   BSTR String2_ = SysAllocStringByteLen(String2.c_str(), String2.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucCompare_(String1_, String2_, Options  );
   SysFreeString(String2_);
   SysFreeString(String1_);
   return RetVal;
}

int ucCount() {
   if(ucInit==0) uCalcInit();
   return _ucCount_();
}

int ucCountSkipped() {
   if(ucInit==0) uCalcInit();
   return _ucCountSkipped_();
}

int ucDelim(string Delim, string L = "", string R = "") {
   BSTR Delim_ = SysAllocStringByteLen(Delim.c_str(), Delim.length());
   BSTR R_ = SysAllocStringByteLen(R.c_str(), R.length());
   BSTR L_ = SysAllocStringByteLen(L.c_str(), L.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucDelim_(Delim_, L_, R_  );
   SysFreeString(L_);
   SysFreeString(R_);
   SysFreeString(Delim_);
   return RetVal;
}

int ucEquals(string String1, string String2, int Options  = 0) {
   BSTR String1_ = SysAllocStringByteLen(String1.c_str(), String1.length());
   BSTR String2_ = SysAllocStringByteLen(String2.c_str(), String2.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucEquals_(String1_, String2_, Options  );
   SysFreeString(String2_);
   SysFreeString(String1_);
   return RetVal;
}

int ucInStr(int Start, string MainString, string Pattern, int Options  = 0) {
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucInStr_( Start, MainString_, Pattern_, Options  );
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   return RetVal;
}

int ucLen(string MainString, int Options  = 0) {
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucLen_(MainString_, Options  );
   SysFreeString(MainString_);
   return RetVal;
}

int ucLength(int x  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucLength_( x  );
}

int ucLimit(int Limit ) {
   if(ucInit==0) uCalcInit();
   return _ucLimit_( Limit );
}

int ucNth(int Number ) {
   if(ucInit==0) uCalcInit();
   return _ucNth_( Number );
}

int ucPos(int x  = 0) {
   if(ucInit==0) uCalcInit();
   return _ucPos_( x  );
}

int ucSetStringDefaults(int Options ) {
   if(ucInit==0) uCalcInit();
   return _ucSetStringDefaults_( Options );
}

int ucSkip(string MainString) {
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucSkip_(MainString_ );
   SysFreeString(MainString_);
   return RetVal;
}

int ucSplit(string MainString, string Delim = "", int Options  = 0) {
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   BSTR Delim_ = SysAllocStringByteLen(Delim.c_str(), Delim.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucSplit_(MainString_, Delim_, Options  );
   SysFreeString(Delim_);
   SysFreeString(MainString_);
   return RetVal;
}

int ucStart(int Position ) {
   if(ucInit==0) uCalcInit();
   return _ucStart_( Position );
}

int ucStartAfter(int Number ) {
   if(ucInit==0) uCalcInit();
   return _ucStartAfter_( Number );
}

int ucStopAfter(int Number ) {
   if(ucInit==0) uCalcInit();
   return _ucStopAfter_( Number );
}

int ucStringItemCount() {
   if(ucInit==0) uCalcInit();
   return _ucStringItemCount_();
}

int ucTally(string MainString, string Pattern, int Options  = 0) {
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _ucTally_(MainString_, Pattern_, Options  );
   SysFreeString(Pattern_);
   SysFreeString(MainString_);
   return RetVal;
}

string ucExtract(string MainString, string Pattern, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucExtract_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucFile(string NameOfFile) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR NameOfFile_ = SysAllocStringByteLen(NameOfFile.c_str(), NameOfFile.length());
   if(ucInit==0) uCalcInit();
   _ucFile_(ReturnStr_, NameOfFile_ );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(NameOfFile_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucLCase(string MainString, string Pattern = "", int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucLCase_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucLeft(string MainString, int Number, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucLeft_(ReturnStr_, MainString_, Number, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucMCase(string MainString, string Pattern = "", int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucMCase_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucMid(string MainString, int Start, int Length  = 0, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucMid_(ReturnStr_, MainString_, Start, Length, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucRange(int Start, int Finish, string Expression, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Expression_ = SysAllocStringByteLen(Expression.c_str(), Expression.length());
   if(ucInit==0) uCalcInit();
   _ucRange_(ReturnStr_, Start, Finish, Expression_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(Expression_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucRemain(string MainString, string Pattern, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucRemain_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucRemove(string MainString, string Pattern, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucRemove_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucReplace(string MainString, string Pattern, string Replacement = "", int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Replacement_ = SysAllocStringByteLen(Replacement.c_str(), Replacement.length());
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucReplace_(ReturnStr_, MainString_, Pattern_, Replacement_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(Replacement_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucRetain(string MainString, string Pattern, string Filter = "", int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Filter_ = SysAllocStringByteLen(Filter.c_str(), Filter.length());
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucRetain_(ReturnStr_, MainString_, Pattern_, Filter_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(Filter_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucRight(string MainString, int Number, int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucRight_(ReturnStr_, MainString_, Number, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucStringItem(int Index) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   if(ucInit==0) uCalcInit();
   _ucStringItem_(ReturnStr_, Index );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

string ucUCase(string MainString, string Pattern = "", int Options  = 0) { 
   BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);
   BSTR Pattern_ = SysAllocStringByteLen(Pattern.c_str(), Pattern.length());
   BSTR MainString_ = SysAllocStringByteLen(MainString.c_str(), MainString.length());
   if(ucInit==0) uCalcInit();
   _ucUCase_(ReturnStr_, MainString_, Pattern_, Options  );
   string ReturnStr = (LPCSTR)ReturnStr_;
   SysFreeString(MainString_);
   SysFreeString(Pattern_);
   SysFreeString(ReturnStr_);
   return ReturnStr;
}

int uCalcRaw(string ReturnStr_, int uc, string TextIn, int Misc1, int Misc2, int ReturnPtr, int tHandle) {
   BSTR ReturnStr__ = SysAllocStringByteLen(ReturnStr_.c_str(), ReturnStr_.length());
   BSTR TextIn_ = SysAllocStringByteLen(TextIn.c_str(), TextIn.length());
   if(ucInit==0) uCalcInit();
   int RetVal = _uCalcRaw_(ReturnStr__, uc, TextIn_, Misc1, Misc2, ReturnPtr, tHandle );
   SysFreeString(TextIn_);
   SysFreeString(ReturnStr__);
   return RetVal;
}

int uCalcInit() {
   static HINSTANCE hDLL;
#ifdef UNICODE
   hDLL = LoadLibrary(_T("uCalc64v400.dll"));
#else
   hDLL = LoadLibraryA("uCalc64v400.dll");
#endif
   
   if (hDLL == NULL) return 0;
   ucInit = 1;   

   _ucAddr_ = (__ucAddr)GetProcAddress(hDLL, "ucAddr");
   _uCalc_ = (__uCalc)GetProcAddress(hDLL, "uCalc");
   _ExceptionHelper_ = (__ExceptionHelper)GetProcAddress(hDLL, "ExceptionHelper");
   _ucEvaluate_ = (__ucEvaluate)GetProcAddress(hDLL, "ucEvaluate");
   _ucArgLng_ = (__ucArgLng)GetProcAddress(hDLL, "ucArgLng");
   _ucArg_ = (__ucArg)GetProcAddress(hDLL, "ucArg");
   _ucArgStr_ = (__ucArgStr)GetProcAddress(hDLL, "ucArgStr");
   _ucArgHandle_ = (__ucArgHandle)GetProcAddress(hDLL, "ucArgHandle");
   _ucArgCount_ = (__ucArgCount)GetProcAddress(hDLL, "ucArgCount");
   _ucReturnLng_ = (__ucReturnLng)GetProcAddress(hDLL, "ucReturnLng");
   _ucReturn_ = (__ucReturn)GetProcAddress(hDLL, "ucReturnDbl");
   _ucReturnStr_ = (__ucReturnStr)GetProcAddress(hDLL, "ucReturnStr");
   _ucGetVariableValue_ = (__ucGetVariableValue)GetProcAddress(hDLL, "ucGetVariableValue");
   _ucGetVariableValueLng_ = (__ucGetVariableValueLng)GetProcAddress(hDLL, "ucGetVariableValueLng");
   _ucGetVariableValueStr_ = (__ucGetVariableValueStr)GetProcAddress(hDLL, "ucGetVariableValueStr");
   _ucSetVariableValueLng_ = (__ucSetVariableValueLng)GetProcAddress(hDLL, "ucSetVariableValueLng");
   _ucSetVariableValue_ = (__ucSetVariableValue)GetProcAddress(hDLL, "ucSetVariableValueDbl");
   _ucSetVariableValueStr_ = (__ucSetVariableValueStr)GetProcAddress(hDLL, "ucSetVariableValueStr");
   _ucExprThread_ = (__ucExprThread)GetProcAddress(hDLL, "ucExprThread");
   _ucLicense_ = (__ucLicense)GetProcAddress(hDLL, "ucLicense");
   _uCalcStr_ = (__uCalcStr)GetProcAddress(hDLL, "uCalcStr");
   _ucClose32bitDLL_ = (__ucClose32bitDLL)GetProcAddress(hDLL, "ucClose32bitDLL");
   _ucDefine_ = (__ucDefine)GetProcAddress(hDLL, "ucDefine");
   _ucDefineConstant_ = (__ucDefineConstant)GetProcAddress(hDLL, "ucDefineConstant");
   _ucDefineFunction_ = (__ucDefineFunction)GetProcAddress(hDLL, "ucDefineFunction");
   _ucDefineOperator_ = (__ucDefineOperator)GetProcAddress(hDLL, "ucDefineOperator");
   _ucDefineSyntax_ = (__ucDefineSyntax)GetProcAddress(hDLL, "ucDefineSyntax");
   _ucDefineVariable_ = (__ucDefineVariable)GetProcAddress(hDLL, "ucDefineVariable");
   _ucEval_ = (__ucEval)GetProcAddress(hDLL, "ucEval");
   _ucEvalStr_ = (__ucEvalStr)GetProcAddress(hDLL, "ucEvalStr");
   _ucEvaluateStr_ = (__ucEvaluateStr)GetProcAddress(hDLL, "ucEvaluateStr");
   _ucExpand_ = (__ucExpand)GetProcAddress(hDLL, "ucExpand");
   _ucFPU_ = (__ucFPU)GetProcAddress(hDLL, "ucFPU");
   _ucGetTrigMode_ = (__ucGetTrigMode)GetProcAddress(hDLL, "ucGetTrigMode");
   _ucInitialize_ = (__ucInitialize)GetProcAddress(hDLL, "ucInitialize");
   _ucNewThread_ = (__ucNewThread)GetProcAddress(hDLL, "ucNewThread");
   _ucParse_ = (__ucParse)GetProcAddress(hDLL, "ucParse");
   _ucReleaseItem_ = (__ucReleaseItem)GetProcAddress(hDLL, "ucReleaseItem");
   _ucRun_ = (__ucRun)GetProcAddress(hDLL, "ucRun");
   _ucSetOutput_ = (__ucSetOutput)GetProcAddress(hDLL, "ucSetOutput");
   _ucSetTrigMode_ = (__ucSetTrigMode)GetProcAddress(hDLL, "ucSetTrigMode");
   _ucAddErrorHandler_ = (__ucAddErrorHandler)GetProcAddress(hDLL, "ucAddErrorHandler");
   _ucError_ = (__ucError)GetProcAddress(hDLL, "ucError");
   _ucErrorMessage_ = (__ucErrorMessage)GetProcAddress(hDLL, "ucErrorMessage");
   _ucErrorExpression_ = (__ucErrorExpression)GetProcAddress(hDLL, "ucErrorExpression");
   _ucErrorLocation_ = (__ucErrorLocation)GetProcAddress(hDLL, "ucErrorLocation");
   _ucErrorSymbol_ = (__ucErrorSymbol)GetProcAddress(hDLL, "ucErrorSymbol");
   _ucRaiseError_ = (__ucRaiseError)GetProcAddress(hDLL, "ucRaiseError");
   _ucRaiseErrorMessage_ = (__ucRaiseErrorMessage)GetProcAddress(hDLL, "ucRaiseErrorMessage");
   _ucSetError_ = (__ucSetError)GetProcAddress(hDLL, "ucSetError");
   _ucSetErrorMessage_ = (__ucSetErrorMessage)GetProcAddress(hDLL, "ucSetErrorMessage");
   _ucSetErrorNumber_ = (__ucSetErrorNumber)GetProcAddress(hDLL, "ucSetErrorNumber");
   _ucLoadStringLibInFMP_ = (__ucLoadStringLibInFMP)GetProcAddress(hDLL, "ucLoadStringLibInFMP");
   _ucBetween_ = (__ucBetween)GetProcAddress(hDLL, "ucBetween");
   _ucCompare_ = (__ucCompare)GetProcAddress(hDLL, "ucCompare");
   _ucCount_ = (__ucCount)GetProcAddress(hDLL, "ucCount");
   _ucCountSkipped_ = (__ucCountSkipped)GetProcAddress(hDLL, "ucCountSkipped");
   _ucDelim_ = (__ucDelim)GetProcAddress(hDLL, "ucDelim");
   _ucEquals_ = (__ucEquals)GetProcAddress(hDLL, "ucEquals");
   _ucInStr_ = (__ucInStr)GetProcAddress(hDLL, "ucInStr");
   _ucLen_ = (__ucLen)GetProcAddress(hDLL, "ucLen");
   _ucLength_ = (__ucLength)GetProcAddress(hDLL, "ucLength");
   _ucLimit_ = (__ucLimit)GetProcAddress(hDLL, "ucLimit");
   _ucNth_ = (__ucNth)GetProcAddress(hDLL, "ucNth");
   _ucPos_ = (__ucPos)GetProcAddress(hDLL, "ucPos");
   _ucSetStringDefaults_ = (__ucSetStringDefaults)GetProcAddress(hDLL, "ucSetStringDefaults");
   _ucSkip_ = (__ucSkip)GetProcAddress(hDLL, "ucSkip");
   _ucSplit_ = (__ucSplit)GetProcAddress(hDLL, "ucSplit");
   _ucStart_ = (__ucStart)GetProcAddress(hDLL, "ucStart");
   _ucStartAfter_ = (__ucStartAfter)GetProcAddress(hDLL, "ucStartAfter");
   _ucStopAfter_ = (__ucStopAfter)GetProcAddress(hDLL, "ucStopAfter");
   _ucStringItemCount_ = (__ucStringItemCount)GetProcAddress(hDLL, "ucStringItemCount");
   _ucTally_ = (__ucTally)GetProcAddress(hDLL, "ucTally");
   _ucExtract_ = (__ucExtract)GetProcAddress(hDLL, "ucExtract");
   _ucFile_ = (__ucFile)GetProcAddress(hDLL, "ucFile");
   _ucLCase_ = (__ucLCase)GetProcAddress(hDLL, "ucLCase");
   _ucLeft_ = (__ucLeft)GetProcAddress(hDLL, "ucLeft");
   _ucMCase_ = (__ucMCase)GetProcAddress(hDLL, "ucMCase");
   _ucMid_ = (__ucMid)GetProcAddress(hDLL, "ucMid");
   _ucRange_ = (__ucRange)GetProcAddress(hDLL, "ucRange");
   _ucRemain_ = (__ucRemain)GetProcAddress(hDLL, "ucRemain");
   _ucRemove_ = (__ucRemove)GetProcAddress(hDLL, "ucRemove");
   _ucReplace_ = (__ucReplace)GetProcAddress(hDLL, "ucReplace");
   _ucRetain_ = (__ucRetain)GetProcAddress(hDLL, "ucRetain");
   _ucRight_ = (__ucRight)GetProcAddress(hDLL, "ucRight");
   _ucStringItem_ = (__ucStringItem)GetProcAddress(hDLL, "ucStringItem");
   _ucUCase_ = (__ucUCase)GetProcAddress(hDLL, "ucUCase");
   _uCalcRaw_ = (__uCalcRaw)GetProcAddress(hDLL, "uCalcRaw");
   return 1;
}