# CBuilder.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.8 on 2/27/2014 11:33:04 AM
# Comment: Transforms uCalc interface file to C++ Builder header file (uCalcCB.h)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to C++ Builder header file (uCalcCB.h)
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcCB.h
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Customize header comments and prepare function declarations
Pass: 1

Criteria: 2
BackColor: DodgerBlue
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
BackColor: Tomato
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
BackColor: Orange
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
BackColor: DeepSkyBlue
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
BackColor: DarkKhaki
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
BackColor: Yellow
Find: '
Replace: //

Criteria: 8
BackColor: Lime
Find: ' Main Functions
Replace: // Main Functions
         
         Int32 ucInit = 0;
         Int32 uCalcInit();
         // typedef
         
         // extern
         

Criteria: 9
BackColor: Red
Find: ' Interface.Bas {etc}
Replace: // {@Eval:OutputFile}: C++ Builder header file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 10
BackColor: Brown
Find: ' Designed for : {etc}
Replace: // Designed for : C++ Builder XE
         //                Add the following line to your code:
         //                #include "uCalcCB.h" in your code.

Criteria: 11
BackColor: RoyalBlue
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 12
BackColor: Pink
Find: ' VB.NET: {etc}
Replace: {Nothing}

Criteria: 13
BackColor: SlateBlue
Find: ' VB.NET: Public Module uCalcVBNET
Replace: #pragma once
         #include <windows.h>
         #include <oleauto.h>
         using namespace std;{nl}{nl}

Criteria: 14
BackColor: Purple
Find: %{const} = {value} [' {comment}]
Replace: const Int32 {const} = {value};

Criteria: 15
BackColor: Khaki
Find: ' VB.NET: End Module
Replace: Int32 uCalcInit()
            static HINSTANCE hDLL;
            hDLL = LoadLibraryA("{@Eval:DLLFile}");
            
            if (hDLL == NULL) return 0;
            ucInit = 1;   
            return 1;

Criteria: 16
BackColor: Green
PassOnce: False
Find: Function {name} Alias {q}{alias}{q} {args} Export As {type:1}
        {body~+}
      End Function
Replace: def: {type}, {alias}, {alias}, {args}

Criteria: 17
BackColor: SandyBrown
Find: Sub {name} Alias {q}{alias}{q} {args} Export
        {body~+}
      End Sub
Replace: def: void, {alias}, {alias}, {args}

Criteria: 18
BackColor: Violet
Find: ' Function {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: def: {type}, {alias}, {alias}, {args}

Criteria: 19
BackColor: YellowGreen
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 20
Selected: True
BackColor: CornflowerBlue
Find: ' Deprecated {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: // {Self}

Criteria: 21
BackColor: Gold
Find: ' Sub {name} Alias {q}{alias}{q} {args} Export
Replace: def: void, {alias}, {alias}, {args}

Criteria: 22
BackColor: Gold
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Ext Alias {q}{alias}{q} {args} Export
Replace: def: void, {name}, {alias}, {args}

Criteria: 23
Find: ' Sub {ucSetVariableValueDbl | ucReturnDbl} {etc}
Replace: {Nothing}

Criteria: 24
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
Replace: def: void, {alias}, {alias}, (ByRef ReturnStr As String, {args})

Criteria: 25
Comment: Takes care of args
Pass: 2

Criteria: 26
Find: { Extended | Double }
Replace: Extended

Criteria: 27
Find: Dword
Replace: UInt32

Criteria: 28
Find: { Long | Integer }
Replace: Int32

Criteria: 29
Find: [{optional: Optional}] ByVal {arg} As {type%:1}
Replace: <{type}> {arg}{optional: = 0}

Criteria: 30
Find: [{optional: Optional}] ByRef {arg} As String
Replace: <AnsiString&> {arg}{optional: = ""}

Criteria: 31
Find: ByRef ReturnStr As String
Replace: BSTR& ReturnStr

Criteria: 32
Find: Optional ByVal {item: ErrorHandlerAddress | FunctionAddress | VarAddress } As {type:1}
Replace: <void *>{item} = 0

Criteria: 33
Find: // extern {other~+} Int32 uCalcInit()
      {code+}
Replace: {nl}Int32 uCalcInit() {{code}}

Criteria: 34
PassOnce: False
Find: // typedef
      {SomeCode~+}
      // extern [{n~+}]
      def: {type}, {name}, {alias}, ([{args}])
      {MoreCode~+}
      return 1;
      
Replace: typedef {type} (CALLBACK* __{name})({args}); extern __{name} _{name}_; __{name} _{name}_;
         // typedef
         {SomeCode}{type} {name}({args}) {
            if(ucInit==0) uCalcInit();
            {@Eval: IIf("{type}"<>"void", "return ")}_{name}_({args});
         }
         
         // extern
         {MoreCode}
            _{name}_ = (__{name})GetProcAddress(hDLL, "{alias}");
            return 1;

Criteria: 35
Comment: 
Pass: 3

Criteria: 36
SkipOver: True
Find: { #include {etc} | [return] {"_"}{func}({result}); }
Replace: [Skip over]

Criteria: 37
Find: { < | > | // typedef }
Replace: {Nothing}

Criteria: 38
Comment: 
Pass: 4

Criteria: 39
Find: typedef {type} ({cback}) ({args})
Replace: typedef {type} ({cback}){@Eval: Remove('({args})', '= { 0 | {q}{q} }')}

Criteria: 40
Find: AnsiString&
Replace: AnsiString

Criteria: 41
Find: void {name}(BSTR& ReturnStr[[,] {args%}]) "{"
         {code~+}
      "}"
Replace: AnsiString {name}({args}) {
            BSTR ReturnStr_ = SysAllocStringByteLen(NULL, 1);{@Eval:
               Replace(Remove('{code}', '{ BSTR& | <{type}> | = { 0 | {q}{q} } }', Skip('==')), "ReturnStr", "ReturnStr_")
            }   AnsiString ReturnStr = (LPCSTR)ReturnStr_;
            SysFreeString(ReturnStr_);
            return ReturnStr;
         }

Criteria: 42
Find: "{" {code~+} "}"
Replace: {@Eval: Remove('{{code}}', '{ <{type}> | = { 0 | {q}{q} } }', Skip('=='))}

Criteria: 43
Comment: Reformat the text appearance a bit
Pass: 5

Criteria: 44
Find: ;{nl}{nl}{sp}
Replace: ;{nl}{#32#32#32}

Criteria: 45
Find: [{sp}],  {arg:1}
Replace: , {arg}

Criteria: 46
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

# End Search