# Delphi.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.5 on 1/23/2014 2:22:08 PM
# Comment: Transforms uCalc interface file to Delphi include file (uCalcDlp.pas)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to Delphi include file (uCalcDlp.pas)
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
OutputFile: uCalcDlp.pas
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: 
Pass: 1

Criteria: 2
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Implementation As String
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
BackColor: Yellow
Find: '
Replace: //

Criteria: 8
BackColor: Lime
Find: ' Interface.Bas {etc}
Replace: // {@Eval:OutputFile}: Delphi include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 9
BackColor: Red
Find: ' Designed for : {etc}
Replace: // Designed for: Delphi XE
         // Instructions: Add this file to your project's directory and the uCalc DLLs
         //               there as well (or copy the DLLs to a directory that is in the
         //               path).  Then Add "uCalcDlp" to the "uses" section of your code
         //               and you're ready go.

Criteria: 10
BackColor: Brown
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 11
BackColor: RoyalBlue
Find: ' VB.NET: {etc}
Replace: {Nothing}

Criteria: 12
BackColor: Pink
Find: ' VB.NET: Public Module uCalcVBNET
Replace: unit uCalcDlp;
         interface
         const

Criteria: 13
BackColor: SlateBlue
Find: ' VB.NET: End Module
Replace: implementation
         uses ActiveX;
         end.

Criteria: 14
BackColor: Purple
Find: %{const} = {value} [' {comment}]
Replace: {const} = {value}; {comment: // {comment}}

Criteria: 15
BackColor: Khaki
Find: Sub {name} Alias {q}{alias}{q} {args%} Export
        {body~+}
      End {Function || Sub}
Replace: procedure {alias}{args}; stdcall; external '{@Eval:DLLFile}';

Criteria: 16
Find: Function {name} Alias {q}{alias}{q} {args%} Export As {type:1}
        {body~+}
      End Function
Replace: function {alias}{args}: {type}; stdcall; external '{@Eval:DLLFile}';

Criteria: 17
BackColor: Green
Find: ' Function {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: function {alias}{args}: {type}; stdcall; external '{@Eval:DLLFile}';

Criteria: 18
BackColor: SandyBrown
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 19
Find: ' Deprecated {etc}
Replace: {Nothing}

Criteria: 20
BackColor: Violet
Find: ' Deprecated {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: function {name}{args}: {type}; stdcall; external '{@Eval:DLLFile}' name '{alias}';

Criteria: 21
BackColor: YellowGreen
Find: ' Sub {name} Alias {q}{alias}{q} {args%} Export
Replace: procedure {alias}{args}; stdcall; external '{@Eval:DLLFile}';

Criteria: 22
BackColor: CornflowerBlue
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Ext Alias {q}{alias}{q} {args%} Export
Replace: procedure {name}{args}; stdcall; external '{@Eval:DLLFile}' name '{alias}';

Criteria: 23
BackColor: Gold
Find: ' Sub {ucSetVariableValueDbl | ucReturnDbl} {etc}
Replace: {Nothing}

Criteria: 24
Comment: Removes extraneous whitespace and fixes args, etc.
Pass: 2

Criteria: 25
Find: ,
Replace: ;

Criteria: 26
Find: Long
Replace: LongInt

Criteria: 27
Find: Dword
Replace: LongWord

Criteria: 28
Find: [{optional: Optional}] ByVal {arg} As {type%:1}
Replace: {arg}: {type}{optional: = 0}

Criteria: 29
Selected: True
PassOnce: False
Find: Optional ByVal {arg: ErrorHandlerAddress | FunctionAddress | VarAddress} As {type:1}
Replace: ByVal {arg} As Pointer = nil

Criteria: 30
Find: [{optional: Optional}] { ByVal | {byref: ByRef}} {arg} As String
Replace: {byref:var }{arg}: AnsiString{optional: = ''}

Criteria: 31
Comment: 
Pass: 3

Criteria: 32
Find: {routine: procedure | function} {def:".*"}
Replace: {@Eval: IIf(InStr("{def}", "AnsiString"), "AnsiArg::")}{Self}

Criteria: 33
Comment: 
Pass: 4

Criteria: 34
Find: AnsiArg::{routine: procedure | function} {name}({args})[{type: : {type_:1}}]{etc>};
Replace: {routine} {name}_({@Eval: Replace(Remove("{args}", "= {''|0|nil}"), "ReturnStr: AnsiString", "ReturnStr: Pointer")}){type}{etc} name '{name}';
         :::{routine} {name}({@Eval: Remove("{args}", "var")}){type};
         begin
            {type: {name} := }{name}_({@Eval: Replace(Remove("{args}", "{ var | : {type__:1} [={''|0|nil}]}"), ";", ",")});
         end;

Criteria: 35
Comment: 
Pass: 5

Criteria: 36
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 37
PassOnce: False
Find: {nl}{nl}{routine: function | procedure}
Replace: {nl}{routine}

Criteria: 38
Find: {nl}:::{decl}{nl}{def+}end;
Replace: {nl}{decl}{@Eval: Implementation = Implementation + "{decl}{nl}{def}end;{nl}{nl}"}

Criteria: 39
PassOnce: False
Find: {nl}:::procedure {name} (ReturnStr: AnsiString [; {argsA}]);{nl}
      begin{nl}
         {FuncCall}{nl}
      end;
Replace: {nl}:::function {name}({argsA}): AnsiString;
         var
            ReturnStr: Pointer;
         begin
            ReturnStr := SysAllocStringByteLen(nil, 0);
            {FuncCall}
            {name} := PAnsiChar(ReturnStr);
            SysFreeString(ReturnStr);
         end;

Criteria: 40
Find: uses ActiveX;
Replace: {Self}
         
         {@Eval: Implementation}

Criteria: 41
Find: String
Replace: AnsiString

Criteria: 42
SkipOver: True
Find: // {comment:".*"}
Replace: [Skip over]

Criteria: 43
Find: name {RealName} name {DeprecatedName};
Replace: name {RealName};

# End Search