# PowerBASIC.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.8 on 1/16/2014 12:00:29 PM
# Comment: Transforms uCalc interface file to PowerBASIC include file (uCalcPB.Bas)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to PowerBASIC include file (uCalcPB.Bas)
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcPB.Bas
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Transforms Interface.Bas code to uCalcPB.Bas
Pass: 1

Criteria: 2
Selected: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: txt As String
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
         }

Criteria: 3
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
BackColor: Yellow
Find: ' Interface.Bas {etc}
Replace: ' {@Eval:ShortName(OutputFile)+SEND+Ext(OutputFile)}: PowerBASIC include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 8
BackColor: Lime
Find: ' Designed for : {etc}
Replace: ' Designed for : PB/CC 5+ and PB/Win 9+
         ' Instruction: Add the following line to your program and you're ready to go:
         '              #Include "uCalcPB.Bas"

Criteria: 9
BackColor: Red
Find: ' VB.NET: {code:".*"}
Replace: {Nothing}

Criteria: 10
BackColor: Brown
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 11
BackColor: Pink
PassOnce: False
Find: Function {name} Alias {q}{alias}{q} {args} Export As {type:1}
        {body~+}
      End Function
Replace: Declare Function {alias} Lib "{@Eval:DLLFile}" Alias "{alias}" {args} As {type}

Criteria: 12
PassOnce: False
Find: Sub {name} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
        {body~+}
      End Sub
Replace: Declare Sub {alias}_ Lib "{@Eval:DLLFile}" Alias "{alias}" (ByRef ReturnStr As String{args:, {args}})
         Function {alias}({args}) As String
            Dim ReturnStr As String
            {alias}_(ReturnStr{args:, {@Eval:
               txt=Replace('{args}', 'Optional ByRef {arg:1} As String', 'IIf$(VarPtr({arg}), {arg}, "")')
               Remove(txt, '{ Optional | ByVal | ByRef | As {type:1} }')
            }})
            {alias} = ReturnStr
         End Function

Criteria: 13
BackColor: SlateBlue
Find: ' {routine: Sub | Function} {name} Alias {q}{alias}{q} {args%} Export
Replace: Declare {routine} {alias} Lib "{@Eval:DLLFile}" Alias "{alias}" {args}

Criteria: 14
BackColor: Purple
Find: ' Deprecated {name:1} Alias {q}{alias}{q} {args} Export As {type}
Replace: Declare Function {name} Lib "{@Eval:DLLFile}" Alias "{alias}" {args} As {type}

Criteria: 15
PassOnce: False
Find: ' {Sub | Deprecated} {etc} (ByRef ReturnStr As String [, {args}]) Export
Replace: Sub {etc} (ByRef ReturnStr As String {args:, {args}}) Export
            ' Place holder
         End Sub

Criteria: 16
BackColor: Khaki
Find: ' Sub {name:" uc(SetVariableValue|Return)"}Ext {etc%} Export
Replace: Declare Sub{name} Lib "{@Eval:DLLFile}" {etc}

Criteria: 17
BackColor: Green
Find: ' Sub {ucSetVariableValueDbl | ucReturnDbl} {etc}
Replace: {Nothing}

Criteria: 18
BackColor: SandyBrown
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 19
Comment: Removes extraneous whitespace, etc.
Pass: 2

Criteria: 20
BackColor: YellowGreen
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 21
BackColor: CornflowerBlue
PassOnce: False
Find: {nl}{nl}Declare
Replace: {nl}Declare

# End Search