# VisualBasic6.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.8 on 1/16/2014 12:01:13 PM
# Comment: Transforms uCalc interface file to Visual Basic 6 include file (uCalcVB6.vb)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to Visual Basic 6 include file (uCalcVB6.vb)
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcVB6.Bas
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Transforms Interface.Bas code to uCalcNET.vb
Pass: 1

Criteria: 2
Selected: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Var: Implementation As String
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
Comment: Transforms uCalc interface file to Visual Basic 6 include file (uCalcVB6.Bas)
BackColor: Yellow
Find: ' Interface.Bas {etc}
Replace: ' {@Eval:OutputFile}: VB6 include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 8
BackColor: Lime
Find: ' Designed for : {etc}
Replace: ' Designed for : Visual Basic 6
         ' Instructions: Add this file to your project's directory (from the menu:
         '               Project / Add Module / Existing) and copy uCalc DLLs to
         '               a directory in the path, such as a system directory, or
         '               else in the project directory, and you're ready to go.
         '               Note: When running from the debugger instead of compiled,
         '               the DLLs might not be found if they are only in your
         '               project directory and that directory is not in the path.

Criteria: 9
BackColor: Red
Find: ' VB.NET: {code:".*"}
Replace: {Nothing}

Criteria: 10
Find: ' VB.NET: End Module
Replace: ' String return functions

Criteria: 11
BackColor: Brown
Find: ' VB.NET: Public Module uCalcVBNET
Replace: Attribute VB_Name = "uCalcModule"

Criteria: 12
BackColor: RoyalBlue
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 13
BackColor: Pink
Find: %{const} =
Replace: Public Const {const} As Long =

Criteria: 14
BackColor: SlateBlue
Find: Optional ByVal {var:1} As {type:1}
Replace: Optional ByVal {var} As {type} = 0

Criteria: 15
BackColor: Purple
Find: Optional ByVal {var:1} As String
Replace: Optional ByVal {var} As String = ""

Criteria: 16
BackColor: Green
PassOnce: False
Find: Function {name} Alias {q}{alias}{q} {args} Export As {type:1}
        {body~+}
      End Function
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" {args} As {type}

Criteria: 17
Find: Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
        {body~+}
      End Sub
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" ({args}) As String

Criteria: 18
BackColor: SandyBrown
PassOnce: False
Find: ' {routine: Sub | Function} {name} Alias {q}{alias}{q} {etc} Export
Replace: Public Declare {routine} {alias} Lib "{@Eval:DLLFile}" {etc}

Criteria: 19
BackColor: Violet
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 20
BackColor: YellowGreen
Find: ' Deprecated {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: Public Declare Function {name} Lib "{@Eval:DLLFile}" Alias "{alias}" {args} As {type}

Criteria: 21
BackColor: CornflowerBlue
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Dbl {etc} Export
Replace: Public Declare Sub {name} Lib "{@Eval:DLLFile}" {etc}

Criteria: 22
BackColor: Gold
Find: ' Sub {ucSetVariableValueExt | ucReturnExt} {etc}
Replace: {Nothing}

Criteria: 23
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" ({args}) As String

Criteria: 24
Comment: Removes extraneous whitespace and fixes args
Pass: 2

Criteria: 25
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 26
PassOnce: False
Find: {nl}{nl}Public
Replace: {nl}Public

Criteria: 27
Find: As { Dword | Long | {type} Ptr }
Replace: As Long

Criteria: 28
Find: As Extended
Replace: As Double

Criteria: 29
Find: {routine: Sub | Function} {name} Lib {lib} Alias {q}{name}{q}
Replace: {routine} {name} Lib {lib}

Criteria: 30
Comment: 
Pass: 3

Criteria: 31
PassOnce: False
Find: Function {name} Lib {lib} ({args}) As String
Replace: Sub {name}_ Lib {lib} Alias "{name}" (ByRef ReturnStr As String, {args}){@Eval:
         Implementation = Implementation + "
         Public Function {name}({args}) As String
            Dim ReturnStr As String
            Call {name}_(ReturnStr, "+Remove('{args}', '{ Optional|ByVal|ByRef|As {type:1}[={val:1}] }', ucQuote)+")
            {name} = ReturnStr
         End Function
         "
         }

Criteria: 32
Find: Alias {real:1} Alias {etra:1}
Replace: Alias {real}

Criteria: 33
Find: ' String return functions
Replace: {Self}
         {@Eval: Implementation}

# End Search