# VisualBasicNET.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.8 on 3/7/2014 4:10:31 PM
# Comment: Transforms uCalc interface file to VB.NET include file (uCalcVB.vb)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to VB.NET include file (uCalcVB.vb)
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcVB.vb
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: 
Pass: 1

Criteria: 2
Highlight: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
Highlight: True
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
Highlight: True
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
Highlight: True
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
Highlight: True
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
Highlight: True
BackColor: Yellow
Find: ' Interface.Bas {etc}
Replace: ' {@Eval:OutputFile}: VB.NET Include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 8
Highlight: True
BackColor: Lime
Find: ' Designed for : {etc}
Replace: ' Designed for : Visual Basic .NET 2010 and 2012
         ' Instructions: Add this file to your project's directory (from the menu:
         '               Project / Add Existing Item...) and copy uCalc DLLs to
         '               your bin and/or bin\Debug directory (or any directory in
         '               the path) and you're ready to go.

Criteria: 9
Highlight: True
BackColor: Red
Find: ' VB.NET:{" "}{code:".*"}
Replace: {code}

Criteria: 10
Highlight: True
BackColor: Brown
Find: ' VB.NET: Public Module uCalcVBNET
Replace: Imports System.Runtime.InteropServices
         
         Public Module uCalcVBNET

Criteria: 11
Highlight: True
BackColor: RoyalBlue
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 12
Highlight: True
BackColor: Pink
Find: %{const} =
Replace: Public Const {const} As Integer =

Criteria: 13
Highlight: True
BackColor: SlateBlue
Find: Optional ByVal {var:1} As {type:1}
Replace: Optional ByVal {var} As {type} = 0

Criteria: 14
Highlight: True
BackColor: Purple
Find: Optional ByRef {var:1} As String
Replace: Optional ByRef {var} As String = ""

Criteria: 15
Highlight: True
BackColor: Green
PassOnce: False
Find: Function {name:1} Alias {q}{alias}{q} {args} Export As {type:1}
        {body~+}
      End Function
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" {args} As {type}

Criteria: 16
Highlight: True
PassOnce: False
Find: Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
        {body~+}
      End Sub
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" ({args}) As String

Criteria: 17
Highlight: True
BackColor: SandyBrown
PassOnce: False
Find: ' {routine: Sub | Function} {name} Alias {q}{alias}{q}{etc} Export
Replace: Public Declare {routine} {alias} Lib "{@Eval:DLLFile}" {etc}

Criteria: 18
Highlight: True
BackColor: Violet
Find: ' Deprecated {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: Public Declare Function {name} Lib "{@Eval:DLLFile}" Alias "{alias}" {args} As {type}

Criteria: 19
Highlight: True
BackColor: YellowGreen
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Dbl {etc} Export
Replace: Public Declare Sub {name} Lib "{@Eval:DLLFile}" {etc}

Criteria: 20
Highlight: True
BackColor: CornflowerBlue
Find: ' Sub {ucSetVariableValueExt | ucReturnExt} {etc}
Replace: {Nothing}

Criteria: 21
Highlight: True
PassOnce: False
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
      
Replace: Public Declare Function {alias} Lib "{@Eval:DLLFile}" ({args}) As String

Criteria: 22
Comment: Removes extraneous whitespace and fixes args, etc
Pass: 2

Criteria: 23
Highlight: True
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 24
Highlight: True
PassOnce: False
Find: {nl}{nl}Public
Replace: {nl}Public

Criteria: 25
Highlight: True
Find: As Long
Replace: As Integer

Criteria: 26
Highlight: True
Find: As Dword
Replace: As UInteger

Criteria: 27
Highlight: True
Find: As Extended
Replace: As Double

Criteria: 28
Highlight: True
Find: [{optional: Optional}] ByRef {arg} As String
Replace: <MarshalAsAttribute(UnmanagedType.AnsiBStr)>{optional} ByRef {arg} As String

Criteria: 29
Highlight: True
Find: ErrorHandlerAddress As {type:1} = 0
Replace: ErrorHandlerAddress As ucErrorHandlerDelegate = Nothing

Criteria: 30
Highlight: True
Find: FunctionAddress As {type:1} = 0
Replace: FunctionAddress As ucFunctionDelegate = Nothing

Criteria: 31
Selected: True
Highlight: True
Find: VarAddress As {type%:1} = 0
Replace: {@Eval: IIF(SEND=="x64", "VarAddress As Int64 = 0", "VarAddress As Integer = 0")}

Criteria: 32
Highlight: True
Find: {routine: Sub | Function} {name} Lib {lib} Alias {q}{name}{q}
Replace: {routine} {name} Lib {lib}

Criteria: 33
Comment: Creates additional function for ones that return a string
Pass: 3

Criteria: 34
Highlight: True
PassOnce: False
Find: Function {name} Lib {lib} ({args}) As String
Replace: Sub {name}_ Lib {lib} Alias "{name}" (<MarshalAsAttribute(UnmanagedType.AnsiBStr)> ByRef ReturnStr As String, {args})
         Public Function {name}({@Eval: Remove('{args}', '<MarshalAsAttribute(UnmanagedType.AnsiBStr)>')}) As String
            Dim ReturnStr As String = ""
            {name}_(ReturnStr, {@Eval: Remove('{args}', '{ Optional|ByVal|ByRef|As {type:1}[={val:1}] | <MarshalAsAttribute(UnmanagedType.AnsiBStr)> }', ucQuote)})
            If ReturnStr Is Nothing Then Return "" Else Return ReturnStr
         End Function

Criteria: 35
Highlight: True
PassOnce: False
Find: Alias {real:1} Alias {etra:1}
Replace: Alias {real}

Criteria: 36
Comment: Adds indentation
Pass: 4

Criteria: 37
Highlight: True
Find: {nl}
Replace: {nl}{sp}{sp}{sp}

Criteria: 38
Highlight: True
Find: { ' {etc~+} {nl}Public Module | {nl}End Module }
Replace: {Self}

# End Search