# VisualCppNET.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.95 on 3/10/2014 4:00:39 PM
# Comment: Transforms uCalc interface file to VC++.NET header (uCalcVC_NET.h)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to VC++.NET header (uCalcVC_NET.h)
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcVC_NET.h
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: 
Pass: 1

Criteria: 2
Highlight: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Var: StringMarshal = "[In,Out,MarshalAs(UnmanagedType::AnsiBStr)]String ^ %"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
Highlight: True
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
Highlight: True
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
Highlight: True
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
Highlight: True
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
Highlight: True
BackColor: Yellow
Find: '
Replace: //

Criteria: 8
Highlight: True
BackColor: Lime
Find: ' Interface.Bas {etc}
Replace: // {@Eval:OutputFile}: VC++ NET include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 9
Highlight: True
BackColor: Red
Find: ' Designed for : {etc}
Replace: // Designed for : Visual C++.NET 2010 and 2012 with CLR

Criteria: 10
Highlight: True
BackColor: Brown
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 11
Highlight: True
BackColor: RoyalBlue
Find: ' VB.NET: Public Module uCalcVBNET
Replace: #pragma once
         using namespace System;
         using namespace System::Runtime::InteropServices;
         
         #define uCalcDLL "{@Eval:DLLFile}"{nl}

Criteria: 12
Highlight: True
BackColor: Pink
Find: ' VB.NET: End Module
Replace: {Nothing}

Criteria: 13
Highlight: True
BackColor: SlateBlue
Find: ' VB.NET: Public Delegate Sub {name}({args})
Replace: public delegate void {name}({args});

Criteria: 14
Highlight: True
BackColor: Purple
Find: ' VB.NET: Public Delegate Function {name}({args}) As {type}
Replace: public delegate {type} {name}({args});

Criteria: 15
Highlight: True
BackColor: Khaki
PassOnce: False
Find: %{const} = {value:" [0-9\-]+"}
Replace: const int {const} ={value};

Criteria: 16
Highlight: True
BackColor: Green
Find: Function {name} Alias {q}{alias}{q} {args%} Export As {type:1}
        {body~+}
      End Function
Replace: DLL.Import {type} {alias}{args};

Criteria: 17
Highlight: True
Find: Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args%}]) Export
        {body~+}
      End Sub
Replace: DLL.Import string {alias}({args});

Criteria: 18
Highlight: True
BackColor: SandyBrown
Find: ' Function {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: DLL.Import {type} {alias}{args};

Criteria: 19
Highlight: True
BackColor: Violet
Find: ' Deprecated {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: DLL.Import, EntryPoint="{alias}" {type} {name}{args};

Criteria: 20
Highlight: True
BackColor: YellowGreen
Find: ' Sub {name} Alias {q}{alias}{q} {args%} Export
Replace: DLL.Import void {alias} {args};

Criteria: 21
Highlight: True
BackColor: CornflowerBlue
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Dbl Alias {alias:1} {args%} Export
Replace: DLL.Import, EntryPoint="{name}Dbl" void {name}{args};

Criteria: 22
Highlight: True
BackColor: Gold
Find: ' Sub {ucSetVariableValueExt | ucReturnExt} {etc}
Replace: {Nothing}

Criteria: 23
Highlight: True
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args%}]) Export
Replace: DLL.Import string {alias}({args});

Criteria: 24
Comment: Removes extraneous whitespace and fixes args, etc.
Pass: 2

Criteria: 25
Highlight: True
Find: Extended
Replace: double

Criteria: 26
Highlight: True
Find: Dword
Replace: UInt32

Criteria: 27
Highlight: True
Find: { Long | Integer }
Replace: int

Criteria: 28
Highlight: True
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 29
Highlight: True
PassOnce: False
Find: {nl}{nl}{LineBeginning: public static | DLL.Import}
Replace: {nl}{LineBeginning}

Criteria: 30
Highlight: True
Find: [{optional: Optional}] ByRef {arg} As String
Replace: {@Eval:StringMarshal} {arg}{optional: = ""}

Criteria: 31
Highlight: True
Find: [{optional: Optional}] ByVal {arg} As {type%:1}
Replace: {type} {arg}{optional: = 0}

Criteria: 32
Highlight: True
Find: [{optional: Optional}] ByVal ErrorHandlerAddress As {type:1}
Replace: ucErrorHandlerDelegate ^ ErrorHandlerAddress {optional: = nullptr}

Criteria: 33
Highlight: True
Find: [{optional: Optional}] ByVal FunctionAddress As {type:1}
Replace: ucFunctionDelegate ^ FuncAddress {optional: = nullptr}

Criteria: 34
Highlight: True
Find: [{optional: Optional}] ByVal {arg:1} As {type: ucCheckForStop | ucFunctionDelegate}
Replace: {type} ^ {arg} {optional: = nullptr}

Criteria: 35
Highlight: True
Find: [{optional: Optional}] ByVal VarAddress As {type:1}
Replace: {@Eval: IIF(SEND=="x64", "__int64 VarAddress = 0", "int VarAddress = 0")}

Criteria: 36
Comment: 
Pass: 3

Criteria: 37
Highlight: True
Find: DLL.Import[{e: , EntryPoint={q}{name}{q}}]
Replace: [DllImport(uCalcDLL{e})]

Criteria: 38
Selected: True
Highlight: True
PassOnce: False
Find: DLL.Import[{{e: , EntryPoint={q}{name}{q}}|{ne: }}] {type:1} {func}({args: {etc1} String{a:" "}{etc2}});
Replace: [DllImport(uCalcDLL{e}{ne:, EntryPoint="{func}"})] {type} {func}_({@Eval: Remove('{args}', '={opt:1}', ucQuote)});
         {type} {func}({@Eval: Replace('{args}', '"["{marshal}"]" String ^ %', 'String ^')}) {
            {@Eval:IIf('{type}'<>'void', 'return')} {func}_({@Eval: Remove('{args}', '{ UInt32|int| ={x:1}|ucCheckForStop|ucFunctionDelegate|__int64|"["{marshal}"]" String | ^ | % }', ucQuote)});
         }

Criteria: 39
Highlight: True
Find: DLL.Import[{{e: , EntryPoint={q}{name}{q}}|{ne: }}] String {func}({args});
Replace: [DllImport(uCalcDLL{e}{ne:, EntryPoint="{func}"})] void {func}_({@Eval:StringMarshal} ReturnStr, {@Eval: Remove('{args}', '={x:1}', ucQuote)});
         String ^ {func}({@Eval: Replace('{args}', '"["{marshal}"]" String ^ %', 'String ^ ')}) {
            String ^ ReturnStr = "";
            {func}_(ReturnStr, {@Eval: Remove('{args}', '{ UInt32|int| ={x:1} | "["{marshal}"]" String | ^ | % }', ucQuote)});
            return ReturnStr;
         }

# End Search