# +++ Namespace
# Note: A simple but quite useful REPL can be done with just the 1 line of
# code at the end of this comment.  However, extras further down provide
# additional niceties such as configurable output and prompts, support for
# multiline input, startup timer, etc.
#
# uc_Loop(True, WriteLn(ucEval(ReadLine())), EndOfInput <> True)

Var: Prompt_SingleLine = "> "
Var: Prompt_MultiLine  = ">>"
Var: REPL_StopCommand  = "{ Bye | Stop | Quit | Exit }"
Var: REPL_Language = "Generic"
Var: REPL_Startup = "Startup.uc"
Var: REPL_Result As String
Var: REPL_ResultType As DWord
Var: REPL_Result_Extra = "WriteLn()"
Var: REPL_Expression As String

Overhead ~~ Func: REPL_Format(Result As String, t As Long) As String = Result

Syntax: Prog_Start ::= {q}{Prog_Start} {q}
Pass: 1 ~~ Syntax: {Prog_Start} ::=
Pass: 1 ~~ Syntax: REPL_OR_FILE ::= REPL_Run
Pass: 1 ~~ Syntax: REPL_OR_FILE {MoreCode:{q}[\x00-\xFF]{5}{q}} ::= {Prog_Start}{MoreCode}

If: _NoConsole == True  ~~ Func: REPL_Run(t As Long = ~t) As String = ""
If: _NoConsole == False ~~ Func: REPL_Run(t As Long = ~t) = {
   ~Local(Var: Prompt As String)
   ~Local(Var: MultiLine As String)

   WriteLn("uCalc Language Builder "+REPL_Language+" Interpreter");
   WriteLn("Type "+REPL_Language+" code, or enter SAMPLE for an example, or BYE to quit.");
   WriteLn("Load Time: " + Omni((GetTickCount - ucScriptTimerStart) / 1000) + CrLf);
   SetVar(_Echo, True);
   ucDefine("Pass: 1 ~"+"~Syntax: {Prog_Start}Sample ::= _
             _SendTextToInput(Load({qq}~Eval(REPL_Language)_Sample.uc{qq}))", t);
   ucDefine("Pass: 1 ~"+"~Syntax: {Prog_Start}" + REPL_StopCommand + " ::= SetVar(EndOfInput, True)", t);
   SetVar(Prompt, Prompt_SingleLine);
   SetVar(EndOfInput, False);

   ucEval(Prog_Start + Load(REPL_Startup));

   uc_Loop(1,
      Write(Prompt);
      SetVar(REPL_Expression, MultiLine + ReadLine());
      SetVar(REPL_Result, ucEval(Prog_Start + REPL_Expression, t));

      Iif(uc_IsIncomplete(t),
         uc_IsIncomplete(t, False);
         SetVar(Prompt, Prompt_MultiLine);
         SetVar(MultiLine, REPL_Expression + CrLf)
      ,
         SetVar(REPL_ResultType, uCalc(uc_GetItemData, '', t, uc_DataType, 0, t));
         Write(REPL_Format(REPL_Result, t));
         ucEval(REPL_Result_Extra);
         SetVar(Prompt, Prompt_SingleLine);
         SetVar(MultiLine, "")
      ),      
   EndOfInput <> True);
}
