#PBForms Created V1.51
'--------------------------------------------------------------------------------
' The first line in this file is a PBForms metastatement.
' It should ALWAYS be the first line of the file. Other
' PBForms metastatements are placed at the beginning and
' ending of blocks of code that should be edited using
' PBForms only. Do not edit or delete these
' metastatements or PBForms will not be able to reread
' the file correctly. See the PBForms documentation for
' more information.
' Beginning blocks begin like this: #PBForms Begin ...
' Ending blocks begin like this:    #PBForms End ...
' Other PBForms metastatements such as:
'     #PBForms Declarations
' are used to tell PBForms where to insert additional
' code. Feel free to make changes anywhere else in the file.
'--------------------------------------------------------------------------------

#Compile Exe
#Dim All

'--------------------------------------------------------------------------------
'   ** Includes **
'--------------------------------------------------------------------------------
#PBForms Begin Includes
#If Not %Def(%WINAPI)
   #Include "WIN32API.INC"
#EndIf
#Include "PBForms.INC"
#PBForms End Includes
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Constants **
'--------------------------------------------------------------------------------
#PBForms Begin Constants
%IDD_Form1               =  101
%IDC_chkDefExamples      = 1001
%IDC_chkExprEvalExamples = 1002
%IDC_txtPlotEq           = 1003
%IDC_btnPlot             = 1004
%IDC_Picture1            = 1005
%IDC_txtSumMax           = 1006
%IDC_btnSum              = 1007
%IDC_txtSumResult        = 1008
%IDC_txtSumExpression    = 1009
%IDC_btnDefine           = 1010
%IDC_btnEval             = 1012
%IDC_txtResult           = 1013
%IDC_lblElapsed          = 1021
%IDC_Label1              = 1022
%IDC_lblFPU              = 1030
%IDC_chkInvalidOp        = 1031
%IDC_chkDenormalOp       = 1032
%IDC_chkDivisionBy0      = 1033
%IDC_chkOverflow         = 1034
%IDC_chkUnderflow        = 1035
%IDC_chkPrecisionLoss    = 1036
%IDC_cmbExpression       = 1037
%IDC_cmbDefinition       = 1038
%IDC_cmbNumericFormat    = 1039
#PBForms End Constants
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Declarations **
'--------------------------------------------------------------------------------
Declare CallBack Function ShowForm1Proc()
Declare Function ShowForm1(ByVal hParent As Dword) As Long
#PBForms Declarations
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
#Include "uCalcPB.bas" ' Note: Run Setup.Bat first to copy this and other required files.

Global Ps As PAINTSTRUCT
Global Rct As RECT
Global NumericFormat$

Sub SpeedTest(ByVal hDlg As Dword)
   Dim Expression As String, txtSumMax As String
   Dim ExprHandle As Dword, xHandle As Dword
   Dim x As Extended, SumTotal As Extended, SumMax As Extended
   Dim TimerStart As Single, TimerEnd As Single

   Control Get Text hDlg, %IDC_txtSumExpression To Expression
   Control Get Text hDlg, %IDC_txtSumMax To txtSumMax

   xHandle = ucDefineVariable("x", VarPtr(x))
   ExprHandle = ucParse(Expression)

   SumMax = Val(txtSumMax)
   TimerStart = Timer

   For x = 1 To SumMax
      SumTotal = SumTotal + ucEvaluate(ExprHandle)
   Next

   TimerEnd = Timer - TimerStart
   Control Set Text hDlg, %IDC_txtSumResult, Str$(SumTotal, 18)
   Control Set Text hDlg, %IDC_lblElapsed, "Elapsed Time: " + Format$(TimerEnd, "0.00") + " seconds"

   ucReleaseItem ExprHandle
   ucReleaseItem xHandle
End Sub

Sub CartesianLineTo(ByVal hDc As Long, ByVal x As Single, y As Single)
   Dim NewX As Long, NewY As Long

   NewX = 216 * (x + 10) / 20
   NewY = 100 * (2 - y) / 4

   If x = -10 Or NewY > 99 Or NewY < 0 _
   Then MoveToEx hDc, NewX, Min&(Max&(NewY, 0), 99), ByVal %NULL _
   Else LineTo hDc, NewX, NewY
End Sub

Sub PlotGraph(ByVal hDlg As Dword)
    Dim x As Extended, EqHandle As Dword, xHandle As Dword
    Dim Equation$
    Dim hDc As Dword

    hDC = GetDC(GetDlgItem(hDlg, %IDC_Picture1))
    Rct.nRight = 216 : Rct.nBottom = 100
    FillRect hDC, Rct, 1

    Control Get Text hDlg, %IDC_txtPlotEq To Equation$

    xHandle = ucDefineVariable("x", VarPtr(x))
    EqHandle = ucParse(Equation$)

    For x = -10 To 10 Step 0.125
       CartesianLineTo hDc, x, ucEvaluate(EqHandle)
    Next

    ucReleaseItem EqHandle
    ucReleaseItem xHandle

    ReleaseDC GetDlgItem(hDlg, %IDC_Picture1), hDC
End Sub

' uCalc callback routines

Sub MyNumericFormat(ByVal Expr As Dword)
   Dim Value As Extended, ValueAsString As String ' NumericFormat$ is Global

   ValueAsString = ucArgStr(Expr, 1)
   Value = Val(ValueAsString)

   Select Case NumericFormat$
   Case "General Number": NumericFormat$ = ""
   Case "Currency": NumericFormat$ = "$#.00; ($#.00)"
   Case "Fixed": NumericFormat$ = "#.00"
   Case "Standard": NumericFormat$ = "#.#,"
   Case "Percent": NumericFormat$ = "0.0%" : Value = Value * 100
   Case "Scientific": NumericFormat$ = "0.00E+##"
   End Select

   If ValueAsString = "Inf" Or ValueAsString = "NaN" _
   Then ucReturnStr(Expr, ValueAsString) _
   Else ucReturnStr(Expr, Format$(Value, NumericFormat$))
End Sub

Function MyErrorHandler(ByVal t As Long) As Long
   Static AlreadyDisplayedOnce As Long

   If AlreadyDisplayedOnce = %ucFalse Then
      MsgBox "Error Handler message: " + ucErrorMessage(0, t) + Chr$(13) _
         + "Offending symbol: " + ucErrorSymbol(t) + Chr$(13) _
         + "Error Location: " + Str$(ucErrorLocation(t)) + Chr$(13) + Chr$(13) _
         + "This message box won't be displayed for the next error." + Chr$(13) _
         + "Remove 'AlreadyDisplayedOnce = %ucTrue' in the demo source code to change this."
   End If

   ' Remove the line below if you want the message box to be
   ' displayed every time there's an error.
   AlreadyDisplayedOnce = %ucTrue
   MyErrorHandler = %ucAbort
End Function

Sub MyArea(ByVal Expr As Dword)
   Dim MyLength As Extended, MyWidth As Extended

   MyLength = ucArg(Expr, 1)
   MyWidth = ucArg(Expr, 2)

   If MyLength < 0 Then ucRaiseErrorMessage Expr, "Length cannot be negative"
   If MyWidth < 0 Then ucRaiseErrorMessage Expr, "Width cannot be negative"

   ucReturn(Expr, MyLength * MyWidth)
End Sub

Function NonNativeFunc(ByVal a As Double, ByRef b As Long, ByVal c As Byte) As Extended
   NonNativeFunc = a + b + c
End Function

Sub MyIIF_Numeric(ByVal Expr As Dword)
   Dim Condition As Extended, TruePart As Dword, FalsePart As Dword

   Condition = ucArg(Expr, 1)
   TruePart = ucArgHandle(Expr, 2)
   FalsePart = ucArgHandle(Expr, 3)

   If Condition <> 0 Then
      ucReturn(Expr, ucEvaluate(TruePart))
   Else
      ucReturn(Expr, ucEvaluate(FalsePart))
   End If
End Sub

Sub MyIIF_String(ByVal Expr As Dword)
   Dim Condition As Extended, TruePart As Dword, FalsePart As Dword

   Condition = ucArg(Expr, 1)
   TruePart = ucArgHandle(Expr, 2)
   FalsePart = ucArgHandle(Expr, 3)

   If Condition <> 0 Then
      ucReturnStr(Expr, ucEvaluateStr(TruePart))
   Else
      ucReturnStr(Expr, ucEvaluateStr(FalsePart))
   End If
End Sub

Sub Native_MsgBox(ByVal Expr As Dword)
   ucReturn(Expr, MsgBox(ucArgStr(Expr, 1), ucArg(Expr, 2), ucArgStr(Expr, 3)))
End Sub

Function nn_MsgBox(ByRef Prompt As String, ByVal Buttons As Long, ByRef Title As String) As Long
   nn_MsgBox = MsgBox(Prompt, Buttons, Title)
End Function

Sub MyAverage(ByVal Expr As Dword)
   Dim x As Long, Total As Extended

   For x = 1 To ucArgCount(Expr)
      Total = Total + ucArg(Expr, x)
   Next

   ucReturn(Expr, Total / ucArgCount(Expr))
End Sub

Sub MyLeft(ByVal Expr As Dword)
    ucReturnStr(Expr, Left$(ucArgStr(Expr, 1), ucArg(Expr, 2)))
End Sub

Sub StringRepeat(ByVal Expr As Dword)
   Dim x As Long, TotalString As String

   For x = 1 To ucArg(Expr, 2)
      TotalString = TotalString + ucArgStr(Expr, 1)
   Next

   ucReturnStr(Expr, TotalString)
End Sub

Sub ucSum(ByVal Expr As Dword)
   Dim Expression As Dword, VarHandle As Dword
   Dim Start As Long, Finish As Long, sStep As Long
   Dim x As Extended, Total As Extended

   Expression = ucArgHandle(Expr, 1)
   Start      = ucArg(Expr, 2)
   Finish     = ucArg(Expr, 3)
   sStep      = ucArg(Expr, 4)
   VarHandle  = ucArgHandle(Expr, 5)

   For x = Start To Finish Step sStep
      ucSetVariableValue(VarHandle, x)
      Total = Total + ucEvaluate(Expression)
   Next

   ucReturn(Expr, Total)
End Sub

Sub ucSolve(ByVal Expr As Dword)
   Dim Expression As Dword, Variable As Dword, Iterations As Long
   Dim a As Double, b As Double, fa As Double, fb As Double
   Dim Value As Double, tmp As Double

   Expression = ucArgHandle(Expr, 1)
   a = ucArg(Expr, 2)
   b = ucArg(Expr, 3)
   Variable = ucArgHandle(Expr, 4)

   ucSetVariableValue(Variable, a): fa = ucEvaluate(Expression)
   ucSetVariableValue(Variable, b): fb = ucEvaluate(Expression)

   If fb < fa Then tmp = a: a = b: b = tmp   'swap a, b

   Do While Abs(b - a) > 0.000000000000001
      ucSetVariableValue(Variable, (a + b) / 2)

      Value = ucEvaluate(Expression)

      If Value = 0 Then a = (a + b) / 2: Exit Do

      If Value < 0 _
      Then a = (a + b) / 2 _
      Else b = (a + b) / 2

      Iterations = Iterations + 1
      If Iterations = 100 Then Exit Do
   Loop

   If Abs(Value) > 0.0000000001 Then ucRaiseErrorMessage Expr, "Solution not found"

   ucReturn(Expr, a)
End Sub

Sub Test(ByVal Expr As String, ByVal Answer As String, Optional ByVal t As Long)
   If Answer <> ucEvalStr(Expr, t) Then MsgBox Expr + Chr$(10) + ucEvalStr(Expr, t) + Chr$(10) + Answer
End Sub

Sub TestExpand(ByVal Expr As String, ByVal Answer As String, Optional ByVal t As Long)
   If Answer <> ucExpand(Expr, t) Then MsgBox Expr + Chr$(10) + ucExpand(Expr, t) + Chr$(10) + Answer
End Sub

Function PBMain()
   ' The definitions here are for "callback" routines.
   ' Note: A callback in uCalc has a somewhat different meaning than a callback in PB.
   ' Each line ends with the address of a routine, using CodePtr.
   ' The actual code for these routines can be found elsewhere in this file.
   ' Do a search for MyErrorHandler, for instance, to see the actual code for it.

   ' Code in the MyNumericFormat() Sub routine determines the output format for numeric values.
   ucSetOutput(CodePtr(MyNumericFormat))

   ' The MyErrorHandler() function will be called whenever and wherever an
   ' error (such as "Syntax Error") is raised.

   ucAddErrorHandler(CodePtr(MyErrorHandler))

   ' Native callback definitions, which start with "Native: " are recommended for
   ' speed, and for routines that use uCalc's default numeric and string types.
   ' MyArea() returns the product of multiplying the two arguments.
   ' MyLeft() returns the left-most characters of a string.  The second argument represents the number of characters.
   ' MsgBox() displays a message box.  The 1st argument is required.  The others are optional.
   ucDefineFunction "Native: MyArea(Length, Width)", CodePtr(MyArea)
   ucDefineFunction "Native: MyLeft(Text As String, Count) As String", CodePtr(MyLeft)
   ucDefineFunction "Native: MyMsgBox(Prompt As String, Buttons = 0, Title As String = 'uCalc')", CodePtr(Native_MsgBox)
   ucDefineSyntax "MsgBox ::= MyMsgBox"

   ' The three consecutive dots "..." mean that MyAverage can take any number of arguments
   ' (however, because "x" is specified, there must be at least one argument).
   ucDefineFunction "Native: MyAverage(x ...)", CodePtr(MyAverage)

   ' Two versions of MyIIF can co-exist peacefully with the same name because
   ' they are defined with different argument types (numeric vs string).
   ' By passing the last two arguments ByExpr, the callback can chose to evaluate only one of of them.
   ucDefineFunction "Native: MyIIf(cond, ByExpr TruePart, ByExpr FalsePart)", CodePtr(MyIIF_Numeric)
   ucDefineFunction "Native: MyIIf(cond, ByExpr TruePart As String, ByExpr FalsePart As String) As String", CodePtr(MyIIF_String)

   ' The following defines the "*" operator so that MyString * n returns MyString repeated n times.
   ' For instance, "He " * 3, would return "He He He".  20 represents the precedence level.  It is
   ' arbitrarily set at the same level as that of the "*" multiplication operator defined in uCalcPB.Bas.

   ucDefineOperator "Native: Precedence('*') {MyString As String} * {Number} As String", CodePtr(StringRepeat)

   ' Non-native callbacks are intended for routines that were not created with
   ' uCalc in mind, such as the Windows API, or other pre-existing DLL routines.
   ' It is convenient (no need to adapt the routines; all you need is a function
   ' address), but not as fast as Native callbacks.
   ' NonNativeFunc() simply adds the three arguments.
   ' nn_MsgBox is a Non-Native version of MsgBox, which displays a message box.
   ucDefineFunction "NonNativeFunc(ByVal a As Double, ByRef b As Long, ByVal c As Byte) As Extended", CodePtr(NonNativeFunc)
   ucDefineFunction "nn_MsgBox(ByRef Prompt As String, ByVal Buttons As Long = 0, ByRef Title As String = 'uCalc') As Long", CodePtr(nn_MsgBox)

   ' This definition is for a summation.  See the callback ucSum() routine for the
   ' actual code, which runs a loop that adds up the total for the expression in
   ' the first argument a number of times based on the second and third arguments.
   ' For instance Sum(g^2+1, 1, 5, 1, g) returns 60 and Sum(x^2, 1, 10) returns 385.
   ' The last two arguments are optional, so they default to 1 and x if omitted.
   '
   ' The first argument is passed "ByExpr".  So instead of being evaluated before
   ' being passed to the callback the way an ordinary argument would be, a handle
   ' for the expression is passed so that the callback can evaluate it (in this
   ' case numerous times).
   '
   ' The last argument is passed "ByHandle".  This causes the callback to receive
   ' a handle for the variable being passed, in such a way that it can be linked to
   ' the summation counter, and integrated into the expression in the first argument.
   '
   ' The actual function being defined is Sum_().  Then a syntax construct named
   ' Sum() is defined in such a way that the last argument gets defined as a local
   ' variable.  So if you evaluate Sum(x^2, 5, 10, 1, x), the local "x" in this
   ' expression will not interfere with a pre-existing variable named x.  Also you
   ' do not need to declare a variable ahead of time to use it as a counter for Sum().
   ucDefineFunction "Native: Sum_(ByExpr Expr, Start, Finish, Step, ByHandle Var)", CodePtr(ucSum)
   ucDefineSyntax "Sum({Expr}, {Start}, {Finish} [, {Step=1} [, {Var=x}]])" _
                + "::= Local({Var}, Sum_({Expr}, {Start}, {Finish}, {Step}, {Var}))"

   ' The following routine solves an equation.
   ' The callback code is based on the Bisection Method algorithm.
   ' The concept here is very similar to that of Sum().
   ' Two syntax constructs are defined.  The second one rearranges the equation
   ' if it includes an equal sign.
   ' For instance Solve(x^2 = 9+x) becomes Solve(x^2 - (9+x))
   ' Solve(x^2 + 1 = 26) returns 5.
   ' Solve(x^2 + 1 = 26, -1000, 0) returns -5.
   ucDefineFunction "Native: Solve_(ByExpr Expr, a, b, ByHandle Var)", CodePtr(ucSolve)
   ucDefineSyntax "Solve({Expr} [, {a=-100000000} [, {b=100000000} [, {Var=x}]]]) " _
                + "::= Local({Var}, Solve_({Expr}, {a}, {b}, {Var}))"
   ucDefineSyntax "Solve({Left} = {Right} [, {etc}]) ::= Solve({Left}-({Right}) {etc: , {etc}})"

   ShowForm1 %HWND_Desktop
End Function
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** CallBacks **
'--------------------------------------------------------------------------------
CallBack Function ShowForm1Proc()
    Dim txt$, Discard As Long

    Select Case CbMsg
        Case %WM_Command
            Select Case CbCtl
                Case %IDC_btnEval
                    If CbCtlMsg = %BN_Clicked Then
                       ' ucEval() evaluates an expression and returns a numeric result.
                       ' ucEvalStr() can evaluate expressions of any data type (numeric, string, or other).
                       ' If the result is numeric ucEvalStr conveniently converts it to a string for you.
                       Control Get Text CbHndl, %IDC_cmbExpression To txt$
                       Control Set Text CbHndl, %IDC_txtResult, ucEvalStr(txt$)
                    End If
                Case %IDC_btnDefine
                    If CbCtlMsg = %BN_Clicked Then
                       Control Get Text CbHndl, %IDC_cmbDefinition To txt$

                       ' ucDefine can define a variable, function, operator, syntax construct,
                       ' constant, pattern, data type, and more.
                       '
                       ' Examples:
                       '
                       ' ucDefine "Var: MyVariable As String"
                       ' ucDefine "Func: Area(Length, Width) = Length * Width"
                       ' ucDefine "Op: 50 {x}%  :=  x / 100"   ' 50 is an arbitrary precedence level.
                       ' ucDefine "Syntax: {a} + {a} ::= 'Two {a}s are better than one {a}'"
                       ' ucDefine "Const: Pi = Atan(1) * 4"
                       ucDefine txt$
                    End If
                Case %IDC_btnSum
                    If CbCtlMsg = %BN_Clicked Then
                       Call SpeedTest(CbHndl)
                    End If
                Case %IDC_btnPlot
                    If CbCtlMsg = %BN_Clicked Then
                        Call PlotGraph(CbHndl)
                    End If
                Case %IDC_chkInvalidOp
                   ' If toggled, then an expression such as 0 / 0 raises an error.
                   ' If toggled again, then 0 / 0 returns NaN.
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_InvalidOp
                Case %IDC_chkDenormalOp
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_DenormalOp
                Case %IDC_chkDivisionBy0
                   ' If toggled, then 1 / 0 raises an error.
                   ' If toggled again, then 1 / 0 returns Inf.
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_ZeroDivide
                Case %IDC_chkOverflow
                   ' If toggled, then 100! ^ 150 raises an error.
                   ' If toggled again, then 100! ^ 150 returns Inf.
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_Overflow
                Case %IDC_chkUnderflow
                   ' If toggled, then (1/100!)^150 raises an error.
                   ' If toggled again, then (1/100!)^150 returns 0.
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_Underflow
                Case %IDC_chkPrecisionLoss
                   ' If toggled, an expression that cannot be represented in exact form
                   ' such as "1/3" will raise an error.
                   ' If toggled again, "1/3" returns the closest extended precision approximation.
                   ucFPU %uc_ToggleFPU, %uc_FPU_Mask_PrecisionLoss
                Case %IDC_cmbNumericFormat
                   Control Get Text CbHndl, %IDC_cmbNumericFormat To NumericFormat$
            End Select
    End Select

End Function
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Dialogs **
'--------------------------------------------------------------------------------
Function ShowForm1(ByVal hParent As Dword) As Long
    Local lRslt As Long
#PBForms Begin Dialog %IDD_Form1->->
   Local hDlg   As Dword
   Local hFont1 As Dword

   Dialog New hParent, "uCalc Fast Math Parser 3.0 PowerBASIC Demo", 168, _
      164, 430, 163, %WS_Popup Or %WS_Border Or %WS_DlgFrame Or %WS_SysMenu _
      Or %WS_ClipSiblings Or %WS_ClipChildren Or %WS_Visible Or %DS_3DLook _
      Or %DS_NoFailCreate Or %DS_SetFont, %WS_Ex_Windowedge Or _
      %WS_Ex_ControlParent Or %WS_Ex_AppWindow Or %WS_Ex_Left Or _
      %WS_Ex_LtrReading Or %WS_Ex_RightScrollbar, To hDlg
   Control Add TextBox,  hDlg, %IDC_txtSumMax, "100000", 365, 55, 54, 12
   Control Add TextBox,  hDlg, %IDC_txtSumExpression, "x^2+5*x-10", 280, 71, _
      139, 12
   Control Add TextBox,  hDlg, %IDC_txtPlotEq, "-sin(x)/2", 10, 60, 145, 12
   Control Add TextBox,  hDlg, %IDC_txtResult, "", 10, 19, 145, 12
   Control Add Button,   hDlg, %IDC_btnEval, "Evaluate", 115, 35, 38, 15
   Control Add Button,   hDlg, %IDC_btnDefine, "Define", 175, 25, 43, 16
   Control Add TextBox,  hDlg, %IDC_txtSumResult, "", 280, 86, 139, 11
   Control Add Button,   hDlg, %IDC_btnSum, "Start", 280, 100, 27, 16
   Control Add Label,    hDlg, %IDC_Label1, "Summation from 1 to", 286, 58, _
      75, 7
   Control Add Label,    hDlg, %IDC_lblElapsed, "Elapsed Time: 0 seconds", _
      315, 105, 102, 11
   Control Add Image,    hDlg, %IDC_Picture1, "", 10, 75, 145, 62, %WS_Child _
      Or %WS_Visible Or %WS_Border Or %SS_Bitmap Or %SS_CenterImage
   Control Add Button,   hDlg, %IDC_btnPlot, "Plot", 10, 140, 33, 16
   Control Add Label,    hDlg, %IDC_lblFPU, "FPU exception masks", 170, 60, _
      100, 10
   Control Add CheckBox, hDlg, %IDC_chkInvalidOp, "Invalid Op", 170, 70, 60, _
      10
   Control Add CheckBox, hDlg, %IDC_chkDenormalOp, "Denormal Op", 170, 80, _
      60, 10
   Control Add CheckBox, hDlg, %IDC_chkDivisionBy0, "Division By 0", 170, 90, _
      55, 10
   Control Add CheckBox, hDlg, %IDC_chkOverflow, "Overflow", 170, 100, 60, 10
   Control Add CheckBox, hDlg, %IDC_chkUnderflow, "Underflow", 170, 110, 60, _
      10
   Control Add CheckBox, hDlg, %IDC_chkPrecisionLoss, "Precision Loss", 170, _
      120, 60, 10
   Control Add ComboBox, hDlg, %IDC_cmbExpression, , 10, 5, 145, 155, _
      %WS_Child Or %WS_Visible Or %WS_TabStop Or %WS_VScroll Or _
      %CBS_DropDown, %WS_Ex_Left Or %WS_Ex_LtrReading Or _
      %WS_Ex_RightScrollbar
   Control Add ComboBox, hDlg, %IDC_cmbDefinition, , 175, 5, 245, 155, _
      %WS_Child Or %WS_Visible Or %WS_TabStop Or %WS_VScroll Or _
      %CBS_DropDown, %WS_Ex_Left Or %WS_Ex_LtrReading Or _
      %WS_Ex_RightScrollbar
   Control Add ComboBox, hDlg, %IDC_cmbNumericFormat, , 10, 35, 100, 80, _
      %WS_Child Or %WS_Visible Or %WS_TabStop Or %CBS_DropDown, %WS_Ex_Left _
      Or %WS_Ex_LtrReading Or %WS_Ex_RightScrollbar

   hFont1 = PBFormsMakeFont("MS Sans Serif", 8, 400, %TRUE, %FALSE, %FALSE, _
      %ANSI_CHARSET)

   Control Send hDlg, %IDC_lblFPU, %WM_SETFONT, hFont1, 0
#PBForms End Dialog

    Control Set Check hDlg, %IDC_chkInvalidOp, 1
    Control Set Check hDlg, %IDC_chkDenormalOp, 1
    Control Set Check hDlg, %IDC_chkDivisionBy0, 1
    Control Set Check hDlg, %IDC_chkOverflow, 1
    Control Set Check hDlg, %IDC_chkUnderflow, 1
    Control Set Check hDlg, %IDC_chkPrecisionLoss, 1

    Control Set Text hDlg, %IDC_cmbExpression, "3+4/5-8"
    Control Set Text hDlg, %IDC_cmbDefinition, "Var: MyVariable = 1234.5"
    Control Set Text hDlg, %IDC_cmbNumericFormat, "General Number"

' The following block of code auto-generated with uCalc Search/Replace beta #20.
' It inserted ComboBox Add hDlg, %IDC_cmb... (and quotes) around lists of text.
ComboBox Add hDlg, %IDC_cmbExpression, ".5 + 10"
ComboBox Add hDlg, %IDC_cmbExpression, "5*(((10+3)!-1) MOD 7)^2"
ComboBox Add hDlg, %IDC_cmbExpression, "((2.5+1)*(9-5.5/2)^1.5+COS(ATAN(1)*(3+1/3)))^2"
ComboBox Add hDlg, %IDC_cmbExpression, "MyArea(3,4)"
ComboBox Add hDlg, %IDC_cmbExpression, "MyArea(-3,4)"
ComboBox Add hDlg, %IDC_cmbExpression, "IIF(1 > 2, 1/0, 3)"
ComboBox Add hDlg, %IDC_cmbExpression, "IIF(1 > 2, ""True"", ""False"")"
ComboBox Add hDlg, %IDC_cmbExpression, "IIF(1 > 2, MyMsgBox(""Yes""), MyMsgBox(""No""))"
ComboBox Add hDlg, %IDC_cmbExpression, "MyIIF(1 > 2, 1/0, 3)"
ComboBox Add hDlg, %IDC_cmbExpression, "MyIIF(1 > 2, ""True"", ""False"")"
ComboBox Add hDlg, %IDC_cmbExpression, "MyIIF(1 > 2, MyMsgBox(""Yes""), MyMsgBox(""No""))"
ComboBox Add hDlg, %IDC_cmbExpression, "Solve(x^2 + 1 = 26)"
ComboBox Add hDlg, %IDC_cmbExpression, "Solve(x^2 + 1 = 26, -1000, 0)"
ComboBox Add hDlg, %IDC_cmbExpression, "Sum(2*x + 5, 1, 10)"
ComboBox Add hDlg, %IDC_cmbExpression, """Hello "" + ""world"""
ComboBox Add hDlg, %IDC_cmbExpression, """This"" > ""That"""
ComboBox Add hDlg, %IDC_cmbExpression, "'This' < 'That'"
ComboBox Add hDlg, %IDC_cmbExpression, "Asc(""D"")"
ComboBox Add hDlg, %IDC_cmbExpression, "#hAE.B1 + #b1110.1001"
ComboBox Add hDlg, %IDC_cmbExpression, "NonNativeFunc(2.5, 10.3, 6)"
ComboBox Add hDlg, %IDC_cmbExpression, "MsgBox(""Please send feedback at www.ucalc.com"")"
ComboBox Add hDlg, %IDC_cmbExpression, "MsgBox(""Something"", 2)"
ComboBox Add hDlg, %IDC_cmbExpression, "MsgBox(""Great"",, ""New Title"")"
ComboBox Add hDlg, %IDC_cmbExpression, "MyAverage(1,2,3,4,5,6)"
ComboBox Add hDlg, %IDC_cmbExpression, "MyLeft(""Hello There"", 7)"
ComboBox Add hDlg, %IDC_cmbExpression, "MsgBox(""First box"") ; MsgBox(""Second Box"",, ""Title"") ; 123"
ComboBox Add hDlg, %IDC_cmbExpression, """Hello "" * 3"

ComboBox Add hDlg, %IDC_cmbDefinition, "Var: x = 123"
ComboBox Add hDlg, %IDC_cmbDefinition, "Var: MyString As String = ""Hello"""
ComboBox Add hDlg, %IDC_cmbDefinition, "Var: StringB = ""StringB is automatically defined as string because of quotes"""
ComboBox Add hDlg, %IDC_cmbDefinition, "Var: MyInt As Long = 123"
ComboBox Add hDlg, %IDC_cmbDefinition, "Const: Pi = Atan(1) * 4"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: f(x) = x^2"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: g(x, y) = x * y"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Twice(x As Double) As Double = x * 2"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Twice(x As String) As String = x + x"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Area(x) = x ^ 2"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Area(x, y) = x * y"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Volume(r, h=0) = IIf(h==0, pi*r^3*4/3, pi*r^2*h/3)"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Factorial(x) = IIf(x>1, x*Factorial(x-1), 1)"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Fib(n) = IIf(n < 2, n, Fib(n-1) + Fib(n - 2))"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: Test(x As String) As String = MyMsgBox(x) ; x + x"
ComboBox Add hDlg, %IDC_cmbDefinition, "Func: TriangleWave(x) = (8/pi^2)*Sum((-1)^((n-1)/2)/(n^2)*Sin(n*x), 1, 100, 2, n)"
ComboBox Add hDlg, %IDC_cmbDefinition, "Op: Precedence(""*"") {x} ShiftLeft {y} := x * 2^y"
ComboBox Add hDlg, %IDC_cmbDefinition, "Op: !{x}  :=  x == 0"
ComboBox Add hDlg, %IDC_cmbDefinition, "Op: {x}%  :=  x / 100"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: This sentence ::= ""Something Else"""
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: {'&b'}{Number:'[0-1]+'} ::= BaseConvert('{Number}', 2)"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: Reverse({first}) ::= '{first}'"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: Reverse({first}, {rest}) ::= Reverse({rest}) + ', {first}'"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: MySum({x}) ::= {x}"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: MySum({x}, {y}) ::= ({x} + MySum({y}))"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: CountArgs({x})      ::= 1"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: CountArgs({x}, {y}) ::= ~Eval(1 + CountArgs({y}))"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: Average({args}) ::= MySum({args}) / CountArgs({args})"
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: {a} & {b} ::= ""{a}s and {b}s are different"""
ComboBox Add hDlg, %IDC_cmbDefinition, "Syntax: {a} & {a} ::= ""Two {a}s are better than one {a}"""
ComboBox Add hDlg, %IDC_cmbDefinition, "Macro: Plus(x) = x + x"

ComboBox Add hDlg, %IDC_cmbNumericFormat, "General Number"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "Currency"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "Fixed"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "Standard"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "Percent"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "Scientific"
ComboBox Add hDlg, %IDC_cmbNumericFormat, "##.##"

    Dialog Show Modal hDlg, Call ShowForm1Proc To lRslt

#PBForms Begin CleanUp %IDD_Form1
   DeleteObject hFont1
#PBForms End CleanUp

    Function = lRslt
End Function
'--------------------------------------------------------------------------------
