Attribute VB_Name = "DemoVB"
Sub Main()
  ChDir App.Path
  Form1.Show
End Sub

Function MyErrorHandler(ByVal t As Long) As Long
   Static AlreadyDisplayedOnce As Long

   If AlreadyDisplayedOnce = ucFalse Then
      MsgBox "Error Handler message: " + ucErrorMessage(0, t) + Chr$(13) _
         + "Offending symbol: " + ucErrorSymbol(t) + Chr$(13) _
         + "Error Location: " + Str$(ucErrorLocation(t)) + Chr$(13) + Chr(13) _
         + "This message box won't be displayed for the next error." + Chr$(13) _
         + "Remove 'AlreadyDisplayedOnce = ucTrue' in the demo source code to change this."
   End If

   ' Remove the line below if you want the message box to be
   ' displayed every time there's an error.
   AlreadyDisplayedOnce = ucTrue
   MyErrorHandler = ucAbort
End Function

Sub MyNumericFormat(ByVal Expr As Long)
   Dim ValueAsString As String

   ValueAsString = ucArgStr(Expr, 1)
   if ValueAsString = "Inf" or ValueAsString = "NaN" _
   Then ucReturnStr Expr, ValueAsString _
   Else ucReturnStr Expr, Format$(Val(ValueAsString), Form1.cmbNumericFormat)
End Sub

Sub MyArea(ByVal Expr As Long)
   Dim MyLength As Double, MyWidth As Double

   MyLength = ucArg(Expr, 1)
   MyWidth = ucArg(Expr, 2)
   
   If MyLength < 0 Then ucRaiseErrorMessage Expr, "Length cannot be negative"
   If MyWidth < 0 Then ucRaiseErrorMessage Expr, "Width cannot be negative"

   ucReturn Expr, MyLength * MyWidth
End Sub

Function NonNativeFunc(ByVal a As Double, ByRef b As Long, ByVal c As Byte) As Double
   NonNativeFunc = a + b + c
End Function

Sub MyIIF_Numeric(ByVal Expr As Long)
   Dim Condition As Double, TruePart As Long, FalsePart As Long
   
   Condition = ucArg(Expr, 1)
   TruePart = ucArgHandle(Expr, 2)
   FalsePart = ucArgHandle(Expr, 3)
   
   If Condition <> 0 _
   Then ucReturn Expr, ucEvaluate(TruePart) _
   Else ucReturn Expr, ucEvaluate(FalsePart)
End Sub
 
Sub MyIIF_String(ByVal Expr As Long)
   Dim Condition As Double, TruePart As Long, FalsePart As Long
   
   Condition = ucArg(Expr, 1)
   TruePart = ucArgHandle(Expr, 2)
   FalsePart = ucArgHandle(Expr, 3)
   
   If Condition <> 0 _
   Then ucReturnStr Expr, ucEvaluateStr(TruePart) _
   Else ucReturnStr Expr, ucEvaluateStr(FalsePart)
End Sub

Sub Native_MsgBox(ByVal Expr As Long)
   ucReturn Expr, MsgBox(ucArgStr(Expr, 1), ucArg(Expr, 2), ucArgStr(Expr, 3))
End Sub

Function nn_MsgBox(ByRef Prompt As String, ByVal Buttons As Long, ByRef Title As String) As Long
   nn_MsgBox = MsgBox(Prompt, Buttons, Title)
End Function

Sub MyAverage(ByVal Expr As Long)
   Dim x As Long, Total As Double

   For x = 1 To ucArgCount(Expr)
      Total = Total + ucArg(Expr, x)
   Next

   ucReturn Expr, Total / ucArgCount(Expr)
End Sub

Sub MyLeft(ByVal Expr As Long)
    ucReturnStr Expr, Left$(ucArgStr(Expr, 1), ucArg(Expr, 2))
End Sub

Sub StringRepeat(ByVal Expr As Long)
   Dim x As Long, TotalString As String

   For x = 1 To ucArg(Expr, 2)
      TotalString = TotalString + ucArgStr(Expr, 1)
   Next

   ucReturnStr Expr, TotalString
End Sub

Sub ucSum(ByVal Expr As Long)
   Dim Expression As Long, VarHandle As Long
   Dim Start As Long, Finish As Long, sStep As Long
   Dim x As Double, Total As Double

   Expression = ucArgHandle(Expr, 1)
   Start = ucArg(Expr, 2)
   Finish = ucArg(Expr, 3)
   sStep = ucArg(Expr, 4)
   VarHandle = ucArgHandle(Expr, 5)

   For x = Start To Finish Step sStep
      ucSetVariableValue VarHandle, x
      Total = Total + ucEvaluate(Expression)
   Next

   ucReturn Expr, Total
End Sub

Sub ucSolve(ByVal Expr As Long)
   Dim Expression As Long, Variable As Long, Iterations As Long
   Dim a As Double, b As Double, fa As Double, fb As Double
   Dim Value As Double, tmp As Double

   Expression = ucArgHandle(Expr, 1)
   a = ucArg(Expr, 2)
   b = ucArg(Expr, 3)
   Variable = ucArgHandle(Expr, 4)

   ucSetVariableValue Variable, a: fa = ucEvaluate(Expression)
   ucSetVariableValue Variable, b: fb = ucEvaluate(Expression)
   
   If fb < fa Then tmp = a: a = b: b = tmp   'swap a, b
    
   Do While Abs(b - a) > 0.000000000000001
      ucSetVariableValue Variable, (a + b) / 2
      
      Value = ucEvaluate(Expression)
      
      If Value = 0 Then a = (a + b) / 2: Exit Do

      If Value < 0 _
      Then a = (a + b) / 2 _
      Else b = (a + b) / 2

      Iterations = Iterations + 1
      If Iterations = 100 Then Exit Do
   Loop
   
   If Abs(Value) > 0.0000000001 Then ucRaiseErrorMessage Expr, "Solution not found"

   ucReturn Expr, a
End Sub

