VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "uCalc Fast Math Parser 3  demo for VB 6"
   ClientHeight    =   3795
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   9675
   LinkTopic       =   "Form1"
   ScaleHeight     =   3795
   ScaleWidth      =   9675
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox cmbDefinition 
      Height          =   315
      ItemData        =   "DemoVB.frx":0000
      Left            =   4440
      List            =   "DemoVB.frx":0061
      TabIndex        =   21
      Text            =   "Var: MyVariable = 1234.5"
      Top             =   120
      Width           =   5055
   End
   Begin VB.ComboBox cmbNumericFormat 
      Height          =   315
      ItemData        =   "DemoVB.frx":05A0
      Left            =   120
      List            =   "DemoVB.frx":05B9
      TabIndex        =   20
      Text            =   "General Number"
      Top             =   840
      Width           =   2295
   End
   Begin VB.ComboBox cmbExpression 
      Height          =   315
      ItemData        =   "DemoVB.frx":0604
      Left            =   120
      List            =   "DemoVB.frx":0659
      TabIndex        =   19
      Text            =   "3+4/5-8"
      Top             =   120
      Width           =   3255
   End
   Begin VB.CheckBox chkPrecisionLoss 
      Caption         =   "Precision Loss"
      Height          =   255
      Left            =   3600
      TabIndex        =   18
      Top             =   3000
      Value           =   1  'Checked
      Width           =   1455
   End
   Begin VB.CheckBox chkUnderflow 
      Caption         =   "Underflow"
      Height          =   255
      Left            =   3600
      TabIndex        =   17
      Top             =   2760
      Value           =   1  'Checked
      Width           =   1215
   End
   Begin VB.CheckBox chkOverflow 
      Caption         =   "Overflow"
      Height          =   255
      Left            =   3600
      TabIndex        =   16
      Top             =   2520
      Value           =   1  'Checked
      Width           =   1215
   End
   Begin VB.CheckBox chkDivisionBy0 
      Caption         =   "Division by 0"
      Height          =   255
      Left            =   3600
      TabIndex        =   15
      Top             =   2280
      Value           =   1  'Checked
      Width           =   1455
   End
   Begin VB.CheckBox chkDenormalOp 
      Caption         =   "Denormal Op"
      Height          =   255
      Left            =   3600
      TabIndex        =   14
      Top             =   2040
      Value           =   1  'Checked
      Width           =   1455
   End
   Begin VB.CheckBox chkInvalidOp 
      Caption         =   "Invalid Op"
      Height          =   255
      Left            =   3600
      TabIndex        =   13
      Top             =   1800
      Value           =   1  'Checked
      Width           =   1455
   End
   Begin VB.TextBox txtPlotEq 
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Text            =   "-sin(x)/2"
      Top             =   1560
      Width           =   3135
   End
   Begin VB.CommandButton btnPlot 
      Caption         =   "Plot"
      Height          =   375
      Left            =   120
      TabIndex        =   11
      Top             =   3240
      Width           =   735
   End
   Begin VB.PictureBox Picture1 
      Height          =   1215
      Left            =   120
      ScaleHeight     =   1155
      ScaleWidth      =   3075
      TabIndex        =   10
      Top             =   1920
      Width           =   3135
   End
   Begin VB.TextBox txtSumMax 
      Height          =   285
      Left            =   8160
      TabIndex        =   0
      Text            =   "100000"
      Top             =   1890
      Width           =   1215
   End
   Begin VB.CommandButton btnSum 
      Caption         =   "Start"
      Height          =   375
      Left            =   6240
      TabIndex        =   7
      Top             =   3000
      Width           =   615
   End
   Begin VB.TextBox txtSumResult 
      Height          =   285
      Left            =   6240
      TabIndex        =   6
      Top             =   2640
      Width           =   3135
   End
   Begin VB.TextBox txtSumExpression 
      Height          =   285
      Left            =   6240
      TabIndex        =   1
      Text            =   "x^2+5*x-10"
      Top             =   2280
      Width           =   3135
   End
   Begin VB.CommandButton btnDefine 
      Caption         =   "Define"
      Height          =   375
      Left            =   4440
      TabIndex        =   5
      Top             =   480
      Width           =   975
   End
   Begin VB.CommandButton btnEval 
      Caption         =   "Evaluate"
      Height          =   375
      Left            =   2520
      TabIndex        =   4
      Top             =   840
      Width           =   855
   End
   Begin VB.TextBox txtResult 
      Height          =   285
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   3255
   End
   Begin VB.Label lblFPU 
      Caption         =   "FPU exception masks"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3600
      TabIndex        =   12
      Top             =   1560
      Width           =   1815
   End
   Begin VB.Label lblElapsed 
      Caption         =   "Elapsed Time: 0 seconds"
      Height          =   255
      Left            =   7080
      TabIndex        =   9
      Top             =   3000
      Width           =   2295
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Summation from 1 to"
      Height          =   375
      Left            =   6240
      TabIndex        =   8
      Top             =   1920
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub btnDefine_Click()
   ' ucDefine can define a variable, function, operator, syntax construct,
   ' constant, pattern, data type, and more.
   '
   ' Examples:
   '
   ' ucDefine "Var: MyVariable As String"
   ' ucDefine "Func: Area(Length, Width) = Length * Width"
   ' ucDefine "Op: 50 {x}%  :=  x / 100"   ' 50 is an arbitrary precedence level.
   ' ucDefine "Syntax: {a} + {a} ::= 'Two {a}s are better than one {a}'"
   ' ucDefine "Const: Pi = Atan(1) * 4"
   ucDefine cmbDefinition
End Sub

Private Sub btnEval_Click()
   ' ucEval() evaluates an expression and returns a numeric result.
   ' ucEvalStr() can evaluate expressions of any data type (numeric, string, or other).
   ' If the result is numeric ucEvalStr conveniently converts it to a string for you.
   txtResult = ucEvalStr(cmbExpression)
End Sub

Private Sub chkInvalidOp_Click()
   ' If toggled, then an expression such as 0 / 0 raises an error.
   ' If toggled again, then 0 / 0 returns NaN.
   ucFPU uc_ToggleFPU, uc_FPU_Mask_InvalidOp
End Sub

Private Sub chkDenormalOp_Click()
   ucFPU uc_ToggleFPU, uc_FPU_Mask_DenormalOp
End Sub

Private Sub chkDivisionBy0_Click()
   ' If toggled, then 1 / 0 raises an error.
   ' If toggled again, then 1 / 0 returns Inf.
   ucFPU uc_ToggleFPU, uc_FPU_Mask_ZeroDivide
End Sub

Private Sub chkOverflow_Click()
   ' If toggled, then 100! ^ 150 raises an error.
   ' If toggled again, then 100! ^ 150 returns Inf.
   ucFPU uc_ToggleFPU, uc_FPU_Mask_Overflow
End Sub

Private Sub chkUnderflow_Click()
   ' If toggled, then (1/100!)^150 raises an error.
   ' If toggled again, then (1/100!)^150 returns 0.
   ucFPU uc_ToggleFPU, uc_FPU_Mask_Underflow
End Sub

Private Sub chkPrecisionLoss_Click()
   ' If toggled, an expression that cannot be represented in exact form
   ' such as "1/3" will raise an error.
   ' If toggled again, "1/3" returns the closest extended precision approximation.
   ucFPU uc_ToggleFPU, uc_FPU_Mask_PrecisionLoss
End Sub

Private Sub btnPlot_Click()
    Dim x As Double, EqHandle As Long, xHandle As Long
    
    Picture1.Cls
    Picture1.Scale (-10, 2)-(10, -2)
    Picture1.PSet (-10, 0)

    xHandle = ucDefineVariable("x")
    EqHandle = ucParse(txtPlotEq)
    
    For x = -10 To 10 Step 0.125
        ucSetVariableValue xHandle, x
        Picture1.Line -(x, ucEvaluate(EqHandle))
    Next
    
    ucReleaseItem EqHandle
    ucReleaseItem xHandle
End Sub

Private Sub btnSum_Click()
   Dim ExprHandle As Long, xHandle As Long
   Dim x As Double, SumTotal As Double
   Dim TimerStart As Single, TimerEnd As Single
   
   xHandle = ucDefineVariable("x")
   ExprHandle = ucParse(txtSumExpression)
   TimerStart = Timer
   
   For x = 1 To txtSumMax
      ucSetVariableValue xHandle, x
      SumTotal = SumTotal + ucEvaluate(ExprHandle)
   Next
   
   TimerEnd = Timer - TimerStart
   txtSumResult = Str$(SumTotal)
   lblElapsed = "Elapsed Time: " + Format$(TimerEnd, "0.00") + " seconds"
   
   ucReleaseItem ExprHandle
   ucReleaseItem xHandle
End Sub

Private Sub Form_Load()
   ' The definitions here are for "callback" routines.
   ' Each line ends with the address of a routine, using AddressOf.
   ' The actual code for these routines can be found in the DemoVB.Bas file.
   ' Do a search there for MyErrorHandler, for instance, to see the actual code for it.

   ucSetOutput AddressOf MyNumericFormat
   
   ' The MyErrorHandler() function will be called whenever and wherever an
   ' error (such as "Syntax Error") is raised.
   ucAddErrorHandler AddressOf MyErrorHandler

   ' Native callback definitions, which start with "Native: " are recommended for
   ' speed, and for routines that use uCalc's default numeric and string types.
   ' MyArea() returns the product of multiplying the two arguments.
   ' MyLeft() returns the left-most characters of a string.  The second argument represents the number of characters.
   ' MsgBox() displays a message box.  The 1st argument is required.  The others are optional.
   ucDefineFunction "Native: MyArea(Length, Width)", AddressOf MyArea
   ucDefineFunction "Native: MyLeft(Text As String, Count) As String", AddressOf MyLeft
   ucDefineFunction "Native: MyMsgBox(Prompt As String, Buttons = 0, Title As String = 'uCalc')", AddressOf Native_MsgBox
   ucDefineSyntax "MsgBox ::= MyMsgBox"

   ' The three consecutive dots "..." mean that MyAverage can take any number of arguments
   ' (however, because "x" is specified, there must be at least one argument).
   ucDefineFunction "Native: MyAverage(x ...)", AddressOf MyAverage

   ' Two versions of MyIIF can co-exist peacefully with the same name because
   ' they are defined with different argument types (numeric vs string).
   ' By passing the last two arguments ByExpr, the callback can chose to evaluate only one of of them.
   ucDefineFunction "Native: MyIIf(cond, ByExpr TruePart, ByExpr FalsePart)", AddressOf MyIIF_Numeric
   ucDefineFunction "Native: MyIIf(cond, ByExpr TruePart As String, ByExpr FalsePart As String) As String", AddressOf MyIIF_String

   ' The following defines the "*" operator so that MyString * n returns MyString repeated n times.
   ' For instance, "He " * 3, would return "He He He".  20 represents the precedence level.  It is
   ' arbitrarily set at the same level as that of the "*" multiplication operator defined in uCalcVB.Bas.
   ucDefineOperator "Native: Precedence('*') {MyString As String} * {Number} As String", AddressOf StringRepeat

   ' Non-native callbacks are intended for routines that were not created with
   ' uCalc in mind, such as the Windows API, or other pre-existing DLL routines.
   ' It is convenient (no need to adapt the routines; all you need is a function
   ' address), but not as fast as Native callbacks.
   ' NonNativeFunc() simply adds the three arguments.
   ' nn_MsgBox is a Non-Native version of MsgBox, which displays a message box.
   ' Notice that uCalc's WideString is what matches VB's String in non-native callbacks.
   ucDefineFunction "NonNativeFunc(ByVal a As Double, ByRef b As Long, ByVal c As Byte) As Double", AddressOf NonNativeFunc
   ucDefineFunction "nn_MsgBox(ByRef Prompt As WideString, ByVal Buttons As Long = 0, ByRef Title As WideString = 'uCalc') As Long", AddressOf nn_MsgBox

   ' This definition is for a summation.  See the callback ucSum() routine for the
   ' actual code, which runs a loop that adds up the total for the expression in
   ' the first argument a number of times based on the second and third arguments.
   ' For instance Sum(g^2+1, 1, 5, 1, g) returns 60 and Sum(x^2, 1, 10) returns 385.
   ' The last two arguments are optional, so they default to 1 and x if omitted.
   '
   ' The first argument is passed "ByExpr".  So instead of being evaluated before
   ' being passed to the callback the way an ordinary argument would be, a handle
   ' for the expression is passed so that the callback can evaluate it (in this
   ' case numerous times).
   '
   ' The last argument is passed "ByHandle".  This causes the callback to receive
   ' a handle for the variable being passed, in such a way that it can be linked to
   ' the summation counter, and integrated into the expression in the first argument.
   '
   ' The actual function being defined is Sum_().  Then a syntax construct named
   ' Sum() is defined in such a way that the last argument gets defined as a local
   ' variable.  So if you evaluate Sum(x^2, 5, 10, 1, x), the local "x" in this
   ' expression will not interfere with a pre-existing variable named x.  Also you
   ' do not need to declare a variable ahead of time to use it as a counter for Sum().
   ucDefineFunction "Native: Sum_(ByExpr Expr, Start, Finish, Step, ByHandle Var)", AddressOf ucSum
   ucDefineSyntax "Sum({Expr}, {Start}, {Finish} [, {Step=1} [, {Var=x}]])" _
                + "::= Local({Var}, Sum_({Expr}, {Start}, {Finish}, {Step}, {Var}))"

   ' The following routine solves an equation.
   ' The callback code is based on the Bisection Method algorithm.
   ' The concept here is very similar to that of Sum().
   ' Two syntax constructs are defined.  The second one rearranges the equation
   ' if it includes an equal sign.
   ' For instance Solve(x^2 = 9+x) becomes Solve(x^2 - (9+x))
   ' Solve(x^2 + 1 = 26) returns 5.
   ' Solve(x^2 + 1 = 26, -1000, 0) returns -5.
   ucDefineFunction "Native: Solve_(ByExpr Expr, a, b, ByHandle Var)", AddressOf ucSolve
   ucDefineSyntax "Solve({Expr} [, {a=-100000000} [, {b=100000000} [, {Var=x}]]]) " _
                + "::= Local({Var}, Solve_({Expr}, {a}, {b}, {Var}))"
   ucDefineSyntax "Solve({Left} = {Right} [, {etc}]) ::= Solve({Left}-({Right}) {etc: , {etc}})"
End Sub

