﻿Imports Microsoft.VisualBasic
Public Class Form1

    Public g As Graphics
    Public myPen As New Pen(Color.Black)

    Private Sub CartesianLineTo(ByVal x As Single, ByVal y As Single)
        Dim NewX As Integer, NewY As Integer
        Static OldX As Integer, OldY As Integer

        If x = -10 Then OldX = 0 : OldY = 0

        NewX = PictureBox1.Size.Width * (x + 10) / 20
        NewY = PictureBox1.Size.Height * (2 - y) / 4

        g.DrawLine(myPen, OldX, OldY, NewX, NewY)

        OldX = NewX
        OldY = NewY
    End Sub

    Private Sub btnEval_Click(sender As System.Object, e As System.EventArgs) Handles btnEval.Click
        ' ucEval() evaluates an expression and returns a numeric result.
        ' ucEvalStr() can evaluate expressions of any data type (numeric, string, or other).
        ' If the result is numeric ucEvalStr conveniently converts it to a string for you.

        ' txtResult.Text = ucEval(cmbExpression.Text) ' Note: ucEval() will also work here but ucEvalStr() is more flexible.

        txtResult.Text = ucEvalStr(cmbExpression.Text)
    End Sub

    Private Sub btnDefine_Click(sender As System.Object, e As System.EventArgs) Handles btnDefine.Click
        ' ucDefine can define a variable, constant, function, operator,
        ' syntax construct, pattern, data type, and more.
        ucDefine(cmbDefine.Text)
    End Sub


    ' The definitions in Form1_Load are for "callback" routines.
    ' The actual code body for these routines can be found in the MyFunctions.vb file.
    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        g = PictureBox1.CreateGraphics
        For x = 0 To 5 : chkFPU.SetItemCheckState(x, CheckState.Checked) : Next

        ' Note: In the current 64-bit implementation of uCalc, functions that involve a function address or delegate,
        '       such as the ones in this Form1_Load section, are ignored.

        ' The MyErrorHandler() function will be called whenever and wherever an error (such as "Syntax Error") is raised.

        Static d_MyErrorHandler As ucErrorHandlerDelegate = AddressOf MyErrorHandler
        ucAddErrorHandler(d_MyErrorHandler)

        Static d_MyNumericFormat As ucFunctionDelegate = AddressOf MyNumericFormat
        ucSetOutput(d_MyNumericFormat)

        ' MyArea() returns the product of multiplying the two arguments.
        ' MyLeft() returns the left-most characters of a string.  The second argument represents the number of characters.
        ' MsgBox() displays a message box.  The 1st argument is required.  The others are optional.

        Static d_MyArea As ucFunctionDelegate = AddressOf MyArea
        ucDefineFunction("Native: MyArea(Length, Width)", d_MyArea)

        Static d_MyLeft As ucFunctionDelegate = AddressOf MyLeft
        ucDefineFunction("Native: MyLeft(Text As String, Count) As String", d_MyLeft)

        Static d_Native_MsgBox As ucFunctionDelegate = AddressOf Native_MsgBox
        ucDefineFunction("Native: MyMsgBox(Prompt As String, Buttons = 0, Title As String = 'uCalc')", d_Native_MsgBox)
        ucDefineSyntax("MsgBox ::= MyMsgBox")

        ' The three consecutive dots "..." mean that MyAverage can take any number of arguments
        ' (however, because "x" is specified, there must be at least one argument).

        Static d_MyAverage As ucFunctionDelegate = AddressOf MyAverage
        ucDefineFunction("Native: MyAverage(x ...)", d_MyAverage)

        ' Two versions of MyIIF can co-exist peacefully with the same name because
        ' they are defined with different argument types (numeric vs string).
        ' By passing the last two arguments ByExpr, the callback can chose to evaluate just one of of them.

        Static d_MyIIF_Numeric As ucFunctionDelegate = AddressOf MyIIF_Numeric
        ucDefineFunction("Native: MyIIf(cond, ByExpr TruePart, ByExpr FalsePart)", d_MyIIF_Numeric)

        Static d_MyIIF_String As ucFunctionDelegate = AddressOf MyIIF_String
        ucDefineFunction("Native: MyIIf(cond, ByExpr TruePart As String, ByExpr FalsePart As String) As String", d_MyIIF_String)

        ' The following defines the "*" operator so that MyString * n returns MyString repeated n times.
        ' For instance, "He " * 3, would return "He He He".  It is arbitrarily set at the same precedence
        ' level as that of the "*" multiplication operator.
        Static d_StringRepeat As ucFunctionDelegate = AddressOf StringRepeat
        ucDefineOperator("Native: Precedence('*') {MyString As String} * {Number} As String", d_StringRepeat)

        ' This definition is for a summation.  See the callback ucSum() routine for the
        ' actual code, which runs a loop that adds up the total for the expression in
        ' the first argument a number of times based on the second and third arguments.
        ' For instance Sum(g^2+1, 1, 5, 1, g) returns 60 and Sum(x^2, 1, 10) returns 385.
        ' The last two arguments are optional, so they default to 1 and x if omitted.
        '
        ' The first argument is passed "ByExpr".  So instead of being evaluated before
        ' being passed to the callback the way an ordinary argument would be, a handle
        ' for the expression is passed so that the callback can evaluate it (in this
        ' case numerous times).
        '
        ' The last argument is passed "ByHandle".  This causes the callback to receive
        ' a handle for the variable being passed, in such a way that it can be linked to
        ' the summation counter and integrated into the expression in the first argument.
        '
        ' The actual function being defined is Sum_().  Then a syntax construct named
        ' Sum() is defined in such a way that the last argument gets defined as a local
        ' variable.  So if you evaluate Sum(x^2, 5, 10, 1, x), the local "x" in this
        ' expression will not interfere with a pre-existing variable named x.  Also you
        ' do not need to declare a variable ahead of time to use it as a counter for Sum().

        Static d_ucSum As ucFunctionDelegate = AddressOf ucSum
        ucDefineFunction("Native: Sum_(ByExpr Expr, Start, Finish, Step, ByHandle Var)", d_ucSum)
        ucDefineSyntax("Sum({Expr}, {Start}, {Finish} [, {Step=1} [, {Var=x}]])" _
                     + "::= Local({Var}, Sum_({Expr}, {Start}, {Finish}, {Step}, {Var}))")

        ' The following routine solves an equation.
        ' The callback code is based on the Bisection Method algorithm.
        ' The concept here is very similar to that of Sum().
        ' Two syntax constructs are defined.  The second one rearranges the equation
        ' if it includes an equal sign.
        ' For instance Solve(x^2 = 9+x) becomes Solve(x^2 - (9+x))
        ' Solve(x^2 + 1 = 26) returns 5.
        ' Solve(x^2 + 1 = 26, -1000, 0) returns -5.

        Static d_ucSolve As ucFunctionDelegate = AddressOf ucSolve
        ucDefineFunction("Native: Solve_(ByExpr Expr, a, b, ByHandle Var)", d_ucSolve)
        ucDefineSyntax("Solve({Expr} [, {a=-100000000} [, {b=100000000} [, {Var=x}]]]) " _
                     + "::= Local({Var}, Solve_({Expr}, {a}, {b}, {Var}))")
        ucDefineSyntax("Solve({Left} = {Right} [, {etc}]) ::= Solve({Left}-({Right}) {etc: , {etc}})")

    End Sub

    Private Sub btnPlot_Click(sender As System.Object, e As System.EventArgs) Handles btnPlot.Click
        Dim x As Double, EquationHandle As Integer, VariableHandle As Integer

        g.Clear(System.Drawing.SystemColors.Control)

        VariableHandle = ucDefineVariable("x")
        EquationHandle = ucParse(txtPlot.Text)

        For x = -10 To 10 Step 0.125
            ucSetVariableValue(VariableHandle, x)
            CartesianLineTo(x, ucEvaluate(EquationHandle))
        Next

        ucReleaseItem(EquationHandle)
        ucReleaseItem(VariableHandle)
    End Sub

    Private Sub btnSummation_Click(sender As System.Object, e As System.EventArgs) Handles btnSummation.Click
        Dim ExpressionHandle As Integer, VariableHandle As Integer
        Dim x As Double, SumTotal As Double
        Dim TimerStart As Single, TimerEnd As Single

        VariableHandle = ucDefineVariable("x")
        ExpressionHandle = ucParse(txtSumExpression.Text)
        TimerStart = Timer()

        For x = 1 To CInt(txtSumMax.Text)
            ucSetVariableValue(VariableHandle, x)
            SumTotal = SumTotal + ucEvaluate(ExpressionHandle)
        Next

        TimerEnd = Timer() - TimerStart
        txtSumResult.Text = SumTotal.ToString
        lblElapsed.Text = "Elapsed Time: " & Format(TimerEnd, "0.00") & " seconds"

        ucReleaseItem(ExpressionHandle)
        ucReleaseItem(VariableHandle)
    End Sub

    
    Private Sub chkFPU_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles chkFPU.SelectedIndexChanged
        Select Case chkFPU.SelectedIndex
            Case 0 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_InvalidOp)
            Case 1 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_DenormalOp)
            Case 2 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_ZeroDivide)
            Case 3 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_Overflow)
            Case 4 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_Underflow)
            Case 5 : ucFPU(uc_ToggleFPU, uc_FPU_Mask_PrecisionLoss)
        End Select
    End Sub
End Class
