﻿Public Module MyFunctions
    Function MyErrorHandler(ByVal t As Integer) As Integer
        Static AlreadyDisplayedOnce As Integer

        If AlreadyDisplayedOnce = ucFalse Then
            MsgBox("See MyErrorHandler for the source code for this uCalc error handler." + vbCr + vbCr _
                   + "Bad expression: " + ucErrorExpression(t) + vbCr _
                   + "Error handler message: " + ucErrorMessage(0, t) + vbCr _
                   + "Offending symbol: " + ucErrorSymbol(t) + vbCr _
                   + "Error Location: " + Str(ucErrorLocation(t)) + vbCr + vbCr _
                   + "This message box won't be displayed for the next error." + vbCr _
                   + "Remove 'AlreadyDisplayedOnce = ucTrue' in the demo source code to change this.")

        End If

        ' Remove the line below if you want the message box to be
        ' displayed every time there's an error.
        AlreadyDisplayedOnce = ucTrue
        MyErrorHandler = ucAbort
    End Function

    Public Sub MyNumericFormat(ByVal Expr As Integer)
        Dim Value As String = ucArgStr(Expr, 1)
        If Value = "Inf" Or Value = "NaN" Then ucReturnStr(Expr, Value) Else ucReturnStr(Expr, Format$(Val(Value), Form1.cmbNumericFormat.Text))
    End Sub

    Public Sub MyArea(ByVal Expr As Integer)
        Dim MyLength As Double, MyWidth As Double

        MyLength = ucArg(Expr, 1)
        MyWidth = ucArg(Expr, 2)

        If MyLength < 0 Then ucRaiseErrorMessage(Expr, "Length cannot be negative")
        If MyWidth < 0 Then ucRaiseErrorMessage(Expr, "Width cannot be negative")

        ucReturn(Expr, MyLength * MyWidth)
    End Sub

    Sub MyIIF_Numeric(ByVal Expr As Integer)
        Dim Condition As Double, TruePart As Integer, FalsePart As Integer

        Condition = ucArg(Expr, 1)
        TruePart = ucArgHandle(Expr, 2)
        FalsePart = ucArgHandle(Expr, 3)

        If Condition <> 0 Then
            ucReturn(Expr, ucEvaluate(TruePart))
        Else
            ucReturn(Expr, ucEvaluate(FalsePart))
        End If
    End Sub

    Sub MyIIF_String(ByVal Expr As Integer)
        Dim Condition As Double, TruePart As Integer, FalsePart As Integer

        Condition = ucArg(Expr, 1)
        TruePart = ucArgHandle(Expr, 2)
        FalsePart = ucArgHandle(Expr, 3)

        If Condition <> 0 Then
            ucReturnStr(Expr, ucEvaluateStr(TruePart))
        Else
            ucReturnStr(Expr, ucEvaluateStr(FalsePart))
        End If
    End Sub

    Sub Native_MsgBox(ByVal Expr As Integer)
        ucReturn(Expr, MsgBox(ucArgStr(Expr, 1), ucArg(Expr, 2), ucArgStr(Expr, 3)))
    End Sub

    Sub MyAverage(ByVal Expr As Integer)
        Dim x As Integer, Total As Double

        For x = 1 To ucArgCount(Expr)
            Total = Total + ucArg(Expr, x)
        Next

        ucReturn(Expr, Total / ucArgCount(Expr))
    End Sub

    Sub MyLeft(ByVal Expr As Integer)
        ucReturnStr(Expr, Left$(ucArgStr(Expr, 1), ucArg(Expr, 2)))
    End Sub

    Sub StringRepeat(ByVal Expr As Integer)
        Dim x As Integer, TotalString As String = ""

        For x = 1 To ucArg(Expr, 2)
            TotalString = TotalString + ucArgStr(Expr, 1)
        Next
        ucReturnStr(Expr, TotalString)
    End Sub

    Sub ucSum(ByVal Expr As Integer)
        Dim Expression As Integer, VarHandle As Integer
        Dim Start As Integer, Finish As Integer, sStep As Integer
        Dim x As Double, Total As Double

        Expression = ucArgHandle(Expr, 1)
        Start = ucArg(Expr, 2)
        Finish = ucArg(Expr, 3)
        sStep = ucArg(Expr, 4)
        VarHandle = ucArgHandle(Expr, 5)

        For x = Start To Finish Step sStep
            ucSetVariableValue(VarHandle, x)
            Total = Total + ucEvaluate(Expression)
        Next

        ucReturn(Expr, Total)
    End Sub

    Sub ucSolve(ByVal Expr As Integer)
        Dim Expression As Integer, Variable As Integer, Iterations As Integer
        Dim a As Double, b As Double, fa As Double, fb As Double
        Dim Value As Double, tmp As Double

        Expression = ucArgHandle(Expr, 1)
        a = ucArg(Expr, 2)
        b = ucArg(Expr, 3)
        Variable = ucArgHandle(Expr, 4)

        ucSetVariableValue(Variable, a) : fa = ucEvaluate(Expression)
        ucSetVariableValue(Variable, b) : fb = ucEvaluate(Expression)

        If fb < fa Then tmp = a : a = b : b = tmp 'swap a, b

        Do While Math.Abs(b - a) > 0.000000000000001
            ucSetVariableValue(Variable, (a + b) / 2)

            Value = ucEvaluate(Expression)

            If Value = 0 Then a = (a + b) / 2 : Exit Do

            If Value < 0 _
            Then a = (a + b) / 2 _
            Else b = (a + b) / 2

            Iterations = Iterations + 1
            If Iterations = 100 Then Exit Do
        Loop

        If Math.Abs(Value) > 0.0000000001 Then ucRaiseErrorMessage(Expr, "Solution not found")

        ucReturn(Expr, a)
    End Sub

    Sub Test(ByVal Expr As String, ByVal Answer As String, Optional ByVal t As Long = 0)
        If Answer <> ucEvalStr(Expr, t) Then MsgBox(Expr + Chr(10) + ucEvalStr(Expr, t) + Chr(10) + Answer)
    End Sub

    Sub TestExpand(ByVal Expr As String, ByVal Answer As String, Optional ByVal t As Long = 0)
        If Answer <> ucExpand(Expr, t) Then MsgBox(Expr + Chr(10) + ucExpand(Expr, t) + Chr(10) + Answer)
    End Sub

End Module
