#pragma once
#include "uCalcVC_NET.h"

namespace FormTest {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	
	/// <summary>
	/// Summary for Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: Add the constructor code here
			//
		}





	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	internal: System::Windows::Forms::ComboBox^  cmbNumericFormat;
	protected: 
	private: System::Windows::Forms::Label^  label2;
	internal: 
	internal: System::Windows::Forms::Label^  lblFPU;
	private: 
	internal: System::Windows::Forms::CheckedListBox^  chkFPU;

	internal: System::Windows::Forms::Button^  btnSummation;
	internal: System::Windows::Forms::Label^  Label1;
	internal: System::Windows::Forms::TextBox^  txtSumMax;
	internal: System::Windows::Forms::TextBox^  txtSumExpression;
	internal: System::Windows::Forms::TextBox^  txtSumResult;
	internal: System::Windows::Forms::Button^  btnPlot;
	internal: System::Windows::Forms::PictureBox^  PictureBox1;
	internal: System::Windows::Forms::TextBox^  txtPlotExpression;
	internal: System::Windows::Forms::Button^  btnDefine;
	internal: System::Windows::Forms::ComboBox^  cmbDefinition;


	internal: System::Windows::Forms::ComboBox^  cmbExpression;
	internal: System::Windows::Forms::Button^  btnEval;
	internal: System::Windows::Forms::TextBox^  txtResult;

	internal: 

	internal: 

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->cmbNumericFormat = (gcnew System::Windows::Forms::ComboBox());
			this->label2 = (gcnew System::Windows::Forms::Label());
			this->lblFPU = (gcnew System::Windows::Forms::Label());
			this->chkFPU = (gcnew System::Windows::Forms::CheckedListBox());
			this->btnSummation = (gcnew System::Windows::Forms::Button());
			this->Label1 = (gcnew System::Windows::Forms::Label());
			this->txtSumMax = (gcnew System::Windows::Forms::TextBox());
			this->txtSumExpression = (gcnew System::Windows::Forms::TextBox());
			this->txtSumResult = (gcnew System::Windows::Forms::TextBox());
			this->btnPlot = (gcnew System::Windows::Forms::Button());
			this->PictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			this->txtPlotExpression = (gcnew System::Windows::Forms::TextBox());
			this->btnDefine = (gcnew System::Windows::Forms::Button());
			this->cmbDefinition = (gcnew System::Windows::Forms::ComboBox());
			this->cmbExpression = (gcnew System::Windows::Forms::ComboBox());
			this->btnEval = (gcnew System::Windows::Forms::Button());
			this->txtResult = (gcnew System::Windows::Forms::TextBox());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->PictureBox1))->BeginInit();
			this->SuspendLayout();
			// 
			// cmbNumericFormat
			// 
			this->cmbNumericFormat->FormattingEnabled = true;
			this->cmbNumericFormat->Items->AddRange(gcnew cli::array< System::Object^  >(7) {L"General Number", L"Currency", L"Fixed", 
				L"Standard", L"Percent", L"Scientific", L"##.0000"});
			this->cmbNumericFormat->Location = System::Drawing::Point(14, 67);
			this->cmbNumericFormat->Name = L"cmbNumericFormat";
			this->cmbNumericFormat->Size = System::Drawing::Size(118, 21);
			this->cmbNumericFormat->TabIndex = 52;
			this->cmbNumericFormat->Text = L"General Number";
			this->cmbNumericFormat->TextUpdate += gcnew System::EventHandler(this, &Form1::cmbNumericFormat_TextUpdate);
			this->cmbNumericFormat->TextChanged += gcnew System::EventHandler(this, &Form1::cmbNumericFormat_TextChanged);
			// 
			// label2
			// 
			this->label2->AutoSize = true;
			this->label2->Location = System::Drawing::Point(140, 284);
			this->label2->Name = L"label2";
			this->label2->Size = System::Drawing::Size(481, 13);
			this->label2->TabIndex = 51;
			this->label2->Text = L" \' Note: Run Setup.Bat before running this demo to make sure required files are c" 
				L"opied to this project.";
			// 
			// lblFPU
			// 
			this->lblFPU->AutoSize = true;
			this->lblFPU->Location = System::Drawing::Point(303, 117);
			this->lblFPU->Name = L"lblFPU";
			this->lblFPU->Size = System::Drawing::Size(110, 13);
			this->lblFPU->TabIndex = 50;
			this->lblFPU->Text = L"FPU exception masks";
			// 
			// chkFPU
			// 
			this->chkFPU->CheckOnClick = true;
			this->chkFPU->Enabled = false;
			this->chkFPU->FormattingEnabled = true;
			this->chkFPU->Items->AddRange(gcnew cli::array< System::Object^  >(6) {L"Invalid op", L"Denormal op", L"Division by 0", L"Overflow", 
				L"Underflow", L"Precision loss"});
			this->chkFPU->Location = System::Drawing::Point(306, 133);
			this->chkFPU->Name = L"chkFPU";
			this->chkFPU->Size = System::Drawing::Size(114, 94);
			this->chkFPU->TabIndex = 49;
			this->chkFPU->SelectedIndexChanged += gcnew System::EventHandler(this, &Form1::chkFPU_SelectedIndexChanged);
			// 
			// btnSummation
			// 
			this->btnSummation->Location = System::Drawing::Point(462, 204);
			this->btnSummation->Name = L"btnSummation";
			this->btnSummation->Size = System::Drawing::Size(75, 23);
			this->btnSummation->TabIndex = 47;
			this->btnSummation->Text = L"Summation";
			this->btnSummation->UseVisualStyleBackColor = true;
			this->btnSummation->Click += gcnew System::EventHandler(this, &Form1::btnSummation_Click);
			// 
			// Label1
			// 
			this->Label1->AutoSize = true;
			this->Label1->Location = System::Drawing::Point(459, 128);
			this->Label1->Name = L"Label1";
			this->Label1->Size = System::Drawing::Size(103, 13);
			this->Label1->TabIndex = 46;
			this->Label1->Text = L"Summation from 1 to";
			// 
			// txtSumMax
			// 
			this->txtSumMax->Location = System::Drawing::Point(568, 125);
			this->txtSumMax->Name = L"txtSumMax";
			this->txtSumMax->Size = System::Drawing::Size(81, 20);
			this->txtSumMax->TabIndex = 45;
			this->txtSumMax->Text = L"100000";
			// 
			// txtSumExpression
			// 
			this->txtSumExpression->Location = System::Drawing::Point(462, 151);
			this->txtSumExpression->Name = L"txtSumExpression";
			this->txtSumExpression->Size = System::Drawing::Size(187, 20);
			this->txtSumExpression->TabIndex = 44;
			this->txtSumExpression->Text = L"x^2+5*x-10";
			// 
			// txtSumResult
			// 
			this->txtSumResult->Location = System::Drawing::Point(462, 177);
			this->txtSumResult->Name = L"txtSumResult";
			this->txtSumResult->Size = System::Drawing::Size(187, 20);
			this->txtSumResult->TabIndex = 43;
			// 
			// btnPlot
			// 
			this->btnPlot->Location = System::Drawing::Point(14, 274);
			this->btnPlot->Name = L"btnPlot";
			this->btnPlot->Size = System::Drawing::Size(75, 23);
			this->btnPlot->TabIndex = 42;
			this->btnPlot->Text = L"Plot";
			this->btnPlot->UseVisualStyleBackColor = true;
			this->btnPlot->Click += gcnew System::EventHandler(this, &Form1::btnPlot_Click);
			// 
			// PictureBox1
			// 
			this->PictureBox1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->PictureBox1->Location = System::Drawing::Point(14, 145);
			this->PictureBox1->Name = L"PictureBox1";
			this->PictureBox1->Size = System::Drawing::Size(254, 123);
			this->PictureBox1->TabIndex = 41;
			this->PictureBox1->TabStop = false;
			// 
			// txtPlotExpression
			// 
			this->txtPlotExpression->Location = System::Drawing::Point(14, 120);
			this->txtPlotExpression->Name = L"txtPlotExpression";
			this->txtPlotExpression->Size = System::Drawing::Size(254, 20);
			this->txtPlotExpression->TabIndex = 40;
			this->txtPlotExpression->Text = L"-sin(x)/2";
			// 
			// btnDefine
			// 
			this->btnDefine->Location = System::Drawing::Point(306, 39);
			this->btnDefine->Name = L"btnDefine";
			this->btnDefine->Size = System::Drawing::Size(75, 23);
			this->btnDefine->TabIndex = 39;
			this->btnDefine->Text = L"Define";
			this->btnDefine->UseVisualStyleBackColor = true;
			this->btnDefine->Click += gcnew System::EventHandler(this, &Form1::btnDefine_Click);
			// 
			// cmbDefinition
			// 
			this->cmbDefinition->FormattingEnabled = true;
			this->cmbDefinition->Items->AddRange(gcnew cli::array< System::Object^  >(31) {L"Var: x = 123", L"Var: MyString As String = \"Hello\"", 
				L"Var: StringB = \"StringB is automatically defined as string because of quotes\"", L"Var: MyInt As Long = 123", L"Const: Pi = Atan(1) * 4", 
				L"Func: f(x) = x^2", L"Func: g(x, y) = x * y", L"Func: Twice(x As Double) As Double = x * 2", L"Func: Twice(x As String) As String = x + x", 
				L"Func: Area(x) = x ^ 2", L"Func: Area(x, y) = x * y", L"Func: Volume(r, h=0) = IIf(h==0, pi*r^3*4/3, pi*r^2*h/3)", L"Func: Factorial(x) = IIf(x>1, x*Factorial(x-1), 1)", 
				L"Func: Fib(n) = IIf(n < 2, n, Fib(n-1) + Fib(n - 2))", L"Func: Test(x As String) As String = MyMsgBox(x) ; x + x", L"Func: TriangleWave(x) = (8/pi^2)*Sum((-1)^((n-1)/2)/(n^2)*Sin(n*x), 1, 100, 2, n)" 
				L"", 
				L"Op: Precedence(\"*\") {x} ShiftLeft {y} := x * 2^y", L"Op: !{x}  :=  x == 0", L"Op: {x}%  :=  x / 100", L"Syntax: This sentence ::= \"Something Else\"", 
				L"Syntax: {\'&b\'}{Number:\'[0-1]+\'} ::= BaseConvert(\'{Number}\', 2)", L"Syntax: Reverse({first}) ::= \'{first}\'", L"Syntax: Reverse({first}, {rest}) ::= Reverse({rest}) + \', {first}\'", 
				L"Syntax: MySum({x}) ::= {x}", L"Syntax: MySum({x}, {y}) ::= ({x} + MySum({y}))", L"Syntax: CountArgs({x})      ::= 1", L"Syntax: CountArgs({x}, {y}) ::= ~Eval(1 + CountArgs({y}))", 
				L"Syntax: Average({args}) ::= MySum({args}) / CountArgs({args})", L"Syntax: {a} & {b} ::= \"{a}s and {b}s are different\"", L"Syntax: {a} & {a} ::= \"Two {a}s are better than one {a}\"", 
				L"Macro: Plus(x) = x + x"});
			this->cmbDefinition->Location = System::Drawing::Point(306, 12);
			this->cmbDefinition->Name = L"cmbDefinition";
			this->cmbDefinition->Size = System::Drawing::Size(343, 21);
			this->cmbDefinition->TabIndex = 38;
			this->cmbDefinition->Text = L"Var: MyVariable = 1234.5";
			// 
			// cmbExpression
			// 
			this->cmbExpression->FormattingEnabled = true;
			this->cmbExpression->Items->AddRange(gcnew cli::array< System::Object^  >(27) {L".5 + 10", L"5*(((10+3)!-1) MOD 7)^2", L"((2.5+1)*(9-5.5/2)^1.5+COS(ATAN(1)*(3+1/3)))^2", 
				L"MyArea(3,4)", L"MyArea(-3,4)", L"IIF(1 > 2, 1/0, 3)", L"IIF(1 > 2, \"True\", \"False\")", L"IIF(1 > 2, MyMsgBox(\"Yes\"), MyMsgBox(\"No\"))", 
				L"MyIIF(1 > 2, 1/0, 3)", L"MyIIF(1 > 2, \"True\", \"False\")", L"MyIIF(1 > 2, MyMsgBox(\"Yes\"), MyMsgBox(\"No\"))", L"Solve(x^2 + 1 = 26)", 
				L"Solve(x^2 + 1 = 26, -1000, 0)", L"Sum(2*x + 5, 1, 10)", L"\"Hello \" + \"world\"", L"\"This\" > \"That\"", L"\'This\' < \'That\'", 
				L"Asc(\"D\")", L"#hAE.B1 + #b1110.1001", L"NonNativeFunc(2.5, 10.3, 6)", L"MsgBox(\"Please send feedback at www.ucalc.com\")", 
				L"MsgBox(\"Something\", 2)", L"MsgBox(\"Great\",, \"New Title\")", L"MyAverage(1,2,3,4,5,6)", L"MyLeft(\"Hello There\", 7)", 
				L"MsgBox(\"First box\") ; MsgBox(\"Second Box\",, \"Title\") ; 123", L"\"Hello \" * 3"});
			this->cmbExpression->Location = System::Drawing::Point(14, 12);
			this->cmbExpression->Name = L"cmbExpression";
			this->cmbExpression->Size = System::Drawing::Size(254, 21);
			this->cmbExpression->TabIndex = 37;
			this->cmbExpression->Text = L"3+4/5-8";
			// 
			// btnEval
			// 
			this->btnEval->Location = System::Drawing::Point(193, 65);
			this->btnEval->Name = L"btnEval";
			this->btnEval->Size = System::Drawing::Size(75, 23);
			this->btnEval->TabIndex = 36;
			this->btnEval->Text = L"Evaluate";
			this->btnEval->UseVisualStyleBackColor = true;
			this->btnEval->Click += gcnew System::EventHandler(this, &Form1::btnEval_Click);
			// 
			// txtResult
			// 
			this->txtResult->Location = System::Drawing::Point(14, 39);
			this->txtResult->Name = L"txtResult";
			this->txtResult->Size = System::Drawing::Size(254, 20);
			this->txtResult->TabIndex = 35;
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(673, 321);
			this->Controls->Add(this->cmbNumericFormat);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->lblFPU);
			this->Controls->Add(this->chkFPU);
			this->Controls->Add(this->btnSummation);
			this->Controls->Add(this->Label1);
			this->Controls->Add(this->txtSumMax);
			this->Controls->Add(this->txtSumExpression);
			this->Controls->Add(this->txtSumResult);
			this->Controls->Add(this->btnPlot);
			this->Controls->Add(this->PictureBox1);
			this->Controls->Add(this->txtPlotExpression);
			this->Controls->Add(this->btnDefine);
			this->Controls->Add(this->cmbDefinition);
			this->Controls->Add(this->cmbExpression);
			this->Controls->Add(this->btnEval);
			this->Controls->Add(this->txtResult);
			this->Name = L"Form1";
			this->Text = L"uCalc Fast Math Parser 3 demo for VC++";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->PictureBox1))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion		
		
	private: System::Void btnEval_Click(System::Object^  sender, System::EventArgs^  e) {
				 static bool Displayed = false;
				txtResult->Text = ucEvalStr(cmbExpression->Text);
			 }

	#include "MyRoutines.cpp"		  
	static ucErrorHandlerDelegate ^ d_MyErrorHandler = gcnew ucErrorHandlerDelegate(&MyErrorHandler);
    static ucFunctionDelegate ^ d_MyNumericFormat = gcnew ucFunctionDelegate(&MyNumericFormat);
	static ucFunctionDelegate ^ d_MyArea = gcnew ucFunctionDelegate(&MyArea);
	static ucFunctionDelegate ^ d_MyLeft = gcnew ucFunctionDelegate(&MyLeft);
	static ucFunctionDelegate ^ d_MyMsgBox = gcnew ucFunctionDelegate(&MyMsgBox);
	static ucFunctionDelegate ^ d_MyAverage = gcnew ucFunctionDelegate(&MyAverage);
	static ucFunctionDelegate ^ d_MyIIf_Numeric = gcnew ucFunctionDelegate(&MyIIf_Numeric);
	static ucFunctionDelegate ^ d_MyIIf_String = gcnew ucFunctionDelegate(&MyIIf_String);
	static ucFunctionDelegate ^ d_StringRepeat = gcnew ucFunctionDelegate(&StringRepeat);
	static ucFunctionDelegate ^ d_ucSum = gcnew ucFunctionDelegate(&ucSum);
	static ucFunctionDelegate ^ d_ucSolve = gcnew ucFunctionDelegate(&ucSolve);
	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {				 
            for (int x = 0; x <= 5; x++) { chkFPU->SetItemCheckState(x, CheckState::Checked); }                      

            // The definitions here are for "callback" routines.  Each definition ends with the
            // name of a function, which can be found elsewhere in this file.
#if _MSC_VER == 1600
            ucSetOutput(d_MyNumericFormat);
#endif

            // The MyErrorHandler() function will be called whenever and wherever an
            // error (such as "Syntax Error") is raised.	
            ucAddErrorHandler(d_MyErrorHandler);            
                        
            // MyArea() returns the product of multiplying the two arguments.
            // MyLeft() returns the left-most characters of a string.  The second argument represents the number of characters.
            // MsgBox() displays a message box.  The 1st argument is required.  The others are optional.

            ucDefineFunction("Native: MyArea(Length, Width)", d_MyArea);
            ucDefineFunction("Native: MyLeft(Text As String, Count) As String", d_MyLeft);
            ucDefineFunction("Native: MyMsgBox(Prompt As String, Buttons = 0, Title As String = 'uCalc')", d_MyMsgBox);
            ucDefineSyntax("MsgBox ::= MyMsgBox");

            // The three consecutive dots "..." mean that MyAverage can take any number of arguments
            // (however, because "x" is specified, there must be at least one argument).
            ucDefineFunction("Native: MyAverage(x ...)", d_MyAverage);

            // Two versions of MyIIF can co-exist peacefully with the same name because
            // they are defined with different argument types (numeric vs string).
            // By passing the last two arguments ByExpr, the callback can chose to evaluate only one of of them.  
            ucDefineFunction("Native: MyIIf(cond, ByExpr TruePart, ByExpr FalsePart)", d_MyIIf_Numeric);
            ucDefineFunction("Native: MyIIf(cond, ByExpr TruePart As String, ByExpr FalsePart As String) As String", d_MyIIf_String);

            // The following defines the "*" operator so that MyString * n returns MyString repeated n times.
            // For instance, "He " * 3, would return "He He He".  20 represents the precedence level.  It is
            // arbitrarily set at the same level as that of the numeric "*" multiplication operator.			
            ucDefineOperator("Native: Precedence('*') {MyString As String} * {Number} As String", d_StringRepeat);

            // This definition is for a summation.  See the callback ucSum() routine for the
            // actual code, which runs a loop that adds up the total for the expression in
            // the first argument a number of times based on the second and third arguments.
            // For instance Sum(g^2+1, 1, 5, 1, g) returns 60 and Sum(x^2, 1, 10) returns 385.
            // The last two arguments are optional, so they default to 1 and x if omitted.
            //
            // The first argument is passed "ByExpr".  So instead of being evaluated before
            // being passed to the callback the way an ordinary argument would be, a handle
            // for the expression is passed so that the callback can evaluate it (in this
            // case numerous times).
            //
            // The last argument is passed "ByHandle".  This causes the callback to receive
            // a handle for the variable being passed, in such a way that it can be linked to
            // the summation counter, and integrated into the expression in the first argument.
            //
            // The actual function being defined is Sum_().  Then a syntax construct named
            // Sum() is defined in such a way that the last argument gets defined as a local
            // variable.  So if you evaluate Sum(x^2, 5, 10, 1, x), the local "x" in this
            // expression will not interfere with a pre-existing variable named x.  Also you
            // do not need to declare a variable ahead of time to use it as a counter for Sum().
            ucDefineFunction("Native: Sum_(ByExpr Expr, Start, Finish, Step, ByHandle Var)", d_ucSum);
            ucDefineSyntax("Sum({Expr}, {Start}, {Finish} [, {Step=1} [, {Var=x}]]) ::= Local({Var}, Sum_({Expr}, {Start}, {Finish}, {Step}, {Var}))");

            // The following routine solves an equation.
            // The callback code is based on the Bisection Method algorithm.
            // The concept here is very similar to that of Sum().
            // Two syntax constructs are defined.  The second one rearranges the equation
            // if it includes an equal sign.
            // For instance Solve(x^2 = 9+x) becomes Solve(x^2 - (9+x))
            // Solve(x^2 + 1 = 26) returns 5.
            // Solve(x^2 + 1 = 26, -1000, 0) returns -5.
            ucDefineFunction("Native: Solve_(ByExpr Expr, a, b, ByHandle Var)", d_ucSolve);
            ucDefineSyntax("Solve({Expr} [, {a=-100000000} [, {b=100000000} [, {Var=x}]]]) ::= Local({Var}, Solve_({Expr}, {a}, {b}, {Var}))");
            ucDefineSyntax("Solve({Left} = {Right} [, {etc}]) ::= Solve({Left}-({Right}) {etc: , {etc}})");			
		 }
private: System::Void btnDefine_Click(System::Object^  sender, System::EventArgs^  e) {
			 ucDefine(cmbDefinition->Text);
		 }

private: System::Void btnSummation_Click(System::Object^  sender, System::EventArgs^  e) {			    
   double x = 1, SumTotal = 0, SumMax;
   int ExprHandle, xHandle;   

   SumMax = Convert::ToDouble(txtSumMax->Text);
   
   xHandle = ucDefineVariable("x");
   ExprHandle = ucParse(txtSumExpression->Text);
   
   while (x <= SumMax)
   {
	  ucSetVariableValue(xHandle, x);
      SumTotal = SumTotal + ucEvaluate(ExprHandle);
      x++;
   } 
      
   txtSumResult->Text = Convert::ToString(SumTotal);

   ucReleaseItem(ExprHandle);
   ucReleaseItem(xHandle);
 }

		 
        

private: System::Void btnPlot_Click(System::Object^  sender, System::EventArgs^  e) {			   
            double x = -10, y;
			float OldX, OldY, NewX, NewY;
            int EqHandle, xHandle;

			Graphics ^ g = PictureBox1->CreateGraphics();        
			Pen ^ myPen = gcnew Pen(Color::Black);
            g->Clear(Color::White);

            xHandle = ucDefineVariable("x");
            EqHandle = ucParse(txtPlotExpression->Text);

            while (x <= 10)
            {
				if (x == -10) { OldX = 0; OldY = 0; }
                ucSetVariableValue(xHandle, x);               
				y = ucEvaluate(EqHandle);
				NewX = PictureBox1->Size.Width * (x + 10) / 20;
                NewY = PictureBox1->Size.Height * (2 - y) / 4;
                g->DrawLine(myPen, OldX, OldY, NewX, NewY);

                OldX = NewX;
                OldY = NewY;
			
                x = x + (float)0.125;
            }

            ucReleaseItem(EqHandle);
            ucReleaseItem(xHandle);
		 }
	private: System::Void chkFPU_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
				 /*
				 switch (chkFPU.SelectedIndex)
				{
					case 0: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_InvalidOp); break;
					case 1: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_DenormalOp); break;
					case 2: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_ZeroDivide); break;
					case 3: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_Overflow); break;
					case 4: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_Underflow); break;
					case 5: ucFPU(uCalc.uc_ToggleFPU, uc_FPU_Mask_PrecisionLoss); break;
				}
				*/
			 }
private: System::Void cmbNumericFormat_TextUpdate(System::Object^  sender, System::EventArgs^  e) {
		    NumericFormat = cmbNumericFormat->Text;
            if (NumericFormat == "Standard") NumericFormat = "N";
            if(NumericFormat == "Scientific") NumericFormat = "E";
            if(NumericFormat->ToUpper() != NumericFormat->ToLower()) NumericFormat = NumericFormat->Substring(0, 1);
		 }
private: System::Void cmbNumericFormat_TextChanged(System::Object^  sender, System::EventArgs^  e) {
			 NumericFormat = cmbNumericFormat->Text;
            if (NumericFormat == "Standard") NumericFormat = "N";
            if(NumericFormat == "Scientific") NumericFormat = "E";
            if(NumericFormat->ToUpper() != NumericFormat->ToLower()) NumericFormat = NumericFormat->Substring(0, 1);
		 }
};
}

