        static String ^ NumericFormat = "G";

		static void MyNumericFormat(int Expr)
        {
			String ^ ResultAsString = ucArgStr(Expr, 1);		

			if(ResultAsString=="Inf" || ResultAsString=="NaN") {
				ucReturnStr(Expr, ResultAsString);
			}
			else {
				double Result = Convert::ToDouble(ResultAsString);
				String ^ FormattedResult = Result.ToString(NumericFormat);
				ucReturnStr(Expr, FormattedResult);         
			}
        }

        static int MyErrorHandler(int t)
		{
			static int AlreadyDisplayedOnce;
			if(AlreadyDisplayedOnce == ucFalse)
				MessageBox::Show("Error Handler message: "+ ucErrorMessage(0, t) + "\n"
				+ "Offending symbol: " + ucErrorSymbol(t) + "\n"
				+ "Error Location: " + ucErrorLocation(t).ToString() + "\n" + "\n"
				+ "This message box will not be displayed for the next error. " + "\n"
				+ "Remove 'AlreadyDisplayedOnce = 1;' in the demo source code to change this. ",
                                  "uCalc FMP error demo");

			// Remove the line below if you want the message box to be
			// displayed every time there's an error.
			AlreadyDisplayedOnce = 1;

			return ucAbort;
		}

		static void MyArea(int Expr)
		{
			double MyLength, MyWidth;			

			MyLength = ucArg(Expr, 1);
			MyWidth = ucArg(Expr, 2);			
   
			if(MyLength < 0) ucRaiseErrorMessage(Expr, "Length cannot be negative");
			if(MyWidth  < 0) ucRaiseErrorMessage(Expr, "Width cannot be negative");

			ucReturn(Expr, MyLength * MyWidth);
		}

		static void MyIIf_Numeric(int Expr)
		{
			double Condition;
			int TruePart, FalsePart;

			Condition = ucArg(Expr, 1);
			TruePart = ucArgHandle(Expr, 2);
			FalsePart = ucArgHandle(Expr, 3);

			if(Condition != 0)
			ucReturn(Expr, ucEvaluate(TruePart));
			else ucReturn(Expr, ucEvaluate(FalsePart));
		}

		static void MyIIf_String(int Expr)
		{
			double Condition;
			int TruePart, FalsePart;

			Condition = ucArg(Expr, 1);
			TruePart = ucArgHandle(Expr, 2);
			FalsePart = ucArgHandle(Expr, 3);

			if(Condition != 0)
			ucReturnStr(Expr, ucEvaluateStr(TruePart));
			else ucReturnStr(Expr, ucEvaluateStr(FalsePart));
		}

		static void MyMsgBox(int Expr)
		{
            // Second arg is ignored
            MessageBox::Show(ucArgStr(Expr, 1), ucArgStr(Expr, 3));
			ucReturn(Expr, 1);
		}

		static void MyAverage(int Expr)
		{
			int x;
			double Total = 0;

			for(x=1; x <= ucArgCount(Expr); x++)
				Total = Total + ucArg(Expr, x);        

			ucReturn(Expr, Total / ucArgCount(Expr));
		}

		static void MyLeft(int Expr)
		{            
            ucReturnStr(Expr, ucArgStr(Expr, 1)->Substring(0, (int)ucArg(Expr, 2)));
		}

		static void StringRepeat(int Expr)
		{
			int x;
			String ^ TotalString = "";

			for(x = 1; x <= ucArg(Expr, 2); x++)
				TotalString = TotalString + ucArgStr(Expr, 1);
        
			ucReturnStr(Expr, TotalString);
		}

		static void ucSum(int Expr)
		{
			int Expression, VarHandle;
			double Start, Finish, sStep;
			double x, Total;

            Expression = ucArgHandle(Expr, 1);
			Start = ucArg(Expr, 2);
			Finish = ucArg(Expr, 3);
			sStep = ucArg(Expr, 4);
			VarHandle = ucArgHandle(Expr, 5);

			x = Start;
			Total = 0;
			while(x <= Finish)
			{
				ucSetVariableValue(VarHandle, x);
				Total = Total + ucEvaluate(Expression);
				x = x + sStep;
			}

			ucReturn(Expr, Total);
		}

		static void ucSolve(int Expr)
		{
			int Expression, Variable;
			int Iterations = 0;
			double a, b, fa, fb, Value, tmp;

			Expression = ucArgHandle(Expr, 1);
			a = ucArg(Expr, 2);
			b = ucArg(Expr, 3);
			Variable = ucArgHandle(Expr, 4);
			Value = 0;

			ucSetVariableValue(Variable, a);
			fa = ucEvaluate(Expression);

			ucSetVariableValue(Variable, b); 
			fb = ucEvaluate(Expression);
   
			if(fb < fa) {tmp = a; a = b; b = tmp;}  // swap a, b
    
			while(Math::Abs(b - a) > 0.000000000000001)
			{
				ucSetVariableValue(Variable, (a + b) / 2);
      
				Value = ucEvaluate(Expression);
      
				if(Value == 0) {a = (a + b) / 2; break;}

				if(Value < 0) a = (a + b) / 2; else b = (a + b) / 2;

				Iterations = Iterations + 1;
				if(Iterations == 100) break;
			}
   
			if(Math::Abs(Value) > 0.0000000001) ucRaiseErrorMessage(Expr, "Solution not found");
			ucReturn(Expr, a);
		}
