######################################################################
#
# *** IMPORTANT *** : Please do not submit or publish any additions
#                     or improvements to this or other files just yet.
#                     These files will likely be open source.
#                     However, details have not been worked out yet.
#                     Please do not submit bug reports yet either.
#                     This beta is a snap shot with many missing or
#                     evolving pieces, so it is already expected that
#                     certain things won't work as anticipated.
#
# NOTE: This one is the least stable among the languages in the
#       Aug 2011 file.  Many of the examples simply won't work.
#
# CPP.uc: This sample version of Tcl was done while browsing through
#         www.cplusplus.com/doc/tutorial
#         c_preprocessor on Wikipedia
#         microsoft msdn for C++ Character Constants, String Literals
#
# For use with uCalc Language Builder v ???
#
# Code in this file originally written by: Daniel Corbier
# Contact: support at ucalc.com
# Date: ???
#
# Revision: ??? Date: ???  By: ??? contact: ???
# Modifications: ???, ???, ???
# 
######################################################################

Pass: 7
Include: uCalc.uc
Include: Memory.uc

Pattern: [ \r\n\t]+ ~~ Properties: ucWhiteSpace
Pattern: \?\?.      ~~ # This one is for trigraph support (old C relic)

# Phases of Translation are broken down into separate passes below

Pass: 1 ~~ # Character mapping (trigraph replacement)
#Execute: Synonym(Pass 1): ??= #, ??/ \, ??' ^, ??( [, ??) ], ??! |, ??< {, ??> }, ??- ~


Pass: 2 ~~ # Line splicing (with \ followd by carriage return)
#Syntax:  ".*\$"  ::=


Pass: 3 ~~ # Tokenization (comments handled here)
Syntax: {Comment:"//.*"}    ::= {sp}
Syntax: {Comment: /* {code} */ } ::= {sp}


Pass: 4 ~~ # Preprocessing
Syntax: #if {condition}   {cr}  _
            {Statements+} {cr}  _
       [#else             {cr}  _
            {StatementsB+}{cr}] _
        #endIf                  _
        ::= ~Eval(iif({condition}, {q}{Statements}{q}+CrLf, {q}{StatementsB}{q}+CrLf))
Syntax: #ifdef {identifier} ::= #if ~Eval(ucHandle("{identifier}"))
Syntax: #ifndef {identifier} ::= #if ~Eval(ucHandle("{identifier}")==0)
Syntax: #include {FileName} ::= ~FileInclude{FileName}
Syntax: #include <{Ignore}> ::=
Syntax: #define {identifier#} [({params})] [{tokens:".*"}] ::= ~Define(Macro(4): {identifier} [({params})] = {tokens})


Pass: 5 ~~ # Character-set mapping (handles string escapes)
Var: Esc_(20)
Syntax: {"\q"}[{text:"[^\q\\]+"}]{"\\"}{Escape:"."} ::= "{String}"+Esc_(Chr({Escape}))+"
Syntax: {"\q"}[{text:"[^\q\\]+"}]{"\\x"}{Value:"."} ::= "{String}"+Chr(0x{Value})+"
#Syntax: Escape: \{ch:"."} {value:1} [; {more:".*"}] ::= ~Exec(SetVar(Esc_(Asc({q}{ch}{q})), {value})) {more: Escape: {more}}
#Escape: \n 10; \t 9; \v 11; \b 8; \r 13; \f 12; \a 7; \\ 92; \? 63; \' 39; \" 34; \0 0


Pass: 6 ~~ # String concatenation
#Syntax: {String1:"\q[^\q]*"}{"\q +\q"}{String2:"[^\q]*\q"} ::= {String1}{String2}

Pass: 7 ~~ # Translation
Rename: "AndAlso" "&&", "OrElse" "||", "And" "&", "Or" "|", "<>" "!="

Synonym: int long, float SINGLE, char BYTE
Syntax: signed ::=
Syntax: unsigned short [int] ::= WORD
Syntax: [signed] short [int] ::= Integer
Syntax: unsigned { int | long } ::= DWORD
Syntax: long double ::= EXTENDED

Syntax: {"'"}{char}{"'"} ::= ~Eval(Asc("{char}"))

SyntaxArgL: {type} = "{type: long | double | float | string | void | BYTE | WORD | DWORD | EXTENDED }"
Syntax: {type} {variable}; ::= ~Local(Var: <{type}>{variable})
Syntax: {type} * {variable}; ::= ~Local(Var: <DWORD>{variable} ~~ NextDef ~~ Precedence: 100 _
        ~~ Syntax: *{name:1} ::= ValueAtAddr(({type}), {name}))
Syntax: {type} {variable:1} ({default}); ::= ~Local(Var: <{type}>{variable} = {default})
Syntax: {type} {name:1} "[" [{elements}] "]" [ = "{" {init~} "}" ]; ::=   _
        ~Local(Count: {elements}+ArgCount({init}) ~~ Var: <{type}>{name}) _
        {init: ~Exec(InitArray:{name}: {init}) }
Precedence: 100 ~~ Syntax: {name}"["{index}"]" ::= ValAtAddr({name}, {index})
Syntax: char {name:1} "[" [{elements}] "]" [ = "{" {init~} "}" ]; ::= _
        ~Local(Size: {elements}+ArgCount({init}) ~~ Var: {name} As LPCSTR) _
        ~Local(Precedence: 100 ~~ Syntax: {name}"["{index}"]" ::= ValueAtAddr((BYTE), Address({name}), {index})) _
        {init: ~Exec(InitArray:{name}: {init}) }
Syntax: char {name:1} "[" "]" = {" *\q"}{text:"[^\q]+"}{"\q"} ::= ~Local(Var: {name} As LPCSTR = "{text}") _
        ~Local(Precedence: 100 ~~ Syntax: {name}"["{index}"]" ::= ValueAtAddr((BYTE), Address({name}), {index}))
Syntax: {type} {FirstVar~}, {OtherVars~} ::= {type} {FirstVar}; {type} {OtherVars}
SkipOver ~~ Syntax: ({type})
Syntax: Var: <{type}>{variable}({value}) ::= Var:<{type}>{variable} = {value}
Syntax: InitArray:{array}: [{Args>}, ] {LastArg} ::= _
        ~Exec({array}[ArgCount({Args})] = {LastArg}) _
        {Args: InitArray:{array}: {Args} }




Syntax: int main () "{" {code} "}" ::= {code}
Syntax: {type} {funcName:1} ({params~}) { {statements} } ::= _
        ~Define(Func: {funcName}(_fparams({params})) As {type} = {statements})
Syntax: _fparams([void]) ::=
PassOnce ~~ Syntax: _fparams({Type:1}[{byref: &}]{name:1} [{etc~}]) ::= {byref: ByRef} {name} As {Type} {etc}
Syntax: _fparams({arg1~}, {more~}) ::= _fparams({arg1}), _fparams({more})

Syntax: if ({condition}) {statement} ::= IfElseIf(({condition}), {statement}; 0)
#Syntax: if ({condition}) {statement} [else {statement2}] ::= _
#        IfElseIf(({condition}), {statement} {statement2: , 1, {statement2} })
Syntax: while ({condition}) {statement} ::= uc_Loop({condition}, {statement}; 0, 1)
Syntax: do {statement} while ({condition}); ::= uc_Loop(1, {statement}; 0, {condition});
Syntax: for ([{initialization}]; {condition}; [{increase}]) {statement} ::= _
        {initialization}; while ({condition}) { {statement}; {increase} }


Syntax: cin >> {variable}; ::= SetVar({variable}, Omni(ReadLine_FromConsole()));
Syntax: getline(cin, {variable}); ::= SetVar({variable}, Omni(ReadLine_FromConsole()));
Syntax: cout << {data}; ::= Write(Omni({data}));
Syntax: cout << {data} << {more} ::= cout << {data}; cout << {more} 

Syntax: return {data}; ::= {data};

Syntax: endl ::= "{cr}"

Syntax: SetVar_({variable}, {value}) ::= (SetVar({variable}, {value}); {variable})
RightToLeft ~~ Syntax: {variable:1} = {value} ::= SetVar_({variable}, {value})

Precedence: 10
Syntax: {variable} {operator: +|-|*|/|%} = {value} ::= {variable} = {variable} {operator} ({value})
Precedence: 70 ~~ # on par with precedence of unary +/- defined in math.uc
Syntax: &{variable}    ::= VarPtr({variable})
Syntax: !{expr#}       ::= (1 - (({expr})<>0))
Syntax: ++{variable}   ::= (SetVar({variable}, {variable}+1); {variable})
Syntax: --{variable}   ::= (SetVar({variable}, {variable}-1); {variable})
Syntax: {variable}++   ::= (SetVar({variable}, {variable}+1); {variable}-1)
Syntax: {variable}--   ::= (SetVar({variable}, {variable}-1); {variable}+1)
Syntax: sizeof({item%})::= uCalc(uc_GetItemData, "{item}", 0, uc_ByteSize) _
                                 * max(1, uCalc(uc_GetItemData, "{item}", 0, uc_ArgCount))
Syntax: new {type:1}   ::= HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, sizeof({type}))
Syntax: delete {p:1}   ::= HeapFree(GetProcessHeap(), 0, {p}) 

Precedence: 5 ~~ Syntax: {condition} ? {result1} : {result2} ::= iif({condition}, {result1}, {result2})
Execute: SetConst(true, 1)




Syntax: {"0"}{OctalNumber:"[0-7]+"}  ::= ~Eval(BaseConvert("{OctalNumber}",  8))
Syntax: {"0x"}{HexNumber:"[0-9A-F]+"} ::= ~Eval(BaseConvert("{HexNumber}",   16))


Execute: SetVar(REPL_Language, "C++")

Mode: Execute

REPL_OR_FILE
