# List types are defined in Types.uc
# Stack concatenation is defined in Math.uc

Func: Len(StackVar As Stack) = uc_Count(StackVar)

Precedence: Precedence("*") ~~ Op: {x} * {StackVar As Stack} As Stack := {   
   ~Static(Var: StackReturn As Stack)
   ResetVariable(StackReturn);
   uc_For(x, 2, x, 1, SetVar(StackReturn, StackReturn + StackVar));
   StackReturn + StackVar
}

Func: StackSlice(StackVar As Stack, start, finish) As Stack = {
   ~Local(Var: x)
   ~Static(Var: StackReturn As Stack)
   ResetVariable(StackReturn);
   SetVar(finish, Min(finish, uc_Count(StackVar)));
   uc_For(x, start, finish, 1, uc_PushH(StackReturn, uc_ReadHandle(StackVar, x)));
   StackReturn
}
