# Patterns for performing tokenization (lexical analysis / scanning)

Pattern: [\x00-\x1F] ~~ # Reserved characters (see DefSyntax.uc)
Pattern: \x03 ~~ \x03 ~~ DataType: String ~~ Properties: ucQuotedText+ucLiteral
Pattern: \x05 ~~ # Codeblock bootstrap
Pattern: \x06 ~~ \x07 ~~ Properties: ucCodeBlock
#Pattern: \x0B ~~ # Reserved for item by handle
Pattern: \x11 ~~ \x11 ~~ DataType: String ~~ Properties: ucQuotedText+ucLiteral
Pattern: \x12 ~~ \x12 ~~ DataType: String ~~ Properties: ucQuotedText+ucLiteral
Pattern: \x1F[a-z]+\x1F ~~ # Non-text marker
Pattern: [~:]
Pattern: :=
Pattern: \[ ~~ \] ~~ Properties: ucCodeBlock
Pattern: \{ ~~ \} ~~ DataType: Stack ~~ Address: @uc_Func_Populate_Stack ~~ Properties: ucCodeBlock
Pattern: [\q] ~~ [\q] ~~ DataType: String ~~ Properties: ucQuotedText+ucLiteral
Pattern: [']  ~~ [']  ~~ DataType: String ~~ Properties: ucQuotedText+ucLiteral
Pattern: \r\n ~~ Properties: ucStatementSep ~~ # Carriage Return
Pattern: ; ~~ Properties: ucStatementSep
Pattern: ~t ~~ Properties: ucCurrentThread
Pattern: ~Define   ~~ Properties: ucDefineNow
Pattern: ~Eval     ~~ Properties: ucEvalInsert
Pattern: ~Eval_1   ~~ Properties: ucEvalInsert ~~ PassOnce
Pattern: ~Eval_P   ~~ Properties: ucEvalDuringParse
Pattern: ~Exec     ~~ Properties: ucEvalInsert ~~ IgnoreOutput
Pattern: ~Expand   ~~ Properties: ucExpandInsert
Pattern: ~Expand_1 ~~ Properties: ucExpandInsert ~~ PassOnce
Pattern: ~FileInclude ~~ Properties: ucFileInclude
Pattern: ~FileInclude_1 ~~ Properties: ucFileInclude ~~ PassOnce
Pattern: ~Local    ~~ Properties: ucLocalVar
Pattern: ~Static   ~~ Properties: ucStaticVar
Pattern: ~TempDef  ~~ Properties: ucTempDef
Pattern: \. ~~ Properties: ucMemberAccess+ucInfix
Pattern: \~\~ ~~ Properties: ucStatementSep
Pattern: , ~~ Properties: ucArgSeparator
Pattern: \( ~~ \) ~~ Properties: ucCodeBlock
Pattern: [ \t]+ ~~ Properties: ucWhiteSpace
Pattern: [\|+/*^$&#\-=%@!`\\<>?]+ ~~ Properties: ucReducible ~~ # For operators
Pattern: ([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)? ~~ DataType: Extended ~~ Properties: ucLiteral ~~ # Numeric
Pattern: [a-z_\x0C][0-9a-z_]* ~~ Name: AlphaNum ~~ Properties: ucAlphaNumeric
