' C:\> rundll32 uCalcLB.dll,Run File Basic.uc Test3.uc
' C:\> Windiff Test3.Ans Test3.out


DefExt a-z

Global MyGlobal As Double

Macro MyMacro    = 12345
Macro mAdd(a, b) = a + b

Sub MySubA(txt$)
   Print txt$
End Sub

Sub MySubB(txt1$, txt2$)
   Print txt1$, txt2$
End Sub

Function TestFunc$(MyText$)
   Local Counter&, Result$
   Static sCount As Long

   sCount = SCount + 1
   
   For Counter& = 1 To Len(MyText$)
      Result$ = Result$ + Mid$(MyText$, Counter&, 1) + " "
   Next

   MyText$ = MyText$ + MyText$ ' Modifies the arg passed ByRef
   TestFunc$ = Result$ + Str$(sCount)
End Function

' Note: This tests something different from Factorial() in the other file.
'       Though both test recursion, here the x arg as well as the reuturn
'       value are Extended (instead of Long).

Function Factorial(ByVal x)
   If x > 1 Then
      Factorial = x * Factorial(x-1)
   Else
      Function = 1 ' Can return using either "Function" or the function name
   End If
End Function

Function Fibonacci(ByVal x)
   If x < 2 Then Fibonacci = x
   If x > 1 Then Fibonacci = Fibonacci(x-1) + Fibonacci(x-2)
End Function

Function PBMain () As Long 
   #Include "test3i.uc"

   ' Some string routines
   text$ = "   Hello   "
   Print "..."; text$; "..."
   Print "..."; RTrim$(text$); "..."
   Print "..."; LTrim$(text$); "..."
   Print "..."; Trim$(text$);  "..."


   ' Function, Sub, & misc
   MyGlobal  = 100 ' Defined w/ Global previously
   Counter&  = 55  ' Defined automatically (w/o being previously declared)
   sCount    = 15  ' sCount & Counter& not affected by local vars in TestFunc$()
   MyString$ = "Test"
   Answer$   = TestFunc$(MyString$)

   Print         
   Print Answer$, MyString$, Counter&, MyGlobal, sCount
   Print TestFunc$(MyString$), MyString$
   Print

   MySubA("Hello")
   MySubB("a", "b")
   MySubA "xyz"
   MySubB "x", "y"
   MySubA "ABC" : MySubB "x", "y" : MySubA "..."
   Print


   ' Recursive functions
   Print Fibonacci(20)
   Print "Factorial of 5: "; Factorial(5)
   Print Factorial(10), Factorial(5)+Factorial(10)
   Print Factorial(Factorial(3)), Factorial(Factorial(3)+1)
   Print Factorial(Factorial(3)+Factorial(2))
   Print


   ' Flexible Chr$()
   Print Chr$(65), Chr$("abc"), Chr$(65 to 70)
   Print Chr$(65, "*", 65 to 70, ".", asc("a") To Asc("g"))
   Print Chr$(65), Chr$("xyz"), Chr$(65 To 75)
   Print Chr$("Hello ", 65, 66, 67, "  ", 80 To 90)


   ' Macros
   Print
   Print MyMacro, mAdd(20, 30), mAdd("Good ", "day")


   ' Arrays
   Dim x As Long, text$(15), Number(15) As Long
   Dim NumAt(15) As Long At VarPtr(Number(0))

   For x = 1 To 12
      text$(x) = Mid$("Hello World!", x, 1)
      Number(x) = x^2
   Next

   Print : Print LBound(text$), UBound(Number)
   Print : Print "x", "text$(x)", "Number(x)", "NumAt(x)"

   For x = 1 To 12
      Print x, text$(x), Number(x), NumAt(x)
   Next


   Dim Year$(1995 To 2005)

   Print
   Print LBound(Year$); "To"; UBound(Year$)

   For x = LBound(Year$) To UBound(Year$)
      Year$(x) = "Year:" + Str$(x)
   Next

   For x = LBound(Year$) To UBound(Year$)
      ? x, Year$(x)
   Next


   ' Pointers
   Dim MyByte As Byte, MyBytePtr As Byte Ptr

   MyByte = 123
   MyBytePtr = VarPtr(MyByte)
   ? Chr$(MyByte), @MyBytePtr, Chr$(@MyBytePtr), Chr$(@MyBytePtr+2)
   @MyBytePtr = 65
   Print MyByte, @MyBytePtr, Chr$(@MyBytePtr), Asc(Chr$(@MyBytePtr))

   ' Index pointers
   Dim Txt  As String
   Dim Char As Byte   Ptr
   Dim sPtr As String Ptr
   Dim zPtr As Asciiz Ptr

   Txt  = "Hello"
   Char = StrPtr(Txt)
   sPtr = VarPtr(Txt)
   zPtr = StrPtr(Txt)

   Print
   ? @Char[0], @Char[1], @Char[2], @Char[3], @Char[4]

   For x = 0 To Len(Txt)-1
      Print x, Chr$(@Char[x])
   Next

   Print @sPtr, Len(@sPtr)
   Print @zPtr, Len(@zPtr)
   Txt = "New text"
   Print @sPtr, Len(@sPtr)


   ' Variable type conversions
   n = -1.15625
   Print
   Print CByt(n)
   Print CDbl(n)
   Print CDwd(n)
   Print Cext(n)
   Print CCur(n)
   Print CInt(n)
   Print CLng(n)
   Print CSng(n)
   Print CWrd(n)
   Print

   Print CvDwd("ABCD")
   Print MkDwd$(1162037582)
   Print


   ' File handling
   Open "Test3b.uc" For Input As #1
   While Not Eof(1)
      Line Input #1, LineOfText$
      Print LineOfText$, Seek(#1)
   Wend
   Print Lof(1)
   Close #1

   ' Note: Open For Output already tested in Test.uc

   f = FreeFile
   Open "Test3b.uc" For Append As #f
   Print #f, "This line is appended at the end."
   Print #f, "So is this."
   Print #f, "The End Part 2!"
   Close #f

   Open "Test3b.uc" For Binary As #1
   Print Seek(1), Lof(1)
   Get$ #1, Lof(1), AllFile$
   Print Seek(1)
   Print AllFile$
   Seek #1, 6 : Put$ #1, "ABCD"
   Print Seek(1)
   Seek 1, 21 : Put$ 1, "following:"
   Close #1

   Print : Print
   Open "test3b.uc" For Input As #1
   Line Input #1, LineOfText$
   Print LineOfText$
   Close #1

   Print : PRINT Int(Timer)
End Function

#Include "Test.uc"