'==============================================================================
'
' TestBas.uc BASIC test file for uCalc Language Builder. Uses Basic.uc.
'
' This file mainly tests flow control functionality, such as:
' For/Next, If/Then, Select Case, Do/Loop, and While/Wend.  Also tested here:
' a recursive function (Factorial), the Data statement, and other things.
'
' The output of this test file, when interpreted with uCalc LB, is identical
' to the output you get if you cut-and-paste this code exactly as-is into
' the PowerBASIC/CC 9 IDE and compile/run it.  Note: Tests for additional
' code that is very close to PB-syntax can be found in other files (Test*.uc).
'
'==============================================================================

DefLng a-z

' Tests mainly flow control

Sub FlowControlTest(ByVal MaxPass As Long)
   For Pass = 1 To MaxPass
      Print "Pass: "; Pass : Print
      If Pass < 5 Then
         For x = 1 To DataCount
            Select Case Read$(x)
               Case "Oak": Print Read$(x); " is a tree."
               Case Is "Sparrow": Print Read$(x); " is a bird."
               Case "Orange"
                  If Pass = 1 Then
                     Print Read$(x); " is a fruit."
                  Else
                     ? Read$(x); " is a color."
                  End If
               Case "Green"
                  If Pass = 1 Then
                     Print Read$(x); " is a color."
                  ElseIf Pass = 2 Then
                     Item$ = Read$(x)
                     For y = 1 To Len(Read$(x))
                        Print Mid$(Item$, y, 1);
                        Print " ";
                     Next
                  ElseIf Pass = 3 Then
                     Print "Leaves are " + LCase$(Read$(x)); "."
                  Else
                     Print "The lawn is " + UCase$(Read$(x)) + "."
                  End If
               Case "Ant"
                  ' Do nothing
               Case "Mouse"
                  If Pass = 1 _
                  Then Print Read$(x); " is a rodent." _
                  Else Print Read$(x); " is a PC accessory.
                  ' The missing end quote in the above line is intentional
               Case "Florida", "New York", "Texas", "South Dakota"
                  Print Read$(x); " is a state in the U.S."
               Case Else
                  Print "There is no info for: "; Read$(x)
            End Select
         Next
      Else
         x = 0
         Do
            x = x + 1
            Select Case x
               Case < 3: Print x; " is less than 3"
               Case 4 To 6, 10: Print x; " is between 4 and 6, or 10"
               Case 7
                  y = 0
                  While y <= 10
                     y = y + 1
                     If y Mod 2 = 0 Then Print y, y^2 Else Print y, y*100
                  Wend

                  Print : y = 3

                  While y > 0 : Print y, y*10; : Print " While/Wend"; : y = y-1 : Wend : Print
                  Do While y < 4 : y = y+1 : Print "Do While / Wend"; y : Loop
                  Print : Do Until y = 0 : Print "Do Until Loop"; y : y = y - 1 : Loop
                  Do : Print "Do Loop Until"; y : y = y + 1 : Loop Until y = 3
                  Print
                  Do : Print "Do Loop While"; y : y = y - 1 : Loop While y > 0
               Case 8, 9, > 10: ? x; Read$(x); Tab(20); LCase$(Read$(x)); Tab(40); UCase$(Read$(x))
            End Select
         Loop Until x = DataCount

         x = 0
         Do
            x = x + 1
            Print "Do/Loop While"; x
         Loop While x < 4

         Do While x > 0
            x = x - 1
            Print "Do While/Loop"; x
         Loop

         Do Until x = 3
            x = x + 1
            Print "Do Until/Loop"; x
         Loop
      End If
      Print
   Next

   Data "Orange", "Banana", Sparrow, "Green"
   Data Ant, "Mouse", "Oak", "Florida", "New York", "Texas"
   Data "Keyboard", South Dakota, "Panel", "Candy", I said "Hi!"
End Sub

Function Factorial(ByVal x)
   If x > 1 Then
      Factorial = x * Factorial(x-1)
   Else
      Function = 1 ' Can return using either "Function" or the function name
   End If
End Function

Function Test$(text$)
   Test$ = text$ + text$
End Function

Function Test2(y)
   For x = 1 To y
      If y < 10 Then Print x, x^2 Else Print x, x*100
   Next
   y = y * 10
End Function

Function PBMain () As Long
   t! = Timer
   Cls

   #If 0
      =========================================
      This tests various Flow Control routines
      =========================================
   #Else
      Print "======= Start ======="
   #EndIf

   Print "Factorial of 5: "; Factorial(5)
   Print Factorial(10), Factorial(5)+Factorial(10)
   Print

   x = -10 : y = -20
   FlowControlTest 5
   FlowControlTest 3
   FlowControlTest 0

   Print Test$("Testing ")
   Num = 5
   Test2(Num)
   Print Num
   Print x, y
   Print

   Print "Missing quote at the end
   Print "Nested ""quotes"" in string"
   Print "Missing ""nested"" mixture

   Print

   Print Max(3, 8, -5, 100, 75, 22, 9)
   Print Min(3, 8, -5, 100, 75, 22, 9)
   Print Max(5, 23, Max(-2, 57, Min(123, 456), 22), Min(523, 5), 11)
   Print Max$("Abc", "Zebra", "Car")
   Print Min$("Abc", "Zebra", "Car")

   a = 1
   b = a = 1
   c = a = 0

   Print a, b, c
   Let c = 10
   ? c, a = 1
   ? a = 1
   If a = 1 Then Print "a is one"

   Print : Print

   For x = 1 To 5
      If x > 0 And x < 4 Then
         If x = 1 Then Print "X is one (single line IF)"
         If x > 1 Then If x = 3 Then Print "X is three (single line IF)"
         If x = 1 Then Print "X is one (s/l IF/Else)" Else Print "x not one (single line IF)", x
         If x = 1 Then Print "X is one (s/l IF/Else If)" Else If x = 2 Then Print "x=two (s/l if else if)"

         If x = 2 Then Print "this" : Print "that", : Print x
      End If

      If x = 1 Then
         Print "If statement: x is one"
      End If

      If x = 1 Then
         Print "If/Else: x is one"
      Else
         Print "If/Else: x not one"
      End If

      If x = 1 Then
         Print "If/ElseIf: x = 1"
      ElseIf x = 2 Then
         Print "If/ElseIf: x = 2"
      End If

      If x = 1 Then
         Print "If/ElseIf/Else: x = 1"
      ElseIf x = 2 Then
         Print "If/ElseIf/Else: x = 2"
      Else
         Print "If/ElseIf/Else: x > 2", x
      End If

      If x = 1 Then
         Print "If/ElseIf/ElseIf: x = 1"
      ElseIf x = 2 Then
         Print "If/ElseIf/ElseIf: x = 2"
      ElseIf x = 3 Then
         Print "If/ElseIf/ElseIf: x = 3"
      End If

      If x = 1 Then
         Print "If/ElseIf/ElseIf/Else: x = 1"
      ElseIf x = 2 Then
         Print "If/ElseIf/ElseIf/Else: x = 2"
      ElseIf x = 3 Then
         Print "If/ElseIf/ElseIf/Else: x = 3"
      Else
         Print "If/ElseIf/ElseIf/Else: x > 3", x
      End If
   Next

   Dim m(5) As Byte
   x = 0
   Print
   Do
      x = x+1
      m(0) = x
      Print m(0), x   
   Loop While m(0) = 1 Or m(0) = 2
   Print m(0), x
   Print

   Print "======= Finish ======="

   Print "Execution time: "; Int((Timer-t!)*1e5)/1e5
   Print "Total time (Loading+Parsing+Execution): "; (GetTickCount - ucScriptTimerStart) / 1000

   #Include "Test.uc"
End Function