//==============================================================================
//
// TestCPP.uc C++ test file for uCalc Language Builder. Uses CPP.uc.
//
// Much of this will simply not work yet in the Aug 11 beta; don't copy/paste
// in bulk.  Try the other languages if you want something more stable.  You may
// try your hand at improving CPP.uc as an excercise if you'd like (but don't
// submit your improvements).
//==============================================================================

#define HelloMacro "Hello World macro"
#define LENGTH 100
#define WIDTH LENGTH * 2
#define SUM(x, y) ((x) + (y))
#define ignore

int MyGlobal = 123;

int testfunc(int x, int y, int z = 100)
{
   int result;
   result = MyGlobal + x + y * z;
   return (result);
}

float testfunc(float x, float y, float z) {  // function overload test
   return (x+y+z);
}

void ByRefTest(int x, int& y, int& z) {
   x = x - 1;
   y = x * 10;
   z *= z;
}

int main() {
   int a, b, c;
   float result = 7.25, fa, fb, fc;
   float * fptr; int * iptr;
   long xyz (10);
   unsigned short age;
   char str1[100];
   char str2[] = { 'T', 'e', 's', 't', '\0'};
   char str3[] = "Hello world";
   string FirstName, LastName;
   string Description = "Your name: ";
   float array1[15];
   int array2[] = { 5, 10, 15, 20, 25, 30, 50, 100, 200, 500 }

   a = fa = 1; b = fb = 2; c = fc = 3; fptr = &fb;   
   cout << testfunc(a, b, c) << " " << testfunc(5, 10) << " " << MyGlobal << endl;
   cout << testfunc(fa, fb, fc) << " " << *fptr << " " << *fptr * *fptr << endl;

   a=6; b=5; c=4; ByRefTest(a, b, c); cout << a << " " << b << " " << c << endl;

   MyGlobal = 321; cout << testfunc(1, 2, 3) << " " << MyGlobal << endl;

   iptr = &a; cout << *iptr << endl;
   *iptr = 2222; cout << a << endl;
   iptr =  array2;
   cout << *iptr << " " << *(iptr+1) << " " << *(iptr++) << " " << *(iptr++) << endl;
   iptr = &array2[5]; cout << *iptr << endl;
   iptr++; cout << *iptr << endl;
   iptr = array2+3; cout << *iptr << endl;

   a = result; cout // "result" here is distinct from local result in testfunc
       << a <<
       " " << result << " " <<
       xyz;
   
   a = b = c = 25;
   cout << a << " " << b << " " << c;
   a = b + (c = 10);
   cout << a << " " << b << " " << c;
   a -= 25; b *= 5+1; c+=20;
   cout << a << " " << b << " " << c;
   a--; c++; cout << a << " " << b++ << " " << c;
   a = 10; b = ++a; c = a++;
   cout << a << " " << b << " " << c << " " << ++a << " " << a++ << " " << a;
   cout << 0xFF << 0123 << 5e5 << endl;
   cout << 5==2 ? 10 : 20 << " " << 5==2+3 ? 10 : 20 << endl;
   a=(b=100, b+50);
   cout << a << " " << b << endl;

   GetConsoleTitle(str1, 50);
   cout << str1 << endl << str2 << endl << str3 << endl;
   cout << str1[0] << " " << str1[1] << " " << str1[2] << endl;
   cout << str2[0] << " " << str2[1] << " " << str2[2] << endl;
   cout << str3[0] << " " << str3[1] << " " << str3[2] << endl;

   cout << sizeof(a) << " " << sizeof(age) << " " << sizeof(long) << endl;
   cout << sizeof(float) << " " << sizeof(long double) << " " << sizeof(array2) << endl;
   cout << sizeof(char) << " " << sizeof(str1) << " " << sizeof(str2) << " " << sizeof(str3) << endl;

   a = 0;
   while (a < 10) {
      array1[a] = a * a;
      a++;
   }

   a = 0;
   while (a < 10) {
      cout << a << "   " << array1[a] << "   " << array2[a] << endl;
      a++;
   }

   array1[3]=2; array1[2]=4;
   cout << array2[array1] << " " << array1[3] + array1[2] << endl;


   a=0; while (a < 10) cout << a++;

   while (a > 0) {   // Count down
      cout << a << endl;      
      if (a == 1) cout << "Take off!" << endl;
      a--;
   }

   do
   {
      cout << "Number: " << a;
      if ((a % 2) == 0) cout << " is even"; else cout << " is odd";
      a++
   } while (a != 10)

   a = 123;
   for (int a=-5; a <= 5; a++) {
      cout << "Number: " << a;

      if (a % 2) cout << " is an even number"; else cout << " is an odd number";

      if (a == 0)
         cout << " and is 0";
      else if (a < 0)
         cout << " and negative";
      else
         cout << " and odd";

      cout << endl;
   }
   cout << a << endl; // the previously defined "a" is distinct from the "a" local to for()

   
   FirstName = "John"; LastName = "Doe";
   cout << Description + FirstName + " " + LastName; << endl;

   cout << "So what is your first name? ";
   _SendTextToInput("Daniel"+CrLf);  // This particular line is not C++; it's used for automated testing.
   cin >> FirstName;
   cout << endl << "How about your (imaginary) age? ";
   _SendTextToInput("123"+CrLf);
   cin >> age;

   age = -1; cout << age << endl;  // note: age is an unsigned short



   cout << "Hello World!"; << endl;
   cout << "This sentence \
   is spliced together \
   so that it all appears on one line." << endl;

   cout << "These strings "
           "are concatenated "
           "into one " "long string" << endl;

/* This
   is a comment
   cout << "Should not display this line" << endl;
*/

   cout << "This " << "is " << "a " << "test." << endl << "Line 2" << endl;
   cout << "Line 1\n Line 2\n";

// This line is a comment

   #if LENGTH
      cout << "Width: " << WIDTH << endl;
      cout << SUM(SUM(5, LENGTH), WIDTH) << " " << a+2*30 << endl;
      ignore // ignore is an empty macro
      cout << HelloMacro << endl; ignore
      cout << "Escape test: \x41\x42\x43;\t\'\"\? 

      #ifdef WIDTH
         cout << "WIDTH is defined" << endl;
      #endif

      #ifdef HMM
         cout << "Should not print" << endl;
      #endif

      #ifndef HMM
         cout << "HMM is not defined" << endl;
      #endif
   #else
      cout << "this should not be printed";
   #endif
}