Lock ~~ Var: ucSymbols As SortedList At uCalc(uc_GetSymbolTable)
Syntax: MBox {text} ::= MessageBox(0, Omni({text}), "uCalc", 0)

# Mechanism for allowing definitions during runtime ("#Def" must precede definitions)
Pass: 1 ~~ Syntax: #Def {Def:".*"} ::= ~Define({Def})
Pass: 1 ~~ Syntax: #Def {cr}   _
              {Def1:".*"} {cr} _
              [{Defs+} {cr}]   _
           #EndDef             _
           ::= ~Define({Def1}) {Defs: #Def {cr} {Defs} {cr} #EndDef}

# Opens a file and places all of its contents into a text string variable
Func: Load(FileName As String) As String = {
   ~Local(Var: FileHandle As Dword)
   ~Local(Var: lpText As LPCSTR * 100000)
   ~Local(Var: FileContent As String)

   SetVar(FileHandle, CreateFile(FileName+"",GENERIC_READ,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0));
   ReadFile(FileHandle, lpText, GetFileSize(FileHandle , 0), _Ignore, 0);
   SetVar(FileContent, lpText);
   CloseHandle(FileHandle);
   FileContent
}

# Returns the name of the data type associated with a given item
Func: TypeName(Item As String, t As Long = ~t) As String = {
   ~Local(Var: ItemHandle As Dword)
   ~Local(Var: dType As Dword)
   ~Local(Var: ExprPtr As Dword)
   ~Local(Var: Result As String)
   
   IIf(ucHandle(Item),
      SetVar(dType, uCalc(uc_GetItemData, Item, 0, uc_DataType, 0, t));
      SetVar(Result, uCalcStr(uc_GetItemData, NullStr, dType, uc_SymbolName))
   ,
      SetVar(ExprPtr, ucParse(Item, 0, t));
      SetVar(dType, uCalc(uc_GetItemData, NullStr, ExprPtr, uc_DataType, 0, t));
      SetVar(Result, uCalcStr(uc_GetItemData, NullStr, dType, uc_SymbolName));
      ucRelease(ExprPtr)
   );
   Result
}
Syntax: Type({Item}) ::= TypeName({q}{Item}{q})

# Sets Boolean output to True or False
Func: BooleanOutput(Item As Dword, Output As String) As String = IIf(Output<>"0", "True", "False")
#Execute: uCalc(uc_SetTypeOutput, "BooleanOutput", Boolean)

# This sets the output for members of a Stack or SortedList
Var: List_Open  = "{"
Var: List_Close = "}"
Var: List_Quote = "'"
Var: List_Sep   = ", "
Func: ListOutput(Item As Dword, Output As String) As String = {
   ~Local(Var: x)
   ~Local(Var: Result As String)
   ~Local(Var: Data As String)   
   
   uc_For(x, 1, uc_Count(__(Item)), 1,
          SetVar(Data, uc_ReadStr(__(Item), x));          
          IIf(_Type(Item) == SortedList Or _Type(uc_ReadHandle(__(Item), x)) == String,
              SetVar(Data, List_Quote + Data + List_Quote)
          );
          SetVar(Result, Result + List_Sep + Data)
   );
   
   List_Open + Mid(Result, 3) + List_Close
}
Execute: uCalc(uc_SetTypeOutput, "ListOutput", Stack)
Execute: uCalc(uc_SetTypeOutput, "ListOutput", SortedList)

# This sets the output for members of a Table list
Func: TableListOutput(Item As Dword, Output As String) As String = {
   ~Local(Var: x)
   ~Local(Var: Key As String)
   ~Local(Var: Result As String)
   ~Local(Var: Data As String)
   
   uc_For(x, 1, uc_Count(__(Item)), 1,
          SetVar(Key, uc_ReadKey(__(Item), x));
          SetVar(Result, Result + ", '" + Key + "'");
          SetVar(Data, uc_ReadData(__(Item), Key));
          IIf(uCalc(uc_GetItemData, "", Handle(__(Item), Key), uc_DataType)==String, SetVar(Data, "'"+Data+"'"));
          SetVar(Result, Result + ", " + Data)          
   );

   "{" + Mid(Result, 3) + "}"
}
Execute: uCalc(uc_SetTypeOutput, "TableListOutput", Table)


Func: ByteArrayString(Item As Dword, Output As String) As String = {
   ~Local(Var: ArgCount As Long)
   SetVar(ArgCount, uCalc(uc_GetItemData, "", Item, uc_ArgCount));
   IIf(ArgCount, uc_Peek(uCalc(uc_GetItemData, "", Item, uc_Address), ArgCount), Output)   
}
Execute: uCalc(uc_SetTypeOutput, "ByteArrayString", Byte)


/*

# Surrounds string output with quotes (this one's for temporary use only)
Func: StringOutput(Item As Dword, Output As String) As String = {
   IIf(InStr(Output, '"') > 0 Or InStr(Output, "'") == 0, "'" + Output + "'", '"' + Output + '"')
}
#Execute: uCalc(uc_SetTypeOutput, "StringOutput", String)

# Appends a "0" in front of non-integer values between -1 and 1 (for example 0.5 instead of .5)
Func: NumericTypeOutput(ByVal Item As Dword, ByVal Output As String) As String = {
   IIf(Asc(Output) == Asc("."),
      "0" + Output,
      IIf(Asc(Output) == Asc("-") And Asc(Output, 2) == Asc("."),
         "-0." + Mid(Output, 3),
         Output
      )
   )
}

uCalc(uc_SetTypeOutput, 'NumericTypeOutput', Single)


ListFormat: Start: "{"    Sep: ", "   End: "}"    QuoteChar: '"'
*/

