# Note: String & Extended are first defined in uCalc.uc

Begin
   DataType: Single
   Size: 4
   TypeHandler: @uc_Single
   ConvertsTo: Extended, @uc_Convert_Single_Extended
End

Begin
   DataType: Double
   Size: 8
   TypeHandler: @uc_Double
   ConvertsTo: Extended, @uc_Convert_Double_Extended   
End

Begin
   DataType: Integer
   Size: 2
   TypeHandler: @uc_Int16
   ConvertsTo: Extended, @uc_Convert_Int16_Extended
End

Begin
   DataType: Long
   Size: 4
   TypeHandler: @uc_Int32
   ConvertsTo: Extended, @uc_Convert_Int32_Extended
   ConvertsTo: Double, @uc_Convert_Int32_Double
   ConvertsFrom: Integer
   ConvertsTo: Integer
End

Begin
   DataType: Int64
   Size: 8
   TypeHandler: @uc_Int64
   ConvertsTo: Extended, @uc_Convert_Int64_Extended
End

Begin
   DataType: Byte
   Size: 1
   TypeHandler: @uc_Int8u
   ConvertsTo: Extended, @uc_Convert_Int8u_Extended
   ConvertsTo: Long
End

Begin
   DataType: Word
   Size: 2
   TypeHandler: @uc_Int16u
   ConvertsTo: Extended
   ConvertsTo: Long
   ConvertsFrom: Byte
   ConvertsFrom: Long
End

Begin
   DataType: Dword
   Size: 4
   TypeHandler: @uc_Int32u
   ConvertsTo: Long
   ConvertsTo: Extended, @uc_Convert_Int32u_Extended
   ConvertsFrom: Long
End

# Configurable Boolean output is set in another file (Tools.uc)
Begin
   DataType: Boolean
   Size: 4
   TypeHandler: @uc_Int32
   ConvertsTo: Extended, @uc_Convert_Int32_Extended
   ConvertsTo: Long
   ConvertsTo: Dword
   ConvertsFrom: Long
   ConvertsFrom: Dword
End

Begin
   DataType: Currency
   Size: 8
   TypeHandler: @uc_Currency
   ConvertsTo: Extended
End

Begin
   DataType: LPCSTR
   TypeHandler: @uc_String_LPCSTR
   ConvertsTo: String
End

Begin
   DataType: FixedString
   TypeHandler: @uc_String_Fixed
   ConvertsTo: String
End

Begin
   DataType: String   
   Size: 4
   TypeHandler: @uc_String
   ConvertsTo: LPCSTR
   ConvertsTo: FixedString
   Overhead
End

Begin
   DataType: SortedList
   Size: 4
   TypeHandler: @uc_SortedList
   ConvertsTo: Stack, @uc_Convert_SortedList_Stack
   ConvertsTo: String
End

Begin
   DataType: Table
   Size: 4
   TypeHandler: @uc_Table
   ConvertsTo: Stack, @uc_Convert_Table_Stack
   ConvertsTo: String
End

Begin
   DataType: Stack
   Size: 4
   TypeHandler: @uc_Stack
   ConvertsTo: Table, @uc_Convert_Stack_Table
   ConvertsTo: SortedList, @uc_Convert_Stack_SortedList
End

Begin
   DataType: Void
   Size: 10
   TypeHandler: @uc_Void
   ConvertsTo: Extended, @uc_Convert_Void_Extended
   ConvertsFrom: Long
   ConvertsFrom: Dword
   ConvertsFrom: Extended
End

Begin
   DataType: Extended
   ConvertsTo: Long, @uc_Convert_Extended_Int32
   ConvertsTo: Boolean, @uc_Convert_Extended_Int32
   ConvertsTo: Dword, @uc_Convert_Extended_Int32
   ConvertsTo: Single, @uc_Convert_Extended_Single
   ConvertsTo: Double, @uc_Convert_Extended_Double
   ConvertsTo: Byte
   ConvertsTo: Word
   ConvertsTo: Integer
   ConvertsTo: Int64
   ConvertsTo: Currency
   ConvertsTo: Boolean
End

Begin
   DataType: Double   
   ConvertsTo: Long, @uc_Convert_Double_Int32   
End

Begin
   DataType: OmniType
   Size: 4
   TypeHandler: @uc_String
   ConvertsToAny
   ConvertsFromAny
End
