Begin
   DataType: COORD
   {Var: x As Integer}
   {Var: y As Integer}
   TypeHandler: @uc_User_Type
End

Begin
   DataType: SMALL_RECT
   {Var: Left As Integer}
   {Var: Top As Integer}
   {Var: Right As Integer}
   {Var: Bottom As Integer}
   TypeHandler: @uc_User_Type
End

Begin
   DataType: CONSOLE_SCREEN_BUFFER_INFO
   {Var: dwSize As COORD}
   {Var: dwCursorPosition As COORD}
   {Var: wAttributes As Word}
   {Var: srWindow As SMALL_RECT}
   {Var: dwMaximumWindowSize As COORD}
   TypeHandler: @uc_User_Type
End

Begin
  DataType: KEY_EVENT_RECORD
  {Var: bKeyDown As Long}
  {Var: wRepeatCount As Word}
  {Var: wVirtualKeyCode As Word}
  {Var: wVirtualScanCode As Word}
  {Var: uChar As Integer}
  {Var: dwControlKeyState As Dword}
  TypeHandler: @uc_User_Type
End

# Must later add union +++
Begin
  DataType: INPUT_RECORD
  {Var: EventType As Word}
  {Var: Skip As Word}
  {Var: Event As KEY_EVENT_RECORD}
  TypeHandler: @uc_User_Type
End

Func: AllocConsole() As Long At GetProcAddress(Kernel32, "AllocConsole")

Func: FreeConsole() As Long At GetProcAddress(Kernel32, "FreeConsole")

Func: FillConsoleOutputCharacter(ByVal hConsoleOutput As Dword,               _
      ByVal Character As Byte, ByVal nLength As Dword,                        _
      ByVal dwWriteCoord As COORD, ByRef lpNumberOfCharactersWritten As Long) _
      As Long At GetProcAddress(Kernel32, "FillConsoleOutputCharacterA")

Func: FlushConsoleInputBuffer(ByVal hConsoleInput As Dword) As Long _
      At GetProcAddress(Kernel32, "FlushConsoleInputBuffer")

Func: GetConsoleScreenBufferInfo(ByVal hConsoleOutput As Dword,              _
      ByRef lpConsoleScreenBufferInfo As CONSOLE_SCREEN_BUFFER_INFO) As Long _
      At GetProcAddress(Kernel32, "GetConsoleScreenBufferInfo")

Func: GetConsoleTitle(ByRef lpConsoleTitle As LPCSTR, ByVal nSize As Dword) _
      As Long At GetProcAddress(Kernel32, "GetConsoleTitleA")

Func: GetFileType(ByVal hFile As Dword) As Long At GetProcAddress(Kernel32, "GetFileType")

Func: GetLargestConsoleWindowSize(ByVal hConsoleOutput As Dword) As Long _
      At GetProcAddress(Kernel32, "GetLargestConsoleWindowSize")

Func: GetStdHandle(ByVal nStdHandle As Dword) As Dword At GetProcAddress(Kernel32, "GetStdHandle")

Func: ReadConsole(ByVal hConsoleInput As Dword, ByRef lpBuffer As LPCSTR, _
      ByVal nNumberOfCharsToRead As Long, ByRef lpNumberOfCharsRead As Long, _
      ByRef lpReserved As Long) As Long At GetProcAddress(Kernel32, "ReadConsoleA")

Func: ReadConsoleInput(ByVal hConsoleInput As Dword,         _
      ByRef lpBuffer As INPUT_RECORD, ByVal nLength As Long, _
      ByRef lpNumberOfCharsRead As Long) As Long             _
      At GetProcAddress(Kernel32, "ReadConsoleInputA")

Func: ReadConsoleOutputCharacter(ByVal hConsoleOutput As Dword, _
      ByRef szCharacter As LPCSTR, ByVal nLength As Long,       _
      ByVal dwReadCoord As Dword, ByRef lpNumberOfCharsRead As Long) As Long _
      At GetProcAddress(Kernel32, "ReadConsoleOutputCharacterA")

#Func: ReadFile() is in MiscAPI.uc

Func: SetConsoleCursorPosition(ByVal hConsoleOutput As Dword, _
      ByVal CursorPosition As COORD) As Long                  _
      At GetProcAddress(Kernel32, "SetConsoleCursorPosition")

Func: SetConsoleMode(ByVal hConsoleHandle As Dword, ByVal dwMode As Dword) _
      At GetProcAddress(Kernel32, "SetConsoleMode")

Func: SetConsoleTextAttribute(ByVal hConsoleOutput As Dword, ByVal vAttributes As Word) As Long _
      At GetProcAddress(Kernel32, "SetConsoleTextAttribute")

Func: SetConsoleTitle(ByRef lpConsoleTitle As LPCSTR) As Long _
      At GetProcAddress(Kernel32, "SetConsoleTitleA")

Func: SetConsoleWindowInfo(ByVal hConsoleOutput As Dword,                   _
      ByVal bAbsolute As Long, ByRef lpConsoleWindow As SMALL_RECT) As Long _
      At GetProcAddress(Kernel32, "SetConsoleWindowInfo")

Func: WriteConsole(ByVal hConsoleOutput As Dword,    _
      ByRef lpBuffer As LPCSTR,                      _
      ByVal nNumberOfCharsToWrite As Long,           _
      ByRef lpNumberOfCharsWritten As Long,          _
      ByVal lpReservered As Long) As Long            _
      At GetProcAddress(Kernel32, "WriteConsoleA")

#Func: WriteFile() is in MiscAPI.uc

Var: EndOfInput As Long
Var: _Ignore As Long
Var: _Coord As COORD
Var: _Coord00 As COORD
Var: _LineLength As Long
Var: _ScrBuff As CONSOLE_SCREEN_BUFFER_INFO
Var: _InputRecord As INPUT_RECORD
Var: _Echo As Long
Var: _NoConsole As Long
Var: ConsoleHandle As Long
Var: InputBuffer As String

Const: ENABLE_PROCESSED_INPUT = 1
Const: ENABLE_LINE_INPUT      = 2
Const: ENABLE_ECHO_INPUT      = 4
Const: STD_INPUT_HANDLE       = -10
Const: STD_OUTPUT_HANDLE      = -11
Const: STD_ERROR_HANDLE       = -12

Const: KEY_EVENT                = #H1
Const: MOUSE_EVENT              = #H2
Const: WINDOW_BUFFER_SIZE_EVENT = #H4
Const: MENU_EVENT               = #H8
Const: FOCUS_EVENT              = #H10

Const: VK_RETURN       = #HD
Const: VK_TAB          = #H9
Const: VK_MENU         = #H12
Const: VK_SPACE        = #H20
Const: VK_LEFT         = #H25
Const: VK_UP           = #H26
Const: VK_RIGHT        = #H27
Const: VK_DOWN         = #H28
Const: VK_INSERT       = #H2D
Const: VK_DELETE       = #H2E
Const: VK_U            = #H55
Const: WM_KEYDOWN      = #H100
Const: WM_KEYUP        = #H101
Const: WM_CHAR         = #H102
Const: WM_SYSKEYDOWN   = #H104
Const: WM_SYSKEYUP     = #H105
Const: KEYEVENTF_KEYUP = #H2


#Derived
Func: LoadConsole(Title As String) = {
      AllocConsole();
      SetConsoleTitle(Title+"");
      SetConsoleMode(GetStdHandle(STD_INPUT_HANDLE), ENABLE_LINE_INPUT+ENABLE_ECHO_INPUT+ENABLE_PROCESSED_INPUT);
      Sleep(40); SetVar(ConsoleHandle, FindWindow(0, Title+""))
}

IfFileOption: /NoConsole Execute: SetVar(_NoConsole, True)
If: GetFileType(GetStdHandle(STD_OUTPUT_HANDLE)) <> FILE_TYPE_DISK And _NoConsole==False ~~ Execute: LoadConsole("uCalc Console")

Const: StdIn  As Dword = GetStdHandle(STD_INPUT_HANDLE)
Const: StdOut As Dword = GetStdHandle(STD_OUTPUT_HANDLE)
Const: StdErr As Dword = GetStdHandle(STD_ERROR_HANDLE)

Func: Write(Text As String) As Void = WriteFile(StdOut, Text+"", Len(Text), 0, 0)
Func: WriteLn(Text As String = NullStr) As Void = Write(Text+CrLf)
Func: Write(Output As Dword, Text As String) As Void = WriteFile(Output, Text+"", Len(Text), 0, 0)
Func: WriteLn(Output As Dword, Text As String = NullStr) As Void = Write(Output, Text+CrLf)
Func: WriteConsole(Text As String) As Void = WriteConsole(StdOut, Text+"", Len(Text), 0, 0)

Func: InputKey() As String = {
      uc_Loop(1,
         ReadConsoleInput(StdIn, _InputRecord, 1, _Ignore),
         (_InputRecord.EventType == KEY_EVENT And _InputRecord.Event.bKeyDown <> 0)==0
      ); Chr(_InputRecord.Event.uChar)
}

Func: ReadLine_FromConsole() As String = {
      ~Local(Var: Ignore As Long)
      ~Local(Var: LineLength As Long)
      ~Local(Var: lpText As LPCSTR * 1024)
      SetForegroundWindow(ConsoleHandle);
      ReadFile(StdIn, lpText, 1000, LineLength, Ignore);
      uc_Peek(VarPtr(lpText), LineLength - 2)
}

Func: ReadLine_FromFile(Input As Dword = StdIn) As String = {
      ~Local(Var: BytesRead As Long)
      ~Local(Var: FullLine As String)
      ~Local(Var: lpText As LPCSTR * 2)
      uc_Loop(1,
         ReadFile(Input, lpText, 1, BytesRead, 0);
         Iif(Asc(lpText)>13, SetVar(FullLine, FullLine+lpText)),
      BytesRead <> 0 And lpText <> Chr(10));
      Iif(BytesRead==0, SetVar(EndOfInput, True)); IIf(_Echo, WriteLn(FullLine)); FullLine
}

If: GetFileType(StdIn) == FILE_TYPE_CHAR ~~ Func: ReadLine() As String = ReadLine_FromConsole()
If: GetFileType(StdIn) == FILE_TYPE_DISK ~~ Func: ReadLine() As String = ReadLine_FromFile()

# This one is for debugging
# +++ PostMessage w/ WM_CHAR doesn't work w/ double characters
# such as the 11 in "2011".  Find out why (not related to uCalc).
Func: _SendTextToInput(text As String) As Void = {
   ~Local(Var: x As Long)

   uc_For(x, 1, Len(text), 1,
      PostMessage(ConsoleHandle, WM_CHAR, Asc(text, x), 0)
   )
}


Func: ScreenX() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff); _ScrBuff.dwSize.x
Func: ScreenY() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff); _ScrBuff.dwSize.y
Func: CursorX() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff); _ScrBuff.dwCursorPosition.x+1
Func: CursorY() = GetConsoleScreenBufferInfo(StdOut, _ScrBuff); _ScrBuff.dwCursorPosition.y+1
Func: NextPrintZone() As Void = {
      SetVar(_Coord.x, (CursorX+14)\14*14);
      SetVar(_Coord.y, CursorY-1);
      iif(_Coord.x > ScreenX-1, SetVar(_Coord.x, ((_Coord.x+1) mod ScreenX)-1); SetVar(_Coord.y, _Coord.y+1); 0);
      SetConsoleCursorPosition(StdOut, _Coord)
}

Func: Cls() As Void = FillConsoleOutputCharacter(StdOut, 32, 100000, _Coord00, _Ignore); _
      SetConsoleCursorPosition(StdOut, _Coord00)