# Prefix Operator

Syntax: Op: {Name} '{' {Operand} '}' [As {type}] ::= _
        Name: {Name} ~~ Param: {Operand} ~~ DataType: {type} ~~ Properties: ucPrefix+ucOperator


# Postfix Operator

Syntax: Op: '{' {Operand} '}' {Name} [As {type}] ::= _
        Name: {Name} ~~ Param: {Operand} ~~ DataType: {type} ~~ Properties: ucPostfix+ucOperator


# Infix Operator

Syntax: Op: '{' {LeftOp} '}' {Name} '{' {RightOp} '}' [As {type}] ::= _
        Name: {Name} ~~ Param: {LeftOp} ~~ Param: {RightOp} ~~ DataType: {type} ~~ Properties: ucInfix+ucOperator

Syntax: Op: {Def} { ':=' {Expr:'.+'} | At {addr} } ::= Op: {Def} {addr: ~~ Address: {addr} ~~ StdCall} {Expr: ~~ FuncBody: {Expr}}
Syntax: Op: {pValue:' *[0-9]+ '} {Def} ::= Precedence: {pValue} ~~ Op: {Def}
Syntax: Op: Precedence({op}) ::= Op: ~Eval(Precedence({op}))
Syntax: Op:: {Def:'.+'} ::= NativeCall ~~ Op: {Def}
Syntax: Op: Native: {Def} At {Addr} ::= NativeCall ~~ Address: {Addr} ~~ Op: {Def}


# Variables

Syntax: Var: {VarName:1} ::= Var: <DefaultType>{VarName}
Syntax: Var: <{type}>{VarName:1} [= {Value}] [At {Addr:' .+'}] ::= _
        Name: {VarName} ~~ Variable ~~ DataType: {type}            _
        {Value:  ~~ Value: {Value}} {Addr:   ~~ Address: {Addr}}
Syntax: Var: {VarName:1} As {type:1} ::= Var: <{type}>{VarName}
Syntax: Var: {VarName:1} As {type:1} * {size} ::= Var: <{type}>{VarName} ~~ Size: {size}
Syntax: Var: {VarName:1}({index}) As {type:1} ::= Var: <{type}>{VarName}({index})
Syntax: Var: {VarName:1} As AnyType ::= AnyType ~~ Var: {VarName}
Syntax: Var: {PassBy:'( +ByRef)|( +ByVal)|( +ByHandle)|( +ByExpr)'} ::= {PassBy} ~~ Var:
Syntax: Var: {Def} ... ::= Var: {Def} ~~ VariableArgList
Syntax: Var: ... ::= Name: _ ~~ Variable ~~ VariableArgList
Syntax: Var: {name:1} = {quote:' *[\x22\x27]'} ::= Var: {name} As String = {quote}
Syntax: Var: <DefaultType>{VarName:1} ::= Var: <Extended>{VarName}

Syntax: Var: <{type}>{ArrayName:1}([{LowerBound=0} To] {UpperBound}) [{etc}]::= _
        Count: {UpperBound}-{LowerBound}+1 ~~ Var: <{type}>{ArrayName} {etc}  _
        ~~ NextDef: { Precedence: 100 ~~ _
        Syntax: {ArrayName}({Index})::= ValAtAddr({ArrayName}, {Index}-{LowerBound}) } _
        ~~ NextDef: { Syntax: UBound({ArrayName}) ::= {UpperBound} } _
        ~~ NextDef: { Syntax: LBound({ArrayName}) ::= {LowerBound} }

Syntax: Var: {TableName:1} As Table [{etc}] ::= Var: <Table>{TableName} {etc} _
        ~~ NextDef: { Precedence: 100 ~~ Syntax: {TableName}({ItemName}) ::= _
        ValueAtAddr(hDataType(Handle({TableName}, {ItemName})), hAddress(Handle({TableName}, {ItemName}))) }

Syntax: Var:: {type:1} {name} ::= Name: {name} ~~ variable ~~ DataType: {type}

Syntax: Const: {Def:'.*'} ::= Var: {Def} ~~ Properties: ucLock


# Functions
SkipOver ~~ Pass: All ~~ Syntax: Func: {def:"[\x00-\xFF]+"}
Syntax: Func: {FuncName:1} ([{ParamList}]) [As {type}] [{ = {Def:'.+'} | At {addr} }] ::= _
        Name: {FuncName} ~~ Params: ({ParamList}) ~~ DataType: {type} _
        ~~ Properties: ucFunction + ucPrefix _
        {addr: ~~ Address: {addr} ~~ StdCall} ~~ FuncBody: {Def}
Syntax: Func:: ::= NativeCall ~~ Func:
Syntax: Func: Native: {Def} At {Addr} ::= NativeCall ~~ Address: {Addr} ~~ Func: {Def}

Syntax: Params: ([{SingleParam+}]) ::= IsParam ~~ { {SingleParam: Var: {SingleParam}} }
Syntax: Params: ({Variable} = {Default}) ::= Params: ({Variable} ~~ TextData: {Default})
Syntax: Params: ({Param1}, {OtherParams}) ::= Params: ({Param1}) ~~ Params: ({OtherParams})
Syntax: Param: {ParamDef} [~~] ::= IsParam ~~ { Var: {ParamDef} } ~~

Syntax: ArgCount()      ::= 0
Syntax: ArgCount({Arg}) ::= 1
Syntax: ArgCount({FirstArg}, {OtherArgs}) ::= ~Eval(1 + ArgCount({OtherArgs}))

Syntax: Rename: {old:1} {new:1} [, {other}] ::= ~Eval(ucRename({old}, {new})) {other: Rename: {other}}
Syntax: Synonym[([[Pass] {pass}])]: {symbol:1} [{equivalent:1}] [, {other}] ::= _
        ~Define({pass: Pass: {pass} ~~} Syntax: {symbol} ::= {equivalent}) {other: Synonym({pass}): {other}}

SyntaxArg: {cr} = {#13#10}      ~~ # Carriage return (CRLF)
SyntaxArg: {lf} = {#10}         ~~ # Line feed (LF)
SyntaxArg: {dq} = {#34}         ~~ # Double quote
SyntaxArg: {sq} = {#39}         ~~ # Single quote
SyntaxArg: {q}  = {#3}          ~~ # Quote using invisible character
SyntaxArg: {q1} = {#17}         ~~ #    "           "          "
SyntaxArg: {q2} = {#18}         ~~ #    "           "          "
SyntaxArg: {qq} = {#19}         ~~ # Invisible quote on evaluated arg
SyntaxArg: {Prog_Start} = {#20} ~~ # Can be used as 1st char in a program
SyntaxArg: {Prog_End}   = {#21} ~~ # Can be used as last char in a program
SyntaxArg: {ns} = {#3#3}        ~~ # Null String using empty quotes
SyntaxArg: {sp} = {#32}         ~~ # blank space
SyntaxArgR: {Self} = {#15}      ~~ # Current expression

# SyntaxArgX: {abcd} --> SyntaxArg: {abcd} = {#31}abcd{#31}  where {#31} is a randomly chosen non-printing char
Syntax: SyntaxArgX: "{" {Name} "}" ::= ~Define(SyntaxArg: {{Name}} = {#31}{Name}{#31})

Syntax: {qq}{data$%+}{qq} ::= {q2}{data}{q2}
Syntax: Quote({data$%+})  ::= {q2}{data}{q2}
Syntax: UnQuote({"{q}"}[{text:"[^{q}]+"}]{"{q}"}) ::= {text}
Syntax: UnQuote({"\q"}[{text:"[^\q]+"}]{"\q"}) ::= {text}
Syntax: UnQuote({"'"}[{text:"[^']+"}]{"'"}) ::= {text}
Syntax: ___({handle}) ::= ~Eval(Chr(uc_HandleToken) + uc_Peek(VarPtr({handle}), 4))
Syntax: __ ::= SpecialArg
#Syntax: _({name}) ::= ~Eval(Chr(uc_HandleToken) + uc_Peek(VarPtr(ucHandle({name})), 4))
#Syntax: __({Item}) ::= ~Eval(Chr(uc_HandleToken)+uc_Peek(VarPtr({Item}), 4))
Syntax: _({name}) ::= ~Eval(Chr(uc_HandleToken)+uc_Peek(VarPtr(uCalc(uc_GetItemData, {name}, 0, uc_Handle, ucVariable)), 4))
