Var: _Number    As String = '([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)?'
Var: _HexNumber As String = '([0-9a-z]*\.)?[0-9a-z]+(e[-+]?[0-9]+)?'
Var: _Alpha     As String = '[a-z_][0-9a-z_]*'
Var: _sAlpha    As String = ' *[a-z_][0-9a-z_]*'
#Precedence: 60 ~~ Syntax: {Num:_Number}{Alpha:_Alpha} ::= {Num}*{Alpha}

Syntax: {"#b"}{Number:_Number}       ::= ~Eval(BaseConvert({q}{Number}{q}, 2))
Syntax: {"#o"}{Number:_Number}       ::= ~Eval(BaseConvert({q}{Number}{q}, 8))
Syntax: {"#h"}{Number:_HexNumber}    ::= ~Eval(BaseConvert({q}{Number}{q}, 16))
Precedence: 10 ~~ Syntax: {x} += {y} ::= SetVar({x}, {x} + {y})
Precedence: 10 ~~ Syntax: {x} -= {y} ::= SetVar({x}, {x} - {y})

Op:  +{x} := x   ~~ Precedence: 70
Op:: -{x}        ~~ Precedence: 70 ~~ Address: @uc_Op_Negate
Op:: {x As Stack}+{y As Stack}  As Stack  ~~ Precedence: 50 ~~ Address: @uc_Op_Concat_Stack
Op:: {x As Long} +{y As Long}   As Long   ~~ Precedence: 50 ~~ Address: @uc_Op_Add_Int32

Op:: {x}>{y}  As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_GreaterThan
Op:: {x}<{y}  As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_LessThan
Op:: {x}>={y} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_GreaterOrEqual
Op:: {x}<={y} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_LessOrEqual
Op:: {x}<>{y} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_NotEqual
Op:: {x}=={y} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_Equal

Op:: {x As String}>{y As String}  As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_GreaterThan_Str
Op:: {x As String}<{y As String}  As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_LessThan_Str
Op:: {x As String}>={y As String} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_GreaterOrEqual_Str
Op:: {x As String}<={y As String} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_LessOrEqual_Str
Op:: {x As String}<>{y As String} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_NotEqual_Str
Op:: {x As String}=={y As String} As Boolean ~~ Precedence: 40 ~~ Address: @uc_Op_Equal_Str
Op:: {x As String}+{y As String} As String ~~ Precedence: 50 ~~ Address: @uc_Op_StrConcat

Op:: {x As Boolean} And     {y As Boolean} As Boolean ~~ Precedence: 30 ~~ Address: @uc_Op_And_Int32
Op:: {x}         AndAlso {ByExpr y}          ~~ Precedence: 30 ~~ Address: @uc_Op_AndAlso
Op:: {x As Boolean} Or      {y As Boolean} As Boolean ~~ Precedence: 20 ~~ Address: @uc_Op_Or_Int32
Op:: {x}         OrElse  {ByExpr y}          ~~ Precedence: 20 ~~ Address: @uc_Op_OrElse

Op:: {x}+{y}     ~~ Precedence: 50 ~~ Address: @uc_Op_Add
Op:: {x}-{y}     ~~ Precedence: 50 ~~ Address: @uc_Op_Subtract
Op:: {x}*{y}     ~~ Precedence: 60 ~~ Address: @uc_Op_Multiply
Op:: {x}/{y}     ~~ Precedence: 60 ~~ Address: @uc_Op_Divide
Op:: {x} Mod {y} ~~ Precedence: 60 ~~ Address: @uc_Op_Mod
Op:: {x}^{y}     ~~ Precedence: 80 ~~ Address: @uc_Op_PowerOf_ExtToExt

Op:: {x As Long}! ~~ Precedence: 90 ~~ Address: @uc_Op_Factorial
Op:: {x As Long}\{y As Long} As Long ~~ Precedence: 60 ~~ Address: @uc_Op_Divide_Int32

Func:: Sin(x)      ~~ Address: @uc_Func_Sin
Func:: Cos(x)      ~~ Address: @uc_Func_Cos
Func:: Tan(x)      ~~ Address: @uc_Func_Tan
Func:: Atan(x)     ~~ Address: @uc_Func_Atan
Func:: Abs(x)      ~~ Address: @uc_Func_Abs
Func:: Exp(x)      ~~ Address: @uc_Func_Exp
Func:: Log(x)      ~~ Address: @uc_Func_Log
Func:: Ceil(x) As Long ~~ Address: @uc_Func_Ceil
Func:: Sqr(x)      ~~ Address: @uc_Func_SquareRoot
Func:: Int(x)      ~~ Address: @uc_Func_Int
Func:: Frac(x)     ~~ Address: @uc_Func_Frac
Func:: Sgn(x)      ~~ Address: @uc_Func_Sgn
Func:: Rand(x = 1) ~~ Address: @uc_Func_Rand
Func:: Rand(x As Long, y As Long) ~~ Address: @uc_Func_Rand

Func:: Min(x ...)  ~~ Address: @uc_Func_Min
Func:: Max(x ...)  ~~ Address: @uc_Func_Max
Func:: Min(x As String ...) As String ~~ Address: @uc_Func_Min_Str
Func:: Max(x As String ...) As String ~~ Address: @uc_Func_Max_Str   

Func:: BaseConvert(Number As String, Base As Long) ~~ Address: @uc_Func_BaseConvert

Func:: IIf(cond As Boolean, ByExpr True As String, ByExpr False As String = '') As String ~~ Address: @uc_Func_IIF_Str
Func:: IIf(cond As Boolean, ByExpr True, ByExpr False = 0) ~~ Address: @uc_Func_IIF
Func: Inf() = 1/0
Func: NaN() = 0/0
