# PBFix.uc - uCalc Transformation file
# This file was saved with uCalc Search/Replace (beta) - Beta #21
# Comment: This demo makes changes to PowerBASIC source code

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterStartText, FilterUnique

FindMode: Replace

# Definitions
Include: Patterns.uc
Token: [\(\)] ~~ ~~ Properties: ucAlphaNumeric ~~ # Treats parenthesis as ordinary characters
Token: [$%]?[a-z][0-9a-z_]* ~~ ~~ Properties: ucAlphaNumeric
Token: [a-z_][0-9a-z_]*[%&?!#@$]{1,3} ~~ ~~ Properties: ucAlphaNumeric
EvalSpace: uCalc.uc /NoConsole
SyntaxArg: {marker} = {#20}
SyntaxArg: {space} = {#32}

# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: This demo makes changes to PowerBASIC source code
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Transparent
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: False
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Inserts marker
Pass: 1

Criteria: 2
Comment: Adds a marker (and newline) at the beginning of code; the marker will gradually move to the end.
Selected: True
PassOnce: True
Find: {AllText:"[\x00-\xFF]+"}
Replace: {marker}{AllText}

Criteria: 3
Comment: 
Pass: 2

Criteria: 4
Comment: Deletes the marker once it reaches the end
PassOnce: True
Find: {marker}
Replace: 

Criteria: 5
Comment: Moves marker without changing color for all tokens that do not need color
Highlight: True
ForeColor: Black
Find: {marker}{AnyToken:1}
Replace: {AnyToken}{marker}

Criteria: 6
Comment: Inserts missing quote at the end
Find: {marker}{QuotedText:"[\q][^\q\n]*"}{nl}
Replace: {QuotedText}"{nl}{marker}

Criteria: 7
Highlight: True
Find: {marker}?
Replace: Print{marker}

Criteria: 8
ForeColor: Green
Find: {marker}{Comment:"'.*"}
Replace: {Comment}{marker}

Criteria: 9
Highlight: True
Find: {marker}{variable} = {variable} +
Replace: {variable} +={marker}

Criteria: 10
Find: {marker}{nl}
Replace: {nl}{marker}

Criteria: 11
BackColor: Aqua
Find: {marker}{whitespace:"[ ]+"}
Replace: {whitespace}{marker}

Criteria: 12
Comment: Normalizes spacing between arithmetic symbols
ForeColor: Black
Find: {marker}[{"[ ]+"}] {Symbol:"[\:\+\-\*\^\\\/]"} [{"[ ]+"}]
Replace: {space}{Symbol}{space}{marker}

Criteria: 13
Comment: Normalizes spacing around commas
ForeColor: Black
Find: {marker}{Comma:" *, *"}
Replace: ,{space}{marker}

# End Search