# PrettyBas.uc - uCalc Transformation file
# This file was saved with uCalc Search/Replace (beta) - Beta #21
# Comment: Adds color and indentation to BASIC source code

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterStartText, FilterUnique

FindMode: Replace

# Definitions
Include: Patterns.uc
Token: [\(\)] ~~ ~~ Properties: ucAlphaNumeric ~~ # Treats parenthesis as ordinary characters
Token: [$%]?[a-z][0-9a-z_]* ~~ ~~ Properties: ucAlphaNumeric
Token: [a-z_][0-9a-z_]*[%&?!#@$]{1,3} ~~ ~~ Properties: ucAlphaNumeric
EvalSpace: uCalc.uc /NoConsole
Inline: #Def Var: Indentation As Long
Inline: #Def Const: Size As Long = 3
Inline: {indent_reset} = SetVar(Indentation, 0)
Inline: {indent+} = Indentation += Size
Inline: {indent-} = Indentation -= Size
Inline: {indent} = " " * Indentation
SyntaxArg: {marker} = {#20}
SyntaxArg: {space} = {#32}

# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds color and indentation to BASIC source code
Selected: True
Highlight: True
ForeColor: ControlText
BackColor: Transparent
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: False
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Inserts marker
Pass: 1

Criteria: 2
Comment: Adds a marker (and newline) at the beginning of code; the marker will gradually move to the end.
Selected: False
Highlight: False
PassOnce: True
Find: {AllText:"[\x00-\xFF]+"}
Replace: {indent_reset}{marker}{nl}{AllText}

Criteria: 3
Comment: Indentation
Pass: 2

Criteria: 4
Selected: False
Highlight: False
PassOnce: True
Find: {nl}{etc}
Replace: {nl}{indent}{etc}

Criteria: 5
Comment: Indents tag then increments indentation
Selected: False
Highlight: False
PassOnce: True
Find: {nl}{Keyword: Type | Union | For | If | Do | While | Macro | Sub | Function }
Replace: {nl}{indent}{Keyword}{indent+}

Criteria: 6
Comment: Indents end-tag then decrements indentation
Selected: False
Highlight: False
PassOnce: True
Find: {nl}{Keyword: End | Next | Loop | Wend }
Replace: {nl}{indent-}{indent}{Keyword}

Criteria: 7
Selected: False
Highlight: False
PassOnce: True
Find: {nl}{SameLine: For | Do | While } {etc} :
Replace: {nl}{indent}{SameLine} {etc} :

Criteria: 8
Comment: Doesn't increase indentation for single-line If statement
Selected: False
Highlight: False
PassOnce: True
Find: {nl}If {cond} Then {Space:"[ ]+"} {SameLine:"[^'\r\n]"}
Replace: {nl}{indent}If {cond} Then {SameLine}

Criteria: 9
Selected: False
Highlight: False
PassOnce: True
Find: {nl}{Other: Function = | Macro {def} = }
Replace: {nl}{indent}{Other}

Criteria: 10
Comment: Removes {nl}
Pass: 3

Criteria: 11
Comment: Removes newline that was inserted at the beginning in Pass: 1
Selected: False
Highlight: False
PassOnce: True
Find: {NewLine:"[\r\n ]+"}{AllText:"[\x00-\xFF]+"}
Replace: {AllText}

Criteria: 12
Comment: Adds color
Pass: 4

Criteria: 13
Comment: Deletes the marker once it reaches the end
Selected: False
Highlight: False
PassOnce: True
Find: {marker}
Replace: 

Criteria: 14
Comment: Moves marker without changing color for all tokens that do not need color
Selected: False
ForeColor: Black
Find: {marker}{AnyToken:1}
Replace: {AnyToken}{marker}

Criteria: 15
Comment: Adds color to value within quotes
Selected: False
ForeColor: Brown
Find: {marker}{QuotedText:"[\q][^\q]*[\q]"}
Replace: {QuotedText}{marker}

Criteria: 16
Comment: Adds color to keywords
Selected: False
ForeColor: Blue
Find: {marker}{Keyword: #Compile | #Include | Exe | Sub | Function | Rnd | FreeFile }
Replace: {Keyword}{marker}

Criteria: 17
Comment: Adds color to keywords
Selected: False
ForeColor: Blue
Find: {marker}{Keyword: #Dim | Dim | As | All | Dword | Long | String | Do | Loop }
Replace: {Keyword}{marker}

Criteria: 18
Comment: Adds color to keywords
Selected: False
ForeColor: Blue
Find: {marker}{Keyword: For | Next | If | Then | Type | End | While | Wend | Print }
Replace: {Keyword}{marker}

Criteria: 19
Selected: False
ForeColor: Green
Find: {marker}{Comment:"'.*"}
Replace: {Comment}{marker}

Criteria: 20
Selected: False
ForeColor: Red
Find: {marker}! {ASM}
Replace: ! {ASM}{marker}

Criteria: 21
Selected: False
Highlight: False
Find: {marker}{nl}
Replace: {nl}{marker}

Criteria: 22
Comment: Preserves whitespace (such as indentaiton we've just added)
Selected: False
Highlight: False
Find: {marker}{whitespace:"[ ]+"}
Replace: {whitespace}{marker}

Criteria: 23
Comment: Normalizes spacing between arithmetic symbols
Selected: False
ForeColor: Black
Find: {marker}[{"[ ]+"}] {Symbol:"[\=\:\+\-\*\^\\\/]"} [{"[ ]+"}]
Replace: {space}{Symbol}{space}{marker}

Criteria: 24
Comment: Normalizes spacing around commas
Selected: False
ForeColor: Black
Find: {marker}{Comma:" *, *"}
Replace: ,{space}{marker}

# End Search