# PrettyXML_Color.uc - uCalc Transformation file
# This file was saved with uCalc Search/Replace (beta) - Beta #21
# Comment: Adds color and indentation to an XML file

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterStartText, FilterUnique

FindMode: Replace

# Definitions
Include: XML.uc
EvalSpace: uCalc.uc /NoConsole
Inline: #Def Var: Indentation As Long
Inline: #Def Const: Size As Long = 3
Inline: {indent_incr} = Indentation += Size
Inline: {indent_decr} = Indentation -= Size
Inline: {indent} = " " * Indentation

# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds color and indentation to an XML file
Selected: True
Highlight: True
ForeColor: ControlText
BackColor: Transparent
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: False
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Handles indentation
Pass: 1

Criteria: 2
Comment: Indents tag then increments indentation
Selected: False
Highlight: False
PassOnce: True
Find: <{tag}> {whitespace}
Replace: {indent}<{tag}>{indent_incr}{nl}

Criteria: 3
Comment: Indents innermost element
Selected: False
Highlight: False
PassOnce: True
Find: <{tag}>[{SameLine$}]</{end}> {whitespace}
Replace: {indent}<{tag}>{SameLine}</{end}>{nl}

Criteria: 4
Comment: Indents "empty-tag"
Selected: False
Highlight: False
PassOnce: True
Find: <{tag}/> {whitespace}
Replace: {indent}<{tag}/>{nl}

Criteria: 5
Comment: Indents end-tag then decrements indentation
Selected: False
Highlight: False
PassOnce: True
Find: </{end}> {whitespace}
Replace: {indent_decr}{indent}</{end}>{nl}

Criteria: 6
Selected: False
Highlight: False
PassOnce: True
Find: <?xml {etc} ?> {whitespace}
Replace: {indent}<?xml {etc} ?>{nl}

Criteria: 7
Comment: Adds a marker to allow for coloring in the next pass
Pass: 2

Criteria: 8
Comment: Adds a marker at the beginning of code; it will gradually move to the end.
Selected: False
Highlight: False
PassOnce: True
Find: {AllText}
Replace: {marker}{AllText}

Criteria: 9
Comment: This pass moves a marker along while adding color
Pass: 3

Criteria: 10
Comment: Deletes the marker once it reaches the end
Selected: False
Highlight: False
PassOnce: True
Find: {marker}
Replace: 

Criteria: 11
Comment: Adds color to "<" and moves the marker position and changes is it to {markerTag}
Selected: False
ForeColor: Blue
Find: {marker}<
Replace: <{markerTag}

Criteria: 12
Comment: Adds color to "</" and moves the marker position and changes is it to {markerTag}
Selected: False
ForeColor: Blue
Find: {marker}</
Replace: </{markerTag}

Criteria: 13
Comment: Adds color to PI and moves the marker
Selected: False
ForeColor: Blue
Find: {marker}<?xml {etc} ?>
Replace: <?xml {etc} ?>{marker}

Criteria: 14
Selected: False
Highlight: False
Find: {marker}{data:" *[^<]+"}
Replace: {data}{marker}

Criteria: 15
Comment: Adds color to tag name and moves the marker
Selected: False
ForeColor: Brown
Find: {markerTag}{name:" *[^=>]+"}
Replace: {name}{markerTag}

Criteria: 16
Comment: Adds color to "=" and quote and moves the marker and changes to {markerQuote}
Selected: False
ForeColor: Blue
Find: {markerTag}{" *= *[\q]"}
Replace: ="{markerQuote}

Criteria: 17
Selected: False
ForeColor: Blue
Find: {markerTag}>
Replace: >{marker}

Criteria: 18
Selected: False
ForeColor: Blue
Find: {markerTag}/>
Replace: />{marker}

Criteria: 19
Comment: Adds color to value within quotes
Selected: False
ForeColor: DarkGreen
Find: {markerQuote}[{Value:"[^\q]+"}]
Replace: {Value}{markerQuote}

Criteria: 20
Comment: adds color to ending quote mark and changes marker back to {markerTag}
Selected: False
ForeColor: Blue
Find: {markerQuote}{"[\q]"}
Replace: "{markerTag}

# End Search