' ---------------------------------------------------------------------------
' uCalcVB6.Bas: VB6 include file for uCalc Fast Math Parser 4.00
' Designed for : Visual Basic 6
' Instructions: Add this file to your project's directory (from the menu:
'               Project / Add Module / Existing) and copy uCalc DLLs to
'               a directory in the path, such as a system directory, or
'               else in the project directory, and you're ready to go.
'               Note: When running from the debugger instead of compiled,
'               the DLLs might not be found if they are only in your
'               project directory and that directory is not in the path.
'
' This file auto-generated by : VisualBasic6.uc using uCalc Transform 3.0
' Auto-generation timestamp: 08/14/14
' VisualBasic6.uc prepared by : Daniel Corbier
' Visit www.ucalc.com for additional resources.
' ---------------------------------------------------------------------------

Attribute VB_Name = "uCalcModule"
' Definition properties
Public Const ucAlphaNumeric As Long = 1
Public Const ucArgSeparator As Long = 2
Public Const ucCodeBlock As Long = 3
Public Const ucCodeBlockMatch As Long = 4
Public Const ucMemberAccess As Long = 5
Public Const ucQuotedText As Long = 6
Public Const ucStatementSep As Long = 7
Public Const ucWhiteSpace As Long = 8
Public Const ucCurrentThread As Long = 9
Public Const ucLocalVar As Long = 10
Public Const ucStaticVar As Long = 11
Public Const ucDefineNow As Long = 11 ' same as ucStaticVar
Public Const ucTempDef As Long = 12
Public Const ucEvalInsert As Long = 13
Public Const ucEvalDuringParse As Long = 14
Public Const ucExpandInsert As Long = 15
Public Const ucFileInclude As Long = 16
Public Const ucCurrentSpace As Long = 17
Public Const ucDefSpace As Long = 18
Public Const ucEvalSpace As Long = 19
Public Const ucFunction As Long = 64
Public Const ucOperator As Long = 128
Public Const ucVariable As Long = 256
Public Const ucSyntax As Long = 512
Public Const ucLiteral As Long = 1024
Public Const ucSymbol As Long = 2048
Public Const ucReducible As Long = 4096
Public Const ucLock As Long = 8192
Public Const ucInfix As Long = 16384
Public Const ucPrefix As Long = 32768
Public Const ucPostfix As Long = 49152

' uCalc Commands
Public Const uc_Define As Long = 1
Public Const uc_DefineSyntax As Long = 2
Public Const uc_Eval As Long = 3
Public Const uc_EvalStr As Long = 4
Public Const uc_Evaluate As Long = 5
Public Const uc_EvaluateLng As Long = 6
Public Const uc_EvaluateStr As Long = 7
Public Const uc_GetCaseSensitivity As Long = 8
Public Const uc_GetDefaultPass As Long = 9
Public Const uc_GetDefaultPrecedence As Long = 10
Public Const uc_GetDefaultRank As Long = 11
Public Const uc_GetCodeAddr As Long = 12
Public Const uc_GetDefaultThread As Long = 13
Public Const uc_GetDefaultType As Long = 14
Public Const uc_GetDefSeparator As Long = 15
Public Const uc_GetDefSpace As Long = 16
Public Const uc_GetErrorNumber As Long = 17
Public Const uc_GetEvalSpace As Long = 18
Public Const uc_GetParentThread As Long = 20
Public Const uc_GetSyntaxEqual As Long = 21
Public Const uc_Parse As Long = 22
Public Const uc_ReleaseItem As Long = 23
Public Const uc_SetCaseSensitivity As Long = 24
Public Const uc_SetCodeAddr As Long = 25
Public Const uc_SetDefaultPrecedence As Long = 26
Public Const uc_SetDefaultRank As Long = 27
Public Const uc_SetDefaultThread As Long = 28
Public Const uc_SetDefaultType As Long = 29
Public Const uc_SetDefSeparator As Long = 30
Public Const uc_SetErrorNumber As Long = 31
Public Const uc_SetParentThread As Long = 32
Public Const uc_SetSyntaxEqual As Long = 33
Public Const uc_NewThread As Long = 34
Public Const uc_RegExWordBoundaryChars As Long = 35
Public Const uc_RegExEscapeChar As Long = 36
Public Const uc_License As Long = 37

' License options
Public Const uc_License_Demo As Long = 0
Public Const uc_License_FMP_Free As Long = 1
Public Const uc_License_FMP_Standard_32 As Long = 2
Public Const uc_License_FMP_Standard_64 As Long = 3
Public Const uc_License_FMP_32_and_64 As Long = 4
Public Const uc_License_LanguageBuilder As Long = 5
Public Const uc_License_GeneralParser As Long = 6
Public Const uc_License_Interpreter As Long = 7
Public Const uc_License_ConsoleCalc As Long = 8
Public Const uc_License_WindowsCalc As Long = 9
Public Const uc_License_StringLib As Long = 10
Public Const uc_License_Transform As Long = 11
Public Const uc_License_TransformLib As Long = 12
Public Const uc_License_Search As Long = 13
Public Const uc_License_SearchLib As Long = 14
Public Const uc_License_Library1 As Long = 15
Public Const uc_License_Library2 As Long = 16
Public Const uc_License_Beta As Long = 17
Public Const uc_License_Debugger As Long = 18
Public Const uc_License_uCalc_All As Long = 50
Public Const uc_License_Developer As Long = 100
Public Const uc_License_EndUser As Long = 101
Public Const uc_AddDebugger As Long = 39
Public Const Debug_ReleaseItem As Long = 1
Public Const Debug_StdFuncCall As Long = 2
Public Const Debug_UserFuncCall As Long = 3
Public Const Debug_GetTextToken As Long = 4
Public Const Debug_ErrorHandler As Long = 5
Public Const Debug_ParseExpr As Long = 6
Public Const Debug_ParseItem As Long = 7
Public Const Debug_EvalOperation As Long = 8
Public Const Debug_DefSyntax As Long = 9
Public Const Debug_Define As Long = 10
Public Const Debug_DefinePart As Long = 11
Public Const Debug_Expand As Long = 12
Public Const Debug_ExpandSuccess As Long = 13
Public Const Debug_ExpandMiss As Long = 14
Public Const Debug_ExpandFail As Long = 15
Public Const Debug_GetSyntaxBlock As Long = 16
Public Const Debug_GetCodeBlock As Long = 17
Public Const Debug_LineNumber As Long = 18
Public Const Debug_TotalTally As Long = 19
Public Const Debug_Breakpoint As Long = 20
Public Const Debug_Delay As Long = 21
Public Const Debug_JumpTo As Long = 22
Public Const Debug_StepAction As Long = 23
Public Const uc_AddErrorHandler As Long = 40
Public Const uc_GetSymbolTable As Long = 41
Public Const uc_GetSteps As Long = 42
Public Const uc_GetStepsCount As Long = 43
Public Const uc_SetTypeOutput As Long = 45
Public Const uc_Group As Long = 46
Public Const uc_GetTag As Long = 47
Public Const uc_SetTag As Long = 48
Public Const uc_GetCallbackData As Long = 50
Public Const uc_SetCallbackReturn As Long = 51
Public Const uc_GetErrorExpression As Long = 60
Public Const uc_SetExpression As Long = 61
Public Const uc_GetSymbol As Long = 62
Public Const uc_SetSymbol As Long = 63
Public Const uc_GetLocation As Long = 64
Public Const uc_GetTokenType As Long = 65
Public Const uc_GetTokenProperties As Long = 66
Public Const uc_TrigMode As Long = 67
Public Const uc_ItemClone As Long = 70
Public Const uc_DataConvert As Long = 71
Public Const uc_DataCopy As Long = 72
Public Const uc_DataAlloc As Long = 72
Public Const uc_DataFree As Long = 73
Public Const uc_DataReset As Long = 74

' FPU commands
Public Const uc_SetFPU As Long = 75
Public Const uc_SetFPU_HostProg As Long = 76
Public Const uc_GetFPU As Long = 77
Public Const uc_GetFPU_HostProg As Long = 78
Public Const uc_ToggleFPU As Long = 79
Public Const uc_ToggleFPU_HostProg As Long = 80
Public Const uc_ErrorClear As Long = 85
Public Const uc_RestoreErrorMessageBox As Long = 86
Public Const uc_SetErrorMessage As Long = 91
Public Const uc_GetErrorMessage As Long = 92
Public Const uc_SerialNumber As Long = 93
Public Const uc_SetTurbo As Long = 94
Public Const uc_Expand As Long = 95
Public Const uc_GetNextToken As Long = 96
Public Const uc_GetItemData As Long = 97
Public Const uc_SetItemData As Long = 98
Public Const uc_GetThreadAddr As Long = 99
Public Const uc_GetCodeBlock As Long = 100
Public Const uc_Status_CurrentPass As Long = 101
Public Const uc_Status_MaxPass As Long = 102
Public Const uc_Status_Location As Long = 103
Public Const uc_Status_NestedLevel As Long = 104
Public Const uc_Status_TextLength As Long = 105
Public Const uc_Find As Long = 110
Public Const uc_FindAddMatch As Long = 111
Public Const uc_FindGetIndex As Long = 112
Public Const uc_FindGetCount As Long = 113
Public Const uc_FindGetStart As Long = 114
Public Const uc_FindGetLength As Long = 115
Public Const uc_FindGetText As Long = 116
Public Const uc_FindReset As Long = 117
Public Const uc_FindReplace As Long = 118
Public Const uc_FindFilter As Long = 119
Public Const uc_FindSetFilter As Long = 120
Public Const uc_FindFilterSort As Long = 1
Public Const uc_FindFilterUnique As Long = 2
Public Const uc_FindFilterTally As Long = 4
Public Const uc_FindFilterSeparator As Long = 8
Public Const uc_FindFilterStartText As Long = 16
Public Const uc_FindFilterEndText As Long = 32
Public Const uc_FindContext_Other As Long = 0
Public Const uc_FindContext_Found As Long = 1
Public Const uc_FindContext_Replaced As Long = 2
Public Const uc_FindZoomIn As Long = 1
Public Const uc_FindTransformInPlace As Long = 2
Public Const uc_Properties As Long = 1
Public Const uc_Thread As Long = 2
Public Const uc_Address As Long = 3
Public Const uc_SymbolName As Long = 4
Public Const uc_Rank As Long = 5
Public Const uc_Precedence As Long = 6
Public Const uc_OverloadHandle As Long = 7
Public Const uc_OverloadCount As Long = 8
Public Const uc_ByteSize As Long = 9
Public Const uc_ArgCount As Long = 10
Public Const uc_DataType As Long = 12
Public Const uc_Handle As Long = 13
Public Const uc_Value As Long = 14
Public Const uc_Property As Long = 15

' Error numbers
Public Const uc_Err_None As Long = 0
Public Const uc_Err_Dynamically_Defined As Long = 1
Public Const uc_Err_Syntax_Error As Long = 2
Public Const uc_Err_Undefined_Identifier As Long = 3
Public Const uc_Err_FileNotFound As Long = 4
Public Const uc_Err_Unrecognized_Token As Long = 5
Public Const uc_Err_Unrecognized_Command As Long = 6
Public Const uc_Err_Datatype_Mismatch As Long = 7
Public Const uc_Err_Invalid_Argument_Count As Long = 8
Public Const uc_Err_Invalid_Definition As Long = 9
Public Const uc_Err_CodeBlock_Error As Long = 10
Public Const uc_Err_Undefined_Callback As Long = 11
Public Const uc_Err_ErrMsgAlreadyDefined As Long = 12
Public Const uc_Err_ItemCannotBeModified As Long = 13
Public Const uc_Err_Unrecognized_Member As Long = 14
Public Const uc_Err_Unbalanced_Quote As Long = 15
Public Const uc_Err_Array_Bounds_Exceeded As Long = 20
Public Const uc_Err_Float_Denormal_Operand As Long = 21
Public Const uc_Err_Float_Divide_By_Zero As Long = 22
Public Const uc_Err_Float_Inexact_Result As Long = 23
Public Const uc_Err_Float_Invalid_Operation As Long = 24
Public Const uc_Err_Float_Overflow As Long = 25
Public Const uc_Err_Float_Stack_Check As Long = 26
Public Const uc_Err_Float_Underflow As Long = 27
Public Const uc_Err_Integer_Divide_By_Zero As Long = 28
Public Const uc_Err_Integer_Overflow As Long = 29
Public Const uc_Err_Privileged_Instruction As Long = 30

' Error response
Public Const ucAbort As Long = 0
Public Const ucResume As Long = 1
Public Const ucReRaise As Long = 2

' FPU Control Word Settings
Public Const uc_FPU_Mask_InvalidOp As Long = 1
Public Const uc_FPU_Mask_DenormalOp As Long = 2
Public Const uc_FPU_Mask_ZeroDivide As Long = 4
Public Const uc_FPU_Mask_Overflow As Long = 8
Public Const uc_FPU_Mask_Underflow As Long = 16
Public Const uc_FPU_Mask_PrecisionLoss As Long = 32
Public Const uc_FPU_Precision_Single As Long = 0
Public Const uc_FPU_Precision_Double As Long = 256
Public Const uc_FPU_Precision_Extended As Long = 768
Public Const uc_FPU_Round_Even As Long = 0
Public Const uc_FPU_Round_Down As Long = 1024
Public Const uc_FPU_Round_Up As Long = 2048
Public Const uc_FPU_Round_Toward As Long = 3072

' Data type handler callback action modes
Public Const uc_TypeHandler_Store As Long = 2
Public Const uc_TypeHandler_StringOutput As Long = 3
Public Const uc_TypeHandler_Free As Long = 4
Public Const uc_TypeHandler_FuncRet As Long = 5
Public Const uc_TypeHandler_Copy As Long = 6
Public Const uc_TypeHandler_Alloc As Long = 7
Public Const uc_TypeHandler_Reset As Long = 8
Public Const uc_Callback_Undefined As Long = 0 ' Returns error

' Data Type callbacks
Public Const uc_Complex As Long = 1
Public Const uc_Currency As Long = 2
Public Const uc_Double As Long = 3
Public Const uc_Extended As Long = 4
Public Const uc_Int8 As Long = 5
Public Const uc_Int8u As Long = 6
Public Const uc_Int16 As Long = 7
Public Const uc_Int16u As Long = 8
Public Const uc_Int32 As Long = 9
Public Const uc_Int32u As Long = 10
Public Const uc_Int64 As Long = 11
Public Const uc_Int64u As Long = 12
Public Const uc_Single As Long = 13
Public Const uc_String As Long = 14
Public Const uc_String_LPCSTR As Long = 15
Public Const uc_String_Fixed As Long = 16
Public Const uc_String_Wide As Long = 17
Public Const uc_Stack As Long = 18
Public Const uc_Table As Long = 19
Public Const uc_SortedList As Long = 20
Public Const uc_Void As Long = 21
Public Const uc_User_Type As Long = 22
Public Const uc_Convert_Generic As Long = 23
Public Const uc_Convert_Same As Long = 24
Public Const uc_Convert_Double_Extended As Long = 25
Public Const uc_Convert_Int8_Extended As Long = 26
Public Const uc_Convert_Int8u_Extended As Long = 27
Public Const uc_Convert_Int16_Extended As Long = 28
Public Const uc_Convert_Int16u_Extended As Long = 29
Public Const uc_Convert_Int32_Extended As Long = 30
Public Const uc_Convert_Int32u_Extended As Long = 31
Public Const uc_Convert_Int64_Extended As Long = 32
Public Const uc_Convert_Int64u_Extended As Long = 33
Public Const uc_Convert_Single_Extended As Long = 34
Public Const uc_Convert_Void_Extended As Long = 35
Public Const uc_Convert_Extended_Double As Long = 37
Public Const uc_Convert_Extended_Single As Long = 38
Public Const uc_Convert_Extended_Int16u As Long = 39
Public Const uc_Convert_Extended_Int32 As Long = 40
Public Const uc_Convert_Complex_Extended As Long = 41
Public Const uc_Convert_Extended_Complex As Long = 42

' Default built-in routines
Public Const uc_Op_Negate As Long = 43
Public Const uc_Op_UnaryPlus As Long = 44
Public Const uc_Op_Percentage As Long = 45
Public Const uc_Op_StrConcat As Long = 46
Public Const uc_Op_Add_Int32 As Long = 47
Public Const uc_Op_Add As Long = 48
Public Const uc_Op_Add_Complex As Long = 49
Public Const uc_Op_Subtract_Int32 As Long = 50
Public Const uc_Op_Subtract As Long = 51
Public Const uc_Op_Multiply_Int32 As Long = 52
Public Const uc_Op_Multiply As Long = 53
Public Const uc_Op_Multiply_Complex As Long = 54
Public Const uc_Op_Divide_Int32 As Long = 55
Public Const uc_Op_Divide As Long = 56
Public Const uc_Op_Mod_Int32 As Long = 57
Public Const uc_Op_Mod As Long = 58
Public Const uc_Op_PowerOf_ExtToExt As Long = 59
Public Const uc_Op_PowerOf_ExtToLng As Long = 60
Public Const uc_Op_PowerOf_CplxToCplx As Long = 61
Public Const uc_Op_GreaterThan As Long = 62
Public Const uc_Op_GreaterOrEqual As Long = 63
Public Const uc_Op_LessThan As Long = 64
Public Const uc_Op_LessOrEqual As Long = 65
Public Const uc_Op_Equal As Long = 66
Public Const uc_Op_NotEqual As Long = 67
Public Const uc_Op_GreaterThan_Str As Long = 68
Public Const uc_Op_GreaterOrEqual_Str As Long = 69
Public Const uc_Op_LessThan_Str As Long = 70
Public Const uc_Op_LessOrEqual_Str As Long = 71
Public Const uc_Op_Equal_Str As Long = 72
Public Const uc_Op_NotEqual_Str As Long = 73
Public Const uc_Op_Not_Int32 As Long = 74
Public Const uc_Op_And_Int32 As Long = 75
Public Const uc_Op_Or_Int32 As Long = 76
Public Const uc_Op_Xor_Int32 As Long = 77
Public Const uc_Op_Eqv_Int32 As Long = 78
Public Const uc_Op_Imp_Int32 As Long = 79
Public Const uc_Op_AndAlso As Long = 80
Public Const uc_Op_OrElse As Long = 81
Public Const uc_Op_Factorial As Long = 82
Public Const uc_Func_IIf As Long = 83
Public Const uc_Func_IIf_Str As Long = 84
Public Const uc_Func_Sin As Long = 85
Public Const uc_Func_Cos As Long = 86
Public Const uc_Func_Tan As Long = 87
Public Const uc_Func_Atan As Long = 88
Public Const uc_Func_Ceil As Long = 89
Public Const uc_Func_Abs As Long = 90
Public Const uc_Func_Abs_Int32 As Long = 91
Public Const uc_Func_Exp As Long = 92
Public Const uc_Func_Log As Long = 93
Public Const uc_Func_Floor As Long = 94
Public Const uc_Func_SquareRoot As Long = 95
Public Const uc_Func_BaseConvert As Long = 96
Public Const uc_Func_ExprHandle As Long = 97
Public Const uc_Func_VarPtr As Long = 98
Public Const uc_Func_uCalc As Long = 99
Public Const uc_Func_uCalcStr As Long = 100
Public Const uc_Func_ucAddr As Long = 101
Public Const uc_Func_ValueAtAddr As Long = 102
Public Const uc_Func_SpecialArg As Long = 103
Public Const uc_Op_StringMult As Long = 104
Public Const uc_Func_For As Long = 105
Public Const uc_Func_Loop As Long = 107
Public Const uc_Func_LoadLibrary As Long = 108
Public Const uc_Func_GetProcAddress As Long = 109
Public Const uc_NullString As Long = 110
Public Const uc_True As Long = 111
Public Const uc_Func_Peek As Long = 112
Public Const uc_Func_Poke As Long = 113
Public Const uc_Func_Int As Long = 115
Public Const uc_Func_Frac As Long = 116
Public Const uc_Func_Sgn As Long = 117
Public Const uc_Func_PushData_Stack As Long = 120
' Public Const uc_Func_PopHandle_Stack As Long = 121
Public Const uc_Func_PopNum_Stack As Long = 122
Public Const uc_Func_PopStr_Stack As Long = 123
Public Const uc_Func_ReadHandle_Stack As Long = 124
Public Const uc_Func_ReadNum_Stack As Long = 125
Public Const uc_Func_ReadStr_Stack As Long = 126
Public Const uc_Func_Count_Stack As Long = 127
Public Const uc_Op_Concat_Stack As Long = 128
Public Const uc_Func_Populate_Stack As Long = 129
Public Const uc_Insert_Table As Long = 130
Public Const uc_Delete_Table As Long = 131
Public Const uc_Index_Table As Long = 132
Public Const uc_Handle_Table As Long = 133
Public Const uc_HandleB_Table As Long = 134
Public Const uc_ReadData_Table As Long = 135
Public Const uc_ReadNum_Table As Long = 136
Public Const uc_Func_Min As Long = 137
Public Const uc_Func_Max As Long = 138
Public Const uc_Func_Min_Str As Long = 139
Public Const uc_Func_Max_Str As Long = 140
Public Const uc_SetVariableValue As Long = 141
Public Const uc_SetVariableValueAnyType As Long = 141
Public Const uc_SetVariableValueLong As Long = 142
Public Const uc_SetVariableValueDouble As Long = 143
Public Const uc_SetVariableValueExtended As Long = 144
Public Const uc_ResetVariable As Long = 145

' Misc other callbacks
Public Const uc_EvaluateAddr As Long = 150
Public Const uc_EvaluateTurboAddr As Long = 151
Public Const uc_ExceptionHelper As Long = 152
Public Const uc_DefaultErrorHandler As Long = 153
Public Const uc_Raise_Error As Long = 154
Public Const uc_Func_IsIncomplete As Long = 155
Public Const uc_ScriptTimerStart As Long = 160
Public Const uc_LoadTimeTix As Long = 161
Public Const uc_Op_Ext_Plus_Complex As Long = 190
Public Const uc_Op_Ext_Times_Complex As Long = 191
Public Const uc_Func_If_ElseIf As Long = 195
Public Const uc_Func_SetSyntaxParams As Long = 196
Public Const uc_Func_SpecialUCase As Long = 197
Public Const uc_Func_Rand As Long = 198
Public Const uc_Func_GetmatchArg As Long = 199
Public Const uc_Func_PatternNum As Long = 200
Public Const uc_Func_PatternStr As Long = 201
Public Const uc_Convert_Stack_Table As Long = 220
Public Const uc_Convert_Stack_SortedList As Long = 221
Public Const uc_Convert_Table_Stack As Long = 222
Public Const uc_Convert_SortedList_Stack As Long = 223
Public Const uc_Expand_List As Long = 1
Public Const uc_Expand_StackPtr As Long = 2
Public Const uc_HandleToken As Long = 21 ' &h15

' Trig Mode
Public Const uc_ReturnTrigMode As Long = 0
Public Const uc_Radians As Long = 1
Public Const uc_Degrees As Long = 2
Public Const uc_Grad As Long = 3

' Misc
Public Const ucTrue As Long = 1
Public Const ucFalse As Long = 0
Public Const uc_Rank_First As Long = 1
Public Const uc_Rank_Last As Long = -1

' Pattern options
Public Const uc_Pattern_ArgCount As Long = 1
Public Const uc_Pattern_ArgIndex As Long = 2
Public Const uc_Pattern_ArgLength As Long = 3
Public Const uc_Pattern_ArgLocation As Long = 4
Public Const uc_Pattern_ArgText As Long = 5
Public Const uc_Pattern_DocumentLength As Long = 6
Public Const uc_Pattern_DocumentText As Long = 7
Public Const uc_Pattern_CriteriaCount As Long = 8
Public Const uc_Pattern_CriteriaIndex As Long = 9
Public Const uc_Pattern_MatchLength As Long = 10
Public Const uc_Pattern_MatchLocation As Long = 11
Public Const uc_Pattern_MatchText As Long = 12
Public Const uc_Pattern_MatchTally As Long = 13
Public Const uc_Pattern_SkipTally As Long = 14

' String Library
Public Const uc_StringLibNum As Long = 230
Public Const uc_StringLibStr As Long = 231
Public Const ucs_SetStringDefaults As Long = 4
Public Const ucs_Start As Long = 5
Public Const ucs_Limit As Long = 6
Public Const ucs_StartAfter As Long = 7
Public Const ucs_StopAfter As Long = 8
Public Const ucs_Between As Long = 9
Public Const ucs_Nth As Long = 10
Public Const ucs_File As Long = 11
Public Const ucs_Pos As Long = 12
Public Const ucs_Length As Long = 13
Public Const ucs_Text As Long = 14
Public Const ucs_Count As Long = 15
Public Const ucs_CountSkipped As Long = 16
Public Const ucs_InStr As Long = 17
Public Const ucs_Tally As Long = 18
Public Const ucs_UCase As Long = 19
Public Const ucs_LCase As Long = 20
Public Const ucs_MCase As Long = 21
Public Const ucs_Replace As Long = 22
Public Const ucs_Remove As Long = 23
Public Const ucs_Mid As Long = 24
Public Const ucs_Left As Long = 25
Public Const ucs_Right As Long = 26
Public Const ucs_Len As Long = 27
Public Const ucs_Extract As Long = 28
Public Const ucs_Remain As Long = 29
Public Const ucs_Skip As Long = 30
Public Const ucs_Delim As Long = 31
Public Const ucs_Retain As Long = 32
Public Const ucs_Range As Long = 33
Public Const ucs_Compare As Long = 34
Public Const ucs_Equals As Long = 35
Public Const ucs_Split As Long = 36
Public Const ucs_StringItem As Long = 37
Public Const ucs_StringItemCount As Long = 38

' String Libarary Options
Public Const ucByte As Long = 1
Public Const ucChar As Long = 2
Public Const ucWord As Long = 4
Public Const ucToken As Long = 8
Public Const ucBlock As Long = 16
Public Const ucExpr As Long = 32
Public Const ucQuote As Long = 64
Public Const ucSpace As Long = 128
Public Const ucCase As Long = 256
' End Of String Library Options

' Main Functions
Public Declare Function ucAddr Lib "uCalc32v400.dll" (ByVal AddressIndex As Long) As Long
Public Declare Function uCalc Lib "uCalc32v400.dll" (ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long = 0, Optional ByVal b As Long = 0, Optional ByVal c As Long = 0, Optional ByVal t As Long = 0) As Long

' Insert Other Exports
Public Declare Function ExceptionHelper Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal SystemError As Long) As Long
Public Declare Function ucEvaluate Lib "uCalc32v400.dll" (ByVal Item As Long) As Double
Public Declare Function ucArgLng Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal index As Long) As Long
Public Declare Function ucArg Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal index As Long) As Double
Public Declare Sub ucArgStr_ Lib "uCalc32v400.dll" Alias "ucArgStr" (ByRef ReturnStr As String, ByVal Expr As Long, ByVal index As Long)
Public Declare Function ucArgHandle Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal index As Long) As Long
Public Declare Function ucArgCount Lib "uCalc32v400.dll" (ByVal Expr As Long) As Long
Public Declare Sub ucReturnLng Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal ReturnValue As Long)
Public Declare Sub ucReturn Lib "uCalc32v400.dll" Alias "ucReturnDbl" (ByVal Expr As Long, ByVal ReturnValue As Double)
Public Declare Sub ucReturnStr Lib "uCalc32v400.dll" (ByVal Expr As Long, ByRef ReturnValue As String)
Public Declare Function ucGetVariableValue Lib "uCalc32v400.dll" (ByVal Item As Long) As Double
Public Declare Function ucGetVariableValueLng Lib "uCalc32v400.dll" (ByVal Item As Long) As Long
Public Declare Sub ucGetVariableValueStr_ Lib "uCalc32v400.dll" Alias "ucGetVariableValueStr" (ByRef ReturnStr As String, ByVal Item As Long)
Public Declare Sub ucSetVariableValueLng Lib "uCalc32v400.dll" (ByVal Item As Long, ByVal NewValue As Long)
Public Declare Sub ucSetVariableValue Lib "uCalc32v400.dll" Alias "ucSetVariableValueDbl" (ByVal Item As Long, ByVal NewValue As Double)
Public Declare Sub ucSetVariableValueStr Lib "uCalc32v400.dll" (ByVal Item As Long, ByRef NewValue As String)
Public Declare Function ucExprThread Lib "uCalc32v400.dll" (ByVal Expr As Long) As Long
Public Declare Function ucLicense Lib "uCalc32v400.dll" (ByVal Product As Long, Optional ByVal L1 As Long = 0, Optional ByVal L2 As Long = 0, Optional ByVal L3 As Long = 0, Optional ByVal L4 As Long = 0, Optional ByVal L5 As Long = 0) As Long
' End Insert
Public Declare Sub uCalcStr_ Lib "uCalc32v400.dll" Alias "uCalcStr" (ByRef ReturnStr As String, ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long)
Public Declare Function ucClose32bitDLL Lib "uCalc32v400.dll" (ByVal ReserverdArg As Long) As Long
Public Declare Function ucDefine Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal Arg1 As Long = 0, Optional ByVal Arg2 As Long = 0, Optional ByVal Arg3 As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucDefineConstant Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal t As Long = 0) As Long
Public Declare Function ucDefineFunction Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal FunctionAddress As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucDefineOperator Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal FunctionAddress As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucDefineSyntax Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal Rank As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucDefineVariable Lib "uCalc32v400.dll" (ByRef Definition As String, Optional ByVal VarAddress As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucEval Lib "uCalc32v400.dll" (ByRef Expr As String, Optional ByVal t As Long = 0) As Double
Public Declare Sub ucEvalStr_ Lib "uCalc32v400.dll" Alias "ucEvalStr" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long)
Public Declare Sub ucEvaluateStr_ Lib "uCalc32v400.dll" Alias "ucEvaluateStr" (ByRef ReturnStr As String, ByVal ucItem As Long)
Public Declare Sub ucExpand_ Lib "uCalc32v400.dll" Alias "ucExpand" (ByRef ReturnStr As String, ByRef Expr As String, Optional ByVal t As Long)
Public Declare Function ucFPU Lib "uCalc32v400.dll" (ByVal FPU_Command As Long, Optional ByVal FPU_Option As Long = 0) As Long
Public Declare Function ucGetTrigMode Lib "uCalc32v400.dll" () As Long
Public Declare Function ucInitialize Lib "uCalc32v400.dll" (Optional ByVal NewThread As Long = 0) As Long
Public Declare Function ucNewThread Lib "uCalc32v400.dll" (Optional ByVal ParentThread As Long = 0, Optional ByVal MakeThisDefault As Long = 0) As Long
Public Declare Function ucParse Lib "uCalc32v400.dll" (ByRef Expr As String, Optional ByVal ExprType As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucReleaseItem Lib "uCalc32v400.dll" (ByVal ucItem As Long) As Long
Public Declare Sub ucRun_ Lib "uCalc32v400.dll" Alias "ucRun" (ByRef ReturnStr As String, ByRef RunOption As String, ByRef TextIn As String, Optional ByVal ExpandCount As Long, Optional ByVal t As Long)
Public Declare Function ucSetOutput Lib "uCalc32v400.dll" (Optional ByVal FunctionAddress As Long = 0, Optional ByRef FuncName As String, Optional ByRef DataType As String, Optional ByVal t As Long = 0) As Long
Public Declare Function ucSetTrigMode Lib "uCalc32v400.dll" (ByVal TrigMode As Long) As Long

' Error handling
Public Declare Function ucAddErrorHandler Lib "uCalc32v400.dll" (Optional ByVal ErrorHandlerAddress As Long = 0, Optional ByVal t As Long = 0) As Long
Public Declare Function ucError Lib "uCalc32v400.dll" (Optional ByVal t As Long = 0) As Long
Public Declare Sub ucErrorMessage_ Lib "uCalc32v400.dll" Alias "ucErrorMessage" (ByRef ReturnStr As String, Optional ByVal ErrorNumber As Long, Optional ByVal t As Long)
Public Declare Sub ucErrorExpression_ Lib "uCalc32v400.dll" Alias "ucErrorExpression" (ByRef ReturnStr As String, Optional ByVal t As Long)
Public Declare Function ucErrorLocation Lib "uCalc32v400.dll" (ByVal t As Long) As Long
Public Declare Sub ucErrorSymbol_ Lib "uCalc32v400.dll" Alias "ucErrorSymbol" (ByRef ReturnStr As String, ByVal t As Long)
Public Declare Function ucRaiseError Lib "uCalc32v400.dll" (ByVal Expr As Long, ByVal ErrorNumber As Long) As Long
Public Declare Function ucRaiseErrorMessage Lib "uCalc32v400.dll" (ByVal Expr As Long, ByRef ErrorMessage As String) As Long
Public Declare Function ucSetError Lib "uCalc32v400.dll" (ByVal ErrorNumber As Long, Optional ByVal t As Long = 0) As Long
Public Declare Function ucSetErrorMessage Lib "uCalc32v400.dll" (ByVal ErrorIndex As Long, ByRef ErrorMessage As String, Optional ByVal t As Long = 0) As Long
Public Declare Function ucSetErrorNumber Lib "uCalc32v400.dll" (ByVal ErrorNumber As Long, Optional ByVal t As Long = 0) As Long

' uCalc String Library
Public Declare Function ucLoadStringLibInFMP Lib "uCalc32v400.dll" (Optional ByVal tHandle As Long = 0) As Long

' uCalc String Library Routine Exports
Public Declare Function ucBetween Lib "uCalc32v400.dll" (ByVal a As Long, ByVal b As Long) As Long
Public Declare Function ucCompare Lib "uCalc32v400.dll" (ByRef String1 As String, ByRef String2 As String, Optional ByVal Options As Long = 0) As Long
Public Declare Function ucCount Lib "uCalc32v400.dll" () As Long
Public Declare Function ucCountSkipped Lib "uCalc32v400.dll" () As Long
Public Declare Function ucDelim Lib "uCalc32v400.dll" (ByRef Delim As String, Optional ByRef L As String, Optional ByRef R As String) As Long
Public Declare Function ucEquals Lib "uCalc32v400.dll" (ByRef String1 As String, ByRef String2 As String, Optional ByVal Options As Long = 0) As Long
Public Declare Function ucInStr Lib "uCalc32v400.dll" (ByVal Start As Long, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long = 0) As Long
Public Declare Function ucLen Lib "uCalc32v400.dll" (ByRef MainString As String, Optional ByVal Options As Long = 0) As Long
Public Declare Function ucLength Lib "uCalc32v400.dll" (Optional ByVal x As Long = 0) As Long
Public Declare Function ucLimit Lib "uCalc32v400.dll" (ByVal Limit As Long) As Long
Public Declare Function ucNth Lib "uCalc32v400.dll" (ByVal Number As Long) As Long
Public Declare Function ucPos Lib "uCalc32v400.dll" (Optional ByVal x As Long = 0) As Long
Public Declare Function ucSetStringDefaults Lib "uCalc32v400.dll" (ByVal Options As Long) As Long
Public Declare Function ucSkip Lib "uCalc32v400.dll" (ByRef MainString As String) As Long
Public Declare Function ucSplit Lib "uCalc32v400.dll" (ByRef MainString As String, Optional ByRef Delim As String, Optional ByVal Options As Long = 0) As Long
Public Declare Function ucStart Lib "uCalc32v400.dll" (ByVal Position As Long) As Long
Public Declare Function ucStartAfter Lib "uCalc32v400.dll" (ByVal Number As Long) As Long
Public Declare Function ucStopAfter Lib "uCalc32v400.dll" (ByVal Number As Long) As Long
Public Declare Function ucStringItemCount Lib "uCalc32v400.dll" () As Long
Public Declare Function ucTally Lib "uCalc32v400.dll" (ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long = 0) As Long
Public Declare Sub ucExtract_ Lib "uCalc32v400.dll" Alias "ucExtract" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Sub ucFile_ Lib "uCalc32v400.dll" Alias "ucFile" (ByRef ReturnStr As String, ByRef NameOfFile As String)
Public Declare Sub ucLCase_ Lib "uCalc32v400.dll" Alias "ucLCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Sub ucLeft_ Lib "uCalc32v400.dll" Alias "ucLeft" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long)
Public Declare Sub ucMCase_ Lib "uCalc32v400.dll" Alias "ucMCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Sub ucMid_ Lib "uCalc32v400.dll" Alias "ucMid" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Start As Long, Optional ByVal Length As Long, Optional ByVal Options As Long)
Public Declare Sub ucRange_ Lib "uCalc32v400.dll" Alias "ucRange" (ByRef ReturnStr As String, ByVal Start As Long, ByVal Finish As Long, ByRef Expression As String, Optional ByVal Options As Long)
Public Declare Sub ucRemain_ Lib "uCalc32v400.dll" Alias "ucRemain" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Sub ucRemove_ Lib "uCalc32v400.dll" Alias "ucRemove" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Sub ucReplace_ Lib "uCalc32v400.dll" Alias "ucReplace" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByRef Replacement As String, Optional ByVal Options As Long)
Public Declare Sub ucRetain_ Lib "uCalc32v400.dll" Alias "ucRetain" (ByRef ReturnStr As String, ByRef MainString As String, ByRef Pattern As String, Optional ByRef Filter As String, Optional ByVal Options As Long)
Public Declare Sub ucRight_ Lib "uCalc32v400.dll" Alias "ucRight" (ByRef ReturnStr As String, ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long)
Public Declare Sub ucStringItem_ Lib "uCalc32v400.dll" Alias "ucStringItem" (ByRef ReturnStr As String, ByVal Index As Long)
Public Declare Sub ucUCase_ Lib "uCalc32v400.dll" Alias "ucUCase" (ByRef ReturnStr As String, ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long)
Public Declare Function uCalcRaw Lib "uCalc32v400.dll" (ByRef ReturnStr_ As String, ByVal uc As Long, ByRef TextIn As String, ByVal Misc1 As Long, ByVal Misc2 As Long, ByVal ReturnPtr As Long, ByVal tHandle As Long) As Long

' Deprecated notations
' Note: The following alternative notations are preserved for backwards compatibility and may not be supported in the future.
Public Declare Function ucParam Lib "uCalc32v400.dll" Alias "ucArg" (ByVal ExprHandle As Long, ByVal Index As Long) As Double
Public Declare Sub ucParamStr_ Lib "uCalc32v400.dll" Alias "ucArgStr" (ByRef ReturnStr As String, ByVal ExprHandle As Long, ByVal Index As Long)
Public Declare Function ucParamCount Lib "uCalc32v400.dll" Alias "ucArgCount" (ByVal ExprHandle As Long) As Long
Public Declare Function ucParamHandle Lib "uCalc32v400.dll" Alias "ucArgHandle" (ByVal ExprHandle As Long, ByVal Index As Long) As Long
Public Declare Function ucErrLocation Lib "uCalc32v400.dll" Alias "ucErrorLocation" (ByVal t As Long) As Long
Public Declare Sub ucErrSymbol_ Lib "uCalc32v400.dll" Alias "ucErrorSymbol" (ByRef ReturnStr As String, ByVal t As Long)
Public Declare Function ucSetErrMsg Lib "uCalc32v400.dll" Alias "ucSetErrorMessage" (ByVal Index As Long, ByRef Msg As String) As Long

' String return functions

Public Function ucArgStr(ByVal Expr As Long, ByVal index As Long) As String
   Dim ReturnStr As String
   Call ucArgStr_(ReturnStr,  Expr ,  index )
   ucArgStr = ReturnStr
End Function

Public Function ucGetVariableValueStr(ByVal Item As Long) As String
   Dim ReturnStr As String
   Call ucGetVariableValueStr_(ReturnStr,  Item )
   ucGetVariableValueStr = ReturnStr
End Function

Public Function uCalcStr(ByVal ucCommand As Long, Optional ByRef TextIn As String, Optional ByVal a As Long, Optional ByVal b As Long, Optional ByVal c As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call uCalcStr_(ReturnStr,  ucCommand ,   TextIn ,   a ,   b ,   c ,   t )
   uCalcStr = ReturnStr
End Function

Public Function ucEvalStr(ByRef Expr As String, Optional ByVal ExprType As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucEvalStr_(ReturnStr,  Expr ,   ExprType ,   t )
   ucEvalStr = ReturnStr
End Function

Public Function ucEvaluateStr(ByVal ucItem As Long) As String
   Dim ReturnStr As String
   Call ucEvaluateStr_(ReturnStr,  ucItem )
   ucEvaluateStr = ReturnStr
End Function

Public Function ucExpand(ByRef Expr As String, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucExpand_(ReturnStr,  Expr ,   t )
   ucExpand = ReturnStr
End Function

Public Function ucRun(ByRef RunOption As String, ByRef TextIn As String, Optional ByVal ExpandCount As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucRun_(ReturnStr,  RunOption ,  TextIn ,   ExpandCount ,   t )
   ucRun = ReturnStr
End Function

Public Function ucErrorMessage(Optional ByVal ErrorNumber As Long, Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucErrorMessage_(ReturnStr,   ErrorNumber ,   t )
   ucErrorMessage = ReturnStr
End Function

Public Function ucErrorExpression(Optional ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucErrorExpression_(ReturnStr,   t )
   ucErrorExpression = ReturnStr
End Function

Public Function ucErrorSymbol(ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucErrorSymbol_(ReturnStr,  t )
   ucErrorSymbol = ReturnStr
End Function

Public Function ucExtract(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucExtract_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucExtract = ReturnStr
End Function

Public Function ucFile(ByRef NameOfFile As String) As String
   Dim ReturnStr As String
   Call ucFile_(ReturnStr,  NameOfFile )
   ucFile = ReturnStr
End Function

Public Function ucLCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucLCase_(ReturnStr,  MainString ,   Pattern ,   Options )
   ucLCase = ReturnStr
End Function

Public Function ucLeft(ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucLeft_(ReturnStr,  MainString ,  Number ,   Options )
   ucLeft = ReturnStr
End Function

Public Function ucMCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucMCase_(ReturnStr,  MainString ,   Pattern ,   Options )
   ucMCase = ReturnStr
End Function

Public Function ucMid(ByRef MainString As String, ByVal Start As Long, Optional ByVal Length As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucMid_(ReturnStr,  MainString ,  Start ,   Length ,   Options )
   ucMid = ReturnStr
End Function

Public Function ucRange(ByVal Start As Long, ByVal Finish As Long, ByRef Expression As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucRange_(ReturnStr,  Start ,  Finish ,  Expression ,   Options )
   ucRange = ReturnStr
End Function

Public Function ucRemain(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucRemain_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucRemain = ReturnStr
End Function

Public Function ucRemove(ByRef MainString As String, ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucRemove_(ReturnStr,  MainString ,  Pattern ,   Options )
   ucRemove = ReturnStr
End Function

Public Function ucReplace(ByRef MainString As String, ByRef Pattern As String, Optional ByRef Replacement As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucReplace_(ReturnStr,  MainString ,  Pattern ,   Replacement ,   Options )
   ucReplace = ReturnStr
End Function

Public Function ucRetain(ByRef MainString As String, ByRef Pattern As String, Optional ByRef Filter As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucRetain_(ReturnStr,  MainString ,  Pattern ,   Filter ,   Options )
   ucRetain = ReturnStr
End Function

Public Function ucRight(ByRef MainString As String, ByVal Number As Long, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucRight_(ReturnStr,  MainString ,  Number ,   Options )
   ucRight = ReturnStr
End Function

Public Function ucStringItem(ByVal Index As Long) As String
   Dim ReturnStr As String
   Call ucStringItem_(ReturnStr,  Index )
   ucStringItem = ReturnStr
End Function

Public Function ucUCase(ByRef MainString As String, Optional ByRef Pattern As String, Optional ByVal Options As Long) As String
   Dim ReturnStr As String
   Call ucUCase_(ReturnStr,  MainString ,   Pattern ,   Options )
   ucUCase = ReturnStr
End Function

Public Function ucParamStr(ByVal ExprHandle As Long, ByVal Index As Long) As String
   Dim ReturnStr As String
   Call ucParamStr_(ReturnStr,  ExprHandle ,  Index )
   ucParamStr = ReturnStr
End Function

Public Function ucErrSymbol(ByVal t As Long) As String
   Dim ReturnStr As String
   Call ucErrSymbol_(ReturnStr,  t )
   ucErrSymbol = ReturnStr
End Function

