# CSharp.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.95 on 3/10/2014 4:14:30 PM
# Comment: Transforms uCalc interface file to C# include file (uCalcCS.cs)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to C# include file (uCalcCS.cs)
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: uCalcCS.cs
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: 
Pass: 1

Criteria: 2
Highlight: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Var: StringMarshal = "[In,Out,MarshalAs(UnmanagedType.AnsiBStr)]ref string"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
Highlight: True
BackColor: Orange
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
Highlight: True
BackColor: DeepSkyBlue
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
Highlight: True
BackColor: DarkKhaki
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
Highlight: True
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
Highlight: True
BackColor: Yellow
Find: '
Replace: //

Criteria: 8
Highlight: True
BackColor: Lime
Find: ' Interface.Bas {etc}
Replace: // {@Eval:OutputFile}: C# include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 9
Highlight: True
BackColor: Red
Find: ' Designed for : {etc}
Replace: // Designed for : C# 2010 and 2012
         // Instructions: Add this file to your project's directory (from the menu:
         //               Project / Add Existing Item...) and copy uCalc DLLs to
         //               your bin and/or bin\Debug directory (or any directory in
         //               the path) and you're ready to go.

Criteria: 10
Highlight: True
BackColor: Brown
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 11
Highlight: True
BackColor: RoyalBlue
Find: ' VB.NET: Public Module uCalcVBNET
Replace: using System;
         using System.Runtime.InteropServices;
         
         public class uc
         {
            public const string uCalcDLL = "{@Eval:DLLFile}";

Criteria: 12
Highlight: True
BackColor: Pink
Find: ' VB.NET: End Module
Replace: }

Criteria: 13
Highlight: True
BackColor: SlateBlue
Find: ' VB.NET: Public Delegate Sub {name}({args})
Replace: public delegate void {name}({args});

Criteria: 14
Highlight: True
BackColor: Purple
Find: ' VB.NET: Public Delegate Function {name}({args}) As {type}
Replace: public delegate {type} {name}({args});

Criteria: 15
Highlight: True
BackColor: Khaki
PassOnce: False
Find: %{const} = {value:" [0-9\-]+"}
Replace: public const int {const} ={value};

Criteria: 16
Highlight: True
BackColor: Green
Find: Function {name} Alias {q}{alias}{q} {args%} Export As {type:1}
        {body~+}
      End Function
Replace: DLL.Import {type} {alias}{args};

Criteria: 17
Highlight: True
Find: Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args%}]) Export
        {body~+}
      End Sub
Replace: DLL.Import string {alias}({args});

Criteria: 18
Highlight: True
BackColor: SandyBrown
Find: ' Function {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: DLL.Import {type} {alias}{args};

Criteria: 19
Highlight: True
BackColor: Violet
Find: ' Deprecated {name} Alias {q}{alias}{q} {args%} Export As {type}
Replace: DLL.Import, EntryPoint="{alias}" {type} {name}{args};

Criteria: 20
Highlight: True
BackColor: YellowGreen
Find: ' Sub {name} Alias {q}{alias}{q} {args%} Export
Replace: DLL.Import void {alias} {args};

Criteria: 21
Highlight: True
BackColor: CornflowerBlue
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Dbl Alias {alias:1} {args%} Export
Replace: DLL.Import, EntryPoint="{name}Dbl" void {name}{args};

Criteria: 22
Highlight: True
BackColor: Gold
Find: ' Sub {ucSetVariableValueExt | ucReturnExt} {etc}
Replace: {Nothing}

Criteria: 23
Highlight: True
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args%}]) Export
Replace: DLL.Import string {alias}({args});

Criteria: 24
Comment: Removes extraneous whitespace and fixes args, etc.
Pass: 2

Criteria: 25
Highlight: True
Find: Extended
Replace: double

Criteria: 26
Highlight: True
Find: Dword
Replace: UInt32

Criteria: 27
Highlight: True
Find: { Long | Integer }
Replace: int

Criteria: 28
Highlight: True
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 29
Highlight: True
PassOnce: False
Find: {nl}{nl}{LineBeginning: public static | DLL.Import}
Replace: {nl}{LineBeginning}

Criteria: 30
Highlight: True
Find: [{optional: Optional}] ByVal {arg} As {type%:1}
Replace: {type} {arg}{optional: = 0}

Criteria: 31
Highlight: True
Find: [{optional: Optional}] ByRef {arg} As String
Replace: {@Eval:StringMarshal} {arg}{optional: = ""}

Criteria: 32
Highlight: True
Find: Optional ByVal ErrorHandlerAddress As {type:1}
Replace: ucErrorHandlerDelegate ErrorHandlerAddress = null

Criteria: 33
Highlight: True
Find: Optional ByVal FunctionAddress As {type:1}
Replace: ucFunctionDelegate FuncAddress = null

Criteria: 34
Highlight: True
Find: Optional ByVal VarAddress As {type:1}
Replace: {@Eval: IIF(SEND=="x64", "Int64 VarAddress = 0", "int VarAddress = 0")}

Criteria: 35
Highlight: True
Find: DLL.Import[{e: , EntryPoint={q}{name}{q}}]
Replace: [DllImport(uCalcDLL{e})] public static extern

Criteria: 36
Selected: True
Highlight: True
PassOnce: False
Find: DLL.Import[{{e: , EntryPoint={q}{name}{q}}|{ne: }}] {type:1} {func}({args: {etc1} ref string{a:" "}{etc2}});
Replace: [DllImport(uCalcDLL{e}{ne:, EntryPoint="{func}"})] public static extern {type} {func}_({@Eval: Remove('{args}', '={opt:1}', ucQuote)});
         public static {type} {func}({@Eval: Remove('{args}', '"["{marshal}"]" ref')}) {
            {@Eval:IIf('{type}'<>'void', 'return')} {func}_({@Eval: Remove(Replace('{args}', '"["{marshal}"]" ref string', 'ref'), '{ UInt32|int|={x:1}|ucCheckForStop|ucFunctionDelegate|Int64 }', ucQuote)});
         }

Criteria: 37
Highlight: True
Find: DLL.Import[{{e: , EntryPoint={q}{name}{q}}|{ne: }}] string {func}({args});
Replace: [DllImport(uCalcDLL{e}{ne:, EntryPoint="{func}"})] public static extern void {func}_({@Eval:StringMarshal} ReturnStr, {@Eval: Remove('{args}', '={x:1}', ucQuote)});
         public static string {func}({@Eval: Remove('{args}', '"["{marshal}"]" ref')}) {
            string ReturnStr = "";
            {func}_(ref ReturnStr, {@Eval: Remove(Replace('{args}', '"["{marshal}"]" ref string', 'ref'), '{ UInt32|int|={x:1} }', ucQuote)});
            if(ReturnStr==null) {return "";} else return ReturnStr;
         }

# End Search