# DLLFunctionList.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.8 on 1/16/2014 11:55:57 AM
# Comment: Creates list of constants, and also functions exported by FMP DLL

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Creates list of constants, and also functions exported by FMP DLL
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Interface.Bas
OutputFile: Exports.txt
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Transforms Interface.Bas code to uCalcPB.Bas (listing constants and exported routines).
Pass: 1

Criteria: 2
Selected: True
BackColor: Tomato
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
BackColor: Orange
Find: @CompilerName
Replace: Other compilers

Criteria: 4
BackColor: DeepSkyBlue
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 5
BackColor: DarkKhaki
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 6
BackColor: Yellow
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 7
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 8
BackColor: Lime
Find: ' Interface.Bas {etc}
Replace: ' {@Eval:OutputFile}: Routines from uCalc Fast Math Parser {@Eval:Version} ({@Eval:DLLFile})
         ' Also includes : List of uCalc Fast Math Parser {@Eval:Version} constants

Criteria: 9
BackColor: Red
Find: ' VB.NET: {code:".*"}
Replace: {Nothing}

Criteria: 10
BackColor: Brown
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 11
BackColor: RoyalBlue
Find: ' Deprecated notations
      {etc:"[\x00-\xFF]+"}
Replace: {Nothing}

Criteria: 12
BackColor: Pink
Find: Function {name:1} {etc} As {type:1}
        {body~+}
      End Function
Replace: Function {name} {etc} As {type}

Criteria: 13
Find: Sub {name:1} {etc}{nl}
        {body~+}
      End Sub
Replace: Sub {name} {etc}

Criteria: 14
BackColor: SlateBlue
Find: ' {routine: Sub | Function}
Replace: {routine}

Criteria: 15
BackColor: Purple
Find: ' Legacy: {Func}({x} As {typeA} [,{y} As {typeB}]) As {type:1}
Replace: Macro {Func}({x}{y:, {y}})

Criteria: 16
BackColor: Khaki
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 17
Comment: Removes extraneous whitespace, processes optional parameters, etc.
Pass: 2

Criteria: 18
BackColor: CornflowerBlue
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 19
BackColor: Gold
PassOnce: False
Find: {nl}[{nl}]{routine: Sub | Function} {name} Alias {q}{alias}{q}{etc}
Replace: {nl}{routine} {alias}{etc}

Criteria: 20
Find: ) Export
Replace: )

Criteria: 21
Find: %
Replace: {Nothing}

Criteria: 22
Find: Optional ByVal {arg:1} As {type:1}
Replace: Optional ByVal {arg} As {type} = 0

Criteria: 23
Find: Optional ByRef {arg:1} As String
Replace: Optional ByVal {arg} As String = ""

Criteria: 24
PassOnce: False
Find: Optional {by: ByVal | ByRef} {arg:1} As {type:1}, {by2: ByVal | ByRef}
Replace: Optional {by} {arg} As {type}, Optional {by2}

# End Search