# VisualCPP_MFC.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.95 on 3/10/2014 4:47:21 PM
# Comment: Transforms uCalc interface file to VC++ include file (uCalcVC.h)

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Transforms uCalc interface file to VC++ include file (uCalcVC.h)
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: 
OutputFile: uCalcVC_MFC.h
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Customize header comments and prepare function declarations
Pass: 1

Criteria: 2
Selected: True
Highlight: True
BackColor: DodgerBlue
Find: $Version = {value}{nl}
Replace: {@Define:
            Var: Version = {value}
            Var: DLLFile = "uCalc32v"+Remove({value}, ".", ucChar)+".dll"
            Exec: IIF(SEND=="x64", DLLFile=Replace(DLLFile, "32v", "64v", ucChar))
            Exec: OutputFile = ShortName(OutputFile)+SEND+Ext(OutputFile)
         }

Criteria: 3
Highlight: True
BackColor: Tomato
Find: @CompilerTransformFile
Replace: {@Eval:ShortName(TransformFile)}.uc

Criteria: 4
Highlight: True
BackColor: Orange
Find: @AppName
Replace: {@Eval:AppName}

Criteria: 5
Highlight: True
BackColor: DeepSkyBlue
Find: @DateTime
Replace: {@Eval:TimeStamp("MM/dd/yy")}

Criteria: 6
Highlight: True
BackColor: DarkKhaki
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval:FileText("{file}")}

Criteria: 7
Highlight: True
BackColor: Yellow
Find: '
Replace: //

Criteria: 8
Highlight: True
BackColor: Lime
Find: ' Main Functions
Replace: // Main Functions
         
         int ucInit = 0;
         int uCalcInit();
         // typedef
         
         // extern
         

Criteria: 9
Highlight: True
BackColor: Red
Find: ' Interface.Bas {etc}
Replace: // {@Eval:OutputFile}: VC++ Native include file for uCalc Fast Math Parser {@Eval:Version}

Criteria: 10
Highlight: True
BackColor: Brown
Find: ' Designed for : {etc}
Replace: // Designed for : Visual C++ 2010 & 2012 - Native / No CLR (unmanaged)
         //                Requires MFC
         //                Works with both Unicode and Multi-Byte character set
         //                Add the following line to your code:
         //                #include "uCalcVC_MFC.h" in your code.

Criteria: 11
Highlight: True
BackColor: RoyalBlue
Find: #If {etc:".*"}
        {lines~+}
      #EndIf
Replace: {Nothing}

Criteria: 12
Highlight: True
BackColor: Pink
Find: ' VB.NET: {etc}
Replace: {Nothing}

Criteria: 13
Highlight: True
BackColor: SlateBlue
Find: ' VB.NET: Public Module uCalcVBNET
Replace: #pragma once
         #include <windows.h>
         #include <oleauto.h>
         #include <wtypes.h>
         #include <atlstr.h>{nl}

Criteria: 14
Highlight: True
BackColor: Purple
Find: %{const} = {value} [' {comment}]
Replace: const int {const} = {value};

Criteria: 15
Highlight: True
BackColor: Khaki
Find: ' VB.NET: End Module
Replace: int uCalcInit()
            static HINSTANCE hDLL;
         #ifdef UNICODE
            hDLL = LoadLibrary(_T("{@Eval:DLLFile}"));
         #else
            hDLL = LoadLibraryA("{@Eval:DLLFile}");
         #endif
            
            if (hDLL == NULL) return 0;
            ucInit = 1;   
            return 1;

Criteria: 16
Highlight: True
BackColor: Green
PassOnce: False
Find: Function {name} Alias {q}{alias}{q} {args} Export As {type:1}
        {body~+}
      End Function
Replace: def: {type}, {alias}, {alias}, {args}

Criteria: 17
Highlight: True
BackColor: SandyBrown
Find: Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
        {body~+}
      End Sub
Replace: def: void, {alias}, {alias}, (ByRef ReturnStr As String, {args})

Criteria: 18
Highlight: True
BackColor: Violet
Find: ' Function {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: def: {type}, {alias}, {alias}, {args}

Criteria: 19
Highlight: True
BackColor: YellowGreen
Find: ' Function {uCalc2 | uCalc3} {etc}
Replace: {Nothing}

Criteria: 20
Highlight: True
BackColor: CornflowerBlue
Find: ' Deprecated {name} Alias {q}{alias}{q} {args} Export As {type}
Replace: // {Self}

Criteria: 21
Highlight: True
BackColor: Gold
Find: ' Sub {name} Alias {q}{alias}{q} {args} Export
Replace: def: void, {alias}, {alias}, {args}

Criteria: 22
Highlight: True
BackColor: Gold
Find: ' Sub{" "}{name:"uc(SetVariableValue|Return)"}Dbl Alias {q}{alias}{q} {args} Export
Replace: def: void, {name}, {alias}, {args}

Criteria: 23
Highlight: True
Find: ' Sub {ucSetVariableValueExt | ucReturnExt} {etc}
Replace: {Nothing}

Criteria: 24
Highlight: True
Find: ' Sub {name:1} Alias {q}{alias}{q} (ByRef ReturnStr As String [, {args}]) Export
Replace: def: void, {alias}, {alias}, (ByRef ReturnStr As String, {args})

Criteria: 25
Comment: Takes care of args
Pass: 2

Criteria: 26
Highlight: True
Find: { Extended | Double }
Replace: double

Criteria: 27
Highlight: True
Find: Dword
Replace: DWORD

Criteria: 28
Highlight: True
Find: { Long | Integer }
Replace: int

Criteria: 29
Highlight: True
Find: [{optional: Optional}] ByVal {arg} As {type%:1}
Replace: <{type}> {arg} {optional: = 0}

Criteria: 30
Highlight: True
Find: [{optional: Optional}] ByRef {arg} As String
Replace: <BSTR&> {arg} {optional: = TEXT("")}

Criteria: 31
Highlight: True
Find: Optional ByVal {item: ErrorHandlerAddress | FunctionAddress | VarAddress } As {type:1}
Replace: <void *>{item} = 0

Criteria: 32
Highlight: True
Find: // extern {other+} int uCalcInit()
      {code+}
Replace: {nl}int uCalcInit() {{code}}

Criteria: 33
Highlight: True
PassOnce: False
Find: // typedef
      {SomeCode+}
      // extern [{n+}]
      def: {type}, {name}, {alias}, ([{args}])
      {MoreCode+}
      return 1;
      
Replace: typedef {type} (CALLBACK* __{name})({args}); extern __{name} _{name}_; __{name} _{name}_;
         // typedef
         {SomeCode}{type} {name}({args}) {
            if(ucInit==0) uCalcInit();
            {@Eval: IIf("{type}"<>"void", "return ")}_{name}_({args});{@Eval:
                    IIf(InStr('{args}', 'ReturnStr'), Chr(10)+'   CStringA ReturnStr = (LPCSTR)ReturnStr_;')}
         }
         
         // extern
         {MoreCode}
            _{name}_ = (__{name})GetProcAddress(hDLL, "{alias}");
            return 1;

Criteria: 34
Comment: 
Pass: 3

Criteria: 35
Highlight: True
SkipOver: True
Find: { #include {etc} | [return] {"_"}{func}({result}); }
Replace: [Skip over]

Criteria: 36
Highlight: True
Find: { < | > | // typedef }
Replace: {Nothing}

Criteria: 37
Comment: 
Pass: 4

Criteria: 38
Highlight: True
Find: = {value:1}
Replace: {Nothing}

Criteria: 39
Find: = TEXT({q}{q})
Replace: {Nothing}

Criteria: 40
Highlight: True
Find: <{type}>
Replace: {Nothing}

Criteria: 41
Highlight: True
Find: <BSTR&> {arg:1}
Replace: {arg}_

Criteria: 42
Highlight: True
SkipOver: True
Find: #pragma once {etc+} ucInit = 0;
Replace: [Skip over]

Criteria: 43
Highlight: True
SkipOver: True
Find: { { ReturnStr|hDLL|ucInit } =[=] | = ({ProcAddr}) | {"\n[^\n\x7B]+\x7B"} }
Replace: [Skip over]

Criteria: 44
Comment: 
Pass: 5

Criteria: 45
Highlight: True
SkipOver: True
Find: typedef {".*"}
Replace: [Skip over]

Criteria: 46
Highlight: True
PassOnce: False
Find: ([{etc}]BSTR& {arg:1} [{etc2}])  "{" {code+} "}"
Replace: ({etc} CString {arg} {etc2}) {
            BSTR {arg}_ = SysAllocStringByteLen((CStringA){arg}, {arg}.GetLength());
         {code}
            SysFreeString({arg}_);
         }

Criteria: 47
Highlight: True
Find: (CStringA)ReturnStr, ReturnStr.GetLength()
Replace: NULL, 1

Criteria: 48
Comment: Reformat the text appearance a bit
Pass: 6

Criteria: 49
Highlight: True
Find: ;{nl}{nl}{sp}
Replace: ;{nl}{#32#32#32}

Criteria: 50
Highlight: True
Find: [{sp}],  {arg:1}
Replace: , {arg}

Criteria: 51
Highlight: True
PassOnce: False
Find: {nl}{nl}{nl}
Replace: {nl}{nl}

Criteria: 52
Comment: 
Pass: 7

Criteria: 53
Highlight: True
Find: {nl}{type:1} {func}({args}) "{" {nl}BSTR {code+} return {code2+} "}"
Replace: {nl}{type} {func}({args}) {
            BSTR {code}   {type} RetVal = {code2}   return RetVal;{nl}}

Criteria: 54
Highlight: True
Find: {nl}void {func}(CString ReturnStr, {args}) "{" {code+} "}"
Replace: {nl}CString {func}({args}) { {code}   return (CString)ReturnStr;{nl}}

# End Search